/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.DatabaseOperationException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.dynabean.SqlDynaClass;
import org.apache.ddlutils.io.DataSink;
import org.apache.ddlutils.io.DataSinkException;
import org.apache.ddlutils.io.Identity;
import org.apache.ddlutils.io.WaitingObject;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Reference;
import org.apache.ddlutils.model.Table;

public class DataToDatabaseSink
implements DataSink {
    private final Log _log = LogFactory.getLog((Class)(class$org$apache$ddlutils$io$DataToDatabaseSink == null ? (class$org$apache$ddlutils$io$DataToDatabaseSink = DataToDatabaseSink.class$("org.apache.ddlutils.io.DataToDatabaseSink")) : class$org$apache$ddlutils$io$DataToDatabaseSink));
    private Platform _platform;
    private Database _model;
    private Connection _connection;
    private boolean _haltOnErrors = true;
    private boolean _ensureFkOrder = true;
    private boolean _useBatchMode = false;
    private ArrayList _batchQueue = new ArrayList();
    private int _batchSize = 1024;
    private HashSet _fkTables = new HashSet();
    private HashSet _tablesWithSelfIdentityReference = new HashSet();
    private HashSet _tablesWithRequiredSelfReference = new HashSet();
    private HashMap _identityMap = new HashMap();
    private ArrayList _waitingObjects = new ArrayList();
    static /* synthetic */ Class class$org$apache$ddlutils$io$DataToDatabaseSink;

    public DataToDatabaseSink(Platform platform, Database model) {
        this._platform = platform;
        this._model = model;
        block0: for (int tableIdx = 0; tableIdx < model.getTableCount(); ++tableIdx) {
            int idx;
            Table table = model.getTable(tableIdx);
            ForeignKey selfRefFk = table.getSelfReferencingForeignKey();
            if (selfRefFk == null) continue;
            Column[] pkColumns = table.getPrimaryKeyColumns();
            for (idx = 0; idx < pkColumns.length; ++idx) {
                if (!pkColumns[idx].isAutoIncrement()) continue;
                this._tablesWithSelfIdentityReference.add(table);
                break;
            }
            for (idx = 0; idx < selfRefFk.getReferenceCount(); ++idx) {
                if (!selfRefFk.getReference(idx).getLocalColumn().isRequired()) continue;
                this._tablesWithRequiredSelfReference.add(table);
                continue block0;
            }
        }
    }

    public boolean isHaltOnErrors() {
        return this._haltOnErrors;
    }

    public void setHaltOnErrors(boolean haltOnErrors) {
        this._haltOnErrors = haltOnErrors;
    }

    public boolean isEnsureFkOrder() {
        return this._ensureFkOrder;
    }

    public void setEnsureForeignKeyOrder(boolean ensureFkOrder) {
        this._ensureFkOrder = ensureFkOrder;
    }

    public boolean isUseBatchMode() {
        return this._useBatchMode;
    }

    public void setUseBatchMode(boolean useBatchMode) {
        this._useBatchMode = useBatchMode;
    }

    public int getBatchSize() {
        return this._batchSize;
    }

    public void setBatchSize(int batchSize) {
        this._batchSize = batchSize;
    }

    public void end() throws DataSinkException {
        this.purgeBatchQueue();
        try {
            this._connection.close();
        }
        catch (SQLException ex) {
            throw new DataSinkException(ex);
        }
        if (!this._waitingObjects.isEmpty()) {
            if (this._log.isDebugEnabled()) {
                Iterator it = this._waitingObjects.iterator();
                while (it.hasNext()) {
                    WaitingObject obj = (WaitingObject)it.next();
                    Table table = this._model.getDynaClassFor(obj.getObject()).getTable();
                    Identity objId = this.buildIdentityFromPKs(table, obj.getObject());
                    this._log.debug((Object)("Row " + objId + " is still not written because it depends on these yet unwritten rows"));
                    Iterator fkIt = obj.getPendingFKs();
                    while (fkIt.hasNext()) {
                        Identity pendingFkId = (Identity)fkIt.next();
                        this._log.debug((Object)("  " + pendingFkId));
                    }
                }
            }
            if (this._waitingObjects.size() == 1) {
                throw new DataSinkException("There is one row still not written because of missing referenced rows");
            }
            throw new DataSinkException("There are " + this._waitingObjects.size() + " rows still not written because of missing referenced rows");
        }
    }

    public void start() throws DataSinkException {
        this._fkTables.clear();
        this._waitingObjects.clear();
        if (this._ensureFkOrder) {
            for (int tableIdx = 0; tableIdx < this._model.getTableCount(); ++tableIdx) {
                Table table = this._model.getTable(tableIdx);
                for (int fkIdx = 0; fkIdx < table.getForeignKeyCount(); ++fkIdx) {
                    ForeignKey curFk = table.getForeignKey(fkIdx);
                    this._fkTables.add(curFk.getForeignTable());
                }
            }
        }
        try {
            this._connection = this._platform.borrowConnection();
        }
        catch (DatabaseOperationException ex) {
            throw new DataSinkException((Throwable)((Object)ex));
        }
    }

    public void addBean(DynaBean bean) throws DataSinkException {
        Table table = this._model.getDynaClassFor(bean).getTable();
        Identity origIdentity = this.buildIdentityFromPKs(table, bean);
        if (this._ensureFkOrder && table.getForeignKeyCount() > 0) {
            WaitingObject waitingObj = new WaitingObject(bean, origIdentity);
            for (int idx = 0; idx < table.getForeignKeyCount(); ++idx) {
                ForeignKey fk = table.getForeignKey(idx);
                Identity fkIdentity = this.buildIdentityFromFK(table, fk, bean);
                if (fkIdentity == null || fkIdentity.equals(origIdentity)) continue;
                Identity processedIdentity = (Identity)this._identityMap.get(fkIdentity);
                if (processedIdentity != null) {
                    this.updateFKColumns(bean, fkIdentity.getForeignKeyName(), processedIdentity);
                    continue;
                }
                waitingObj.addPendingFK(fkIdentity);
            }
            if (waitingObj.hasPendingFKs()) {
                if (this._log.isDebugEnabled()) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("Defering insertion of row ");
                    msg.append(this.buildIdentityFromPKs(table, bean).toString());
                    msg.append(" because it is waiting for:");
                    Iterator it = waitingObj.getPendingFKs();
                    while (it.hasNext()) {
                        msg.append("\n  ");
                        msg.append(it.next().toString());
                    }
                    this._log.debug((Object)msg.toString());
                }
                this._waitingObjects.add(waitingObj);
                return;
            }
        }
        this.insertBeanIntoDatabase(table, bean);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Inserted bean " + origIdentity));
        }
        if (this._ensureFkOrder && this._fkTables.contains(table)) {
            Identity newIdentity = this.buildIdentityFromPKs(table, bean);
            ArrayList<DynaBean> finishedObjs = new ArrayList<DynaBean>();
            this._identityMap.put(origIdentity, newIdentity);
            ArrayList<Identity> identitiesToCheck = new ArrayList<Identity>();
            identitiesToCheck.add(origIdentity);
            while (!identitiesToCheck.isEmpty() && !this._waitingObjects.isEmpty()) {
                Identity curIdentity = (Identity)identitiesToCheck.get(0);
                Identity curNewIdentity = (Identity)this._identityMap.get(curIdentity);
                identitiesToCheck.remove(0);
                finishedObjs.clear();
                Iterator waitingObjIt = this._waitingObjects.iterator();
                while (waitingObjIt.hasNext()) {
                    WaitingObject waitingObj = (WaitingObject)waitingObjIt.next();
                    Identity fkIdentity = waitingObj.removePendingFK(curIdentity);
                    if (fkIdentity != null) {
                        this.updateFKColumns(waitingObj.getObject(), fkIdentity.getForeignKeyName(), curNewIdentity);
                    }
                    if (waitingObj.hasPendingFKs()) continue;
                    waitingObjIt.remove();
                    finishedObjs.add(waitingObj.getObject());
                }
                Iterator finishedObjIt = finishedObjs.iterator();
                while (finishedObjIt.hasNext()) {
                    DynaBean finishedObj = (DynaBean)finishedObjIt.next();
                    Table tableForObj = this._model.getDynaClassFor(finishedObj).getTable();
                    Identity objIdentity = this.buildIdentityFromPKs(tableForObj, finishedObj);
                    this.insertBeanIntoDatabase(tableForObj, finishedObj);
                    Identity newObjIdentity = this.buildIdentityFromPKs(tableForObj, finishedObj);
                    this._identityMap.put(objIdentity, newObjIdentity);
                    identitiesToCheck.add(objIdentity);
                    if (!this._log.isDebugEnabled()) continue;
                    this._log.debug((Object)("Inserted deferred row " + objIdentity));
                }
            }
        }
    }

    private void insertBeanIntoDatabase(Table table, DynaBean bean) throws DataSinkException {
        if (this._useBatchMode) {
            this._batchQueue.add(bean);
            if (this._batchQueue.size() >= this._batchSize) {
                this.purgeBatchQueue();
            }
        } else {
            this.insertSingleBeanIntoDatabase(table, bean);
        }
    }

    private void purgeBatchQueue() throws DataSinkException {
        if (!this._batchQueue.isEmpty()) {
            try {
                this._platform.insert(this._connection, this._model, this._batchQueue);
                if (!this._connection.getAutoCommit()) {
                    this._connection.commit();
                }
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Inserted " + this._batchQueue.size() + " rows in batch mode "));
                }
            }
            catch (Exception ex) {
                if (this._haltOnErrors) {
                    this._platform.returnConnection(this._connection);
                    throw new DataSinkException(ex);
                }
                this._log.warn((Object)("Exception while inserting " + this._batchQueue.size() + " rows via batch mode into the database"), (Throwable)ex);
            }
            this._batchQueue.clear();
        }
    }

    private void insertSingleBeanIntoDatabase(Table table, DynaBean bean) throws DataSinkException {
        try {
            boolean needTwoStepInsert = false;
            ForeignKey selfRefFk = null;
            if (!this._platform.isIdentityOverrideOn() && this._tablesWithSelfIdentityReference.contains(table)) {
                Identity fkIdentity;
                selfRefFk = table.getSelfReferencingForeignKey();
                Identity pkIdentity = this.buildIdentityFromPKs(table, bean);
                if (pkIdentity.equals(fkIdentity = this.buildIdentityFromFK(table, selfRefFk, bean))) {
                    if (this._tablesWithRequiredSelfReference.contains(table)) {
                        throw new DataSinkException("Can only insert rows with fk pointing to themselves when all fk columns can be NULL (row pk is " + pkIdentity + ")");
                    }
                    needTwoStepInsert = true;
                }
            }
            if (needTwoStepInsert) {
                int idx;
                ArrayList<Object> fkValues = new ArrayList<Object>();
                for (idx = 0; idx < selfRefFk.getReferenceCount(); ++idx) {
                    String columnName = selfRefFk.getReference(idx).getLocalColumnName();
                    fkValues.add(bean.get(columnName));
                    bean.set(columnName, null);
                }
                this._platform.insert(this._connection, this._model, bean);
                for (idx = 0; idx < selfRefFk.getReferenceCount(); ++idx) {
                    bean.set(selfRefFk.getReference(idx).getLocalColumnName(), fkValues.get(idx));
                }
                this._platform.update(this._connection, this._model, bean);
            } else {
                this._platform.insert(this._connection, this._model, bean);
            }
            if (!this._connection.getAutoCommit()) {
                this._connection.commit();
            }
        }
        catch (Exception ex) {
            if (this._haltOnErrors) {
                this._platform.returnConnection(this._connection);
                throw new DataSinkException(ex);
            }
            this._log.warn((Object)"Exception while inserting a row into the database", (Throwable)ex);
        }
    }

    private String getFKName(Table owningTable, ForeignKey fk) {
        int idx;
        if (fk.getName() != null && fk.getName().length() > 0) {
            return fk.getName();
        }
        StringBuffer result = new StringBuffer();
        result.append(owningTable.getName());
        result.append("[");
        for (idx = 0; idx < fk.getReferenceCount(); ++idx) {
            if (idx > 0) {
                result.append(",");
            }
            result.append(fk.getReference(idx).getLocalColumnName());
        }
        result.append("]->");
        result.append(fk.getForeignTableName());
        result.append("[");
        for (idx = 0; idx < fk.getReferenceCount(); ++idx) {
            if (idx > 0) {
                result.append(",");
            }
            result.append(fk.getReference(idx).getForeignColumnName());
        }
        result.append("]");
        return result.toString();
    }

    private Identity buildIdentityFromPKs(Table table, DynaBean bean) {
        Identity identity = new Identity(table);
        Column[] pkColumns = table.getPrimaryKeyColumns();
        for (int idx = 0; idx < pkColumns.length; ++idx) {
            identity.setColumnValue(pkColumns[idx].getName(), bean.get(pkColumns[idx].getName()));
        }
        return identity;
    }

    private Identity buildIdentityFromFK(Table owningTable, ForeignKey fk, DynaBean bean) {
        Identity identity = new Identity(fk.getForeignTable(), this.getFKName(owningTable, fk));
        for (int idx = 0; idx < fk.getReferenceCount(); ++idx) {
            Reference reference = fk.getReference(idx);
            Object value = bean.get(reference.getLocalColumnName());
            if (value == null) {
                return null;
            }
            identity.setColumnValue(reference.getForeignColumnName(), value);
        }
        return identity;
    }

    private void updateFKColumns(DynaBean bean, String fkName, Identity identity) {
        int idx;
        Table sourceTable = ((SqlDynaClass)bean.getDynaClass()).getTable();
        Table targetTable = identity.getTable();
        ForeignKey fk = null;
        for (idx = 0; idx < sourceTable.getForeignKeyCount(); ++idx) {
            ForeignKey curFk = sourceTable.getForeignKey(idx);
            if (!curFk.getForeignTableName().equalsIgnoreCase(targetTable.getName()) || !fkName.equals(this.getFKName(sourceTable, curFk))) continue;
            fk = curFk;
            break;
        }
        if (fk != null) {
            for (idx = 0; idx < fk.getReferenceCount(); ++idx) {
                Reference curRef = fk.getReference(idx);
                Column sourceColumn = curRef.getLocalColumn();
                Column targetColumn = curRef.getForeignColumn();
                bean.set(sourceColumn.getName(), identity.getColumnValue(targetColumn.getName()));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

