/*
 *  This file is part of X-File Manager XFM
 *  ----------------------------------------------------------------------
  suffix.c

  (c) 2005,2006 Bernhard R. Link

  fast fallback suffix finding code
 *  ----------------------------------------------------------------------
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <xfmconfig.h>

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <string.h>
#include <fcntl.h>
#include <stdbool.h>
#include "mime.h"
#include "suffix.h"

struct suffix {
	struct suffix *smaller,*larger;
	char *data;
	struct mime_filetype *type;
} *suffixes[7] = {NULL, NULL, NULL, NULL, NULL, NULL, NULL};

const char *suffix_search(const char *name,struct mime_filetype **typep) {
	size_t len = strlen(name);
	int i;
	struct suffix *s;

	i = 6;
	/* make sure the name is long enough to hold this with
	 * the dot not the first character */
	if( len < (size_t)i+3 )
		i = len-3;
	/* then search for this extension */
	for( ; i >= 0 ; i-- ) {
		if( name[len-i-2] != '.' )
			continue;
		s = suffixes[i];
		while( s != NULL ) {
			int c = memcmp(s->data,name+len-i-1,i+1);
			if( c == 0 ) {
				*typep = s->type;
				return s->type->fulltypename;
			}
			if( c < 0 )
				s = s->smaller;
			else
				s = s->larger;
		}
	}
	return NULL;
}

bool suffix_add(const char *suffix,size_t len, struct mime_filetype *type) {
	struct suffix **s;
	struct suffix *n;

	if( len <= 0 || len > sizeof(suffixes)/sizeof(suffixes[0]) )
		return false;
	s = &suffixes[len-1];
	while( *s != NULL ) {
		int c = memcmp((*s)->data,suffix,len);
		if( c == 0 )
			return false;
		if( c < 0 )
			s = &(*s)->smaller;
		else
			s = &(*s)->larger;
	};
	n = malloc(sizeof(struct suffix));
	if( n == NULL )
		return false;
	n->data = malloc(len);
	if( n->data == NULL ) {
		free(n);
		return false;
	}
	memcpy(n->data,suffix,len);
	n->type = type;
	n->smaller = NULL;
	n->larger = NULL;
	*s = n;
	return true;
}
