/* hypertextview.c generated by valac 0.56.4, the Vala compiler
 * generated from hypertextview.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2009-2010  Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "libnotes.h"
#include <gdk/gdk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <pango/pango.h>
#include <gio/gio.h>

enum  {
	XNP_HYPERTEXT_VIEW_0_PROPERTY,
	XNP_HYPERTEXT_VIEW_FONT_PROPERTY,
	XNP_HYPERTEXT_VIEW_NUM_PROPERTIES
};
static GParamSpec* xnp_hypertext_view_properties[XNP_HYPERTEXT_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define __vala_PangoTabArray_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoTabArray_free (var), NULL)))

struct _XnpHypertextViewPrivate {
	GdkCursor* hand_cursor;
	GdkCursor* regular_cursor;
	gboolean cursor_over_link;
	guint undo_timeout;
	gint undo_cursor_pos;
	gchar* undo_text;
	gchar* redo_text;
	guint tag_timeout;
	GtkTextTag* tag_link;
	gchar* _font;
};

static gint XnpHypertextView_private_offset;
static gpointer xnp_hypertext_view_parent_class = NULL;

static gboolean xnp_hypertext_view_button_release_event_cb (XnpHypertextView* self,
                                                     GtkWidget* hypertextview,
                                                     GdkEventButton* event);
static gboolean _xnp_hypertext_view_button_release_event_cb_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                      GdkEventButton* event,
                                                                                      gpointer self);
static gboolean xnp_hypertext_view_motion_notify_event_cb (XnpHypertextView* self,
                                                    GtkWidget* hypertextview,
                                                    GdkEventMotion* event);
static gboolean _xnp_hypertext_view_motion_notify_event_cb_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                                    GdkEventMotion* event,
                                                                                    gpointer self);
static void xnp_hypertext_view_move_cursor_cb (XnpHypertextView* self,
                                        GtkWidget* hypertextview,
                                        GtkMovementStep step,
                                        gint count,
                                        gboolean extend_selection);
static void _xnp_hypertext_view_move_cursor_cb_gtk_text_view_move_cursor (GtkTextView* _sender,
                                                                   GtkMovementStep step,
                                                                   gint count,
                                                                   gboolean extend_selection,
                                                                   gpointer self);
static void xnp_hypertext_view_buffer_changed_cb (XnpHypertextView* self);
static void _xnp_hypertext_view_buffer_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                                    gpointer self);
static void xnp_hypertext_view_insert_text_cb (XnpHypertextView* self,
                                        GtkTextBuffer* buffer,
                                        GtkTextIter* location,
                                        const gchar* text,
                                        gint len);
static void _xnp_hypertext_view_insert_text_cb_gtk_text_buffer_insert_text (GtkTextBuffer* _sender,
                                                                     GtkTextIter* pos,
                                                                     const gchar* new_text,
                                                                     gint new_text_length,
                                                                     gpointer self);
static void xnp_hypertext_view_delete_range_cb (XnpHypertextView* self,
                                         GtkTextBuffer* buffer,
                                         GtkTextIter* start,
                                         GtkTextIter* end);
static void _xnp_hypertext_view_delete_range_cb_gtk_text_buffer_delete_range (GtkTextBuffer* _sender,
                                                                       GtkTextIter* start,
                                                                       GtkTextIter* end,
                                                                       gpointer self);
static gboolean xnp_hypertext_view_undo_snapshot (XnpHypertextView* self);
static gboolean _xnp_hypertext_view_undo_snapshot_gsource_func (gpointer self);
static gboolean xnp_hypertext_view_tag_timeout_cb (XnpHypertextView* self);
static gboolean _xnp_hypertext_view_tag_timeout_cb_gsource_func (gpointer self);
static void xnp_hypertext_view_tag_timeout_init (XnpHypertextView* self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static GObject * xnp_hypertext_view_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void _vala_PangoTabArray_free (PangoTabArray* self);
static void xnp_hypertext_view_finalize (GObject * obj);
static GType xnp_hypertext_view_get_type_once (void);
static void _vala_xnp_hypertext_view_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_xnp_hypertext_view_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
xnp_hypertext_view_get_instance_private (XnpHypertextView* self)
{
	return G_STRUCT_MEMBER_P (self, XnpHypertextView_private_offset);
}

static gboolean
_xnp_hypertext_view_button_release_event_cb_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                             GdkEventButton* event,
                                                                             gpointer self)
{
	gboolean result;
	result = xnp_hypertext_view_button_release_event_cb ((XnpHypertextView*) self, _sender, event);
	return result;
}

static gboolean
_xnp_hypertext_view_motion_notify_event_cb_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                           GdkEventMotion* event,
                                                                           gpointer self)
{
	gboolean result;
	result = xnp_hypertext_view_motion_notify_event_cb ((XnpHypertextView*) self, _sender, event);
	return result;
}

static void
_xnp_hypertext_view_move_cursor_cb_gtk_text_view_move_cursor (GtkTextView* _sender,
                                                              GtkMovementStep step,
                                                              gint count,
                                                              gboolean extend_selection,
                                                              gpointer self)
{
	xnp_hypertext_view_move_cursor_cb ((XnpHypertextView*) self, _sender, step, count, extend_selection);
}

static void
_xnp_hypertext_view_buffer_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                               gpointer self)
{
	xnp_hypertext_view_buffer_changed_cb ((XnpHypertextView*) self);
}

static void
_xnp_hypertext_view_insert_text_cb_gtk_text_buffer_insert_text (GtkTextBuffer* _sender,
                                                                GtkTextIter* pos,
                                                                const gchar* new_text,
                                                                gint new_text_length,
                                                                gpointer self)
{
	xnp_hypertext_view_insert_text_cb ((XnpHypertextView*) self, _sender, pos, new_text, new_text_length);
}

static void
_xnp_hypertext_view_delete_range_cb_gtk_text_buffer_delete_range (GtkTextBuffer* _sender,
                                                                  GtkTextIter* start,
                                                                  GtkTextIter* end,
                                                                  gpointer self)
{
	xnp_hypertext_view_delete_range_cb ((XnpHypertextView*) self, _sender, start, end);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

XnpHypertextView*
xnp_hypertext_view_construct (GType object_type)
{
	XnpHypertextView * self = NULL;
	GtkTextIter iter = {0};
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	GtkTextIter _tmp8_ = {0};
	GtkTextBuffer* _tmp9_;
	GtkTextBuffer* _tmp10_;
	GtkTextIter _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkTextBuffer* _tmp13_;
	GtkTextTag* _tmp14_;
	GtkTextTag* _tmp15_;
	self = (XnpHypertextView*) g_object_new (object_type, NULL);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _xnp_hypertext_view_button_release_event_cb_gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) _xnp_hypertext_view_motion_notify_event_cb_gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object ((GtkTextView*) self, "move-cursor", (GCallback) _xnp_hypertext_view_move_cursor_cb_gtk_text_view_move_cursor, self, 0);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) _xnp_hypertext_view_buffer_changed_cb_gtk_text_buffer_changed, self, 0);
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp3_ = _tmp2_;
	g_signal_connect_object (_tmp3_, "insert-text", (GCallback) _xnp_hypertext_view_insert_text_cb_gtk_text_buffer_insert_text, self, 0);
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	g_signal_connect_object (_tmp5_, "delete-range", (GCallback) _xnp_hypertext_view_delete_range_cb_gtk_text_buffer_delete_range, self, 0);
	_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp7_ = _tmp6_;
	gtk_text_buffer_get_iter_at_offset (_tmp7_, &_tmp8_, 0);
	iter = _tmp8_;
	_tmp9_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = iter;
	gtk_text_buffer_create_mark (_tmp10_, "undo-pos", &_tmp11_, FALSE);
	_tmp12_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = gtk_text_buffer_create_tag (_tmp13_, "link", "foreground", "blue", "underline", PANGO_UNDERLINE_SINGLE, NULL, NULL);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	_g_object_unref0 (self->priv->tag_link);
	self->priv->tag_link = _tmp15_;
	return self;
}

XnpHypertextView*
xnp_hypertext_view_new (void)
{
	return xnp_hypertext_view_construct (XNP_TYPE_HYPERTEXT_VIEW);
}

/**
 * button_release_event_cb:
 *
 * Event to open links.
 */
static gboolean
xnp_hypertext_view_button_release_event_cb (XnpHypertextView* self,
                                            GtkWidget* hypertextview,
                                            GdkEventButton* event)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter iter = {0};
	gchar* link = NULL;
	gint x = 0;
	gint y = 0;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkTextIter _tmp6_ = {0};
	GtkTextTag* _tmp7_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (hypertextview != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button != ((guint) 1)) {
		result = FALSE;
		_g_free0 (link);
		return result;
	}
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	gtk_text_buffer_get_selection_bounds (_tmp1_, &_tmp2_, &_tmp3_);
	start = _tmp2_;
	end = _tmp3_;
	if (gtk_text_iter_get_offset (&start) != gtk_text_iter_get_offset (&end)) {
		result = FALSE;
		_g_free0 (link);
		return result;
	}
	gtk_text_view_window_to_buffer_coords ((GtkTextView*) self, GTK_TEXT_WINDOW_WIDGET, (gint) event->x, (gint) event->y, &_tmp4_, &_tmp5_);
	x = _tmp4_;
	y = _tmp5_;
	gtk_text_view_get_iter_at_location ((GtkTextView*) self, &_tmp6_, x, y);
	iter = _tmp6_;
	_tmp7_ = self->priv->tag_link;
	if (gtk_text_iter_has_tag (&iter, _tmp7_)) {
		GtkTextIter _tmp8_;
		GtkTextIter _tmp9_;
		GtkTextTag* _tmp10_;
		GtkTextTag* _tmp12_;
		GtkTextIter _tmp13_;
		gchar* _tmp14_;
		_tmp8_ = iter;
		end = _tmp8_;
		_tmp9_ = end;
		start = _tmp9_;
		_tmp10_ = self->priv->tag_link;
		if (!gtk_text_iter_starts_tag (&start, _tmp10_)) {
			GtkTextTag* _tmp11_;
			_tmp11_ = self->priv->tag_link;
			gtk_text_iter_backward_to_tag_toggle (&start, _tmp11_);
		}
		_tmp12_ = self->priv->tag_link;
		gtk_text_iter_forward_to_tag_toggle (&end, _tmp12_);
		_tmp13_ = end;
		_tmp14_ = gtk_text_iter_get_text (&start, &_tmp13_);
		_g_free0 (link);
		link = _tmp14_;
		{
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp15_ = link;
			_tmp16_ = g_strconcat ("exo-open ", _tmp15_, NULL);
			_tmp17_ = _tmp16_;
			g_spawn_command_line_async (_tmp17_, &_inner_error0_);
			_g_free0 (_tmp17_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			result = FALSE;
			_g_free0 (link);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp18_ = FALSE;
			_g_free0 (link);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp18_;
		}
		{
			const gchar* _tmp19_;
			_tmp19_ = link;
			g_app_info_launch_default_for_uri (_tmp19_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			result = FALSE;
			_g_free0 (link);
			return result;
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp20_;
			const gchar* _tmp21_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp20_ = e;
			_tmp21_ = _tmp20_->message;
			g_message ("hypertextview.vala:127: Unable to open link with default handler: %s", _tmp21_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp22_ = FALSE;
			_g_free0 (link);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp22_;
		}
		{
			const gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp23_ = link;
			_tmp24_ = g_strconcat ("xdg-open ", _tmp23_, NULL);
			_tmp25_ = _tmp24_;
			g_spawn_command_line_async (_tmp25_, &_inner_error0_);
			_g_free0 (_tmp25_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
			result = FALSE;
			_g_free0 (link);
			return result;
		}
		goto __finally2;
		__catch2_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp26_ = FALSE;
			_g_free0 (link);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp26_;
		}
		{
			const gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp27_ = link;
			_tmp28_ = g_strconcat ("firefox ", _tmp27_, NULL);
			_tmp29_ = _tmp28_;
			g_spawn_command_line_async (_tmp29_, &_inner_error0_);
			_g_free0 (_tmp29_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch3_g_error;
			}
			result = FALSE;
			_g_free0 (link);
			return result;
		}
		goto __finally3;
		__catch3_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp30_ = FALSE;
			_g_free0 (link);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp30_;
		}
		g_message ("hypertextview.vala:142: Unable to find an appropriate fallback to open" \
" the link");
	}
	result = FALSE;
	_g_free0 (link);
	return result;
}

/**
 * motion_notify_event_cb:
 *
 * Event to update the cursor of the pointer.
 */
static gboolean
xnp_hypertext_view_motion_notify_event_cb (XnpHypertextView* self,
                                           GtkWidget* hypertextview,
                                           GdkEventMotion* event)
{
	GtkTextIter iter = {0};
	GdkWindow* win = NULL;
	gboolean over_link = FALSE;
	gint x = 0;
	gint y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkTextIter _tmp2_ = {0};
	GtkTextTag* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (hypertextview != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	gtk_text_view_window_to_buffer_coords ((GtkTextView*) self, GTK_TEXT_WINDOW_WIDGET, (gint) event->x, (gint) event->y, &_tmp0_, &_tmp1_);
	x = _tmp0_;
	y = _tmp1_;
	gtk_text_view_get_iter_at_location ((GtkTextView*) self, &_tmp2_, x, y);
	iter = _tmp2_;
	_tmp3_ = self->priv->tag_link;
	over_link = gtk_text_iter_has_tag (&iter, _tmp3_);
	if (over_link != self->priv->cursor_over_link) {
		GdkWindow* _tmp4_;
		GdkWindow* _tmp5_;
		GdkCursor* _tmp6_ = NULL;
		GdkWindow* _tmp9_;
		self->priv->cursor_over_link = over_link;
		_tmp4_ = gtk_text_view_get_window ((GtkTextView*) self, GTK_TEXT_WINDOW_TEXT);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (win);
		win = _tmp5_;
		if (over_link) {
			GdkCursor* _tmp7_;
			_tmp7_ = self->priv->hand_cursor;
			_tmp6_ = _tmp7_;
		} else {
			GdkCursor* _tmp8_;
			_tmp8_ = self->priv->regular_cursor;
			_tmp6_ = _tmp8_;
		}
		_tmp9_ = win;
		gdk_window_set_cursor (_tmp9_, _tmp6_);
	}
	result = FALSE;
	_g_object_unref0 (win);
	return result;
}

/**
 * move_cursor_cb:
 *
 * Destroys existing timeouts and executes the actions immediately.
 */
static void
xnp_hypertext_view_move_cursor_cb (XnpHypertextView* self,
                                   GtkWidget* hypertextview,
                                   GtkMovementStep step,
                                   gint count,
                                   gboolean extend_selection)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (hypertextview != NULL);
	if (self->priv->undo_timeout > ((guint) 0)) {
		GtkTextBuffer* _tmp0_;
		GtkTextBuffer* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		g_source_remove (self->priv->undo_timeout);
		self->priv->undo_timeout = (guint) 0;
		xnp_hypertext_view_undo_snapshot (self);
		_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp1_ = _tmp0_;
		g_object_get (_tmp1_, "cursor-position", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		self->priv->undo_cursor_pos = _tmp3_;
	}
	if (self->priv->tag_timeout > ((guint) 0)) {
		g_source_remove (self->priv->tag_timeout);
		self->priv->tag_timeout = (guint) 0;
		xnp_hypertext_view_update_tags (self);
	}
}

/**
 * buffer_changed_cb:
 *
 * Initializes timeouts to postpone actions.
 */
static gboolean
_xnp_hypertext_view_undo_snapshot_gsource_func (gpointer self)
{
	gboolean result;
	result = xnp_hypertext_view_undo_snapshot ((XnpHypertextView*) self);
	return result;
}

static gboolean
_xnp_hypertext_view_tag_timeout_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = xnp_hypertext_view_tag_timeout_cb ((XnpHypertextView*) self);
	return result;
}

static void
xnp_hypertext_view_buffer_changed_cb (XnpHypertextView* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->undo_timeout > ((guint) 0)) {
		g_source_remove (self->priv->undo_timeout);
		self->priv->undo_timeout = (guint) 0;
	}
	self->priv->undo_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, _xnp_hypertext_view_undo_snapshot_gsource_func, g_object_ref (self), g_object_unref);
	if (self->priv->tag_timeout > ((guint) 0)) {
		g_source_remove (self->priv->tag_timeout);
		self->priv->tag_timeout = (guint) 0;
		self->priv->tag_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, _xnp_hypertext_view_tag_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
	}
}

/**
 * insert_text_cb:
 *
 * Event to create and update existing tags within the buffer.
 */
static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
xnp_hypertext_view_insert_text_cb (XnpHypertextView* self,
                                   GtkTextBuffer* buffer,
                                   GtkTextIter* location,
                                   const gchar* text,
                                   gint len)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextTag* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buffer != NULL);
	g_return_if_fail (location != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->tag_link;
	if (gtk_text_iter_starts_tag (location, _tmp0_)) {
		gboolean _tmp1_ = FALSE;
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = strlen (text);
		_tmp3_ = _tmp2_;
		if (string_get (text, (glong) (_tmp3_ - 1)) != ' ') {
			gint _tmp4_;
			gint _tmp5_;
			_tmp4_ = strlen (text);
			_tmp5_ = _tmp4_;
			_tmp1_ = string_get (text, (glong) (_tmp5_ - 1)) != '\n';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			GtkTextIter _tmp6_;
			GtkTextIter _tmp7_;
			GtkTextTag* _tmp8_;
			GtkTextBuffer* _tmp9_;
			GtkTextBuffer* _tmp10_;
			GtkTextTag* _tmp11_;
			GtkTextIter _tmp12_;
			GtkTextIter _tmp13_;
			_tmp6_ = *location;
			start = _tmp6_;
			_tmp7_ = *location;
			end = _tmp7_;
			_tmp8_ = self->priv->tag_link;
			gtk_text_iter_forward_to_tag_toggle (&end, _tmp8_);
			_tmp9_ = gtk_text_view_get_buffer ((GtkTextView*) self);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->priv->tag_link;
			_tmp12_ = start;
			_tmp13_ = end;
			gtk_text_buffer_remove_tag (_tmp10_, _tmp11_, &_tmp12_, &_tmp13_);
		}
		xnp_hypertext_view_tag_timeout_init (self);
	} else {
		GtkTextTag* _tmp14_;
		_tmp14_ = self->priv->tag_link;
		if (gtk_text_iter_has_tag (location, _tmp14_)) {
			GtkTextIter _tmp15_;
			GtkTextTag* _tmp16_;
			GtkTextIter _tmp17_ = {0};
			_tmp15_ = *location;
			start = _tmp15_;
			_tmp16_ = self->priv->tag_link;
			gtk_text_iter_backward_to_tag_toggle (&start, _tmp16_);
			gtk_text_iter_forward_search (&start, "://", GTK_TEXT_SEARCH_TEXT_ONLY, NULL, &_tmp17_, NULL);
			end = _tmp17_;
			if (gtk_text_iter_get_offset (location) <= (gtk_text_iter_get_offset (&end) - 3)) {
				gboolean _tmp18_ = FALSE;
				if (string_contains (text, " ")) {
					_tmp18_ = TRUE;
				} else {
					_tmp18_ = string_contains (text, "\n");
				}
				if (_tmp18_) {
					GtkTextTag* _tmp19_;
					GtkTextBuffer* _tmp20_;
					GtkTextBuffer* _tmp21_;
					GtkTextTag* _tmp22_;
					GtkTextIter _tmp23_;
					GtkTextIter _tmp24_;
					_tmp19_ = self->priv->tag_link;
					gtk_text_iter_forward_to_tag_toggle (&end, _tmp19_);
					_tmp20_ = gtk_text_view_get_buffer ((GtkTextView*) self);
					_tmp21_ = _tmp20_;
					_tmp22_ = self->priv->tag_link;
					_tmp23_ = start;
					_tmp24_ = end;
					gtk_text_buffer_remove_tag (_tmp21_, _tmp22_, &_tmp23_, &_tmp24_);
					xnp_hypertext_view_tag_timeout_init (self);
				}
			} else {
				gboolean _tmp25_ = FALSE;
				if (gtk_text_iter_get_offset (location) < gtk_text_iter_get_offset (&end)) {
					_tmp25_ = TRUE;
				} else {
					_tmp25_ = string_contains (text, ":");
				}
				if (_tmp25_) {
					GtkTextTag* _tmp26_;
					GtkTextBuffer* _tmp27_;
					GtkTextBuffer* _tmp28_;
					GtkTextTag* _tmp29_;
					GtkTextIter _tmp30_;
					GtkTextIter _tmp31_;
					_tmp26_ = self->priv->tag_link;
					gtk_text_iter_forward_to_tag_toggle (&end, _tmp26_);
					_tmp27_ = gtk_text_view_get_buffer ((GtkTextView*) self);
					_tmp28_ = _tmp27_;
					_tmp29_ = self->priv->tag_link;
					_tmp30_ = start;
					_tmp31_ = end;
					gtk_text_buffer_remove_tag (_tmp28_, _tmp29_, &_tmp30_, &_tmp31_);
				} else {
					gboolean _tmp32_ = FALSE;
					if (string_contains (text, " ")) {
						_tmp32_ = TRUE;
					} else {
						_tmp32_ = string_contains (text, "\n");
					}
					if (_tmp32_) {
						GtkTextIter _tmp33_;
						GtkTextTag* _tmp34_;
						GtkTextBuffer* _tmp35_;
						GtkTextBuffer* _tmp36_;
						GtkTextTag* _tmp37_;
						GtkTextIter _tmp38_;
						GtkTextIter _tmp39_;
						_tmp33_ = *location;
						start = _tmp33_;
						_tmp34_ = self->priv->tag_link;
						gtk_text_iter_forward_to_tag_toggle (&end, _tmp34_);
						_tmp35_ = gtk_text_view_get_buffer ((GtkTextView*) self);
						_tmp36_ = _tmp35_;
						_tmp37_ = self->priv->tag_link;
						_tmp38_ = start;
						_tmp39_ = end;
						gtk_text_buffer_remove_tag (_tmp36_, _tmp37_, &_tmp38_, &_tmp39_);
						xnp_hypertext_view_tag_timeout_init (self);
					}
				}
			}
		} else {
			GtkTextTag* _tmp40_;
			_tmp40_ = self->priv->tag_link;
			if (gtk_text_iter_ends_tag (location, _tmp40_)) {
				gboolean _tmp41_ = FALSE;
				if (len >= 1) {
					gboolean _tmp42_ = FALSE;
					if (string_get (text, (glong) 0) == ' ') {
						_tmp42_ = TRUE;
					} else {
						_tmp42_ = string_get (text, (glong) 0) == '\n';
					}
					_tmp41_ = !_tmp42_;
				} else {
					_tmp41_ = FALSE;
				}
				if (_tmp41_) {
					GtkTextIter _tmp43_;
					GtkTextTag* _tmp44_;
					GtkTextBuffer* _tmp45_;
					GtkTextBuffer* _tmp46_;
					GtkTextTag* _tmp47_;
					GtkTextIter _tmp48_;
					GtkTextIter _tmp49_;
					_tmp43_ = *location;
					start = _tmp43_;
					_tmp44_ = self->priv->tag_link;
					gtk_text_iter_backward_to_tag_toggle (&start, _tmp44_);
					_tmp45_ = gtk_text_view_get_buffer ((GtkTextView*) self);
					_tmp46_ = _tmp45_;
					_tmp47_ = self->priv->tag_link;
					_tmp48_ = start;
					_tmp49_ = *location;
					gtk_text_buffer_remove_tag (_tmp46_, _tmp47_, &_tmp48_, &_tmp49_);
					xnp_hypertext_view_tag_timeout_init (self);
				} else {
					if (string_contains (text, "://")) {
						xnp_hypertext_view_tag_timeout_init (self);
					}
				}
			} else {
				gboolean _tmp50_ = FALSE;
				if (len == 1) {
					_tmp50_ = string_get (text, (glong) 0) == '/';
				} else {
					_tmp50_ = FALSE;
				}
				if (_tmp50_) {
					GtkTextIter _tmp51_;
					gboolean _tmp52_ = FALSE;
					_tmp51_ = *location;
					start = _tmp51_;
					if (!gtk_text_iter_backward_chars (&start, 2)) {
						_tmp52_ = TRUE;
					} else {
						GtkTextIter _tmp53_;
						gchar* _tmp54_;
						gchar* _tmp55_;
						_tmp53_ = *location;
						_tmp54_ = gtk_text_iter_get_text (&start, &_tmp53_);
						_tmp55_ = _tmp54_;
						_tmp52_ = g_strcmp0 (_tmp55_, ":/") != 0;
						_g_free0 (_tmp55_);
					}
					if (_tmp52_) {
						return;
					}
					xnp_hypertext_view_tag_timeout_init (self);
				} else {
					gboolean _tmp56_ = FALSE;
					if (len == 1) {
						gboolean _tmp57_ = FALSE;
						if (string_get (text, (glong) 0) == ' ') {
							_tmp57_ = TRUE;
						} else {
							_tmp57_ = string_get (text, (glong) 0) == '\n';
						}
						_tmp56_ = _tmp57_;
					} else {
						_tmp56_ = FALSE;
					}
					if (_tmp56_) {
						xnp_hypertext_view_update_tags (self);
					} else {
						gboolean _tmp58_ = FALSE;
						if (len > 4) {
							_tmp58_ = string_contains (text, "://");
						} else {
							_tmp58_ = FALSE;
						}
						if (_tmp58_) {
							xnp_hypertext_view_tag_timeout_init (self);
						}
					}
				}
			}
		}
	}
}

/**
 * delete_range_cb:
 *
 * Event to delete and update existing tags within the buffer.
 */
static void
xnp_hypertext_view_delete_range_cb (XnpHypertextView* self,
                                    GtkTextBuffer* buffer,
                                    GtkTextIter* start,
                                    GtkTextIter* end)
{
	GtkTextIter iter = {0};
	gboolean _tmp0_ = FALSE;
	GtkTextTag* _tmp1_;
	GtkTextTag* _tmp3_;
	GtkTextTag* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buffer != NULL);
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	_tmp1_ = self->priv->tag_link;
	if (!gtk_text_iter_has_tag (start, _tmp1_)) {
		GtkTextTag* _tmp2_;
		_tmp2_ = self->priv->tag_link;
		_tmp0_ = !gtk_text_iter_has_tag (end, _tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->tag_link;
	if (gtk_text_iter_has_tag (start, _tmp3_)) {
		GtkTextIter _tmp4_;
		GtkTextTag* _tmp5_;
		GtkTextBuffer* _tmp6_;
		GtkTextBuffer* _tmp7_;
		GtkTextTag* _tmp8_;
		GtkTextIter _tmp9_;
		GtkTextIter _tmp10_;
		_tmp4_ = *start;
		iter = _tmp4_;
		_tmp5_ = self->priv->tag_link;
		gtk_text_iter_backward_to_tag_toggle (&iter, _tmp5_);
		_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->tag_link;
		_tmp9_ = iter;
		_tmp10_ = *start;
		gtk_text_buffer_remove_tag (_tmp7_, _tmp8_, &_tmp9_, &_tmp10_);
	}
	_tmp11_ = self->priv->tag_link;
	if (gtk_text_iter_has_tag (end, _tmp11_)) {
		GtkTextIter _tmp12_;
		GtkTextTag* _tmp13_;
		GtkTextBuffer* _tmp14_;
		GtkTextBuffer* _tmp15_;
		GtkTextTag* _tmp16_;
		GtkTextIter _tmp17_;
		GtkTextIter _tmp18_;
		_tmp12_ = *end;
		iter = _tmp12_;
		_tmp13_ = self->priv->tag_link;
		gtk_text_iter_forward_to_tag_toggle (&iter, _tmp13_);
		_tmp14_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = self->priv->tag_link;
		_tmp17_ = *end;
		_tmp18_ = iter;
		gtk_text_buffer_remove_tag (_tmp15_, _tmp16_, &_tmp17_, &_tmp18_);
	}
	xnp_hypertext_view_tag_timeout_init (self);
}

/**
 * undo_snapshot:
 *
 * Makes a snapshot of the current buffer and swaps undo/redo texts.
 */
static gboolean
xnp_hypertext_view_undo_snapshot (XnpHypertextView* self)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextIter _tmp6_ = {0};
	GtkTextBuffer* _tmp7_;
	GtkTextBuffer* _tmp8_;
	GtkTextIter _tmp9_ = {0};
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkTextBuffer* _tmp13_;
	GtkTextIter _tmp14_;
	GtkTextIter _tmp15_;
	gchar* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "cursor-position", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	self->priv->undo_cursor_pos = _tmp3_;
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	gtk_text_buffer_get_iter_at_offset (_tmp5_, &_tmp6_, 0);
	start = _tmp6_;
	_tmp7_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp8_ = _tmp7_;
	gtk_text_buffer_get_iter_at_offset (_tmp8_, &_tmp9_, -1);
	end = _tmp9_;
	_tmp10_ = self->priv->redo_text;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (self->priv->undo_text);
	self->priv->undo_text = _tmp11_;
	_tmp12_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = start;
	_tmp15_ = end;
	_tmp16_ = gtk_text_buffer_get_text (_tmp13_, &_tmp14_, &_tmp15_, FALSE);
	_g_free0 (self->priv->redo_text);
	self->priv->redo_text = _tmp16_;
	if (self->priv->undo_timeout > ((guint) 0)) {
		g_source_remove (self->priv->undo_timeout);
		self->priv->undo_timeout = (guint) 0;
	}
	result = FALSE;
	return result;
}

/**
 * undo:
 *
 * Revert the buffer to the undo text and swaps undo/redo texts.
 */
void
xnp_hypertext_view_undo (XnpHypertextView* self)
{
	GtkTextIter iter = {0};
	GtkTextMark* mark = NULL;
	gchar* tmp = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	const gchar* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkTextBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	GtkTextIter _tmp8_;
	GtkTextBuffer* _tmp9_;
	GtkTextBuffer* _tmp10_;
	GtkTextMark* _tmp11_;
	GtkTextMark* _tmp12_;
	GtkTextBuffer* _tmp13_;
	GtkTextBuffer* _tmp14_;
	GtkTextMark* _tmp15_;
	GtkTextIter _tmp16_;
	GtkTextMark* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	g_return_if_fail (self != NULL);
	if (self->priv->undo_timeout > ((guint) 0)) {
		g_source_remove (self->priv->undo_timeout);
		self->priv->undo_timeout = (guint) 0;
		xnp_hypertext_view_undo_snapshot (self);
	}
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->undo_text;
	gtk_text_buffer_set_text (_tmp1_, _tmp2_, -1);
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp4_ = _tmp3_;
	gtk_text_buffer_get_iter_at_offset (_tmp4_, &_tmp5_, self->priv->undo_cursor_pos);
	iter = _tmp5_;
	_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = iter;
	gtk_text_buffer_place_cursor (_tmp7_, &_tmp8_);
	_tmp9_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = gtk_text_buffer_get_mark (_tmp10_, "undo-pos");
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_g_object_unref0 (mark);
	mark = _tmp12_;
	_tmp13_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = mark;
	_tmp16_ = iter;
	gtk_text_buffer_move_mark (_tmp14_, _tmp15_, &_tmp16_);
	_tmp17_ = mark;
	gtk_text_view_scroll_to_mark ((GtkTextView*) self, _tmp17_, 0.0, FALSE, 0.5, 0.5);
	_tmp18_ = self->priv->undo_text;
	_tmp19_ = g_strdup (_tmp18_);
	_g_free0 (tmp);
	tmp = _tmp19_;
	_tmp20_ = self->priv->redo_text;
	_tmp21_ = g_strdup (_tmp20_);
	_g_free0 (self->priv->undo_text);
	self->priv->undo_text = _tmp21_;
	_tmp22_ = tmp;
	_tmp23_ = g_strdup (_tmp22_);
	_g_free0 (self->priv->redo_text);
	self->priv->redo_text = _tmp23_;
	if (self->priv->undo_timeout > ((guint) 0)) {
		g_source_remove (self->priv->undo_timeout);
		self->priv->undo_timeout = (guint) 0;
	}
	_g_free0 (tmp);
	_g_object_unref0 (mark);
}

static gboolean
xnp_hypertext_view_tag_timeout_cb (XnpHypertextView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	xnp_hypertext_view_update_tags (self);
	result = FALSE;
	return result;
}

static void
xnp_hypertext_view_tag_timeout_init (XnpHypertextView* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->tag_timeout > ((guint) 0)) {
		g_source_remove (self->priv->tag_timeout);
		self->priv->tag_timeout = (guint) 0;
	}
	self->priv->tag_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, _xnp_hypertext_view_tag_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
}

/**
 * update_tags:
 *
 * Goes through the entire document to search for untagged links and tag them.
 */
void
xnp_hypertext_view_update_tags (XnpHypertextView* self)
{
	GtkTextIter iter = {0};
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter tmp = {0};
	gchar* link = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	if (self->priv->tag_timeout > ((guint) 0)) {
		g_source_remove (self->priv->tag_timeout);
		self->priv->tag_timeout = (guint) 0;
	}
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	gtk_text_buffer_get_iter_at_offset (_tmp1_, &_tmp2_, 0);
	iter = _tmp2_;
	while (TRUE) {
		GtkTextIter _tmp3_ = {0};
		GtkTextIter _tmp4_ = {0};
		gboolean _tmp5_;
		GtkTextIter _tmp6_;
		GtkTextTag* _tmp7_;
		GtkTextIter _tmp8_ = {0};
		gboolean _tmp9_;
		_tmp5_ = gtk_text_iter_forward_search (&iter, "://", GTK_TEXT_SEARCH_TEXT_ONLY, &_tmp3_, &_tmp4_, NULL);
		start = _tmp3_;
		end = _tmp4_;
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = end;
		iter = _tmp6_;
		if (!gtk_text_iter_ends_word (&start)) {
			continue;
		}
		gtk_text_iter_backward_word_start (&start);
		_tmp7_ = self->priv->tag_link;
		if (gtk_text_iter_starts_tag (&start, _tmp7_)) {
			continue;
		}
		_tmp9_ = gtk_text_iter_forward_search (&iter, " ", GTK_TEXT_SEARCH_TEXT_ONLY, &_tmp8_, NULL, NULL);
		end = _tmp8_;
		if (!_tmp9_) {
			GtkTextIter _tmp10_ = {0};
			gboolean _tmp11_;
			_tmp11_ = gtk_text_iter_forward_search (&iter, "\n", GTK_TEXT_SEARCH_TEXT_ONLY, &_tmp10_, NULL, NULL);
			end = _tmp10_;
			if (!_tmp11_) {
				GtkTextBuffer* _tmp12_;
				GtkTextBuffer* _tmp13_;
				GtkTextIter _tmp14_ = {0};
				_tmp12_ = gtk_text_view_get_buffer ((GtkTextView*) self);
				_tmp13_ = _tmp12_;
				gtk_text_buffer_get_iter_at_offset (_tmp13_, &_tmp14_, -1);
				end = _tmp14_;
			}
		} else {
			GtkTextIter _tmp15_ = {0};
			gboolean _tmp16_;
			_tmp16_ = gtk_text_iter_forward_search (&iter, "\n", GTK_TEXT_SEARCH_TEXT_ONLY, &_tmp15_, NULL, NULL);
			tmp = _tmp15_;
			if (_tmp16_) {
				if (gtk_text_iter_get_offset (&tmp) < gtk_text_iter_get_offset (&end)) {
					GtkTextIter _tmp17_;
					_tmp17_ = tmp;
					end = _tmp17_;
				}
			}
		}
		if ((gtk_text_iter_get_offset (&end) - gtk_text_iter_get_offset (&start)) >= 5) {
			GtkTextIter _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			GtkTextBuffer* _tmp21_;
			GtkTextBuffer* _tmp22_;
			GtkTextTag* _tmp23_;
			GtkTextIter _tmp24_;
			GtkTextIter _tmp25_;
			_tmp18_ = end;
			_tmp19_ = gtk_text_iter_get_text (&iter, &_tmp18_);
			_g_free0 (link);
			link = _tmp19_;
			_tmp20_ = link;
			if (string_contains (_tmp20_, ":")) {
				continue;
			}
			_tmp21_ = gtk_text_view_get_buffer ((GtkTextView*) self);
			_tmp22_ = _tmp21_;
			_tmp23_ = self->priv->tag_link;
			_tmp24_ = start;
			_tmp25_ = end;
			gtk_text_buffer_apply_tag (_tmp22_, _tmp23_, &_tmp24_, &_tmp25_);
		}
	}
	_g_free0 (link);
}

const gchar*
xnp_hypertext_view_get_font (XnpHypertextView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_font;
	result = _tmp0_;
	return result;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

void
xnp_hypertext_view_set_font (XnpHypertextView* self,
                             const gchar* value)
{
	gchar* _tmp0_;
	PangoFontDescription* font_descr = NULL;
	PangoFontDescription* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_font);
	self->priv->_font = _tmp0_;
	_tmp1_ = pango_font_description_from_string (value);
	font_descr = _tmp1_;
	gtk_widget_override_font ((GtkWidget*) self, font_descr);
	__vala_PangoFontDescription_free0 (font_descr);
	g_object_notify_by_pspec ((GObject *) self, xnp_hypertext_view_properties[XNP_HYPERTEXT_VIEW_FONT_PROPERTY]);
}

static void
_vala_PangoTabArray_free (PangoTabArray* self)
{
	g_boxed_free (pango_tab_array_get_type (), self);
}

static GObject *
xnp_hypertext_view_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	XnpHypertextView * self;
	PangoTabArray* _tmp0_;
	PangoTabArray* _tmp1_;
	parent_class = G_OBJECT_CLASS (xnp_hypertext_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView);
	xnp_hypertext_view_set_font (self, "Sans 13");
	_tmp0_ = pango_tab_array_new_with_positions (1, TRUE, PANGO_TAB_LEFT, 12, NULL);
	_tmp1_ = _tmp0_;
	gtk_text_view_set_tabs ((GtkTextView*) self, _tmp1_);
	__vala_PangoTabArray_free0 (_tmp1_);
	return obj;
}

static void
xnp_hypertext_view_class_init (XnpHypertextViewClass * klass,
                               gpointer klass_data)
{
	xnp_hypertext_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &XnpHypertextView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_xnp_hypertext_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_xnp_hypertext_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = xnp_hypertext_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = xnp_hypertext_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), XNP_HYPERTEXT_VIEW_FONT_PROPERTY, xnp_hypertext_view_properties[XNP_HYPERTEXT_VIEW_FONT_PROPERTY] = g_param_spec_string ("font", "font", "font", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
xnp_hypertext_view_instance_init (XnpHypertextView * self,
                                  gpointer klass)
{
	GdkDisplay* _tmp0_;
	GdkCursor* _tmp1_;
	GdkDisplay* _tmp2_;
	GdkCursor* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self->priv = xnp_hypertext_view_get_instance_private (self);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_cursor_new_for_display (_tmp0_, GDK_HAND2);
	self->priv->hand_cursor = _tmp1_;
	_tmp2_ = gdk_display_get_default ();
	_tmp3_ = gdk_cursor_new_for_display (_tmp2_, GDK_XTERM);
	self->priv->regular_cursor = _tmp3_;
	self->priv->cursor_over_link = FALSE;
	self->priv->undo_timeout = (guint) 0;
	_tmp4_ = g_strdup ("");
	self->priv->undo_text = _tmp4_;
	_tmp5_ = g_strdup ("");
	self->priv->redo_text = _tmp5_;
	self->priv->tag_timeout = (guint) 0;
}

static void
xnp_hypertext_view_finalize (GObject * obj)
{
	XnpHypertextView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView);
	if (self->priv->undo_timeout != ((guint) 0)) {
		g_source_remove (self->priv->undo_timeout);
	}
	if (self->priv->tag_timeout != ((guint) 0)) {
		g_source_remove (self->priv->tag_timeout);
	}
	_g_object_unref0 (self->priv->hand_cursor);
	_g_object_unref0 (self->priv->regular_cursor);
	_g_free0 (self->priv->undo_text);
	_g_free0 (self->priv->redo_text);
	_g_object_unref0 (self->priv->tag_link);
	_g_free0 (self->priv->_font);
	G_OBJECT_CLASS (xnp_hypertext_view_parent_class)->finalize (obj);
}

static GType
xnp_hypertext_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XnpHypertextViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_hypertext_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpHypertextView), 0, (GInstanceInitFunc) xnp_hypertext_view_instance_init, NULL };
	GType xnp_hypertext_view_type_id;
	xnp_hypertext_view_type_id = g_type_register_static (gtk_text_view_get_type (), "XnpHypertextView", &g_define_type_info, 0);
	XnpHypertextView_private_offset = g_type_add_instance_private (xnp_hypertext_view_type_id, sizeof (XnpHypertextViewPrivate));
	return xnp_hypertext_view_type_id;
}

GType
xnp_hypertext_view_get_type (void)
{
	static volatile gsize xnp_hypertext_view_type_id__once = 0;
	if (g_once_init_enter (&xnp_hypertext_view_type_id__once)) {
		GType xnp_hypertext_view_type_id;
		xnp_hypertext_view_type_id = xnp_hypertext_view_get_type_once ();
		g_once_init_leave (&xnp_hypertext_view_type_id__once, xnp_hypertext_view_type_id);
	}
	return xnp_hypertext_view_type_id__once;
}

static void
_vala_xnp_hypertext_view_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	XnpHypertextView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView);
	switch (property_id) {
		case XNP_HYPERTEXT_VIEW_FONT_PROPERTY:
		g_value_set_string (value, xnp_hypertext_view_get_font (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_xnp_hypertext_view_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	XnpHypertextView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, XNP_TYPE_HYPERTEXT_VIEW, XnpHypertextView);
	switch (property_id) {
		case XNP_HYPERTEXT_VIEW_FONT_PROPERTY:
		xnp_hypertext_view_set_font (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

