/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.dialogs;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import rene.dialogs.Warning;
import rene.gui.ButtonAction;
import rene.gui.MyLabel;
import rene.gui.MyPanel;
import rene.gui.MyTextField;
import rene.gui.Panel3D;
import rene.zirkel.Zirkel;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.dialogs.HelpCloseDialog;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.ConstructionObject;

public class EditConditionals
extends HelpCloseDialog
implements ActionListener {
    TextField[] Colors = new TextField[ColorStrings.length];
    TextField[] ColorTypes = new TextField[ColorTypeStrings.length];
    TextField Hidden;
    TextField SuperHidden;
    TextField ShowName;
    TextField ShowValue;
    TextField Background;
    TextField Solid;
    TextField Z;
    ConstructionObject O;
    Vector V;
    Frame F;
    public static String[] ColorTypeStrings = new String[]{"normal", "thick", "thin", "invisible"};
    public static String[] ColorStrings = new String[]{"black", "green", "blue", "brown", "cyan", "red"};

    public EditConditionals(Frame frame, ConstructionObject constructionObject, Vector vector) {
        super(frame, constructionObject == null ? Zirkel.name("editconditionals.title") : Zirkel.name("editconditionals.title") + " : " + constructionObject.getName(), true);
        Expression expression;
        int n;
        this.O = constructionObject;
        this.F = frame;
        if (this.O == null) {
            this.O = constructionObject = (ConstructionObject)vector.elementAt(0);
        }
        if (vector == null) {
            this.V = new Vector();
            this.V.addElement(constructionObject);
        } else {
            this.V = vector;
        }
        this.setLayout(new BorderLayout());
        MyPanel myPanel = new MyPanel();
        myPanel.setLayout(new GridLayout(0, 2));
        for (n = 0; n < ColorStrings.length; ++n) {
            myPanel.add(new MyLabel(Zirkel.name("colors." + ColorStrings[n])));
            this.Colors[n] = new MyTextField("", 32);
            expression = constructionObject.getConditional(ColorStrings[n]);
            if (expression != null) {
                this.Colors[n].setText(expression.toString());
            }
            myPanel.add(this.Colors[n]);
        }
        for (n = 0; n < ColorTypeStrings.length; ++n) {
            myPanel.add(new MyLabel(Zirkel.name("color.type." + ColorTypeStrings[n])));
            this.ColorTypes[n] = new MyTextField("", 32);
            expression = constructionObject.getConditional(ColorTypeStrings[n]);
            if (expression != null) {
                this.ColorTypes[n].setText(expression.toString());
            }
            myPanel.add(this.ColorTypes[n]);
        }
        this.Hidden = this.addConditional(myPanel, "hidden");
        this.SuperHidden = this.addConditional(myPanel, "superhidden");
        this.ShowName = this.addConditional(myPanel, "showname");
        this.ShowValue = this.addConditional(myPanel, "showvalue");
        this.Background = this.addConditional(myPanel, "background");
        this.Solid = this.addConditional(myPanel, "solid");
        this.Z = this.addConditional(myPanel, "z");
        this.add("North", new Panel3D(myPanel));
        MyPanel myPanel2 = new MyPanel();
        myPanel2.add(new ButtonAction(this, Zirkel.name("cancel"), "Close"));
        myPanel2.add(new ButtonAction(this, Zirkel.name("ok"), "OK"));
        this.addHelp(myPanel2, "conditions");
        this.add("South", new Panel3D(myPanel2));
        this.pack();
        this.center(frame);
        this.setVisible(true);
    }

    public EditConditionals(Frame frame, Vector vector) {
        this(frame, null, vector);
    }

    public EditConditionals(Frame frame, ConstructionObject constructionObject) {
        this(frame, constructionObject, null);
    }

    public TextField addConditional(Panel panel, String string) {
        panel.add(new MyLabel(Zirkel.name("editconditionals." + string)));
        MyTextField myTextField = new MyTextField("", 32);
        Expression expression = this.O.getConditional(string);
        if (expression != null) {
            myTextField.setText(expression.toString());
        }
        panel.add(myTextField);
        return myTextField;
    }

    public void doAction(String string) {
        if (string.equals("OK")) {
            Enumeration enumeration = this.V.elements();
            while (enumeration.hasMoreElements()) {
                int n;
                this.O = (ConstructionObject)enumeration.nextElement();
                this.O.clearConditionals();
                for (n = 0; n < ColorStrings.length; ++n) {
                    this.setConditional(ColorStrings[n], this.Colors[n]);
                }
                for (n = 0; n < ColorTypeStrings.length; ++n) {
                    this.setConditional(ColorTypeStrings[n], this.ColorTypes[n]);
                }
                this.setConditional("hidden", this.Hidden);
                this.setConditional("superhidden", this.SuperHidden);
                this.setConditional("showname", this.ShowName);
                this.setConditional("showvalue", this.ShowValue);
                this.setConditional("background", this.Background);
                this.setConditional("solid", this.Solid);
                this.setConditional("z", this.Z);
                try {
                    this.O.checkConditionals();
                }
                catch (ConstructionException constructionException) {
                    Warning warning = new Warning(this.F, constructionException.getDescription(), Zirkel.name("warning"), true);
                    warning.center(this.F);
                    warning.setVisible(true);
                    return;
                }
            }
            this.doclose();
        } else {
            super.doAction(string);
        }
    }

    public void setConditional(String string, TextField textField) {
        if (!textField.getText().trim().equals("")) {
            this.O.addConditional(string, new Expression(textField.getText().trim(), this.O.getConstruction(), this.O, null, false));
        }
    }
}

