(* This file was originally generated by why.
   It can be modified; only the generated parts will be overwritten. *)

Require Import Why.
Require Import Omega.
Require Import heap.
Require Import Inftree.
Require Import ZArithRing.

Lemma double_div2 : forall x:Z, Zdiv2 (2 * x) = x.
Proof.
simple destruct x; auto.
Qed.

Lemma double_div2_bis : forall x:Z, (0 <= x)%Z -> Zdiv2 (2 * x + 1) = x.
Proof.
simple destruct x; auto.
intros.
simpl in H.
absurd (0 <= Zneg p)%Z.
simpl.
 compute.
 auto.
 assumption.
Qed.

Lemma lem_div2_0 :
 forall n:Z, (1 <= n)%Z -> (-1 <= Zdiv2 (n - 2) <= n - 1)%Z.
Proof.
intros.
elim (Z_lt_ge_dec 1 n); intro.
elim (Z_modulo_2 n).
intro H0; elim H0; clear H0; intros.
replace (n - 2)%Z with (2 * (x - 1))%Z.
rewrite double_div2.
omega.
 omega.
intro H0; elim H0; clear H0; intros.
replace (n - 2)%Z with (2 * (x - 1) + 1)%Z.
rewrite double_div2_bis.
omega.
 omega.
 omega.
 replace n with 1%Z.
simpl.
 omega.
 omega.
Qed.

Lemma lem_div2_1 : forall n:Z, (1 <= n)%Z -> (0 <= Zdiv2 (n - 2) + 1)%Z.
Proof.
intros n Hn.
 generalize (lem_div2_0 n Hn).
 omega.
Qed.

Lemma lem_div2_2 :
 forall n i:Z,
   (1 <= n)%Z ->
   (Zdiv2 (n - 2) + 1 <= i <= n - 1)%Z -> (2 * i >= n - 1)%Z.
Proof.
intros n i Hn.
elim (Z_lt_ge_dec 1 n); intro.
elim (Z_modulo_2 n).
intro H0; elim H0; clear H0; intros x Hx.
replace (n - 2)%Z with (2 * (x - 1))%Z.
rewrite double_div2.
omega.
 omega.
 intro H0; elim H0; clear H0; intros x Hx.
replace (n - 2)%Z with (2 * (x - 1) + 1)%Z.
rewrite double_div2_bis.
omega.
 omega.
 omega.
 replace n with 1%Z.
simpl.
 omega.
 omega.
Qed.


(* Obligations. *)

Proof.
intuition.
Qed.

Proof.
intuition SameLength t1 t0; try omega.
rewrite H10; auto with *.
apply permut_trans with (t' := t0); assumption.
unfold Zwf; Omega'.
Qed.

Proof.
intros.
generalize (lem_div2_0 (array_length t) Pre16); intuition try Omega'.
apply heap_leaf.
generalize (lem_div2_1 (array_length t) Pre16); Omega'.
apply (lem_div2_2 (array_length t) i); trivial || Omega'.
auto with datatypes.
Qed.

Proof.
intuition.
SameLength t0 t; auto with *.
Qed.

Proof.
intuition.
Qed.

Proof.
intuition.
SameLength t2 t1; omega.
apply heap_id with (t := t1).
apply heap_weakening.
 Omega'.
apply H1; Omega'.
 Omega'.
decompose [exchange] Post15; clear Post15.
unfold array_id.
intros i0 Hi0.
 symmetry.
 apply H18; Omega'.
Qed.

Proof.
intuition.
SameLength t3 t2; omega.
(* heap *)
subst k2; apply H17; Omega'.
(* t[0] <= t[k] *)
subst k2; ring (k1 - 1 + 1)%Z.
 rewrite (H16 k1); [ idtac | Omega' ].
decompose [exchange] Post15.
rewrite H24.
apply inftree_1 with (n := (k1 - 1)%Z).
apply H19.
apply inftree_weakening.
 Omega'.
apply inftree_exchange with (t1 := t1).
 Omega'.
apply inftree_3.
apply H1; Omega'.
assumption.
 Omega'.
(* sorted *)
subst k2; ring (k1 - 1 + 1)%Z.
  elim (Z_le_lt_eq_dec k1 (array_length t1 - 1) H6); intro.
  (* k0 < N-1 *)
  replace k1 with (k1 + 1 - 1)%Z; [ idtac | Omega' ].
  apply left_extension.
 Omega'.
 Omega'.
  apply sorted_array_id with (t1 := t2).
   apply sorted_array_id with (t1 := t1).
   SameLength t3 t2; SameLength t2 t1; SameLength t1 t.
  rewrite H20; rewrite H21.
 apply H7; Omega'.
  decompose [exchange] Post15.
  unfold array_id.
 intros i Hi.
 symmetry.
   SameLength t3 t2; apply H25; try Omega'.
  unfold array_id.
 intros i Hi.
 symmetry.
 apply H16; Omega'.
  (* t3[k0] <= t3[k0+1] *)
  ring (k1 + 1 - 1)%Z.
   rewrite (H16 k1); [ idtac | Omega' ].
  rewrite (H16 (k1 + 1)%Z);
   [ idtac | SameLength t3 t2; SameLength t2 t1; Omega' ].
  decompose [exchange] Post15.
  rewrite H24.
 rewrite (H25 (k1 + 1)%Z); [ idtac | Omega' | Omega' | Omega' ].
  apply H4; Omega'.
  (* k0 = N-1 *)
  rewrite b.
   unfold sorted_array.
  intros HN x HHx Hx.
   absurd (x >= array_length t3 - 1)%Z; SameLength t3 t2;
    SameLength t2 t1; Omega'.
(* (permut t3 t) *)
apply permut_trans with (t' := t2); try assumption.
 apply permut_trans with (t' := t1).
apply exchange_is_permut with (i := 0%Z) (j := k1).
 assumption.
 assumption.
 Qed.

Proof.
intuition SameLength t0 t; try omega.
apply heap_all.
subst k; assumption.
tauto.
intro; absurd (array_length t0 - 1 + 1 <= array_length t0 - 1)%Z;
 Omega'.
Qed.

Proof.
intuition.
elim (Z_le_lt_eq_dec 1 (array_length t) Pre16); intro.
  (* 1 < N *)
  replace 0%Z with (1 - 1)%Z; [ idtac | Omega' ].
  apply left_extension.
 Omega'.
 Omega'.
  replace 1%Z with (k1 + 1)%Z; [ idtac | Omega' ].
  replace (array_length t1 - (k1 + 1))%Z with (array_length t1 - 1)%Z;
   [ idtac | Omega' ].
  apply H6; SameLength t1 t; Omega'.
  replace (1 - 1)%Z with 0%Z; [ idtac | Omega' ].
 (* Ring `1-1`. *)
  replace 1%Z with (k1 + 1)%Z; [ idtac | Omega' ].
  apply H4; SameLength t1 t; Omega'.
  (* 1 = N *)
  unfold sorted_array.
   intros HN x HHx Hx.
   absurd (x >= array_length t - 1)%Z; SameLength t1 t; Omega'.
Qed.

Require Import swap_why.
Require Import downheap_why.


Proof.
(* FILL PROOF HERE *)
Save.

Proof.
(* FILL PROOF HERE *)
Save.

Proof.
(* FILL PROOF HERE *)
Save.

Proof.
(* FILL PROOF HERE *)
Save.

Proof.
(* FILL PROOF HERE *)
Save.

Proof.
(* FILL PROOF HERE *)
Save.

Proof.
(* FILL PROOF HERE *)
Save.

Proof.
(* FILL PROOF HERE *)
Save.

Proof.
(* FILL PROOF HERE *)
Save.


Admitted.

Admitted.

(*Why logic*) Definition lt_int_bool : Z -> Z -> bool.
Admitted.

(*Why logic*) Definition le_int_bool : Z -> Z -> bool.
Admitted.

(*Why logic*) Definition gt_int_bool : Z -> Z -> bool.
Admitted.

(*Why logic*) Definition ge_int_bool : Z -> Z -> bool.
Admitted.

(*Why logic*) Definition eq_int_bool : Z -> Z -> bool.
Admitted.

(*Why logic*) Definition neq_int_bool : Z -> Z -> bool.
Admitted.

(*Why axiom*) Lemma lt_int_bool_axiom :
  (forall (x:Z), (forall (y:Z), ((lt_int_bool x y) = true <-> x < y))).
Admitted.

(*Why axiom*) Lemma le_int_bool_axiom :
  (forall (x:Z), (forall (y:Z), ((le_int_bool x y) = true <-> x <= y))).
Admitted.

(*Why axiom*) Lemma gt_int_bool_axiom :
  (forall (x:Z), (forall (y:Z), ((gt_int_bool x y) = true <-> x > y))).
Admitted.

(*Why axiom*) Lemma ge_int_bool_axiom :
  (forall (x:Z), (forall (y:Z), ((ge_int_bool x y) = true <-> x >= y))).
Admitted.

(*Why axiom*) Lemma eq_int_bool_axiom :
  (forall (x:Z), (forall (y:Z), ((eq_int_bool x y) = true <-> x = y))).
Admitted.

(*Why axiom*) Lemma neq_int_bool_axiom :
  (forall (x:Z), (forall (y:Z), ((neq_int_bool x y) = true <-> x <> y))).
Admitted.

(*Why logic*) Definition abs_int : Z -> Z.
Admitted.

(*Why axiom*) Lemma abs_int_pos :
  (forall (x:Z), (x >= 0 -> (abs_int x) = x)).
Admitted.

(*Why axiom*) Lemma abs_int_neg :
  (forall (x:Z), (x <= 0 -> (abs_int x) = (Zopp x))).
Admitted.

(*Why logic*) Definition int_max : Z -> Z -> Z.
Admitted.

(*Why logic*) Definition int_min : Z -> Z -> Z.
Admitted.

(*Why axiom*) Lemma int_max_is_ge :
  (forall (x:Z), (forall (y:Z), (int_max x y) >= x /\ (int_max x y) >= y)).
Admitted.

(*Why axiom*) Lemma int_max_is_some :
  (forall (x:Z), (forall (y:Z), (int_max x y) = x \/ (int_max x y) = y)).
Admitted.

(*Why axiom*) Lemma int_min_is_le :
  (forall (x:Z), (forall (y:Z), (int_min x y) <= x /\ (int_min x y) <= y)).
Admitted.

(*Why axiom*) Lemma int_min_is_some :
  (forall (x:Z), (forall (y:Z), (int_min x y) = x \/ (int_min x y) = y)).
Admitted.

(*Why logic*) Definition computer_div : Z -> Z -> Z.
Admitted.

(*Why logic*) Definition computer_mod : Z -> Z -> Z.
Admitted.

(*Why logic*) Definition math_div : Z -> Z -> Z.
Admitted.

(*Why logic*) Definition math_mod : Z -> Z -> Z.
Admitted.

(*Why axiom*) Lemma math_div_mod :
  (forall (x:Z),
   (forall (y:Z), (y <> 0 -> x = (y * (math_div x y) + (math_mod x y))))).
Admitted.

(*Why axiom*) Lemma math_mod_bound :
  (forall (x:Z),
   (forall (y:Z),
    (y <> 0 -> 0 <= (math_mod x y) /\ (math_mod x y) < (abs_int y)))).
Admitted.

(*Why axiom*) Lemma computer_div_mod :
  (forall (x:Z),
   (forall (y:Z),
    (y <> 0 -> x = (y * (computer_div x y) + (computer_mod x y))))).
Admitted.

(*Why axiom*) Lemma computer_mod_bound :
  (forall (x:Z),
   (forall (y:Z), (y <> 0 -> (abs_int (computer_mod x y)) < (abs_int y)))).
Admitted.

(*Why axiom*) Lemma computer_mod_sign_pos :
  (forall (x:Z),
   (forall (y:Z), (x >= 0 /\ y <> 0 -> (computer_mod x y) >= 0))).
Admitted.

(*Why axiom*) Lemma computer_mod_sign_neg :
  (forall (x:Z),
   (forall (y:Z), (x <= 0 /\ y <> 0 -> (computer_mod x y) <= 0))).
Admitted.

(*Why axiom*) Lemma computer_rounds_toward_zero :
  (forall (x:Z),
   (forall (y:Z),
    (y <> 0 -> (abs_int ((computer_div x y) * y)) <= (abs_int x)))).
Admitted.

(* Why obligation from file "heapsort.mlw", line 27, characters 20-209: *)
(*Why goal*) Lemma heapsort_po_1 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  (-1) <= ((computer_div result 2) - 1).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 27, characters 20-209: *)
(*Why goal*) Lemma heapsort_po_2 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  ((computer_div result 2) - 1) <= ((array_length t) - 1).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 27, characters 20-209: *)
(*Why goal*) Lemma heapsort_po_3 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (i: Z),
  forall (HW_3: ((computer_div result 2) - 1 + 1) <= i /\ i <=
                ((array_length t) - 1)),
  (heap t ((array_length t) - 1) i).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 27, characters 20-209: *)
(*Why goal*) Lemma heapsort_po_4 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  (permutation t t).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 32, characters 8-43: *)
(*Why goal*) Lemma heapsort_po_5 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_5: k >= 0),
  forall (result0: Z),
  forall (HW_6: result0 = (array_length t0)),
  0 <= k.
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 32, characters 8-43: *)
(*Why goal*) Lemma heapsort_po_6 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_5: k >= 0),
  forall (result0: Z),
  forall (HW_6: result0 = (array_length t0)),
  k <= (result0 - 1).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 32, characters 8-43: *)
(*Why goal*) Lemma heapsort_po_7 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_5: k >= 0),
  forall (result0: Z),
  forall (HW_6: result0 = (array_length t0)),
  (result0 - 1) < (array_length t0).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 32, characters 8-43: *)
(*Why goal*) Lemma heapsort_po_8 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_5: k >= 0),
  forall (result0: Z),
  forall (HW_6: result0 = (array_length t0)),
  forall (i: Z),
  forall (HW_7: (k + 1) <= i /\ i <= (result0 - 1)),
  (heap t0 (result0 - 1) i).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 27, characters 20-209: *)
(*Why goal*) Lemma heapsort_po_9 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_5: k >= 0),
  forall (result0: Z),
  forall (HW_6: result0 = (array_length t0)),
  forall (HW_8: (0 <= k /\ k <= (result0 - 1)) /\ (result0 - 1) <
                (array_length t0) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= (result0 - 1) ->
                  (heap t0 (result0 - 1) i)))),
  forall (t1: (array Z)),
  forall (HW_9: (permutation t1 t0) /\
                (forall (i:Z),
                 (k <= i /\ i <= (result0 - 1) -> (heap t1 (result0 - 1) i))) /\
                (forall (i:Z),
                 (0 <= i /\ i < k \/ k < i /\ i < (2 * k + 1) \/
                  (result0 - 1) < i /\ i < (array_length t1) ->
                  (access t1 i) = (access t0 i))) /\
                (forall (v:Z),
                 ((inftree t0 (result0 - 1) v k) ->
                  (inftree t1 (result0 - 1) v k)))),
  forall (k0: Z),
  forall (HW_10: k0 = (k - 1)),
  (-1) <= k0.
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 27, characters 20-209: *)
(*Why goal*) Lemma heapsort_po_10 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_5: k >= 0),
  forall (result0: Z),
  forall (HW_6: result0 = (array_length t0)),
  forall (HW_8: (0 <= k /\ k <= (result0 - 1)) /\ (result0 - 1) <
                (array_length t0) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= (result0 - 1) ->
                  (heap t0 (result0 - 1) i)))),
  forall (t1: (array Z)),
  forall (HW_9: (permutation t1 t0) /\
                (forall (i:Z),
                 (k <= i /\ i <= (result0 - 1) -> (heap t1 (result0 - 1) i))) /\
                (forall (i:Z),
                 (0 <= i /\ i < k \/ k < i /\ i < (2 * k + 1) \/
                  (result0 - 1) < i /\ i < (array_length t1) ->
                  (access t1 i) = (access t0 i))) /\
                (forall (v:Z),
                 ((inftree t0 (result0 - 1) v k) ->
                  (inftree t1 (result0 - 1) v k)))),
  forall (k0: Z),
  forall (HW_10: k0 = (k - 1)),
  k0 <= ((array_length t1) - 1).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 27, characters 20-209: *)
(*Why goal*) Lemma heapsort_po_11 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_5: k >= 0),
  forall (result0: Z),
  forall (HW_6: result0 = (array_length t0)),
  forall (HW_8: (0 <= k /\ k <= (result0 - 1)) /\ (result0 - 1) <
                (array_length t0) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= (result0 - 1) ->
                  (heap t0 (result0 - 1) i)))),
  forall (t1: (array Z)),
  forall (HW_9: (permutation t1 t0) /\
                (forall (i:Z),
                 (k <= i /\ i <= (result0 - 1) -> (heap t1 (result0 - 1) i))) /\
                (forall (i:Z),
                 (0 <= i /\ i < k \/ k < i /\ i < (2 * k + 1) \/
                  (result0 - 1) < i /\ i < (array_length t1) ->
                  (access t1 i) = (access t0 i))) /\
                (forall (v:Z),
                 ((inftree t0 (result0 - 1) v k) ->
                  (inftree t1 (result0 - 1) v k)))),
  forall (k0: Z),
  forall (HW_10: k0 = (k - 1)),
  forall (i: Z),
  forall (HW_11: (k0 + 1) <= i /\ i <= ((array_length t1) - 1)),
  (heap t1 ((array_length t1) - 1) i).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 27, characters 20-209: *)
(*Why goal*) Lemma heapsort_po_12 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_5: k >= 0),
  forall (result0: Z),
  forall (HW_6: result0 = (array_length t0)),
  forall (HW_8: (0 <= k /\ k <= (result0 - 1)) /\ (result0 - 1) <
                (array_length t0) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= (result0 - 1) ->
                  (heap t0 (result0 - 1) i)))),
  forall (t1: (array Z)),
  forall (HW_9: (permutation t1 t0) /\
                (forall (i:Z),
                 (k <= i /\ i <= (result0 - 1) -> (heap t1 (result0 - 1) i))) /\
                (forall (i:Z),
                 (0 <= i /\ i < k \/ k < i /\ i < (2 * k + 1) \/
                  (result0 - 1) < i /\ i < (array_length t1) ->
                  (access t1 i) = (access t0 i))) /\
                (forall (v:Z),
                 ((inftree t0 (result0 - 1) v k) ->
                  (inftree t1 (result0 - 1) v k)))),
  forall (k0: Z),
  forall (HW_10: k0 = (k - 1)),
  (permutation t1 t).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 31, characters 18-21: *)
(*Why goal*) Lemma heapsort_po_13 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_5: k >= 0),
  forall (result0: Z),
  forall (HW_6: result0 = (array_length t0)),
  forall (HW_8: (0 <= k /\ k <= (result0 - 1)) /\ (result0 - 1) <
                (array_length t0) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= (result0 - 1) ->
                  (heap t0 (result0 - 1) i)))),
  forall (t1: (array Z)),
  forall (HW_9: (permutation t1 t0) /\
                (forall (i:Z),
                 (k <= i /\ i <= (result0 - 1) -> (heap t1 (result0 - 1) i))) /\
                (forall (i:Z),
                 (0 <= i /\ i < k \/ k < i /\ i < (2 * k + 1) \/
                  (result0 - 1) < i /\ i < (array_length t1) ->
                  (access t1 i) = (access t0 i))) /\
                (forall (v:Z),
                 ((inftree t0 (result0 - 1) v k) ->
                  (inftree t1 (result0 - 1) v k)))),
  forall (k0: Z),
  forall (HW_10: k0 = (k - 1)),
  0 <= (k + 1).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 31, characters 18-21: *)
(*Why goal*) Lemma heapsort_po_14 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_5: k >= 0),
  forall (result0: Z),
  forall (HW_6: result0 = (array_length t0)),
  forall (HW_8: (0 <= k /\ k <= (result0 - 1)) /\ (result0 - 1) <
                (array_length t0) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= (result0 - 1) ->
                  (heap t0 (result0 - 1) i)))),
  forall (t1: (array Z)),
  forall (HW_9: (permutation t1 t0) /\
                (forall (i:Z),
                 (k <= i /\ i <= (result0 - 1) -> (heap t1 (result0 - 1) i))) /\
                (forall (i:Z),
                 (0 <= i /\ i < k \/ k < i /\ i < (2 * k + 1) \/
                  (result0 - 1) < i /\ i < (array_length t1) ->
                  (access t1 i) = (access t0 i))) /\
                (forall (v:Z),
                 ((inftree t0 (result0 - 1) v k) ->
                  (inftree t1 (result0 - 1) v k)))),
  forall (k0: Z),
  forall (HW_10: k0 = (k - 1)),
  (k0 + 1) < (k + 1).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 35, characters 8-66: *)
(*Why goal*) Lemma heapsort_po_15 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  (heap t0 ((array_length t0) - 1) 0).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 35, characters 8-66: *)
(*Why goal*) Lemma heapsort_po_16 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  (permutation t0 t).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 40, characters 20-289: *)
(*Why goal*) Lemma heapsort_po_17 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  0 <= (result0 - 1).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 40, characters 20-289: *)
(*Why goal*) Lemma heapsort_po_18 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  (result0 - 1) <= ((array_length t0) - 1).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 40, characters 20-289: *)
(*Why goal*) Lemma heapsort_po_19 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (i: Z),
  forall (HW_14: 0 <= i /\ i <= (result0 - 1)),
  (heap t0 (result0 - 1) i).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 40, characters 20-289: *)
(*Why goal*) Lemma heapsort_po_20 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (HW_15: (result0 - 1 + 1) <= ((array_length t0) - 1)),
  (access t0 0) <= (access t0 (result0 - 1 + 1)).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 40, characters 20-289: *)
(*Why goal*) Lemma heapsort_po_21 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (HW_16: (result0 - 1 + 1) <= ((array_length t0) - 1)),
  (sorted_array t0 (result0 - 1 + 1) ((array_length t0) - 1)).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 40, characters 20-289: *)
(*Why goal*) Lemma heapsort_po_22 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  (permutation t0 t).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 47, characters 9-20: *)
(*Why goal*) Lemma heapsort_po_23 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (k0: Z),
  forall (t1: (array Z)),
  forall (HW_17: (0 <= k0 /\ k0 <= ((array_length t1) - 1)) /\
                 (forall (i:Z), (0 <= i /\ i <= k0 -> (heap t1 k0 i))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) -> (access t1 0) <=
                   (access t1 (k0 + 1)))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) ->
                   (sorted_array t1 (k0 + 1) ((array_length t1) - 1)))) /\
                 (permutation t1 t)),
  forall (HW_18: k0 >= 1),
  0 <= 0.
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 47, characters 9-20: *)
(*Why goal*) Lemma heapsort_po_24 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (k0: Z),
  forall (t1: (array Z)),
  forall (HW_17: (0 <= k0 /\ k0 <= ((array_length t1) - 1)) /\
                 (forall (i:Z), (0 <= i /\ i <= k0 -> (heap t1 k0 i))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) -> (access t1 0) <=
                   (access t1 (k0 + 1)))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) ->
                   (sorted_array t1 (k0 + 1) ((array_length t1) - 1)))) /\
                 (permutation t1 t)),
  forall (HW_18: k0 >= 1),
  0 < (array_length t1).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 47, characters 9-20: *)
(*Why goal*) Lemma heapsort_po_25 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (k0: Z),
  forall (t1: (array Z)),
  forall (HW_17: (0 <= k0 /\ k0 <= ((array_length t1) - 1)) /\
                 (forall (i:Z), (0 <= i /\ i <= k0 -> (heap t1 k0 i))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) -> (access t1 0) <=
                   (access t1 (k0 + 1)))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) ->
                   (sorted_array t1 (k0 + 1) ((array_length t1) - 1)))) /\
                 (permutation t1 t)),
  forall (HW_18: k0 >= 1),
  0 <= k0.
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 47, characters 9-20: *)
(*Why goal*) Lemma heapsort_po_26 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (k0: Z),
  forall (t1: (array Z)),
  forall (HW_17: (0 <= k0 /\ k0 <= ((array_length t1) - 1)) /\
                 (forall (i:Z), (0 <= i /\ i <= k0 -> (heap t1 k0 i))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) -> (access t1 0) <=
                   (access t1 (k0 + 1)))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) ->
                   (sorted_array t1 (k0 + 1) ((array_length t1) - 1)))) /\
                 (permutation t1 t)),
  forall (HW_18: k0 >= 1),
  k0 < (array_length t1).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 48, characters 9-28: *)
(*Why goal*) Lemma heapsort_po_27 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (k0: Z),
  forall (t1: (array Z)),
  forall (HW_17: (0 <= k0 /\ k0 <= ((array_length t1) - 1)) /\
                 (forall (i:Z), (0 <= i /\ i <= k0 -> (heap t1 k0 i))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) -> (access t1 0) <=
                   (access t1 (k0 + 1)))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) ->
                   (sorted_array t1 (k0 + 1) ((array_length t1) - 1)))) /\
                 (permutation t1 t)),
  forall (HW_18: k0 >= 1),
  forall (HW_19: (0 <= 0 /\ 0 < (array_length t1)) /\ 0 <= k0 /\ k0 <
                 (array_length t1)),
  forall (t2: (array Z)),
  forall (HW_20: (exchange t2 t1 0 k0)),
  0 <= 0.
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 48, characters 9-28: *)
(*Why goal*) Lemma heapsort_po_28 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (k0: Z),
  forall (t1: (array Z)),
  forall (HW_17: (0 <= k0 /\ k0 <= ((array_length t1) - 1)) /\
                 (forall (i:Z), (0 <= i /\ i <= k0 -> (heap t1 k0 i))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) -> (access t1 0) <=
                   (access t1 (k0 + 1)))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) ->
                   (sorted_array t1 (k0 + 1) ((array_length t1) - 1)))) /\
                 (permutation t1 t)),
  forall (HW_18: k0 >= 1),
  forall (HW_19: (0 <= 0 /\ 0 < (array_length t1)) /\ 0 <= k0 /\ k0 <
                 (array_length t1)),
  forall (t2: (array Z)),
  forall (HW_20: (exchange t2 t1 0 k0)),
  0 <= (k0 - 1).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 48, characters 9-28: *)
(*Why goal*) Lemma heapsort_po_29 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (k0: Z),
  forall (t1: (array Z)),
  forall (HW_17: (0 <= k0 /\ k0 <= ((array_length t1) - 1)) /\
                 (forall (i:Z), (0 <= i /\ i <= k0 -> (heap t1 k0 i))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) -> (access t1 0) <=
                   (access t1 (k0 + 1)))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) ->
                   (sorted_array t1 (k0 + 1) ((array_length t1) - 1)))) /\
                 (permutation t1 t)),
  forall (HW_18: k0 >= 1),
  forall (HW_19: (0 <= 0 /\ 0 < (array_length t1)) /\ 0 <= k0 /\ k0 <
                 (array_length t1)),
  forall (t2: (array Z)),
  forall (HW_20: (exchange t2 t1 0 k0)),
  (k0 - 1) < (array_length t2).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 48, characters 9-28: *)
(*Why goal*) Lemma heapsort_po_30 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (k0: Z),
  forall (t1: (array Z)),
  forall (HW_17: (0 <= k0 /\ k0 <= ((array_length t1) - 1)) /\
                 (forall (i:Z), (0 <= i /\ i <= k0 -> (heap t1 k0 i))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) -> (access t1 0) <=
                   (access t1 (k0 + 1)))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) ->
                   (sorted_array t1 (k0 + 1) ((array_length t1) - 1)))) /\
                 (permutation t1 t)),
  forall (HW_18: k0 >= 1),
  forall (HW_19: (0 <= 0 /\ 0 < (array_length t1)) /\ 0 <= k0 /\ k0 <
                 (array_length t1)),
  forall (t2: (array Z)),
  forall (HW_20: (exchange t2 t1 0 k0)),
  forall (i: Z),
  forall (HW_21: (0 + 1) <= i /\ i <= (k0 - 1)),
  (heap t2 (k0 - 1) i).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 40, characters 20-289: *)
(*Why goal*) Lemma heapsort_po_31 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (k0: Z),
  forall (t1: (array Z)),
  forall (HW_17: (0 <= k0 /\ k0 <= ((array_length t1) - 1)) /\
                 (forall (i:Z), (0 <= i /\ i <= k0 -> (heap t1 k0 i))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) -> (access t1 0) <=
                   (access t1 (k0 + 1)))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) ->
                   (sorted_array t1 (k0 + 1) ((array_length t1) - 1)))) /\
                 (permutation t1 t)),
  forall (HW_18: k0 >= 1),
  forall (HW_19: (0 <= 0 /\ 0 < (array_length t1)) /\ 0 <= k0 /\ k0 <
                 (array_length t1)),
  forall (t2: (array Z)),
  forall (HW_20: (exchange t2 t1 0 k0)),
  forall (HW_22: (0 <= 0 /\ 0 <= (k0 - 1)) /\ (k0 - 1) < (array_length t2) /\
                 (forall (i:Z),
                  ((0 + 1) <= i /\ i <= (k0 - 1) -> (heap t2 (k0 - 1) i)))),
  forall (t3: (array Z)),
  forall (HW_23: (permutation t3 t2) /\
                 (forall (i:Z),
                  (0 <= i /\ i <= (k0 - 1) -> (heap t3 (k0 - 1) i))) /\
                 (forall (i:Z),
                  (0 <= i /\ i < 0 \/ 0 < i /\ i < (2 * 0 + 1) \/ (k0 - 1) <
                   i /\ i < (array_length t3) -> (access t3 i) =
                   (access t2 i))) /\
                 (forall (v:Z),
                  ((inftree t2 (k0 - 1) v 0) -> (inftree t3 (k0 - 1) v 0)))),
  forall (k1: Z),
  forall (HW_24: k1 = (k0 - 1)),
  0 <= k1.
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 40, characters 20-289: *)
(*Why goal*) Lemma heapsort_po_32 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (k0: Z),
  forall (t1: (array Z)),
  forall (HW_17: (0 <= k0 /\ k0 <= ((array_length t1) - 1)) /\
                 (forall (i:Z), (0 <= i /\ i <= k0 -> (heap t1 k0 i))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) -> (access t1 0) <=
                   (access t1 (k0 + 1)))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) ->
                   (sorted_array t1 (k0 + 1) ((array_length t1) - 1)))) /\
                 (permutation t1 t)),
  forall (HW_18: k0 >= 1),
  forall (HW_19: (0 <= 0 /\ 0 < (array_length t1)) /\ 0 <= k0 /\ k0 <
                 (array_length t1)),
  forall (t2: (array Z)),
  forall (HW_20: (exchange t2 t1 0 k0)),
  forall (HW_22: (0 <= 0 /\ 0 <= (k0 - 1)) /\ (k0 - 1) < (array_length t2) /\
                 (forall (i:Z),
                  ((0 + 1) <= i /\ i <= (k0 - 1) -> (heap t2 (k0 - 1) i)))),
  forall (t3: (array Z)),
  forall (HW_23: (permutation t3 t2) /\
                 (forall (i:Z),
                  (0 <= i /\ i <= (k0 - 1) -> (heap t3 (k0 - 1) i))) /\
                 (forall (i:Z),
                  (0 <= i /\ i < 0 \/ 0 < i /\ i < (2 * 0 + 1) \/ (k0 - 1) <
                   i /\ i < (array_length t3) -> (access t3 i) =
                   (access t2 i))) /\
                 (forall (v:Z),
                  ((inftree t2 (k0 - 1) v 0) -> (inftree t3 (k0 - 1) v 0)))),
  forall (k1: Z),
  forall (HW_24: k1 = (k0 - 1)),
  k1 <= ((array_length t3) - 1).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 40, characters 20-289: *)
(*Why goal*) Lemma heapsort_po_33 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (k0: Z),
  forall (t1: (array Z)),
  forall (HW_17: (0 <= k0 /\ k0 <= ((array_length t1) - 1)) /\
                 (forall (i:Z), (0 <= i /\ i <= k0 -> (heap t1 k0 i))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) -> (access t1 0) <=
                   (access t1 (k0 + 1)))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) ->
                   (sorted_array t1 (k0 + 1) ((array_length t1) - 1)))) /\
                 (permutation t1 t)),
  forall (HW_18: k0 >= 1),
  forall (HW_19: (0 <= 0 /\ 0 < (array_length t1)) /\ 0 <= k0 /\ k0 <
                 (array_length t1)),
  forall (t2: (array Z)),
  forall (HW_20: (exchange t2 t1 0 k0)),
  forall (HW_22: (0 <= 0 /\ 0 <= (k0 - 1)) /\ (k0 - 1) < (array_length t2) /\
                 (forall (i:Z),
                  ((0 + 1) <= i /\ i <= (k0 - 1) -> (heap t2 (k0 - 1) i)))),
  forall (t3: (array Z)),
  forall (HW_23: (permutation t3 t2) /\
                 (forall (i:Z),
                  (0 <= i /\ i <= (k0 - 1) -> (heap t3 (k0 - 1) i))) /\
                 (forall (i:Z),
                  (0 <= i /\ i < 0 \/ 0 < i /\ i < (2 * 0 + 1) \/ (k0 - 1) <
                   i /\ i < (array_length t3) -> (access t3 i) =
                   (access t2 i))) /\
                 (forall (v:Z),
                  ((inftree t2 (k0 - 1) v 0) -> (inftree t3 (k0 - 1) v 0)))),
  forall (k1: Z),
  forall (HW_24: k1 = (k0 - 1)),
  forall (i: Z),
  forall (HW_25: 0 <= i /\ i <= k1),
  (heap t3 k1 i).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 40, characters 20-289: *)
(*Why goal*) Lemma heapsort_po_34 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (k0: Z),
  forall (t1: (array Z)),
  forall (HW_17: (0 <= k0 /\ k0 <= ((array_length t1) - 1)) /\
                 (forall (i:Z), (0 <= i /\ i <= k0 -> (heap t1 k0 i))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) -> (access t1 0) <=
                   (access t1 (k0 + 1)))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) ->
                   (sorted_array t1 (k0 + 1) ((array_length t1) - 1)))) /\
                 (permutation t1 t)),
  forall (HW_18: k0 >= 1),
  forall (HW_19: (0 <= 0 /\ 0 < (array_length t1)) /\ 0 <= k0 /\ k0 <
                 (array_length t1)),
  forall (t2: (array Z)),
  forall (HW_20: (exchange t2 t1 0 k0)),
  forall (HW_22: (0 <= 0 /\ 0 <= (k0 - 1)) /\ (k0 - 1) < (array_length t2) /\
                 (forall (i:Z),
                  ((0 + 1) <= i /\ i <= (k0 - 1) -> (heap t2 (k0 - 1) i)))),
  forall (t3: (array Z)),
  forall (HW_23: (permutation t3 t2) /\
                 (forall (i:Z),
                  (0 <= i /\ i <= (k0 - 1) -> (heap t3 (k0 - 1) i))) /\
                 (forall (i:Z),
                  (0 <= i /\ i < 0 \/ 0 < i /\ i < (2 * 0 + 1) \/ (k0 - 1) <
                   i /\ i < (array_length t3) -> (access t3 i) =
                   (access t2 i))) /\
                 (forall (v:Z),
                  ((inftree t2 (k0 - 1) v 0) -> (inftree t3 (k0 - 1) v 0)))),
  forall (k1: Z),
  forall (HW_24: k1 = (k0 - 1)),
  forall (HW_26: (k1 + 1) <= ((array_length t3) - 1)),
  (access t3 0) <= (access t3 (k1 + 1)).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 40, characters 20-289: *)
(*Why goal*) Lemma heapsort_po_35 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (k0: Z),
  forall (t1: (array Z)),
  forall (HW_17: (0 <= k0 /\ k0 <= ((array_length t1) - 1)) /\
                 (forall (i:Z), (0 <= i /\ i <= k0 -> (heap t1 k0 i))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) -> (access t1 0) <=
                   (access t1 (k0 + 1)))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) ->
                   (sorted_array t1 (k0 + 1) ((array_length t1) - 1)))) /\
                 (permutation t1 t)),
  forall (HW_18: k0 >= 1),
  forall (HW_19: (0 <= 0 /\ 0 < (array_length t1)) /\ 0 <= k0 /\ k0 <
                 (array_length t1)),
  forall (t2: (array Z)),
  forall (HW_20: (exchange t2 t1 0 k0)),
  forall (HW_22: (0 <= 0 /\ 0 <= (k0 - 1)) /\ (k0 - 1) < (array_length t2) /\
                 (forall (i:Z),
                  ((0 + 1) <= i /\ i <= (k0 - 1) -> (heap t2 (k0 - 1) i)))),
  forall (t3: (array Z)),
  forall (HW_23: (permutation t3 t2) /\
                 (forall (i:Z),
                  (0 <= i /\ i <= (k0 - 1) -> (heap t3 (k0 - 1) i))) /\
                 (forall (i:Z),
                  (0 <= i /\ i < 0 \/ 0 < i /\ i < (2 * 0 + 1) \/ (k0 - 1) <
                   i /\ i < (array_length t3) -> (access t3 i) =
                   (access t2 i))) /\
                 (forall (v:Z),
                  ((inftree t2 (k0 - 1) v 0) -> (inftree t3 (k0 - 1) v 0)))),
  forall (k1: Z),
  forall (HW_24: k1 = (k0 - 1)),
  forall (HW_27: (k1 + 1) <= ((array_length t3) - 1)),
  (sorted_array t3 (k1 + 1) ((array_length t3) - 1)).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 40, characters 20-289: *)
(*Why goal*) Lemma heapsort_po_36 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (k0: Z),
  forall (t1: (array Z)),
  forall (HW_17: (0 <= k0 /\ k0 <= ((array_length t1) - 1)) /\
                 (forall (i:Z), (0 <= i /\ i <= k0 -> (heap t1 k0 i))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) -> (access t1 0) <=
                   (access t1 (k0 + 1)))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) ->
                   (sorted_array t1 (k0 + 1) ((array_length t1) - 1)))) /\
                 (permutation t1 t)),
  forall (HW_18: k0 >= 1),
  forall (HW_19: (0 <= 0 /\ 0 < (array_length t1)) /\ 0 <= k0 /\ k0 <
                 (array_length t1)),
  forall (t2: (array Z)),
  forall (HW_20: (exchange t2 t1 0 k0)),
  forall (HW_22: (0 <= 0 /\ 0 <= (k0 - 1)) /\ (k0 - 1) < (array_length t2) /\
                 (forall (i:Z),
                  ((0 + 1) <= i /\ i <= (k0 - 1) -> (heap t2 (k0 - 1) i)))),
  forall (t3: (array Z)),
  forall (HW_23: (permutation t3 t2) /\
                 (forall (i:Z),
                  (0 <= i /\ i <= (k0 - 1) -> (heap t3 (k0 - 1) i))) /\
                 (forall (i:Z),
                  (0 <= i /\ i < 0 \/ 0 < i /\ i < (2 * 0 + 1) \/ (k0 - 1) <
                   i /\ i < (array_length t3) -> (access t3 i) =
                   (access t2 i))) /\
                 (forall (v:Z),
                  ((inftree t2 (k0 - 1) v 0) -> (inftree t3 (k0 - 1) v 0)))),
  forall (k1: Z),
  forall (HW_24: k1 = (k0 - 1)),
  (permutation t3 t).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 46, characters 18-19: *)
(*Why goal*) Lemma heapsort_po_37 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (k0: Z),
  forall (t1: (array Z)),
  forall (HW_17: (0 <= k0 /\ k0 <= ((array_length t1) - 1)) /\
                 (forall (i:Z), (0 <= i /\ i <= k0 -> (heap t1 k0 i))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) -> (access t1 0) <=
                   (access t1 (k0 + 1)))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) ->
                   (sorted_array t1 (k0 + 1) ((array_length t1) - 1)))) /\
                 (permutation t1 t)),
  forall (HW_18: k0 >= 1),
  forall (HW_19: (0 <= 0 /\ 0 < (array_length t1)) /\ 0 <= k0 /\ k0 <
                 (array_length t1)),
  forall (t2: (array Z)),
  forall (HW_20: (exchange t2 t1 0 k0)),
  forall (HW_22: (0 <= 0 /\ 0 <= (k0 - 1)) /\ (k0 - 1) < (array_length t2) /\
                 (forall (i:Z),
                  ((0 + 1) <= i /\ i <= (k0 - 1) -> (heap t2 (k0 - 1) i)))),
  forall (t3: (array Z)),
  forall (HW_23: (permutation t3 t2) /\
                 (forall (i:Z),
                  (0 <= i /\ i <= (k0 - 1) -> (heap t3 (k0 - 1) i))) /\
                 (forall (i:Z),
                  (0 <= i /\ i < 0 \/ 0 < i /\ i < (2 * 0 + 1) \/ (k0 - 1) <
                   i /\ i < (array_length t3) -> (access t3 i) =
                   (access t2 i))) /\
                 (forall (v:Z),
                  ((inftree t2 (k0 - 1) v 0) -> (inftree t3 (k0 - 1) v 0)))),
  forall (k1: Z),
  forall (HW_24: k1 = (k0 - 1)),
  0 <= k0.
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 46, characters 18-19: *)
(*Why goal*) Lemma heapsort_po_38 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (k0: Z),
  forall (t1: (array Z)),
  forall (HW_17: (0 <= k0 /\ k0 <= ((array_length t1) - 1)) /\
                 (forall (i:Z), (0 <= i /\ i <= k0 -> (heap t1 k0 i))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) -> (access t1 0) <=
                   (access t1 (k0 + 1)))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) ->
                   (sorted_array t1 (k0 + 1) ((array_length t1) - 1)))) /\
                 (permutation t1 t)),
  forall (HW_18: k0 >= 1),
  forall (HW_19: (0 <= 0 /\ 0 < (array_length t1)) /\ 0 <= k0 /\ k0 <
                 (array_length t1)),
  forall (t2: (array Z)),
  forall (HW_20: (exchange t2 t1 0 k0)),
  forall (HW_22: (0 <= 0 /\ 0 <= (k0 - 1)) /\ (k0 - 1) < (array_length t2) /\
                 (forall (i:Z),
                  ((0 + 1) <= i /\ i <= (k0 - 1) -> (heap t2 (k0 - 1) i)))),
  forall (t3: (array Z)),
  forall (HW_23: (permutation t3 t2) /\
                 (forall (i:Z),
                  (0 <= i /\ i <= (k0 - 1) -> (heap t3 (k0 - 1) i))) /\
                 (forall (i:Z),
                  (0 <= i /\ i < 0 \/ 0 < i /\ i < (2 * 0 + 1) \/ (k0 - 1) <
                   i /\ i < (array_length t3) -> (access t3 i) =
                   (access t2 i))) /\
                 (forall (v:Z),
                  ((inftree t2 (k0 - 1) v 0) -> (inftree t3 (k0 - 1) v 0)))),
  forall (k1: Z),
  forall (HW_24: k1 = (k0 - 1)),
  k1 < k0.
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 52, characters 6-66: *)
(*Why goal*) Lemma heapsort_po_39 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (k0: Z),
  forall (t1: (array Z)),
  forall (HW_17: (0 <= k0 /\ k0 <= ((array_length t1) - 1)) /\
                 (forall (i:Z), (0 <= i /\ i <= k0 -> (heap t1 k0 i))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) -> (access t1 0) <=
                   (access t1 (k0 + 1)))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) ->
                   (sorted_array t1 (k0 + 1) ((array_length t1) - 1)))) /\
                 (permutation t1 t)),
  forall (HW_28: k0 < 1),
  (sorted_array t1 0 ((array_length t1) - 1)).
Proof.
(* FILL PROOF HERE *)
Save.

(* Why obligation from file "heapsort.mlw", line 52, characters 6-66: *)
(*Why goal*) Lemma heapsort_po_40 : 
  forall (t: (array Z)),
  forall (HW_1: 1 <= (array_length t)),
  forall (result: Z),
  forall (HW_2: result = (array_length t)),
  forall (k: Z),
  forall (t0: (array Z)),
  forall (HW_4: ((-1) <= k /\ k <= ((array_length t0) - 1)) /\
                (forall (i:Z),
                 ((k + 1) <= i /\ i <= ((array_length t0) - 1) ->
                  (heap t0 ((array_length t0) - 1) i))) /\
                (permutation t0 t)),
  forall (HW_12: k < 0),
  forall (result0: Z),
  forall (HW_13: result0 = (array_length t0)),
  forall (k0: Z),
  forall (t1: (array Z)),
  forall (HW_17: (0 <= k0 /\ k0 <= ((array_length t1) - 1)) /\
                 (forall (i:Z), (0 <= i /\ i <= k0 -> (heap t1 k0 i))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) -> (access t1 0) <=
                   (access t1 (k0 + 1)))) /\
                 (((k0 + 1) <= ((array_length t1) - 1) ->
                   (sorted_array t1 (k0 + 1) ((array_length t1) - 1)))) /\
                 (permutation t1 t)),
  forall (HW_28: k0 < 1),
  (permutation t1 t).
Proof.
(* FILL PROOF HERE *)
Save.

