/*
    utils.h - tools for The WebDruid

    Copyright (C) 2003-2004 Fabien Chevalier (fabien@juliana-multimedia.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/

/* includes */

/* ensure sys/types */
#ifndef _SYS_TYPES_H
#include <sys/types.h>
#endif

#include "stdio.h"

/*********************************************/
/* SAFE_RUN                                  */
/*********************************************/

/* runs given executable savely -
   this will kill the child after timeout seconds
   if it hasn't finished yet

   if timeout equals 0, timer is disabled

   returns:
     - 0 if Ok
     - 1 if sth went wrong
*/

extern int safe_run(const char *path, char *const argv[], int timeout);

/*****************************************************************/
/* _2UTF8 converts given string from current charset to utf8     */
/*****************************************************************/

extern char * _2utf8(char * from);

/*********************************************/
/* strtolower_utf8                           */
/*********************************************/

/*
   convert an uft8 string to lower case
*/

extern void strtolower_utf8(char *utf8_str);

/*********************************************/
/* strip_spaces                              */
/*********************************************/

/*
  removes a string's trailing and leading spaces
*/

extern void strip_spaces(char** str);

/*********************************************/
/* HASH - return hash value for string       */
/*********************************************/

extern u_long hash(char *str);

/*********************************************/
/* PROGRESSIVE_HASH                          */
/*********************************************/

/*
  Calculates hash on a set of strings
  progressively.
*/

extern u_long progressive_hash(char *str, u_long hashval);

/*********************************************/
/* OPEN_OUT_FILE - Open file for output      */
/*********************************************/

extern FILE *open_out_file(char *filename);

/*********************************************/
/* OPEN_OUT_FILE_IN_DIR - does what it says  */
/*********************************************/

extern FILE *open_out_file_in_dir(const char *dir,const char *filename);

/*****************************************************************/
/*                                                               */
/* JDATE  - Julian date calculator                               */
/*                                                               */
/* Calculates the number of days since Jan 1, 0000.              */
/*                                                               */
/* Originally written by Bradford L. Barrett (03/17/1988)        */
/* Returns an unsigned long value representing the number of     */
/* days since January 1, 0000.                                   */
/*                                                               */
/* Note: Due to the changes made by Pope Gregory XIII in the     */
/*       16th Centyry (Feb 24, 1582), dates before 1583 will     */
/*       not return a truely accurate number (will be at least   */
/*       10 days off).  Somehow, I don't think this will         */
/*       present much of a problem for most situations :)        */
/*                                                               */
/* Usage: days = jdate(day, month, year)                         */
/*                                                               */
/* The number returned is adjusted by 5 to facilitate day of     */
/* week calculations.  The mod of the returned value gives the   */
/* day of the week the date is.  (ie: dow = days % 7 ) where     */
/* dow will return 0=Sunday, 1=Monday, 2=Tuesday, etc...         */
/*                                                               */
/*****************************************************************/

extern u_long jdate(int,int,int);

/* open output file    */
extern FILE  *open_out_file(char *);

/* debugging purpose   */
extern void dump_logrec();
