/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.shape;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLAppearanceChildNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseLineProperties
extends AbstractNode
implements VRMLAppearanceChildNodeType {
    protected static final int FIELD_LINEWIDTH_SCALE_FACTOR = 1;
    protected static final int FIELD_LINETYPE = 2;
    protected static final int FIELD_APPLIED = 3;
    protected static final int NUM_FIELDS = 4;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected int vfLinetype;
    protected float vfLinewidthScaleFactor;
    protected boolean vfApplied;

    protected BaseLineProperties() {
        super("LineProperties");
        this.hasChanged = new boolean[4];
        this.vfLinetype = 0;
        this.vfLinewidthScaleFactor = 0.0f;
        this.vfApplied = true;
    }

    protected BaseLineProperties(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("linewidthScaleFactor");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfLinewidthScaleFactor = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("linetype");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfLinetype = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("applied");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfApplied = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 1;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 1: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfLinewidthScaleFactor;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 2: {
                vRMLFieldData.clear();
                vRMLFieldData.intValue = this.vfLinetype;
                vRMLFieldData.dataType = (short)2;
                break;
            }
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfApplied;
                vRMLFieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfLinewidthScaleFactor);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfLinetype);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfApplied);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                this.setLineType(n2);
                break;
            }
            default: {
                super.setValue(n, n2);
            }
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                this.setApplied(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setLineWidthScale(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    protected void setLineWidthScale(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException("The linewidthScaleFactor is < 0: " + f);
        }
        this.vfLinewidthScaleFactor = f;
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    protected void setLineType(int n) throws InvalidFieldValueException {
        if (n < 1) {
            throw new InvalidFieldValueException("The linestyle is < 1: " + n);
        }
        this.vfLinetype = n;
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    protected void setApplied(boolean bl) throws InvalidFieldValueException {
        this.vfApplied = bl;
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[4];
        fieldMap = new HashMap(12);
        BaseLineProperties.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseLineProperties.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFFloat", "linewidthScaleFactor");
        BaseLineProperties.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFInt32", "linetype");
        BaseLineProperties.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFBool", "applied");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("linewidthScaleFactor", n);
        fieldMap.put("set_linewidthScaleFactor", n);
        fieldMap.put("linewidthScaleFactor_changed", n);
        n = new Integer(2);
        fieldMap.put("linetype", n);
        fieldMap.put("set_linetype", n);
        fieldMap.put("linetype_changed", n);
        n = new Integer(3);
        fieldMap.put("applied", n);
        fieldMap.put("set_applied", n);
        fieldMap.put("applied_changed", n);
    }
}

