---
layout: transform
title: Tree Transform
permalink: /docs/transforms/tree/index.html
---

The **tree** transform computes a node-link diagram layout for hierarchical data. It supports both _cluster_ layouts (for example to create [dendrograms](http://en.wikipedia.org/wiki/Dendrogram)) and _tidy_ layouts (using the method of [Reingold & Tilford](http://emr.cs.iit.edu/~reingold/tidier-drawings.pdf), as later corrected by [Buchheim _et al._](http://dirk.jivas.de/papers/buchheim02improving.pdf)). The coordinates `x` and `y` produced by the layout represent an arbitrary coordinate system; for example, you can treat x as an angle and y as a radius to produce a radial layout.

Internally, this transform processes a collection of special tree node objects generated by an upstream [nest](../nest) or [stratify](../stratify) transform. The original input data object can be accessed under the `data` field of these tree node objects. This transform uses the [d3-hierarchy library](https://github.com/d3/d3-hierarchy).

## Example

{% include embed spec="tree" %}

## Transform Parameters

| Property            | Type                           | Description   |
| :------------------ | :----------------------------: | :------------ |
| field               | {% include type t="Field" %}   | The data field corresponding to a numeric value for the node. The sum of values for a node and all its descendants is available on the node object as the `value` property. If unspecified, the layout will instead tally the counts of leaf nodes.|
| sort                | {% include type t="Compare" %} | A comparator for sorting sibling nodes. The inputs to the comparator are tree node objects, not input data objects.|
| method              | {% include type t="String" %}  | The layout method to use. One of `tidy` (the default) or `cluster`.|
| separation          | {% include type t="Boolean" %}| {% include tag ver="4.3" %} A flag indicating if node separation logic should be applied. If `true` (the default), cousin nodes will be placed farther apart than sibling nodes. If `false`, nodes will be uniformly separated, as in a standard dendrogram.|
| size                | {% include type t="Number[]" %}| The size of the layout, provided as a [width, height] array.|
| nodeSize            | {% include type t="Number[]" %}| The size of each node, provided as a [width, height] array.|
| as                  | {% include type t="String[]" %}| The output fields at which to write the layout results. The default is `["x", "y", "depth", "children"]`, where `x` and `y` are the layout coordinates, `depth` is the tree depth, and `children` is the count of a node's children in the tree.|

## Usage

```json
{
  "type": "tree",
  "method": "tidy",
  "size": [{"signal": "width"}, {"signal": "height"}]
}
```

Computes a `tidy` tree layout using the full width and height of the view.
