/* valasignal.c generated by valac, the Vala compiler
 * generated from valasignal.vala, do not modify */

/* valasignal.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaSignalPrivate {
	gboolean _is_virtual;
	ValaList* parameters;
	ValaMethod* _default_handler;
	ValaMethod* _emitter;
	gboolean lock_used;
	ValaDataType* _return_type;
	ValaBlock* _body;
};


static gpointer vala_signal_parent_class = NULL;
static ValaLockableIface * vala_signal_vala_lockable_parent_iface = NULL;
static ValaCallableIface * vala_signal_vala_callable_parent_iface = NULL;

#define VALA_SIGNAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SIGNAL, ValaSignalPrivate))
static void vala_signal_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_signal_real_get_parameters (ValaCallable* base);
static void vala_signal_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_signal_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static gboolean vala_signal_real_get_lock_used (ValaLockable* base);
static void vala_signal_real_set_lock_used (ValaLockable* base,
                                     gboolean used);
static void vala_signal_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static gboolean vala_signal_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static void vala_signal_set_default_handler (ValaSignal* self,
                                      ValaMethod* value);
static void vala_signal_set_emitter (ValaSignal* self,
                              ValaMethod* value);
static void vala_signal_finalize (ValaCodeNode * obj);


/**
 * Creates a new signal.
 *
 * @param name              signal name
 * @param return_type       signal return type
 * @param source_reference  reference to source code
 * @return                  newly created signal
 */
ValaSignal*
vala_signal_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaSignal* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaSignal*) vala_symbol_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}


ValaSignal*
vala_signal_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_signal_construct (VALA_TYPE_SIGNAL, name, return_type, source_reference, comment);
}


/**
 * Appends parameter to signal handler.
 *
 * @param param a formal parameter
 */
static void
vala_signal_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaSignal * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaSignal*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static ValaList*
vala_signal_real_get_parameters (ValaCallable* base)
{
	ValaSignal * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaSignal*) base;
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns generated delegate to be used for signal handlers.
 *
 * @return delegate
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


ValaDelegate*
vala_signal_get_delegate (ValaSignal* self,
                          ValaDataType* sender_type,
                          ValaCodeNode* node_reference)
{
	ValaDelegate* result = NULL;
	ValaDataType* actual_return_type = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDelegate* generated_delegate = NULL;
	ValaDataType* _tmp3_;
	ValaDelegate* _tmp4_;
	ValaDelegate* _tmp5_;
	ValaDelegate* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	ValaDataType* sender_param_type = NULL;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDelegate* _tmp12_;
	ValaDataType* _tmp13_;
	gboolean is_generic = FALSE;
	gboolean _tmp38_;
	ValaScope* _tmp90_;
	ValaScope* _tmp91_;
	ValaDelegate* _tmp92_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sender_type != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_data_type_get_actual_type (_tmp1_, sender_type, NULL, node_reference);
	actual_return_type = _tmp2_;
	_tmp3_ = actual_return_type;
	_tmp4_ = vala_delegate_new (NULL, _tmp3_, NULL, NULL);
	generated_delegate = _tmp4_;
	_tmp5_ = generated_delegate;
	vala_symbol_set_access ((ValaSymbol*) _tmp5_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp6_ = generated_delegate;
	_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp8_ = _tmp7_;
	vala_symbol_set_owner ((ValaSymbol*) _tmp6_, _tmp8_);
	_tmp9_ = vala_data_type_copy (sender_type);
	sender_param_type = _tmp9_;
	_tmp10_ = sender_param_type;
	vala_data_type_set_value_owned (_tmp10_, FALSE);
	_tmp11_ = sender_param_type;
	vala_data_type_set_nullable (_tmp11_, FALSE);
	_tmp12_ = generated_delegate;
	_tmp13_ = sender_param_type;
	vala_delegate_set_sender_type (_tmp12_, _tmp13_);
	is_generic = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp14_;
		ValaList* _tmp15_;
		gint _param_size = 0;
		ValaList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _param_index = 0;
		_tmp14_ = self->priv->parameters;
		_tmp15_ = _vala_iterable_ref0 (_tmp14_);
		_param_list = _tmp15_;
		_tmp16_ = _param_list;
		_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_param_size = _tmp18_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			ValaParameter* param = NULL;
			ValaList* _tmp22_;
			gint _tmp23_;
			gpointer _tmp24_;
			ValaParameter* actual_param = NULL;
			ValaParameter* _tmp25_;
			ValaParameter* _tmp26_;
			ValaParameter* _tmp27_;
			ValaParameter* _tmp28_;
			ValaDataType* _tmp29_;
			ValaDataType* _tmp30_;
			ValaDataType* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDelegate* _tmp33_;
			ValaParameter* _tmp34_;
			ValaParameter* _tmp35_;
			ValaDataType* _tmp36_;
			ValaDataType* _tmp37_;
			_tmp19_ = _param_index;
			_param_index = _tmp19_ + 1;
			_tmp20_ = _param_index;
			_tmp21_ = _param_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _param_list;
			_tmp23_ = _param_index;
			_tmp24_ = vala_list_get (_tmp22_, _tmp23_);
			param = (ValaParameter*) _tmp24_;
			_tmp25_ = param;
			_tmp26_ = vala_parameter_copy (_tmp25_);
			actual_param = _tmp26_;
			_tmp27_ = actual_param;
			_tmp28_ = actual_param;
			_tmp29_ = vala_variable_get_variable_type ((ValaVariable*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_data_type_get_actual_type (_tmp30_, sender_type, NULL, node_reference);
			_tmp32_ = _tmp31_;
			vala_variable_set_variable_type ((ValaVariable*) _tmp27_, _tmp32_);
			_vala_code_node_unref0 (_tmp32_);
			_tmp33_ = generated_delegate;
			_tmp34_ = actual_param;
			vala_callable_add_parameter ((ValaCallable*) _tmp33_, _tmp34_);
			_tmp35_ = actual_param;
			_tmp36_ = vala_variable_get_variable_type ((ValaVariable*) _tmp35_);
			_tmp37_ = _tmp36_;
			if (VALA_IS_GENERIC_TYPE (_tmp37_)) {
				is_generic = TRUE;
			}
			_vala_code_node_unref0 (actual_param);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp38_ = is_generic;
	if (_tmp38_) {
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp39_;
		ValaSymbol* _tmp40_;
		ValaObjectTypeSymbol* _tmp41_;
		_tmp39_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		cl = _tmp41_;
		{
			ValaList* _type_param_list = NULL;
			ValaObjectTypeSymbol* _tmp42_;
			ValaList* _tmp43_;
			gint _type_param_size = 0;
			ValaList* _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			gint _type_param_index = 0;
			_tmp42_ = cl;
			_tmp43_ = vala_object_type_symbol_get_type_parameters (_tmp42_);
			_type_param_list = _tmp43_;
			_tmp44_ = _type_param_list;
			_tmp45_ = vala_collection_get_size ((ValaCollection*) _tmp44_);
			_tmp46_ = _tmp45_;
			_type_param_size = _tmp46_;
			_type_param_index = -1;
			while (TRUE) {
				gint _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				ValaTypeParameter* type_param = NULL;
				ValaList* _tmp50_;
				gint _tmp51_;
				gpointer _tmp52_;
				ValaDelegate* _tmp53_;
				ValaTypeParameter* _tmp54_;
				const gchar* _tmp55_;
				const gchar* _tmp56_;
				ValaTypeParameter* _tmp57_;
				ValaSourceReference* _tmp58_;
				ValaSourceReference* _tmp59_;
				ValaTypeParameter* _tmp60_;
				ValaTypeParameter* _tmp61_;
				_tmp47_ = _type_param_index;
				_type_param_index = _tmp47_ + 1;
				_tmp48_ = _type_param_index;
				_tmp49_ = _type_param_size;
				if (!(_tmp48_ < _tmp49_)) {
					break;
				}
				_tmp50_ = _type_param_list;
				_tmp51_ = _type_param_index;
				_tmp52_ = vala_list_get (_tmp50_, _tmp51_);
				type_param = (ValaTypeParameter*) _tmp52_;
				_tmp53_ = generated_delegate;
				_tmp54_ = type_param;
				_tmp55_ = vala_symbol_get_name ((ValaSymbol*) _tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = type_param;
				_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = vala_typeparameter_new (_tmp56_, _tmp59_);
				_tmp61_ = _tmp60_;
				vala_delegate_add_type_parameter (_tmp53_, _tmp61_);
				_vala_code_node_unref0 (_tmp61_);
				_vala_code_node_unref0 (type_param);
			}
			_vala_iterable_unref0 (_type_param_list);
		}
		{
			ValaList* _param_list = NULL;
			ValaDelegate* _tmp62_;
			ValaList* _tmp63_;
			gint _param_size = 0;
			ValaList* _tmp64_;
			gint _tmp65_;
			gint _tmp66_;
			gint _param_index = 0;
			_tmp62_ = generated_delegate;
			_tmp63_ = vala_callable_get_parameters ((ValaCallable*) _tmp62_);
			_param_list = _tmp63_;
			_tmp64_ = _param_list;
			_tmp65_ = vala_collection_get_size ((ValaCollection*) _tmp64_);
			_tmp66_ = _tmp65_;
			_param_size = _tmp66_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp67_;
				gint _tmp68_;
				gint _tmp69_;
				ValaParameter* param = NULL;
				ValaList* _tmp70_;
				gint _tmp71_;
				gpointer _tmp72_;
				ValaGenericType* generic_type = NULL;
				ValaParameter* _tmp73_;
				ValaDataType* _tmp74_;
				ValaDataType* _tmp75_;
				ValaGenericType* _tmp76_;
				ValaGenericType* _tmp77_;
				_tmp67_ = _param_index;
				_param_index = _tmp67_ + 1;
				_tmp68_ = _param_index;
				_tmp69_ = _param_size;
				if (!(_tmp68_ < _tmp69_)) {
					break;
				}
				_tmp70_ = _param_list;
				_tmp71_ = _param_index;
				_tmp72_ = vala_list_get (_tmp70_, _tmp71_);
				param = (ValaParameter*) _tmp72_;
				_tmp73_ = param;
				_tmp74_ = vala_variable_get_variable_type ((ValaVariable*) _tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp75_) ? ((ValaGenericType*) _tmp75_) : NULL);
				generic_type = _tmp76_;
				_tmp77_ = generic_type;
				if (_tmp77_ != NULL) {
					ValaGenericType* _tmp78_;
					ValaDelegate* _tmp79_;
					ValaList* _tmp80_;
					ValaList* _tmp81_;
					ValaDelegate* _tmp82_;
					ValaGenericType* _tmp83_;
					ValaTypeParameter* _tmp84_;
					ValaTypeParameter* _tmp85_;
					const gchar* _tmp86_;
					const gchar* _tmp87_;
					gpointer _tmp88_;
					ValaTypeParameter* _tmp89_;
					_tmp78_ = generic_type;
					_tmp79_ = generated_delegate;
					_tmp80_ = vala_delegate_get_type_parameters (_tmp79_);
					_tmp81_ = _tmp80_;
					_tmp82_ = generated_delegate;
					_tmp83_ = generic_type;
					_tmp84_ = vala_generic_type_get_type_parameter (_tmp83_);
					_tmp85_ = _tmp84_;
					_tmp86_ = vala_symbol_get_name ((ValaSymbol*) _tmp85_);
					_tmp87_ = _tmp86_;
					_tmp88_ = vala_list_get (_tmp81_, vala_typesymbol_get_type_parameter_index ((ValaTypeSymbol*) _tmp82_, _tmp87_));
					_tmp89_ = (ValaTypeParameter*) _tmp88_;
					vala_generic_type_set_type_parameter (_tmp78_, _tmp89_);
					_vala_code_node_unref0 (_tmp89_);
					_vala_iterable_unref0 (_tmp81_);
				}
				_vala_code_node_unref0 (generic_type);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp90_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp91_ = _tmp90_;
	_tmp92_ = generated_delegate;
	vala_scope_add (_tmp91_, NULL, (ValaSymbol*) _tmp92_);
	result = generated_delegate;
	_vala_code_node_unref0 (sender_param_type);
	_vala_code_node_unref0 (actual_return_type);
	return result;
}


static void
vala_signal_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaSignal * self;
	self = (ValaSignal*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_signal (visitor, self);
}


static void
vala_signal_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaSignal * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	gboolean _tmp14_ = FALSE;
	ValaMethod* _tmp15_;
	ValaMethod* _tmp22_;
	self = (ValaSignal*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _param_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _param_index = 0;
		_tmp2_ = self->priv->parameters;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_param_list = _tmp3_;
		_tmp4_ = _param_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_param_size = _tmp6_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaParameter* param = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaParameter* _tmp13_;
			_tmp7_ = _param_index;
			_param_index = _tmp7_ + 1;
			_tmp8_ = _param_index;
			_tmp9_ = _param_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _param_list;
			_tmp11_ = _param_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			param = (ValaParameter*) _tmp12_;
			_tmp13_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp15_ = self->priv->_default_handler;
	if (_tmp15_ == NULL) {
		ValaBlock* _tmp16_;
		ValaBlock* _tmp17_;
		_tmp16_ = vala_signal_get_body (self);
		_tmp17_ = _tmp16_;
		_tmp14_ = _tmp17_ != NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		ValaBlock* _tmp18_;
		ValaBlock* _tmp19_;
		_tmp18_ = vala_signal_get_body (self);
		_tmp19_ = _tmp18_;
		vala_code_node_accept ((ValaCodeNode*) _tmp19_, visitor);
	} else {
		ValaMethod* _tmp20_;
		_tmp20_ = self->priv->_default_handler;
		if (_tmp20_ != NULL) {
			ValaMethod* _tmp21_;
			_tmp21_ = self->priv->_default_handler;
			vala_code_node_accept ((ValaCodeNode*) _tmp21_, visitor);
		}
	}
	_tmp22_ = self->priv->_emitter;
	if (_tmp22_ != NULL) {
		ValaMethod* _tmp23_;
		_tmp23_ = self->priv->_emitter;
		vala_code_node_accept ((ValaCodeNode*) _tmp23_, visitor);
	}
}


static gboolean
vala_signal_real_get_lock_used (ValaLockable* base)
{
	ValaSignal * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (ValaSignal*) base;
	_tmp0_ = self->priv->lock_used;
	result = _tmp0_;
	return result;
}


static void
vala_signal_real_set_lock_used (ValaLockable* base,
                                gboolean used)
{
	ValaSignal * self;
	self = (ValaSignal*) base;
	self->priv->lock_used = used;
}


static void
vala_signal_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaSignal * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaSignal*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
	}
}


static gboolean
vala_signal_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaSignal * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaTypeSymbol* _tmp8_;
	ValaTypeSymbol* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaDataType* _tmp12_;
	ValaTypeSymbol* _tmp13_;
	ValaTypeSymbol* _tmp14_;
	gboolean _tmp43_ = FALSE;
	gboolean _tmp44_;
	gboolean _tmp49_;
	gboolean _tmp94_ = FALSE;
	gboolean _tmp95_;
	gboolean _tmp96_;
	gboolean _tmp169_ = FALSE;
	gboolean _tmp170_ = FALSE;
	gboolean _tmp171_;
	gboolean _tmp172_;
	gboolean _tmp187_;
	gboolean _tmp188_;
	self = (ValaSignal*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp5_ = _tmp4_;
	vala_code_node_check ((ValaCodeNode*) _tmp5_, context);
	_tmp6_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_data_type_get_data_type (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_code_context_get_analyzer (context);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_->va_list_type;
	_tmp13_ = vala_data_type_get_data_type (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp9_ == _tmp14_) {
		ValaSourceReference* _tmp15_;
		ValaSourceReference* _tmp16_;
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp15_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_data_type_get_data_type (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strdup_printf ("`%s' not supported as return type", _tmp22_);
		_tmp24_ = _tmp23_;
		vala_report_error (_tmp16_, _tmp24_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		result = FALSE;
		return result;
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp25_;
		ValaList* _tmp26_;
		gint _param_size = 0;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _param_index = 0;
		_tmp25_ = self->priv->parameters;
		_tmp26_ = _vala_iterable_ref0 (_tmp25_);
		_param_list = _tmp26_;
		_tmp27_ = _param_list;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_param_size = _tmp29_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			ValaParameter* param = NULL;
			ValaList* _tmp33_;
			gint _tmp34_;
			gpointer _tmp35_;
			ValaParameter* _tmp36_;
			gboolean _tmp37_;
			gboolean _tmp38_;
			ValaParameter* _tmp42_;
			_tmp30_ = _param_index;
			_param_index = _tmp30_ + 1;
			_tmp31_ = _param_index;
			_tmp32_ = _param_size;
			if (!(_tmp31_ < _tmp32_)) {
				break;
			}
			_tmp33_ = _param_list;
			_tmp34_ = _param_index;
			_tmp35_ = vala_list_get (_tmp33_, _tmp34_);
			param = (ValaParameter*) _tmp35_;
			_tmp36_ = param;
			_tmp37_ = vala_parameter_get_ellipsis (_tmp36_);
			_tmp38_ = _tmp37_;
			if (_tmp38_) {
				ValaParameter* _tmp39_;
				ValaSourceReference* _tmp40_;
				ValaSourceReference* _tmp41_;
				_tmp39_ = param;
				_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp39_);
				_tmp41_ = _tmp40_;
				vala_report_error (_tmp41_, "Signals with variable argument lists are not supported");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_tmp42_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp42_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp44_ = self->priv->_is_virtual;
	if (!_tmp44_) {
		ValaBlock* _tmp45_;
		ValaBlock* _tmp46_;
		_tmp45_ = vala_signal_get_body (self);
		_tmp46_ = _tmp45_;
		_tmp43_ = _tmp46_ != NULL;
	} else {
		_tmp43_ = FALSE;
	}
	if (_tmp43_) {
		ValaSourceReference* _tmp47_;
		ValaSourceReference* _tmp48_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp47_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp48_ = _tmp47_;
		vala_report_error (_tmp48_, "Only virtual signals can have a default signal handler body");
	}
	_tmp49_ = self->priv->_is_virtual;
	if (_tmp49_) {
		const gchar* _tmp50_;
		const gchar* _tmp51_;
		ValaDataType* _tmp52_;
		ValaDataType* _tmp53_;
		ValaSourceReference* _tmp54_;
		ValaSourceReference* _tmp55_;
		ValaMethod* _tmp56_;
		ValaMethod* _tmp57_;
		ValaMethod* _tmp58_;
		ValaScope* _tmp59_;
		ValaScope* _tmp60_;
		ValaMethod* _tmp61_;
		ValaSymbolAccessibility _tmp62_;
		ValaSymbolAccessibility _tmp63_;
		ValaMethod* _tmp64_;
		gboolean _tmp65_;
		gboolean _tmp66_;
		ValaMethod* _tmp67_;
		gboolean _tmp68_;
		gboolean _tmp69_;
		ValaMethod* _tmp70_;
		ValaMethod* _tmp71_;
		ValaMethod* _tmp72_;
		ValaBlock* _tmp73_;
		ValaBlock* _tmp74_;
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp88_;
		ValaSymbol* _tmp89_;
		ValaObjectTypeSymbol* _tmp90_;
		ValaObjectTypeSymbol* _tmp91_;
		ValaMethod* _tmp92_;
		ValaMethod* _tmp93_;
		_tmp50_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp51_ = _tmp50_;
		_tmp52_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp55_ = _tmp54_;
		_tmp56_ = vala_method_new (_tmp51_, _tmp53_, _tmp55_, NULL);
		_tmp57_ = _tmp56_;
		vala_signal_set_default_handler (self, _tmp57_);
		_vala_code_node_unref0 (_tmp57_);
		_tmp58_ = self->priv->_default_handler;
		_tmp59_ = vala_symbol_get_owner ((ValaSymbol*) self);
		_tmp60_ = _tmp59_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp58_, _tmp60_);
		_tmp61_ = self->priv->_default_handler;
		_tmp62_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp63_ = _tmp62_;
		vala_symbol_set_access ((ValaSymbol*) _tmp61_, _tmp63_);
		_tmp64_ = self->priv->_default_handler;
		_tmp65_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp66_ = _tmp65_;
		vala_symbol_set_external ((ValaSymbol*) _tmp64_, _tmp66_);
		_tmp67_ = self->priv->_default_handler;
		_tmp68_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp69_ = _tmp68_;
		vala_symbol_set_hides ((ValaSymbol*) _tmp67_, _tmp69_);
		_tmp70_ = self->priv->_default_handler;
		vala_method_set_is_virtual (_tmp70_, TRUE);
		_tmp71_ = self->priv->_default_handler;
		vala_method_set_signal_reference (_tmp71_, self);
		_tmp72_ = self->priv->_default_handler;
		_tmp73_ = vala_signal_get_body (self);
		_tmp74_ = _tmp73_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp72_, _tmp74_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp75_;
			ValaList* _tmp76_;
			gint _param_size = 0;
			ValaList* _tmp77_;
			gint _tmp78_;
			gint _tmp79_;
			gint _param_index = 0;
			_tmp75_ = self->priv->parameters;
			_tmp76_ = _vala_iterable_ref0 (_tmp75_);
			_param_list = _tmp76_;
			_tmp77_ = _param_list;
			_tmp78_ = vala_collection_get_size ((ValaCollection*) _tmp77_);
			_tmp79_ = _tmp78_;
			_param_size = _tmp79_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp80_;
				gint _tmp81_;
				gint _tmp82_;
				ValaParameter* param = NULL;
				ValaList* _tmp83_;
				gint _tmp84_;
				gpointer _tmp85_;
				ValaMethod* _tmp86_;
				ValaParameter* _tmp87_;
				_tmp80_ = _param_index;
				_param_index = _tmp80_ + 1;
				_tmp81_ = _param_index;
				_tmp82_ = _param_size;
				if (!(_tmp81_ < _tmp82_)) {
					break;
				}
				_tmp83_ = _param_list;
				_tmp84_ = _param_index;
				_tmp85_ = vala_list_get (_tmp83_, _tmp84_);
				param = (ValaParameter*) _tmp85_;
				_tmp86_ = self->priv->_default_handler;
				_tmp87_ = param;
				vala_callable_add_parameter ((ValaCallable*) _tmp86_, _tmp87_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp88_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp89_ = _tmp88_;
		_tmp90_ = _vala_code_node_ref0 (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp89_) ? ((ValaObjectTypeSymbol*) _tmp89_) : NULL);
		cl = _tmp90_;
		_tmp91_ = cl;
		_tmp92_ = self->priv->_default_handler;
		vala_object_type_symbol_add_hidden_method (_tmp91_, _tmp92_);
		_tmp93_ = self->priv->_default_handler;
		vala_code_node_check ((ValaCodeNode*) _tmp93_, context);
		_vala_code_node_unref0 (cl);
	}
	_tmp95_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp96_ = _tmp95_;
	if (!_tmp96_) {
		ValaAttribute* _tmp97_;
		ValaAttribute* _tmp98_;
		_tmp97_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "HasEmitter");
		_tmp98_ = _tmp97_;
		_tmp94_ = _tmp98_ != NULL;
		_vala_code_node_unref0 (_tmp98_);
	} else {
		_tmp94_ = FALSE;
	}
	if (_tmp94_) {
		const gchar* _tmp99_;
		const gchar* _tmp100_;
		ValaDataType* _tmp101_;
		ValaDataType* _tmp102_;
		ValaSourceReference* _tmp103_;
		ValaSourceReference* _tmp104_;
		ValaMethod* _tmp105_;
		ValaMethod* _tmp106_;
		ValaMethod* _tmp107_;
		ValaScope* _tmp108_;
		ValaScope* _tmp109_;
		ValaMethod* _tmp110_;
		ValaSymbolAccessibility _tmp111_;
		ValaSymbolAccessibility _tmp112_;
		ValaBlock* body = NULL;
		ValaSourceReference* _tmp113_;
		ValaSourceReference* _tmp114_;
		ValaBlock* _tmp115_;
		ValaMethodCall* call = NULL;
		const gchar* _tmp116_;
		const gchar* _tmp117_;
		ValaSourceReference* _tmp118_;
		ValaSourceReference* _tmp119_;
		ValaMemberAccess* _tmp120_;
		ValaMemberAccess* _tmp121_;
		ValaSourceReference* _tmp122_;
		ValaSourceReference* _tmp123_;
		ValaMethodCall* _tmp124_;
		ValaMethodCall* _tmp125_;
		ValaDataType* _tmp147_;
		ValaDataType* _tmp148_;
		ValaMethod* _tmp161_;
		ValaBlock* _tmp162_;
		ValaObjectTypeSymbol* cl = NULL;
		ValaSymbol* _tmp163_;
		ValaSymbol* _tmp164_;
		ValaObjectTypeSymbol* _tmp165_;
		ValaObjectTypeSymbol* _tmp166_;
		ValaMethod* _tmp167_;
		ValaMethod* _tmp168_;
		_tmp99_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp100_ = _tmp99_;
		_tmp101_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp102_ = _tmp101_;
		_tmp103_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp104_ = _tmp103_;
		_tmp105_ = vala_method_new (_tmp100_, _tmp102_, _tmp104_, NULL);
		_tmp106_ = _tmp105_;
		vala_signal_set_emitter (self, _tmp106_);
		_vala_code_node_unref0 (_tmp106_);
		_tmp107_ = self->priv->_emitter;
		_tmp108_ = vala_symbol_get_owner ((ValaSymbol*) self);
		_tmp109_ = _tmp108_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp107_, _tmp109_);
		_tmp110_ = self->priv->_emitter;
		_tmp111_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp112_ = _tmp111_;
		vala_symbol_set_access ((ValaSymbol*) _tmp110_, _tmp112_);
		_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_block_new (_tmp114_);
		body = _tmp115_;
		_tmp116_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp117_ = _tmp116_;
		_tmp118_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp119_ = _tmp118_;
		_tmp120_ = vala_member_access_new_simple (_tmp117_, _tmp119_);
		_tmp121_ = _tmp120_;
		_tmp122_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp123_ = _tmp122_;
		_tmp124_ = vala_method_call_new ((ValaExpression*) _tmp121_, _tmp123_);
		_tmp125_ = _tmp124_;
		_vala_code_node_unref0 (_tmp121_);
		call = _tmp125_;
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp126_;
			ValaList* _tmp127_;
			gint _param_size = 0;
			ValaList* _tmp128_;
			gint _tmp129_;
			gint _tmp130_;
			gint _param_index = 0;
			_tmp126_ = self->priv->parameters;
			_tmp127_ = _vala_iterable_ref0 (_tmp126_);
			_param_list = _tmp127_;
			_tmp128_ = _param_list;
			_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
			_tmp130_ = _tmp129_;
			_param_size = _tmp130_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp131_;
				gint _tmp132_;
				gint _tmp133_;
				ValaParameter* param = NULL;
				ValaList* _tmp134_;
				gint _tmp135_;
				gpointer _tmp136_;
				ValaMethod* _tmp137_;
				ValaParameter* _tmp138_;
				ValaMethodCall* _tmp139_;
				ValaParameter* _tmp140_;
				const gchar* _tmp141_;
				const gchar* _tmp142_;
				ValaSourceReference* _tmp143_;
				ValaSourceReference* _tmp144_;
				ValaMemberAccess* _tmp145_;
				ValaMemberAccess* _tmp146_;
				_tmp131_ = _param_index;
				_param_index = _tmp131_ + 1;
				_tmp132_ = _param_index;
				_tmp133_ = _param_size;
				if (!(_tmp132_ < _tmp133_)) {
					break;
				}
				_tmp134_ = _param_list;
				_tmp135_ = _param_index;
				_tmp136_ = vala_list_get (_tmp134_, _tmp135_);
				param = (ValaParameter*) _tmp136_;
				_tmp137_ = self->priv->_emitter;
				_tmp138_ = param;
				vala_callable_add_parameter ((ValaCallable*) _tmp137_, _tmp138_);
				_tmp139_ = call;
				_tmp140_ = param;
				_tmp141_ = vala_symbol_get_name ((ValaSymbol*) _tmp140_);
				_tmp142_ = _tmp141_;
				_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp144_ = _tmp143_;
				_tmp145_ = vala_member_access_new_simple (_tmp142_, _tmp144_);
				_tmp146_ = _tmp145_;
				vala_method_call_add_argument (_tmp139_, (ValaExpression*) _tmp146_);
				_vala_code_node_unref0 (_tmp146_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp147_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp148_ = _tmp147_;
		if (VALA_IS_VOID_TYPE (_tmp148_)) {
			ValaBlock* _tmp149_;
			ValaMethodCall* _tmp150_;
			ValaSourceReference* _tmp151_;
			ValaSourceReference* _tmp152_;
			ValaExpressionStatement* _tmp153_;
			ValaExpressionStatement* _tmp154_;
			_tmp149_ = body;
			_tmp150_ = call;
			_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp152_ = _tmp151_;
			_tmp153_ = vala_expression_statement_new ((ValaExpression*) _tmp150_, _tmp152_);
			_tmp154_ = _tmp153_;
			vala_block_add_statement (_tmp149_, (ValaStatement*) _tmp154_);
			_vala_code_node_unref0 (_tmp154_);
		} else {
			ValaBlock* _tmp155_;
			ValaMethodCall* _tmp156_;
			ValaSourceReference* _tmp157_;
			ValaSourceReference* _tmp158_;
			ValaReturnStatement* _tmp159_;
			ValaReturnStatement* _tmp160_;
			_tmp155_ = body;
			_tmp156_ = call;
			_tmp157_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp158_ = _tmp157_;
			_tmp159_ = vala_return_statement_new ((ValaExpression*) _tmp156_, _tmp158_);
			_tmp160_ = _tmp159_;
			vala_block_add_statement (_tmp155_, (ValaStatement*) _tmp160_);
			_vala_code_node_unref0 (_tmp160_);
		}
		_tmp161_ = self->priv->_emitter;
		_tmp162_ = body;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp161_, _tmp162_);
		_tmp163_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp164_ = _tmp163_;
		_tmp165_ = _vala_code_node_ref0 (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp164_) ? ((ValaObjectTypeSymbol*) _tmp164_) : NULL);
		cl = _tmp165_;
		_tmp166_ = cl;
		_tmp167_ = self->priv->_emitter;
		vala_object_type_symbol_add_hidden_method (_tmp166_, _tmp167_);
		_tmp168_ = self->priv->_emitter;
		vala_code_node_check ((ValaCodeNode*) _tmp168_, context);
		_vala_code_node_unref0 (cl);
		_vala_code_node_unref0 (call);
		_vala_code_node_unref0 (body);
	}
	_tmp171_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp172_ = _tmp171_;
	if (!_tmp172_) {
		gboolean _tmp173_;
		gboolean _tmp174_;
		_tmp173_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp174_ = _tmp173_;
		_tmp170_ = !_tmp174_;
	} else {
		_tmp170_ = FALSE;
	}
	if (_tmp170_) {
		ValaSymbol* _tmp175_;
		ValaSymbol* _tmp176_;
		_tmp175_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp176_ = _tmp175_;
		_tmp169_ = _tmp176_ != NULL;
		_vala_code_node_unref0 (_tmp176_);
	} else {
		_tmp169_ = FALSE;
	}
	if (_tmp169_) {
		ValaSourceReference* _tmp177_;
		ValaSourceReference* _tmp178_;
		gchar* _tmp179_;
		gchar* _tmp180_;
		ValaSymbol* _tmp181_;
		ValaSymbol* _tmp182_;
		gchar* _tmp183_;
		gchar* _tmp184_;
		gchar* _tmp185_;
		gchar* _tmp186_;
		_tmp177_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp178_ = _tmp177_;
		_tmp179_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp180_ = _tmp179_;
		_tmp181_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp182_ = _tmp181_;
		_tmp183_ = vala_symbol_get_full_name (_tmp182_);
		_tmp184_ = _tmp183_;
		_tmp185_ = g_strdup_printf ("%s hides inherited signal `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp180_, _tmp184_);
		_tmp186_ = _tmp185_;
		vala_report_warning (_tmp178_, _tmp186_);
		_g_free0 (_tmp186_);
		_g_free0 (_tmp184_);
		_vala_code_node_unref0 (_tmp182_);
		_g_free0 (_tmp180_);
	}
	_tmp187_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp188_ = _tmp187_;
	result = !_tmp188_;
	return result;
}


static ValaDataType*
vala_signal_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaSignal* self;
	ValaDataType* _tmp0_;
	self = (ValaSignal*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}


static void
vala_signal_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaSignal* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaSignal*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaBlock*
vala_signal_get_body (ValaSignal* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}


void
vala_signal_set_body (ValaSignal* self,
                      ValaBlock* value)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp0_;
	_tmp1_ = self->priv->_body;
	if (_tmp1_ != NULL) {
		ValaBlock* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_body;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


gboolean
vala_signal_get_is_virtual (ValaSignal* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_virtual;
	result = _tmp0_;
	return result;
}


void
vala_signal_set_is_virtual (ValaSignal* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}


ValaMethod*
vala_signal_get_default_handler (ValaSignal* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_handler;
	result = _tmp0_;
	return result;
}


static void
vala_signal_set_default_handler (ValaSignal* self,
                                 ValaMethod* value)
{
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_handler);
	self->priv->_default_handler = _tmp0_;
}


ValaMethod*
vala_signal_get_emitter (ValaSignal* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_emitter;
	result = _tmp0_;
	return result;
}


static void
vala_signal_set_emitter (ValaSignal* self,
                         ValaMethod* value)
{
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_emitter);
	self->priv->_emitter = _tmp0_;
}


static void
vala_signal_class_init (ValaSignalClass * klass)
{
	vala_signal_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_signal_finalize;
	g_type_class_add_private (klass, sizeof (ValaSignalPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_signal_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_signal_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_signal_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_signal_real_check;
}


static void
vala_signal_vala_lockable_interface_init (ValaLockableIface * iface)
{
	vala_signal_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = (gboolean (*) (ValaLockable*)) vala_signal_real_get_lock_used;
	iface->set_lock_used = (void (*) (ValaLockable*, gboolean)) vala_signal_real_set_lock_used;
}


static void
vala_signal_vala_callable_interface_init (ValaCallableIface * iface)
{
	vala_signal_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_signal_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_signal_real_get_parameters;
	iface->get_return_type = vala_signal_real_get_return_type;
	iface->set_return_type = vala_signal_real_set_return_type;
}


static void
vala_signal_instance_init (ValaSignal * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_SIGNAL_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
	self->priv->lock_used = FALSE;
}


static void
vala_signal_finalize (ValaCodeNode * obj)
{
	ValaSignal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SIGNAL, ValaSignal);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_code_node_unref0 (self->priv->_default_handler);
	_vala_code_node_unref0 (self->priv->_emitter);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_code_node_unref0 (self->priv->_body);
	VALA_CODE_NODE_CLASS (vala_signal_parent_class)->finalize (obj);
}


/**
 * Represents an object signal. Signals enable objects to provide notifications.
 */
GType
vala_signal_get_type (void)
{
	static volatile gsize vala_signal_type_id__volatile = 0;
	if (g_once_init_enter (&vala_signal_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSignalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_signal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSignal), 0, (GInstanceInitFunc) vala_signal_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_signal_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_signal_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_signal_type_id;
		vala_signal_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaSignal", &g_define_type_info, 0);
		g_type_add_interface_static (vala_signal_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		g_type_add_interface_static (vala_signal_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
		g_once_init_leave (&vala_signal_type_id__volatile, vala_signal_type_id);
	}
	return vala_signal_type_id__volatile;
}



