// SPDX-License-Identifier: GPL-2.0+
/*
 * Copyright 2010-2011 Freescale Semiconductor, Inc.
 */

#include <common.h>
#include <asm/mmu.h>

struct fsl_e_tlb_entry tlb_table[] = {
	/* TLB 0 - for temp stack in cache */
	SET_TLB_ENTRY(0, CFG_SYS_INIT_RAM_ADDR, CFG_SYS_INIT_RAM_ADDR,
			MAS3_SX|MAS3_SW|MAS3_SR, 0,
			0, 0, BOOKE_PAGESZ_4K, 0),
	SET_TLB_ENTRY(0, CFG_SYS_INIT_RAM_ADDR + 4 * 1024 ,
			CFG_SYS_INIT_RAM_ADDR + 4 * 1024,
			MAS3_SX|MAS3_SW|MAS3_SR, 0,
			0, 0, BOOKE_PAGESZ_4K, 0),
	SET_TLB_ENTRY(0, CFG_SYS_INIT_RAM_ADDR + 8 * 1024 ,
			CFG_SYS_INIT_RAM_ADDR + 8 * 1024,
			MAS3_SX|MAS3_SW|MAS3_SR, 0,
			0, 0, BOOKE_PAGESZ_4K, 0),
	SET_TLB_ENTRY(0, CFG_SYS_INIT_RAM_ADDR + 12 * 1024 ,
			CFG_SYS_INIT_RAM_ADDR + 12 * 1024,
			MAS3_SX|MAS3_SW|MAS3_SR, 0,
			0, 0, BOOKE_PAGESZ_4K, 0),

	/* TLB 1 */
	/* *I*** - Covers boot page */
	SET_TLB_ENTRY(1, 0xfffff000, 0xfffff000,
		      MAS3_SX|MAS3_SW|MAS3_SR, MAS2_I|MAS2_G,
		      0, 0, BOOKE_PAGESZ_4K, 1),
#ifdef CONFIG_SPL_NAND_BOOT
	SET_TLB_ENTRY(1, 0xffffe000, 0xffffe000,
		      MAS3_SX|MAS3_SW|MAS3_SR, MAS2_I|MAS2_G,
		      0, 10, BOOKE_PAGESZ_4K, 1),
#endif

	/* *I*G* - CCSRBAR */
	SET_TLB_ENTRY(1, CFG_SYS_CCSRBAR, CFG_SYS_CCSRBAR_PHYS,
			MAS3_SW|MAS3_SR, MAS2_I|MAS2_G,
			0, 1, BOOKE_PAGESZ_1M, 1),

#ifndef CONFIG_SPL_BUILD
	SET_TLB_ENTRY(1, CFG_SYS_FLASH_BASE, CFG_SYS_FLASH_BASE_PHYS,
			MAS3_SX|MAS3_SR, MAS2_W|MAS2_G,
			0, 2, BOOKE_PAGESZ_16M, 1),

	SET_TLB_ENTRY(1, CFG_SYS_FLASH_BASE + 0x1000000,
			CFG_SYS_FLASH_BASE_PHYS + 0x1000000,
			MAS3_SX|MAS3_SR, MAS2_W|MAS2_G,
			0, 3, BOOKE_PAGESZ_16M, 1),

#ifdef CONFIG_PCI
	/* *I*G* - PCI */
	SET_TLB_ENTRY(1, CFG_SYS_PCIE1_MEM_VIRT, CFG_SYS_PCIE1_MEM_PHYS,
			MAS3_SW|MAS3_SR, MAS2_I|MAS2_G,
			0, 4, BOOKE_PAGESZ_1G, 1),

	/* *I*G* - PCI I/O */
	SET_TLB_ENTRY(1, CFG_SYS_PCIE1_IO_VIRT, CFG_SYS_PCIE1_IO_PHYS,
			MAS3_SW|MAS3_SR, MAS2_I|MAS2_G,
			0, 5, BOOKE_PAGESZ_256K, 1),
#endif
#endif

	/* *I*G - Board CPLD  */
	SET_TLB_ENTRY(1, CFG_SYS_CPLD_BASE, CFG_SYS_CPLD_BASE_PHYS,
			MAS3_SW|MAS3_SR, MAS2_I|MAS2_G,
			0, 6, BOOKE_PAGESZ_256K, 1),

	SET_TLB_ENTRY(1, CFG_SYS_NAND_BASE, CFG_SYS_NAND_BASE_PHYS,
			MAS3_SX|MAS3_SW|MAS3_SR, MAS2_I|MAS2_G,
			0, 7, BOOKE_PAGESZ_1M, 1),

#if defined(CONFIG_SYS_RAMBOOT) || !CONFIG_IS_ENABLED(COMMON_INIT_DDR)
	SET_TLB_ENTRY(1, CFG_SYS_DDR_SDRAM_BASE, CFG_SYS_DDR_SDRAM_BASE,
			MAS3_SX|MAS3_SW|MAS3_SR, MAS2_M,
			0, 8, BOOKE_PAGESZ_1G, 1),
#endif

#ifdef CFG_SYS_INIT_L2_ADDR
	/* *I*G - L2SRAM */
	SET_TLB_ENTRY(1, CFG_SYS_INIT_L2_ADDR, CFG_SYS_INIT_L2_ADDR_PHYS,
		      MAS3_SX|MAS3_SW|MAS3_SR, MAS2_G,
		      0, 11, BOOKE_PAGESZ_256K, 1)
#endif
};

int num_tlb_entries = ARRAY_SIZE(tlb_table);
