---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, mots, typographie, fi, ffi, 
              ligature esthétique, fontspec
---

# Comment empêcher une ligature ?

C'est un point fort de TeX : certains couples de lettres sont automatiquement
remplacés par un glyphe unique, pour des raisons esthétiques, 
comme cela se fait en imprimerie au plomb. Par exemple quand un `f` et un `i` 
se suivent, le haut du `f` aurait normalement tendance à mordre sur le point 
du `i`, ce qui ne serait pas très beau. TeX les remplace donc 
par un nouveau glyphe plus joli. Cette fusion de glyphes est une
[ligature](wpfr:Ligature_(écriture)) :

| Sans ligature                               | Avec ligature                               |
|:--------------------------------------------|:--------------------------------------------|
| ![alt](/_static/images/ligatures-0.png)     | ![alt](/_static/images/ligatures-1.png)     |


Le principe de ligature sert pour d'autres cas, par exemple :
- les caractères espagnols ¡ et ¿, obtenus 
  avec la saisie ````!` ```` et ````?` ````.
- dans les polices cyrilliques utilisées avec l'encodage OT2, le couple 
  de lettres `sh` produira le glyphe ш.


## Empêcher ponctuellement une ligature

Pour empêcher une ligature, il suffit de séparer les lettres dans le code LaTeX
avec quelque chose qui ne produira rien dans le fichier de sortie. 
Par exemple : `\/`, `{}`, `\mbox{}`, `\null`. Les codages de fontes T1 et OT1 
fournissent aussi la commande `\textcompwordmark`, qui a le même but.

``` 
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\Large
Comment effacer efficacement les fleurs ?

Mais, oui, comment ef\/facer ef{}ficacement les f\mbox{}leurs ?
\end{document}
```


## Empêcher systématiquement une ligature

L'extension <ctanpkg:fontspec> permet d'utiliser des fonctionnalités avancées
des polices de caractères, dont le paramétrage des ligatures. 

L'exemple ci-dessous montre la différence de résultat.

::::{tab-set}

:::{tab-item} Sans ligatures
```
\documentclass{article}
  \usepackage{fontspec}
  \usepackage[french]{babel}
  \pagestyle{empty}

  \defaultfontfeatures{
    Ligatures={
      NoCommon,
      NoRequired,
      NoContextual,
      NoHistoric,
      NoDiscretionary
    }
  }
  \setmainfont[
    BoldFont=lmroman10-bold.otf,
    ItalicFont=lmroman10-italic.otf,
    BoldItalicFont=lmroman10-bolditalic.otf,
    SlantedFont=lmromanslant10-regular.otf,
    BoldSlantedFont=lmromanslant10-bold.otf,
    SmallCapsFont=lmromancaps10-regular.otf
  ]{lmroman10-regular.otf}

\begin{document}
\Large Comment effacer efficacement les fleurs ?
\end{document}
```
:::

:::{tab-item} Avec ligatures

```
%!TEX engine=lualatex
\documentclass{article}
  \usepackage{fontspec}
  \usepackage[french]{babel}
  \pagestyle{empty}

  \setmainfont[
    BoldFont=lmroman10-bold.otf,
    ItalicFont=lmroman10-italic.otf,
    BoldItalicFont=lmroman10-bolditalic.otf,
    SlantedFont=lmromanslant10-regular.otf,
    BoldSlantedFont=lmromanslant10-bold.otf,
    SmallCapsFont=lmromancaps10-regular.otf
  ]{lmroman10-regular.otf}

\begin{document}
\Large Comment effacer efficacement les fleurs ?
\end{document}
```
:::

:::{tab-item} Avec ligatures (sans `\setmainfont`)

```
%!TEX engine=lualatex
\documentclass{article}
  \usepackage{lmodern}
  \usepackage[french]{babel}
  \pagestyle{empty}

\begin{document}
\Large Comment effacer efficacement les fleurs ?
\end{document}
```
:::

::::


:::{sources}
- [LaTeX pour les linguistes](https://hal.science/cel-02145840/document), 
  de Thomas Pellard
- [Removing ligatures when using fontspec](https://tex.stackexchange.com/q/103238), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
- [When should I not use a ligature in English typesetting?](https://english.stackexchange.com/q/50660)
  sur [English Stack Exchange](https://english.stackexchange.com/)
:::