/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.activities;

import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.piccolo2d.extras.activities.PPathActivity;

public class PPositionPathActivity
extends PPathActivity {
    protected Point2D[] positions;
    protected Target target;

    public PPositionPathActivity(long duration, long stepRate, Target target) {
        this(duration, stepRate, target, null, new Point2D[0]);
    }

    public PPositionPathActivity(long duration, long stepRate, Target target, float[] knots, Point2D[] positions) {
        this(duration, stepRate, 1, 1, target, knots, positions);
    }

    public PPositionPathActivity(long duration, long stepRate, int loopCount, int mode, Target target, float[] knots, Point2D[] positions) {
        super(duration, stepRate, loopCount, mode, knots);
        this.target = target;
        this.positions = (Point2D[])positions.clone();
    }

    protected boolean isAnimation() {
        return true;
    }

    public Point2D[] getPositions() {
        return (Point2D[])this.positions.clone();
    }

    public Point2D getPosition(int index) {
        return this.positions[index];
    }

    public void setPositions(Point2D[] positions) {
        this.positions = (Point2D[])positions.clone();
    }

    public void setPosition(int index, Point2D position) {
        this.positions[index] = position;
    }

    public void setPositions(GeneralPath path) {
        PathIterator pi = path.getPathIterator(null, 1.0);
        ArrayList<Point2D.Float> points = new ArrayList<Point2D.Float>();
        float[] point = new float[6];
        float distanceSum = 0.0f;
        float lastMoveToX = 0.0f;
        float lastMoveToY = 0.0f;
        while (!pi.isDone()) {
            int type = pi.currentSegment(point);
            switch (type) {
                case 0: {
                    points.add(new Point2D.Float(point[0], point[1]));
                    lastMoveToX = point[0];
                    lastMoveToY = point[1];
                    break;
                }
                case 1: {
                    points.add(new Point2D.Float(point[0], point[1]));
                    break;
                }
                case 4: {
                    points.add(new Point2D.Float(lastMoveToX, lastMoveToY));
                    break;
                }
                case 2: 
                case 3: {
                    throw new RuntimeException();
                }
            }
            if (points.size() > 1) {
                Point2D last = (Point2D)points.get(points.size() - 2);
                Point2D current = (Point2D)points.get(points.size() - 1);
                distanceSum = (float)((double)distanceSum + last.distance(current));
            }
            pi.next();
        }
        int size = points.size();
        Point2D[] newPositions = new Point2D[size];
        float[] newKnots = new float[size];
        for (int i = 0; i < size; ++i) {
            newPositions[i] = (Point2D)points.get(i);
            if (i <= 0) continue;
            float dist = (float)newPositions[i - 1].distance(newPositions[i]);
            newKnots[i] = newKnots[i - 1] + dist / distanceSum;
        }
        this.setPositions(newPositions);
        this.setKnots(newKnots);
    }

    public void setRelativeTargetValue(float zeroToOne, int startKnot, int endKnot) {
        Point2D start = this.getPosition(startKnot);
        Point2D end = this.getPosition(endKnot);
        this.target.setPosition(start.getX() + (double)zeroToOne * (end.getX() - start.getX()), start.getY() + (double)zeroToOne * (end.getY() - start.getY()));
    }

    public static interface Target {
        public void setPosition(double var1, double var3);
    }
}

