// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/query"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsEc2query_serializeOpAcceptReservedInstancesExchangeQuote struct {
}

func (*awsEc2query_serializeOpAcceptReservedInstancesExchangeQuote) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAcceptReservedInstancesExchangeQuote) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AcceptReservedInstancesExchangeQuoteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AcceptReservedInstancesExchangeQuote")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAcceptReservedInstancesExchangeQuoteInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAcceptTransitGatewayMulticastDomainAssociations struct {
}

func (*awsEc2query_serializeOpAcceptTransitGatewayMulticastDomainAssociations) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAcceptTransitGatewayMulticastDomainAssociations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AcceptTransitGatewayMulticastDomainAssociationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AcceptTransitGatewayMulticastDomainAssociations")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAcceptTransitGatewayMulticastDomainAssociationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAcceptTransitGatewayPeeringAttachment struct {
}

func (*awsEc2query_serializeOpAcceptTransitGatewayPeeringAttachment) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAcceptTransitGatewayPeeringAttachment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AcceptTransitGatewayPeeringAttachmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AcceptTransitGatewayPeeringAttachment")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAcceptTransitGatewayPeeringAttachmentInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAcceptTransitGatewayVpcAttachment struct {
}

func (*awsEc2query_serializeOpAcceptTransitGatewayVpcAttachment) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAcceptTransitGatewayVpcAttachment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AcceptTransitGatewayVpcAttachmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AcceptTransitGatewayVpcAttachment")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAcceptTransitGatewayVpcAttachmentInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAcceptVpcEndpointConnections struct {
}

func (*awsEc2query_serializeOpAcceptVpcEndpointConnections) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAcceptVpcEndpointConnections) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AcceptVpcEndpointConnectionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AcceptVpcEndpointConnections")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAcceptVpcEndpointConnectionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAcceptVpcPeeringConnection struct {
}

func (*awsEc2query_serializeOpAcceptVpcPeeringConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAcceptVpcPeeringConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AcceptVpcPeeringConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AcceptVpcPeeringConnection")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAcceptVpcPeeringConnectionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAdvertiseByoipCidr struct {
}

func (*awsEc2query_serializeOpAdvertiseByoipCidr) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAdvertiseByoipCidr) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AdvertiseByoipCidrInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AdvertiseByoipCidr")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAdvertiseByoipCidrInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAllocateAddress struct {
}

func (*awsEc2query_serializeOpAllocateAddress) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAllocateAddress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AllocateAddressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AllocateAddress")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAllocateAddressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAllocateHosts struct {
}

func (*awsEc2query_serializeOpAllocateHosts) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAllocateHosts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AllocateHostsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AllocateHosts")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAllocateHostsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpApplySecurityGroupsToClientVpnTargetNetwork struct {
}

func (*awsEc2query_serializeOpApplySecurityGroupsToClientVpnTargetNetwork) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpApplySecurityGroupsToClientVpnTargetNetwork) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ApplySecurityGroupsToClientVpnTargetNetworkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ApplySecurityGroupsToClientVpnTargetNetwork")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentApplySecurityGroupsToClientVpnTargetNetworkInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAssignIpv6Addresses struct {
}

func (*awsEc2query_serializeOpAssignIpv6Addresses) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAssignIpv6Addresses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssignIpv6AddressesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AssignIpv6Addresses")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAssignIpv6AddressesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAssignPrivateIpAddresses struct {
}

func (*awsEc2query_serializeOpAssignPrivateIpAddresses) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAssignPrivateIpAddresses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssignPrivateIpAddressesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AssignPrivateIpAddresses")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAssignPrivateIpAddressesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAssociateAddress struct {
}

func (*awsEc2query_serializeOpAssociateAddress) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAssociateAddress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateAddressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AssociateAddress")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAssociateAddressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAssociateClientVpnTargetNetwork struct {
}

func (*awsEc2query_serializeOpAssociateClientVpnTargetNetwork) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAssociateClientVpnTargetNetwork) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateClientVpnTargetNetworkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AssociateClientVpnTargetNetwork")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAssociateClientVpnTargetNetworkInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAssociateDhcpOptions struct {
}

func (*awsEc2query_serializeOpAssociateDhcpOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAssociateDhcpOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateDhcpOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AssociateDhcpOptions")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAssociateDhcpOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAssociateEnclaveCertificateIamRole struct {
}

func (*awsEc2query_serializeOpAssociateEnclaveCertificateIamRole) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAssociateEnclaveCertificateIamRole) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateEnclaveCertificateIamRoleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AssociateEnclaveCertificateIamRole")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAssociateEnclaveCertificateIamRoleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAssociateIamInstanceProfile struct {
}

func (*awsEc2query_serializeOpAssociateIamInstanceProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAssociateIamInstanceProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateIamInstanceProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AssociateIamInstanceProfile")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAssociateIamInstanceProfileInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAssociateRouteTable struct {
}

func (*awsEc2query_serializeOpAssociateRouteTable) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAssociateRouteTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateRouteTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AssociateRouteTable")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAssociateRouteTableInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAssociateSubnetCidrBlock struct {
}

func (*awsEc2query_serializeOpAssociateSubnetCidrBlock) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAssociateSubnetCidrBlock) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateSubnetCidrBlockInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AssociateSubnetCidrBlock")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAssociateSubnetCidrBlockInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAssociateTransitGatewayMulticastDomain struct {
}

func (*awsEc2query_serializeOpAssociateTransitGatewayMulticastDomain) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAssociateTransitGatewayMulticastDomain) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateTransitGatewayMulticastDomainInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AssociateTransitGatewayMulticastDomain")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAssociateTransitGatewayMulticastDomainInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAssociateTransitGatewayRouteTable struct {
}

func (*awsEc2query_serializeOpAssociateTransitGatewayRouteTable) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAssociateTransitGatewayRouteTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateTransitGatewayRouteTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AssociateTransitGatewayRouteTable")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAssociateTransitGatewayRouteTableInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAssociateVpcCidrBlock struct {
}

func (*awsEc2query_serializeOpAssociateVpcCidrBlock) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAssociateVpcCidrBlock) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateVpcCidrBlockInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AssociateVpcCidrBlock")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAssociateVpcCidrBlockInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAttachClassicLinkVpc struct {
}

func (*awsEc2query_serializeOpAttachClassicLinkVpc) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAttachClassicLinkVpc) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachClassicLinkVpcInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AttachClassicLinkVpc")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAttachClassicLinkVpcInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAttachInternetGateway struct {
}

func (*awsEc2query_serializeOpAttachInternetGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAttachInternetGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachInternetGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AttachInternetGateway")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAttachInternetGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAttachNetworkInterface struct {
}

func (*awsEc2query_serializeOpAttachNetworkInterface) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAttachNetworkInterface) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachNetworkInterfaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AttachNetworkInterface")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAttachNetworkInterfaceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAttachVolume struct {
}

func (*awsEc2query_serializeOpAttachVolume) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAttachVolume) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachVolumeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AttachVolume")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAttachVolumeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAttachVpnGateway struct {
}

func (*awsEc2query_serializeOpAttachVpnGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAttachVpnGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AttachVpnGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AttachVpnGateway")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAttachVpnGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAuthorizeClientVpnIngress struct {
}

func (*awsEc2query_serializeOpAuthorizeClientVpnIngress) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAuthorizeClientVpnIngress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AuthorizeClientVpnIngressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AuthorizeClientVpnIngress")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAuthorizeClientVpnIngressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAuthorizeSecurityGroupEgress struct {
}

func (*awsEc2query_serializeOpAuthorizeSecurityGroupEgress) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAuthorizeSecurityGroupEgress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AuthorizeSecurityGroupEgressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AuthorizeSecurityGroupEgress")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAuthorizeSecurityGroupEgressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpAuthorizeSecurityGroupIngress struct {
}

func (*awsEc2query_serializeOpAuthorizeSecurityGroupIngress) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpAuthorizeSecurityGroupIngress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AuthorizeSecurityGroupIngressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("AuthorizeSecurityGroupIngress")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentAuthorizeSecurityGroupIngressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpBundleInstance struct {
}

func (*awsEc2query_serializeOpBundleInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpBundleInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BundleInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("BundleInstance")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentBundleInstanceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCancelBundleTask struct {
}

func (*awsEc2query_serializeOpCancelBundleTask) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCancelBundleTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelBundleTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CancelBundleTask")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCancelBundleTaskInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCancelCapacityReservation struct {
}

func (*awsEc2query_serializeOpCancelCapacityReservation) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCancelCapacityReservation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelCapacityReservationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CancelCapacityReservation")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCancelCapacityReservationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCancelConversionTask struct {
}

func (*awsEc2query_serializeOpCancelConversionTask) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCancelConversionTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelConversionTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CancelConversionTask")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCancelConversionTaskInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCancelExportTask struct {
}

func (*awsEc2query_serializeOpCancelExportTask) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCancelExportTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelExportTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CancelExportTask")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCancelExportTaskInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCancelImportTask struct {
}

func (*awsEc2query_serializeOpCancelImportTask) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCancelImportTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelImportTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CancelImportTask")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCancelImportTaskInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCancelReservedInstancesListing struct {
}

func (*awsEc2query_serializeOpCancelReservedInstancesListing) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCancelReservedInstancesListing) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelReservedInstancesListingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CancelReservedInstancesListing")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCancelReservedInstancesListingInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCancelSpotFleetRequests struct {
}

func (*awsEc2query_serializeOpCancelSpotFleetRequests) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCancelSpotFleetRequests) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelSpotFleetRequestsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CancelSpotFleetRequests")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCancelSpotFleetRequestsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCancelSpotInstanceRequests struct {
}

func (*awsEc2query_serializeOpCancelSpotInstanceRequests) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCancelSpotInstanceRequests) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelSpotInstanceRequestsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CancelSpotInstanceRequests")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCancelSpotInstanceRequestsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpConfirmProductInstance struct {
}

func (*awsEc2query_serializeOpConfirmProductInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpConfirmProductInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ConfirmProductInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ConfirmProductInstance")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentConfirmProductInstanceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCopyFpgaImage struct {
}

func (*awsEc2query_serializeOpCopyFpgaImage) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCopyFpgaImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CopyFpgaImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CopyFpgaImage")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCopyFpgaImageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCopyImage struct {
}

func (*awsEc2query_serializeOpCopyImage) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCopyImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CopyImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CopyImage")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCopyImageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCopySnapshot struct {
}

func (*awsEc2query_serializeOpCopySnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCopySnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CopySnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CopySnapshot")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCopySnapshotInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateCapacityReservation struct {
}

func (*awsEc2query_serializeOpCreateCapacityReservation) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateCapacityReservation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCapacityReservationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateCapacityReservation")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateCapacityReservationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateCarrierGateway struct {
}

func (*awsEc2query_serializeOpCreateCarrierGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateCarrierGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCarrierGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateCarrierGateway")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateCarrierGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateClientVpnEndpoint struct {
}

func (*awsEc2query_serializeOpCreateClientVpnEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateClientVpnEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateClientVpnEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateClientVpnEndpoint")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateClientVpnEndpointInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateClientVpnRoute struct {
}

func (*awsEc2query_serializeOpCreateClientVpnRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateClientVpnRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateClientVpnRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateClientVpnRoute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateClientVpnRouteInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateCustomerGateway struct {
}

func (*awsEc2query_serializeOpCreateCustomerGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateCustomerGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateCustomerGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateCustomerGateway")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateCustomerGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateDefaultSubnet struct {
}

func (*awsEc2query_serializeOpCreateDefaultSubnet) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateDefaultSubnet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDefaultSubnetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateDefaultSubnet")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateDefaultSubnetInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateDefaultVpc struct {
}

func (*awsEc2query_serializeOpCreateDefaultVpc) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateDefaultVpc) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDefaultVpcInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateDefaultVpc")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateDefaultVpcInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateDhcpOptions struct {
}

func (*awsEc2query_serializeOpCreateDhcpOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateDhcpOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDhcpOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateDhcpOptions")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateDhcpOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateEgressOnlyInternetGateway struct {
}

func (*awsEc2query_serializeOpCreateEgressOnlyInternetGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateEgressOnlyInternetGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateEgressOnlyInternetGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateEgressOnlyInternetGateway")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateEgressOnlyInternetGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateFleet struct {
}

func (*awsEc2query_serializeOpCreateFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateFleet")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateFleetInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateFlowLogs struct {
}

func (*awsEc2query_serializeOpCreateFlowLogs) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateFlowLogs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFlowLogsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateFlowLogs")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateFlowLogsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateFpgaImage struct {
}

func (*awsEc2query_serializeOpCreateFpgaImage) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateFpgaImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFpgaImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateFpgaImage")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateFpgaImageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateImage struct {
}

func (*awsEc2query_serializeOpCreateImage) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateImage")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateImageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateInstanceExportTask struct {
}

func (*awsEc2query_serializeOpCreateInstanceExportTask) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateInstanceExportTask) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateInstanceExportTaskInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateInstanceExportTask")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateInstanceExportTaskInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateInternetGateway struct {
}

func (*awsEc2query_serializeOpCreateInternetGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateInternetGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateInternetGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateInternetGateway")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateInternetGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateKeyPair struct {
}

func (*awsEc2query_serializeOpCreateKeyPair) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateKeyPair) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateKeyPairInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateKeyPair")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateKeyPairInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateLaunchTemplate struct {
}

func (*awsEc2query_serializeOpCreateLaunchTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateLaunchTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateLaunchTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateLaunchTemplate")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateLaunchTemplateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateLaunchTemplateVersion struct {
}

func (*awsEc2query_serializeOpCreateLaunchTemplateVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateLaunchTemplateVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateLaunchTemplateVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateLaunchTemplateVersion")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateLaunchTemplateVersionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateLocalGatewayRoute struct {
}

func (*awsEc2query_serializeOpCreateLocalGatewayRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateLocalGatewayRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateLocalGatewayRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateLocalGatewayRoute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateLocalGatewayRouteInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateLocalGatewayRouteTableVpcAssociation struct {
}

func (*awsEc2query_serializeOpCreateLocalGatewayRouteTableVpcAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateLocalGatewayRouteTableVpcAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateLocalGatewayRouteTableVpcAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateLocalGatewayRouteTableVpcAssociation")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateLocalGatewayRouteTableVpcAssociationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateManagedPrefixList struct {
}

func (*awsEc2query_serializeOpCreateManagedPrefixList) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateManagedPrefixList) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateManagedPrefixListInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateManagedPrefixList")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateManagedPrefixListInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateNatGateway struct {
}

func (*awsEc2query_serializeOpCreateNatGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateNatGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateNatGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateNatGateway")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateNatGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateNetworkAcl struct {
}

func (*awsEc2query_serializeOpCreateNetworkAcl) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateNetworkAcl) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateNetworkAclInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateNetworkAcl")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateNetworkAclInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateNetworkAclEntry struct {
}

func (*awsEc2query_serializeOpCreateNetworkAclEntry) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateNetworkAclEntry) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateNetworkAclEntryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateNetworkAclEntry")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateNetworkAclEntryInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateNetworkInsightsPath struct {
}

func (*awsEc2query_serializeOpCreateNetworkInsightsPath) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateNetworkInsightsPath) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateNetworkInsightsPathInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateNetworkInsightsPath")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateNetworkInsightsPathInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateNetworkInterface struct {
}

func (*awsEc2query_serializeOpCreateNetworkInterface) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateNetworkInterface) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateNetworkInterfaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateNetworkInterface")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateNetworkInterfaceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateNetworkInterfacePermission struct {
}

func (*awsEc2query_serializeOpCreateNetworkInterfacePermission) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateNetworkInterfacePermission) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateNetworkInterfacePermissionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateNetworkInterfacePermission")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateNetworkInterfacePermissionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreatePlacementGroup struct {
}

func (*awsEc2query_serializeOpCreatePlacementGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreatePlacementGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePlacementGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreatePlacementGroup")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreatePlacementGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateReservedInstancesListing struct {
}

func (*awsEc2query_serializeOpCreateReservedInstancesListing) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateReservedInstancesListing) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateReservedInstancesListingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateReservedInstancesListing")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateReservedInstancesListingInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateRoute struct {
}

func (*awsEc2query_serializeOpCreateRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateRoute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateRouteInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateRouteTable struct {
}

func (*awsEc2query_serializeOpCreateRouteTable) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateRouteTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRouteTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateRouteTable")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateRouteTableInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateSecurityGroup struct {
}

func (*awsEc2query_serializeOpCreateSecurityGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateSecurityGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSecurityGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateSecurityGroup")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateSecurityGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateSnapshot struct {
}

func (*awsEc2query_serializeOpCreateSnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateSnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateSnapshot")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateSnapshotInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateSnapshots struct {
}

func (*awsEc2query_serializeOpCreateSnapshots) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateSnapshots) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSnapshotsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateSnapshots")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateSnapshotsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateSpotDatafeedSubscription struct {
}

func (*awsEc2query_serializeOpCreateSpotDatafeedSubscription) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateSpotDatafeedSubscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSpotDatafeedSubscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateSpotDatafeedSubscription")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateSpotDatafeedSubscriptionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateSubnet struct {
}

func (*awsEc2query_serializeOpCreateSubnet) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateSubnet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSubnetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateSubnet")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateSubnetInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateTags struct {
}

func (*awsEc2query_serializeOpCreateTags) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateTags")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateTagsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateTrafficMirrorFilter struct {
}

func (*awsEc2query_serializeOpCreateTrafficMirrorFilter) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateTrafficMirrorFilter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTrafficMirrorFilterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateTrafficMirrorFilter")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateTrafficMirrorFilterInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateTrafficMirrorFilterRule struct {
}

func (*awsEc2query_serializeOpCreateTrafficMirrorFilterRule) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateTrafficMirrorFilterRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTrafficMirrorFilterRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateTrafficMirrorFilterRule")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateTrafficMirrorFilterRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateTrafficMirrorSession struct {
}

func (*awsEc2query_serializeOpCreateTrafficMirrorSession) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateTrafficMirrorSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTrafficMirrorSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateTrafficMirrorSession")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateTrafficMirrorSessionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateTrafficMirrorTarget struct {
}

func (*awsEc2query_serializeOpCreateTrafficMirrorTarget) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateTrafficMirrorTarget) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTrafficMirrorTargetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateTrafficMirrorTarget")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateTrafficMirrorTargetInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateTransitGateway struct {
}

func (*awsEc2query_serializeOpCreateTransitGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateTransitGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTransitGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateTransitGateway")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateTransitGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateTransitGatewayConnect struct {
}

func (*awsEc2query_serializeOpCreateTransitGatewayConnect) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateTransitGatewayConnect) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTransitGatewayConnectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateTransitGatewayConnect")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateTransitGatewayConnectInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateTransitGatewayConnectPeer struct {
}

func (*awsEc2query_serializeOpCreateTransitGatewayConnectPeer) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateTransitGatewayConnectPeer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTransitGatewayConnectPeerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateTransitGatewayConnectPeer")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateTransitGatewayConnectPeerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateTransitGatewayMulticastDomain struct {
}

func (*awsEc2query_serializeOpCreateTransitGatewayMulticastDomain) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateTransitGatewayMulticastDomain) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTransitGatewayMulticastDomainInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateTransitGatewayMulticastDomain")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateTransitGatewayMulticastDomainInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateTransitGatewayPeeringAttachment struct {
}

func (*awsEc2query_serializeOpCreateTransitGatewayPeeringAttachment) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateTransitGatewayPeeringAttachment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTransitGatewayPeeringAttachmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateTransitGatewayPeeringAttachment")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateTransitGatewayPeeringAttachmentInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateTransitGatewayPrefixListReference struct {
}

func (*awsEc2query_serializeOpCreateTransitGatewayPrefixListReference) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateTransitGatewayPrefixListReference) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTransitGatewayPrefixListReferenceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateTransitGatewayPrefixListReference")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateTransitGatewayPrefixListReferenceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateTransitGatewayRoute struct {
}

func (*awsEc2query_serializeOpCreateTransitGatewayRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateTransitGatewayRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTransitGatewayRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateTransitGatewayRoute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateTransitGatewayRouteInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateTransitGatewayRouteTable struct {
}

func (*awsEc2query_serializeOpCreateTransitGatewayRouteTable) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateTransitGatewayRouteTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTransitGatewayRouteTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateTransitGatewayRouteTable")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateTransitGatewayRouteTableInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateTransitGatewayVpcAttachment struct {
}

func (*awsEc2query_serializeOpCreateTransitGatewayVpcAttachment) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateTransitGatewayVpcAttachment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTransitGatewayVpcAttachmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateTransitGatewayVpcAttachment")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateTransitGatewayVpcAttachmentInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateVolume struct {
}

func (*awsEc2query_serializeOpCreateVolume) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateVolume) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVolumeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateVolume")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateVolumeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateVpc struct {
}

func (*awsEc2query_serializeOpCreateVpc) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateVpc) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVpcInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateVpc")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateVpcInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateVpcEndpoint struct {
}

func (*awsEc2query_serializeOpCreateVpcEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateVpcEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVpcEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateVpcEndpoint")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateVpcEndpointInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateVpcEndpointConnectionNotification struct {
}

func (*awsEc2query_serializeOpCreateVpcEndpointConnectionNotification) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateVpcEndpointConnectionNotification) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVpcEndpointConnectionNotificationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateVpcEndpointConnectionNotification")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateVpcEndpointConnectionNotificationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateVpcEndpointServiceConfiguration struct {
}

func (*awsEc2query_serializeOpCreateVpcEndpointServiceConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateVpcEndpointServiceConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVpcEndpointServiceConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateVpcEndpointServiceConfiguration")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateVpcEndpointServiceConfigurationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateVpcPeeringConnection struct {
}

func (*awsEc2query_serializeOpCreateVpcPeeringConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateVpcPeeringConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVpcPeeringConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateVpcPeeringConnection")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateVpcPeeringConnectionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateVpnConnection struct {
}

func (*awsEc2query_serializeOpCreateVpnConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateVpnConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVpnConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateVpnConnection")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateVpnConnectionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateVpnConnectionRoute struct {
}

func (*awsEc2query_serializeOpCreateVpnConnectionRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateVpnConnectionRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVpnConnectionRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateVpnConnectionRoute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateVpnConnectionRouteInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpCreateVpnGateway struct {
}

func (*awsEc2query_serializeOpCreateVpnGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpCreateVpnGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVpnGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("CreateVpnGateway")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentCreateVpnGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteCarrierGateway struct {
}

func (*awsEc2query_serializeOpDeleteCarrierGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteCarrierGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCarrierGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteCarrierGateway")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteCarrierGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteClientVpnEndpoint struct {
}

func (*awsEc2query_serializeOpDeleteClientVpnEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteClientVpnEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteClientVpnEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteClientVpnEndpoint")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteClientVpnEndpointInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteClientVpnRoute struct {
}

func (*awsEc2query_serializeOpDeleteClientVpnRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteClientVpnRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteClientVpnRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteClientVpnRoute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteClientVpnRouteInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteCustomerGateway struct {
}

func (*awsEc2query_serializeOpDeleteCustomerGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteCustomerGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCustomerGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteCustomerGateway")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteCustomerGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteDhcpOptions struct {
}

func (*awsEc2query_serializeOpDeleteDhcpOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteDhcpOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDhcpOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteDhcpOptions")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteDhcpOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteEgressOnlyInternetGateway struct {
}

func (*awsEc2query_serializeOpDeleteEgressOnlyInternetGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteEgressOnlyInternetGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteEgressOnlyInternetGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteEgressOnlyInternetGateway")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteEgressOnlyInternetGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteFleets struct {
}

func (*awsEc2query_serializeOpDeleteFleets) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteFleets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFleetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteFleets")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteFleetsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteFlowLogs struct {
}

func (*awsEc2query_serializeOpDeleteFlowLogs) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteFlowLogs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFlowLogsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteFlowLogs")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteFlowLogsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteFpgaImage struct {
}

func (*awsEc2query_serializeOpDeleteFpgaImage) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteFpgaImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFpgaImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteFpgaImage")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteFpgaImageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteInternetGateway struct {
}

func (*awsEc2query_serializeOpDeleteInternetGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteInternetGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteInternetGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteInternetGateway")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteInternetGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteKeyPair struct {
}

func (*awsEc2query_serializeOpDeleteKeyPair) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteKeyPair) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteKeyPairInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteKeyPair")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteKeyPairInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteLaunchTemplate struct {
}

func (*awsEc2query_serializeOpDeleteLaunchTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteLaunchTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLaunchTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteLaunchTemplate")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteLaunchTemplateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteLaunchTemplateVersions struct {
}

func (*awsEc2query_serializeOpDeleteLaunchTemplateVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteLaunchTemplateVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLaunchTemplateVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteLaunchTemplateVersions")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteLaunchTemplateVersionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteLocalGatewayRoute struct {
}

func (*awsEc2query_serializeOpDeleteLocalGatewayRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteLocalGatewayRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLocalGatewayRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteLocalGatewayRoute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteLocalGatewayRouteInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteLocalGatewayRouteTableVpcAssociation struct {
}

func (*awsEc2query_serializeOpDeleteLocalGatewayRouteTableVpcAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteLocalGatewayRouteTableVpcAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteLocalGatewayRouteTableVpcAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteLocalGatewayRouteTableVpcAssociation")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteLocalGatewayRouteTableVpcAssociationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteManagedPrefixList struct {
}

func (*awsEc2query_serializeOpDeleteManagedPrefixList) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteManagedPrefixList) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteManagedPrefixListInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteManagedPrefixList")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteManagedPrefixListInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteNatGateway struct {
}

func (*awsEc2query_serializeOpDeleteNatGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteNatGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteNatGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteNatGateway")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteNatGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteNetworkAcl struct {
}

func (*awsEc2query_serializeOpDeleteNetworkAcl) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteNetworkAcl) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteNetworkAclInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteNetworkAcl")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteNetworkAclInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteNetworkAclEntry struct {
}

func (*awsEc2query_serializeOpDeleteNetworkAclEntry) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteNetworkAclEntry) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteNetworkAclEntryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteNetworkAclEntry")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteNetworkAclEntryInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteNetworkInsightsAnalysis struct {
}

func (*awsEc2query_serializeOpDeleteNetworkInsightsAnalysis) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteNetworkInsightsAnalysis) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteNetworkInsightsAnalysisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteNetworkInsightsAnalysis")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteNetworkInsightsAnalysisInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteNetworkInsightsPath struct {
}

func (*awsEc2query_serializeOpDeleteNetworkInsightsPath) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteNetworkInsightsPath) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteNetworkInsightsPathInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteNetworkInsightsPath")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteNetworkInsightsPathInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteNetworkInterface struct {
}

func (*awsEc2query_serializeOpDeleteNetworkInterface) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteNetworkInterface) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteNetworkInterfaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteNetworkInterface")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteNetworkInterfaceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteNetworkInterfacePermission struct {
}

func (*awsEc2query_serializeOpDeleteNetworkInterfacePermission) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteNetworkInterfacePermission) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteNetworkInterfacePermissionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteNetworkInterfacePermission")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteNetworkInterfacePermissionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeletePlacementGroup struct {
}

func (*awsEc2query_serializeOpDeletePlacementGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeletePlacementGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePlacementGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeletePlacementGroup")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeletePlacementGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteQueuedReservedInstances struct {
}

func (*awsEc2query_serializeOpDeleteQueuedReservedInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteQueuedReservedInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteQueuedReservedInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteQueuedReservedInstances")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteQueuedReservedInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteRoute struct {
}

func (*awsEc2query_serializeOpDeleteRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteRoute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteRouteInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteRouteTable struct {
}

func (*awsEc2query_serializeOpDeleteRouteTable) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteRouteTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRouteTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteRouteTable")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteRouteTableInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteSecurityGroup struct {
}

func (*awsEc2query_serializeOpDeleteSecurityGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteSecurityGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSecurityGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteSecurityGroup")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteSecurityGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteSnapshot struct {
}

func (*awsEc2query_serializeOpDeleteSnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteSnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteSnapshot")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteSnapshotInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteSpotDatafeedSubscription struct {
}

func (*awsEc2query_serializeOpDeleteSpotDatafeedSubscription) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteSpotDatafeedSubscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSpotDatafeedSubscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteSpotDatafeedSubscription")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteSpotDatafeedSubscriptionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteSubnet struct {
}

func (*awsEc2query_serializeOpDeleteSubnet) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteSubnet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSubnetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteSubnet")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteSubnetInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteTags struct {
}

func (*awsEc2query_serializeOpDeleteTags) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteTags")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteTagsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteTrafficMirrorFilter struct {
}

func (*awsEc2query_serializeOpDeleteTrafficMirrorFilter) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteTrafficMirrorFilter) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTrafficMirrorFilterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteTrafficMirrorFilter")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteTrafficMirrorFilterInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteTrafficMirrorFilterRule struct {
}

func (*awsEc2query_serializeOpDeleteTrafficMirrorFilterRule) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteTrafficMirrorFilterRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTrafficMirrorFilterRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteTrafficMirrorFilterRule")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteTrafficMirrorFilterRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteTrafficMirrorSession struct {
}

func (*awsEc2query_serializeOpDeleteTrafficMirrorSession) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteTrafficMirrorSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTrafficMirrorSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteTrafficMirrorSession")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteTrafficMirrorSessionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteTrafficMirrorTarget struct {
}

func (*awsEc2query_serializeOpDeleteTrafficMirrorTarget) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteTrafficMirrorTarget) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTrafficMirrorTargetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteTrafficMirrorTarget")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteTrafficMirrorTargetInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteTransitGateway struct {
}

func (*awsEc2query_serializeOpDeleteTransitGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteTransitGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTransitGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteTransitGateway")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteTransitGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteTransitGatewayConnect struct {
}

func (*awsEc2query_serializeOpDeleteTransitGatewayConnect) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteTransitGatewayConnect) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTransitGatewayConnectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteTransitGatewayConnect")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteTransitGatewayConnectInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteTransitGatewayConnectPeer struct {
}

func (*awsEc2query_serializeOpDeleteTransitGatewayConnectPeer) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteTransitGatewayConnectPeer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTransitGatewayConnectPeerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteTransitGatewayConnectPeer")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteTransitGatewayConnectPeerInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteTransitGatewayMulticastDomain struct {
}

func (*awsEc2query_serializeOpDeleteTransitGatewayMulticastDomain) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteTransitGatewayMulticastDomain) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTransitGatewayMulticastDomainInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteTransitGatewayMulticastDomain")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteTransitGatewayMulticastDomainInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteTransitGatewayPeeringAttachment struct {
}

func (*awsEc2query_serializeOpDeleteTransitGatewayPeeringAttachment) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteTransitGatewayPeeringAttachment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTransitGatewayPeeringAttachmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteTransitGatewayPeeringAttachment")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteTransitGatewayPeeringAttachmentInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteTransitGatewayPrefixListReference struct {
}

func (*awsEc2query_serializeOpDeleteTransitGatewayPrefixListReference) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteTransitGatewayPrefixListReference) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTransitGatewayPrefixListReferenceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteTransitGatewayPrefixListReference")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteTransitGatewayPrefixListReferenceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteTransitGatewayRoute struct {
}

func (*awsEc2query_serializeOpDeleteTransitGatewayRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteTransitGatewayRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTransitGatewayRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteTransitGatewayRoute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteTransitGatewayRouteInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteTransitGatewayRouteTable struct {
}

func (*awsEc2query_serializeOpDeleteTransitGatewayRouteTable) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteTransitGatewayRouteTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTransitGatewayRouteTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteTransitGatewayRouteTable")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteTransitGatewayRouteTableInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteTransitGatewayVpcAttachment struct {
}

func (*awsEc2query_serializeOpDeleteTransitGatewayVpcAttachment) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteTransitGatewayVpcAttachment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTransitGatewayVpcAttachmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteTransitGatewayVpcAttachment")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteTransitGatewayVpcAttachmentInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteVolume struct {
}

func (*awsEc2query_serializeOpDeleteVolume) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteVolume) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVolumeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteVolume")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteVolumeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteVpc struct {
}

func (*awsEc2query_serializeOpDeleteVpc) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteVpc) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVpcInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteVpc")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteVpcInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteVpcEndpointConnectionNotifications struct {
}

func (*awsEc2query_serializeOpDeleteVpcEndpointConnectionNotifications) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteVpcEndpointConnectionNotifications) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVpcEndpointConnectionNotificationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteVpcEndpointConnectionNotifications")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteVpcEndpointConnectionNotificationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteVpcEndpoints struct {
}

func (*awsEc2query_serializeOpDeleteVpcEndpoints) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteVpcEndpoints) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVpcEndpointsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteVpcEndpoints")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteVpcEndpointsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteVpcEndpointServiceConfigurations struct {
}

func (*awsEc2query_serializeOpDeleteVpcEndpointServiceConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteVpcEndpointServiceConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVpcEndpointServiceConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteVpcEndpointServiceConfigurations")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteVpcEndpointServiceConfigurationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteVpcPeeringConnection struct {
}

func (*awsEc2query_serializeOpDeleteVpcPeeringConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteVpcPeeringConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVpcPeeringConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteVpcPeeringConnection")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteVpcPeeringConnectionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteVpnConnection struct {
}

func (*awsEc2query_serializeOpDeleteVpnConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteVpnConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVpnConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteVpnConnection")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteVpnConnectionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteVpnConnectionRoute struct {
}

func (*awsEc2query_serializeOpDeleteVpnConnectionRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteVpnConnectionRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVpnConnectionRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteVpnConnectionRoute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteVpnConnectionRouteInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeleteVpnGateway struct {
}

func (*awsEc2query_serializeOpDeleteVpnGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeleteVpnGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVpnGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeleteVpnGateway")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeleteVpnGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeprovisionByoipCidr struct {
}

func (*awsEc2query_serializeOpDeprovisionByoipCidr) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeprovisionByoipCidr) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeprovisionByoipCidrInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeprovisionByoipCidr")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeprovisionByoipCidrInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeregisterImage struct {
}

func (*awsEc2query_serializeOpDeregisterImage) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeregisterImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeregisterImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeregisterImage")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeregisterImageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeregisterInstanceEventNotificationAttributes struct {
}

func (*awsEc2query_serializeOpDeregisterInstanceEventNotificationAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeregisterInstanceEventNotificationAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeregisterInstanceEventNotificationAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeregisterInstanceEventNotificationAttributes")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeregisterInstanceEventNotificationAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeregisterTransitGatewayMulticastGroupMembers struct {
}

func (*awsEc2query_serializeOpDeregisterTransitGatewayMulticastGroupMembers) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeregisterTransitGatewayMulticastGroupMembers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeregisterTransitGatewayMulticastGroupMembersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeregisterTransitGatewayMulticastGroupMembers")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeregisterTransitGatewayMulticastGroupMembersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDeregisterTransitGatewayMulticastGroupSources struct {
}

func (*awsEc2query_serializeOpDeregisterTransitGatewayMulticastGroupSources) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDeregisterTransitGatewayMulticastGroupSources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeregisterTransitGatewayMulticastGroupSourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DeregisterTransitGatewayMulticastGroupSources")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDeregisterTransitGatewayMulticastGroupSourcesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeAccountAttributes struct {
}

func (*awsEc2query_serializeOpDescribeAccountAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeAccountAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAccountAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAccountAttributes")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeAccountAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeAddresses struct {
}

func (*awsEc2query_serializeOpDescribeAddresses) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeAddresses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAddressesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAddresses")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeAddressesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeAggregateIdFormat struct {
}

func (*awsEc2query_serializeOpDescribeAggregateIdFormat) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeAggregateIdFormat) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAggregateIdFormatInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAggregateIdFormat")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeAggregateIdFormatInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeAvailabilityZones struct {
}

func (*awsEc2query_serializeOpDescribeAvailabilityZones) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeAvailabilityZones) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAvailabilityZonesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeAvailabilityZones")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeAvailabilityZonesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeBundleTasks struct {
}

func (*awsEc2query_serializeOpDescribeBundleTasks) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeBundleTasks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeBundleTasksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeBundleTasks")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeBundleTasksInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeByoipCidrs struct {
}

func (*awsEc2query_serializeOpDescribeByoipCidrs) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeByoipCidrs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeByoipCidrsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeByoipCidrs")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeByoipCidrsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeCapacityReservations struct {
}

func (*awsEc2query_serializeOpDescribeCapacityReservations) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeCapacityReservations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeCapacityReservationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeCapacityReservations")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeCapacityReservationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeCarrierGateways struct {
}

func (*awsEc2query_serializeOpDescribeCarrierGateways) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeCarrierGateways) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeCarrierGatewaysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeCarrierGateways")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeCarrierGatewaysInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeClassicLinkInstances struct {
}

func (*awsEc2query_serializeOpDescribeClassicLinkInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeClassicLinkInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClassicLinkInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeClassicLinkInstances")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeClassicLinkInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeClientVpnAuthorizationRules struct {
}

func (*awsEc2query_serializeOpDescribeClientVpnAuthorizationRules) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeClientVpnAuthorizationRules) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClientVpnAuthorizationRulesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeClientVpnAuthorizationRules")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeClientVpnAuthorizationRulesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeClientVpnConnections struct {
}

func (*awsEc2query_serializeOpDescribeClientVpnConnections) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeClientVpnConnections) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClientVpnConnectionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeClientVpnConnections")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeClientVpnConnectionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeClientVpnEndpoints struct {
}

func (*awsEc2query_serializeOpDescribeClientVpnEndpoints) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeClientVpnEndpoints) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClientVpnEndpointsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeClientVpnEndpoints")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeClientVpnEndpointsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeClientVpnRoutes struct {
}

func (*awsEc2query_serializeOpDescribeClientVpnRoutes) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeClientVpnRoutes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClientVpnRoutesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeClientVpnRoutes")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeClientVpnRoutesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeClientVpnTargetNetworks struct {
}

func (*awsEc2query_serializeOpDescribeClientVpnTargetNetworks) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeClientVpnTargetNetworks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClientVpnTargetNetworksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeClientVpnTargetNetworks")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeClientVpnTargetNetworksInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeCoipPools struct {
}

func (*awsEc2query_serializeOpDescribeCoipPools) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeCoipPools) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeCoipPoolsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeCoipPools")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeCoipPoolsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeConversionTasks struct {
}

func (*awsEc2query_serializeOpDescribeConversionTasks) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeConversionTasks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeConversionTasksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeConversionTasks")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeConversionTasksInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeCustomerGateways struct {
}

func (*awsEc2query_serializeOpDescribeCustomerGateways) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeCustomerGateways) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeCustomerGatewaysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeCustomerGateways")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeCustomerGatewaysInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeDhcpOptions struct {
}

func (*awsEc2query_serializeOpDescribeDhcpOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeDhcpOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDhcpOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeDhcpOptions")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeDhcpOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeEgressOnlyInternetGateways struct {
}

func (*awsEc2query_serializeOpDescribeEgressOnlyInternetGateways) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeEgressOnlyInternetGateways) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEgressOnlyInternetGatewaysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeEgressOnlyInternetGateways")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeEgressOnlyInternetGatewaysInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeElasticGpus struct {
}

func (*awsEc2query_serializeOpDescribeElasticGpus) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeElasticGpus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeElasticGpusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeElasticGpus")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeElasticGpusInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeExportImageTasks struct {
}

func (*awsEc2query_serializeOpDescribeExportImageTasks) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeExportImageTasks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeExportImageTasksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeExportImageTasks")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeExportImageTasksInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeExportTasks struct {
}

func (*awsEc2query_serializeOpDescribeExportTasks) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeExportTasks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeExportTasksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeExportTasks")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeExportTasksInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeFastSnapshotRestores struct {
}

func (*awsEc2query_serializeOpDescribeFastSnapshotRestores) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeFastSnapshotRestores) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFastSnapshotRestoresInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeFastSnapshotRestores")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeFastSnapshotRestoresInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeFleetHistory struct {
}

func (*awsEc2query_serializeOpDescribeFleetHistory) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeFleetHistory) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFleetHistoryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeFleetHistory")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeFleetHistoryInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeFleetInstances struct {
}

func (*awsEc2query_serializeOpDescribeFleetInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeFleetInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFleetInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeFleetInstances")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeFleetInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeFleets struct {
}

func (*awsEc2query_serializeOpDescribeFleets) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeFleets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFleetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeFleets")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeFleetsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeFlowLogs struct {
}

func (*awsEc2query_serializeOpDescribeFlowLogs) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeFlowLogs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFlowLogsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeFlowLogs")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeFlowLogsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeFpgaImageAttribute struct {
}

func (*awsEc2query_serializeOpDescribeFpgaImageAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeFpgaImageAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFpgaImageAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeFpgaImageAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeFpgaImageAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeFpgaImages struct {
}

func (*awsEc2query_serializeOpDescribeFpgaImages) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeFpgaImages) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFpgaImagesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeFpgaImages")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeFpgaImagesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeHostReservationOfferings struct {
}

func (*awsEc2query_serializeOpDescribeHostReservationOfferings) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeHostReservationOfferings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeHostReservationOfferingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeHostReservationOfferings")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeHostReservationOfferingsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeHostReservations struct {
}

func (*awsEc2query_serializeOpDescribeHostReservations) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeHostReservations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeHostReservationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeHostReservations")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeHostReservationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeHosts struct {
}

func (*awsEc2query_serializeOpDescribeHosts) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeHosts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeHostsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeHosts")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeHostsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeIamInstanceProfileAssociations struct {
}

func (*awsEc2query_serializeOpDescribeIamInstanceProfileAssociations) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeIamInstanceProfileAssociations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeIamInstanceProfileAssociationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeIamInstanceProfileAssociations")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeIamInstanceProfileAssociationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeIdentityIdFormat struct {
}

func (*awsEc2query_serializeOpDescribeIdentityIdFormat) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeIdentityIdFormat) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeIdentityIdFormatInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeIdentityIdFormat")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeIdentityIdFormatInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeIdFormat struct {
}

func (*awsEc2query_serializeOpDescribeIdFormat) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeIdFormat) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeIdFormatInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeIdFormat")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeIdFormatInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeImageAttribute struct {
}

func (*awsEc2query_serializeOpDescribeImageAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeImageAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeImageAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeImageAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeImageAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeImages struct {
}

func (*awsEc2query_serializeOpDescribeImages) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeImages) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeImagesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeImages")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeImagesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeImportImageTasks struct {
}

func (*awsEc2query_serializeOpDescribeImportImageTasks) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeImportImageTasks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeImportImageTasksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeImportImageTasks")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeImportImageTasksInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeImportSnapshotTasks struct {
}

func (*awsEc2query_serializeOpDescribeImportSnapshotTasks) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeImportSnapshotTasks) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeImportSnapshotTasksInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeImportSnapshotTasks")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeImportSnapshotTasksInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeInstanceAttribute struct {
}

func (*awsEc2query_serializeOpDescribeInstanceAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeInstanceAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInstanceAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeInstanceAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeInstanceAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeInstanceCreditSpecifications struct {
}

func (*awsEc2query_serializeOpDescribeInstanceCreditSpecifications) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeInstanceCreditSpecifications) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInstanceCreditSpecificationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeInstanceCreditSpecifications")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeInstanceCreditSpecificationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeInstanceEventNotificationAttributes struct {
}

func (*awsEc2query_serializeOpDescribeInstanceEventNotificationAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeInstanceEventNotificationAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInstanceEventNotificationAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeInstanceEventNotificationAttributes")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeInstanceEventNotificationAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeInstances struct {
}

func (*awsEc2query_serializeOpDescribeInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeInstances")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeInstanceStatus struct {
}

func (*awsEc2query_serializeOpDescribeInstanceStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeInstanceStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInstanceStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeInstanceStatus")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeInstanceStatusInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeInstanceTypeOfferings struct {
}

func (*awsEc2query_serializeOpDescribeInstanceTypeOfferings) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeInstanceTypeOfferings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInstanceTypeOfferingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeInstanceTypeOfferings")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeInstanceTypeOfferingsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeInstanceTypes struct {
}

func (*awsEc2query_serializeOpDescribeInstanceTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeInstanceTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInstanceTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeInstanceTypes")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeInstanceTypesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeInternetGateways struct {
}

func (*awsEc2query_serializeOpDescribeInternetGateways) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeInternetGateways) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInternetGatewaysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeInternetGateways")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeInternetGatewaysInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeIpv6Pools struct {
}

func (*awsEc2query_serializeOpDescribeIpv6Pools) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeIpv6Pools) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeIpv6PoolsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeIpv6Pools")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeIpv6PoolsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeKeyPairs struct {
}

func (*awsEc2query_serializeOpDescribeKeyPairs) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeKeyPairs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeKeyPairsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeKeyPairs")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeKeyPairsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeLaunchTemplates struct {
}

func (*awsEc2query_serializeOpDescribeLaunchTemplates) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeLaunchTemplates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLaunchTemplatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLaunchTemplates")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeLaunchTemplatesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeLaunchTemplateVersions struct {
}

func (*awsEc2query_serializeOpDescribeLaunchTemplateVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeLaunchTemplateVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLaunchTemplateVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLaunchTemplateVersions")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeLaunchTemplateVersionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeLocalGatewayRouteTables struct {
}

func (*awsEc2query_serializeOpDescribeLocalGatewayRouteTables) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeLocalGatewayRouteTables) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLocalGatewayRouteTablesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLocalGatewayRouteTables")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeLocalGatewayRouteTablesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations struct {
}

func (*awsEc2query_serializeOpDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeLocalGatewayRouteTableVpcAssociations struct {
}

func (*awsEc2query_serializeOpDescribeLocalGatewayRouteTableVpcAssociations) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeLocalGatewayRouteTableVpcAssociations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLocalGatewayRouteTableVpcAssociationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLocalGatewayRouteTableVpcAssociations")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeLocalGatewayRouteTableVpcAssociationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeLocalGateways struct {
}

func (*awsEc2query_serializeOpDescribeLocalGateways) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeLocalGateways) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLocalGatewaysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLocalGateways")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeLocalGatewaysInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeLocalGatewayVirtualInterfaceGroups struct {
}

func (*awsEc2query_serializeOpDescribeLocalGatewayVirtualInterfaceGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeLocalGatewayVirtualInterfaceGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLocalGatewayVirtualInterfaceGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLocalGatewayVirtualInterfaceGroups")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeLocalGatewayVirtualInterfaceGroupsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeLocalGatewayVirtualInterfaces struct {
}

func (*awsEc2query_serializeOpDescribeLocalGatewayVirtualInterfaces) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeLocalGatewayVirtualInterfaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLocalGatewayVirtualInterfacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeLocalGatewayVirtualInterfaces")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeLocalGatewayVirtualInterfacesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeManagedPrefixLists struct {
}

func (*awsEc2query_serializeOpDescribeManagedPrefixLists) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeManagedPrefixLists) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeManagedPrefixListsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeManagedPrefixLists")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeManagedPrefixListsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeMovingAddresses struct {
}

func (*awsEc2query_serializeOpDescribeMovingAddresses) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeMovingAddresses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeMovingAddressesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeMovingAddresses")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeMovingAddressesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeNatGateways struct {
}

func (*awsEc2query_serializeOpDescribeNatGateways) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeNatGateways) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeNatGatewaysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeNatGateways")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeNatGatewaysInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeNetworkAcls struct {
}

func (*awsEc2query_serializeOpDescribeNetworkAcls) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeNetworkAcls) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeNetworkAclsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeNetworkAcls")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeNetworkAclsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeNetworkInsightsAnalyses struct {
}

func (*awsEc2query_serializeOpDescribeNetworkInsightsAnalyses) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeNetworkInsightsAnalyses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeNetworkInsightsAnalysesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeNetworkInsightsAnalyses")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeNetworkInsightsAnalysesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeNetworkInsightsPaths struct {
}

func (*awsEc2query_serializeOpDescribeNetworkInsightsPaths) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeNetworkInsightsPaths) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeNetworkInsightsPathsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeNetworkInsightsPaths")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeNetworkInsightsPathsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeNetworkInterfaceAttribute struct {
}

func (*awsEc2query_serializeOpDescribeNetworkInterfaceAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeNetworkInterfaceAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeNetworkInterfaceAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeNetworkInterfaceAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeNetworkInterfaceAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeNetworkInterfacePermissions struct {
}

func (*awsEc2query_serializeOpDescribeNetworkInterfacePermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeNetworkInterfacePermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeNetworkInterfacePermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeNetworkInterfacePermissions")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeNetworkInterfacePermissionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeNetworkInterfaces struct {
}

func (*awsEc2query_serializeOpDescribeNetworkInterfaces) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeNetworkInterfaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeNetworkInterfacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeNetworkInterfaces")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeNetworkInterfacesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribePlacementGroups struct {
}

func (*awsEc2query_serializeOpDescribePlacementGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribePlacementGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribePlacementGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribePlacementGroups")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribePlacementGroupsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribePrefixLists struct {
}

func (*awsEc2query_serializeOpDescribePrefixLists) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribePrefixLists) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribePrefixListsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribePrefixLists")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribePrefixListsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribePrincipalIdFormat struct {
}

func (*awsEc2query_serializeOpDescribePrincipalIdFormat) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribePrincipalIdFormat) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribePrincipalIdFormatInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribePrincipalIdFormat")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribePrincipalIdFormatInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribePublicIpv4Pools struct {
}

func (*awsEc2query_serializeOpDescribePublicIpv4Pools) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribePublicIpv4Pools) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribePublicIpv4PoolsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribePublicIpv4Pools")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribePublicIpv4PoolsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeRegions struct {
}

func (*awsEc2query_serializeOpDescribeRegions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeRegions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRegionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeRegions")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeRegionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeReservedInstances struct {
}

func (*awsEc2query_serializeOpDescribeReservedInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeReservedInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeReservedInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeReservedInstances")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeReservedInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeReservedInstancesListings struct {
}

func (*awsEc2query_serializeOpDescribeReservedInstancesListings) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeReservedInstancesListings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeReservedInstancesListingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeReservedInstancesListings")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeReservedInstancesListingsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeReservedInstancesModifications struct {
}

func (*awsEc2query_serializeOpDescribeReservedInstancesModifications) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeReservedInstancesModifications) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeReservedInstancesModificationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeReservedInstancesModifications")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeReservedInstancesModificationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeReservedInstancesOfferings struct {
}

func (*awsEc2query_serializeOpDescribeReservedInstancesOfferings) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeReservedInstancesOfferings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeReservedInstancesOfferingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeReservedInstancesOfferings")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeReservedInstancesOfferingsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeRouteTables struct {
}

func (*awsEc2query_serializeOpDescribeRouteTables) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeRouteTables) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRouteTablesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeRouteTables")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeRouteTablesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeScheduledInstanceAvailability struct {
}

func (*awsEc2query_serializeOpDescribeScheduledInstanceAvailability) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeScheduledInstanceAvailability) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeScheduledInstanceAvailabilityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeScheduledInstanceAvailability")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeScheduledInstanceAvailabilityInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeScheduledInstances struct {
}

func (*awsEc2query_serializeOpDescribeScheduledInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeScheduledInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeScheduledInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeScheduledInstances")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeScheduledInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeSecurityGroupReferences struct {
}

func (*awsEc2query_serializeOpDescribeSecurityGroupReferences) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeSecurityGroupReferences) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSecurityGroupReferencesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeSecurityGroupReferences")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeSecurityGroupReferencesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeSecurityGroups struct {
}

func (*awsEc2query_serializeOpDescribeSecurityGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeSecurityGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSecurityGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeSecurityGroups")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeSecurityGroupsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeSnapshotAttribute struct {
}

func (*awsEc2query_serializeOpDescribeSnapshotAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeSnapshotAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSnapshotAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeSnapshotAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeSnapshotAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeSnapshots struct {
}

func (*awsEc2query_serializeOpDescribeSnapshots) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeSnapshots) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSnapshotsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeSnapshots")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeSnapshotsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeSpotDatafeedSubscription struct {
}

func (*awsEc2query_serializeOpDescribeSpotDatafeedSubscription) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeSpotDatafeedSubscription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSpotDatafeedSubscriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeSpotDatafeedSubscription")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeSpotDatafeedSubscriptionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeSpotFleetInstances struct {
}

func (*awsEc2query_serializeOpDescribeSpotFleetInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeSpotFleetInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSpotFleetInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeSpotFleetInstances")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeSpotFleetInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeSpotFleetRequestHistory struct {
}

func (*awsEc2query_serializeOpDescribeSpotFleetRequestHistory) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeSpotFleetRequestHistory) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSpotFleetRequestHistoryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeSpotFleetRequestHistory")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeSpotFleetRequestHistoryInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeSpotFleetRequests struct {
}

func (*awsEc2query_serializeOpDescribeSpotFleetRequests) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeSpotFleetRequests) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSpotFleetRequestsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeSpotFleetRequests")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeSpotFleetRequestsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeSpotInstanceRequests struct {
}

func (*awsEc2query_serializeOpDescribeSpotInstanceRequests) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeSpotInstanceRequests) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSpotInstanceRequestsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeSpotInstanceRequests")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeSpotInstanceRequestsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeSpotPriceHistory struct {
}

func (*awsEc2query_serializeOpDescribeSpotPriceHistory) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeSpotPriceHistory) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSpotPriceHistoryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeSpotPriceHistory")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeSpotPriceHistoryInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeStaleSecurityGroups struct {
}

func (*awsEc2query_serializeOpDescribeStaleSecurityGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeStaleSecurityGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeStaleSecurityGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeStaleSecurityGroups")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeStaleSecurityGroupsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeSubnets struct {
}

func (*awsEc2query_serializeOpDescribeSubnets) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeSubnets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSubnetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeSubnets")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeSubnetsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeTags struct {
}

func (*awsEc2query_serializeOpDescribeTags) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeTags) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTagsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTags")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeTagsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeTrafficMirrorFilters struct {
}

func (*awsEc2query_serializeOpDescribeTrafficMirrorFilters) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeTrafficMirrorFilters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTrafficMirrorFiltersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTrafficMirrorFilters")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeTrafficMirrorFiltersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeTrafficMirrorSessions struct {
}

func (*awsEc2query_serializeOpDescribeTrafficMirrorSessions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeTrafficMirrorSessions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTrafficMirrorSessionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTrafficMirrorSessions")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeTrafficMirrorSessionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeTrafficMirrorTargets struct {
}

func (*awsEc2query_serializeOpDescribeTrafficMirrorTargets) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeTrafficMirrorTargets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTrafficMirrorTargetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTrafficMirrorTargets")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeTrafficMirrorTargetsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeTransitGatewayAttachments struct {
}

func (*awsEc2query_serializeOpDescribeTransitGatewayAttachments) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeTransitGatewayAttachments) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTransitGatewayAttachmentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTransitGatewayAttachments")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeTransitGatewayAttachmentsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeTransitGatewayConnectPeers struct {
}

func (*awsEc2query_serializeOpDescribeTransitGatewayConnectPeers) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeTransitGatewayConnectPeers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTransitGatewayConnectPeersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTransitGatewayConnectPeers")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeTransitGatewayConnectPeersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeTransitGatewayConnects struct {
}

func (*awsEc2query_serializeOpDescribeTransitGatewayConnects) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeTransitGatewayConnects) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTransitGatewayConnectsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTransitGatewayConnects")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeTransitGatewayConnectsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeTransitGatewayMulticastDomains struct {
}

func (*awsEc2query_serializeOpDescribeTransitGatewayMulticastDomains) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeTransitGatewayMulticastDomains) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTransitGatewayMulticastDomainsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTransitGatewayMulticastDomains")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeTransitGatewayMulticastDomainsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeTransitGatewayPeeringAttachments struct {
}

func (*awsEc2query_serializeOpDescribeTransitGatewayPeeringAttachments) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeTransitGatewayPeeringAttachments) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTransitGatewayPeeringAttachmentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTransitGatewayPeeringAttachments")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeTransitGatewayPeeringAttachmentsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeTransitGatewayRouteTables struct {
}

func (*awsEc2query_serializeOpDescribeTransitGatewayRouteTables) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeTransitGatewayRouteTables) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTransitGatewayRouteTablesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTransitGatewayRouteTables")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeTransitGatewayRouteTablesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeTransitGateways struct {
}

func (*awsEc2query_serializeOpDescribeTransitGateways) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeTransitGateways) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTransitGatewaysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTransitGateways")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeTransitGatewaysInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeTransitGatewayVpcAttachments struct {
}

func (*awsEc2query_serializeOpDescribeTransitGatewayVpcAttachments) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeTransitGatewayVpcAttachments) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTransitGatewayVpcAttachmentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeTransitGatewayVpcAttachments")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeTransitGatewayVpcAttachmentsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVolumeAttribute struct {
}

func (*awsEc2query_serializeOpDescribeVolumeAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVolumeAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVolumeAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVolumeAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeVolumeAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVolumes struct {
}

func (*awsEc2query_serializeOpDescribeVolumes) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVolumes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVolumesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVolumes")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeVolumesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVolumesModifications struct {
}

func (*awsEc2query_serializeOpDescribeVolumesModifications) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVolumesModifications) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVolumesModificationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVolumesModifications")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeVolumesModificationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVolumeStatus struct {
}

func (*awsEc2query_serializeOpDescribeVolumeStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVolumeStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVolumeStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVolumeStatus")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeVolumeStatusInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVpcAttribute struct {
}

func (*awsEc2query_serializeOpDescribeVpcAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVpcAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVpcAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVpcAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeVpcAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVpcClassicLink struct {
}

func (*awsEc2query_serializeOpDescribeVpcClassicLink) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVpcClassicLink) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVpcClassicLinkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVpcClassicLink")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeVpcClassicLinkInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVpcClassicLinkDnsSupport struct {
}

func (*awsEc2query_serializeOpDescribeVpcClassicLinkDnsSupport) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVpcClassicLinkDnsSupport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVpcClassicLinkDnsSupportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVpcClassicLinkDnsSupport")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeVpcClassicLinkDnsSupportInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVpcEndpointConnectionNotifications struct {
}

func (*awsEc2query_serializeOpDescribeVpcEndpointConnectionNotifications) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVpcEndpointConnectionNotifications) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVpcEndpointConnectionNotificationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVpcEndpointConnectionNotifications")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeVpcEndpointConnectionNotificationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVpcEndpointConnections struct {
}

func (*awsEc2query_serializeOpDescribeVpcEndpointConnections) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVpcEndpointConnections) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVpcEndpointConnectionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVpcEndpointConnections")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeVpcEndpointConnectionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVpcEndpoints struct {
}

func (*awsEc2query_serializeOpDescribeVpcEndpoints) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVpcEndpoints) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVpcEndpointsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVpcEndpoints")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeVpcEndpointsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVpcEndpointServiceConfigurations struct {
}

func (*awsEc2query_serializeOpDescribeVpcEndpointServiceConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVpcEndpointServiceConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVpcEndpointServiceConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVpcEndpointServiceConfigurations")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeVpcEndpointServiceConfigurationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVpcEndpointServicePermissions struct {
}

func (*awsEc2query_serializeOpDescribeVpcEndpointServicePermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVpcEndpointServicePermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVpcEndpointServicePermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVpcEndpointServicePermissions")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeVpcEndpointServicePermissionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVpcEndpointServices struct {
}

func (*awsEc2query_serializeOpDescribeVpcEndpointServices) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVpcEndpointServices) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVpcEndpointServicesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVpcEndpointServices")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeVpcEndpointServicesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVpcPeeringConnections struct {
}

func (*awsEc2query_serializeOpDescribeVpcPeeringConnections) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVpcPeeringConnections) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVpcPeeringConnectionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVpcPeeringConnections")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeVpcPeeringConnectionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVpcs struct {
}

func (*awsEc2query_serializeOpDescribeVpcs) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVpcs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVpcsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVpcs")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeVpcsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVpnConnections struct {
}

func (*awsEc2query_serializeOpDescribeVpnConnections) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVpnConnections) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVpnConnectionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVpnConnections")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeVpnConnectionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDescribeVpnGateways struct {
}

func (*awsEc2query_serializeOpDescribeVpnGateways) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDescribeVpnGateways) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeVpnGatewaysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DescribeVpnGateways")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDescribeVpnGatewaysInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDetachClassicLinkVpc struct {
}

func (*awsEc2query_serializeOpDetachClassicLinkVpc) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDetachClassicLinkVpc) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachClassicLinkVpcInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DetachClassicLinkVpc")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDetachClassicLinkVpcInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDetachInternetGateway struct {
}

func (*awsEc2query_serializeOpDetachInternetGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDetachInternetGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachInternetGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DetachInternetGateway")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDetachInternetGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDetachNetworkInterface struct {
}

func (*awsEc2query_serializeOpDetachNetworkInterface) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDetachNetworkInterface) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachNetworkInterfaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DetachNetworkInterface")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDetachNetworkInterfaceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDetachVolume struct {
}

func (*awsEc2query_serializeOpDetachVolume) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDetachVolume) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachVolumeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DetachVolume")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDetachVolumeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDetachVpnGateway struct {
}

func (*awsEc2query_serializeOpDetachVpnGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDetachVpnGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DetachVpnGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DetachVpnGateway")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDetachVpnGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDisableEbsEncryptionByDefault struct {
}

func (*awsEc2query_serializeOpDisableEbsEncryptionByDefault) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDisableEbsEncryptionByDefault) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableEbsEncryptionByDefaultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisableEbsEncryptionByDefault")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDisableEbsEncryptionByDefaultInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDisableFastSnapshotRestores struct {
}

func (*awsEc2query_serializeOpDisableFastSnapshotRestores) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDisableFastSnapshotRestores) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableFastSnapshotRestoresInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisableFastSnapshotRestores")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDisableFastSnapshotRestoresInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDisableTransitGatewayRouteTablePropagation struct {
}

func (*awsEc2query_serializeOpDisableTransitGatewayRouteTablePropagation) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDisableTransitGatewayRouteTablePropagation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableTransitGatewayRouteTablePropagationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisableTransitGatewayRouteTablePropagation")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDisableTransitGatewayRouteTablePropagationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDisableVgwRoutePropagation struct {
}

func (*awsEc2query_serializeOpDisableVgwRoutePropagation) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDisableVgwRoutePropagation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableVgwRoutePropagationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisableVgwRoutePropagation")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDisableVgwRoutePropagationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDisableVpcClassicLink struct {
}

func (*awsEc2query_serializeOpDisableVpcClassicLink) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDisableVpcClassicLink) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableVpcClassicLinkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisableVpcClassicLink")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDisableVpcClassicLinkInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDisableVpcClassicLinkDnsSupport struct {
}

func (*awsEc2query_serializeOpDisableVpcClassicLinkDnsSupport) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDisableVpcClassicLinkDnsSupport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisableVpcClassicLinkDnsSupportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisableVpcClassicLinkDnsSupport")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDisableVpcClassicLinkDnsSupportInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDisassociateAddress struct {
}

func (*awsEc2query_serializeOpDisassociateAddress) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDisassociateAddress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateAddressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisassociateAddress")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDisassociateAddressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDisassociateClientVpnTargetNetwork struct {
}

func (*awsEc2query_serializeOpDisassociateClientVpnTargetNetwork) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDisassociateClientVpnTargetNetwork) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateClientVpnTargetNetworkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisassociateClientVpnTargetNetwork")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDisassociateClientVpnTargetNetworkInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDisassociateEnclaveCertificateIamRole struct {
}

func (*awsEc2query_serializeOpDisassociateEnclaveCertificateIamRole) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDisassociateEnclaveCertificateIamRole) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateEnclaveCertificateIamRoleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisassociateEnclaveCertificateIamRole")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDisassociateEnclaveCertificateIamRoleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDisassociateIamInstanceProfile struct {
}

func (*awsEc2query_serializeOpDisassociateIamInstanceProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDisassociateIamInstanceProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateIamInstanceProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisassociateIamInstanceProfile")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDisassociateIamInstanceProfileInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDisassociateRouteTable struct {
}

func (*awsEc2query_serializeOpDisassociateRouteTable) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDisassociateRouteTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateRouteTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisassociateRouteTable")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDisassociateRouteTableInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDisassociateSubnetCidrBlock struct {
}

func (*awsEc2query_serializeOpDisassociateSubnetCidrBlock) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDisassociateSubnetCidrBlock) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateSubnetCidrBlockInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisassociateSubnetCidrBlock")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDisassociateSubnetCidrBlockInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDisassociateTransitGatewayMulticastDomain struct {
}

func (*awsEc2query_serializeOpDisassociateTransitGatewayMulticastDomain) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDisassociateTransitGatewayMulticastDomain) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateTransitGatewayMulticastDomainInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisassociateTransitGatewayMulticastDomain")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDisassociateTransitGatewayMulticastDomainInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDisassociateTransitGatewayRouteTable struct {
}

func (*awsEc2query_serializeOpDisassociateTransitGatewayRouteTable) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDisassociateTransitGatewayRouteTable) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateTransitGatewayRouteTableInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisassociateTransitGatewayRouteTable")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDisassociateTransitGatewayRouteTableInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpDisassociateVpcCidrBlock struct {
}

func (*awsEc2query_serializeOpDisassociateVpcCidrBlock) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpDisassociateVpcCidrBlock) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateVpcCidrBlockInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("DisassociateVpcCidrBlock")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentDisassociateVpcCidrBlockInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpEnableEbsEncryptionByDefault struct {
}

func (*awsEc2query_serializeOpEnableEbsEncryptionByDefault) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpEnableEbsEncryptionByDefault) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableEbsEncryptionByDefaultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("EnableEbsEncryptionByDefault")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentEnableEbsEncryptionByDefaultInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpEnableFastSnapshotRestores struct {
}

func (*awsEc2query_serializeOpEnableFastSnapshotRestores) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpEnableFastSnapshotRestores) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableFastSnapshotRestoresInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("EnableFastSnapshotRestores")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentEnableFastSnapshotRestoresInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpEnableTransitGatewayRouteTablePropagation struct {
}

func (*awsEc2query_serializeOpEnableTransitGatewayRouteTablePropagation) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpEnableTransitGatewayRouteTablePropagation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableTransitGatewayRouteTablePropagationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("EnableTransitGatewayRouteTablePropagation")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentEnableTransitGatewayRouteTablePropagationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpEnableVgwRoutePropagation struct {
}

func (*awsEc2query_serializeOpEnableVgwRoutePropagation) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpEnableVgwRoutePropagation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableVgwRoutePropagationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("EnableVgwRoutePropagation")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentEnableVgwRoutePropagationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpEnableVolumeIO struct {
}

func (*awsEc2query_serializeOpEnableVolumeIO) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpEnableVolumeIO) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableVolumeIOInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("EnableVolumeIO")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentEnableVolumeIOInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpEnableVpcClassicLink struct {
}

func (*awsEc2query_serializeOpEnableVpcClassicLink) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpEnableVpcClassicLink) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableVpcClassicLinkInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("EnableVpcClassicLink")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentEnableVpcClassicLinkInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpEnableVpcClassicLinkDnsSupport struct {
}

func (*awsEc2query_serializeOpEnableVpcClassicLinkDnsSupport) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpEnableVpcClassicLinkDnsSupport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EnableVpcClassicLinkDnsSupportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("EnableVpcClassicLinkDnsSupport")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentEnableVpcClassicLinkDnsSupportInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpExportClientVpnClientCertificateRevocationList struct {
}

func (*awsEc2query_serializeOpExportClientVpnClientCertificateRevocationList) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpExportClientVpnClientCertificateRevocationList) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExportClientVpnClientCertificateRevocationListInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ExportClientVpnClientCertificateRevocationList")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentExportClientVpnClientCertificateRevocationListInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpExportClientVpnClientConfiguration struct {
}

func (*awsEc2query_serializeOpExportClientVpnClientConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpExportClientVpnClientConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExportClientVpnClientConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ExportClientVpnClientConfiguration")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentExportClientVpnClientConfigurationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpExportImage struct {
}

func (*awsEc2query_serializeOpExportImage) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpExportImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExportImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ExportImage")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentExportImageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpExportTransitGatewayRoutes struct {
}

func (*awsEc2query_serializeOpExportTransitGatewayRoutes) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpExportTransitGatewayRoutes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExportTransitGatewayRoutesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ExportTransitGatewayRoutes")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentExportTransitGatewayRoutesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetAssociatedEnclaveCertificateIamRoles struct {
}

func (*awsEc2query_serializeOpGetAssociatedEnclaveCertificateIamRoles) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetAssociatedEnclaveCertificateIamRoles) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAssociatedEnclaveCertificateIamRolesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetAssociatedEnclaveCertificateIamRoles")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetAssociatedEnclaveCertificateIamRolesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetAssociatedIpv6PoolCidrs struct {
}

func (*awsEc2query_serializeOpGetAssociatedIpv6PoolCidrs) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetAssociatedIpv6PoolCidrs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAssociatedIpv6PoolCidrsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetAssociatedIpv6PoolCidrs")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetAssociatedIpv6PoolCidrsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetCapacityReservationUsage struct {
}

func (*awsEc2query_serializeOpGetCapacityReservationUsage) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetCapacityReservationUsage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCapacityReservationUsageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetCapacityReservationUsage")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetCapacityReservationUsageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetCoipPoolUsage struct {
}

func (*awsEc2query_serializeOpGetCoipPoolUsage) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetCoipPoolUsage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCoipPoolUsageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetCoipPoolUsage")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetCoipPoolUsageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetConsoleOutput struct {
}

func (*awsEc2query_serializeOpGetConsoleOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetConsoleOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetConsoleOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetConsoleOutput")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetConsoleOutputInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetConsoleScreenshot struct {
}

func (*awsEc2query_serializeOpGetConsoleScreenshot) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetConsoleScreenshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetConsoleScreenshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetConsoleScreenshot")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetConsoleScreenshotInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetDefaultCreditSpecification struct {
}

func (*awsEc2query_serializeOpGetDefaultCreditSpecification) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetDefaultCreditSpecification) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDefaultCreditSpecificationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetDefaultCreditSpecification")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetDefaultCreditSpecificationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetEbsDefaultKmsKeyId struct {
}

func (*awsEc2query_serializeOpGetEbsDefaultKmsKeyId) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetEbsDefaultKmsKeyId) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEbsDefaultKmsKeyIdInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetEbsDefaultKmsKeyId")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetEbsDefaultKmsKeyIdInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetEbsEncryptionByDefault struct {
}

func (*awsEc2query_serializeOpGetEbsEncryptionByDefault) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetEbsEncryptionByDefault) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEbsEncryptionByDefaultInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetEbsEncryptionByDefault")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetEbsEncryptionByDefaultInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetGroupsForCapacityReservation struct {
}

func (*awsEc2query_serializeOpGetGroupsForCapacityReservation) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetGroupsForCapacityReservation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetGroupsForCapacityReservationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetGroupsForCapacityReservation")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetGroupsForCapacityReservationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetHostReservationPurchasePreview struct {
}

func (*awsEc2query_serializeOpGetHostReservationPurchasePreview) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetHostReservationPurchasePreview) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetHostReservationPurchasePreviewInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetHostReservationPurchasePreview")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetHostReservationPurchasePreviewInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetLaunchTemplateData struct {
}

func (*awsEc2query_serializeOpGetLaunchTemplateData) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetLaunchTemplateData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetLaunchTemplateDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetLaunchTemplateData")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetLaunchTemplateDataInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetManagedPrefixListAssociations struct {
}

func (*awsEc2query_serializeOpGetManagedPrefixListAssociations) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetManagedPrefixListAssociations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetManagedPrefixListAssociationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetManagedPrefixListAssociations")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetManagedPrefixListAssociationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetManagedPrefixListEntries struct {
}

func (*awsEc2query_serializeOpGetManagedPrefixListEntries) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetManagedPrefixListEntries) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetManagedPrefixListEntriesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetManagedPrefixListEntries")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetManagedPrefixListEntriesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetPasswordData struct {
}

func (*awsEc2query_serializeOpGetPasswordData) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetPasswordData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPasswordDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetPasswordData")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetPasswordDataInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetReservedInstancesExchangeQuote struct {
}

func (*awsEc2query_serializeOpGetReservedInstancesExchangeQuote) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetReservedInstancesExchangeQuote) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetReservedInstancesExchangeQuoteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetReservedInstancesExchangeQuote")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetReservedInstancesExchangeQuoteInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetTransitGatewayAttachmentPropagations struct {
}

func (*awsEc2query_serializeOpGetTransitGatewayAttachmentPropagations) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetTransitGatewayAttachmentPropagations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTransitGatewayAttachmentPropagationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetTransitGatewayAttachmentPropagations")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetTransitGatewayAttachmentPropagationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetTransitGatewayMulticastDomainAssociations struct {
}

func (*awsEc2query_serializeOpGetTransitGatewayMulticastDomainAssociations) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetTransitGatewayMulticastDomainAssociations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTransitGatewayMulticastDomainAssociationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetTransitGatewayMulticastDomainAssociations")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetTransitGatewayMulticastDomainAssociationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetTransitGatewayPrefixListReferences struct {
}

func (*awsEc2query_serializeOpGetTransitGatewayPrefixListReferences) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetTransitGatewayPrefixListReferences) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTransitGatewayPrefixListReferencesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetTransitGatewayPrefixListReferences")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetTransitGatewayPrefixListReferencesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetTransitGatewayRouteTableAssociations struct {
}

func (*awsEc2query_serializeOpGetTransitGatewayRouteTableAssociations) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetTransitGatewayRouteTableAssociations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTransitGatewayRouteTableAssociationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetTransitGatewayRouteTableAssociations")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetTransitGatewayRouteTableAssociationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpGetTransitGatewayRouteTablePropagations struct {
}

func (*awsEc2query_serializeOpGetTransitGatewayRouteTablePropagations) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpGetTransitGatewayRouteTablePropagations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTransitGatewayRouteTablePropagationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("GetTransitGatewayRouteTablePropagations")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentGetTransitGatewayRouteTablePropagationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpImportClientVpnClientCertificateRevocationList struct {
}

func (*awsEc2query_serializeOpImportClientVpnClientCertificateRevocationList) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpImportClientVpnClientCertificateRevocationList) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ImportClientVpnClientCertificateRevocationListInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ImportClientVpnClientCertificateRevocationList")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentImportClientVpnClientCertificateRevocationListInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpImportImage struct {
}

func (*awsEc2query_serializeOpImportImage) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpImportImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ImportImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ImportImage")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentImportImageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpImportInstance struct {
}

func (*awsEc2query_serializeOpImportInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpImportInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ImportInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ImportInstance")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentImportInstanceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpImportKeyPair struct {
}

func (*awsEc2query_serializeOpImportKeyPair) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpImportKeyPair) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ImportKeyPairInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ImportKeyPair")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentImportKeyPairInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpImportSnapshot struct {
}

func (*awsEc2query_serializeOpImportSnapshot) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpImportSnapshot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ImportSnapshotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ImportSnapshot")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentImportSnapshotInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpImportVolume struct {
}

func (*awsEc2query_serializeOpImportVolume) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpImportVolume) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ImportVolumeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ImportVolume")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentImportVolumeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyAvailabilityZoneGroup struct {
}

func (*awsEc2query_serializeOpModifyAvailabilityZoneGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyAvailabilityZoneGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyAvailabilityZoneGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyAvailabilityZoneGroup")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyAvailabilityZoneGroupInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyCapacityReservation struct {
}

func (*awsEc2query_serializeOpModifyCapacityReservation) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyCapacityReservation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyCapacityReservationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyCapacityReservation")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyCapacityReservationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyClientVpnEndpoint struct {
}

func (*awsEc2query_serializeOpModifyClientVpnEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyClientVpnEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyClientVpnEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyClientVpnEndpoint")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyClientVpnEndpointInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyDefaultCreditSpecification struct {
}

func (*awsEc2query_serializeOpModifyDefaultCreditSpecification) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyDefaultCreditSpecification) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyDefaultCreditSpecificationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyDefaultCreditSpecification")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyDefaultCreditSpecificationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyEbsDefaultKmsKeyId struct {
}

func (*awsEc2query_serializeOpModifyEbsDefaultKmsKeyId) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyEbsDefaultKmsKeyId) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyEbsDefaultKmsKeyIdInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyEbsDefaultKmsKeyId")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyEbsDefaultKmsKeyIdInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyFleet struct {
}

func (*awsEc2query_serializeOpModifyFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyFleet")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyFleetInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyFpgaImageAttribute struct {
}

func (*awsEc2query_serializeOpModifyFpgaImageAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyFpgaImageAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyFpgaImageAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyFpgaImageAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyFpgaImageAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyHosts struct {
}

func (*awsEc2query_serializeOpModifyHosts) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyHosts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyHostsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyHosts")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyHostsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyIdentityIdFormat struct {
}

func (*awsEc2query_serializeOpModifyIdentityIdFormat) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyIdentityIdFormat) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyIdentityIdFormatInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyIdentityIdFormat")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyIdentityIdFormatInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyIdFormat struct {
}

func (*awsEc2query_serializeOpModifyIdFormat) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyIdFormat) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyIdFormatInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyIdFormat")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyIdFormatInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyImageAttribute struct {
}

func (*awsEc2query_serializeOpModifyImageAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyImageAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyImageAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyImageAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyImageAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyInstanceAttribute struct {
}

func (*awsEc2query_serializeOpModifyInstanceAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyInstanceAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyInstanceAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyInstanceAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyInstanceAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyInstanceCapacityReservationAttributes struct {
}

func (*awsEc2query_serializeOpModifyInstanceCapacityReservationAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyInstanceCapacityReservationAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyInstanceCapacityReservationAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyInstanceCapacityReservationAttributes")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyInstanceCapacityReservationAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyInstanceCreditSpecification struct {
}

func (*awsEc2query_serializeOpModifyInstanceCreditSpecification) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyInstanceCreditSpecification) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyInstanceCreditSpecificationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyInstanceCreditSpecification")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyInstanceCreditSpecificationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyInstanceEventStartTime struct {
}

func (*awsEc2query_serializeOpModifyInstanceEventStartTime) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyInstanceEventStartTime) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyInstanceEventStartTimeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyInstanceEventStartTime")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyInstanceEventStartTimeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyInstanceMetadataOptions struct {
}

func (*awsEc2query_serializeOpModifyInstanceMetadataOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyInstanceMetadataOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyInstanceMetadataOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyInstanceMetadataOptions")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyInstanceMetadataOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyInstancePlacement struct {
}

func (*awsEc2query_serializeOpModifyInstancePlacement) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyInstancePlacement) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyInstancePlacementInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyInstancePlacement")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyInstancePlacementInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyLaunchTemplate struct {
}

func (*awsEc2query_serializeOpModifyLaunchTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyLaunchTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyLaunchTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyLaunchTemplate")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyLaunchTemplateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyManagedPrefixList struct {
}

func (*awsEc2query_serializeOpModifyManagedPrefixList) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyManagedPrefixList) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyManagedPrefixListInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyManagedPrefixList")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyManagedPrefixListInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyNetworkInterfaceAttribute struct {
}

func (*awsEc2query_serializeOpModifyNetworkInterfaceAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyNetworkInterfaceAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyNetworkInterfaceAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyNetworkInterfaceAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyNetworkInterfaceAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyReservedInstances struct {
}

func (*awsEc2query_serializeOpModifyReservedInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyReservedInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyReservedInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyReservedInstances")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyReservedInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifySnapshotAttribute struct {
}

func (*awsEc2query_serializeOpModifySnapshotAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifySnapshotAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifySnapshotAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifySnapshotAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifySnapshotAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifySpotFleetRequest struct {
}

func (*awsEc2query_serializeOpModifySpotFleetRequest) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifySpotFleetRequest) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifySpotFleetRequestInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifySpotFleetRequest")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifySpotFleetRequestInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifySubnetAttribute struct {
}

func (*awsEc2query_serializeOpModifySubnetAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifySubnetAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifySubnetAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifySubnetAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifySubnetAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyTrafficMirrorFilterNetworkServices struct {
}

func (*awsEc2query_serializeOpModifyTrafficMirrorFilterNetworkServices) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyTrafficMirrorFilterNetworkServices) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyTrafficMirrorFilterNetworkServicesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyTrafficMirrorFilterNetworkServices")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyTrafficMirrorFilterNetworkServicesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyTrafficMirrorFilterRule struct {
}

func (*awsEc2query_serializeOpModifyTrafficMirrorFilterRule) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyTrafficMirrorFilterRule) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyTrafficMirrorFilterRuleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyTrafficMirrorFilterRule")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyTrafficMirrorFilterRuleInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyTrafficMirrorSession struct {
}

func (*awsEc2query_serializeOpModifyTrafficMirrorSession) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyTrafficMirrorSession) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyTrafficMirrorSessionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyTrafficMirrorSession")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyTrafficMirrorSessionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyTransitGateway struct {
}

func (*awsEc2query_serializeOpModifyTransitGateway) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyTransitGateway) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyTransitGatewayInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyTransitGateway")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyTransitGatewayInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyTransitGatewayPrefixListReference struct {
}

func (*awsEc2query_serializeOpModifyTransitGatewayPrefixListReference) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyTransitGatewayPrefixListReference) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyTransitGatewayPrefixListReferenceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyTransitGatewayPrefixListReference")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyTransitGatewayPrefixListReferenceInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyTransitGatewayVpcAttachment struct {
}

func (*awsEc2query_serializeOpModifyTransitGatewayVpcAttachment) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyTransitGatewayVpcAttachment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyTransitGatewayVpcAttachmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyTransitGatewayVpcAttachment")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyTransitGatewayVpcAttachmentInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyVolume struct {
}

func (*awsEc2query_serializeOpModifyVolume) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyVolume) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyVolumeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyVolume")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyVolumeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyVolumeAttribute struct {
}

func (*awsEc2query_serializeOpModifyVolumeAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyVolumeAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyVolumeAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyVolumeAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyVolumeAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyVpcAttribute struct {
}

func (*awsEc2query_serializeOpModifyVpcAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyVpcAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyVpcAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyVpcAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyVpcAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyVpcEndpoint struct {
}

func (*awsEc2query_serializeOpModifyVpcEndpoint) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyVpcEndpoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyVpcEndpointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyVpcEndpoint")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyVpcEndpointInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyVpcEndpointConnectionNotification struct {
}

func (*awsEc2query_serializeOpModifyVpcEndpointConnectionNotification) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyVpcEndpointConnectionNotification) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyVpcEndpointConnectionNotificationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyVpcEndpointConnectionNotification")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyVpcEndpointConnectionNotificationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyVpcEndpointServiceConfiguration struct {
}

func (*awsEc2query_serializeOpModifyVpcEndpointServiceConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyVpcEndpointServiceConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyVpcEndpointServiceConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyVpcEndpointServiceConfiguration")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyVpcEndpointServiceConfigurationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyVpcEndpointServicePermissions struct {
}

func (*awsEc2query_serializeOpModifyVpcEndpointServicePermissions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyVpcEndpointServicePermissions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyVpcEndpointServicePermissionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyVpcEndpointServicePermissions")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyVpcEndpointServicePermissionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyVpcPeeringConnectionOptions struct {
}

func (*awsEc2query_serializeOpModifyVpcPeeringConnectionOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyVpcPeeringConnectionOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyVpcPeeringConnectionOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyVpcPeeringConnectionOptions")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyVpcPeeringConnectionOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyVpcTenancy struct {
}

func (*awsEc2query_serializeOpModifyVpcTenancy) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyVpcTenancy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyVpcTenancyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyVpcTenancy")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyVpcTenancyInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyVpnConnection struct {
}

func (*awsEc2query_serializeOpModifyVpnConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyVpnConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyVpnConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyVpnConnection")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyVpnConnectionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyVpnConnectionOptions struct {
}

func (*awsEc2query_serializeOpModifyVpnConnectionOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyVpnConnectionOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyVpnConnectionOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyVpnConnectionOptions")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyVpnConnectionOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyVpnTunnelCertificate struct {
}

func (*awsEc2query_serializeOpModifyVpnTunnelCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyVpnTunnelCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyVpnTunnelCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyVpnTunnelCertificate")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyVpnTunnelCertificateInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpModifyVpnTunnelOptions struct {
}

func (*awsEc2query_serializeOpModifyVpnTunnelOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpModifyVpnTunnelOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ModifyVpnTunnelOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ModifyVpnTunnelOptions")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentModifyVpnTunnelOptionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpMonitorInstances struct {
}

func (*awsEc2query_serializeOpMonitorInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpMonitorInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*MonitorInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("MonitorInstances")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentMonitorInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpMoveAddressToVpc struct {
}

func (*awsEc2query_serializeOpMoveAddressToVpc) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpMoveAddressToVpc) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*MoveAddressToVpcInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("MoveAddressToVpc")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentMoveAddressToVpcInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpProvisionByoipCidr struct {
}

func (*awsEc2query_serializeOpProvisionByoipCidr) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpProvisionByoipCidr) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ProvisionByoipCidrInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ProvisionByoipCidr")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentProvisionByoipCidrInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpPurchaseHostReservation struct {
}

func (*awsEc2query_serializeOpPurchaseHostReservation) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpPurchaseHostReservation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PurchaseHostReservationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PurchaseHostReservation")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentPurchaseHostReservationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpPurchaseReservedInstancesOffering struct {
}

func (*awsEc2query_serializeOpPurchaseReservedInstancesOffering) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpPurchaseReservedInstancesOffering) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PurchaseReservedInstancesOfferingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PurchaseReservedInstancesOffering")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentPurchaseReservedInstancesOfferingInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpPurchaseScheduledInstances struct {
}

func (*awsEc2query_serializeOpPurchaseScheduledInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpPurchaseScheduledInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PurchaseScheduledInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("PurchaseScheduledInstances")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentPurchaseScheduledInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRebootInstances struct {
}

func (*awsEc2query_serializeOpRebootInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRebootInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RebootInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RebootInstances")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentRebootInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRegisterImage struct {
}

func (*awsEc2query_serializeOpRegisterImage) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRegisterImage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterImageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RegisterImage")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentRegisterImageInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRegisterInstanceEventNotificationAttributes struct {
}

func (*awsEc2query_serializeOpRegisterInstanceEventNotificationAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRegisterInstanceEventNotificationAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterInstanceEventNotificationAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RegisterInstanceEventNotificationAttributes")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentRegisterInstanceEventNotificationAttributesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRegisterTransitGatewayMulticastGroupMembers struct {
}

func (*awsEc2query_serializeOpRegisterTransitGatewayMulticastGroupMembers) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRegisterTransitGatewayMulticastGroupMembers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterTransitGatewayMulticastGroupMembersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RegisterTransitGatewayMulticastGroupMembers")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentRegisterTransitGatewayMulticastGroupMembersInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRegisterTransitGatewayMulticastGroupSources struct {
}

func (*awsEc2query_serializeOpRegisterTransitGatewayMulticastGroupSources) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRegisterTransitGatewayMulticastGroupSources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterTransitGatewayMulticastGroupSourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RegisterTransitGatewayMulticastGroupSources")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentRegisterTransitGatewayMulticastGroupSourcesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRejectTransitGatewayMulticastDomainAssociations struct {
}

func (*awsEc2query_serializeOpRejectTransitGatewayMulticastDomainAssociations) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRejectTransitGatewayMulticastDomainAssociations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RejectTransitGatewayMulticastDomainAssociationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RejectTransitGatewayMulticastDomainAssociations")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentRejectTransitGatewayMulticastDomainAssociationsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRejectTransitGatewayPeeringAttachment struct {
}

func (*awsEc2query_serializeOpRejectTransitGatewayPeeringAttachment) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRejectTransitGatewayPeeringAttachment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RejectTransitGatewayPeeringAttachmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RejectTransitGatewayPeeringAttachment")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentRejectTransitGatewayPeeringAttachmentInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRejectTransitGatewayVpcAttachment struct {
}

func (*awsEc2query_serializeOpRejectTransitGatewayVpcAttachment) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRejectTransitGatewayVpcAttachment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RejectTransitGatewayVpcAttachmentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RejectTransitGatewayVpcAttachment")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentRejectTransitGatewayVpcAttachmentInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRejectVpcEndpointConnections struct {
}

func (*awsEc2query_serializeOpRejectVpcEndpointConnections) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRejectVpcEndpointConnections) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RejectVpcEndpointConnectionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RejectVpcEndpointConnections")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentRejectVpcEndpointConnectionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRejectVpcPeeringConnection struct {
}

func (*awsEc2query_serializeOpRejectVpcPeeringConnection) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRejectVpcPeeringConnection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RejectVpcPeeringConnectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RejectVpcPeeringConnection")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentRejectVpcPeeringConnectionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpReleaseAddress struct {
}

func (*awsEc2query_serializeOpReleaseAddress) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpReleaseAddress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReleaseAddressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ReleaseAddress")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentReleaseAddressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpReleaseHosts struct {
}

func (*awsEc2query_serializeOpReleaseHosts) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpReleaseHosts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReleaseHostsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ReleaseHosts")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentReleaseHostsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpReplaceIamInstanceProfileAssociation struct {
}

func (*awsEc2query_serializeOpReplaceIamInstanceProfileAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpReplaceIamInstanceProfileAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReplaceIamInstanceProfileAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ReplaceIamInstanceProfileAssociation")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentReplaceIamInstanceProfileAssociationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpReplaceNetworkAclAssociation struct {
}

func (*awsEc2query_serializeOpReplaceNetworkAclAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpReplaceNetworkAclAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReplaceNetworkAclAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ReplaceNetworkAclAssociation")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentReplaceNetworkAclAssociationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpReplaceNetworkAclEntry struct {
}

func (*awsEc2query_serializeOpReplaceNetworkAclEntry) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpReplaceNetworkAclEntry) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReplaceNetworkAclEntryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ReplaceNetworkAclEntry")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentReplaceNetworkAclEntryInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpReplaceRoute struct {
}

func (*awsEc2query_serializeOpReplaceRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpReplaceRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReplaceRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ReplaceRoute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentReplaceRouteInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpReplaceRouteTableAssociation struct {
}

func (*awsEc2query_serializeOpReplaceRouteTableAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpReplaceRouteTableAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReplaceRouteTableAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ReplaceRouteTableAssociation")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentReplaceRouteTableAssociationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpReplaceTransitGatewayRoute struct {
}

func (*awsEc2query_serializeOpReplaceTransitGatewayRoute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpReplaceTransitGatewayRoute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReplaceTransitGatewayRouteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ReplaceTransitGatewayRoute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentReplaceTransitGatewayRouteInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpReportInstanceStatus struct {
}

func (*awsEc2query_serializeOpReportInstanceStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpReportInstanceStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ReportInstanceStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ReportInstanceStatus")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentReportInstanceStatusInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRequestSpotFleet struct {
}

func (*awsEc2query_serializeOpRequestSpotFleet) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRequestSpotFleet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RequestSpotFleetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RequestSpotFleet")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentRequestSpotFleetInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRequestSpotInstances struct {
}

func (*awsEc2query_serializeOpRequestSpotInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRequestSpotInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RequestSpotInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RequestSpotInstances")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentRequestSpotInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpResetEbsDefaultKmsKeyId struct {
}

func (*awsEc2query_serializeOpResetEbsDefaultKmsKeyId) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpResetEbsDefaultKmsKeyId) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ResetEbsDefaultKmsKeyIdInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ResetEbsDefaultKmsKeyId")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentResetEbsDefaultKmsKeyIdInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpResetFpgaImageAttribute struct {
}

func (*awsEc2query_serializeOpResetFpgaImageAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpResetFpgaImageAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ResetFpgaImageAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ResetFpgaImageAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentResetFpgaImageAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpResetImageAttribute struct {
}

func (*awsEc2query_serializeOpResetImageAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpResetImageAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ResetImageAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ResetImageAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentResetImageAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpResetInstanceAttribute struct {
}

func (*awsEc2query_serializeOpResetInstanceAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpResetInstanceAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ResetInstanceAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ResetInstanceAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentResetInstanceAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpResetNetworkInterfaceAttribute struct {
}

func (*awsEc2query_serializeOpResetNetworkInterfaceAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpResetNetworkInterfaceAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ResetNetworkInterfaceAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ResetNetworkInterfaceAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentResetNetworkInterfaceAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpResetSnapshotAttribute struct {
}

func (*awsEc2query_serializeOpResetSnapshotAttribute) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpResetSnapshotAttribute) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ResetSnapshotAttributeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("ResetSnapshotAttribute")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentResetSnapshotAttributeInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRestoreAddressToClassic struct {
}

func (*awsEc2query_serializeOpRestoreAddressToClassic) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRestoreAddressToClassic) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RestoreAddressToClassicInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RestoreAddressToClassic")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentRestoreAddressToClassicInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRestoreManagedPrefixListVersion struct {
}

func (*awsEc2query_serializeOpRestoreManagedPrefixListVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRestoreManagedPrefixListVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RestoreManagedPrefixListVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RestoreManagedPrefixListVersion")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentRestoreManagedPrefixListVersionInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRevokeClientVpnIngress struct {
}

func (*awsEc2query_serializeOpRevokeClientVpnIngress) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRevokeClientVpnIngress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RevokeClientVpnIngressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RevokeClientVpnIngress")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentRevokeClientVpnIngressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRevokeSecurityGroupEgress struct {
}

func (*awsEc2query_serializeOpRevokeSecurityGroupEgress) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRevokeSecurityGroupEgress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RevokeSecurityGroupEgressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RevokeSecurityGroupEgress")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentRevokeSecurityGroupEgressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRevokeSecurityGroupIngress struct {
}

func (*awsEc2query_serializeOpRevokeSecurityGroupIngress) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRevokeSecurityGroupIngress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RevokeSecurityGroupIngressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RevokeSecurityGroupIngress")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentRevokeSecurityGroupIngressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRunInstances struct {
}

func (*awsEc2query_serializeOpRunInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRunInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RunInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RunInstances")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentRunInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpRunScheduledInstances struct {
}

func (*awsEc2query_serializeOpRunScheduledInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpRunScheduledInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RunScheduledInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("RunScheduledInstances")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentRunScheduledInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpSearchLocalGatewayRoutes struct {
}

func (*awsEc2query_serializeOpSearchLocalGatewayRoutes) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpSearchLocalGatewayRoutes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchLocalGatewayRoutesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SearchLocalGatewayRoutes")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentSearchLocalGatewayRoutesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpSearchTransitGatewayMulticastGroups struct {
}

func (*awsEc2query_serializeOpSearchTransitGatewayMulticastGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpSearchTransitGatewayMulticastGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchTransitGatewayMulticastGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SearchTransitGatewayMulticastGroups")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentSearchTransitGatewayMulticastGroupsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpSearchTransitGatewayRoutes struct {
}

func (*awsEc2query_serializeOpSearchTransitGatewayRoutes) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpSearchTransitGatewayRoutes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchTransitGatewayRoutesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SearchTransitGatewayRoutes")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentSearchTransitGatewayRoutesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpSendDiagnosticInterrupt struct {
}

func (*awsEc2query_serializeOpSendDiagnosticInterrupt) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpSendDiagnosticInterrupt) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SendDiagnosticInterruptInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("SendDiagnosticInterrupt")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentSendDiagnosticInterruptInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpStartInstances struct {
}

func (*awsEc2query_serializeOpStartInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpStartInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("StartInstances")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentStartInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpStartNetworkInsightsAnalysis struct {
}

func (*awsEc2query_serializeOpStartNetworkInsightsAnalysis) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpStartNetworkInsightsAnalysis) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartNetworkInsightsAnalysisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("StartNetworkInsightsAnalysis")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentStartNetworkInsightsAnalysisInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpStartVpcEndpointServicePrivateDnsVerification struct {
}

func (*awsEc2query_serializeOpStartVpcEndpointServicePrivateDnsVerification) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpStartVpcEndpointServicePrivateDnsVerification) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartVpcEndpointServicePrivateDnsVerificationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("StartVpcEndpointServicePrivateDnsVerification")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentStartVpcEndpointServicePrivateDnsVerificationInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpStopInstances struct {
}

func (*awsEc2query_serializeOpStopInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpStopInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("StopInstances")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentStopInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpTerminateClientVpnConnections struct {
}

func (*awsEc2query_serializeOpTerminateClientVpnConnections) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpTerminateClientVpnConnections) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TerminateClientVpnConnectionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("TerminateClientVpnConnections")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentTerminateClientVpnConnectionsInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpTerminateInstances struct {
}

func (*awsEc2query_serializeOpTerminateInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpTerminateInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TerminateInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("TerminateInstances")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentTerminateInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpUnassignIpv6Addresses struct {
}

func (*awsEc2query_serializeOpUnassignIpv6Addresses) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpUnassignIpv6Addresses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UnassignIpv6AddressesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UnassignIpv6Addresses")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentUnassignIpv6AddressesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpUnassignPrivateIpAddresses struct {
}

func (*awsEc2query_serializeOpUnassignPrivateIpAddresses) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpUnassignPrivateIpAddresses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UnassignPrivateIpAddressesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UnassignPrivateIpAddresses")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentUnassignPrivateIpAddressesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpUnmonitorInstances struct {
}

func (*awsEc2query_serializeOpUnmonitorInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpUnmonitorInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UnmonitorInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UnmonitorInstances")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentUnmonitorInstancesInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpUpdateSecurityGroupRuleDescriptionsEgress struct {
}

func (*awsEc2query_serializeOpUpdateSecurityGroupRuleDescriptionsEgress) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpUpdateSecurityGroupRuleDescriptionsEgress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSecurityGroupRuleDescriptionsEgressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UpdateSecurityGroupRuleDescriptionsEgress")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentUpdateSecurityGroupRuleDescriptionsEgressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpUpdateSecurityGroupRuleDescriptionsIngress struct {
}

func (*awsEc2query_serializeOpUpdateSecurityGroupRuleDescriptionsIngress) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpUpdateSecurityGroupRuleDescriptionsIngress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSecurityGroupRuleDescriptionsIngressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("UpdateSecurityGroupRuleDescriptionsIngress")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentUpdateSecurityGroupRuleDescriptionsIngressInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsEc2query_serializeOpWithdrawByoipCidr struct {
}

func (*awsEc2query_serializeOpWithdrawByoipCidr) ID() string {
	return "OperationSerializer"
}

func (m *awsEc2query_serializeOpWithdrawByoipCidr) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*WithdrawByoipCidrInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	request.Request.URL.Path = "/"
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-www-form-urlencoded")

	bodyWriter := bytes.NewBuffer(nil)
	bodyEncoder := query.NewEncoder(bodyWriter)
	body := bodyEncoder.Object()
	body.Key("Action").String("WithdrawByoipCidr")
	body.Key("Version").String("2016-11-15")

	if err := awsEc2query_serializeOpDocumentWithdrawByoipCidrInput(input, bodyEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	err = bodyEncoder.Encode()
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(bodyWriter.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsEc2query_serializeDocumentAccountAttributeNameStringList(v []types.AccountAttributeName, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("AttributeName")

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsEc2query_serializeDocumentAddPrefixListEntries(v []types.AddPrefixListEntry, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentAddPrefixListEntry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentAddPrefixListEntry(v *types.AddPrefixListEntry, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Cidr != nil {
		objectKey := object.Key("Cidr")
		objectKey.String(*v.Cidr)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	return nil
}

func awsEc2query_serializeDocumentAllocationIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("AllocationId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentArnList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentAssociationIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("AssociationId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentAttributeBooleanValue(v *types.AttributeBooleanValue, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Value {
		objectKey := object.Key("Value")
		objectKey.Boolean(v.Value)
	}

	return nil
}

func awsEc2query_serializeDocumentAttributeValue(v *types.AttributeValue, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsEc2query_serializeDocumentAvailabilityZoneStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("AvailabilityZone")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentBillingProductList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentBlobAttributeValue(v *types.BlobAttributeValue, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.Base64EncodeBytes(v.Value)
	}

	return nil
}

func awsEc2query_serializeDocumentBlockDeviceMapping(v *types.BlockDeviceMapping, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DeviceName != nil {
		objectKey := object.Key("DeviceName")
		objectKey.String(*v.DeviceName)
	}

	if v.Ebs != nil {
		objectKey := object.Key("Ebs")
		if err := awsEc2query_serializeDocumentEbsBlockDevice(v.Ebs, objectKey); err != nil {
			return err
		}
	}

	if v.NoDevice != nil {
		objectKey := object.Key("NoDevice")
		objectKey.String(*v.NoDevice)
	}

	if v.VirtualName != nil {
		objectKey := object.Key("VirtualName")
		objectKey.String(*v.VirtualName)
	}

	return nil
}

func awsEc2query_serializeDocumentBlockDeviceMappingList(v []types.BlockDeviceMapping, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentBlockDeviceMapping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentBlockDeviceMappingRequestList(v []types.BlockDeviceMapping, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("BlockDeviceMapping")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentBlockDeviceMapping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentBundleIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("BundleId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentCapacityReservationIdSet(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentCapacityReservationOptionsRequest(v *types.CapacityReservationOptionsRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.UsageStrategy) > 0 {
		objectKey := object.Key("UsageStrategy")
		objectKey.String(string(v.UsageStrategy))
	}

	return nil
}

func awsEc2query_serializeDocumentCapacityReservationSpecification(v *types.CapacityReservationSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.CapacityReservationPreference) > 0 {
		objectKey := object.Key("CapacityReservationPreference")
		objectKey.String(string(v.CapacityReservationPreference))
	}

	if v.CapacityReservationTarget != nil {
		objectKey := object.Key("CapacityReservationTarget")
		if err := awsEc2query_serializeDocumentCapacityReservationTarget(v.CapacityReservationTarget, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentCapacityReservationTarget(v *types.CapacityReservationTarget, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CapacityReservationId != nil {
		objectKey := object.Key("CapacityReservationId")
		objectKey.String(*v.CapacityReservationId)
	}

	if v.CapacityReservationResourceGroupArn != nil {
		objectKey := object.Key("CapacityReservationResourceGroupArn")
		objectKey.String(*v.CapacityReservationResourceGroupArn)
	}

	return nil
}

func awsEc2query_serializeDocumentCarrierGatewayIdSet(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentCertificateAuthenticationRequest(v *types.CertificateAuthenticationRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClientRootCertificateChainArn != nil {
		objectKey := object.Key("ClientRootCertificateChainArn")
		objectKey.String(*v.ClientRootCertificateChainArn)
	}

	return nil
}

func awsEc2query_serializeDocumentCidrAuthorizationContext(v *types.CidrAuthorizationContext, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Message != nil {
		objectKey := object.Key("Message")
		objectKey.String(*v.Message)
	}

	if v.Signature != nil {
		objectKey := object.Key("Signature")
		objectKey.String(*v.Signature)
	}

	return nil
}

func awsEc2query_serializeDocumentClassicLoadBalancer(v *types.ClassicLoadBalancer, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	return nil
}

func awsEc2query_serializeDocumentClassicLoadBalancers(v []types.ClassicLoadBalancer, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentClassicLoadBalancer(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentClassicLoadBalancersConfig(v *types.ClassicLoadBalancersConfig, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClassicLoadBalancers != nil {
		objectKey := object.FlatKey("ClassicLoadBalancers")
		if err := awsEc2query_serializeDocumentClassicLoadBalancers(v.ClassicLoadBalancers, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentClientConnectOptions(v *types.ClientConnectOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enabled {
		objectKey := object.Key("Enabled")
		objectKey.Boolean(v.Enabled)
	}

	if v.LambdaFunctionArn != nil {
		objectKey := object.Key("LambdaFunctionArn")
		objectKey.String(*v.LambdaFunctionArn)
	}

	return nil
}

func awsEc2query_serializeDocumentClientData(v *types.ClientData, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Comment != nil {
		objectKey := object.Key("Comment")
		objectKey.String(*v.Comment)
	}

	if v.UploadEnd != nil {
		objectKey := object.Key("UploadEnd")
		objectKey.String(smithytime.FormatDateTime(*v.UploadEnd))
	}

	if v.UploadSize != 0 {
		objectKey := object.Key("UploadSize")
		objectKey.Double(v.UploadSize)
	}

	if v.UploadStart != nil {
		objectKey := object.Key("UploadStart")
		objectKey.String(smithytime.FormatDateTime(*v.UploadStart))
	}

	return nil
}

func awsEc2query_serializeDocumentClientVpnAuthenticationRequest(v *types.ClientVpnAuthenticationRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ActiveDirectory != nil {
		objectKey := object.Key("ActiveDirectory")
		if err := awsEc2query_serializeDocumentDirectoryServiceAuthenticationRequest(v.ActiveDirectory, objectKey); err != nil {
			return err
		}
	}

	if v.FederatedAuthentication != nil {
		objectKey := object.Key("FederatedAuthentication")
		if err := awsEc2query_serializeDocumentFederatedAuthenticationRequest(v.FederatedAuthentication, objectKey); err != nil {
			return err
		}
	}

	if v.MutualAuthentication != nil {
		objectKey := object.Key("MutualAuthentication")
		if err := awsEc2query_serializeDocumentCertificateAuthenticationRequest(v.MutualAuthentication, objectKey); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		objectKey := object.Key("Type")
		objectKey.String(string(v.Type))
	}

	return nil
}

func awsEc2query_serializeDocumentClientVpnAuthenticationRequestList(v []types.ClientVpnAuthenticationRequest, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentClientVpnAuthenticationRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentClientVpnEndpointIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentClientVpnSecurityGroupIdSet(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentCoipPoolIdSet(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentConnectionLogOptions(v *types.ConnectionLogOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CloudwatchLogGroup != nil {
		objectKey := object.Key("CloudwatchLogGroup")
		objectKey.String(*v.CloudwatchLogGroup)
	}

	if v.CloudwatchLogStream != nil {
		objectKey := object.Key("CloudwatchLogStream")
		objectKey.String(*v.CloudwatchLogStream)
	}

	if v.Enabled {
		objectKey := object.Key("Enabled")
		objectKey.Boolean(v.Enabled)
	}

	return nil
}

func awsEc2query_serializeDocumentConnectionNotificationIdsList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentConversionIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentCpuOptionsRequest(v *types.CpuOptionsRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CoreCount != 0 {
		objectKey := object.Key("CoreCount")
		objectKey.Integer(v.CoreCount)
	}

	if v.ThreadsPerCore != 0 {
		objectKey := object.Key("ThreadsPerCore")
		objectKey.Integer(v.ThreadsPerCore)
	}

	return nil
}

func awsEc2query_serializeDocumentCreateTransitGatewayConnectRequestOptions(v *types.CreateTransitGatewayConnectRequestOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Protocol) > 0 {
		objectKey := object.Key("Protocol")
		objectKey.String(string(v.Protocol))
	}

	return nil
}

func awsEc2query_serializeDocumentCreateTransitGatewayMulticastDomainRequestOptions(v *types.CreateTransitGatewayMulticastDomainRequestOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.AutoAcceptSharedAssociations) > 0 {
		objectKey := object.Key("AutoAcceptSharedAssociations")
		objectKey.String(string(v.AutoAcceptSharedAssociations))
	}

	if len(v.Igmpv2Support) > 0 {
		objectKey := object.Key("Igmpv2Support")
		objectKey.String(string(v.Igmpv2Support))
	}

	if len(v.StaticSourcesSupport) > 0 {
		objectKey := object.Key("StaticSourcesSupport")
		objectKey.String(string(v.StaticSourcesSupport))
	}

	return nil
}

func awsEc2query_serializeDocumentCreateTransitGatewayVpcAttachmentRequestOptions(v *types.CreateTransitGatewayVpcAttachmentRequestOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.ApplianceModeSupport) > 0 {
		objectKey := object.Key("ApplianceModeSupport")
		objectKey.String(string(v.ApplianceModeSupport))
	}

	if len(v.DnsSupport) > 0 {
		objectKey := object.Key("DnsSupport")
		objectKey.String(string(v.DnsSupport))
	}

	if len(v.Ipv6Support) > 0 {
		objectKey := object.Key("Ipv6Support")
		objectKey.String(string(v.Ipv6Support))
	}

	return nil
}

func awsEc2query_serializeDocumentCreateVolumePermission(v *types.CreateVolumePermission, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Group) > 0 {
		objectKey := object.Key("Group")
		objectKey.String(string(v.Group))
	}

	if v.UserId != nil {
		objectKey := object.Key("UserId")
		objectKey.String(*v.UserId)
	}

	return nil
}

func awsEc2query_serializeDocumentCreateVolumePermissionList(v []types.CreateVolumePermission, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentCreateVolumePermission(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentCreateVolumePermissionModifications(v *types.CreateVolumePermissionModifications, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Add != nil {
		objectKey := object.FlatKey("Add")
		if err := awsEc2query_serializeDocumentCreateVolumePermissionList(v.Add, objectKey); err != nil {
			return err
		}
	}

	if v.Remove != nil {
		objectKey := object.FlatKey("Remove")
		if err := awsEc2query_serializeDocumentCreateVolumePermissionList(v.Remove, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentCreditSpecificationRequest(v *types.CreditSpecificationRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CpuCredits != nil {
		objectKey := object.Key("CpuCredits")
		objectKey.String(*v.CpuCredits)
	}

	return nil
}

func awsEc2query_serializeDocumentCustomerGatewayIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("CustomerGatewayId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentDeleteQueuedReservedInstancesIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentDeregisterInstanceTagAttributeRequest(v *types.DeregisterInstanceTagAttributeRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.IncludeAllTagsOfInstance {
		objectKey := object.Key("IncludeAllTagsOfInstance")
		objectKey.Boolean(v.IncludeAllTagsOfInstance)
	}

	if v.InstanceTagKeys != nil {
		objectKey := object.FlatKey("InstanceTagKey")
		if err := awsEc2query_serializeDocumentInstanceTagKeySet(v.InstanceTagKeys, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentDhcpOptionsIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("DhcpOptionsId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentDirectoryServiceAuthenticationRequest(v *types.DirectoryServiceAuthenticationRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DirectoryId != nil {
		objectKey := object.Key("DirectoryId")
		objectKey.String(*v.DirectoryId)
	}

	return nil
}

func awsEc2query_serializeDocumentDiskImage(v *types.DiskImage, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.Image != nil {
		objectKey := object.Key("Image")
		if err := awsEc2query_serializeDocumentDiskImageDetail(v.Image, objectKey); err != nil {
			return err
		}
	}

	if v.Volume != nil {
		objectKey := object.Key("Volume")
		if err := awsEc2query_serializeDocumentVolumeDetail(v.Volume, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentDiskImageDetail(v *types.DiskImageDetail, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Bytes != 0 {
		objectKey := object.Key("Bytes")
		objectKey.Long(v.Bytes)
	}

	if len(v.Format) > 0 {
		objectKey := object.Key("Format")
		objectKey.String(string(v.Format))
	}

	if v.ImportManifestUrl != nil {
		objectKey := object.Key("ImportManifestUrl")
		objectKey.String(*v.ImportManifestUrl)
	}

	return nil
}

func awsEc2query_serializeDocumentDiskImageList(v []types.DiskImage, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentDiskImage(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentDnsServersOptionsModifyStructure(v *types.DnsServersOptionsModifyStructure, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CustomDnsServers != nil {
		objectKey := object.FlatKey("CustomDnsServers")
		if err := awsEc2query_serializeDocumentValueStringList(v.CustomDnsServers, objectKey); err != nil {
			return err
		}
	}

	if v.Enabled {
		objectKey := object.Key("Enabled")
		objectKey.Boolean(v.Enabled)
	}

	return nil
}

func awsEc2query_serializeDocumentEbsBlockDevice(v *types.EbsBlockDevice, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DeleteOnTermination {
		objectKey := object.Key("DeleteOnTermination")
		objectKey.Boolean(v.DeleteOnTermination)
	}

	if v.Encrypted {
		objectKey := object.Key("Encrypted")
		objectKey.Boolean(v.Encrypted)
	}

	if v.Iops != 0 {
		objectKey := object.Key("Iops")
		objectKey.Integer(v.Iops)
	}

	if v.KmsKeyId != nil {
		objectKey := object.Key("KmsKeyId")
		objectKey.String(*v.KmsKeyId)
	}

	if v.SnapshotId != nil {
		objectKey := object.Key("SnapshotId")
		objectKey.String(*v.SnapshotId)
	}

	if v.Throughput != 0 {
		objectKey := object.Key("Throughput")
		objectKey.Integer(v.Throughput)
	}

	if v.VolumeSize != 0 {
		objectKey := object.Key("VolumeSize")
		objectKey.Integer(v.VolumeSize)
	}

	if len(v.VolumeType) > 0 {
		objectKey := object.Key("VolumeType")
		objectKey.String(string(v.VolumeType))
	}

	return nil
}

func awsEc2query_serializeDocumentEbsInstanceBlockDeviceSpecification(v *types.EbsInstanceBlockDeviceSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DeleteOnTermination {
		objectKey := object.Key("DeleteOnTermination")
		objectKey.Boolean(v.DeleteOnTermination)
	}

	if v.VolumeId != nil {
		objectKey := object.Key("VolumeId")
		objectKey.String(*v.VolumeId)
	}

	return nil
}

func awsEc2query_serializeDocumentEgressOnlyInternetGatewayIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentElasticGpuIdSet(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentElasticGpuSpecification(v *types.ElasticGpuSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Type != nil {
		objectKey := object.Key("Type")
		objectKey.String(*v.Type)
	}

	return nil
}

func awsEc2query_serializeDocumentElasticGpuSpecificationList(v []types.ElasticGpuSpecification, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("ElasticGpuSpecification")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentElasticGpuSpecification(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentElasticGpuSpecifications(v []types.ElasticGpuSpecification, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentElasticGpuSpecification(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentElasticInferenceAccelerator(v *types.ElasticInferenceAccelerator, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Count != 0 {
		objectKey := object.Key("Count")
		objectKey.Integer(v.Count)
	}

	if v.Type != nil {
		objectKey := object.Key("Type")
		objectKey.String(*v.Type)
	}

	return nil
}

func awsEc2query_serializeDocumentElasticInferenceAccelerators(v []types.ElasticInferenceAccelerator, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentElasticInferenceAccelerator(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentEnclaveOptionsRequest(v *types.EnclaveOptionsRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enabled {
		objectKey := object.Key("Enabled")
		objectKey.Boolean(v.Enabled)
	}

	return nil
}

func awsEc2query_serializeDocumentExecutableByStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("ExecutableBy")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentExportImageTaskIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("ExportImageTaskId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentExportTaskIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("ExportTaskId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentExportTaskS3LocationRequest(v *types.ExportTaskS3LocationRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.S3Bucket != nil {
		objectKey := object.Key("S3Bucket")
		objectKey.String(*v.S3Bucket)
	}

	if v.S3Prefix != nil {
		objectKey := object.Key("S3Prefix")
		objectKey.String(*v.S3Prefix)
	}

	return nil
}

func awsEc2query_serializeDocumentExportToS3TaskSpecification(v *types.ExportToS3TaskSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.ContainerFormat) > 0 {
		objectKey := object.Key("ContainerFormat")
		objectKey.String(string(v.ContainerFormat))
	}

	if len(v.DiskImageFormat) > 0 {
		objectKey := object.Key("DiskImageFormat")
		objectKey.String(string(v.DiskImageFormat))
	}

	if v.S3Bucket != nil {
		objectKey := object.Key("S3Bucket")
		objectKey.String(*v.S3Bucket)
	}

	if v.S3Prefix != nil {
		objectKey := object.Key("S3Prefix")
		objectKey.String(*v.S3Prefix)
	}

	return nil
}

func awsEc2query_serializeDocumentFederatedAuthenticationRequest(v *types.FederatedAuthenticationRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.SAMLProviderArn != nil {
		objectKey := object.Key("SAMLProviderArn")
		objectKey.String(*v.SAMLProviderArn)
	}

	if v.SelfServiceSAMLProviderArn != nil {
		objectKey := object.Key("SelfServiceSAMLProviderArn")
		objectKey.String(*v.SelfServiceSAMLProviderArn)
	}

	return nil
}

func awsEc2query_serializeDocumentFilter(v *types.Filter, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	if v.Values != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentValueStringList(v.Values, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentFilterList(v []types.Filter, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Filter")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentFleetIdSet(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentFleetLaunchTemplateConfigListRequest(v []types.FleetLaunchTemplateConfigRequest, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentFleetLaunchTemplateConfigRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentFleetLaunchTemplateConfigRequest(v *types.FleetLaunchTemplateConfigRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LaunchTemplateSpecification != nil {
		objectKey := object.Key("LaunchTemplateSpecification")
		if err := awsEc2query_serializeDocumentFleetLaunchTemplateSpecificationRequest(v.LaunchTemplateSpecification, objectKey); err != nil {
			return err
		}
	}

	if v.Overrides != nil {
		objectKey := object.FlatKey("Overrides")
		if err := awsEc2query_serializeDocumentFleetLaunchTemplateOverridesListRequest(v.Overrides, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentFleetLaunchTemplateOverridesListRequest(v []types.FleetLaunchTemplateOverridesRequest, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentFleetLaunchTemplateOverridesRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentFleetLaunchTemplateOverridesRequest(v *types.FleetLaunchTemplateOverridesRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	if len(v.InstanceType) > 0 {
		objectKey := object.Key("InstanceType")
		objectKey.String(string(v.InstanceType))
	}

	if v.MaxPrice != nil {
		objectKey := object.Key("MaxPrice")
		objectKey.String(*v.MaxPrice)
	}

	if v.Placement != nil {
		objectKey := object.Key("Placement")
		if err := awsEc2query_serializeDocumentPlacement(v.Placement, objectKey); err != nil {
			return err
		}
	}

	if v.Priority != 0 {
		objectKey := object.Key("Priority")
		objectKey.Double(v.Priority)
	}

	if v.SubnetId != nil {
		objectKey := object.Key("SubnetId")
		objectKey.String(*v.SubnetId)
	}

	if v.WeightedCapacity != 0 {
		objectKey := object.Key("WeightedCapacity")
		objectKey.Double(v.WeightedCapacity)
	}

	return nil
}

func awsEc2query_serializeDocumentFleetLaunchTemplateSpecification(v *types.FleetLaunchTemplateSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LaunchTemplateId != nil {
		objectKey := object.Key("LaunchTemplateId")
		objectKey.String(*v.LaunchTemplateId)
	}

	if v.LaunchTemplateName != nil {
		objectKey := object.Key("LaunchTemplateName")
		objectKey.String(*v.LaunchTemplateName)
	}

	if v.Version != nil {
		objectKey := object.Key("Version")
		objectKey.String(*v.Version)
	}

	return nil
}

func awsEc2query_serializeDocumentFleetLaunchTemplateSpecificationRequest(v *types.FleetLaunchTemplateSpecificationRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LaunchTemplateId != nil {
		objectKey := object.Key("LaunchTemplateId")
		objectKey.String(*v.LaunchTemplateId)
	}

	if v.LaunchTemplateName != nil {
		objectKey := object.Key("LaunchTemplateName")
		objectKey.String(*v.LaunchTemplateName)
	}

	if v.Version != nil {
		objectKey := object.Key("Version")
		objectKey.String(*v.Version)
	}

	return nil
}

func awsEc2query_serializeDocumentFleetSpotCapacityRebalanceRequest(v *types.FleetSpotCapacityRebalanceRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.ReplacementStrategy) > 0 {
		objectKey := object.Key("ReplacementStrategy")
		objectKey.String(string(v.ReplacementStrategy))
	}

	return nil
}

func awsEc2query_serializeDocumentFleetSpotMaintenanceStrategiesRequest(v *types.FleetSpotMaintenanceStrategiesRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CapacityRebalance != nil {
		objectKey := object.Key("CapacityRebalance")
		if err := awsEc2query_serializeDocumentFleetSpotCapacityRebalanceRequest(v.CapacityRebalance, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentFlowLogIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentFlowLogResourceIds(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentFpgaImageIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentGroupIdentifier(v *types.GroupIdentifier, value query.Value) error {
	object := value.Object()
	_ = object

	if v.GroupId != nil {
		objectKey := object.Key("GroupId")
		objectKey.String(*v.GroupId)
	}

	if v.GroupName != nil {
		objectKey := object.Key("GroupName")
		objectKey.String(*v.GroupName)
	}

	return nil
}

func awsEc2query_serializeDocumentGroupIdentifierList(v []types.GroupIdentifier, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentGroupIdentifier(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentGroupIds(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentGroupIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("GroupId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentGroupNameStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("GroupName")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentHibernationOptionsRequest(v *types.HibernationOptionsRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Configured {
		objectKey := object.Key("Configured")
		objectKey.Boolean(v.Configured)
	}

	return nil
}

func awsEc2query_serializeDocumentHostReservationIdSet(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentIamInstanceProfileSpecification(v *types.IamInstanceProfileSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Arn != nil {
		objectKey := object.Key("Arn")
		objectKey.String(*v.Arn)
	}

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	return nil
}

func awsEc2query_serializeDocumentIcmpTypeCode(v *types.IcmpTypeCode, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Code != 0 {
		objectKey := object.Key("Code")
		objectKey.Integer(v.Code)
	}

	if v.Type != 0 {
		objectKey := object.Key("Type")
		objectKey.Integer(v.Type)
	}

	return nil
}

func awsEc2query_serializeDocumentIKEVersionsRequestList(v []types.IKEVersionsRequestListValue, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentIKEVersionsRequestListValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentIKEVersionsRequestListValue(v *types.IKEVersionsRequestListValue, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsEc2query_serializeDocumentImageDiskContainer(v *types.ImageDiskContainer, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.DeviceName != nil {
		objectKey := object.Key("DeviceName")
		objectKey.String(*v.DeviceName)
	}

	if v.Format != nil {
		objectKey := object.Key("Format")
		objectKey.String(*v.Format)
	}

	if v.SnapshotId != nil {
		objectKey := object.Key("SnapshotId")
		objectKey.String(*v.SnapshotId)
	}

	if v.Url != nil {
		objectKey := object.Key("Url")
		objectKey.String(*v.Url)
	}

	if v.UserBucket != nil {
		objectKey := object.Key("UserBucket")
		if err := awsEc2query_serializeDocumentUserBucket(v.UserBucket, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentImageDiskContainerList(v []types.ImageDiskContainer, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentImageDiskContainer(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentImageIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("ImageId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentImportImageLicenseConfigurationRequest(v *types.ImportImageLicenseConfigurationRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LicenseConfigurationArn != nil {
		objectKey := object.Key("LicenseConfigurationArn")
		objectKey.String(*v.LicenseConfigurationArn)
	}

	return nil
}

func awsEc2query_serializeDocumentImportImageLicenseSpecificationListRequest(v []types.ImportImageLicenseConfigurationRequest, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentImportImageLicenseConfigurationRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentImportInstanceLaunchSpecification(v *types.ImportInstanceLaunchSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AdditionalInfo != nil {
		objectKey := object.Key("AdditionalInfo")
		objectKey.String(*v.AdditionalInfo)
	}

	if len(v.Architecture) > 0 {
		objectKey := object.Key("Architecture")
		objectKey.String(string(v.Architecture))
	}

	if v.GroupIds != nil {
		objectKey := object.FlatKey("GroupId")
		if err := awsEc2query_serializeDocumentSecurityGroupIdStringList(v.GroupIds, objectKey); err != nil {
			return err
		}
	}

	if v.GroupNames != nil {
		objectKey := object.FlatKey("GroupName")
		if err := awsEc2query_serializeDocumentSecurityGroupStringList(v.GroupNames, objectKey); err != nil {
			return err
		}
	}

	if len(v.InstanceInitiatedShutdownBehavior) > 0 {
		objectKey := object.Key("InstanceInitiatedShutdownBehavior")
		objectKey.String(string(v.InstanceInitiatedShutdownBehavior))
	}

	if len(v.InstanceType) > 0 {
		objectKey := object.Key("InstanceType")
		objectKey.String(string(v.InstanceType))
	}

	if v.Monitoring {
		objectKey := object.Key("Monitoring")
		objectKey.Boolean(v.Monitoring)
	}

	if v.Placement != nil {
		objectKey := object.Key("Placement")
		if err := awsEc2query_serializeDocumentPlacement(v.Placement, objectKey); err != nil {
			return err
		}
	}

	if v.PrivateIpAddress != nil {
		objectKey := object.Key("PrivateIpAddress")
		objectKey.String(*v.PrivateIpAddress)
	}

	if v.SubnetId != nil {
		objectKey := object.Key("SubnetId")
		objectKey.String(*v.SubnetId)
	}

	if v.UserData != nil {
		objectKey := object.Key("UserData")
		if err := awsEc2query_serializeDocumentUserData(v.UserData, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentImportSnapshotTaskIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("ImportTaskId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentImportTaskIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("ImportTaskId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentInsideCidrBlocksStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentInstanceBlockDeviceMappingSpecification(v *types.InstanceBlockDeviceMappingSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DeviceName != nil {
		objectKey := object.Key("DeviceName")
		objectKey.String(*v.DeviceName)
	}

	if v.Ebs != nil {
		objectKey := object.Key("Ebs")
		if err := awsEc2query_serializeDocumentEbsInstanceBlockDeviceSpecification(v.Ebs, objectKey); err != nil {
			return err
		}
	}

	if v.NoDevice != nil {
		objectKey := object.Key("NoDevice")
		objectKey.String(*v.NoDevice)
	}

	if v.VirtualName != nil {
		objectKey := object.Key("VirtualName")
		objectKey.String(*v.VirtualName)
	}

	return nil
}

func awsEc2query_serializeDocumentInstanceBlockDeviceMappingSpecificationList(v []types.InstanceBlockDeviceMappingSpecification, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentInstanceBlockDeviceMappingSpecification(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentInstanceCreditSpecificationListRequest(v []types.InstanceCreditSpecificationRequest, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentInstanceCreditSpecificationRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentInstanceCreditSpecificationRequest(v *types.InstanceCreditSpecificationRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CpuCredits != nil {
		objectKey := object.Key("CpuCredits")
		objectKey.String(*v.CpuCredits)
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	return nil
}

func awsEc2query_serializeDocumentInstanceIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("InstanceId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentInstanceIpv6Address(v *types.InstanceIpv6Address, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Ipv6Address != nil {
		objectKey := object.Key("Ipv6Address")
		objectKey.String(*v.Ipv6Address)
	}

	return nil
}

func awsEc2query_serializeDocumentInstanceIpv6AddressList(v []types.InstanceIpv6Address, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentInstanceIpv6Address(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentInstanceIpv6AddressListRequest(v []types.InstanceIpv6AddressRequest, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("InstanceIpv6Address")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentInstanceIpv6AddressRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentInstanceIpv6AddressRequest(v *types.InstanceIpv6AddressRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Ipv6Address != nil {
		objectKey := object.Key("Ipv6Address")
		objectKey.String(*v.Ipv6Address)
	}

	return nil
}

func awsEc2query_serializeDocumentInstanceMarketOptionsRequest(v *types.InstanceMarketOptionsRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.MarketType) > 0 {
		objectKey := object.Key("MarketType")
		objectKey.String(string(v.MarketType))
	}

	if v.SpotOptions != nil {
		objectKey := object.Key("SpotOptions")
		if err := awsEc2query_serializeDocumentSpotMarketOptions(v.SpotOptions, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentInstanceMetadataOptionsRequest(v *types.InstanceMetadataOptionsRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.HttpEndpoint) > 0 {
		objectKey := object.Key("HttpEndpoint")
		objectKey.String(string(v.HttpEndpoint))
	}

	if v.HttpPutResponseHopLimit != 0 {
		objectKey := object.Key("HttpPutResponseHopLimit")
		objectKey.Integer(v.HttpPutResponseHopLimit)
	}

	if len(v.HttpTokens) > 0 {
		objectKey := object.Key("HttpTokens")
		objectKey.String(string(v.HttpTokens))
	}

	return nil
}

func awsEc2query_serializeDocumentInstanceNetworkInterfaceSpecification(v *types.InstanceNetworkInterfaceSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AssociateCarrierIpAddress {
		objectKey := object.Key("AssociateCarrierIpAddress")
		objectKey.Boolean(v.AssociateCarrierIpAddress)
	}

	if v.AssociatePublicIpAddress {
		objectKey := object.Key("AssociatePublicIpAddress")
		objectKey.Boolean(v.AssociatePublicIpAddress)
	}

	if v.DeleteOnTermination {
		objectKey := object.Key("DeleteOnTermination")
		objectKey.Boolean(v.DeleteOnTermination)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.DeviceIndex != 0 {
		objectKey := object.Key("DeviceIndex")
		objectKey.Integer(v.DeviceIndex)
	}

	if v.Groups != nil {
		objectKey := object.FlatKey("SecurityGroupId")
		if err := awsEc2query_serializeDocumentSecurityGroupIdStringList(v.Groups, objectKey); err != nil {
			return err
		}
	}

	if v.InterfaceType != nil {
		objectKey := object.Key("InterfaceType")
		objectKey.String(*v.InterfaceType)
	}

	if v.Ipv6AddressCount != 0 {
		objectKey := object.Key("Ipv6AddressCount")
		objectKey.Integer(v.Ipv6AddressCount)
	}

	if v.Ipv6Addresses != nil {
		objectKey := object.FlatKey("Ipv6Addresses")
		if err := awsEc2query_serializeDocumentInstanceIpv6AddressList(v.Ipv6Addresses, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkCardIndex != 0 {
		objectKey := object.Key("NetworkCardIndex")
		objectKey.Integer(v.NetworkCardIndex)
	}

	if v.NetworkInterfaceId != nil {
		objectKey := object.Key("NetworkInterfaceId")
		objectKey.String(*v.NetworkInterfaceId)
	}

	if v.PrivateIpAddress != nil {
		objectKey := object.Key("PrivateIpAddress")
		objectKey.String(*v.PrivateIpAddress)
	}

	if v.PrivateIpAddresses != nil {
		objectKey := object.FlatKey("PrivateIpAddresses")
		if err := awsEc2query_serializeDocumentPrivateIpAddressSpecificationList(v.PrivateIpAddresses, objectKey); err != nil {
			return err
		}
	}

	if v.SecondaryPrivateIpAddressCount != 0 {
		objectKey := object.Key("SecondaryPrivateIpAddressCount")
		objectKey.Integer(v.SecondaryPrivateIpAddressCount)
	}

	if v.SubnetId != nil {
		objectKey := object.Key("SubnetId")
		objectKey.String(*v.SubnetId)
	}

	return nil
}

func awsEc2query_serializeDocumentInstanceNetworkInterfaceSpecificationList(v []types.InstanceNetworkInterfaceSpecification, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentInstanceNetworkInterfaceSpecification(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentInstanceSpecification(v *types.InstanceSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ExcludeBootVolume {
		objectKey := object.Key("ExcludeBootVolume")
		objectKey.Boolean(v.ExcludeBootVolume)
	}

	if v.InstanceId != nil {
		objectKey := object.Key("InstanceId")
		objectKey.String(*v.InstanceId)
	}

	return nil
}

func awsEc2query_serializeDocumentInstanceTagKeySet(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentInstanceTypeList(v []types.InstanceType, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsEc2query_serializeDocumentInternetGatewayIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentIpPermission(v *types.IpPermission, value query.Value) error {
	object := value.Object()
	_ = object

	if v.FromPort != 0 {
		objectKey := object.Key("FromPort")
		objectKey.Integer(v.FromPort)
	}

	if v.IpProtocol != nil {
		objectKey := object.Key("IpProtocol")
		objectKey.String(*v.IpProtocol)
	}

	if v.IpRanges != nil {
		objectKey := object.FlatKey("IpRanges")
		if err := awsEc2query_serializeDocumentIpRangeList(v.IpRanges, objectKey); err != nil {
			return err
		}
	}

	if v.Ipv6Ranges != nil {
		objectKey := object.FlatKey("Ipv6Ranges")
		if err := awsEc2query_serializeDocumentIpv6RangeList(v.Ipv6Ranges, objectKey); err != nil {
			return err
		}
	}

	if v.PrefixListIds != nil {
		objectKey := object.FlatKey("PrefixListIds")
		if err := awsEc2query_serializeDocumentPrefixListIdList(v.PrefixListIds, objectKey); err != nil {
			return err
		}
	}

	if v.ToPort != 0 {
		objectKey := object.Key("ToPort")
		objectKey.Integer(v.ToPort)
	}

	if v.UserIdGroupPairs != nil {
		objectKey := object.FlatKey("Groups")
		if err := awsEc2query_serializeDocumentUserIdGroupPairList(v.UserIdGroupPairs, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentIpPermissionList(v []types.IpPermission, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentIpPermission(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentIpRange(v *types.IpRange, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CidrIp != nil {
		objectKey := object.Key("CidrIp")
		objectKey.String(*v.CidrIp)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	return nil
}

func awsEc2query_serializeDocumentIpRangeList(v []types.IpRange, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentIpRange(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentIpv6AddressList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentIpv6PoolIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentIpv6Range(v *types.Ipv6Range, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CidrIpv6 != nil {
		objectKey := object.Key("CidrIpv6")
		objectKey.String(*v.CidrIpv6)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	return nil
}

func awsEc2query_serializeDocumentIpv6RangeList(v []types.Ipv6Range, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentIpv6Range(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentKeyNameStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("KeyName")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentKeyPairIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("KeyPairId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentLaunchPermission(v *types.LaunchPermission, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Group) > 0 {
		objectKey := object.Key("Group")
		objectKey.String(string(v.Group))
	}

	if v.UserId != nil {
		objectKey := object.Key("UserId")
		objectKey.String(*v.UserId)
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchPermissionList(v []types.LaunchPermission, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentLaunchPermission(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentLaunchPermissionModifications(v *types.LaunchPermissionModifications, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Add != nil {
		objectKey := object.FlatKey("Add")
		if err := awsEc2query_serializeDocumentLaunchPermissionList(v.Add, objectKey); err != nil {
			return err
		}
	}

	if v.Remove != nil {
		objectKey := object.FlatKey("Remove")
		if err := awsEc2query_serializeDocumentLaunchPermissionList(v.Remove, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchSpecsList(v []types.SpotFleetLaunchSpecification, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentSpotFleetLaunchSpecification(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateBlockDeviceMappingRequest(v *types.LaunchTemplateBlockDeviceMappingRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DeviceName != nil {
		objectKey := object.Key("DeviceName")
		objectKey.String(*v.DeviceName)
	}

	if v.Ebs != nil {
		objectKey := object.Key("Ebs")
		if err := awsEc2query_serializeDocumentLaunchTemplateEbsBlockDeviceRequest(v.Ebs, objectKey); err != nil {
			return err
		}
	}

	if v.NoDevice != nil {
		objectKey := object.Key("NoDevice")
		objectKey.String(*v.NoDevice)
	}

	if v.VirtualName != nil {
		objectKey := object.Key("VirtualName")
		objectKey.String(*v.VirtualName)
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateBlockDeviceMappingRequestList(v []types.LaunchTemplateBlockDeviceMappingRequest, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("BlockDeviceMapping")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentLaunchTemplateBlockDeviceMappingRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateCapacityReservationSpecificationRequest(v *types.LaunchTemplateCapacityReservationSpecificationRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.CapacityReservationPreference) > 0 {
		objectKey := object.Key("CapacityReservationPreference")
		objectKey.String(string(v.CapacityReservationPreference))
	}

	if v.CapacityReservationTarget != nil {
		objectKey := object.Key("CapacityReservationTarget")
		if err := awsEc2query_serializeDocumentCapacityReservationTarget(v.CapacityReservationTarget, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateConfig(v *types.LaunchTemplateConfig, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LaunchTemplateSpecification != nil {
		objectKey := object.Key("LaunchTemplateSpecification")
		if err := awsEc2query_serializeDocumentFleetLaunchTemplateSpecification(v.LaunchTemplateSpecification, objectKey); err != nil {
			return err
		}
	}

	if v.Overrides != nil {
		objectKey := object.FlatKey("Overrides")
		if err := awsEc2query_serializeDocumentLaunchTemplateOverridesList(v.Overrides, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateConfigList(v []types.LaunchTemplateConfig, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentLaunchTemplateConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateCpuOptionsRequest(v *types.LaunchTemplateCpuOptionsRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.CoreCount != 0 {
		objectKey := object.Key("CoreCount")
		objectKey.Integer(v.CoreCount)
	}

	if v.ThreadsPerCore != 0 {
		objectKey := object.Key("ThreadsPerCore")
		objectKey.Integer(v.ThreadsPerCore)
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateEbsBlockDeviceRequest(v *types.LaunchTemplateEbsBlockDeviceRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DeleteOnTermination {
		objectKey := object.Key("DeleteOnTermination")
		objectKey.Boolean(v.DeleteOnTermination)
	}

	if v.Encrypted {
		objectKey := object.Key("Encrypted")
		objectKey.Boolean(v.Encrypted)
	}

	if v.Iops != 0 {
		objectKey := object.Key("Iops")
		objectKey.Integer(v.Iops)
	}

	if v.KmsKeyId != nil {
		objectKey := object.Key("KmsKeyId")
		objectKey.String(*v.KmsKeyId)
	}

	if v.SnapshotId != nil {
		objectKey := object.Key("SnapshotId")
		objectKey.String(*v.SnapshotId)
	}

	if v.Throughput != 0 {
		objectKey := object.Key("Throughput")
		objectKey.Integer(v.Throughput)
	}

	if v.VolumeSize != 0 {
		objectKey := object.Key("VolumeSize")
		objectKey.Integer(v.VolumeSize)
	}

	if len(v.VolumeType) > 0 {
		objectKey := object.Key("VolumeType")
		objectKey.String(string(v.VolumeType))
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateElasticInferenceAccelerator(v *types.LaunchTemplateElasticInferenceAccelerator, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Count != 0 {
		objectKey := object.Key("Count")
		objectKey.Integer(v.Count)
	}

	if v.Type != nil {
		objectKey := object.Key("Type")
		objectKey.String(*v.Type)
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateElasticInferenceAcceleratorList(v []types.LaunchTemplateElasticInferenceAccelerator, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentLaunchTemplateElasticInferenceAccelerator(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateEnclaveOptionsRequest(v *types.LaunchTemplateEnclaveOptionsRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enabled {
		objectKey := object.Key("Enabled")
		objectKey.Boolean(v.Enabled)
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateHibernationOptionsRequest(v *types.LaunchTemplateHibernationOptionsRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Configured {
		objectKey := object.Key("Configured")
		objectKey.Boolean(v.Configured)
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateIamInstanceProfileSpecificationRequest(v *types.LaunchTemplateIamInstanceProfileSpecificationRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Arn != nil {
		objectKey := object.Key("Arn")
		objectKey.String(*v.Arn)
	}

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateInstanceMarketOptionsRequest(v *types.LaunchTemplateInstanceMarketOptionsRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.MarketType) > 0 {
		objectKey := object.Key("MarketType")
		objectKey.String(string(v.MarketType))
	}

	if v.SpotOptions != nil {
		objectKey := object.Key("SpotOptions")
		if err := awsEc2query_serializeDocumentLaunchTemplateSpotMarketOptionsRequest(v.SpotOptions, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateInstanceMetadataOptionsRequest(v *types.LaunchTemplateInstanceMetadataOptionsRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.HttpEndpoint) > 0 {
		objectKey := object.Key("HttpEndpoint")
		objectKey.String(string(v.HttpEndpoint))
	}

	if v.HttpPutResponseHopLimit != 0 {
		objectKey := object.Key("HttpPutResponseHopLimit")
		objectKey.Integer(v.HttpPutResponseHopLimit)
	}

	if len(v.HttpTokens) > 0 {
		objectKey := object.Key("HttpTokens")
		objectKey.String(string(v.HttpTokens))
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateInstanceNetworkInterfaceSpecificationRequest(v *types.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AssociateCarrierIpAddress {
		objectKey := object.Key("AssociateCarrierIpAddress")
		objectKey.Boolean(v.AssociateCarrierIpAddress)
	}

	if v.AssociatePublicIpAddress {
		objectKey := object.Key("AssociatePublicIpAddress")
		objectKey.Boolean(v.AssociatePublicIpAddress)
	}

	if v.DeleteOnTermination {
		objectKey := object.Key("DeleteOnTermination")
		objectKey.Boolean(v.DeleteOnTermination)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.DeviceIndex != 0 {
		objectKey := object.Key("DeviceIndex")
		objectKey.Integer(v.DeviceIndex)
	}

	if v.Groups != nil {
		objectKey := object.FlatKey("SecurityGroupId")
		if err := awsEc2query_serializeDocumentSecurityGroupIdStringList(v.Groups, objectKey); err != nil {
			return err
		}
	}

	if v.InterfaceType != nil {
		objectKey := object.Key("InterfaceType")
		objectKey.String(*v.InterfaceType)
	}

	if v.Ipv6AddressCount != 0 {
		objectKey := object.Key("Ipv6AddressCount")
		objectKey.Integer(v.Ipv6AddressCount)
	}

	if v.Ipv6Addresses != nil {
		objectKey := object.FlatKey("Ipv6Addresses")
		if err := awsEc2query_serializeDocumentInstanceIpv6AddressListRequest(v.Ipv6Addresses, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkCardIndex != 0 {
		objectKey := object.Key("NetworkCardIndex")
		objectKey.Integer(v.NetworkCardIndex)
	}

	if v.NetworkInterfaceId != nil {
		objectKey := object.Key("NetworkInterfaceId")
		objectKey.String(*v.NetworkInterfaceId)
	}

	if v.PrivateIpAddress != nil {
		objectKey := object.Key("PrivateIpAddress")
		objectKey.String(*v.PrivateIpAddress)
	}

	if v.PrivateIpAddresses != nil {
		objectKey := object.FlatKey("PrivateIpAddresses")
		if err := awsEc2query_serializeDocumentPrivateIpAddressSpecificationList(v.PrivateIpAddresses, objectKey); err != nil {
			return err
		}
	}

	if v.SecondaryPrivateIpAddressCount != 0 {
		objectKey := object.Key("SecondaryPrivateIpAddressCount")
		objectKey.Integer(v.SecondaryPrivateIpAddressCount)
	}

	if v.SubnetId != nil {
		objectKey := object.Key("SubnetId")
		objectKey.String(*v.SubnetId)
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateInstanceNetworkInterfaceSpecificationRequestList(v []types.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("InstanceNetworkInterfaceSpecification")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentLaunchTemplateInstanceNetworkInterfaceSpecificationRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateLicenseConfigurationRequest(v *types.LaunchTemplateLicenseConfigurationRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LicenseConfigurationArn != nil {
		objectKey := object.Key("LicenseConfigurationArn")
		objectKey.String(*v.LicenseConfigurationArn)
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateLicenseSpecificationListRequest(v []types.LaunchTemplateLicenseConfigurationRequest, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentLaunchTemplateLicenseConfigurationRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateNameStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateOverrides(v *types.LaunchTemplateOverrides, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	if len(v.InstanceType) > 0 {
		objectKey := object.Key("InstanceType")
		objectKey.String(string(v.InstanceType))
	}

	if v.Priority != 0 {
		objectKey := object.Key("Priority")
		objectKey.Double(v.Priority)
	}

	if v.SpotPrice != nil {
		objectKey := object.Key("SpotPrice")
		objectKey.String(*v.SpotPrice)
	}

	if v.SubnetId != nil {
		objectKey := object.Key("SubnetId")
		objectKey.String(*v.SubnetId)
	}

	if v.WeightedCapacity != 0 {
		objectKey := object.Key("WeightedCapacity")
		objectKey.Double(v.WeightedCapacity)
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateOverridesList(v []types.LaunchTemplateOverrides, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentLaunchTemplateOverrides(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentLaunchTemplatePlacementRequest(v *types.LaunchTemplatePlacementRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Affinity != nil {
		objectKey := object.Key("Affinity")
		objectKey.String(*v.Affinity)
	}

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	if v.GroupName != nil {
		objectKey := object.Key("GroupName")
		objectKey.String(*v.GroupName)
	}

	if v.HostId != nil {
		objectKey := object.Key("HostId")
		objectKey.String(*v.HostId)
	}

	if v.HostResourceGroupArn != nil {
		objectKey := object.Key("HostResourceGroupArn")
		objectKey.String(*v.HostResourceGroupArn)
	}

	if v.PartitionNumber != 0 {
		objectKey := object.Key("PartitionNumber")
		objectKey.Integer(v.PartitionNumber)
	}

	if v.SpreadDomain != nil {
		objectKey := object.Key("SpreadDomain")
		objectKey.String(*v.SpreadDomain)
	}

	if len(v.Tenancy) > 0 {
		objectKey := object.Key("Tenancy")
		objectKey.String(string(v.Tenancy))
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchTemplatesMonitoringRequest(v *types.LaunchTemplatesMonitoringRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enabled {
		objectKey := object.Key("Enabled")
		objectKey.Boolean(v.Enabled)
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateSpecification(v *types.LaunchTemplateSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LaunchTemplateId != nil {
		objectKey := object.Key("LaunchTemplateId")
		objectKey.String(*v.LaunchTemplateId)
	}

	if v.LaunchTemplateName != nil {
		objectKey := object.Key("LaunchTemplateName")
		objectKey.String(*v.LaunchTemplateName)
	}

	if v.Version != nil {
		objectKey := object.Key("Version")
		objectKey.String(*v.Version)
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateSpotMarketOptionsRequest(v *types.LaunchTemplateSpotMarketOptionsRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BlockDurationMinutes != 0 {
		objectKey := object.Key("BlockDurationMinutes")
		objectKey.Integer(v.BlockDurationMinutes)
	}

	if len(v.InstanceInterruptionBehavior) > 0 {
		objectKey := object.Key("InstanceInterruptionBehavior")
		objectKey.String(string(v.InstanceInterruptionBehavior))
	}

	if v.MaxPrice != nil {
		objectKey := object.Key("MaxPrice")
		objectKey.String(*v.MaxPrice)
	}

	if len(v.SpotInstanceType) > 0 {
		objectKey := object.Key("SpotInstanceType")
		objectKey.String(string(v.SpotInstanceType))
	}

	if v.ValidUntil != nil {
		objectKey := object.Key("ValidUntil")
		objectKey.String(smithytime.FormatDateTime(*v.ValidUntil))
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateTagSpecificationRequest(v *types.LaunchTemplateTagSpecificationRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.ResourceType) > 0 {
		objectKey := object.Key("ResourceType")
		objectKey.String(string(v.ResourceType))
	}

	if v.Tags != nil {
		objectKey := object.FlatKey("Tag")
		if err := awsEc2query_serializeDocumentTagList(v.Tags, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentLaunchTemplateTagSpecificationRequestList(v []types.LaunchTemplateTagSpecificationRequest, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("LaunchTemplateTagSpecificationRequest")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentLaunchTemplateTagSpecificationRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentLicenseConfigurationRequest(v *types.LicenseConfigurationRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.LicenseConfigurationArn != nil {
		objectKey := object.Key("LicenseConfigurationArn")
		objectKey.String(*v.LicenseConfigurationArn)
	}

	return nil
}

func awsEc2query_serializeDocumentLicenseSpecificationListRequest(v []types.LicenseConfigurationRequest, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentLicenseConfigurationRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentLoadBalancersConfig(v *types.LoadBalancersConfig, value query.Value) error {
	object := value.Object()
	_ = object

	if v.ClassicLoadBalancersConfig != nil {
		objectKey := object.Key("ClassicLoadBalancersConfig")
		if err := awsEc2query_serializeDocumentClassicLoadBalancersConfig(v.ClassicLoadBalancersConfig, objectKey); err != nil {
			return err
		}
	}

	if v.TargetGroupsConfig != nil {
		objectKey := object.Key("TargetGroupsConfig")
		if err := awsEc2query_serializeDocumentTargetGroupsConfig(v.TargetGroupsConfig, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentLoadPermissionListRequest(v []types.LoadPermissionRequest, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentLoadPermissionRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentLoadPermissionModifications(v *types.LoadPermissionModifications, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Add != nil {
		objectKey := object.FlatKey("Add")
		if err := awsEc2query_serializeDocumentLoadPermissionListRequest(v.Add, objectKey); err != nil {
			return err
		}
	}

	if v.Remove != nil {
		objectKey := object.FlatKey("Remove")
		if err := awsEc2query_serializeDocumentLoadPermissionListRequest(v.Remove, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentLoadPermissionRequest(v *types.LoadPermissionRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.Group) > 0 {
		objectKey := object.Key("Group")
		objectKey.String(string(v.Group))
	}

	if v.UserId != nil {
		objectKey := object.Key("UserId")
		objectKey.String(*v.UserId)
	}

	return nil
}

func awsEc2query_serializeDocumentLocalGatewayIdSet(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentLocalGatewayRouteTableIdSet(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentLocalGatewayRouteTableVirtualInterfaceGroupAssociationIdSet(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentLocalGatewayRouteTableVpcAssociationIdSet(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentLocalGatewayVirtualInterfaceGroupIdSet(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentLocalGatewayVirtualInterfaceIdSet(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentModifyTransitGatewayOptions(v *types.ModifyTransitGatewayOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AddTransitGatewayCidrBlocks != nil {
		objectKey := object.FlatKey("AddTransitGatewayCidrBlocks")
		if err := awsEc2query_serializeDocumentTransitGatewayCidrBlockStringList(v.AddTransitGatewayCidrBlocks, objectKey); err != nil {
			return err
		}
	}

	if v.AssociationDefaultRouteTableId != nil {
		objectKey := object.Key("AssociationDefaultRouteTableId")
		objectKey.String(*v.AssociationDefaultRouteTableId)
	}

	if len(v.AutoAcceptSharedAttachments) > 0 {
		objectKey := object.Key("AutoAcceptSharedAttachments")
		objectKey.String(string(v.AutoAcceptSharedAttachments))
	}

	if len(v.DefaultRouteTableAssociation) > 0 {
		objectKey := object.Key("DefaultRouteTableAssociation")
		objectKey.String(string(v.DefaultRouteTableAssociation))
	}

	if len(v.DefaultRouteTablePropagation) > 0 {
		objectKey := object.Key("DefaultRouteTablePropagation")
		objectKey.String(string(v.DefaultRouteTablePropagation))
	}

	if len(v.DnsSupport) > 0 {
		objectKey := object.Key("DnsSupport")
		objectKey.String(string(v.DnsSupport))
	}

	if v.PropagationDefaultRouteTableId != nil {
		objectKey := object.Key("PropagationDefaultRouteTableId")
		objectKey.String(*v.PropagationDefaultRouteTableId)
	}

	if v.RemoveTransitGatewayCidrBlocks != nil {
		objectKey := object.FlatKey("RemoveTransitGatewayCidrBlocks")
		if err := awsEc2query_serializeDocumentTransitGatewayCidrBlockStringList(v.RemoveTransitGatewayCidrBlocks, objectKey); err != nil {
			return err
		}
	}

	if len(v.VpnEcmpSupport) > 0 {
		objectKey := object.Key("VpnEcmpSupport")
		objectKey.String(string(v.VpnEcmpSupport))
	}

	return nil
}

func awsEc2query_serializeDocumentModifyTransitGatewayVpcAttachmentRequestOptions(v *types.ModifyTransitGatewayVpcAttachmentRequestOptions, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.ApplianceModeSupport) > 0 {
		objectKey := object.Key("ApplianceModeSupport")
		objectKey.String(string(v.ApplianceModeSupport))
	}

	if len(v.DnsSupport) > 0 {
		objectKey := object.Key("DnsSupport")
		objectKey.String(string(v.DnsSupport))
	}

	if len(v.Ipv6Support) > 0 {
		objectKey := object.Key("Ipv6Support")
		objectKey.String(string(v.Ipv6Support))
	}

	return nil
}

func awsEc2query_serializeDocumentModifyVpnTunnelOptionsSpecification(v *types.ModifyVpnTunnelOptionsSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DPDTimeoutAction != nil {
		objectKey := object.Key("DPDTimeoutAction")
		objectKey.String(*v.DPDTimeoutAction)
	}

	if v.DPDTimeoutSeconds != 0 {
		objectKey := object.Key("DPDTimeoutSeconds")
		objectKey.Integer(v.DPDTimeoutSeconds)
	}

	if v.IKEVersions != nil {
		objectKey := object.FlatKey("IKEVersion")
		if err := awsEc2query_serializeDocumentIKEVersionsRequestList(v.IKEVersions, objectKey); err != nil {
			return err
		}
	}

	if v.Phase1DHGroupNumbers != nil {
		objectKey := object.FlatKey("Phase1DHGroupNumber")
		if err := awsEc2query_serializeDocumentPhase1DHGroupNumbersRequestList(v.Phase1DHGroupNumbers, objectKey); err != nil {
			return err
		}
	}

	if v.Phase1EncryptionAlgorithms != nil {
		objectKey := object.FlatKey("Phase1EncryptionAlgorithm")
		if err := awsEc2query_serializeDocumentPhase1EncryptionAlgorithmsRequestList(v.Phase1EncryptionAlgorithms, objectKey); err != nil {
			return err
		}
	}

	if v.Phase1IntegrityAlgorithms != nil {
		objectKey := object.FlatKey("Phase1IntegrityAlgorithm")
		if err := awsEc2query_serializeDocumentPhase1IntegrityAlgorithmsRequestList(v.Phase1IntegrityAlgorithms, objectKey); err != nil {
			return err
		}
	}

	if v.Phase1LifetimeSeconds != 0 {
		objectKey := object.Key("Phase1LifetimeSeconds")
		objectKey.Integer(v.Phase1LifetimeSeconds)
	}

	if v.Phase2DHGroupNumbers != nil {
		objectKey := object.FlatKey("Phase2DHGroupNumber")
		if err := awsEc2query_serializeDocumentPhase2DHGroupNumbersRequestList(v.Phase2DHGroupNumbers, objectKey); err != nil {
			return err
		}
	}

	if v.Phase2EncryptionAlgorithms != nil {
		objectKey := object.FlatKey("Phase2EncryptionAlgorithm")
		if err := awsEc2query_serializeDocumentPhase2EncryptionAlgorithmsRequestList(v.Phase2EncryptionAlgorithms, objectKey); err != nil {
			return err
		}
	}

	if v.Phase2IntegrityAlgorithms != nil {
		objectKey := object.FlatKey("Phase2IntegrityAlgorithm")
		if err := awsEc2query_serializeDocumentPhase2IntegrityAlgorithmsRequestList(v.Phase2IntegrityAlgorithms, objectKey); err != nil {
			return err
		}
	}

	if v.Phase2LifetimeSeconds != 0 {
		objectKey := object.Key("Phase2LifetimeSeconds")
		objectKey.Integer(v.Phase2LifetimeSeconds)
	}

	if v.PreSharedKey != nil {
		objectKey := object.Key("PreSharedKey")
		objectKey.String(*v.PreSharedKey)
	}

	if v.RekeyFuzzPercentage != 0 {
		objectKey := object.Key("RekeyFuzzPercentage")
		objectKey.Integer(v.RekeyFuzzPercentage)
	}

	if v.RekeyMarginTimeSeconds != 0 {
		objectKey := object.Key("RekeyMarginTimeSeconds")
		objectKey.Integer(v.RekeyMarginTimeSeconds)
	}

	if v.ReplayWindowSize != 0 {
		objectKey := object.Key("ReplayWindowSize")
		objectKey.Integer(v.ReplayWindowSize)
	}

	if v.StartupAction != nil {
		objectKey := object.Key("StartupAction")
		objectKey.String(*v.StartupAction)
	}

	if v.TunnelInsideCidr != nil {
		objectKey := object.Key("TunnelInsideCidr")
		objectKey.String(*v.TunnelInsideCidr)
	}

	if v.TunnelInsideIpv6Cidr != nil {
		objectKey := object.Key("TunnelInsideIpv6Cidr")
		objectKey.String(*v.TunnelInsideIpv6Cidr)
	}

	return nil
}

func awsEc2query_serializeDocumentNatGatewayIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentNetworkAclIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentNetworkInsightsAnalysisIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentNetworkInsightsPathIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentNetworkInterfaceAttachmentChanges(v *types.NetworkInterfaceAttachmentChanges, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AttachmentId != nil {
		objectKey := object.Key("AttachmentId")
		objectKey.String(*v.AttachmentId)
	}

	if v.DeleteOnTermination {
		objectKey := object.Key("DeleteOnTermination")
		objectKey.Boolean(v.DeleteOnTermination)
	}

	return nil
}

func awsEc2query_serializeDocumentNetworkInterfaceIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentNetworkInterfacePermissionIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentNewDhcpConfiguration(v *types.NewDhcpConfiguration, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Key != nil {
		objectKey := object.Key("Key")
		objectKey.String(*v.Key)
	}

	if v.Values != nil {
		objectKey := object.FlatKey("Value")
		if err := awsEc2query_serializeDocumentValueStringList(v.Values, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentNewDhcpConfigurationList(v []types.NewDhcpConfiguration, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentNewDhcpConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentOccurrenceDayRequestSet(v []int32, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("OccurenceDay")

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentOnDemandOptionsRequest(v *types.OnDemandOptionsRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.AllocationStrategy) > 0 {
		objectKey := object.Key("AllocationStrategy")
		objectKey.String(string(v.AllocationStrategy))
	}

	if v.CapacityReservationOptions != nil {
		objectKey := object.Key("CapacityReservationOptions")
		if err := awsEc2query_serializeDocumentCapacityReservationOptionsRequest(v.CapacityReservationOptions, objectKey); err != nil {
			return err
		}
	}

	if v.MaxTotalPrice != nil {
		objectKey := object.Key("MaxTotalPrice")
		objectKey.String(*v.MaxTotalPrice)
	}

	if v.MinTargetCapacity != 0 {
		objectKey := object.Key("MinTargetCapacity")
		objectKey.Integer(v.MinTargetCapacity)
	}

	if v.SingleAvailabilityZone {
		objectKey := object.Key("SingleAvailabilityZone")
		objectKey.Boolean(v.SingleAvailabilityZone)
	}

	if v.SingleInstanceType {
		objectKey := object.Key("SingleInstanceType")
		objectKey.Boolean(v.SingleInstanceType)
	}

	return nil
}

func awsEc2query_serializeDocumentOwnerStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Owner")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentPeeringConnectionOptionsRequest(v *types.PeeringConnectionOptionsRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AllowDnsResolutionFromRemoteVpc {
		objectKey := object.Key("AllowDnsResolutionFromRemoteVpc")
		objectKey.Boolean(v.AllowDnsResolutionFromRemoteVpc)
	}

	if v.AllowEgressFromLocalClassicLinkToRemoteVpc {
		objectKey := object.Key("AllowEgressFromLocalClassicLinkToRemoteVpc")
		objectKey.Boolean(v.AllowEgressFromLocalClassicLinkToRemoteVpc)
	}

	if v.AllowEgressFromLocalVpcToRemoteClassicLink {
		objectKey := object.Key("AllowEgressFromLocalVpcToRemoteClassicLink")
		objectKey.Boolean(v.AllowEgressFromLocalVpcToRemoteClassicLink)
	}

	return nil
}

func awsEc2query_serializeDocumentPhase1DHGroupNumbersRequestList(v []types.Phase1DHGroupNumbersRequestListValue, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentPhase1DHGroupNumbersRequestListValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentPhase1DHGroupNumbersRequestListValue(v *types.Phase1DHGroupNumbersRequestListValue, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Value != 0 {
		objectKey := object.Key("Value")
		objectKey.Integer(v.Value)
	}

	return nil
}

func awsEc2query_serializeDocumentPhase1EncryptionAlgorithmsRequestList(v []types.Phase1EncryptionAlgorithmsRequestListValue, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentPhase1EncryptionAlgorithmsRequestListValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentPhase1EncryptionAlgorithmsRequestListValue(v *types.Phase1EncryptionAlgorithmsRequestListValue, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsEc2query_serializeDocumentPhase1IntegrityAlgorithmsRequestList(v []types.Phase1IntegrityAlgorithmsRequestListValue, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentPhase1IntegrityAlgorithmsRequestListValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentPhase1IntegrityAlgorithmsRequestListValue(v *types.Phase1IntegrityAlgorithmsRequestListValue, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsEc2query_serializeDocumentPhase2DHGroupNumbersRequestList(v []types.Phase2DHGroupNumbersRequestListValue, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentPhase2DHGroupNumbersRequestListValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentPhase2DHGroupNumbersRequestListValue(v *types.Phase2DHGroupNumbersRequestListValue, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Value != 0 {
		objectKey := object.Key("Value")
		objectKey.Integer(v.Value)
	}

	return nil
}

func awsEc2query_serializeDocumentPhase2EncryptionAlgorithmsRequestList(v []types.Phase2EncryptionAlgorithmsRequestListValue, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentPhase2EncryptionAlgorithmsRequestListValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentPhase2EncryptionAlgorithmsRequestListValue(v *types.Phase2EncryptionAlgorithmsRequestListValue, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsEc2query_serializeDocumentPhase2IntegrityAlgorithmsRequestList(v []types.Phase2IntegrityAlgorithmsRequestListValue, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentPhase2IntegrityAlgorithmsRequestListValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentPhase2IntegrityAlgorithmsRequestListValue(v *types.Phase2IntegrityAlgorithmsRequestListValue, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Value != nil {
		objectKey := object.Key("Value")
		objectKey.String(*v.Value)
	}

	return nil
}

func awsEc2query_serializeDocumentPlacement(v *types.Placement, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Affinity != nil {
		objectKey := object.Key("Affinity")
		objectKey.String(*v.Affinity)
	}

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	if v.GroupName != nil {
		objectKey := object.Key("GroupName")
		objectKey.String(*v.GroupName)
	}

	if v.HostId != nil {
		objectKey := object.Key("HostId")
		objectKey.String(*v.HostId)
	}

	if v.HostResourceGroupArn != nil {
		objectKey := object.Key("HostResourceGroupArn")
		objectKey.String(*v.HostResourceGroupArn)
	}

	if v.PartitionNumber != 0 {
		objectKey := object.Key("PartitionNumber")
		objectKey.Integer(v.PartitionNumber)
	}

	if v.SpreadDomain != nil {
		objectKey := object.Key("SpreadDomain")
		objectKey.String(*v.SpreadDomain)
	}

	if len(v.Tenancy) > 0 {
		objectKey := object.Key("Tenancy")
		objectKey.String(string(v.Tenancy))
	}

	return nil
}

func awsEc2query_serializeDocumentPlacementGroupIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("GroupId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentPlacementGroupStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentPortRange(v *types.PortRange, value query.Value) error {
	object := value.Object()
	_ = object

	if v.From != 0 {
		objectKey := object.Key("From")
		objectKey.Integer(v.From)
	}

	if v.To != 0 {
		objectKey := object.Key("To")
		objectKey.Integer(v.To)
	}

	return nil
}

func awsEc2query_serializeDocumentPrefixListId(v *types.PrefixListId, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.PrefixListId != nil {
		objectKey := object.Key("PrefixListId")
		objectKey.String(*v.PrefixListId)
	}

	return nil
}

func awsEc2query_serializeDocumentPrefixListIdList(v []types.PrefixListId, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentPrefixListId(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentPrefixListResourceIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentPriceScheduleSpecification(v *types.PriceScheduleSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.CurrencyCode) > 0 {
		objectKey := object.Key("CurrencyCode")
		objectKey.String(string(v.CurrencyCode))
	}

	if v.Price != 0 {
		objectKey := object.Key("Price")
		objectKey.Double(v.Price)
	}

	if v.Term != 0 {
		objectKey := object.Key("Term")
		objectKey.Long(v.Term)
	}

	return nil
}

func awsEc2query_serializeDocumentPriceScheduleSpecificationList(v []types.PriceScheduleSpecification, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentPriceScheduleSpecification(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentPrivateIpAddressConfigSet(v []types.ScheduledInstancesPrivateIpAddressConfig, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("PrivateIpAddressConfigSet")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentScheduledInstancesPrivateIpAddressConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentPrivateIpAddressSpecification(v *types.PrivateIpAddressSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Primary {
		objectKey := object.Key("Primary")
		objectKey.Boolean(v.Primary)
	}

	if v.PrivateIpAddress != nil {
		objectKey := object.Key("PrivateIpAddress")
		objectKey.String(*v.PrivateIpAddress)
	}

	return nil
}

func awsEc2query_serializeDocumentPrivateIpAddressSpecificationList(v []types.PrivateIpAddressSpecification, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentPrivateIpAddressSpecification(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentPrivateIpAddressStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("PrivateIpAddress")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentProductCodeStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("ProductCode")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentProductDescriptionList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentPublicIpStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("PublicIp")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentPublicIpv4PoolIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentPurchaseRequest(v *types.PurchaseRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.InstanceCount != 0 {
		objectKey := object.Key("InstanceCount")
		objectKey.Integer(v.InstanceCount)
	}

	if v.PurchaseToken != nil {
		objectKey := object.Key("PurchaseToken")
		objectKey.String(*v.PurchaseToken)
	}

	return nil
}

func awsEc2query_serializeDocumentPurchaseRequestSet(v []types.PurchaseRequest, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("PurchaseRequest")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentPurchaseRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentReasonCodesList(v []types.ReportInstanceReasonCodes, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsEc2query_serializeDocumentRegionNameStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("RegionName")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentRegisterInstanceTagAttributeRequest(v *types.RegisterInstanceTagAttributeRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.IncludeAllTagsOfInstance {
		objectKey := object.Key("IncludeAllTagsOfInstance")
		objectKey.Boolean(v.IncludeAllTagsOfInstance)
	}

	if v.InstanceTagKeys != nil {
		objectKey := object.FlatKey("InstanceTagKey")
		if err := awsEc2query_serializeDocumentInstanceTagKeySet(v.InstanceTagKeys, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentRemovePrefixListEntries(v []types.RemovePrefixListEntry, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentRemovePrefixListEntry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentRemovePrefixListEntry(v *types.RemovePrefixListEntry, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Cidr != nil {
		objectKey := object.Key("Cidr")
		objectKey.String(*v.Cidr)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestHostIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentRequestHostIdSet(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentRequestInstanceTypeList(v []types.InstanceType, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsEc2query_serializeDocumentRequestLaunchTemplateData(v *types.RequestLaunchTemplateData, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BlockDeviceMappings != nil {
		objectKey := object.FlatKey("BlockDeviceMapping")
		if err := awsEc2query_serializeDocumentLaunchTemplateBlockDeviceMappingRequestList(v.BlockDeviceMappings, objectKey); err != nil {
			return err
		}
	}

	if v.CapacityReservationSpecification != nil {
		objectKey := object.Key("CapacityReservationSpecification")
		if err := awsEc2query_serializeDocumentLaunchTemplateCapacityReservationSpecificationRequest(v.CapacityReservationSpecification, objectKey); err != nil {
			return err
		}
	}

	if v.CpuOptions != nil {
		objectKey := object.Key("CpuOptions")
		if err := awsEc2query_serializeDocumentLaunchTemplateCpuOptionsRequest(v.CpuOptions, objectKey); err != nil {
			return err
		}
	}

	if v.CreditSpecification != nil {
		objectKey := object.Key("CreditSpecification")
		if err := awsEc2query_serializeDocumentCreditSpecificationRequest(v.CreditSpecification, objectKey); err != nil {
			return err
		}
	}

	if v.DisableApiTermination {
		objectKey := object.Key("DisableApiTermination")
		objectKey.Boolean(v.DisableApiTermination)
	}

	if v.EbsOptimized {
		objectKey := object.Key("EbsOptimized")
		objectKey.Boolean(v.EbsOptimized)
	}

	if v.ElasticGpuSpecifications != nil {
		objectKey := object.FlatKey("ElasticGpuSpecification")
		if err := awsEc2query_serializeDocumentElasticGpuSpecificationList(v.ElasticGpuSpecifications, objectKey); err != nil {
			return err
		}
	}

	if v.ElasticInferenceAccelerators != nil {
		objectKey := object.FlatKey("ElasticInferenceAccelerator")
		if err := awsEc2query_serializeDocumentLaunchTemplateElasticInferenceAcceleratorList(v.ElasticInferenceAccelerators, objectKey); err != nil {
			return err
		}
	}

	if v.EnclaveOptions != nil {
		objectKey := object.Key("EnclaveOptions")
		if err := awsEc2query_serializeDocumentLaunchTemplateEnclaveOptionsRequest(v.EnclaveOptions, objectKey); err != nil {
			return err
		}
	}

	if v.HibernationOptions != nil {
		objectKey := object.Key("HibernationOptions")
		if err := awsEc2query_serializeDocumentLaunchTemplateHibernationOptionsRequest(v.HibernationOptions, objectKey); err != nil {
			return err
		}
	}

	if v.IamInstanceProfile != nil {
		objectKey := object.Key("IamInstanceProfile")
		if err := awsEc2query_serializeDocumentLaunchTemplateIamInstanceProfileSpecificationRequest(v.IamInstanceProfile, objectKey); err != nil {
			return err
		}
	}

	if v.ImageId != nil {
		objectKey := object.Key("ImageId")
		objectKey.String(*v.ImageId)
	}

	if len(v.InstanceInitiatedShutdownBehavior) > 0 {
		objectKey := object.Key("InstanceInitiatedShutdownBehavior")
		objectKey.String(string(v.InstanceInitiatedShutdownBehavior))
	}

	if v.InstanceMarketOptions != nil {
		objectKey := object.Key("InstanceMarketOptions")
		if err := awsEc2query_serializeDocumentLaunchTemplateInstanceMarketOptionsRequest(v.InstanceMarketOptions, objectKey); err != nil {
			return err
		}
	}

	if len(v.InstanceType) > 0 {
		objectKey := object.Key("InstanceType")
		objectKey.String(string(v.InstanceType))
	}

	if v.KernelId != nil {
		objectKey := object.Key("KernelId")
		objectKey.String(*v.KernelId)
	}

	if v.KeyName != nil {
		objectKey := object.Key("KeyName")
		objectKey.String(*v.KeyName)
	}

	if v.LicenseSpecifications != nil {
		objectKey := object.FlatKey("LicenseSpecification")
		if err := awsEc2query_serializeDocumentLaunchTemplateLicenseSpecificationListRequest(v.LicenseSpecifications, objectKey); err != nil {
			return err
		}
	}

	if v.MetadataOptions != nil {
		objectKey := object.Key("MetadataOptions")
		if err := awsEc2query_serializeDocumentLaunchTemplateInstanceMetadataOptionsRequest(v.MetadataOptions, objectKey); err != nil {
			return err
		}
	}

	if v.Monitoring != nil {
		objectKey := object.Key("Monitoring")
		if err := awsEc2query_serializeDocumentLaunchTemplatesMonitoringRequest(v.Monitoring, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkInterfaces != nil {
		objectKey := object.FlatKey("NetworkInterface")
		if err := awsEc2query_serializeDocumentLaunchTemplateInstanceNetworkInterfaceSpecificationRequestList(v.NetworkInterfaces, objectKey); err != nil {
			return err
		}
	}

	if v.Placement != nil {
		objectKey := object.Key("Placement")
		if err := awsEc2query_serializeDocumentLaunchTemplatePlacementRequest(v.Placement, objectKey); err != nil {
			return err
		}
	}

	if v.RamDiskId != nil {
		objectKey := object.Key("RamDiskId")
		objectKey.String(*v.RamDiskId)
	}

	if v.SecurityGroupIds != nil {
		objectKey := object.FlatKey("SecurityGroupId")
		if err := awsEc2query_serializeDocumentSecurityGroupIdStringList(v.SecurityGroupIds, objectKey); err != nil {
			return err
		}
	}

	if v.SecurityGroups != nil {
		objectKey := object.FlatKey("SecurityGroup")
		if err := awsEc2query_serializeDocumentSecurityGroupStringList(v.SecurityGroups, objectKey); err != nil {
			return err
		}
	}

	if v.TagSpecifications != nil {
		objectKey := object.FlatKey("TagSpecification")
		if err := awsEc2query_serializeDocumentLaunchTemplateTagSpecificationRequestList(v.TagSpecifications, objectKey); err != nil {
			return err
		}
	}

	if v.UserData != nil {
		objectKey := object.Key("UserData")
		objectKey.String(*v.UserData)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestSpotLaunchSpecification(v *types.RequestSpotLaunchSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AddressingType != nil {
		objectKey := object.Key("AddressingType")
		objectKey.String(*v.AddressingType)
	}

	if v.BlockDeviceMappings != nil {
		objectKey := object.FlatKey("BlockDeviceMapping")
		if err := awsEc2query_serializeDocumentBlockDeviceMappingList(v.BlockDeviceMappings, objectKey); err != nil {
			return err
		}
	}

	if v.EbsOptimized {
		objectKey := object.Key("EbsOptimized")
		objectKey.Boolean(v.EbsOptimized)
	}

	if v.IamInstanceProfile != nil {
		objectKey := object.Key("IamInstanceProfile")
		if err := awsEc2query_serializeDocumentIamInstanceProfileSpecification(v.IamInstanceProfile, objectKey); err != nil {
			return err
		}
	}

	if v.ImageId != nil {
		objectKey := object.Key("ImageId")
		objectKey.String(*v.ImageId)
	}

	if len(v.InstanceType) > 0 {
		objectKey := object.Key("InstanceType")
		objectKey.String(string(v.InstanceType))
	}

	if v.KernelId != nil {
		objectKey := object.Key("KernelId")
		objectKey.String(*v.KernelId)
	}

	if v.KeyName != nil {
		objectKey := object.Key("KeyName")
		objectKey.String(*v.KeyName)
	}

	if v.Monitoring != nil {
		objectKey := object.Key("Monitoring")
		if err := awsEc2query_serializeDocumentRunInstancesMonitoringEnabled(v.Monitoring, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkInterfaces != nil {
		objectKey := object.FlatKey("NetworkInterface")
		if err := awsEc2query_serializeDocumentInstanceNetworkInterfaceSpecificationList(v.NetworkInterfaces, objectKey); err != nil {
			return err
		}
	}

	if v.Placement != nil {
		objectKey := object.Key("Placement")
		if err := awsEc2query_serializeDocumentSpotPlacement(v.Placement, objectKey); err != nil {
			return err
		}
	}

	if v.RamdiskId != nil {
		objectKey := object.Key("RamdiskId")
		objectKey.String(*v.RamdiskId)
	}

	if v.SecurityGroupIds != nil {
		objectKey := object.FlatKey("SecurityGroupId")
		if err := awsEc2query_serializeDocumentRequestSpotLaunchSpecificationSecurityGroupIdList(v.SecurityGroupIds, objectKey); err != nil {
			return err
		}
	}

	if v.SecurityGroups != nil {
		objectKey := object.FlatKey("SecurityGroup")
		if err := awsEc2query_serializeDocumentRequestSpotLaunchSpecificationSecurityGroupList(v.SecurityGroups, objectKey); err != nil {
			return err
		}
	}

	if v.SubnetId != nil {
		objectKey := object.Key("SubnetId")
		objectKey.String(*v.SubnetId)
	}

	if v.UserData != nil {
		objectKey := object.Key("UserData")
		objectKey.String(*v.UserData)
	}

	return nil
}

func awsEc2query_serializeDocumentRequestSpotLaunchSpecificationSecurityGroupIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentRequestSpotLaunchSpecificationSecurityGroupList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentReservedInstanceIdSet(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("ReservedInstanceId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentReservedInstanceLimitPrice(v *types.ReservedInstanceLimitPrice, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Amount != 0 {
		objectKey := object.Key("Amount")
		objectKey.Double(v.Amount)
	}

	if len(v.CurrencyCode) > 0 {
		objectKey := object.Key("CurrencyCode")
		objectKey.String(string(v.CurrencyCode))
	}

	return nil
}

func awsEc2query_serializeDocumentReservedInstancesConfiguration(v *types.ReservedInstancesConfiguration, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	if v.InstanceCount != 0 {
		objectKey := object.Key("InstanceCount")
		objectKey.Integer(v.InstanceCount)
	}

	if len(v.InstanceType) > 0 {
		objectKey := object.Key("InstanceType")
		objectKey.String(string(v.InstanceType))
	}

	if v.Platform != nil {
		objectKey := object.Key("Platform")
		objectKey.String(*v.Platform)
	}

	if len(v.Scope) > 0 {
		objectKey := object.Key("Scope")
		objectKey.String(string(v.Scope))
	}

	return nil
}

func awsEc2query_serializeDocumentReservedInstancesConfigurationList(v []types.ReservedInstancesConfiguration, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentReservedInstancesConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentReservedInstancesIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("ReservedInstancesId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentReservedInstancesModificationIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("ReservedInstancesModificationId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentReservedInstancesOfferingIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentResourceIdList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentResourceList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentRestorableByStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Member")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentRouteTableIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Item")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentRunInstancesMonitoringEnabled(v *types.RunInstancesMonitoringEnabled, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enabled {
		objectKey := object.Key("Enabled")
		objectKey.Boolean(v.Enabled)
	}

	return nil
}

func awsEc2query_serializeDocumentS3Storage(v *types.S3Storage, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AWSAccessKeyId != nil {
		objectKey := object.Key("AWSAccessKeyId")
		objectKey.String(*v.AWSAccessKeyId)
	}

	if v.Bucket != nil {
		objectKey := object.Key("Bucket")
		objectKey.String(*v.Bucket)
	}

	if v.Prefix != nil {
		objectKey := object.Key("Prefix")
		objectKey.String(*v.Prefix)
	}

	if v.UploadPolicy != nil {
		objectKey := object.Key("UploadPolicy")
		objectKey.Base64EncodeBytes(v.UploadPolicy)
	}

	if v.UploadPolicySignature != nil {
		objectKey := object.Key("UploadPolicySignature")
		objectKey.String(*v.UploadPolicySignature)
	}

	return nil
}

func awsEc2query_serializeDocumentScheduledInstanceIdRequestSet(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("ScheduledInstanceId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentScheduledInstanceRecurrenceRequest(v *types.ScheduledInstanceRecurrenceRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Frequency != nil {
		objectKey := object.Key("Frequency")
		objectKey.String(*v.Frequency)
	}

	if v.Interval != 0 {
		objectKey := object.Key("Interval")
		objectKey.Integer(v.Interval)
	}

	if v.OccurrenceDays != nil {
		objectKey := object.FlatKey("OccurrenceDay")
		if err := awsEc2query_serializeDocumentOccurrenceDayRequestSet(v.OccurrenceDays, objectKey); err != nil {
			return err
		}
	}

	if v.OccurrenceRelativeToEnd {
		objectKey := object.Key("OccurrenceRelativeToEnd")
		objectKey.Boolean(v.OccurrenceRelativeToEnd)
	}

	if v.OccurrenceUnit != nil {
		objectKey := object.Key("OccurrenceUnit")
		objectKey.String(*v.OccurrenceUnit)
	}

	return nil
}

func awsEc2query_serializeDocumentScheduledInstancesBlockDeviceMapping(v *types.ScheduledInstancesBlockDeviceMapping, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DeviceName != nil {
		objectKey := object.Key("DeviceName")
		objectKey.String(*v.DeviceName)
	}

	if v.Ebs != nil {
		objectKey := object.Key("Ebs")
		if err := awsEc2query_serializeDocumentScheduledInstancesEbs(v.Ebs, objectKey); err != nil {
			return err
		}
	}

	if v.NoDevice != nil {
		objectKey := object.Key("NoDevice")
		objectKey.String(*v.NoDevice)
	}

	if v.VirtualName != nil {
		objectKey := object.Key("VirtualName")
		objectKey.String(*v.VirtualName)
	}

	return nil
}

func awsEc2query_serializeDocumentScheduledInstancesBlockDeviceMappingSet(v []types.ScheduledInstancesBlockDeviceMapping, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("BlockDeviceMapping")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentScheduledInstancesBlockDeviceMapping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentScheduledInstancesEbs(v *types.ScheduledInstancesEbs, value query.Value) error {
	object := value.Object()
	_ = object

	if v.DeleteOnTermination {
		objectKey := object.Key("DeleteOnTermination")
		objectKey.Boolean(v.DeleteOnTermination)
	}

	if v.Encrypted {
		objectKey := object.Key("Encrypted")
		objectKey.Boolean(v.Encrypted)
	}

	if v.Iops != 0 {
		objectKey := object.Key("Iops")
		objectKey.Integer(v.Iops)
	}

	if v.SnapshotId != nil {
		objectKey := object.Key("SnapshotId")
		objectKey.String(*v.SnapshotId)
	}

	if v.VolumeSize != 0 {
		objectKey := object.Key("VolumeSize")
		objectKey.Integer(v.VolumeSize)
	}

	if v.VolumeType != nil {
		objectKey := object.Key("VolumeType")
		objectKey.String(*v.VolumeType)
	}

	return nil
}

func awsEc2query_serializeDocumentScheduledInstancesIamInstanceProfile(v *types.ScheduledInstancesIamInstanceProfile, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Arn != nil {
		objectKey := object.Key("Arn")
		objectKey.String(*v.Arn)
	}

	if v.Name != nil {
		objectKey := object.Key("Name")
		objectKey.String(*v.Name)
	}

	return nil
}

func awsEc2query_serializeDocumentScheduledInstancesIpv6Address(v *types.ScheduledInstancesIpv6Address, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Ipv6Address != nil {
		objectKey := object.Key("Ipv6Address")
		objectKey.String(*v.Ipv6Address)
	}

	return nil
}

func awsEc2query_serializeDocumentScheduledInstancesIpv6AddressList(v []types.ScheduledInstancesIpv6Address, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("Ipv6Address")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentScheduledInstancesIpv6Address(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentScheduledInstancesLaunchSpecification(v *types.ScheduledInstancesLaunchSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if v.BlockDeviceMappings != nil {
		objectKey := object.FlatKey("BlockDeviceMapping")
		if err := awsEc2query_serializeDocumentScheduledInstancesBlockDeviceMappingSet(v.BlockDeviceMappings, objectKey); err != nil {
			return err
		}
	}

	if v.EbsOptimized {
		objectKey := object.Key("EbsOptimized")
		objectKey.Boolean(v.EbsOptimized)
	}

	if v.IamInstanceProfile != nil {
		objectKey := object.Key("IamInstanceProfile")
		if err := awsEc2query_serializeDocumentScheduledInstancesIamInstanceProfile(v.IamInstanceProfile, objectKey); err != nil {
			return err
		}
	}

	if v.ImageId != nil {
		objectKey := object.Key("ImageId")
		objectKey.String(*v.ImageId)
	}

	if v.InstanceType != nil {
		objectKey := object.Key("InstanceType")
		objectKey.String(*v.InstanceType)
	}

	if v.KernelId != nil {
		objectKey := object.Key("KernelId")
		objectKey.String(*v.KernelId)
	}

	if v.KeyName != nil {
		objectKey := object.Key("KeyName")
		objectKey.String(*v.KeyName)
	}

	if v.Monitoring != nil {
		objectKey := object.Key("Monitoring")
		if err := awsEc2query_serializeDocumentScheduledInstancesMonitoring(v.Monitoring, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkInterfaces != nil {
		objectKey := object.FlatKey("NetworkInterface")
		if err := awsEc2query_serializeDocumentScheduledInstancesNetworkInterfaceSet(v.NetworkInterfaces, objectKey); err != nil {
			return err
		}
	}

	if v.Placement != nil {
		objectKey := object.Key("Placement")
		if err := awsEc2query_serializeDocumentScheduledInstancesPlacement(v.Placement, objectKey); err != nil {
			return err
		}
	}

	if v.RamdiskId != nil {
		objectKey := object.Key("RamdiskId")
		objectKey.String(*v.RamdiskId)
	}

	if v.SecurityGroupIds != nil {
		objectKey := object.FlatKey("SecurityGroupId")
		if err := awsEc2query_serializeDocumentScheduledInstancesSecurityGroupIdSet(v.SecurityGroupIds, objectKey); err != nil {
			return err
		}
	}

	if v.SubnetId != nil {
		objectKey := object.Key("SubnetId")
		objectKey.String(*v.SubnetId)
	}

	if v.UserData != nil {
		objectKey := object.Key("UserData")
		objectKey.String(*v.UserData)
	}

	return nil
}

func awsEc2query_serializeDocumentScheduledInstancesMonitoring(v *types.ScheduledInstancesMonitoring, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enabled {
		objectKey := object.Key("Enabled")
		objectKey.Boolean(v.Enabled)
	}

	return nil
}

func awsEc2query_serializeDocumentScheduledInstancesNetworkInterface(v *types.ScheduledInstancesNetworkInterface, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AssociatePublicIpAddress {
		objectKey := object.Key("AssociatePublicIpAddress")
		objectKey.Boolean(v.AssociatePublicIpAddress)
	}

	if v.DeleteOnTermination {
		objectKey := object.Key("DeleteOnTermination")
		objectKey.Boolean(v.DeleteOnTermination)
	}

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.DeviceIndex != 0 {
		objectKey := object.Key("DeviceIndex")
		objectKey.Integer(v.DeviceIndex)
	}

	if v.Groups != nil {
		objectKey := object.FlatKey("Group")
		if err := awsEc2query_serializeDocumentScheduledInstancesSecurityGroupIdSet(v.Groups, objectKey); err != nil {
			return err
		}
	}

	if v.Ipv6AddressCount != 0 {
		objectKey := object.Key("Ipv6AddressCount")
		objectKey.Integer(v.Ipv6AddressCount)
	}

	if v.Ipv6Addresses != nil {
		objectKey := object.FlatKey("Ipv6Address")
		if err := awsEc2query_serializeDocumentScheduledInstancesIpv6AddressList(v.Ipv6Addresses, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkInterfaceId != nil {
		objectKey := object.Key("NetworkInterfaceId")
		objectKey.String(*v.NetworkInterfaceId)
	}

	if v.PrivateIpAddress != nil {
		objectKey := object.Key("PrivateIpAddress")
		objectKey.String(*v.PrivateIpAddress)
	}

	if v.PrivateIpAddressConfigs != nil {
		objectKey := object.FlatKey("PrivateIpAddressConfig")
		if err := awsEc2query_serializeDocumentPrivateIpAddressConfigSet(v.PrivateIpAddressConfigs, objectKey); err != nil {
			return err
		}
	}

	if v.SecondaryPrivateIpAddressCount != 0 {
		objectKey := object.Key("SecondaryPrivateIpAddressCount")
		objectKey.Integer(v.SecondaryPrivateIpAddressCount)
	}

	if v.SubnetId != nil {
		objectKey := object.Key("SubnetId")
		objectKey.String(*v.SubnetId)
	}

	return nil
}

func awsEc2query_serializeDocumentScheduledInstancesNetworkInterfaceSet(v []types.ScheduledInstancesNetworkInterface, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("NetworkInterface")

	for i := range v {
		av := array.Value()
		if err := awsEc2query_serializeDocumentScheduledInstancesNetworkInterface(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsEc2query_serializeDocumentScheduledInstancesPlacement(v *types.ScheduledInstancesPlacement, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AvailabilityZone != nil {
		objectKey := object.Key("AvailabilityZone")
		objectKey.String(*v.AvailabilityZone)
	}

	if v.GroupName != nil {
		objectKey := object.Key("GroupName")
		objectKey.String(*v.GroupName)
	}

	return nil
}

func awsEc2query_serializeDocumentScheduledInstancesPrivateIpAddressConfig(v *types.ScheduledInstancesPrivateIpAddressConfig, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Primary {
		objectKey := object.Key("Primary")
		objectKey.Boolean(v.Primary)
	}

	if v.PrivateIpAddress != nil {
		objectKey := object.Key("PrivateIpAddress")
		objectKey.String(*v.PrivateIpAddress)
	}

	return nil
}

func awsEc2query_serializeDocumentScheduledInstancesSecurityGroupIdSet(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("SecurityGroupId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentSecurityGroupIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("SecurityGroupId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentSecurityGroupStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("SecurityGroup")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentSlotDateTimeRangeRequest(v *types.SlotDateTimeRangeRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.EarliestTime != nil {
		objectKey := object.Key("EarliestTime")
		objectKey.String(smithytime.FormatDateTime(*v.EarliestTime))
	}

	if v.LatestTime != nil {
		objectKey := object.Key("LatestTime")
		objectKey.String(smithytime.FormatDateTime(*v.LatestTime))
	}

	return nil
}

func awsEc2query_serializeDocumentSlotStartTimeRangeRequest(v *types.SlotStartTimeRangeRequest, value query.Value) error {
	object := value.Object()
	_ = object

	if v.EarliestTime != nil {
		objectKey := object.Key("EarliestTime")
		objectKey.String(smithytime.FormatDateTime(*v.EarliestTime))
	}

	if v.LatestTime != nil {
		objectKey := object.Key("LatestTime")
		objectKey.String(smithytime.FormatDateTime(*v.LatestTime))
	}

	return nil
}

func awsEc2query_serializeDocumentSnapshotDiskContainer(v *types.SnapshotDiskContainer, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Description != nil {
		objectKey := object.Key("Description")
		objectKey.String(*v.Description)
	}

	if v.Format != nil {
		objectKey := object.Key("Format")
		objectKey.String(*v.Format)
	}

	if v.Url != nil {
		objectKey := object.Key("Url")
		objectKey.String(*v.Url)
	}

	if v.UserBucket != nil {
		objectKey := object.Key("UserBucket")
		if err := awsEc2query_serializeDocumentUserBucket(v.UserBucket, objectKey); err != nil {
			return err
		}
	}

	return nil
}

func awsEc2query_serializeDocumentSnapshotIdStringList(v []string, value query.Value) error {
	if len(v) == 0 {
		return nil
	}
	array := value.Array("SnapshotId")

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsEc2query_serializeDocumentSpotCapacityRebalance(v *types.SpotCapacityRebalance, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.ReplacementStrategy) > 0 {
		objectKey := object.Key("ReplacementStrategy")
		objectKey.String(string(v.ReplacementStrategy))
	}

	return nil
}

func awsEc2query_serializeDocumentSpotFleetLaunchSpecification(v *types.SpotFleetLaunchSpecification, value query.Value) error {
	object := value.Object()
	_ = object

	if v.AddressingType != nil {
		objectKey := object.Key("AddressingType")
		objectKey.String(*v.AddressingType)
	}

	if v.BlockDeviceMappings != nil {
		objectKey := object.FlatKey("BlockDeviceMapping")
		if err := awsEc2query_serializeDocumentBlockDeviceMappingList(v.BlockDeviceMappings, objectKey); err != nil {
			return err
		}
	}

	if v.EbsOptimized {
		objectKey := object.Key("EbsOptimized")
		objectKey.Boolean(v.EbsOptimized)
	}

	if v.IamInstanceProfile != nil {
		objectKey := object.Key("IamInstanceProfile")
		if err := awsEc2query_serializeDocumentIamInstanceProfileSpecification(v.IamInstanceProfile, objectKey); err != nil {
			return err
		}
	}

	if v.ImageId != nil {
		objectKey := object.Key("ImageId")
		objectKey.String(*v.ImageId)
	}

	if len(v.InstanceType) > 0 {
		objectKey := object.Key("InstanceType")
		objectKey.String(string(v.InstanceType))
	}

	if v.KernelId != nil {
		objectKey := object.Key("KernelId")
		objectKey.String(*v.KernelId)
	}

	if v.KeyName != nil {
		objectKey := object.Key("KeyName")
		objectKey.String(*v.KeyName)
	}

	if v.Monitoring != nil {
		objectKey := object.Key("Monitoring")
		if err := awsEc2query_serializeDocumentSpotFleetMonitoring(v.Monitoring, objectKey); err != nil {
			return err
		}
	}

	if v.NetworkInterfaces != nil {
		objectKey := object.FlatKey("NetworkInterfaceSet")
		if err := awsEc2query_serializeDocumentInstanceNetworkInterfaceSpecificationList(v.NetworkInterfaces, objectKey); err != nil {
			return err
		}
	}

	if v.Placement != nil {
		objectKey := object.Key("Placement")
		if err := awsEc2query_serializeDocumentSpotPlacement(v.Placement, objectKey); err != nil {
			return err
		}
	}

	if v.RamdiskId != nil {
		objectKey := object.Key("RamdiskId")
		objectKey.String(*v.RamdiskId)
	}

	if v.SecurityGroups != nil {
		objectKey := object.FlatKey("GroupSet")
		if err := awsEc2query_serializeDocumentGroupIdentifierList(v.SecurityGroups, objectKey); err != nil {
			return err
		}
	}

	if v.SpotPrice != nil {
		objectKey := object.Key("SpotPrice")
		objectKey.String(*v.SpotPrice)
	}

	if v.SubnetId != nil {
		objectKey := object.Key("SubnetId")
		objectKey.String(*v.SubnetId)
	}

	if v.TagSpecifications != nil {
		objectKey := object.FlatKey("TagSpecificationSet")
		if err := awsEc2query_serializeDocumentSpotFleetTagSpecificationList(v.TagSpecifications, objectKey); err != nil {
			return err
		}
	}

	if v.UserData != nil {
		objectKey := object.Key("UserData")
		objectKey.String(*v.UserData)
	}

	if v.WeightedCapacity != 0 {
		objectKey := object.Key("WeightedCapacity")
		objectKey.Double(v.WeightedCapacity)
	}

	return nil
}

func awsEc2query_serializeDocumentSpotFleetMonitoring(v *types.SpotFleetMonitoring, value query.Value) error {
	object := value.Object()
	_ = object

	if v.Enabled {
		objectKey := object.Key("Enabled")
		objectKey.Boolean(v.Enabled)
	}

	return nil
}

func awsEc2query_serializeDocumentSpotFleetRequestConfigData(v *types.SpotFleetRequestConfigData, value query.Value) error {
	object := value.Object()
	_ = object

	if len(v.AllocationStrategy) > 0 {
		objectKey := object.Key("AllocationStrategy")
		objectKey.String(string(v.AllocationStrategy))
	}

	if v.ClientToken != nil {
		objectKey := object.Key("ClientToken")
		objectKey.String(*v.ClientToken)
	}

	if len(v.ExcessCapacityTerminationPolicy) > 0 {
		objectKey := object.Key("ExcessCapacityTerminationPolicy")
		objectKey.String(string(v.ExcessCapacityTerminationPolicy))
	}

	if v.FulfilledCapacity != 0 {
		objectKey := object.Key("FulfilledCapacity")
		objectKey.Double(v.FulfilledCapacity)
	}

	if v.IamFleetRole != nil {
		objectKey := object.Key("IamFleetRole")
		objectKey.String(*v.IamFleetRole)
	}

	if len(v.InstanceInterruptionBehavior) > 0 {
		objectKey := object.Key("InstanceInterruptionBehavior")
		objectKey.String(string(v.InstanceInterruptionBehavior))
	}

	if v.InstancePoolsToUseCount != 0 {
		objectKey := object.Key("InstancePoolsToUseCount")
		objectKey.Integer(v.InstancePoolsToUseCount)
	}

	if v.LaunchSpecifications != nil {
		objectKey := object.FlatKey("LaunchSpecifications")
		if err := awsEc2query_serializeDocumentLaunchSpecsList(v.LaunchSpecifications, objectKey); err != nil {
			return err
		}
	}

	if v.LaunchTemplateConfigs != nil {
		objectKey := object.FlatKey("LaunchTemplateConfigs")
		if err := awsEc2query_serializeDocumentLaunchTemplateConfigList(v.LaunchTemplateConfigs, objectKey); err != nil {
			return err
		}
	}

	if v.LoadBalancersConfig != nil {
		objectKey := object.Key("LoadBalancersConfig")
		if err := awsEc2query_serializeDocumentLoadBalancersConfig(v.LoadBalancersConfig, objectKey); err != nil {
			return err
		}
	}

	if len(v.OnDemandAllocationStrategy) > 0 {
		objectKey := object.Key("OnDemandAllocationStrategy")
		objectKey.String(string(v.OnDemandAllocationStrategy))
	}

	if v.OnDemandFulfilledCapacity != 0 {
		objectKey := object.Key("OnDemandFulfilledCapacity")
		objectKey.Double(v.OnDemandFulfilledCapacity)
	}

	if v.OnDemandMaxTotalPrice != nil {
		objectKey := object.Key("OnDemandMaxTotalPrice")
		objectKey.String(*v.OnDemandMaxTotalPrice)
	}

	if v.OnDemandTargetCapacity != 0 {
		objectKey := object.Key("OnDemandTargetCapacity")
		objectKey.Integer(v.OnDemandTargetCapacity)
	}

	if v.ReplaceUnhealthyInstances {
		objectKey := object.Key("ReplaceUnhealthyInstances")
		objectKey.Boolean(v.ReplaceUnhealthyInstances)
	}

	if v.SpotMaintenanceStrategies != nil {
	