/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef QTUBUNTU_MEDIA_SIGNALS_H
#define QTUBUNTU_MEDIA_SIGNALS_H

#include <QImage>
#include <QMutex>
#include <QObject>
#include <QSize>

class CameraControl;

class SharedSignal : public QObject
{
    Q_OBJECT
public:
    static SharedSignal* instance();

Q_SIGNALS:
    /** Thrown by qtvideo-node to signal when the GL texture has
     * been successfully created.
     */
    void textureCreated(unsigned int textureID);
    /** Thrown by AalVideoRendererControl to signal set the snapshot size.
     */
    void setSnapshotSize(const QSize &size);
    /** Thrown by ShaderVideoNode when the snapshot image has been successfully
     * taken and stored in memory.
     */
    void snapshotTaken(QImage snapshotImage);
    /** Thrown by AalVideoRendererControl to signal when to capture
     * a still image from the preview video stream.
     */
    void takeSnapshot(const CameraControl *control);

protected:
    SharedSignal(QObject *parent = NULL);

private:
    Q_DISABLE_COPY(SharedSignal);

    static SharedSignal *m_sharedSignal;
    static QMutex m_mutex;
};

#endif // SHAREDSIGNAL_H
