/*################################################################################
# Linux Management Providers (LMP), Provider Common Library
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################*/

#include "Datastore.h"

int DS_initDataStore(const string& nameSpace, const string& classname, const string& keys, string& errorMessage) {
	if (!CF_isExist((string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys)) {
		string stdOut, stdErr;
		CF_assert(CF_runCommand("mkdir -p -m 750 '"+ (string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys + "'", stdOut, stdErr, errorMessage));
	}
	return OK;
}

int DS_deleteDataStore(const string& nameSpace, const string& classname, const string& keys, string& errorMessage) {
	if (CF_isExist((string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys)) {
		string stdOut, stdErr;
		CF_assert(CF_runCommand("rm -rf '"+ (string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys+"'", stdOut, stdErr, errorMessage));
		if (CF_isExist((string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys)) {
			errorMessage = "Failed to delete datastore: " + (string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys;
			return FAILED;
		}
	}
	return OK;
}

int DS_setPropertyNULL(const string& nameSpace, const string& classname, const string& keys, const string& property_name, string& errorMessage) {
	if (CF_isExist((string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys+"/"+CF_toLowCase(property_name))) {
		string stdOut, stdErr;
		CF_assert(CF_runCommand("rm '"+ (string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys+"/"+CF_toLowCase(property_name) + "'", stdOut, stdErr, errorMessage));
	}
	return OK;
}

int DS_getKeysEntries(const string& nameSpace, const string& classname, vector<string>& keys_entries, string& errorMessage) {
	keys_entries.clear();
	if (CF_isExist((string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname)) {
		vector<string> regular_files, block_devices, character_devices;
		CF_assert(CF_scanDirectory((string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname, regular_files, keys_entries, block_devices, character_devices, errorMessage));
	}
	return OK;
}

bool DS_keysEntryExists(const string& nameSpace, const string& classname, const string& keys_entry, string& errorMessage) {
	if (!CF_isExist((string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys_entry))
		return false;
	return true;
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, bool& property, string& errorMessage) {
	_GETPROPERTY_INTEGER
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const bool& property, string& errorMessage) {
	_SETPROPERTY_INTEGER_AND_REAL
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, unsigned char& property, string& errorMessage) {
	_GETPROPERTY_INTEGER
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const unsigned char& property, string& errorMessage) {
	_SETPROPERTY_INTEGER_AND_REAL
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, unsigned short& property, string& errorMessage) {
	_GETPROPERTY_INTEGER
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const unsigned short& property, string& errorMessage) {
	_SETPROPERTY_INTEGER_AND_REAL
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, unsigned long& property, string& errorMessage) {
	_GETPROPERTY_INTEGER
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const unsigned long& property, string& errorMessage) {
	_SETPROPERTY_INTEGER_AND_REAL
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, unsigned long long& property, string& errorMessage) {
	string property_file;
	CF_assert(CF_readTextFile((string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys+"/"+CF_toLowCase(property_name), property_file, errorMessage));
	vector<string> property_file_lines;
	CF_splitText(property_file_lines, property_file, '\n');
	property = CF_strToULL(property_file_lines[0]);
	return OK;
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const unsigned long long& property, string& errorMessage) {
	_SETPROPERTY_INTEGER_AND_REAL
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, signed char& property, string& errorMessage) {
	_GETPROPERTY_INTEGER
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const signed char& property, string& errorMessage) {
	_SETPROPERTY_INTEGER_AND_REAL
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, short& property, string& errorMessage) {
	_GETPROPERTY_INTEGER
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const short& property, string& errorMessage) {
	_SETPROPERTY_INTEGER_AND_REAL
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, long& property, string& errorMessage) {
	_GETPROPERTY_INTEGER
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const long& property, string& errorMessage) {
	_SETPROPERTY_INTEGER_AND_REAL
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, long long& property, string& errorMessage) {
	_GETPROPERTY_INTEGER
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const long long& property, string& errorMessage) {
	_SETPROPERTY_INTEGER_AND_REAL
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, float& property, string& errorMessage) {
	_GETPROPERTY_REAL
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const float& property, string& errorMessage) {
	_SETPROPERTY_INTEGER_AND_REAL
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, double& property, string& errorMessage) {
	_GETPROPERTY_REAL
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const double& property, string& errorMessage) {
	_SETPROPERTY_INTEGER_AND_REAL
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, string& property, string& errorMessage) {
	string property_file;
	CF_assert(CF_readTextFile((string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys+"/"+CF_toLowCase(property_name), property_file, errorMessage));
	vector<string> property_file_lines;
	CF_splitText(property_file_lines, property_file, '\n');
	property = property_file_lines[0];
	return OK;
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const string& property, string& errorMessage) {
	CF_assert(DS_initDataStore(nameSpace, classname, keys, errorMessage));
	string property_file;
	CF_assert(CF_writeTextFile((string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys+"/"+CF_toLowCase(property_name), property, errorMessage));
	return OK;
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<bool>& property, string& errorMessage) {
	_GETPROPERTY_INTEGERARRAY
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<bool>& property, string& errorMessage) {
	_SETPROPERTY_INTEGERARRAY
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<unsigned char>& property, string& errorMessage) {
	_GETPROPERTY_INTEGERARRAY
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<unsigned char>& property, string& errorMessage) {
	_SETPROPERTY_INTEGERARRAY
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<unsigned short>& property, string& errorMessage) {
	_GETPROPERTY_INTEGERARRAY
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<unsigned short>& property, string& errorMessage) {
	_SETPROPERTY_INTEGERARRAY
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<unsigned long>& property, string& errorMessage) {
	_GETPROPERTY_INTEGERARRAY
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<unsigned long>& property, string& errorMessage) {
	_SETPROPERTY_INTEGERARRAY
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<unsigned long long>& property, string& errorMessage) {
	property.clear();
	string property_file;
	CF_assert(CF_readTextFile((string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys+"/"+CF_toLowCase(property_name), property_file, errorMessage));
	vector<string> property_file_lines;
	CF_splitText(property_file_lines, property_file, '\n');
	for (size_t i=0; i<property_file_lines.size(); i++)
		property.push_back(CF_strToULL(property_file_lines[i].c_str()));
	return OK;
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<unsigned long long>& property, string& errorMessage) {
	_SETPROPERTY_INTEGERARRAY
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<signed char>& property, string& errorMessage) {
	_GETPROPERTY_INTEGERARRAY
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<signed char>& property, string& errorMessage) {
	_SETPROPERTY_INTEGERARRAY
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<short>& property, string& errorMessage) {
	_GETPROPERTY_INTEGERARRAY
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<short>& property, string& errorMessage) {
	_SETPROPERTY_INTEGERARRAY
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<long>& property, string& errorMessage) {
	_GETPROPERTY_INTEGERARRAY
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<long>& property, string& errorMessage) {
	_SETPROPERTY_INTEGERARRAY
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<long long>& property, string& errorMessage) {
	_GETPROPERTY_INTEGERARRAY
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<long long>& property, string& errorMessage) {
	_SETPROPERTY_INTEGERARRAY
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<float>& property, string& errorMessage) {
	_GETPROPERTY_REALARRAY
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<float>& property, string& errorMessage) {
	_SETPROPERTY_INTEGERARRAY
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<double>& property, string& errorMessage) {
	_GETPROPERTY_REALARRAY
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<double>& property, string& errorMessage) {
	_SETPROPERTY_INTEGERARRAY
}

int DS_getProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, vector<string>& property, string& errorMessage) {
	property.clear();
	string property_file;
	CF_assert(CF_readTextFile((string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys+"/"+CF_toLowCase(property_name), property_file, errorMessage));
	vector<string> property_file_lines;
	CF_splitText(property_file_lines, property_file, '\n');
	for (size_t i=0; i<property_file_lines.size(); i++)
		property.push_back(property_file_lines[i].c_str());
	return OK;
}
int DS_setProperty(const string& nameSpace, const string& classname, const string& keys, const string& property_name, const vector<string>& property, string& errorMessage) {
	CF_assert(DS_initDataStore(nameSpace, classname, keys, errorMessage));
	string property_file;
	for (size_t i=0; i<property.size(); i++) {
		property_file += property[i];
		if (i < property.size()-1)
			property_file += "\n";
	}
	CF_assert(CF_writeTextFile((string) _DATASTORE_PATH+"/"+nameSpace+"/"+classname+"/"+keys+"/"+CF_toLowCase(property_name), property_file, errorMessage));
	return OK;
}
