//start of CompressMethod.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * CompressMethod.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;

//import exceptions
import java.lang.NullPointerException;
import java.lang.IllegalArgumentException;


/**
 * LHÅe萔`B
 * 
 * <pre>
 * -- revision history --
 * $Log: CompressMethod.java,v $
 * Revision 1.1  2002/12/08 00:00:00  dangan
 * [change]
 *     NX LhaConstants  CompressMethod ւƕύXB
 *
 * Revision 1.0  2002/07/24 00:00:00  dangan
 * add to version control
 * [change]
 *     LhaUtil  connectExtractInputStream  connectDecoder Ƃ
 *     connectCompressOutputStream  connectEncoder ƂĈpB
 *     LhaUtil  CompressMethodTo????????? pB
 * [maintanance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1 $
 */
public class CompressMethod{


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  compress method identifier
    //------------------------------------------------------------------
    //  public static final String LH0
    //  public static final String LH1
    //  public static final String LH2
    //  public static final String LH3
    //  public static final String LH4
    //  public static final String LH5
    //  public static final String LH6
    //  public static final String LH7
    //  public static final String LHD
    //  public static final String LZS
    //  public static final String LZ4
    //  public static final String LZ5
    //------------------------------------------------------------------
    /**
     * k`B
     * LH0  k "-lh0-" łB
     */
    public static final String LH0 = "-lh0-";

    /**
     * k`B
     * LH1 ͑Oi 4LoCg̎Aőv60oCg
     * LZSS@Ai KInt}@gp邱ƂӖ
     * "-lh1-" łB
     */
    public static final String LH1 = "-lh1-";

    /**
     * k`B
     * LH2 ͑Oi 8LoCg̎Aőv256oCg
     * LZSS@Ai KInt}@gp邱ƂӖ
     * "-lh2-" łB
     * ̈k@ LH1  LH5 ւ̉ǓrŎI
     * gꂽA݂͎gpĂȂB
     */
    public static final String LH2 = "-lh2-";

    /**
     * k`B
     * LH3 ͑Oi 8LoCg̎Aőv256oCg
     * LZSS@Ai ÓInt}@gp邱ƂӖ
     * "-lh3-" łB
     * ̈k@ LH1  LH5 ւ̉ǓrŎI
     * gꂽA݂͎gpĂȂB
     */
    public static final String LH3 = "-lh3-";

    /**
     * k`B
     * LH4 ͑Oi 4LoCg̎Aőv256oCg
     * LZSS@Ai ÓInt}@gp邱ƂӖ
     * "-lh4-" łB
     * ̈k@ 1990NO̔͂ȃ}VňksہA
     * LH5ks̃VXe𓾂ȂɎg
     * ꂽA݂͖wǎgpĂȂB
     */
    public static final String LH4 = "-lh4-";

    /**
     * k`B
     * LH5 ͑Oi 8LoCg̎Aőv256oCg
     * LZSS@Ai ÓInt}@gp邱ƂӖ
     * "-lh5-" łB
     * ݁ALHAŕWŎgp鈳k@łB
     */
    public static final String LH5 = "-lh5-";

    /**
     * k`B
     * LH6 ͑Oi 32LoCg̎Aőv256oCg
     * LZSS@Ai ÓInt}@gp邱ƂӖ
     * "-lh6-" łB
     * "-lh6-" Ƃ LH7 ̈k@̎Ɏgp
     * B̂߁ALHA̎ł쐬ɂɂ "-lh6-"
     * ̕gpȂ LH7 `ňkĂ̂
     * ݂炵B
     * ܂ ̈k@͊JĂ 10N߂o
     * ̏ꏊ ̈k@ňkꂽɂ͓o^Ȃ
     * ]܂ƂĂB
     */
    public static final String LH6 = "-lh6-";

    /**
     * k`B
     * LH7 ͑Oi 64LoCg̎Aőv256oCg
     * LZSS@Ai ÓInt}@gp邱ƂӖ
     * "-lh7-" łB
     * ܂ ̈k@͊JĂ 10N߂o
     * ̏ꏊ ̈k@ňkꂽɂ͓o^Ȃ
     * ]܂ƂĂB
     */
    public static final String LH7 = "-lh7-";

    /**
     * k`B
     * LHD ͖kŁAfBNgi[Ă邱Ƃ
     * "-lhd-" łB
     */
    public static final String LHD = "-lhd-";

    /**
     * k`B
     * LZS  2LoCg̎Aőv17oCg 
     * LZSS@gp邱Ƃ "-lzs-" łB
     * "-lzs-"  LHA쐬OɃW[ł
     * Larc ̌`łǍ݊ɔzĒ`
     * ꂽB݂͖wǎgpĂȂB
     */
    public static final String LZS = "-lzs-";

    /**
     * k`B
     * LZ4  k "-lz4-" łB
     * "-lz4-"  LHA쐬OɃW[ł
     * Larc ̌`łǍ݊ɔzĒ`
     * ꂽB݂͖wǎgpĂȂB
     */
    public static final String LZ4 = "-lz4-";

    /**
     * k`B
     * LZ5  4LoCg̎Aőv17oCg 
     * LZSS@gp邱Ƃ "-lz5-" łB
     * "-lz5-"  LHA쐬OɃW[ł
     * Larc ̌`łǍ݊ɔzĒ`
     * ꂽB݂͖wǎgpĂȂB
     */
    public static final String LZ5 = "-lz5-";


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private CompressMethod()
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^gps
     */
    private CompressMethod(){ }


    //------------------------------------------------------------------
    //  convert to LZSS parameter
    //------------------------------------------------------------------
    //  public static int toDictionarySize( String method )
    //  public static int toThreshold( String method )
    //  public static int toMaxMatch( String method )
    //------------------------------------------------------------------
    /**
     * k@ʎq TCY𓾂B
     * 
     * @param method k@ʎq
     * 
     * @return TCY
     */
    public static int toDictionarySize( String method ){
        if( CompressMethod.LZS.equalsIgnoreCase( method ) ){
            return  2048;
        }else if( CompressMethod.LZ5.equalsIgnoreCase( method ) ){
            return  4096;
        }else if( CompressMethod.LH1.equalsIgnoreCase( method ) ){
            return  4096;
        }else if( CompressMethod.LH2.equalsIgnoreCase( method ) ){
            return  8192;
        }else if( CompressMethod.LH3.equalsIgnoreCase( method ) ){
            return  8192;
        }else if( CompressMethod.LH4.equalsIgnoreCase( method ) ){
            return  4096;
        }else if( CompressMethod.LH5.equalsIgnoreCase( method ) ){
            return  8192;
        }else if( CompressMethod.LH6.equalsIgnoreCase( method ) ){
            return 32768;
        }else if( CompressMethod.LH7.equalsIgnoreCase( method ) ){
            return 65536;
        }else if( CompressMethod.LZ4.equalsIgnoreCase( method ) ){
            throw new IllegalArgumentException( method + " means no compress." );
        }else if( CompressMethod.LH0.equalsIgnoreCase( method ) ){
            throw new IllegalArgumentException( method + " means no compress." );
        }else if( CompressMethod.LHD.equalsIgnoreCase( method ) ){
            throw new IllegalArgumentException( method + " means no compress." );
        }else if( method == null ){
            throw new NullPointerException( "method" );
        }else{
            throw new IllegalArgumentException( "Unknown compress method. " + method );
        }
    }

    /**
     * k@ʎq k/񈳏k臒l𓾂B
     * 
     * @param method k@ʎq
     * 
     * @return k/񈳏k
     */
    public static int toThreshold( String method ){
        if( CompressMethod.LZS.equalsIgnoreCase( method ) ){
            return 2;
        }else if( CompressMethod.LZ5.equalsIgnoreCase( method ) ){
            return 3;
        }else if( CompressMethod.LH1.equalsIgnoreCase( method ) ){
            return 3;
        }else if( CompressMethod.LH2.equalsIgnoreCase( method ) ){
            return 3;
        }else if( CompressMethod.LH3.equalsIgnoreCase( method ) ){
            return 3;
        }else if( CompressMethod.LH4.equalsIgnoreCase( method ) ){
            return 3;
        }else if( CompressMethod.LH5.equalsIgnoreCase( method ) ){
            return 3;
        }else if( CompressMethod.LH6.equalsIgnoreCase( method ) ){
            return 3;
        }else if( CompressMethod.LH7.equalsIgnoreCase( method ) ){
            return 3;
        }else if( CompressMethod.LZ4.equalsIgnoreCase( method ) ){
            throw new IllegalArgumentException( method + " means no compress." );
        }else if( CompressMethod.LH0.equalsIgnoreCase( method ) ){
            throw new IllegalArgumentException( method + " means no compress." );
        }else if( CompressMethod.LHD.equalsIgnoreCase( method ) ){
            throw new IllegalArgumentException( method + " means no compress." );
        }else if( method == null ){
            throw new NullPointerException( "method" );
        }else{
            throw new IllegalArgumentException( "Unknown compress method. " + method );
        }
    }

    /**
     * k@ʎq őv𓾂B
     * 
     * @param method k@ʎq
     * 
     * @return őv
     */
    public static int toMaxMatch( String method ){
        if( CompressMethod.LZS.equalsIgnoreCase( method ) ){
            return  17;
        }else if( CompressMethod.LZ5.equalsIgnoreCase( method ) ){
            return  18;
        }else if( CompressMethod.LH1.equalsIgnoreCase( method ) ){
            return  60;
        }else if( CompressMethod.LH2.equalsIgnoreCase( method ) ){
            return 256;
        }else if( CompressMethod.LH3.equalsIgnoreCase( method ) ){
            return 256;
        }else if( CompressMethod.LH4.equalsIgnoreCase( method ) ){
            return 256;
        }else if( CompressMethod.LH5.equalsIgnoreCase( method ) ){
            return 256;
        }else if( CompressMethod.LH6.equalsIgnoreCase( method ) ){
            return 256;
        }else if( CompressMethod.LH7.equalsIgnoreCase( method ) ){
            return 256;
        }else if( CompressMethod.LZ4.equalsIgnoreCase( method ) ){
            throw new IllegalArgumentException( method + " means no compress." );
        }else if( CompressMethod.LH0.equalsIgnoreCase( method ) ){
            throw new IllegalArgumentException( method + " means no compress." );
        }else if( CompressMethod.LHD.equalsIgnoreCase( method ) ){
            throw new IllegalArgumentException( method + " means no compress." );
        }else if( method == null ){
            throw new NullPointerException( "method" );
        }else{
            throw new IllegalArgumentException( "Unknown compress method. " + method );
        }
    }


    //------------------------------------------------------------------
    //  shared method
    //------------------------------------------------------------------
    //  connect encoder/decoder
    //------------------------------------------------------------------
    //  public static OutputStream connectEncoder( OutputStream out,
    //                 String method, Properties property )
    //  public static InputStream connectDecoder( InputStream in,
    //                 String method, Properties property, long length )
    //------------------------------------------------------------------
    /**
     * property ɐݒ肳ꂽ𗘗p
     * method ̈k@Ńf[^kAoutɏo͂Xg[\zB
     * 
     * @param out      kf[^o͐̃Xg[
     * @param method   k@ʎq
     * @param property ek`ɑΉ̐܂܂vpeB
     * 
     * @return method ̈k@Ńf[^kAoutɏo͂Xg[
     */
    public static OutputStream connectEncoder( OutputStream out,
                                               String       method,
                                               Properties   property ){

        String key = "lha." + CompressMethod.getCore( method ) + ".encoder";

        String generator = property.getProperty( key );
        if( generator == null ){
            generator = LhaProperty.getProperty( key );
        }

        String packages = property.getProperty( "lha.packages" );
        if( packages == null ){
            packages = LhaProperty.getProperty( "lha.packages" );
        }

        Hashtable substitute = new Hashtable();
        substitute.put( "out", out );

        return (OutputStream)LhaProperty.parse( generator,
                                                substitute,
                                                packages );
    }

    /**
     * property ɐݒ肳ꂽ𗘗p
     * in  method ̈k@ňkꂽf[^𓀂
     * ̓Xg[\zB
     * 
     * @param in       kf[^Xg[
     * @param method   k@ʎq
     * @param property ek`ɑΉ̐܂܂vpeB
     * 
     * @return in  method ̈k@ňkꂽf[^𓀂
     *         ̓Xg[\zB
     */
    public static InputStream connectDecoder( InputStream in,
                                              String      method,
                                              Properties  property,
                                              long        length ){

        String key = "lha." + CompressMethod.getCore( method ) + ".decoder";

        String generator = property.getProperty( key );
        if( generator == null ){
            generator = LhaProperty.getProperty( key );
        }

        String packages = property.getProperty( "lha.packages" );
        if( packages == null ){
            packages = LhaProperty.getProperty( "lha.packages" );
        }

        Hashtable substitute = new Hashtable();
        substitute.put( "in",     in );
        substitute.put( "length", new Long( length ) );

        return (InputStream)LhaProperty.parse( generator,
                                               substitute,
                                               packages );
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  private static String getCore( String method )
    //------------------------------------------------------------------
    /**
     * k@ʎq ̑O '-' 苎
     * LhaProperty ̃L[ lha.???.encoder / lha.???.decoder 
     *  ??? ɓ镶𐶐B
     * 
     * @param method k@ʎq
     * 
     * @return L[̒SɎg镶
     */
    private static String getCore( String method ){
        if( method.startsWith( "-" ) && method.endsWith( "-" ) ){
            return method.substring( 1, method.lastIndexOf( '-' ) ).toLowerCase();
        }else{
            throw new IllegalArgumentException( "" );
        }
    }

}
//end of CompressMethod.java
