/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the libgltf project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#include "TimeFunction.h"

#ifdef _WIN32
#include <windows.h>
#else
#include <sys/time.h>
#endif

double libgltf::time::getCurrentTime()
{
#ifdef _WIN32
    LARGE_INTEGER nFreq;
    QueryPerformanceFrequency(&nFreq);
    double dqFreq = (double)nFreq.QuadPart;
    _LARGE_INTEGER nTime;
    QueryPerformanceCounter(&nTime);
    return (double)nTime.QuadPart / dqFreq;
#else
    struct timeval aTime;
    gettimeofday(&aTime, 0);
    return aTime.tv_sec+(aTime.tv_usec/1000000.0);
#endif
}

double libgltf::time::diffTime(double dEnd, double dBegin)
{
    return dEnd - dBegin;
}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
