/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#include <QWidget>
#include <QGridLayout>
#include <QSettings>
#include <QTextBrowser>
#include <QTabWidget>
#include <QTextEdit>
#include <QAction>
#include <QGroupBox>
#include <QLabel>
#include <QToolButton>
#include <QTabBar>
#include <QPainter>
#include <QPushButton>
#include <QMessageBox>
#include "client_home.h"
#include "tab_dialog.h"
#include "remote_computer.h"
#include "../../commons/sql/database.h"
#include "../core/bean/remote_computer_info.h"

class TranslucentTabWidget : public QTabWidget
{
    Q_OBJECT
public:
    TranslucentTabWidget(QWidget *parent)
        : QTabWidget(parent)
    {
        QTabBar *bar = new QTabBar(this);
#ifdef WIN32
        bar->setAttribute( Qt::WA_TranslucentBackground, true);
#elif defined __APPLE__
#else
        bar->setAttribute(Qt::WA_TranslucentBackground, true);
#endif
        setTabBar(bar);
    }
};

class ClientCentralWindow : public QWidget
{
    Q_OBJECT

public:
    ClientCentralWindow(QToolButton *menuButton);
    Database *database;

public slots:
    void show_connect_dialog();
    void show_connect_dialog(QString ip, QString port, QString port_file);
    void add_tab(QString ip, QString port, QString portFile, QString password);
    void remove_tab_by_index(int index);
    void remove_tab_by_client_nbr(int client_nbr);
    void showMessageSlot(QString title, QString content, int duration);
    void update_os_information(QString os, QString title, int client_nbr);
    void add_command_to_database_slot(Command *command);
    void drop_database();

signals:
    void showMessage(QString title, QString content, int duration);

private:
    QSettings *settings;
    QString user_mode;
    QTextBrowser *textEdit;
    TranslucentTabWidget *tab;
    ClientHome *clientHome;
    TabDialog *tabDialog;
    QMap<int, RemoteComputer*> *client_map;
    QList<RemoteComputerInfo*> remote_info_list;
    QToolButton *menu;
    int client_nbr;
};
