from maximaparsertokens import tokenValues

DLG_ACCEPTED = 1
DLG_CANCELLED = 2

blue = 1
red = 2
black = 3
white = 4

OPERATORS = [tokenValues.PLUS,tokenValues.MINUS,tokenValues.TIMES,tokenValues.DIVIDE,tokenValues.POWER]
FUNCTIONS = [tokenValues.FUNCTION]
INTEGRATE = [tokenValues.INTEGRATE]
DIFFERENTIATE = [tokenValues.DIFFERENTIATE]
LEAFNODEOPERATORS = [tokenValues.NUM,tokenValues.VAR]

SEPERABLE_OPERATORS = [tokenValues.PLUS,tokenValues.MINUS,tokenValues.TIMES,tokenValues.EQUALS]


INTEGRALSIGN = u'\u222B'
SUMSIGN = u'\u03A3'

def trace(f):
    """ By using trace as a decorator all calls to the decorated function will be traced"""
    def newf(*args, **kw):
        import logging
        l = logging.getLogger("trace")
        l.debug("calling %s with args %s, %s" % (f.__name__, args, kw))
        return f(*args, **kw)
    newf.__name__ = f.__name__
    newf.__dict__ = f.__dict__
    newf.__doc__ = f.__doc__
    return newf
