/*
 * Decompiled with CFR 0.152.
 */
package org.cyberneko.html;

import java.io.EOFException;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Stack;
import org.apache.xerces.util.EncodingMap;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.URI;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentScanner;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.cyberneko.html.HTMLAugmentations;
import org.cyberneko.html.HTMLComponent;
import org.cyberneko.html.HTMLElements;
import org.cyberneko.html.HTMLEntities;
import org.cyberneko.html.HTMLErrorReporter;
import org.cyberneko.html.HTMLEventInfo;

public class HTMLScanner
implements XMLDocumentScanner,
XMLLocator,
HTMLComponent {
    public static final String HTML_4_01_STRICT_PUBID = "-//W3C//DTD HTML 4.01//EN";
    public static final String HTML_4_01_STRICT_SYSID = "http://www.w3.org/TR/html4/strict.dtd";
    public static final String HTML_4_01_TRANSITIONAL_PUBID = "-//W3C//DTD HTML 4.01 Transitional//EN";
    public static final String HTML_4_01_TRANSITIONAL_SYSID = "http://www.w3.org/TR/html4/loose.dtd";
    public static final String HTML_4_01_FRAMESET_PUBID = "-//W3C//DTD HTML 4.01 Frameset//EN";
    public static final String HTML_4_01_FRAMESET_SYSID = "http://www.w3.org/TR/html4/frameset.dtd";
    protected static final String AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    protected static final String REPORT_ERRORS = "http://cyberneko.org/html/features/report-errors";
    public static final String NOTIFY_CHAR_REFS = "http://apache.org/xml/features/scanner/notify-char-refs";
    public static final String NOTIFY_XML_BUILTIN_REFS = "http://apache.org/xml/features/scanner/notify-builtin-refs";
    public static final String NOTIFY_HTML_BUILTIN_REFS = "http://cyberneko.org/html/features/scanner/notify-builtin-refs";
    public static final String SCRIPT_STRIP_COMMENT_DELIMS = "http://cyberneko.org/html/features/scanner/script/strip-comment-delims";
    public static final String SCRIPT_STRIP_CDATA_DELIMS = "http://cyberneko.org/html/features/scanner/script/strip-cdata-delims";
    public static final String STYLE_STRIP_COMMENT_DELIMS = "http://cyberneko.org/html/features/scanner/style/strip-comment-delims";
    public static final String STYLE_STRIP_CDATA_DELIMS = "http://cyberneko.org/html/features/scanner/style/strip-cdata-delims";
    public static final String IGNORE_SPECIFIED_CHARSET = "http://cyberneko.org/html/features/scanner/ignore-specified-charset";
    public static final String CDATA_SECTIONS = "http://cyberneko.org/html/features/scanner/cdata-sections";
    public static final String OVERRIDE_DOCTYPE = "http://cyberneko.org/html/features/override-doctype";
    public static final String INSERT_DOCTYPE = "http://cyberneko.org/html/features/insert-doctype";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://cyberneko.org/html/features/augmentations", "http://cyberneko.org/html/features/report-errors", "http://apache.org/xml/features/scanner/notify-char-refs", "http://apache.org/xml/features/scanner/notify-builtin-refs", "http://cyberneko.org/html/features/scanner/notify-builtin-refs", "http://cyberneko.org/html/features/scanner/script/strip-cdata-delims", "http://cyberneko.org/html/features/scanner/script/strip-comment-delims", "http://cyberneko.org/html/features/scanner/style/strip-cdata-delims", "http://cyberneko.org/html/features/scanner/style/strip-comment-delims", "http://cyberneko.org/html/features/scanner/ignore-specified-charset", "http://cyberneko.org/html/features/scanner/cdata-sections", "http://cyberneko.org/html/features/override-doctype", "http://cyberneko.org/html/features/insert-doctype"};
    private static final Boolean[] RECOGNIZED_FEATURES_DEFAULTS = new Boolean[]{null, null, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE};
    protected static final String NAMES_ELEMS = "http://cyberneko.org/html/properties/names/elems";
    protected static final String NAMES_ATTRS = "http://cyberneko.org/html/properties/names/attrs";
    protected static final String DEFAULT_ENCODING = "http://cyberneko.org/html/properties/default-encoding";
    protected static final String ERROR_REPORTER = "http://cyberneko.org/html/properties/error-reporter";
    protected static final String DOCTYPE_PUBID = "http://cyberneko.org/html/properties/doctype/pubid";
    protected static final String DOCTYPE_SYSID = "http://cyberneko.org/html/properties/doctype/sysid";
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://cyberneko.org/html/properties/names/elems", "http://cyberneko.org/html/properties/names/attrs", "http://cyberneko.org/html/properties/default-encoding", "http://cyberneko.org/html/properties/error-reporter", "http://cyberneko.org/html/properties/doctype/pubid", "http://cyberneko.org/html/properties/doctype/sysid"};
    private static final Object[] RECOGNIZED_PROPERTIES_DEFAULTS = new Object[]{null, null, "Windows-1252", null, "-//W3C//DTD HTML 4.01 Transitional//EN", "http://www.w3.org/TR/html4/loose.dtd"};
    protected static final short STATE_CONTENT = 0;
    protected static final short STATE_MARKUP_BRACKET = 1;
    protected static final short STATE_START_DOCUMENT = 10;
    protected static final short STATE_END_DOCUMENT = 11;
    protected static final short NAMES_NO_CHANGE = 0;
    protected static final short NAMES_UPPERCASE = 1;
    protected static final short NAMES_LOWERCASE = 2;
    protected static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final boolean DEBUG_SCANNER = false;
    private static final boolean DEBUG_SCANNER_STATE = false;
    private static final boolean DEBUG_BUFFER = false;
    private static final boolean DEBUG_CHARSET = false;
    protected static final boolean DEBUG_CALLBACKS = false;
    protected static final HTMLEventInfo SYNTHESIZED_ITEM = new HTMLEventInfo.SynthesizedItem();
    protected boolean fAugmentations;
    protected boolean fReportErrors;
    protected boolean fNotifyCharRefs;
    protected boolean fNotifyXmlBuiltinRefs;
    protected boolean fNotifyHtmlBuiltinRefs;
    protected boolean fScriptStripCDATADelims;
    protected boolean fScriptStripCommentDelims;
    protected boolean fStyleStripCDATADelims;
    protected boolean fStyleStripCommentDelims;
    protected boolean fIgnoreSpecifiedCharset;
    protected boolean fCDATASections;
    protected boolean fOverrideDoctype;
    protected boolean fInsertDoctype;
    protected short fNamesElems;
    protected short fNamesAttrs;
    protected String fDefaultIANAEncoding;
    protected HTMLErrorReporter fErrorReporter;
    protected String fDoctypePubid;
    protected String fDoctypeSysid;
    protected int fBeginLineNumber;
    protected int fBeginColumnNumber;
    protected int fEndLineNumber;
    protected int fEndColumnNumber;
    protected PlaybackInputStream fByteStream;
    protected CurrentEntity fCurrentEntity;
    protected final Stack fCurrentEntityStack = new Stack();
    protected Scanner fScanner;
    protected short fScannerState;
    protected XMLDocumentHandler fDocumentHandler;
    protected String fIANAEncoding;
    protected String fJavaEncoding;
    protected int fElementCount;
    protected int fElementDepth;
    protected Scanner fContentScanner = new ContentScanner();
    protected SpecialScanner fSpecialScanner = new SpecialScanner();
    protected final XMLString fString = new XMLString();
    protected final XMLStringBuffer fStringBuffer = new XMLStringBuffer(1024);
    private final XMLStringBuffer fStringBuffer2 = new XMLStringBuffer(1024);
    private final XMLStringBuffer fNonNormAttr = new XMLStringBuffer(128);
    private final HTMLAugmentations fInfosetAugs = new HTMLAugmentations();
    private final LocationItem fLocationItem = new LocationItem();
    private final boolean[] fSingleBoolean = new boolean[]{false};
    private final XMLResourceIdentifierImpl fResourceId = new XMLResourceIdentifierImpl();
    static /* synthetic */ Class class$org$apache$xerces$xni$XMLLocator;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$xerces$xni$NamespaceContext;
    static /* synthetic */ Class class$org$apache$xerces$xni$Augmentations;

    public void pushInputSource(XMLInputSource inputSource) {
        Reader reader = inputSource.getCharacterStream();
        if (reader == null) {
            throw new IllegalArgumentException("pushed input source has no reader");
        }
        this.fCurrentEntityStack.push(this.fCurrentEntity);
        String encoding = inputSource.getEncoding();
        String publicId = inputSource.getPublicId();
        String baseSystemId = inputSource.getBaseSystemId();
        String literalSystemId = inputSource.getSystemId();
        String expandedSystemId = HTMLScanner.expandSystemId(literalSystemId, baseSystemId);
        this.fCurrentEntity = new CurrentEntity(reader, encoding, publicId, baseSystemId, literalSystemId, expandedSystemId);
    }

    public void cleanup(boolean closeall) {
        block9: {
            block8: {
                int i;
                int size = this.fCurrentEntityStack.size();
                if (size <= 0) break block8;
                if (this.fCurrentEntity != null) {
                    try {
                        this.fCurrentEntity.stream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                int n = i = closeall ? 0 : 1;
                while (i < size) {
                    this.fCurrentEntity = (CurrentEntity)this.fCurrentEntityStack.pop();
                    try {
                        this.fCurrentEntity.stream.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    ++i;
                }
                break block9;
            }
            if (!closeall || this.fCurrentEntity == null) break block9;
            try {
                this.fCurrentEntity.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getEncoding() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.encoding : null;
    }

    public String getPublicId() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.publicId : null;
    }

    public String getBaseSystemId() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.baseSystemId : null;
    }

    public String getLiteralSystemId() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.literalSystemId : null;
    }

    public String getExpandedSystemId() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.expandedSystemId : null;
    }

    public int getLineNumber() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.lineNumber : -1;
    }

    public int getColumnNumber() {
        return this.fCurrentEntity != null ? this.fCurrentEntity.columnNumber : -1;
    }

    public Boolean getFeatureDefault(String featureId) {
        int length = RECOGNIZED_FEATURES != null ? RECOGNIZED_FEATURES.length : 0;
        for (int i = 0; i < length; ++i) {
            if (!RECOGNIZED_FEATURES[i].equals(featureId)) continue;
            return RECOGNIZED_FEATURES_DEFAULTS[i];
        }
        return null;
    }

    public Object getPropertyDefault(String propertyId) {
        int length = RECOGNIZED_PROPERTIES != null ? RECOGNIZED_PROPERTIES.length : 0;
        for (int i = 0; i < length; ++i) {
            if (!RECOGNIZED_PROPERTIES[i].equals(propertyId)) continue;
            return RECOGNIZED_PROPERTIES_DEFAULTS[i];
        }
        return null;
    }

    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    public String[] getRecognizedProperties() {
        return RECOGNIZED_PROPERTIES;
    }

    public void reset(XMLComponentManager manager) throws XMLConfigurationException {
        this.fAugmentations = manager.getFeature(AUGMENTATIONS);
        this.fReportErrors = manager.getFeature(REPORT_ERRORS);
        this.fNotifyCharRefs = manager.getFeature(NOTIFY_CHAR_REFS);
        this.fNotifyXmlBuiltinRefs = manager.getFeature(NOTIFY_XML_BUILTIN_REFS);
        this.fNotifyHtmlBuiltinRefs = manager.getFeature(NOTIFY_HTML_BUILTIN_REFS);
        this.fScriptStripCDATADelims = manager.getFeature(SCRIPT_STRIP_CDATA_DELIMS);
        this.fScriptStripCommentDelims = manager.getFeature(SCRIPT_STRIP_COMMENT_DELIMS);
        this.fStyleStripCDATADelims = manager.getFeature(STYLE_STRIP_CDATA_DELIMS);
        this.fStyleStripCommentDelims = manager.getFeature(STYLE_STRIP_COMMENT_DELIMS);
        this.fIgnoreSpecifiedCharset = manager.getFeature(IGNORE_SPECIFIED_CHARSET);
        this.fCDATASections = manager.getFeature(CDATA_SECTIONS);
        this.fOverrideDoctype = manager.getFeature(OVERRIDE_DOCTYPE);
        this.fInsertDoctype = manager.getFeature(INSERT_DOCTYPE);
        this.fNamesElems = HTMLScanner.getNamesValue(String.valueOf(manager.getProperty(NAMES_ELEMS)));
        this.fNamesAttrs = HTMLScanner.getNamesValue(String.valueOf(manager.getProperty(NAMES_ATTRS)));
        this.fDefaultIANAEncoding = String.valueOf(manager.getProperty(DEFAULT_ENCODING));
        this.fErrorReporter = (HTMLErrorReporter)manager.getProperty(ERROR_REPORTER);
        this.fDoctypePubid = String.valueOf(manager.getProperty(DOCTYPE_PUBID));
        this.fDoctypeSysid = String.valueOf(manager.getProperty(DOCTYPE_SYSID));
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        if (featureId.equals(AUGMENTATIONS)) {
            this.fAugmentations = state;
        } else if (featureId.equals(IGNORE_SPECIFIED_CHARSET)) {
            this.fIgnoreSpecifiedCharset = state;
        } else if (featureId.equals(NOTIFY_CHAR_REFS)) {
            this.fNotifyCharRefs = state;
        } else if (featureId.equals(NOTIFY_XML_BUILTIN_REFS)) {
            this.fNotifyXmlBuiltinRefs = state;
        } else if (featureId.equals(NOTIFY_HTML_BUILTIN_REFS)) {
            this.fNotifyHtmlBuiltinRefs = state;
        } else if (featureId.equals(SCRIPT_STRIP_CDATA_DELIMS)) {
            this.fScriptStripCDATADelims = state;
        } else if (featureId.equals(SCRIPT_STRIP_COMMENT_DELIMS)) {
            this.fScriptStripCommentDelims = state;
        } else if (featureId.equals(STYLE_STRIP_CDATA_DELIMS)) {
            this.fStyleStripCDATADelims = state;
        } else if (featureId.equals(STYLE_STRIP_COMMENT_DELIMS)) {
            this.fStyleStripCommentDelims = state;
        } else if (featureId.equals(IGNORE_SPECIFIED_CHARSET)) {
            this.fIgnoreSpecifiedCharset = state;
        }
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        if (propertyId.equals(NAMES_ELEMS)) {
            this.fNamesElems = HTMLScanner.getNamesValue(String.valueOf(value));
            return;
        }
        if (propertyId.equals(NAMES_ATTRS)) {
            this.fNamesAttrs = HTMLScanner.getNamesValue(String.valueOf(value));
            return;
        }
        if (propertyId.equals(DEFAULT_ENCODING)) {
            this.fDefaultIANAEncoding = String.valueOf(value);
            return;
        }
    }

    public void setInputSource(XMLInputSource source) throws IOException {
        this.fElementCount = 0;
        this.fElementDepth = -1;
        this.fByteStream = null;
        this.fCurrentEntityStack.removeAllElements();
        this.fBeginLineNumber = 1;
        this.fBeginColumnNumber = 1;
        this.fEndLineNumber = this.fBeginLineNumber;
        this.fEndColumnNumber = this.fBeginColumnNumber;
        this.fJavaEncoding = this.fIANAEncoding = this.fDefaultIANAEncoding;
        String encoding = source.getEncoding();
        String publicId = source.getPublicId();
        String baseSystemId = source.getBaseSystemId();
        String literalSystemId = source.getSystemId();
        String expandedSystemId = HTMLScanner.expandSystemId(literalSystemId, baseSystemId);
        Reader reader = source.getCharacterStream();
        if (reader == null) {
            InputStream inputStream = source.getByteStream();
            if (inputStream == null) {
                URL url = new URL(expandedSystemId);
                inputStream = url.openStream();
            }
            this.fByteStream = new PlaybackInputStream(inputStream);
            String[] encodings = new String[2];
            if (encoding == null) {
                this.fByteStream.detectEncoding(encodings);
            } else {
                encodings[0] = encoding;
            }
            if (encodings[0] == null) {
                encodings[0] = this.fDefaultIANAEncoding;
                if (this.fReportErrors) {
                    this.fErrorReporter.reportWarning("HTML1000", null);
                }
            }
            if (encodings[1] == null) {
                encodings[1] = EncodingMap.getIANA2JavaMapping((String)encodings[0].toUpperCase());
                if (encodings[1] == null) {
                    encodings[1] = encodings[0];
                    if (this.fReportErrors) {
                        this.fErrorReporter.reportWarning("HTML1001", new Object[]{encodings[0]});
                    }
                }
            }
            this.fIANAEncoding = encodings[0];
            this.fJavaEncoding = encodings[1];
            encoding = this.fIANAEncoding;
            reader = new InputStreamReader((InputStream)this.fByteStream, this.fJavaEncoding);
        }
        this.fCurrentEntity = new CurrentEntity(reader, encoding, publicId, baseSystemId, literalSystemId, expandedSystemId);
        this.setScanner(this.fContentScanner);
        this.setScannerState((short)10);
    }

    public boolean scanDocument(boolean complete) throws XNIException, IOException {
        do {
            if (this.fScanner.scan(complete)) continue;
            return false;
        } while (complete);
        return true;
    }

    public void setDocumentHandler(XMLDocumentHandler handler) {
        this.fDocumentHandler = handler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    protected static String getValue(XMLAttributes attrs, String aname) {
        int length = attrs != null ? attrs.getLength() : 0;
        for (int i = 0; i < length; ++i) {
            if (!attrs.getQName(i).equalsIgnoreCase(aname)) continue;
            return attrs.getValue(i);
        }
        return null;
    }

    public static String expandSystemId(String systemId, String baseSystemId) {
        if (systemId == null || systemId.length() == 0) {
            return systemId;
        }
        try {
            URI uri = new URI(systemId);
            if (uri != null) {
                return systemId;
            }
        }
        catch (URI.MalformedURIException e) {
            // empty catch block
        }
        String id = HTMLScanner.fixURI(systemId);
        URI base = null;
        URI uri = null;
        try {
            if (baseSystemId == null || baseSystemId.length() == 0 || baseSystemId.equals(systemId)) {
                String dir;
                try {
                    dir = HTMLScanner.fixURI(System.getProperty("user.dir"));
                }
                catch (SecurityException se) {
                    dir = "";
                }
                if (!dir.endsWith("/")) {
                    dir = dir + "/";
                }
                base = new URI("file", "", dir, null, null);
            } else {
                try {
                    base = new URI(HTMLScanner.fixURI(baseSystemId));
                }
                catch (URI.MalformedURIException e) {
                    String dir;
                    try {
                        dir = HTMLScanner.fixURI(System.getProperty("user.dir"));
                    }
                    catch (SecurityException se) {
                        dir = "";
                    }
                    if (baseSystemId.indexOf(58) != -1) {
                        base = new URI("file", "", HTMLScanner.fixURI(baseSystemId), null, null);
                    }
                    if (!dir.endsWith("/")) {
                        dir = dir + "/";
                    }
                    dir = dir + HTMLScanner.fixURI(baseSystemId);
                    base = new URI("file", "", dir, null, null);
                }
            }
            uri = new URI(base, id);
        }
        catch (URI.MalformedURIException e) {
            // empty catch block
        }
        if (uri == null) {
            return systemId;
        }
        return uri.toString();
    }

    protected static String fixURI(String str) {
        if ((str = str.replace(File.separatorChar, '/')).length() >= 2) {
            char ch1 = str.charAt(1);
            if (ch1 == ':') {
                char ch0 = Character.toUpperCase(str.charAt(0));
                if (ch0 >= 'A' && ch0 <= 'Z') {
                    str = "/" + str;
                }
            } else if (ch1 == '/' && str.charAt(0) == '/') {
                str = "file:" + str;
            }
        }
        return str;
    }

    protected static final String modifyName(String name, short mode) {
        switch (mode) {
            case 1: {
                return name.toUpperCase();
            }
            case 2: {
                return name.toLowerCase();
            }
        }
        return name;
    }

    protected static final short getNamesValue(String value) {
        if (value.equals("lower")) {
            return 2;
        }
        if (value.equals("upper")) {
            return 1;
        }
        return 0;
    }

    protected int read() throws IOException {
        if (this.fCurrentEntity.offset == this.fCurrentEntity.length && this.load(0) == -1) {
            return -1;
        }
        char c = this.fCurrentEntity.buffer[this.fCurrentEntity.offset++];
        ++this.fCurrentEntity.columnNumber;
        return c;
    }

    protected int load(int offset) throws IOException {
        int count;
        if (offset == this.fCurrentEntity.buffer.length) {
            int adjust = this.fCurrentEntity.buffer.length / 4;
            char[] array = new char[this.fCurrentEntity.buffer.length + adjust];
            System.arraycopy(this.fCurrentEntity.buffer, 0, array, 0, this.fCurrentEntity.length);
            this.fCurrentEntity.buffer = array;
        }
        this.fCurrentEntity.length = (count = this.fCurrentEntity.stream.read(this.fCurrentEntity.buffer, offset, this.fCurrentEntity.buffer.length - offset)) != -1 ? count + offset : offset;
        this.fCurrentEntity.offset = offset;
        return count;
    }

    protected void setScanner(Scanner scanner) {
        this.fScanner = scanner;
    }

    protected void setScannerState(short state) {
        this.fScannerState = state;
    }

    protected void scanDoctype() throws IOException {
        int c;
        String root = null;
        String pubid = null;
        String sysid = null;
        if (this.skipSpaces()) {
            root = this.scanName();
            if (root == null) {
                if (this.fReportErrors) {
                    this.fErrorReporter.reportError("HTML1014", null);
                }
            } else {
                root = HTMLScanner.modifyName(root, this.fNamesElems);
            }
            if (this.skipSpaces()) {
                if (this.skip("PUBLIC", false)) {
                    this.skipSpaces();
                    pubid = this.scanLiteral();
                    if (this.skipSpaces()) {
                        sysid = this.scanLiteral();
                    }
                } else if (this.skip("SYSTEM", false)) {
                    this.skipSpaces();
                    sysid = this.scanLiteral();
                }
            }
        }
        while ((c = this.read()) != -1) {
            if (c == 60) {
                --this.fCurrentEntity.offset;
                --this.fCurrentEntity.columnNumber;
                break;
            }
            if (c == 62) break;
            if (c != 91) continue;
            this.skipMarkup(true);
            break;
        }
        if (this.fDocumentHandler != null) {
            if (this.fOverrideDoctype) {
                pubid = this.fDoctypePubid;
                sysid = this.fDoctypeSysid;
            }
            this.fEndLineNumber = this.fCurrentEntity.lineNumber;
            this.fEndColumnNumber = this.fCurrentEntity.columnNumber;
            this.fDocumentHandler.doctypeDecl(root, pubid, sysid, this.locationAugs());
        }
    }

    protected String scanLiteral() throws IOException {
        int quote = this.read();
        if (quote == 39 || quote == 34) {
            int c;
            StringBuffer str = new StringBuffer();
            while ((c = this.read()) != -1 && c != quote) {
                if (c == 13 || c == 10) {
                    --this.fCurrentEntity.offset;
                    --this.fCurrentEntity.columnNumber;
                    this.skipNewlines();
                    str.append(' ');
                    continue;
                }
                if (c == 60) {
                    --this.fCurrentEntity.offset;
                    --this.fCurrentEntity.columnNumber;
                    break;
                }
                str.append((char)c);
            }
            if (c == -1) {
                if (this.fReportErrors) {
                    this.fErrorReporter.reportError("HTML1007", null);
                }
                throw new EOFException();
            }
            return str.toString();
        }
        --this.fCurrentEntity.offset;
        --this.fCurrentEntity.columnNumber;
        return null;
    }

    protected String scanName() throws IOException {
        int length;
        if (this.fCurrentEntity.offset == this.fCurrentEntity.length && this.load(0) == -1) {
            return null;
        }
        int offset = this.fCurrentEntity.offset;
        while (true) {
            char c;
            if (this.fCurrentEntity.offset < this.fCurrentEntity.length && (Character.isLetterOrDigit(c = this.fCurrentEntity.buffer[this.fCurrentEntity.offset]) || c == '-' || c == '.' || c == ':' || c == '_')) {
                ++this.fCurrentEntity.offset;
                ++this.fCurrentEntity.columnNumber;
                continue;
            }
            if (this.fCurrentEntity.offset != this.fCurrentEntity.length) break;
            length = this.fCurrentEntity.length - offset;
            System.arraycopy(this.fCurrentEntity.buffer, offset, this.fCurrentEntity.buffer, 0, length);
            int count = this.load(length);
            offset = 0;
            if (count == -1) break;
        }
        String name = (length = this.fCurrentEntity.offset - offset) > 0 ? new String(this.fCurrentEntity.buffer, offset, length) : null;
        return name;
    }

    protected int scanEntityRef(XMLStringBuffer str, boolean content) throws IOException {
        str.clear();
        str.append('&');
        while (true) {
            int c;
            if ((c = this.read()) == 59) break;
            if (c == -1) {
                if (this.fReportErrors) {
                    this.fErrorReporter.reportWarning("HTML1004", null);
                }
                if (content && this.fDocumentHandler != null && this.fElementCount >= this.fElementDepth) {
                    this.fEndLineNumber = this.fCurrentEntity.lineNumber;
                    this.fEndColumnNumber = this.fCurrentEntity.columnNumber;
                    this.fDocumentHandler.characters((XMLString)str, this.locationAugs());
                }
                return -1;
            }
            if (!Character.isLetterOrDigit((char)c) && c != 35) {
                if (this.fReportErrors) {
                    this.fErrorReporter.reportWarning("HTML1004", null);
                }
                --this.fCurrentEntity.offset;
                --this.fCurrentEntity.columnNumber;
                if (content && this.fDocumentHandler != null && this.fElementCount >= this.fElementDepth) {
                    this.fEndLineNumber = this.fCurrentEntity.lineNumber;
                    this.fEndColumnNumber = this.fCurrentEntity.columnNumber;
                    this.fDocumentHandler.characters((XMLString)str, this.locationAugs());
                }
                return -1;
            }
            str.append((char)c);
        }
        str.append(';');
        if (str.length == 1) {
            if (content && this.fDocumentHandler != null && this.fElementCount >= this.fElementDepth) {
                this.fEndLineNumber = this.fCurrentEntity.lineNumber;
                this.fEndColumnNumber = this.fCurrentEntity.columnNumber;
                this.fDocumentHandler.characters((XMLString)str, this.locationAugs());
            }
            return -1;
        }
        String name = str.toString().substring(1, str.length - 1);
        if (name.startsWith("#")) {
            int value;
            block22: {
                value = -1;
                try {
                    value = name.startsWith("#x") ? Integer.parseInt(name.substring(2), 16) : Integer.parseInt(name.substring(1));
                    if (content && this.fDocumentHandler != null && this.fElementCount >= this.fElementDepth) {
                        this.fEndLineNumber = this.fCurrentEntity.lineNumber;
                        this.fEndColumnNumber = this.fCurrentEntity.columnNumber;
                        if (this.fNotifyCharRefs) {
                            XMLResourceIdentifier id = this.resourceId();
                            String encoding = null;
                            this.fDocumentHandler.startGeneralEntity(name, id, encoding, this.locationAugs());
                        }
                        str.clear();
                        str.append((char)value);
                        this.fDocumentHandler.characters((XMLString)str, this.locationAugs());
                        if (this.fNotifyCharRefs) {
                            this.fDocumentHandler.endGeneralEntity(name, this.locationAugs());
                        }
                    }
                }
                catch (NumberFormatException e) {
                    if (this.fReportErrors) {
                        this.fErrorReporter.reportError("HTML1005", new Object[]{name});
                    }
                    if (!content || this.fDocumentHandler == null || this.fElementCount < this.fElementDepth) break block22;
                    this.fEndLineNumber = this.fCurrentEntity.lineNumber;
                    this.fEndColumnNumber = this.fCurrentEntity.columnNumber;
                    this.fDocumentHandler.characters((XMLString)str, this.locationAugs());
                }
            }
            return value;
        }
        int c = HTMLEntities.get(name);
        if (c == -1) {
            if (this.fReportErrors) {
                this.fErrorReporter.reportWarning("HTML1006", new Object[]{name});
            }
            if (content && this.fDocumentHandler != null && this.fElementCount >= this.fElementDepth) {
                this.fEndLineNumber = this.fCurrentEntity.lineNumber;
                this.fEndColumnNumber = this.fCurrentEntity.columnNumber;
                this.fDocumentHandler.characters((XMLString)str, this.locationAugs());
            }
            return -1;
        }
        if (content && this.fDocumentHandler != null && this.fElementCount >= this.fElementDepth) {
            boolean notify;
            this.fEndLineNumber = this.fCurrentEntity.lineNumber;
            this.fEndColumnNumber = this.fCurrentEntity.columnNumber;
            boolean bl = notify = this.fNotifyHtmlBuiltinRefs || this.fNotifyXmlBuiltinRefs && HTMLScanner.builtinXmlRef(name);
            if (notify) {
                XMLResourceIdentifier id = this.resourceId();
                String encoding = null;
                this.fDocumentHandler.startGeneralEntity(name, id, encoding, this.locationAugs());
            }
            str.clear();
            str.append((char)c);
            this.fDocumentHandler.characters((XMLString)str, this.locationAugs());
            if (notify) {
                this.fDocumentHandler.endGeneralEntity(name, this.locationAugs());
            }
        }
        return c;
    }

    protected boolean skip(String s, boolean caseSensitive) throws IOException {
        int length = s != null ? s.length() : 0;
        for (int i = 0; i < length; ++i) {
            if (this.fCurrentEntity.offset == this.fCurrentEntity.length) {
                System.arraycopy(this.fCurrentEntity.buffer, this.fCurrentEntity.offset - i, this.fCurrentEntity.buffer, 0, i);
                if (this.load(i) == -1) {
                    this.fCurrentEntity.offset = 0;
                    return false;
                }
            }
            char c0 = s.charAt(i);
            char c1 = this.fCurrentEntity.buffer[this.fCurrentEntity.offset++];
            ++this.fCurrentEntity.columnNumber;
            if (!caseSensitive) {
                c0 = Character.toUpperCase(c0);
                c1 = Character.toUpperCase(c1);
            }
            if (c0 == c1) continue;
            this.fCurrentEntity.offset -= i + 1;
            return false;
        }
        return true;
    }

    protected boolean skipMarkup(boolean balance) throws IOException {
        int depth = 1;
        boolean slashgt = false;
        block0: while (this.fCurrentEntity.offset != this.fCurrentEntity.length || this.load(0) != -1) {
            while (this.fCurrentEntity.offset < this.fCurrentEntity.length) {
                char c = this.fCurrentEntity.buffer[this.fCurrentEntity.offset++];
                ++this.fCurrentEntity.columnNumber;
                if (balance && c == '<') {
                    ++depth;
                    continue;
                }
                if (c == '>') {
                    if (--depth != 0) continue;
                    break block0;
                }
                if (c == '/') {
                    if (this.fCurrentEntity.offset == this.fCurrentEntity.length && this.load(0) == -1) break block0;
                    c = this.fCurrentEntity.buffer[this.fCurrentEntity.offset++];
                    ++this.fCurrentEntity.columnNumber;
                    if (c == '>') {
                        slashgt = true;
                        if (--depth != 0) continue;
                        break block0;
                    }
                    --this.fCurrentEntity.offset;
                    --this.fCurrentEntity.columnNumber;
                    continue;
                }
                if (c != '\r' && c != '\n') continue;
                this.skipNewlines();
            }
        }
        return slashgt;
    }

    protected boolean skipSpaces() throws IOException {
        char c;
        boolean spaces = false;
        while ((this.fCurrentEntity.offset != this.fCurrentEntity.length || this.load(0) != -1) && Character.isSpace(c = this.fCurrentEntity.buffer[this.fCurrentEntity.offset])) {
            spaces = true;
            if (c == '\r' || c == '\n') {
                this.skipNewlines();
                continue;
            }
            ++this.fCurrentEntity.offset;
            ++this.fCurrentEntity.columnNumber;
        }
        return spaces;
    }

    protected int skipNewlines() throws IOException {
        return this.skipNewlines(Integer.MAX_VALUE);
    }

    protected int skipNewlines(int maxlines) throws IOException {
        if (this.fCurrentEntity.offset == this.fCurrentEntity.length && this.load(0) == -1) {
            return 0;
        }
        char c = this.fCurrentEntity.buffer[this.fCurrentEntity.offset];
        int newlines = 0;
        int offset = this.fCurrentEntity.offset;
        if (c == '\n' || c == '\r') {
            do {
                if ((c = this.fCurrentEntity.buffer[this.fCurrentEntity.offset++]) == '\r') {
                    ++newlines;
                    if (this.fCurrentEntity.offset == this.fCurrentEntity.length) {
                        offset = 0;
                        this.fCurrentEntity.offset = newlines;
                        if (this.load(newlines) == -1) break;
                    }
                    if (this.fCurrentEntity.buffer[this.fCurrentEntity.offset] != '\n') continue;
                    ++this.fCurrentEntity.offset;
                    ++offset;
                    continue;
                }
                if (c == '\n') {
                    ++newlines;
                    if (this.fCurrentEntity.offset != this.fCurrentEntity.length) continue;
                    offset = 0;
                    this.fCurrentEntity.offset = newlines;
                    if (this.load(newlines) != -1) continue;
                    break;
                }
                --this.fCurrentEntity.offset;
                break;
            } while (newlines < maxlines && this.fCurrentEntity.offset < this.fCurrentEntity.length - 1);
            this.fCurrentEntity.lineNumber += newlines;
            this.fCurrentEntity.columnNumber = 1;
        }
        return newlines;
    }

    protected final Augmentations locationAugs() {
        HTMLAugmentations augs = null;
        if (this.fAugmentations) {
            this.fLocationItem.setValues(this.fBeginLineNumber, this.fBeginColumnNumber, this.fEndLineNumber, this.fEndColumnNumber);
            augs = this.fInfosetAugs;
            augs.removeAllItems();
            augs.putItem(AUGMENTATIONS, this.fLocationItem);
        }
        return augs;
    }

    protected final Augmentations synthesizedAugs() {
        HTMLAugmentations augs = null;
        if (this.fAugmentations) {
            augs = this.fInfosetAugs;
            augs.removeAllItems();
            augs.putItem(AUGMENTATIONS, SYNTHESIZED_ITEM);
        }
        return augs;
    }

    protected final XMLResourceIdentifier resourceId() {
        this.fResourceId.clear();
        return this.fResourceId;
    }

    protected static boolean builtinXmlRef(String name) {
        return name.equals("amp") || name.equals("lt") || name.equals("gt") || name.equals("quot") || name.equals("apos");
    }

    private void printBuffer() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class LocationItem
    implements HTMLEventInfo {
        protected int fBeginLineNumber;
        protected int fBeginColumnNumber;
        protected int fEndLineNumber;
        protected int fEndColumnNumber;

        protected LocationItem() {
        }

        public void setValues(int beginLine, int beginColumn, int endLine, int endColumn) {
            this.fBeginLineNumber = beginLine;
            this.fBeginColumnNumber = beginColumn;
            this.fEndLineNumber = endLine;
            this.fEndColumnNumber = endColumn;
        }

        public int getBeginLineNumber() {
            return this.fBeginLineNumber;
        }

        public int getBeginColumnNumber() {
            return this.fBeginColumnNumber;
        }

        public int getEndLineNumber() {
            return this.fEndLineNumber;
        }

        public int getEndColumnNumber() {
            return this.fEndColumnNumber;
        }

        public boolean isSynthesized() {
            return false;
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            str.append(this.fBeginLineNumber);
            str.append(':');
            str.append(this.fBeginColumnNumber);
            str.append(':');
            str.append(this.fEndLineNumber);
            str.append(':');
            str.append(this.fEndColumnNumber);
            return str.toString();
        }
    }

    public static class PlaybackInputStream
    extends FilterInputStream {
        private static final boolean DEBUG_PLAYBACK = false;
        protected boolean fPlayback = false;
        protected boolean fCleared = false;
        protected boolean fDetected = false;
        protected byte[] fByteBuffer = new byte[1024];
        protected int fByteOffset = 0;
        protected int fByteLength = 0;
        public int fPushbackOffset = 0;
        public int fPushbackLength = 0;

        public PlaybackInputStream(InputStream in) {
            super(in);
        }

        public void detectEncoding(String[] encodings) throws IOException {
            if (this.fDetected) {
                throw new IOException("Should not detect encoding twice.");
            }
            this.fDetected = true;
            int b1 = this.read();
            if (b1 == -1) {
                return;
            }
            int b2 = this.read();
            if (b2 == -1) {
                this.fPushbackLength = 1;
                return;
            }
            if (b1 == 239 && b2 == 187) {
                int b3 = this.read();
                if (b3 == 191) {
                    this.fPushbackOffset = 3;
                    encodings[0] = "UTF-8";
                    encodings[1] = "UTF8";
                    return;
                }
                this.fPushbackLength = 3;
            }
            if (b1 == 255 && b2 == 254) {
                encodings[0] = "UTF-16";
                encodings[1] = "UnicodeLittleUnmarked";
                return;
            }
            if (b1 == 254 && b2 == 255) {
                encodings[0] = "UTF-16";
                encodings[1] = "UnicodeBigUnmarked";
                return;
            }
            this.fPushbackLength = 2;
        }

        public void playback() {
            this.fPlayback = true;
        }

        public void clear() {
            if (!this.fPlayback) {
                this.fCleared = true;
                this.fByteBuffer = null;
            }
        }

        public int read() throws IOException {
            if (this.fPushbackOffset < this.fPushbackLength) {
                return this.fByteBuffer[this.fPushbackOffset++];
            }
            if (this.fCleared) {
                return this.in.read();
            }
            if (this.fPlayback) {
                byte c = this.fByteBuffer[this.fByteOffset++];
                if (this.fByteOffset == this.fByteLength) {
                    this.fCleared = true;
                    this.fByteBuffer = null;
                }
                return c;
            }
            int c = this.in.read();
            if (c != -1) {
                if (this.fByteLength == this.fByteBuffer.length) {
                    byte[] newarray = new byte[this.fByteLength + 1024];
                    System.arraycopy(this.fByteBuffer, 0, newarray, 0, this.fByteLength);
                    this.fByteBuffer = newarray;
                }
                this.fByteBuffer[this.fByteLength++] = (byte)c;
            }
            return c;
        }

        public int read(byte[] array) throws IOException {
            return this.read(array, 0, array.length);
        }

        public int read(byte[] array, int offset, int length) throws IOException {
            if (this.fPushbackOffset < this.fPushbackLength) {
                int count = this.fPushbackLength - this.fPushbackOffset;
                if (count > length) {
                    count = length;
                }
                System.arraycopy(this.fByteBuffer, this.fPushbackOffset, array, offset, count);
                this.fPushbackOffset += count;
                return count;
            }
            if (this.fCleared) {
                return this.in.read(array, offset, length);
            }
            if (this.fPlayback) {
                if (this.fByteOffset + length > this.fByteLength) {
                    length = this.fByteLength - this.fByteOffset;
                }
                System.arraycopy(this.fByteBuffer, this.fByteOffset, array, offset, length);
                this.fByteOffset += length;
                if (this.fByteOffset == this.fByteLength) {
                    this.fCleared = true;
                    this.fByteBuffer = null;
                }
                return length;
            }
            int count = this.in.read(array, offset, length);
            if (count != -1) {
                if (this.fByteLength + count > this.fByteBuffer.length) {
                    byte[] newarray = new byte[this.fByteLength + count + 512];
                    System.arraycopy(this.fByteBuffer, 0, newarray, 0, this.fByteLength);
                    this.fByteBuffer = newarray;
                }
                System.arraycopy(array, offset, this.fByteBuffer, this.fByteLength, count);
                this.fByteLength += count;
            }
            return count;
        }
    }

    public class SpecialScanner
    implements Scanner {
        protected String fElementName;
        protected boolean fScript;
        protected boolean fStyle;
        protected boolean fTextarea;
        private final QName fQName = new QName();
        private final XMLStringBuffer fStringBuffer = new XMLStringBuffer();

        public Scanner setElementName(String ename) {
            this.fElementName = ename;
            this.fScript = this.fElementName.equalsIgnoreCase("SCRIPT");
            this.fStyle = this.fElementName.equalsIgnoreCase("STYLE");
            this.fTextarea = this.fElementName.equalsIgnoreCase("TEXTAREA");
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public boolean scan(boolean complete) throws IOException {
            void var2_2;
            do {
                try {
                    boolean next = false;
                    int delimiter = -1;
                    switch (HTMLScanner.this.fScannerState) {
                        case 0: {
                            HTMLScanner.this.fBeginLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                            HTMLScanner.this.fBeginColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber--;
                            int c = HTMLScanner.this.read();
                            if (c == 60) {
                                HTMLScanner.this.setScannerState((short)1);
                                break;
                            }
                            if (c == 38) {
                                if (this.fTextarea) {
                                    HTMLScanner.this.scanEntityRef(this.fStringBuffer, true);
                                    break;
                                }
                                this.fStringBuffer.clear();
                                this.fStringBuffer.append('&');
                            } else {
                                if (c == -1) {
                                    if (HTMLScanner.this.fReportErrors) {
                                        HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                                    }
                                    throw new EOFException();
                                }
                                --HTMLScanner.this.fCurrentEntity.offset;
                                this.fStringBuffer.clear();
                            }
                            this.scanCharacters(this.fStringBuffer, -1);
                            break;
                        }
                        case 1: {
                            int c = HTMLScanner.this.read();
                            if (c == 33) {
                                if (HTMLScanner.this.skip("--", false)) {
                                    boolean strip;
                                    this.fStringBuffer.clear();
                                    boolean bl = strip = this.fScript && HTMLScanner.this.fScriptStripCommentDelims || this.fStyle && HTMLScanner.this.fStyleStripCommentDelims;
                                    if (strip) {
                                        do {
                                            if ((c = HTMLScanner.this.read()) != 13 && c != 10) continue;
                                            --HTMLScanner.this.fCurrentEntity.columnNumber;
                                            --HTMLScanner.this.fCurrentEntity.offset;
                                            break;
                                        } while (c != -1);
                                        HTMLScanner.this.skipNewlines(1);
                                        delimiter = 45;
                                    } else {
                                        this.fStringBuffer.append("<!--");
                                    }
                                } else if (HTMLScanner.this.skip("[CDATA[", false)) {
                                    boolean strip;
                                    this.fStringBuffer.clear();
                                    boolean bl = strip = this.fScript && HTMLScanner.this.fScriptStripCDATADelims || this.fStyle && HTMLScanner.this.fStyleStripCDATADelims;
                                    if (strip) {
                                        do {
                                            if ((c = HTMLScanner.this.read()) != 13 && c != 10) continue;
                                            --HTMLScanner.this.fCurrentEntity.columnNumber;
                                            --HTMLScanner.this.fCurrentEntity.offset;
                                            break;
                                        } while (c != -1);
                                        HTMLScanner.this.skipNewlines(1);
                                        delimiter = 93;
                                    } else {
                                        this.fStringBuffer.append("<![CDATA[");
                                    }
                                }
                            } else if (c == 47) {
                                String ename = HTMLScanner.this.scanName();
                                if (ename != null) {
                                    if (ename.equalsIgnoreCase(this.fElementName)) {
                                        if (HTMLScanner.this.read() == 62) {
                                            ename = HTMLScanner.modifyName(ename, HTMLScanner.this.fNamesElems);
                                            if (HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                                                this.fQName.setValues(null, ename, ename, null);
                                                HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                                                HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
                                                HTMLScanner.this.fDocumentHandler.endElement(this.fQName, HTMLScanner.this.locationAugs());
                                            }
                                            HTMLScanner.this.setScanner(HTMLScanner.this.fContentScanner);
                                            HTMLScanner.this.setScannerState((short)0);
                                            return true;
                                        }
                                        --HTMLScanner.this.fCurrentEntity.offset;
                                        --HTMLScanner.this.fCurrentEntity.columnNumber;
                                    }
                                    this.fStringBuffer.clear();
                                    this.fStringBuffer.append("</");
                                    this.fStringBuffer.append(ename);
                                } else {
                                    this.fStringBuffer.clear();
                                    this.fStringBuffer.append("</");
                                }
                            } else {
                                this.fStringBuffer.clear();
                                this.fStringBuffer.append('<');
                                this.fStringBuffer.append((char)c);
                            }
                            this.scanCharacters(this.fStringBuffer, delimiter);
                            HTMLScanner.this.setScannerState((short)0);
                            break;
                        }
                    }
                }
                catch (EOFException e) {
                    HTMLScanner.this.setScanner(HTMLScanner.this.fContentScanner);
                    if (HTMLScanner.this.fCurrentEntityStack.empty()) {
                        HTMLScanner.this.setScannerState((short)11);
                    } else {
                        HTMLScanner.this.fCurrentEntity = (CurrentEntity)HTMLScanner.this.fCurrentEntityStack.pop();
                        HTMLScanner.this.setScannerState((short)0);
                    }
                    return true;
                }
            } while (var2_2 != false || complete);
            return true;
        }

        protected void scanCharacters(XMLStringBuffer buffer, int delimiter) throws IOException {
            boolean strip;
            boolean bl = strip = this.fScript && HTMLScanner.this.fScriptStripCommentDelims || this.fScript && HTMLScanner.this.fScriptStripCDATADelims || this.fStyle && HTMLScanner.this.fStyleStripCommentDelims || this.fStyle && HTMLScanner.this.fStyleStripCDATADelims;
            block0: while (true) {
                int i;
                int c;
                if ((c = HTMLScanner.this.read()) == -1 || delimiter == -1 && (c == 60 || c == 38)) {
                    if (c == -1) break;
                    --HTMLScanner.this.fCurrentEntity.offset;
                    --HTMLScanner.this.fCurrentEntity.columnNumber;
                    break;
                }
                if (c == 13 || c == 10) {
                    --HTMLScanner.this.fCurrentEntity.offset;
                    --HTMLScanner.this.fCurrentEntity.columnNumber;
                    int newlines = HTMLScanner.this.skipNewlines();
                    i = 0;
                    while (true) {
                        if (i >= newlines) continue block0;
                        buffer.append('\n');
                        ++i;
                    }
                }
                if (delimiter != -1 && c == (char)delimiter) {
                    int count = 0;
                    do {
                        ++count;
                    } while ((c = HTMLScanner.this.read()) == (char)delimiter);
                    int n = i = strip && c == 62 ? 2 : 0;
                    while (i < count) {
                        buffer.append((char)delimiter);
                        ++i;
                    }
                    if (c == -1 || count >= 2 && c == 62) {
                        if (strip) break;
                        buffer.append((char)c);
                        break;
                    }
                    --HTMLScanner.this.fCurrentEntity.offset;
                    --HTMLScanner.this.fCurrentEntity.columnNumber;
                    continue;
                }
                buffer.append((char)c);
                if (c != 10) continue;
                HTMLScanner.this.fCurrentEntity.columnNumber = 1;
                ++HTMLScanner.this.fCurrentEntity.lineNumber;
            }
            if (buffer.length > 0 && HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
                HTMLScanner.this.fDocumentHandler.characters((XMLString)buffer, HTMLScanner.this.locationAugs());
            }
        }
    }

    public class ContentScanner
    implements Scanner {
        private final QName fQName = new QName();
        private final XMLAttributesImpl fAttributes = new XMLAttributesImpl();

        public boolean scan(boolean complete) throws IOException {
            boolean next;
            do {
                try {
                    next = false;
                    switch (HTMLScanner.this.fScannerState) {
                        case 0: {
                            HTMLScanner.this.fBeginLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                            HTMLScanner.this.fBeginColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber--;
                            int c = HTMLScanner.this.read();
                            if (c == 60) {
                                HTMLScanner.this.setScannerState((short)1);
                                next = true;
                                break;
                            }
                            if (c == 38) {
                                HTMLScanner.this.scanEntityRef(HTMLScanner.this.fStringBuffer, true);
                                break;
                            }
                            if (c == -1) {
                                throw new EOFException();
                            }
                            --HTMLScanner.this.fCurrentEntity.offset;
                            this.scanCharacters();
                            break;
                        }
                        case 1: {
                            int c = HTMLScanner.this.read();
                            if (c == 33) {
                                if (HTMLScanner.this.skip("--", false)) {
                                    this.scanComment();
                                } else if (HTMLScanner.this.skip("[CDATA[", false)) {
                                    this.scanCDATA();
                                } else if (HTMLScanner.this.skip("DOCTYPE", false)) {
                                    HTMLScanner.this.scanDoctype();
                                } else {
                                    if (HTMLScanner.this.fReportErrors) {
                                        HTMLScanner.this.fErrorReporter.reportError("HTML1002", null);
                                    }
                                    HTMLScanner.this.skipMarkup(true);
                                }
                            } else if (c == 63) {
                                this.scanPI();
                            } else if (c == 47) {
                                this.scanEndElement();
                            } else {
                                if (c == -1) {
                                    if (HTMLScanner.this.fReportErrors) {
                                        HTMLScanner.this.fErrorReporter.reportError("HTML1003", null);
                                    }
                                    if (HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                                        HTMLScanner.this.fStringBuffer.clear();
                                        HTMLScanner.this.fStringBuffer.append('<');
                                        HTMLScanner.this.fDocumentHandler.characters((XMLString)HTMLScanner.this.fStringBuffer, null);
                                    }
                                    throw new EOFException();
                                }
                                --HTMLScanner.this.fCurrentEntity.offset;
                                --HTMLScanner.this.fCurrentEntity.columnNumber;
                                ++HTMLScanner.this.fElementCount;
                                ((HTMLScanner)HTMLScanner.this).fSingleBoolean[0] = false;
                                String ename = this.scanStartElement(HTMLScanner.this.fSingleBoolean);
                                if (ename != null && !HTMLScanner.this.fSingleBoolean[0] && HTMLElements.getElement(ename).isSpecial()) {
                                    HTMLScanner.this.setScanner(HTMLScanner.this.fSpecialScanner.setElementName(ename));
                                    HTMLScanner.this.setScannerState((short)0);
                                    return true;
                                }
                            }
                            HTMLScanner.this.setScannerState((short)0);
                            break;
                        }
                        case 10: {
                            if (HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                                Object[] params;
                                HTMLScanner locator = HTMLScanner.this;
                                String encoding = HTMLScanner.this.fIANAEncoding;
                                Augmentations augs = HTMLScanner.this.locationAugs();
                                try {
                                    Class<?> cls = HTMLScanner.this.fDocumentHandler.getClass();
                                    Class[] types = new Class[]{class$org$apache$xerces$xni$XMLLocator == null ? HTMLScanner.class$("org.apache.xerces.xni.XMLLocator") : class$org$apache$xerces$xni$XMLLocator, class$java$lang$String == null ? HTMLScanner.class$("java.lang.String") : class$java$lang$String, class$org$apache$xerces$xni$NamespaceContext == null ? HTMLScanner.class$("org.apache.xerces.xni.NamespaceContext") : class$org$apache$xerces$xni$NamespaceContext, class$org$apache$xerces$xni$Augmentations == null ? HTMLScanner.class$("org.apache.xerces.xni.Augmentations") : class$org$apache$xerces$xni$Augmentations};
                                    Method method = cls.getMethod("startDocument", types);
                                    NamespaceSupport nscontext = new NamespaceSupport();
                                    params = new Object[]{locator, encoding, nscontext, augs};
                                    method.invoke((Object)HTMLScanner.this.fDocumentHandler, params);
                                }
                                catch (IllegalAccessException e) {
                                    throw new XNIException((Exception)e);
                                }
                                catch (InvocationTargetException e) {
                                    throw new XNIException((Exception)e);
                                }
                                catch (NoSuchMethodException e) {
                                    try {
                                        Class<?> cls = HTMLScanner.this.fDocumentHandler.getClass();
                                        Class[] types = new Class[]{class$org$apache$xerces$xni$XMLLocator == null ? HTMLScanner.class$("org.apache.xerces.xni.XMLLocator") : class$org$apache$xerces$xni$XMLLocator, class$java$lang$String == null ? HTMLScanner.class$("java.lang.String") : class$java$lang$String, class$org$apache$xerces$xni$Augmentations == null ? HTMLScanner.class$("org.apache.xerces.xni.Augmentations") : class$org$apache$xerces$xni$Augmentations};
                                        Method method = cls.getMethod("startDocument", types);
                                        params = new Object[]{locator, encoding, augs};
                                        method.invoke((Object)HTMLScanner.this.fDocumentHandler, params);
                                    }
                                    catch (IllegalAccessException ex) {
                                        throw new XNIException((Exception)ex);
                                    }
                                    catch (InvocationTargetException ex) {
                                        throw new XNIException((Exception)ex);
                                    }
                                    catch (NoSuchMethodException ex) {
                                        throw new XNIException((Exception)ex);
                                    }
                                }
                            }
                            if (HTMLScanner.this.fInsertDoctype && HTMLScanner.this.fDocumentHandler != null) {
                                String root = HTMLElements.getElement((short)46).name;
                                root = HTMLScanner.modifyName(root, HTMLScanner.this.fNamesElems);
                                String pubid = HTMLScanner.this.fDoctypePubid;
                                String sysid = HTMLScanner.this.fDoctypeSysid;
                                HTMLScanner.this.fDocumentHandler.doctypeDecl(root, pubid, sysid, HTMLScanner.this.synthesizedAugs());
                            }
                            HTMLScanner.this.setScannerState((short)0);
                            break;
                        }
                        case 11: {
                            if (HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                                HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                                HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
                                HTMLScanner.this.fDocumentHandler.endDocument(HTMLScanner.this.locationAugs());
                            }
                            return false;
                        }
                        default: {
                            throw new RuntimeException("unknown scanner state: " + HTMLScanner.this.fScannerState);
                        }
                    }
                }
                catch (EOFException e) {
                    if (HTMLScanner.this.fCurrentEntityStack.empty()) {
                        HTMLScanner.this.setScannerState((short)11);
                    } else {
                        HTMLScanner.this.fCurrentEntity = (CurrentEntity)HTMLScanner.this.fCurrentEntityStack.pop();
                    }
                    next = true;
                }
            } while (next || complete);
            return true;
        }

        protected void scanCharacters() throws IOException {
            char c;
            int offset;
            int newlines = HTMLScanner.this.skipNewlines();
            if (newlines == 0 && HTMLScanner.this.fCurrentEntity.offset == HTMLScanner.this.fCurrentEntity.length) {
                return;
            }
            for (int i = offset = HTMLScanner.this.fCurrentEntity.offset - newlines; i < HTMLScanner.this.fCurrentEntity.offset; ++i) {
                HTMLScanner.this.fCurrentEntity.buffer[i] = 10;
            }
            while (HTMLScanner.this.fCurrentEntity.offset < HTMLScanner.this.fCurrentEntity.length && (c = HTMLScanner.this.fCurrentEntity.buffer[HTMLScanner.this.fCurrentEntity.offset]) != '<' && c != '&' && c != '\n' && c != '\r') {
                ++HTMLScanner.this.fCurrentEntity.offset;
                ++HTMLScanner.this.fCurrentEntity.columnNumber;
            }
            if (HTMLScanner.this.fCurrentEntity.offset > offset && HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                HTMLScanner.this.fString.setValues(HTMLScanner.this.fCurrentEntity.buffer, offset, HTMLScanner.this.fCurrentEntity.offset - offset);
                HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
                HTMLScanner.this.fDocumentHandler.characters(HTMLScanner.this.fString, HTMLScanner.this.locationAugs());
            }
        }

        protected void scanCDATA() throws IOException {
            HTMLScanner.this.fStringBuffer.clear();
            if (HTMLScanner.this.fCDATASections) {
                if (HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                    HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                    HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
                    HTMLScanner.this.fDocumentHandler.startCDATA(HTMLScanner.this.locationAugs());
                }
            } else {
                HTMLScanner.this.fStringBuffer.append("[CDATA[");
            }
            boolean eof = this.scanMarkupContent(HTMLScanner.this.fStringBuffer, ']');
            if (!HTMLScanner.this.fCDATASections) {
                HTMLScanner.this.fStringBuffer.append("]]");
            }
            if (HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
                if (HTMLScanner.this.fCDATASections) {
                    HTMLScanner.this.fDocumentHandler.characters((XMLString)HTMLScanner.this.fStringBuffer, HTMLScanner.this.locationAugs());
                    HTMLScanner.this.fDocumentHandler.endCDATA(HTMLScanner.this.locationAugs());
                } else {
                    HTMLScanner.this.fDocumentHandler.comment((XMLString)HTMLScanner.this.fStringBuffer, HTMLScanner.this.locationAugs());
                }
            }
            if (eof) {
                throw new EOFException();
            }
        }

        protected void scanComment() throws IOException {
            HTMLScanner.this.fStringBuffer.clear();
            boolean eof = this.scanMarkupContent(HTMLScanner.this.fStringBuffer, '-');
            if (HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
                HTMLScanner.this.fDocumentHandler.comment((XMLString)HTMLScanner.this.fStringBuffer, HTMLScanner.this.locationAugs());
            }
            if (eof) {
                throw new EOFException();
            }
        }

        protected boolean scanMarkupContent(XMLStringBuffer buffer, char cend) throws IOException {
            int c = -1;
            block0: while (true) {
                int i;
                if ((c = HTMLScanner.this.read()) == cend) {
                    int count = 1;
                    while ((c = HTMLScanner.this.read()) == cend) {
                        ++count;
                    }
                    if (c == -1) {
                        if (!HTMLScanner.this.fReportErrors) break;
                        HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                        break;
                    }
                    if (count < 2) {
                        buffer.append((char)cend);
                        --HTMLScanner.this.fCurrentEntity.offset;
                        --HTMLScanner.this.fCurrentEntity.columnNumber;
                        continue;
                    }
                    if (c != 62) {
                        for (i = 0; i < count; ++i) {
                            buffer.append((char)cend);
                        }
                        --HTMLScanner.this.fCurrentEntity.offset;
                        --HTMLScanner.this.fCurrentEntity.columnNumber;
                        continue;
                    }
                    for (i = 0; i < count - 2; ++i) {
                        buffer.append((char)cend);
                    }
                    break;
                }
                if (c == 10 || c == 13) {
                    --HTMLScanner.this.fCurrentEntity.offset;
                    --HTMLScanner.this.fCurrentEntity.columnNumber;
                    int newlines = HTMLScanner.this.skipNewlines();
                    i = 0;
                    while (true) {
                        if (i >= newlines) continue block0;
                        buffer.append('\n');
                        ++i;
                    }
                }
                if (c == -1) {
                    if (!HTMLScanner.this.fReportErrors) break;
                    HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                    break;
                }
                buffer.append((char)c);
            }
            return c == -1;
        }

        protected void scanPI() throws IOException {
            String target;
            if (HTMLScanner.this.fReportErrors) {
                HTMLScanner.this.fErrorReporter.reportWarning("HTML1008", null);
            }
            if ((target = HTMLScanner.this.scanName()) != null && !target.equalsIgnoreCase("xml")) {
                int c;
                block11: {
                    while (true) {
                        if ((c = HTMLScanner.this.read()) == 13 || c == 10) {
                            ++HTMLScanner.this.fCurrentEntity.lineNumber;
                            HTMLScanner.this.fCurrentEntity.columnNumber = 1;
                            if (c != 13 || (c = HTMLScanner.this.read()) == 10) continue;
                            --HTMLScanner.this.fCurrentEntity.offset;
                            continue;
                        }
                        if (c == -1) break block11;
                        if (c != 32 && c != 9) break;
                    }
                    --HTMLScanner.this.fCurrentEntity.offset;
                    --HTMLScanner.this.fCurrentEntity.columnNumber;
                }
                HTMLScanner.this.fStringBuffer.clear();
                while (true) {
                    if ((c = HTMLScanner.this.read()) == 63 || c == 47) {
                        char c0 = (char)c;
                        c = HTMLScanner.this.read();
                        if (c == 62) break;
                        HTMLScanner.this.fStringBuffer.append(c0);
                        --HTMLScanner.this.fCurrentEntity.offset;
                        --HTMLScanner.this.fCurrentEntity.columnNumber;
                        continue;
                    }
                    if (c == 13 || c == 10) {
                        HTMLScanner.this.fStringBuffer.append('\n');
                        ++HTMLScanner.this.fCurrentEntity.lineNumber;
                        HTMLScanner.this.fCurrentEntity.columnNumber = 1;
                        if (c != 13 || (c = HTMLScanner.this.read()) == 10) continue;
                        --HTMLScanner.this.fCurrentEntity.offset;
                        continue;
                    }
                    if (c == -1) break;
                    HTMLScanner.this.fStringBuffer.append((char)c);
                }
                XMLStringBuffer data = HTMLScanner.this.fStringBuffer;
                if (HTMLScanner.this.fDocumentHandler != null) {
                    HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                    HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
                    HTMLScanner.this.fDocumentHandler.processingInstruction(target, (XMLString)data, HTMLScanner.this.locationAugs());
                }
            } else {
                int beginLineNumber = HTMLScanner.this.fBeginLineNumber;
                int beginColumnNumber = HTMLScanner.this.fBeginColumnNumber;
                this.fAttributes.removeAllAttributes();
                int aindex = 0;
                while (this.scanPseudoAttribute(this.fAttributes)) {
                    this.fAttributes.getName(aindex, this.fQName);
                    this.fQName.rawname = this.fQName.rawname.toLowerCase();
                    this.fAttributes.setName(aindex, this.fQName);
                    ++aindex;
                }
                if (HTMLScanner.this.fDocumentHandler != null) {
                    String version = this.fAttributes.getValue("version");
                    String encoding = this.fAttributes.getValue("encoding");
                    String standalone = this.fAttributes.getValue("standalone");
                    HTMLScanner.this.fBeginLineNumber = beginLineNumber;
                    HTMLScanner.this.fBeginColumnNumber = beginColumnNumber;
                    HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                    HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
                    HTMLScanner.this.fDocumentHandler.xmlDecl(version, encoding, standalone, HTMLScanner.this.locationAugs());
                }
            }
        }

        protected String scanStartElement(boolean[] empty) throws IOException {
            int c;
            String ename = HTMLScanner.this.scanName();
            int length = ename != null ? ename.length() : 0;
            int n = c = length > 0 ? (int)ename.charAt(0) : -1;
            if (length == 0 || (c < 97 || c > 122) && (c < 65 || c > 90)) {
                if (HTMLScanner.this.fReportErrors) {
                    HTMLScanner.this.fErrorReporter.reportError("HTML1009", null);
                }
                if (HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                    HTMLScanner.this.fStringBuffer.clear();
                    HTMLScanner.this.fStringBuffer.append('<');
                    if (length > 0) {
                        HTMLScanner.this.fStringBuffer.append(ename);
                    }
                    HTMLScanner.this.fDocumentHandler.characters((XMLString)HTMLScanner.this.fStringBuffer, null);
                }
                return null;
            }
            ename = HTMLScanner.modifyName(ename, HTMLScanner.this.fNamesElems);
            this.fAttributes.removeAllAttributes();
            boolean print = false;
            int beginLineNumber = HTMLScanner.this.fBeginLineNumber;
            int beginColumnNumber = HTMLScanner.this.fBeginColumnNumber;
            while (this.scanAttribute(this.fAttributes, empty)) {
            }
            HTMLScanner.this.fBeginLineNumber = beginLineNumber;
            HTMLScanner.this.fBeginColumnNumber = beginColumnNumber;
            if (HTMLScanner.this.fByteStream != null && HTMLScanner.this.fElementDepth == -1) {
                if (ename.equalsIgnoreCase("META")) {
                    String httpEquiv = HTMLScanner.getValue((XMLAttributes)this.fAttributes, "http-equiv");
                    if (httpEquiv != null && httpEquiv.equalsIgnoreCase("content-type")) {
                        int index1;
                        String content = HTMLScanner.getValue((XMLAttributes)this.fAttributes, "content");
                        int n2 = index1 = content != null ? content.toLowerCase().indexOf("charset=") : -1;
                        if (index1 != -1 && !HTMLScanner.this.fIgnoreSpecifiedCharset) {
                            int index2 = content.indexOf(59, index1);
                            String charset = index2 != -1 ? content.substring(index1 + 8, index2) : content.substring(index1 + 8);
                            try {
                                String ianaEncoding = charset;
                                String javaEncoding = EncodingMap.getIANA2JavaMapping((String)ianaEncoding);
                                if (javaEncoding == null) {
                                    javaEncoding = ianaEncoding;
                                    if (HTMLScanner.this.fReportErrors) {
                                        HTMLScanner.this.fErrorReporter.reportError("HTML1001", new Object[]{ianaEncoding});
                                    }
                                }
                                HTMLScanner.this.fCurrentEntity.stream = new InputStreamReader((InputStream)HTMLScanner.this.fByteStream, javaEncoding);
                                HTMLScanner.this.fByteStream.playback();
                                HTMLScanner.this.fElementDepth = HTMLScanner.this.fElementCount;
                                HTMLScanner.this.fElementCount = 0;
                                HTMLScanner.this.fCurrentEntity.length = 0;
                                HTMLScanner.this.fCurrentEntity.offset = 0;
                                HTMLScanner.this.fCurrentEntity.lineNumber = 1;
                                HTMLScanner.this.fCurrentEntity.columnNumber = 1;
                            }
                            catch (UnsupportedEncodingException e) {
                                if (HTMLScanner.this.fReportErrors) {
                                    HTMLScanner.this.fErrorReporter.reportError("HTML1010", new Object[]{charset});
                                }
                                HTMLScanner.this.fByteStream.clear();
                            }
                        }
                    }
                } else if (ename.equalsIgnoreCase("BODY")) {
                    HTMLScanner.this.fByteStream.clear();
                } else {
                    HTMLElements.Element element = HTMLElements.getElement(ename);
                    if (element.parent != null && element.parent.length > 0 && element.parent[0].code == 14) {
                        HTMLScanner.this.fByteStream.clear();
                    }
                }
            }
            if (HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                this.fQName.setValues(null, ename, ename, null);
                HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
                if (empty[0]) {
                    HTMLScanner.this.fDocumentHandler.emptyElement(this.fQName, (XMLAttributes)this.fAttributes, HTMLScanner.this.locationAugs());
                } else {
                    HTMLScanner.this.fDocumentHandler.startElement(this.fQName, (XMLAttributes)this.fAttributes, HTMLScanner.this.locationAugs());
                }
            }
            return ename;
        }

        protected boolean scanAttribute(XMLAttributesImpl attributes, boolean[] empty) throws IOException {
            return this.scanAttribute(attributes, empty, '/');
        }

        protected boolean scanPseudoAttribute(XMLAttributesImpl attributes) throws IOException {
            return this.scanAttribute(attributes, HTMLScanner.this.fSingleBoolean, '?');
        }

        protected boolean scanAttribute(XMLAttributesImpl attributes, boolean[] empty, char endc) throws IOException {
            boolean skippedSpaces = HTMLScanner.this.skipSpaces();
            HTMLScanner.this.fBeginLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
            HTMLScanner.this.fBeginColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber--;
            int c = HTMLScanner.this.read();
            if (c == -1) {
                if (HTMLScanner.this.fReportErrors) {
                    HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                }
                throw new EOFException();
            }
            if (c == 62) {
                return false;
            }
            --HTMLScanner.this.fCurrentEntity.offset;
            String aname = HTMLScanner.this.scanName();
            if (aname == null) {
                if (HTMLScanner.this.fReportErrors) {
                    HTMLScanner.this.fErrorReporter.reportError("HTML1011", null);
                }
                empty[0] = HTMLScanner.this.skipMarkup(false);
                return false;
            }
            if (!skippedSpaces && HTMLScanner.this.fReportErrors) {
                HTMLScanner.this.fErrorReporter.reportError("HTML1013", new Object[]{aname});
            }
            aname = HTMLScanner.modifyName(aname, HTMLScanner.this.fNamesAttrs);
            HTMLScanner.this.skipSpaces();
            c = HTMLScanner.this.read();
            if (c == -1) {
                if (HTMLScanner.this.fReportErrors) {
                    HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                }
                throw new EOFException();
            }
            if (c == 47 || c == 62) {
                this.fQName.setValues(null, aname, aname, null);
                attributes.addAttribute(this.fQName, "CDATA", "");
                attributes.setSpecified(attributes.getLength() - 1, true);
                if (HTMLScanner.this.fAugmentations) {
                    this.addLocationItem((XMLAttributes)attributes, attributes.getLength() - 1);
                }
                if (c == 47) {
                    --HTMLScanner.this.fCurrentEntity.offset;
                    --HTMLScanner.this.fCurrentEntity.columnNumber;
                    empty[0] = HTMLScanner.this.skipMarkup(false);
                }
                return false;
            }
            if (c == 61) {
                HTMLScanner.this.skipSpaces();
                c = HTMLScanner.this.read();
                if (c == -1) {
                    if (HTMLScanner.this.fReportErrors) {
                        HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                    }
                    throw new EOFException();
                }
                if (c == 62) {
                    this.fQName.setValues(null, aname, aname, null);
                    attributes.addAttribute(this.fQName, "CDATA", "");
                    attributes.setSpecified(attributes.getLength() - 1, true);
                    if (HTMLScanner.this.fAugmentations) {
                        this.addLocationItem((XMLAttributes)attributes, attributes.getLength() - 1);
                    }
                    return false;
                }
                HTMLScanner.this.fStringBuffer.clear();
                HTMLScanner.this.fNonNormAttr.clear();
                if (c != 39 && c != 34) {
                    --HTMLScanner.this.fCurrentEntity.offset;
                    --HTMLScanner.this.fCurrentEntity.columnNumber;
                    while (true) {
                        if (Character.isSpace((char)(c = HTMLScanner.this.read())) || c == 62) {
                            --HTMLScanner.this.fCurrentEntity.offset;
                            --HTMLScanner.this.fCurrentEntity.columnNumber;
                            break;
                        }
                        if (c == -1) {
                            if (HTMLScanner.this.fReportErrors) {
                                HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                            }
                            throw new EOFException();
                        }
                        if (c == 38) {
                            int ce = HTMLScanner.this.scanEntityRef(HTMLScanner.this.fStringBuffer2, false);
                            if (ce != -1) {
                                HTMLScanner.this.fStringBuffer.append((char)ce);
                            } else {
                                HTMLScanner.this.fStringBuffer.append((XMLString)HTMLScanner.this.fStringBuffer2);
                            }
                            HTMLScanner.this.fNonNormAttr.append((XMLString)HTMLScanner.this.fStringBuffer2);
                            continue;
                        }
                        HTMLScanner.this.fStringBuffer.append((char)c);
                        HTMLScanner.this.fNonNormAttr.append((char)c);
                    }
                    this.fQName.setValues(null, aname, aname, null);
                    String avalue = HTMLScanner.this.fStringBuffer.toString();
                    attributes.addAttribute(this.fQName, "CDATA", avalue);
                    int lastattr = attributes.getLength() - 1;
                    attributes.setSpecified(lastattr, true);
                    attributes.setNonNormalizedValue(lastattr, HTMLScanner.this.fNonNormAttr.toString());
                    if (HTMLScanner.this.fAugmentations) {
                        this.addLocationItem((XMLAttributes)attributes, attributes.getLength() - 1);
                    }
                    return true;
                }
                char quote = (char)c;
                do {
                    if ((c = HTMLScanner.this.read()) == -1) {
                        if (HTMLScanner.this.fReportErrors) {
                            HTMLScanner.this.fErrorReporter.reportError("HTML1007", null);
                        }
                        throw new EOFException();
                    }
                    if (c == 38) {
                        int ce = HTMLScanner.this.scanEntityRef(HTMLScanner.this.fStringBuffer2, false);
                        if (ce != -1) {
                            HTMLScanner.this.fStringBuffer.append((char)ce);
                        } else {
                            HTMLScanner.this.fStringBuffer.append((XMLString)HTMLScanner.this.fStringBuffer2);
                        }
                        HTMLScanner.this.fNonNormAttr.append((XMLString)HTMLScanner.this.fStringBuffer2);
                        continue;
                    }
                    if (c == 9) {
                        HTMLScanner.this.fStringBuffer.append(' ');
                        HTMLScanner.this.fNonNormAttr.append('\t');
                        continue;
                    }
                    if (c == 13 || c == 10) {
                        ++HTMLScanner.this.fCurrentEntity.lineNumber;
                        HTMLScanner.this.fCurrentEntity.columnNumber = 0;
                        if (c == 13) {
                            int c2 = HTMLScanner.this.read();
                            if (c2 != 10) {
                                --HTMLScanner.this.fCurrentEntity.offset;
                                --HTMLScanner.this.fCurrentEntity.columnNumber;
                            } else {
                                HTMLScanner.this.fNonNormAttr.append('\r');
                                c = c2;
                            }
                        }
                        HTMLScanner.this.fStringBuffer.append(' ');
                        HTMLScanner.this.fNonNormAttr.append((char)c);
                        continue;
                    }
                    if (c == quote) continue;
                    HTMLScanner.this.fStringBuffer.append((char)c);
                    HTMLScanner.this.fNonNormAttr.append((char)c);
                } while (c != quote);
                this.fQName.setValues(null, aname, aname, null);
                String avalue = HTMLScanner.this.fStringBuffer.toString();
                attributes.addAttribute(this.fQName, "CDATA", avalue);
                int lastattr = attributes.getLength() - 1;
                attributes.setSpecified(lastattr, true);
                attributes.setNonNormalizedValue(lastattr, HTMLScanner.this.fNonNormAttr.toString());
                if (HTMLScanner.this.fAugmentations) {
                    this.addLocationItem((XMLAttributes)attributes, attributes.getLength() - 1);
                }
            } else {
                this.fQName.setValues(null, aname, aname, null);
                attributes.addAttribute(this.fQName, "CDATA", "");
                attributes.setSpecified(attributes.getLength() - 1, true);
                --HTMLScanner.this.fCurrentEntity.offset;
                --HTMLScanner.this.fCurrentEntity.columnNumber;
                if (HTMLScanner.this.fAugmentations) {
                    this.addLocationItem((XMLAttributes)attributes, attributes.getLength() - 1);
                }
            }
            return true;
        }

        protected void addLocationItem(XMLAttributes attributes, int index) {
            HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
            HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
            LocationItem locationItem = new LocationItem();
            locationItem.setValues(HTMLScanner.this.fBeginLineNumber, HTMLScanner.this.fBeginColumnNumber, HTMLScanner.this.fEndLineNumber, HTMLScanner.this.fEndColumnNumber);
            Augmentations augs = attributes.getAugmentations(index);
            augs.putItem(HTMLScanner.AUGMENTATIONS, (Object)locationItem);
        }

        protected void scanEndElement() throws IOException {
            String ename = HTMLScanner.this.scanName();
            if (HTMLScanner.this.fReportErrors && ename == null) {
                HTMLScanner.this.fErrorReporter.reportError("HTML1012", null);
            }
            HTMLScanner.this.skipMarkup(false);
            if (ename != null) {
                ename = HTMLScanner.modifyName(ename, HTMLScanner.this.fNamesElems);
                if (HTMLScanner.this.fDocumentHandler != null && HTMLScanner.this.fElementCount >= HTMLScanner.this.fElementDepth) {
                    this.fQName.setValues(null, ename, ename, null);
                    HTMLScanner.this.fEndLineNumber = HTMLScanner.this.fCurrentEntity.lineNumber;
                    HTMLScanner.this.fEndColumnNumber = HTMLScanner.this.fCurrentEntity.columnNumber;
                    HTMLScanner.this.fDocumentHandler.endElement(this.fQName, HTMLScanner.this.locationAugs());
                }
            }
        }
    }

    public static class CurrentEntity {
        public Reader stream;
        public String encoding;
        public String publicId;
        public String baseSystemId;
        public String literalSystemId;
        public String expandedSystemId;
        public int lineNumber = 1;
        public int columnNumber = 1;
        public char[] buffer = new char[2048];
        public int offset = 0;
        public int length = 0;

        public CurrentEntity(Reader stream, String encoding, String publicId, String baseSystemId, String literalSystemId, String expandedSystemId) {
            this.stream = stream;
            this.encoding = encoding;
            this.publicId = publicId;
            this.baseSystemId = baseSystemId;
            this.literalSystemId = literalSystemId;
            this.expandedSystemId = expandedSystemId;
        }
    }

    public static interface Scanner {
        public boolean scan(boolean var1) throws IOException;
    }
}

