/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.tag.javadoc;


/**
 * The class <code>Linkplain</code> represents a javadoc linkplain tag.
 * 
 * <div id="example_javadoc_linkplain"> This is an examples for an embedded
 * javadoc linkplain tag: The type of the return code is a
 * {@linkplain org.dbdoclet.xiphias.dom.NodeImpl Node}. </div>
 * 
 * @author <a href="mailto:mfuchs@unico-consulting.com">Michael Fuchs</a>
 * @version 1.0
 */
public class Linkplain extends JavaDocElement {

    public Linkplain() {
	super();
	setNodeName("javadoc:linkplain");
	setFormatType(FORMAT_INLINE);
    }

    public String getName() {
	return getAttribute("name");
    }

    public String getRef() {
	return getAttribute("ref");
    }

    @Override
    public void init() {
    }
}
