module Skylighting
  ( lookupSyntax
  , syntaxByName
  , syntaxByShortName
  , syntaxesByExtension
  , syntaxesByFilename

  , module Skylighting.Syntax

  -- Re-exports from the skylighting-core package
  , module Skylighting.Types
  , module Skylighting.Tokenizer
  , module Skylighting.Parser
  , module Skylighting.Regex
  , module Skylighting.Styles
  , module Skylighting.Format.ANSI
  , module Skylighting.Format.HTML
  , module Skylighting.Format.LaTeX
  , module Skylighting.Loader

  )
where

import Skylighting.Core
import Skylighting.Format.ANSI
import Skylighting.Format.HTML
import Skylighting.Format.LaTeX
import Skylighting.Parser
import Skylighting.Regex
import Skylighting.Styles
import Skylighting.Tokenizer
import Skylighting.Types
import Skylighting.Loader

import Skylighting.Syntax
