/* -*- Mode: C; c-basic-offset: 8; indent-tabs-mode: nil -*- */
/* vim: set filetype=c tabstop=8 shiftwidth=4 expandtab: */

#ifdef ECL_CMU_FORMAT
# define ECL_NAME_PPRINT(x) ECL_NAME(x)
#else
# define ECL_NAME_PPRINT(x) NULL
#endif
#ifdef ECL_FINAL
# define ECL_NAME(x) x
#else
# define ECL_NAME(x) NULL
#endif
#ifdef DPP
#define CLOS_ "CLOS::"
#define EXT_ "EXT::"
#define SYS_ "SI::"
#define MP_ "MP::"
#define KEY_ ":"
#define GRAY_ "GRAY::"
#define FFI_ "FFI::"
typedef struct {
        const char *name;
        const char *translation;
        /* narg >= 0: function takes exactly narg arguments */
        /* narg  < 0: function takes -narg-1 required arguments */
        int narg;
} cl_symbol_initializer;
#else
#include "ecl_constants.h"
#define CLOS_
#define EXT_
#define SYS_
#define MP_
#define KEY_
#define GRAY_
#define FFI_
#endif
/*
 * Conditional addition of functions and symbols. The list of symbols can
 * not depend on the features, because otherwise the sources will and we will
 * not be able to cross-compile.
 */
#ifdef ECL_THREADS
# define IF_MP(x) x
#else
# define IF_MP(x) NULL
#endif
#ifdef ECL_TCP
# define IF_TCP(x) x
#else
# define IF_TCP(x) NULL
#endif
#ifdef PROFILE
# define IF_PROFILE(x) x
#else
# define IF_PROFILE(x) NULL
#endif
#ifndef ECL_CLOS_STREAMS
# undef GRAY_
# define GRAY_ SYS_
#endif
#ifdef ECL_EXTERNALIZABLE
# define IF_EXTERNALIZABLE(x) x
#else
# define IF_EXTERNALIZABLE(x) NULL
#endif
#ifdef ECL_SSE2
# define IF_SSE2(x) x
#else
# define IF_SSE2(x) NULL
#endif
#if defined(HAVE_LIBFFI)
# define IF_DFFI(x) x
#else
# define IF_DFFI(x) NULL
#endif
#ifdef ECL_COMPLEX_FLOAT
# define IF_COMPLEX_FLOAT(x) x
#else
# define IF_COMPLEX_FLOAT(x) NULL
#endif
#ifdef ECL_MS_WINDOWS_HOST
# define IF_WINDOWS(x) x
#else
# define IF_WINDOWS(x) NULL
#endif

#ifndef DPP
# define ECL_FUN(name, cfun, narg) , name, cfun, narg
# define ECL_VAR(code, value) , code, value
#else
# define ECL_FUN(name, cfun, narg) , name, narg
# define ECL_VAR(code, value)
#endif

/* XXX When the symbol has the associated function its name must
   follow the naming convention, otherwise si:mangle-name will
   miscompile the symbol reference. See #534. -- jd 2019-12-04*/

cl_symbol_initializer
cl_symbols[] = {

{"NIL" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"T" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{SYS_ "UNBOUND" ECL_FUN("si_unbound", si_unbound, 0) ECL_VAR(SI_CONSTANT, ECL_UNBOUND)},
{SYS_ "PROTECT-TAG" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "DUMMY-TAG" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "*RESTART-CLUSTERS*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ECL_NIL)},
{SYS_ "*HANDLER-CLUSTERS*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ECL_NIL)},
{EXT_ "*INTERRUPTS-ENABLED*" ECL_FUN(NULL, NULL, 1) ECL_VAR(EXT_SPECIAL, ECL_T)},

/* LISP PACKAGE */
{"&ALLOW-OTHER-KEYS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"&AUX" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"&BODY" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"&ENVIRONMENT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"&KEY" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"&OPTIONAL" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"&REST" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"&WHOLE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"+" ECL_FUN("cl_P", cl_P, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"++" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"+++" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"-" ECL_FUN("cl_M", cl_M, -2) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"*" ECL_FUN("cl_X", cl_X, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"**" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"***" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"/" ECL_FUN("cl_N", cl_N, -2) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"//" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"///" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"/=" ECL_FUN("cl_NE", cl_NE, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"*BREAK-ON-SIGNALS*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"*COMPILE-FILE-PATHNAME*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"*COMPILE-FILE-TRUENAME*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"*COMPILE-PRINT*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"*COMPILE-VERBOSE*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_T)},
{"*DEBUG-IO*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, OBJNULL)},
{"*DEBUGGER-HOOK*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"*DEFAULT-PATHNAME-DEFAULTS*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, OBJNULL)},
{"*ERROR-OUTPUT*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, OBJNULL)},
{"*FEATURES*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, OBJNULL)},
{"*GENSYM-COUNTER*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ecl_make_fixnum(0))},
{"*LOAD-PATHNAME*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"*LOAD-PRINT*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"*LOAD-TRUENAME*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"*LOAD-VERBOSE*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_T)},
{"*MACROEXPAND-HOOK*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, OBJNULL)},
{"*MODULES*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, OBJNULL)},
{EXT_ "*MODULE-PROVIDER-FUNCTIONS*" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_SPECIAL, OBJNULL)},
{"*PACKAGE*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, OBJNULL)},
{"*PRINT-ARRAY*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_T)},
{"*PRINT-BASE*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ecl_make_fixnum(10))},
{"*PRINT-CASE*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, OBJNULL)},
{"*PRINT-CIRCLE*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"*PRINT-ESCAPE*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_T)},
{"*PRINT-GENSYM*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_T)},
{"*PRINT-LENGTH*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"*PRINT-LEVEL*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"*PRINT-LINES*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"*PRINT-MISER-WIDTH*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"*PRINT-PPRINT-DISPATCH*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
#if defined(ECL_CMU_FORMAT)
{"*PRINT-PRETTY*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
#else
{"*PRINT-PRETTY*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_T)},
#endif
{"*PRINT-RADIX*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"*PRINT-READABLY*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"*PRINT-RIGHT-MARGIN*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"*QUERY-IO*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, OBJNULL)},
{"*RANDOM-STATE*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, OBJNULL)},
{"*READ-BASE*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ecl_make_fixnum(10))},
{"*READ-DEFAULT-FLOAT-FORMAT*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, OBJNULL)},
{"*READ-EVAL*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_T)},
{"*READ-SUPPRESS*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, ECL_NIL)},
{"*READTABLE*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, OBJNULL)},
{"*STANDARD-INPUT*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, OBJNULL)},
{"*STANDARD-OUTPUT*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, OBJNULL)},
{"*TERMINAL-IO*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, OBJNULL)},
{"*TRACE-OUTPUT*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_SPECIAL, OBJNULL)},
{"1+" ECL_FUN("cl_1P", cl_1P, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"1-" ECL_FUN("cl_1M", cl_1M, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"<" ECL_FUN("cl_L", cl_L, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"<=" ECL_FUN("cl_LE", cl_LE, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"=" ECL_FUN("cl_E", cl_E, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{">" ECL_FUN("cl_G", cl_G, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{">=" ECL_FUN("cl_GE", cl_GE, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ABORT" ECL_FUN("cl_abort", ECL_NAME(cl_abort), -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ABS" ECL_FUN("cl_abs", cl_abs, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ACONS" ECL_FUN("cl_acons", cl_acons, 3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ACOS" ECL_FUN("cl_acos", ECL_NAME(cl_acos), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ACOSH" ECL_FUN("cl_acosh", ECL_NAME(cl_acosh), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ADJOIN" ECL_FUN("cl_adjoin", cl_adjoin, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ADJUST-ARRAY" ECL_FUN("cl_adjust_array", ECL_NAME(cl_adjust_array), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ADJUSTABLE-ARRAY-P" ECL_FUN("cl_adjustable_array_p", cl_adjustable_array_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ALPHA-CHAR-P" ECL_FUN("cl_alpha_char_p", cl_alpha_char_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ALPHANUMERICP" ECL_FUN("cl_alphanumericp", cl_alphanumericp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"AND" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"APPEND" ECL_FUN("cl_append", cl_append, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"APPLY" ECL_FUN("cl_apply", cl_apply, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"APROPOS" ECL_FUN("cl_apropos", ECL_NAME(cl_apropos), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"APROPOS-LIST" ECL_FUN("cl_apropos_list", ECL_NAME(cl_apropos_list), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"AREF" ECL_FUN("cl_aref", cl_aref, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ARITHMETIC-ERROR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ARITHMETIC-ERROR-OPERANDS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ARITHMETIC-ERROR-OPERATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ARRAY" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ARRAY-DIMENSION" ECL_FUN("cl_array_dimension", cl_array_dimension, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ARRAY-DIMENSION-LIMIT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_ARRAY_DIMENSION_LIMIT))},
{"ARRAY-DIMENSIONS" ECL_FUN("cl_array_dimensions", ECL_NAME(cl_array_dimensions), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ARRAY-DISPLACEMENT" ECL_FUN("cl_array_displacement", cl_array_displacement, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ARRAY-ELEMENT-TYPE" ECL_FUN("cl_array_element_type", cl_array_element_type, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ARRAY-HAS-FILL-POINTER-P" ECL_FUN("cl_array_has_fill_pointer_p", cl_array_has_fill_pointer_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ARRAY-IN-BOUNDS-P" ECL_FUN("cl_array_in_bounds_p", ECL_NAME(cl_array_in_bounds_p), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ARRAY-RANK" ECL_FUN("cl_array_rank", cl_array_rank, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ARRAY-RANK-LIMIT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_ARRAY_RANK_LIMIT))},
{"ARRAY-ROW-MAJOR-INDEX" ECL_FUN("cl_array_row_major_index", ECL_NAME(cl_array_row_major_index), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ARRAY-TOTAL-SIZE" ECL_FUN("cl_array_total_size", cl_array_total_size, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ARRAY-TOTAL-SIZE-LIMIT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_ARRAY_TOTAL_LIMIT))},
{"ARRAYP" ECL_FUN("cl_arrayp", cl_arrayp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ASH" ECL_FUN("cl_ash", cl_ash, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ASIN" ECL_FUN("cl_asin", ECL_NAME(cl_asin), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ASINH" ECL_FUN("cl_asinh", ECL_NAME(cl_asinh), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ASSERT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ASSOC" ECL_FUN("cl_assoc", cl_assoc, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ASSOC-IF" ECL_FUN("cl_assoc_if", ECL_NAME(cl_assoc_if), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ASSOC-IF-NOT" ECL_FUN("cl_assoc_if_not", ECL_NAME(cl_assoc_if_not), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ATAN" ECL_FUN("cl_atan", cl_atan, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ATANH" ECL_FUN("cl_atanh", ECL_NAME(cl_atanh), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ATOM" ECL_FUN("cl_atom", cl_atom, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BASE-CHAR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BASE-STRING" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BIGNUM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BIT" ECL_FUN("cl_bit", ECL_NAME(cl_bit), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BIT-AND" ECL_FUN("cl_bit_and", ECL_NAME(cl_bit_and), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BIT-ANDC1" ECL_FUN("cl_bit_andc1", ECL_NAME(cl_bit_andc1), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BIT-ANDC2" ECL_FUN("cl_bit_andc2", ECL_NAME(cl_bit_andc2), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BIT-EQV" ECL_FUN("cl_bit_eqv", ECL_NAME(cl_bit_eqv), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BIT-IOR" ECL_FUN("cl_bit_ior", ECL_NAME(cl_bit_ior), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BIT-NAND" ECL_FUN("cl_bit_nand", ECL_NAME(cl_bit_nand), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BIT-NOR" ECL_FUN("cl_bit_nor", ECL_NAME(cl_bit_nor), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BIT-NOT" ECL_FUN("cl_bit_not", ECL_NAME(cl_bit_not), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BIT-ORC1" ECL_FUN("cl_bit_orc1", ECL_NAME(cl_bit_orc1), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BIT-ORC2" ECL_FUN("cl_bit_orc2", ECL_NAME(cl_bit_orc2), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BIT-VECTOR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BIT-VECTOR-P" ECL_FUN("cl_bit_vector_p", cl_bit_vector_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BIT-XOR" ECL_FUN("cl_bit_xor", ECL_NAME(cl_bit_xor), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BLOCK" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"BOOLE" ECL_FUN("cl_boole", cl_boole, 3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BOOLE-1" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_BOOL1))},
{"BOOLE-2" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_BOOL2))},
{"BOOLE-AND" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_BOOLAND))},
{"BOOLE-ANDC1" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_BOOLANDC1))},
{"BOOLE-ANDC2" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_BOOLANDC2))},
{"BOOLE-C1" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_BOOLC1))},
{"BOOLE-C2" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_BOOLC2))},
{"BOOLE-CLR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_BOOLCLR))},
{"BOOLE-EQV" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_BOOLEQV))},
{"BOOLE-IOR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_BOOLIOR))},
{"BOOLE-NAND" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_BOOLNAND))},
{"BOOLE-NOR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_BOOLNOR))},
{"BOOLE-ORC1" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_BOOLORC1))},
{"BOOLE-ORC2" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_BOOLORC2))},
{"BOOLE-SET" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_BOOLSET))},
{"BOOLE-XOR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_BOOLXOR))},
{"BOOLEAN" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BOTH-CASE-P" ECL_FUN("cl_both_case_p", cl_both_case_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BOUNDP" ECL_FUN("cl_boundp", cl_boundp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BREAK" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BROADCAST-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BROADCAST-STREAM-STREAMS" ECL_FUN("cl_broadcast_stream_streams", cl_broadcast_stream_streams, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BUTLAST" ECL_FUN("cl_butlast", cl_butlast, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BYTE" ECL_FUN("cl_byte", ECL_NAME(cl_byte), 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BYTE-POSITION" ECL_FUN("cl_byte_position", ECL_NAME(cl_byte_position), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BYTE-SIZE" ECL_FUN("cl_byte_size", ECL_NAME(cl_byte_size), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CAAAAR" ECL_FUN("cl_caaaar", cl_caaaar, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CAAADR" ECL_FUN("cl_caaadr", cl_caaadr, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CAAAR" ECL_FUN("cl_caaar", cl_caaar, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CAADAR" ECL_FUN("cl_caadar", cl_caadar, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CAADDR" ECL_FUN("cl_caaddr", cl_caaddr, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CAADR" ECL_FUN("cl_caadr", cl_caadr, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CAAR" ECL_FUN("cl_caar", cl_caar, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CADAAR" ECL_FUN("cl_cadaar", cl_cadaar, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CADADR" ECL_FUN("cl_cadadr", cl_cadadr, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CADAR" ECL_FUN("cl_cadar", cl_cadar, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CADDAR" ECL_FUN("cl_caddar", cl_caddar, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CADDDR" ECL_FUN("cl_cadddr", cl_cadddr, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CADDR" ECL_FUN("cl_caddr", cl_caddr, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CADR" ECL_FUN("cl_cadr", cl_cadr, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CALL-ARGUMENTS-LIMIT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_CALL_ARGUMENTS_LIMIT))},
{"CAR" ECL_FUN("cl_car", cl_car, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CASE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"CATCH" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"CCASE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CDAAAR" ECL_FUN("cl_cdaaar", cl_cdaaar, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CDAADR" ECL_FUN("cl_cdaadr", cl_cdaadr, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CDAAR" ECL_FUN("cl_cdaar", cl_cdaar, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CDADAR" ECL_FUN("cl_cdadar", cl_cdadar, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CDADDR" ECL_FUN("cl_cdaddr", cl_cdaddr, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CDADR" ECL_FUN("cl_cdadr", cl_cdadr, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CDAR" ECL_FUN("cl_cdar", cl_cdar, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CDDAAR" ECL_FUN("cl_cddaar", cl_cddaar, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CDDADR" ECL_FUN("cl_cddadr", cl_cddadr, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CDDAR" ECL_FUN("cl_cddar", cl_cddar, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CDDDAR" ECL_FUN("cl_cdddar", cl_cdddar, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CDDDDR" ECL_FUN("cl_cddddr", cl_cddddr, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CDDDR" ECL_FUN("cl_cdddr", cl_cdddr, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CDDR" ECL_FUN("cl_cddr", cl_cddr, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CDR" ECL_FUN("cl_cdr", cl_cdr, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CEILING" ECL_FUN("cl_ceiling", cl_ceiling, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CELL-ERROR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CELL-ERROR-NAME" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CERROR" ECL_FUN("cl_cerror", cl_cerror, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHAR" ECL_FUN("cl_char", cl_char, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHAR-CODE" ECL_FUN("cl_char_code", cl_char_code, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHAR-CODE-LIMIT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_CHAR_CODE_LIMIT))},
{"CHAR-DOWNCASE" ECL_FUN("cl_char_downcase", cl_char_downcase, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHAR-EQUAL" ECL_FUN("cl_char_equal", cl_char_equal, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHAR-GREATERP" ECL_FUN("cl_char_greaterp", cl_char_greaterp, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHAR-INT" ECL_FUN("cl_char_int", cl_char_int, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHAR-LESSP" ECL_FUN("cl_char_lessp", cl_char_lessp, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHAR-NAME" ECL_FUN("cl_char_name", cl_char_name, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHAR-NOT-EQUAL" ECL_FUN("cl_char_not_equal", cl_char_not_equal, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHAR-NOT-GREATERP" ECL_FUN("cl_char_not_greaterp", cl_char_not_greaterp, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHAR-NOT-LESSP" ECL_FUN("cl_char_not_lessp", cl_char_not_lessp, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHAR-UPCASE" ECL_FUN("cl_char_upcase", cl_char_upcase, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHAR/=" ECL_FUN("cl_charNE", cl_charNE, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHAR<" ECL_FUN("cl_charL", cl_charL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHAR<=" ECL_FUN("cl_charLE", cl_charLE, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHAR=" ECL_FUN("cl_charE", cl_charE, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHAR>" ECL_FUN("cl_charG", cl_charG, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHAR>=" ECL_FUN("cl_charGE", cl_charGE, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHARACTER" ECL_FUN("cl_character", cl_character, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHARACTERP" ECL_FUN("cl_characterp", cl_characterp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHECK-TYPE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CIS" ECL_FUN("cl_cis", ECL_NAME(cl_cis), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CLEAR-INPUT" ECL_FUN("cl_clear_input", cl_clear_input, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CLEAR-OUTPUT" ECL_FUN("cl_clear_output", cl_clear_output, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CLOSE" ECL_FUN("cl_close", cl_close, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CLRHASH" ECL_FUN("cl_clrhash", cl_clrhash, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CODE-CHAR" ECL_FUN("cl_code_char", cl_code_char, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COERCE" ECL_FUN("cl_coerce", ECL_NAME(cl_coerce), 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COMPILATION-SPEED" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COMPILE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COMPILE-FILE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COMPILE-FILE-PATHNAME" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COMPILED-FUNCTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COMPILED-FUNCTION-P" ECL_FUN("cl_compiled_function_p", cl_compiled_function_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COMPILER-MACRO" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COMPILER-MACRO-FUNCTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COMPLEMENT" ECL_FUN("cl_complement", ECL_NAME(cl_complement), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COMPLEX" ECL_FUN("cl_complex", cl_complex, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COMPLEXP" ECL_FUN("cl_complexp", cl_complexp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COMPUTE-RESTARTS" ECL_FUN("cl_compute_restarts", ECL_NAME(cl_compute_restarts), -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CONCATENATE" ECL_FUN("cl_concatenate", ECL_NAME(cl_concatenate), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CONCATENATED-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CONCATENATED-STREAM-STREAMS" ECL_FUN("cl_concatenated_stream_streams", cl_concatenated_stream_streams, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COND" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"CONDITION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CONJUGATE" ECL_FUN("cl_conjugate", cl_conjugate, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CONTINUE" ECL_FUN("cl_continue", ECL_NAME(cl_continue), -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CONS" ECL_FUN("cl_cons", cl_cons, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CONSP" ECL_FUN("cl_consp", cl_consp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CONSTANTLY" ECL_FUN("cl_constantly", ECL_NAME(cl_constantly), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CONSTANTP" ECL_FUN("cl_constantp", cl_constantp, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CONTROL-ERROR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COPY-ALIST" ECL_FUN("cl_copy_alist", cl_copy_alist, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COPY-LIST" ECL_FUN("cl_copy_list", cl_copy_list, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COPY-PPRINT-DISPATCH" ECL_FUN("cl_copy_pprint_dispatch", ECL_NAME_PPRINT(cl_copy_pprint_dispatch), -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COPY-READTABLE" ECL_FUN("cl_copy_readtable", cl_copy_readtable, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COPY-SEQ" ECL_FUN("cl_copy_seq", cl_copy_seq, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COPY-STRUCTURE" ECL_FUN("cl_copy_structure", cl_copy_structure, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COPY-SYMBOL" ECL_FUN("cl_copy_symbol", cl_copy_symbol, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COPY-TREE" ECL_FUN("cl_copy_tree", cl_copy_tree, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COS" ECL_FUN("cl_cos", cl_cos, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COSH" ECL_FUN("cl_cosh", cl_cosh, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COUNT" ECL_FUN("cl_count", ECL_NAME(cl_count), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COUNT-IF" ECL_FUN("cl_count_if", ECL_NAME(cl_count_if), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COUNT-IF-NOT" ECL_FUN("cl_count_if_not", ECL_NAME(cl_count_if_not), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CTYPECASE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEBUG" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DECF" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DECLAIM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DECLARATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DECLARE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DECODE-FLOAT" ECL_FUN("cl_decode_float", cl_decode_float, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DECODE-UNIVERSAL-TIME" ECL_FUN("cl_decode_universal_time", ECL_NAME(cl_decode_universal_time), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEFCONSTANT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEFINE-CONDITION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEFINE-COMPILER-MACRO" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEFINE-MODIFY-MACRO" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEFINE-SETF-EXPANDER" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEFINE-SYMBOL-MACRO" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEFMACRO" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEFPACKAGE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEFPARAMETER" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEFSETF" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEFSTRUCT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEFTYPE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEFUN" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEFVAR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DELETE" ECL_FUN("cl_delete", ECL_NAME(cl_delete), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DELETE-DUPLICATES" ECL_FUN("cl_delete_duplicates", ECL_NAME(cl_delete_duplicates), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DELETE-FILE" ECL_FUN("cl_delete_file", cl_delete_file, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DELETE-IF" ECL_FUN("cl_delete_if", ECL_NAME(cl_delete_if), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DELETE-IF-NOT" ECL_FUN("cl_delete_if_not", ECL_NAME(cl_delete_if_not), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DELETE-PACKAGE" ECL_FUN("cl_delete_package", cl_delete_package, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DENOMINATOR" ECL_FUN("cl_denominator", cl_denominator, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEPOSIT-FIELD" ECL_FUN("cl_deposit_field", ECL_NAME(cl_deposit_field), 3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DESCRIBE" ECL_FUN("cl_describe", ECL_NAME(cl_describe), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DESTRUCTURING-BIND" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DIGIT-CHAR" ECL_FUN("cl_digit_char", cl_digit_char, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DIGIT-CHAR-P" ECL_FUN("cl_digit_char_p", cl_digit_char_p, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DIRECTORY" ECL_FUN("cl_directory", cl_directory, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DIRECTORY-NAMESTRING" ECL_FUN("cl_directory_namestring", cl_directory_namestring, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DISASSEMBLE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DIVISION-BY-ZERO" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DO" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"DO*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"DO-ALL-SYMBOLS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DO-EXTERNAL-SYMBOLS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DO-SYMBOLS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DOCUMENTATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DOLIST" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"DOTIMES" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"DOUBLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DOUBLE-FLOAT-EPSILON" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, OBJNULL)},
{"DOUBLE-FLOAT-NEGATIVE-EPSILON" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, OBJNULL)},
{"DPB" ECL_FUN("cl_dpb", ECL_NAME(cl_dpb), 3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DRIBBLE" ECL_FUN("cl_dribble", ECL_NAME(cl_dribble), -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DYNAMIC-EXTENT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ECASE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ECHO-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ECHO-STREAM-INPUT-STREAM" ECL_FUN("cl_echo_stream_input_stream", cl_echo_stream_input_stream, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ECHO-STREAM-OUTPUT-STREAM" ECL_FUN("cl_echo_stream_output_stream", cl_echo_stream_output_stream, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ED" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"EIGHTH" ECL_FUN("cl_eighth", cl_eighth, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ELT" ECL_FUN("cl_elt", cl_elt, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ENCODE-UNIVERSAL-TIME" ECL_FUN("cl_encode_universal_time", ECL_NAME(cl_encode_universal_time), -7) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"END-OF-FILE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ENDP" ECL_FUN("cl_endp", cl_endp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ENOUGH-NAMESTRING" ECL_FUN("cl_enough_namestring", cl_enough_namestring, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ENSURE-DIRECTORIES-EXIST" ECL_FUN("cl_ensure_directories_exist", ECL_NAME(cl_ensure_directories_exist), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"EQ" ECL_FUN("cl_eq", cl_eq, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"EQL" ECL_FUN("cl_eql", cl_eql, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"EQUAL" ECL_FUN("cl_equal", cl_equal, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"EQUALP" ECL_FUN("cl_equalp", cl_equalp, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ERROR" ECL_FUN("cl_error", cl_error, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ETYPECASE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"EVAL" ECL_FUN("cl_eval", cl_eval, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"EVAL-WHEN" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"EVENP" ECL_FUN("cl_evenp", cl_evenp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"EVERY" ECL_FUN("cl_every", ECL_NAME(cl_every), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"EXP" ECL_FUN("cl_exp", cl_exp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"EXPORT" ECL_FUN("cl_export", cl_export, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"EXPT" ECL_FUN("cl_expt", cl_expt, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"EXTENDED-CHAR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FBOUNDP" ECL_FUN("cl_fboundp", cl_fboundp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FCEILING" ECL_FUN("cl_fceiling", ECL_NAME(cl_fceiling), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FDEFINITION" ECL_FUN("cl_fdefinition", cl_fdefinition, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FFLOOR" ECL_FUN("cl_ffloor", ECL_NAME(cl_ffloor), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FIFTH" ECL_FUN("cl_fifth", cl_fifth, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FILE-AUTHOR" ECL_FUN("cl_file_author", cl_file_author, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FILE-ERROR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FILE-ERROR-PATHNAME" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FILE-LENGTH" ECL_FUN("cl_file_length", cl_file_length, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FILE-NAMESTRING" ECL_FUN("cl_file_namestring", cl_file_namestring, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FILE-POSITION" ECL_FUN("cl_file_position", cl_file_position, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FILE-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FILE-STRING-LENGTH" ECL_FUN("cl_file_string_length", cl_file_string_length, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FILE-WRITE-DATE" ECL_FUN("cl_file_write_date", cl_file_write_date, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FILL" ECL_FUN("cl_fill", ECL_NAME(cl_fill), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FILL-POINTER" ECL_FUN("cl_fill_pointer", cl_fill_pointer, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FIND" ECL_FUN("cl_find", ECL_NAME(cl_find), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FIND-ALL-SYMBOLS" ECL_FUN("cl_find_all_symbols", ECL_NAME(cl_find_all_symbols), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FIND-IF" ECL_FUN("cl_find_if", ECL_NAME(cl_find_if), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FIND-IF-NOT" ECL_FUN("cl_find_if_not", ECL_NAME(cl_find_if_not), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FIND-PACKAGE" ECL_FUN("cl_find_package", cl_find_package, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FIND-RESTART" ECL_FUN("cl_find_restart", ECL_NAME(cl_find_restart), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FIND-SYMBOL" ECL_FUN("cl_find_symbol", cl_find_symbol, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FINISH-OUTPUT" ECL_FUN("cl_finish_output", cl_finish_output, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FIRST" ECL_FUN("cl_car", cl_car, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FIXNUM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FLET" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"FLOAT" ECL_FUN("cl_float", cl_float, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FLOAT-DIGITS" ECL_FUN("cl_float_digits", cl_float_digits, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FLOAT-PRECISION" ECL_FUN("cl_float_precision", cl_float_precision, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FLOAT-RADIX" ECL_FUN("cl_float_radix", cl_float_radix, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FLOAT-SIGN" ECL_FUN("cl_float_sign", cl_float_sign, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FLOATING-POINT-INEXACT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FLOATING-POINT-INVALID-OPERATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FLOATING-POINT-OVERFLOW" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FLOATING-POINT-UNDERFLOW" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FLOATP" ECL_FUN("cl_floatp", cl_floatp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FLOOR" ECL_FUN("cl_floor", cl_floor, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FMAKUNBOUND" ECL_FUN("cl_fmakunbound", cl_fmakunbound, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FORCE-OUTPUT" ECL_FUN("cl_force_output", cl_force_output, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FORMAT" ECL_FUN("cl_format", cl_format, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FORMATTER" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FOURTH" ECL_FUN("cl_cadddr", cl_cadddr, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FRESH-LINE" ECL_FUN("cl_fresh_line", cl_fresh_line, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FROUND" ECL_FUN("cl_fround", ECL_NAME(cl_fround), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FTRUNCATE" ECL_FUN("cl_ftruncate", ECL_NAME(cl_ftruncate), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FTYPE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FUNCALL" ECL_FUN("cl_funcall", cl_funcall, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FUNCTION-LAMBDA-EXPRESSION" ECL_FUN("cl_function_lambda_expression", cl_function_lambda_expression, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FUNCTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"FUNCTION-KEYWORDS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FUNCTIONP" ECL_FUN("cl_functionp", cl_functionp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"GCD" ECL_FUN("cl_gcd", cl_gcd, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"GENSYM" ECL_FUN("cl_gensym", cl_gensym, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"GENTEMP" ECL_FUN("cl_gentemp", cl_gentemp, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"GET" ECL_FUN("cl_get", cl_get, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"GET-DECODED-TIME" ECL_FUN("cl_get_decoded_time", ECL_NAME(cl_get_decoded_time), 0) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"GET-DISPATCH-MACRO-CHARACTER" ECL_FUN("cl_get_dispatch_macro_character", cl_get_dispatch_macro_character, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"GET-INTERNAL-REAL-TIME" ECL_FUN("cl_get_internal_real_time", cl_get_internal_real_time, 0) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"GET-INTERNAL-RUN-TIME" ECL_FUN("cl_get_internal_run_time", cl_get_internal_run_time, 0) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"GET-MACRO-CHARACTER" ECL_FUN("cl_get_macro_character", cl_get_macro_character, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"GET-OUTPUT-STREAM-STRING" ECL_FUN("cl_get_output_stream_string", cl_get_output_stream_string, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"GET-PROPERTIES" ECL_FUN("cl_get_properties", cl_get_properties, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"GET-SETF-EXPANSION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"GET-UNIVERSAL-TIME" ECL_FUN("cl_get_universal_time", cl_get_universal_time, 0) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"GETF" ECL_FUN("cl_getf", cl_getf, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"GETHASH" ECL_FUN("cl_gethash", cl_gethash, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"GO" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"GRAPHIC-CHAR-P" ECL_FUN("cl_graphic_char_p", cl_graphic_char_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"HANDLER-CASE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"HANDLER-BIND" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"HASH-TABLE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"HASH-TABLE-COUNT" ECL_FUN("cl_hash_table_count", cl_hash_table_count, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"HASH-TABLE-P" ECL_FUN("cl_hash_table_p", cl_hash_table_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"HASH-TABLE-REHASH-SIZE" ECL_FUN("cl_hash_table_rehash_size", cl_hash_table_rehash_size, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"HASH-TABLE-REHASH-THRESHOLD" ECL_FUN("cl_hash_table_rehash_threshold", cl_hash_table_rehash_threshold, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"HASH-TABLE-SIZE" ECL_FUN("cl_hash_table_size", cl_hash_table_size, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"HASH-TABLE-TEST" ECL_FUN("cl_hash_table_test", cl_hash_table_test, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"HOST-NAMESTRING" ECL_FUN("cl_host_namestring", cl_host_namestring, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"IDENTITY" ECL_FUN("cl_identity", cl_identity, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"IGNORABLE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"IGNORE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"IGNORE-ERRORS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"IMAGPART" ECL_FUN("cl_imagpart", cl_imagpart, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"IMPORT" ECL_FUN("cl_import", cl_import, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"IN-PACKAGE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"INCF" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"INLINE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"INPUT-STREAM-P" ECL_FUN("cl_input_stream_p", cl_input_stream_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"INSPECT" ECL_FUN("cl_inspect", ECL_NAME(cl_inspect), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"INTEGER" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"INTEGER-DECODE-FLOAT" ECL_FUN("cl_integer_decode_float", cl_integer_decode_float, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"INTEGER-LENGTH" ECL_FUN("cl_integer_length", cl_integer_length, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"INTEGERP" ECL_FUN("cl_integerp", cl_integerp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"INTERACTIVE-STREAM-P" ECL_FUN("cl_interactive_stream_p", cl_interactive_stream_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"INTERN" ECL_FUN("cl_intern", cl_intern, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"INTERNAL-TIME-UNITS-PER-SECOND" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, OBJNULL)},
{"INTERSECTION" ECL_FUN("cl_intersection", ECL_NAME(cl_intersection), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"INVOKE-DEBUGGER" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"INVOKE-RESTART" ECL_FUN("cl_invoke_restart", ECL_NAME(cl_invoke_restart), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"INVOKE-RESTART-INTERACTIVELY" ECL_FUN("cl_invoke_restart_interactively", ECL_NAME(cl_invoke_restart_interactively), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ISQRT" ECL_FUN("cl_isqrt", ECL_NAME(cl_isqrt), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"KEYWORD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"KEYWORDP" ECL_FUN("cl_keywordp", cl_keywordp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LABELS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"LAMBDA" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"LAMBDA-LIST-KEYWORDS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, OBJNULL)},
{"LAMBDA-PARAMETERS-LIMIT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_LAMBDA_PARAMETERS_LIMIT))},
{"LAST" ECL_FUN("cl_last", cl_last, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LCM" ECL_FUN("cl_lcm", cl_lcm, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LDB" ECL_FUN("cl_ldb", ECL_NAME(cl_ldb), 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LDB-TEST" ECL_FUN("cl_ldb_test", ECL_NAME(cl_ldb_test), 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LDIFF" ECL_FUN("cl_ldiff", cl_ldiff, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LEAST-NEGATIVE-DOUBLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_LEAST_NEGATIVE_DOUBLE_FLOAT)},
{"LEAST-NEGATIVE-LONG-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_LEAST_NEGATIVE_LONG_FLOAT)},
{"LEAST-NEGATIVE-NORMALIZED-DOUBLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_LEAST_NEGATIVE_NORMALIZED_DOUBLE_FLOAT)},
{"LEAST-NEGATIVE-NORMALIZED-LONG-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_LEAST_NEGATIVE_NORMALIZED_LONG_FLOAT)},
{"LEAST-NEGATIVE-NORMALIZED-SHORT-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_LEAST_NEGATIVE_NORMALIZED_SHORT_FLOAT)},
{"LEAST-NEGATIVE-NORMALIZED-SINGLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_LEAST_NEGATIVE_NORMALIZED_SINGLE_FLOAT)},
{"LEAST-NEGATIVE-SHORT-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_LEAST_NEGATIVE_SHORT_FLOAT)},
{"LEAST-NEGATIVE-SINGLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_LEAST_NEGATIVE_SINGLE_FLOAT)},
{"LEAST-POSITIVE-DOUBLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_LEAST_POSITIVE_DOUBLE_FLOAT)},
{"LEAST-POSITIVE-LONG-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_LEAST_POSITIVE_LONG_FLOAT)},
{"LEAST-POSITIVE-NORMALIZED-DOUBLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_LEAST_POSITIVE_NORMALIZED_DOUBLE_FLOAT)},
{"LEAST-POSITIVE-NORMALIZED-LONG-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_LEAST_POSITIVE_NORMALIZED_LONG_FLOAT)},
{"LEAST-POSITIVE-NORMALIZED-SHORT-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_LEAST_POSITIVE_NORMALIZED_SHORT_FLOAT)},
{"LEAST-POSITIVE-NORMALIZED-SINGLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_LEAST_POSITIVE_NORMALIZED_SINGLE_FLOAT)},
{"LEAST-POSITIVE-SHORT-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_LEAST_POSITIVE_SHORT_FLOAT)},
{"LEAST-POSITIVE-SINGLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_LEAST_POSITIVE_SINGLE_FLOAT)},
{"LENGTH" ECL_FUN("cl_length", cl_length, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LET" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"LET*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"LISP-IMPLEMENTATION-TYPE" ECL_FUN("cl_lisp_implementation_type", ECL_NAME(cl_lisp_implementation_type), 0) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LISP-IMPLEMENTATION-VERSION" ECL_FUN("cl_lisp_implementation_version", ECL_NAME(cl_lisp_implementation_version), 0) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LIST" ECL_FUN("cl_list", cl_list, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LIST*" ECL_FUN("cl_listX", cl_listX, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LIST-ALL-PACKAGES" ECL_FUN("cl_list_all_packages", cl_list_all_packages, 0) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LIST-LENGTH" ECL_FUN("cl_list_length", cl_list_length, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LISTEN" ECL_FUN("cl_listen", cl_listen, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LISTP" ECL_FUN("cl_listp", cl_listp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOAD" ECL_FUN("cl_load", cl_load, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOAD-LOGICAL-PATHNAME-TRANSLATIONS" ECL_FUN("cl_load_logical_pathname_translations", ECL_NAME(cl_load_logical_pathname_translations), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOAD-TIME-VALUE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"LOCALLY" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"LOG" ECL_FUN("cl_log", cl_log, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOGAND" ECL_FUN("cl_logand", cl_logand, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOGANDC1" ECL_FUN("cl_logandc1", cl_logandc1, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOGANDC2" ECL_FUN("cl_logandc2", cl_logandc2, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOGBITP" ECL_FUN("cl_logbitp", cl_logbitp, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOGCOUNT" ECL_FUN("cl_logcount", cl_logcount, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOGEQV" ECL_FUN("cl_logeqv", cl_logeqv, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOGICAL-PATHNAME" ECL_FUN("cl_logical_pathname", cl_logical_pathname, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOGICAL-PATHNAME-TRANSLATIONS" ECL_FUN("cl_logical_pathname_translations", ECL_NAME(cl_logical_pathname_translations), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOGIOR" ECL_FUN("cl_logior", cl_logior, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOGNAND" ECL_FUN("cl_lognand", cl_lognand, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOGNOR" ECL_FUN("cl_lognor", cl_lognor, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOGNOT" ECL_FUN("cl_lognot", cl_lognot, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOGORC1" ECL_FUN("cl_logorc1", cl_logorc1, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOGORC2" ECL_FUN("cl_logorc2", cl_logorc2, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOGTEST" ECL_FUN("cl_logtest", ECL_NAME(cl_logtest), 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOGXOR" ECL_FUN("cl_logxor", cl_logxor, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LONG-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LONG-FLOAT-EPSILON" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, OBJNULL)},
{"LONG-FLOAT-NEGATIVE-EPSILON" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, OBJNULL)},
{"LONG-SITE-NAME" ECL_FUN("cl_long_site_name", ECL_NAME(cl_long_site_name), 0) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOOP" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOOP-FINISH" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"LOWER-CASE-P" ECL_FUN("cl_lower_case_p", cl_lower_case_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MACHINE-INSTANCE" ECL_FUN("cl_machine_instance", ECL_NAME(cl_machine_instance), 0) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MACHINE-TYPE" ECL_FUN("cl_machine_type", ECL_NAME(cl_machine_type), 0) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MACHINE-VERSION" ECL_FUN("cl_machine_version", ECL_NAME(cl_machine_version), 0) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MACRO-FUNCTION" ECL_FUN("cl_macro_function", cl_macro_function, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MACROEXPAND" ECL_FUN("cl_macroexpand", cl_macroexpand, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MACROEXPAND-1" ECL_FUN("cl_macroexpand_1", cl_macroexpand_1, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MACROLET" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"MAKE-ARRAY" ECL_FUN("cl_make_array", ECL_NAME(cl_make_array), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-BROADCAST-STREAM" ECL_FUN("cl_make_broadcast_stream", cl_make_broadcast_stream, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-CONDITION" ECL_FUN("cl_make_condition", ECL_NAME(cl_make_condition), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-CONCATENATED-STREAM" ECL_FUN("cl_make_concatenated_stream", cl_make_concatenated_stream, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-DISPATCH-MACRO-CHARACTER" ECL_FUN("cl_make_dispatch_macro_character", cl_make_dispatch_macro_character, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-ECHO-STREAM" ECL_FUN("cl_make_echo_stream", cl_make_echo_stream, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-HASH-TABLE" ECL_FUN("cl_make_hash_table", cl_make_hash_table, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-LIST" ECL_FUN("cl_make_list", cl_make_list, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-PACKAGE" ECL_FUN("cl_make_package", cl_make_package, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-PATHNAME" ECL_FUN("cl_make_pathname", cl_make_pathname, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-RANDOM-STATE" ECL_FUN("cl_make_random_state", cl_make_random_state, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-SEQUENCE" ECL_FUN("cl_make_sequence", ECL_NAME(cl_make_sequence), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-STRING" ECL_FUN("cl_make_string", cl_make_string, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-STRING-INPUT-STREAM" ECL_FUN("cl_make_string_input_stream", cl_make_string_input_stream, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-STRING-OUTPUT-STREAM" ECL_FUN("cl_make_string_output_stream", cl_make_string_output_stream, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-SYMBOL" ECL_FUN("cl_make_symbol", cl_make_symbol, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-SYNONYM-STREAM" ECL_FUN("cl_make_synonym_stream", cl_make_synonym_stream, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-TWO-WAY-STREAM" ECL_FUN("cl_make_two_way_stream", cl_make_two_way_stream, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKUNBOUND" ECL_FUN("cl_makunbound", cl_makunbound, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAP" ECL_FUN("cl_map", ECL_NAME(cl_map), -4) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAP-INTO" ECL_FUN("cl_map_into", ECL_NAME(cl_map_into), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAPC" ECL_FUN("cl_mapc", cl_mapc, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAPCAN" ECL_FUN("cl_mapcan", cl_mapcan, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAPCAR" ECL_FUN("cl_mapcar", cl_mapcar, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAPCON" ECL_FUN("cl_mapcon", cl_mapcon, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAPHASH" ECL_FUN("cl_maphash", cl_maphash, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAPL" ECL_FUN("cl_mapl", cl_mapl, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAPLIST" ECL_FUN("cl_maplist", cl_maplist, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MASK-FIELD" ECL_FUN("cl_mask_field", ECL_NAME(cl_mask_field), 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAX" ECL_FUN("cl_max", cl_max, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MEMBER" ECL_FUN("cl_member", cl_member, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MEMBER-IF" ECL_FUN("cl_member_if", ECL_NAME(cl_member_if), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MEMBER-IF-NOT" ECL_FUN("cl_member_if_not", ECL_NAME(cl_member_if_not), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MERGE" ECL_FUN("cl_merge", ECL_NAME(cl_merge), -5) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MERGE-PATHNAMES" ECL_FUN("cl_merge_pathnames", cl_merge_pathnames, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MIN" ECL_FUN("cl_min", cl_min, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MINUSP" ECL_FUN("cl_minusp", cl_minusp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MISMATCH" ECL_FUN("cl_mismatch", ECL_NAME(cl_mismatch), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MOD" ECL_FUN("cl_mod", cl_mod, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MOST-NEGATIVE-DOUBLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_MOST_NEGATIVE_DOUBLE_FLOAT)},
{"MOST-NEGATIVE-FIXNUM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(MOST_NEGATIVE_FIXNUM))},
{"MOST-NEGATIVE-LONG-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_MOST_NEGATIVE_LONG_FLOAT)},
{"MOST-NEGATIVE-SHORT-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_MOST_NEGATIVE_SHORT_FLOAT)},
{"MOST-NEGATIVE-SINGLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_MOST_NEGATIVE_SINGLE_FLOAT)},
{"MOST-POSITIVE-DOUBLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_MOST_POSITIVE_DOUBLE_FLOAT)},
{"MOST-POSITIVE-FIXNUM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(MOST_POSITIVE_FIXNUM))},
{"MOST-POSITIVE-LONG-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_MOST_POSITIVE_LONG_FLOAT)},
{"MOST-POSITIVE-SHORT-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_MOST_POSITIVE_SHORT_FLOAT)},
{"MOST-POSITIVE-SINGLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_MOST_POSITIVE_SINGLE_FLOAT)},
{"MUFFLE-WARNING" ECL_FUN("cl_muffle_warning", ECL_NAME(cl_muffle_warning), -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MULTIPLE-VALUE-BIND" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"MULTIPLE-VALUE-CALL" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"MULTIPLE-VALUE-LIST" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"MULTIPLE-VALUE-PROG1" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"MULTIPLE-VALUE-SETQ" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"MULTIPLE-VALUES-LIMIT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ecl_make_fixnum(ECL_MULTIPLE_VALUES_LIMIT))},
{"NAME-CHAR" ECL_FUN("cl_name_char", cl_name_char, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NAMESTRING" ECL_FUN("cl_namestring", cl_namestring, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NBUTLAST" ECL_FUN("cl_nbutlast", cl_nbutlast, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NCONC" ECL_FUN("cl_nconc", cl_nconc, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NINTERSECTION" ECL_FUN("cl_nintersection", ECL_NAME(cl_nintersection), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NINTH" ECL_FUN("cl_ninth", cl_ninth, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NOT" ECL_FUN("cl_not", cl_not, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NOTANY" ECL_FUN("cl_notany", ECL_NAME(cl_notany), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NOTEVERY" ECL_FUN("cl_notevery", ECL_NAME(cl_notevery), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NOTINLINE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NRECONC" ECL_FUN("cl_nreconc", cl_nreconc, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NREVERSE" ECL_FUN("cl_nreverse", cl_nreverse, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NSET-DIFFERENCE" ECL_FUN("cl_nset_difference", ECL_NAME(cl_nset_difference), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NSET-EXCLUSIVE-OR" ECL_FUN("cl_nset_exclusive_or", ECL_NAME(cl_nset_exclusive_or), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NSTRING-CAPITALIZE" ECL_FUN("cl_nstring_capitalize", cl_nstring_capitalize, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NSTRING-DOWNCASE" ECL_FUN("cl_nstring_downcase", cl_nstring_downcase, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NSTRING-UPCASE" ECL_FUN("cl_nstring_upcase", cl_nstring_upcase, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NSUBLIS" ECL_FUN("cl_nsublis", cl_nsublis, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NSUBST" ECL_FUN("cl_nsubst", cl_nsubst, -4) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NSUBST-IF" ECL_FUN("cl_nsubst_if", ECL_NAME(cl_nsubst_if), -4) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NSUBST-IF-NOT" ECL_FUN("cl_nsubst_if_not", ECL_NAME(cl_nsubst_if_not), -4) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NSUBSTITUTE" ECL_FUN("cl_nsubstitute", ECL_NAME(cl_nsubstitute), -4) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NSUBSTITUTE-IF" ECL_FUN("cl_nsubstitute_if", ECL_NAME(cl_nsubstitute_if), -4) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NSUBSTITUTE-IF-NOT" ECL_FUN("cl_nsubstitute_if_not", ECL_NAME(cl_nsubstitute_if_not), -4) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NTH" ECL_FUN("cl_nth", cl_nth, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NTH-VALUE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"NTHCDR" ECL_FUN("cl_nthcdr", cl_nthcdr, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NULL" ECL_FUN("cl_null", cl_null, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NUMBER" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NUMBERP" ECL_FUN("cl_numberp", cl_numberp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NUMERATOR" ECL_FUN("cl_numerator", cl_numerator, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NUNION" ECL_FUN("cl_nunion", ECL_NAME(cl_nunion), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ODDP" ECL_FUN("cl_oddp", cl_oddp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"OPEN" ECL_FUN("cl_open", cl_open, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"OPEN-STREAM-P" ECL_FUN("cl_open_stream_p", cl_open_stream_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"OPTIMIZE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"OR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"OTHERWISE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"OUTPUT-STREAM-P" ECL_FUN("cl_output_stream_p", cl_output_stream_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PACKAGE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PACKAGE-ERROR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PACKAGE-ERROR-PACKAGE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PACKAGE-NAME" ECL_FUN("cl_package_name", cl_package_name, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PACKAGE-NICKNAMES" ECL_FUN("cl_package_nicknames", cl_package_nicknames, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PACKAGE-SHADOWING-SYMBOLS" ECL_FUN("cl_package_shadowing_symbols", cl_package_shadowing_symbols, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PACKAGE-USE-LIST" ECL_FUN("cl_package_use_list", cl_package_use_list, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PACKAGE-USED-BY-LIST" ECL_FUN("cl_package_used_by_list", cl_package_used_by_list, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PACKAGEP" ECL_FUN("cl_packagep", cl_packagep, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PAIRLIS" ECL_FUN("cl_pairlis", cl_pairlis, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PARSE-ERROR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PARSE-INTEGER" ECL_FUN("cl_parse_integer", cl_parse_integer, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PARSE-NAMESTRING" ECL_FUN("cl_parse_namestring", cl_parse_namestring, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PATHNAME" ECL_FUN("cl_pathname", cl_pathname, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PATHNAME-DEVICE" ECL_FUN("cl_pathname_device", cl_pathname_device, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PATHNAME-DIRECTORY" ECL_FUN("cl_pathname_directory", cl_pathname_directory, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PATHNAME-HOST" ECL_FUN("cl_pathname_host", cl_pathname_host, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PATHNAME-MATCH-P" ECL_FUN("cl_pathname_match_p", cl_pathname_match_p, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PATHNAME-NAME" ECL_FUN("cl_pathname_name", cl_pathname_name, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PATHNAME-TYPE" ECL_FUN("cl_pathname_type", cl_pathname_type, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PATHNAME-VERSION" ECL_FUN("cl_pathname_version", cl_pathname_version, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PATHNAMEP" ECL_FUN("cl_pathnamep", cl_pathnamep, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PEEK-CHAR" ECL_FUN("cl_peek_char", cl_peek_char, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PHASE" ECL_FUN("cl_phase", ECL_NAME(cl_phase), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PI" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, ECL_PI)},
{"PLUSP" ECL_FUN("cl_plusp", cl_plusp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"POP" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"POSITION" ECL_FUN("cl_position", ECL_NAME(cl_position), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"POSITION-IF" ECL_FUN("cl_position_if", ECL_NAME(cl_position_if), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"POSITION-IF-NOT" ECL_FUN("cl_position_if_not", ECL_NAME(cl_position_if_not), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PPRINT" ECL_FUN("cl_pprint", cl_pprint, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PPRINT-DISPATCH" ECL_FUN("cl_pprint_dispatch", ECL_NAME_PPRINT(cl_pprint_dispatch), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PPRINT-EXIT-IF-LIST-EXHAUSTED" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PPRINT-FILL" ECL_FUN("cl_pprint_fill", ECL_NAME_PPRINT(cl_pprint_fill), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PPRINT-INDENT" ECL_FUN("cl_pprint_indent", ECL_NAME_PPRINT(cl_pprint_indent), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PPRINT-LINEAR" ECL_FUN("cl_pprint_linear", ECL_NAME_PPRINT(cl_pprint_linear), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PPRINT-LOGICAL-BLOCK" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PPRINT-NEWLINE" ECL_FUN("cl_pprint_newline", ECL_NAME_PPRINT(cl_pprint_newline), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PPRINT-POP" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PPRINT-TAB" ECL_FUN("cl_pprint_tab", ECL_NAME_PPRINT(cl_pprint_tab), -4) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PPRINT-TABULAR" ECL_FUN("cl_pprint_tabular", ECL_NAME_PPRINT(cl_pprint_tabular), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PRIN1" ECL_FUN("cl_prin1", cl_prin1, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PRIN1-TO-STRING" ECL_FUN("cl_prin1_to_string", ECL_NAME(cl_prin1_to_string), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PRINC" ECL_FUN("cl_princ", cl_princ, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PRINC-TO-STRING" ECL_FUN("cl_princ_to_string", ECL_NAME(cl_princ_to_string), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PRINT" ECL_FUN("cl_print", cl_print, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PRINT-NOT-READABLE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PRINT-NOT-READABLE-OBJECT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PROBE-FILE" ECL_FUN("cl_probe_file", cl_probe_file, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PROCLAIM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PROG" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"PROG*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"PROG1" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"PROG2" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"PROGN" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"PROGRAM-ERROR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PROGV" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"PROVIDE" ECL_FUN("cl_provide", ECL_NAME(cl_provide), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PSETF" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PSETQ" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"PUSH" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PUSHNEW" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"QUOTE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"RANDOM" ECL_FUN("cl_random", cl_random, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"RANDOM-STATE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"RANDOM-STATE-P" ECL_FUN("cl_random_state_p", cl_random_state_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"RASSOC" ECL_FUN("cl_rassoc", cl_rassoc, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"RASSOC-IF" ECL_FUN("cl_rassoc_if", ECL_NAME(cl_rassoc_if), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"RASSOC-IF-NOT" ECL_FUN("cl_rassoc_if_not", ECL_NAME(cl_rassoc_if_not), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"RATIO" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"RATIONAL" ECL_FUN("cl_rational", cl_rational, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"RATIONALIZE" ECL_FUN("cl_rationalize", cl_rationalize, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"RATIONALP" ECL_FUN("cl_rationalp", cl_rationalp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"READ" ECL_FUN("cl_read", cl_read, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"READ-BYTE" ECL_FUN("cl_read_byte", cl_read_byte, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"READ-CHAR" ECL_FUN("cl_read_char", cl_read_char, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"READ-CHAR-NO-HANG" ECL_FUN("cl_read_char_no_hang", cl_read_char_no_hang, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"READ-DELIMITED-LIST" ECL_FUN("cl_read_delimited_list", cl_read_delimited_list, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"READ-FROM-STRING" ECL_FUN("cl_read_from_string", ECL_NAME(cl_read_from_string), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"READ-LINE" ECL_FUN("cl_read_line", cl_read_line, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"READ-PRESERVING-WHITESPACE" ECL_FUN("cl_read_preserving_whitespace", cl_read_preserving_whitespace, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"READ-SEQUENCE" ECL_FUN("cl_read_sequence", cl_read_sequence, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"READER-ERROR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"READTABLE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"READTABLE-CASE" ECL_FUN("cl_readtable_case", cl_readtable_case, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"READTABLEP" ECL_FUN("cl_readtablep", cl_readtablep, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"REAL" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"REALP" ECL_FUN("cl_realp", cl_realp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"REALPART" ECL_FUN("cl_realpart", cl_realpart, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"REDUCE" ECL_FUN("cl_reduce", ECL_NAME(cl_reduce), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"REM" ECL_FUN("cl_rem", cl_rem, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"REMF" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"REMHASH" ECL_FUN("cl_remhash", cl_remhash, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"REMOVE" ECL_FUN("cl_remove", ECL_NAME(cl_remove), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"REMOVE-DUPLICATES" ECL_FUN("cl_remove_duplicates", ECL_NAME(cl_remove_duplicates), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"REMOVE-IF" ECL_FUN("cl_remove_if", ECL_NAME(cl_remove_if), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"REMOVE-IF-NOT" ECL_FUN("cl_remove_if_not", ECL_NAME(cl_remove_if_not), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"REMPROP" ECL_FUN("cl_remprop", cl_remprop, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"RENAME-FILE" ECL_FUN("cl_rename_file", cl_rename_file, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"RENAME-PACKAGE" ECL_FUN("cl_rename_package", cl_rename_package, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"REPLACE" ECL_FUN("cl_replace", ECL_NAME(cl_replace), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"REQUIRE" ECL_FUN("cl_require", ECL_NAME(cl_require), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"REST" ECL_FUN("cl_cdr", cl_cdr, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"RESTART" ECL_FUN(NULL, NULL, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"RESTART-BIND" ECL_FUN(NULL, NULL, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"RESTART-CASE" ECL_FUN(NULL, NULL, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"RESTART-NAME" ECL_FUN(NULL, NULL, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"RETURN" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"RETURN-FROM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"REVAPPEND" ECL_FUN("cl_revappend", cl_revappend, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"REVERSE" ECL_FUN("cl_reverse", cl_reverse, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ROOM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ROTATEF" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ROUND" ECL_FUN("cl_round", cl_round, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ROW-MAJOR-AREF" ECL_FUN("cl_row_major_aref", cl_row_major_aref, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"RPLACA" ECL_FUN("cl_rplaca", cl_rplaca, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"RPLACD" ECL_FUN("cl_rplacd", cl_rplacd, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SAFETY" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SATISFIES" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SBIT" ECL_FUN("cl_sbit", ECL_NAME(cl_sbit), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SCALE-FLOAT" ECL_FUN("cl_scale_float", cl_scale_float, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SCHAR" ECL_FUN("cl_char", cl_char, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SEARCH" ECL_FUN("cl_search", ECL_NAME(cl_search), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SECOND" ECL_FUN("cl_cadr", cl_cadr, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SEQUENCE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SERIOUS-CONDITION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SET" ECL_FUN("cl_set", cl_set, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SET-DIFFERENCE" ECL_FUN("cl_set_difference", ECL_NAME(cl_set_difference), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SET-DISPATCH-MACRO-CHARACTER" ECL_FUN("cl_set_dispatch_macro_character", cl_set_dispatch_macro_character, -4) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SET-EXCLUSIVE-OR" ECL_FUN("cl_set_exclusive_or", ECL_NAME(cl_set_exclusive_or), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SET-MACRO-CHARACTER" ECL_FUN("cl_set_macro_character", cl_set_macro_character, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SET-PPRINT-DISPATCH" ECL_FUN("cl_set_pprint_dispatch", ECL_NAME_PPRINT(cl_set_pprint_dispatch), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SET-SYNTAX-FROM-CHAR" ECL_FUN("cl_set_syntax_from_char", cl_set_syntax_from_char, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SETF" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SETQ" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"SEVENTH" ECL_FUN("cl_seventh", cl_seventh, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SHADOW" ECL_FUN("cl_shadow", cl_shadow, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SHADOWING-IMPORT" ECL_FUN("cl_shadowing_import", cl_shadowing_import, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SHIFTF" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SHORT-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SHORT-FLOAT-EPSILON" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, OBJNULL)},
{"SHORT-FLOAT-NEGATIVE-EPSILON" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, OBJNULL)},
{"SHORT-SITE-NAME" ECL_FUN("cl_short_site_name", ECL_NAME(cl_short_site_name), 0) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SIGNAL" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SIGNED-BYTE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SIGNUM" ECL_FUN("cl_signum", ECL_NAME(cl_signum), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SIMPLE-ARRAY" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SIMPLE-BASE-STRING" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SIMPLE-BIT-VECTOR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SIMPLE-BIT-VECTOR-P" ECL_FUN("cl_simple_bit_vector_p", cl_simple_bit_vector_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SIMPLE-CONDITION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SIMPLE-CONDITION-FORMAT-CONTROL" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SIMPLE-CONDITION-FORMAT-ARGUMENTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SIMPLE-ERROR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SIMPLE-STRING" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SIMPLE-STRING-P" ECL_FUN("cl_simple_string_p", cl_simple_string_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SIMPLE-TYPE-ERROR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SIMPLE-VECTOR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SIMPLE-VECTOR-P" ECL_FUN("cl_simple_vector_p", cl_simple_vector_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SIMPLE-WARNING" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SIN" ECL_FUN("cl_sin", cl_sin, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SINGLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SINGLE-FLOAT-EPSILON" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, OBJNULL)},
{"SINGLE-FLOAT-NEGATIVE-EPSILON" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_CONSTANT, OBJNULL)},
{"SINH" ECL_FUN("cl_sinh", cl_sinh, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SIXTH" ECL_FUN("cl_sixth", cl_sixth, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SLEEP" ECL_FUN("cl_sleep", cl_sleep, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SOFTWARE-TYPE" ECL_FUN("cl_software_type", ECL_NAME(cl_software_type), 0) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SOFTWARE-VERSION" ECL_FUN("cl_software_version", ECL_NAME(cl_software_version), 0) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SOME" ECL_FUN("cl_some", ECL_NAME(cl_some), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SORT" ECL_FUN("cl_sort", ECL_NAME(cl_sort), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SPACE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SPECIAL" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SPECIAL-OPERATOR-P" ECL_FUN("cl_special_operator_p", cl_special_operator_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SPEED" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SQRT" ECL_FUN("cl_sqrt", cl_sqrt, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STABLE-SORT" ECL_FUN("cl_stable_sort", ECL_NAME(cl_stable_sort), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STANDARD-CHAR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STANDARD-CHAR-P" ECL_FUN("cl_standard_char_p", cl_standard_char_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STEP" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STORAGE-CONDITION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STORE-VALUE" ECL_FUN("cl_store_value", ECL_NAME(cl_store_value), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STREAM-ELEMENT-TYPE" ECL_FUN("cl_stream_element_type", cl_stream_element_type, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STREAM-ERROR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STREAM-ERROR-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STREAM-EXTERNAL-FORMAT" ECL_FUN("cl_stream_external_format", cl_stream_external_format, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STREAMP" ECL_FUN("cl_streamp", cl_streamp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING" ECL_FUN("cl_string", cl_string, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING-DOWNCASE" ECL_FUN("cl_string_downcase", cl_string_downcase, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING-CAPITALIZE" ECL_FUN("cl_string_capitalize", cl_string_capitalize, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING-EQUAL" ECL_FUN("cl_string_equal", cl_string_equal, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING-GREATERP" ECL_FUN("cl_string_greaterp", cl_string_greaterp, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING-LEFT-TRIM" ECL_FUN("cl_string_left_trim", cl_string_left_trim, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING-LESSP" ECL_FUN("cl_string_lessp", cl_string_lessp, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING-NOT-EQUAL" ECL_FUN("cl_string_not_equal", cl_string_not_equal, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING-NOT-GREATERP" ECL_FUN("cl_string_not_greaterp", cl_string_not_greaterp, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING-NOT-LESSP" ECL_FUN("cl_string_not_lessp", cl_string_not_lessp, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING-RIGHT-TRIM" ECL_FUN("cl_string_right_trim", cl_string_right_trim, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING-TRIM" ECL_FUN("cl_string_trim", cl_string_trim, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING-UPCASE" ECL_FUN("cl_string_upcase", cl_string_upcase, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING/=" ECL_FUN("cl_stringNE", cl_stringNE, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING<" ECL_FUN("cl_stringL", cl_stringL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING<=" ECL_FUN("cl_stringLE", cl_stringLE, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING=" ECL_FUN("cl_stringE", cl_stringE, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING>" ECL_FUN("cl_stringG", cl_stringG, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRING>=" ECL_FUN("cl_stringGE", cl_stringGE, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRINGP" ECL_FUN("cl_stringp", cl_stringp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRUCTURE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STYLE-WARNING" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SUBLIS" ECL_FUN("cl_sublis", cl_sublis, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SUBSEQ" ECL_FUN("cl_subseq", cl_subseq, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SUBSETP" ECL_FUN("cl_subsetp", ECL_NAME(cl_subsetp), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SUBST" ECL_FUN("cl_subst", cl_subst, -4) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SUBST-IF" ECL_FUN("cl_subst_if", ECL_NAME(cl_subst_if), -4) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SUBST-IF-NOT" ECL_FUN("cl_subst_if_not", ECL_NAME(cl_subst_if_not), -4) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SUBSTITUTE" ECL_FUN("cl_substitute", ECL_NAME(cl_substitute), -4) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SUBSTITUTE-IF" ECL_FUN("cl_substitute_if", ECL_NAME(cl_substitute_if), -4) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SUBSTITUTE-IF-NOT" ECL_FUN("cl_substitute_if_not", ECL_NAME(cl_substitute_if_not), -4) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SUBTYPEP" ECL_FUN("cl_subtypep", ECL_NAME(cl_subtypep), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SVREF" ECL_FUN("cl_svref", cl_svref, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SXHASH" ECL_FUN("cl_sxhash", cl_sxhash, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SYMBOL" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SYMBOL-FUNCTION" ECL_FUN("cl_symbol_function", cl_symbol_function, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SYMBOL-MACROLET" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"SYMBOL-NAME" ECL_FUN("cl_symbol_name", cl_symbol_name, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SYMBOL-PACKAGE" ECL_FUN("cl_symbol_package", cl_symbol_package, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SYMBOL-PLIST" ECL_FUN("cl_symbol_plist", cl_symbol_plist, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SYMBOL-VALUE" ECL_FUN("cl_symbol_value", cl_symbol_value, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SYMBOLP" ECL_FUN("cl_symbolp", cl_symbolp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SYNONYM-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SYNONYM-STREAM-SYMBOL" ECL_FUN("cl_synonym_stream_symbol", cl_synonym_stream_symbol, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TAGBODY" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"TAILP" ECL_FUN("cl_tailp", cl_tailp, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TAN" ECL_FUN("cl_tan", cl_tan, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TANH" ECL_FUN("cl_tanh", cl_tanh, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TENTH" ECL_FUN("cl_tenth", cl_tenth, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TERPRI" ECL_FUN("cl_terpri", cl_terpri, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"THE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"THIRD" ECL_FUN("cl_caddr", cl_caddr, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"THROW" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"TIME" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TRACE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TRANSLATE-LOGICAL-PATHNAME" ECL_FUN("cl_translate_logical_pathname", cl_translate_logical_pathname, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TRANSLATE-PATHNAME" ECL_FUN("cl_translate_pathname", cl_translate_pathname, -4) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TREE-EQUAL" ECL_FUN("cl_tree_equal", cl_tree_equal, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TRUENAME" ECL_FUN("cl_truename", cl_truename, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TRUNCATE" ECL_FUN("cl_truncate", cl_truncate, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TWO-WAY-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TWO-WAY-STREAM-INPUT-STREAM" ECL_FUN("cl_two_way_stream_input_stream", cl_two_way_stream_input_stream, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TWO-WAY-STREAM-OUTPUT-STREAM" ECL_FUN("cl_two_way_stream_output_stream", cl_two_way_stream_output_stream, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TYPE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TYPE-ERROR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TYPE-ERROR-DATUM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TYPE-ERROR-EXPECTED-TYPE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TYPE-OF" ECL_FUN("cl_type_of", cl_type_of, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TYPECASE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"TYPEP" ECL_FUN("cl_typep", ECL_NAME(cl_typep), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"UNBOUND-SLOT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"UNBOUND-SLOT-INSTANCE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"UNBOUND-VARIABLE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"UNDEFINED-FUNCTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"UNEXPORT" ECL_FUN("cl_unexport", cl_unexport, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"UNINTERN" ECL_FUN("cl_unintern", cl_unintern, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"UNION" ECL_FUN("cl_union", ECL_NAME(cl_union), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"UNLESS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"UNREAD-CHAR" ECL_FUN("cl_unread_char", cl_unread_char, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"UNSIGNED-BYTE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"UNTRACE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"UNUSE-PACKAGE" ECL_FUN("cl_unuse_package", cl_unuse_package, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"UNWIND-PROTECT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"UPGRADED-ARRAY-ELEMENT-TYPE" ECL_FUN("cl_upgraded_array_element_type", ECL_NAME(cl_upgraded_array_element_type), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"UPGRADED-COMPLEX-PART-TYPE" ECL_FUN("cl_upgraded_complex_part_type", ECL_NAME(cl_upgraded_complex_part_type), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"UPPER-CASE-P" ECL_FUN("cl_upper_case_p", cl_upper_case_p, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"USE-PACKAGE" ECL_FUN("cl_use_package", cl_use_package, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"USE-VALUE" ECL_FUN("cl_use_value", ECL_NAME(cl_use_value), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"USER-HOMEDIR-PATHNAME" ECL_FUN("cl_user_homedir_pathname", cl_user_homedir_pathname, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"VALUES" ECL_FUN("cl_values", cl_values, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"VALUES-LIST" ECL_FUN("cl_values_list", cl_values_list, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"VARIABLE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"VECTOR" ECL_FUN("cl_vector", ECL_NAME(cl_vector), -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"VECTOR-POP" ECL_FUN("cl_vector_pop", ECL_NAME(cl_vector_pop), 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"VECTOR-PUSH" ECL_FUN("cl_vector_push", cl_vector_push, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"VECTOR-PUSH-EXTEND" ECL_FUN("cl_vector_push_extend", cl_vector_push_extend, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"VECTORP" ECL_FUN("cl_vectorp", cl_vectorp, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WARN" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WARNING" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WHEN" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"WILD-PATHNAME-P" ECL_FUN("cl_wild_pathname_p", cl_wild_pathname_p, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WITH-COMPILATION-UNIT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WITH-CONDITION-RESTARTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WITH-HASH-TABLE-ITERATOR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WITH-INPUT-FROM-STRING" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WITH-OPEN-FILE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WITH-OPEN-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WITH-OUTPUT-TO-STRING" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WITH-PACKAGE-ITERATOR" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WITH-SIMPLE-RESTART" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WITH-STANDARD-IO-SYNTAX" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WRITE" ECL_FUN("cl_write", cl_write, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WRITE-BYTE" ECL_FUN("cl_write_byte", cl_write_byte, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WRITE-CHAR" ECL_FUN("cl_write_char", cl_write_char, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WRITE-LINE" ECL_FUN("cl_write_line", cl_write_line, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WRITE-SEQUENCE" ECL_FUN("cl_write_sequence", cl_write_sequence, -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WRITE-STRING" ECL_FUN("cl_write_string", cl_write_string, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WRITE-TO-STRING" ECL_FUN("cl_write_to_string", ECL_NAME(cl_write_to_string), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"Y-OR-N-P" ECL_FUN("cl_y_or_n_p", ECL_NAME(cl_y_or_n_p), -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"YES-OR-NO-P" ECL_FUN("cl_yes_or_no_p", ECL_NAME(cl_yes_or_no_p), -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ZEROP" ECL_FUN("cl_zerop", cl_zerop, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ALLOCATE-INSTANCE" ECL_FUN(NULL, NULL, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ADD-METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"BUILT-IN-CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CALL-METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CALL-NEXT-METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CHANGE-CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CLASS-NAME" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"CLASS-OF" ECL_FUN("cl_class_of", cl_class_of, 1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"COMPUTE-APPLICABLE-METHODS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEFCLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEFGENERIC" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEFINE-METHOD-COMBINATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DEFMETHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"DESCRIBE-OBJECT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"ENSURE-GENERIC-FUNCTION" ECL_FUN(NULL, NULL, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FIND-CLASS" ECL_FUN("cl_find_class", cl_find_class, -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"FIND-METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"GENERIC-FUNCTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"IF" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_FORM, OBJNULL)},
{"INITIALIZE-INSTANCE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"INVALID-METHOD-ERROR" ECL_FUN("cl_invalid_method_error", ECL_NAME(cl_invalid_method_error), -3) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-INSTANCE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-INSTANCES-OBSOLETE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-LOAD-FORM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-LOAD-FORM-SAVING-SLOTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"MAKE-METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"METHOD-COMBINATION-ERROR" ECL_FUN("cl_method_combination_error", ECL_NAME(cl_method_combination_error), -2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"METHOD-COMBINATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"METHOD-QUALIFIERS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NEXT-METHOD-P" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NO-APPLICABLE-METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"NO-NEXT-METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PRINT-OBJECT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"PRINT-UNREADABLE-OBJECT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"REINITIALIZE-INSTANCE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"REMOVE-METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SHARED-INITIALIZE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SLOT-BOUNDP" ECL_FUN("cl_slot_boundp", ECL_NAME(cl_slot_boundp), 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SLOT-EXISTS-P" ECL_FUN("cl_slot_exists_p", ECL_NAME(cl_slot_exists_p), 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SLOT-MAKUNBOUND" ECL_FUN("cl_slot_makunbound", ECL_NAME(cl_slot_makunbound), 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SLOT-MISSING" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SLOT-UNBOUND" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"SLOT-VALUE" ECL_FUN("cl_slot_value", cl_slot_value, 2) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STANDARD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STANDARD-CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STANDARD-GENERIC-FUNCTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STANDARD-METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STANDARD-OBJECT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRUCTURE-CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"STRUCTURE-OBJECT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"UPDATE-INSTANCE-FOR-DIFFERENT-CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"UPDATE-INSTANCE-FOR-REDEFINED-CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WITH-ACCESSORS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{"WITH-SLOTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)},
{KEY_ "ACCESSOR" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "ARGUMENT-PRECEDENCE-ORDER" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "ALLOCATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "DECLARE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "DEFAULT-INITARGS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "DESCRIPTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "DIRECT-DEFAULT-INITARGS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "DIRECT-SLOTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "DIRECT-SUPERCLASSES" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "GENERIC-FUNCTION-CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "IDENTITY-WITH-ONE-ARGUMENT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INITARG" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INITARGS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INITFORM" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INITFUNCTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "LAMBDA-LIST" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "LOCATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "METACLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "METHOD-CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "METHOD-COMBINATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "OPERATOR" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "ORDER" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "READER" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "READERS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "REQUIRED" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "WRITER" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "WRITERS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},

/* SYSTEM PACKAGE */
{SYS_ "#!" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "*BACKQ-LEVEL*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ecl_make_fixnum(0))},
{SYS_ "*CBLOCK*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ECL_NIL)},
{SYS_ "*CIRCLE-COUNTER*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ECL_NIL)},
{SYS_ "*CIRCLE-STACK*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, OBJNULL)},
{SYS_ "*CLASS-NAME-HASH-TABLE*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, OBJNULL)},
{SYS_ "*COMPILER-CONSTANTS*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, OBJNULL)},
{SYS_ "*GC-MESSAGE*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ECL_NIL)},
{SYS_ "*GC-VERBOSE*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ECL_NIL)},
{SYS_ "*IGNORE-EOF-ON-TERMINAL-IO*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ECL_NIL)},
{SYS_ "*INDENT-FORMATTED-OUTPUT*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ECL_NIL)},
{SYS_ "*INIT-FUNCTION-PREFIX*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ECL_NIL)},
{SYS_ "*KEEP-DEFINITIONS*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ECL_T)},
{EXT_ "*LOAD-HOOKS*" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_SPECIAL, OBJNULL)},
{SYS_ "*LOAD-SEARCH-LIST*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ECL_NIL)},
{SYS_ "*MAKE-CONSTANT" ECL_FUN("si_Xmake_constant", si_Xmake_constant, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "*MAKE-SPECIAL" ECL_FUN("si_Xmake_special", si_Xmake_special, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "*PRINT-PACKAGE*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ECL_NIL)},
{SYS_ "*PRINT-STRUCTURE*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ECL_NIL)},
{SYS_ "*SHARP-EQ-CONTEXT*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ECL_NIL)},
{SYS_ "*STEP-LEVEL*" ECL_FUN("OBJNULL", OBJNULL, -1) ECL_VAR(SI_SPECIAL, ecl_make_fixnum(0))},
{SYS_ "*STEP-ACTION*" ECL_FUN("OBJNULL", OBJNULL, -1) ECL_VAR(SI_SPECIAL, ECL_NIL)},
{SYS_ "." ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "UNQUOTE" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "UNQUOTE-NSPLICE" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "UNQUOTE-SPLICE" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "ADJUST-VECTOR" ECL_FUN("si_adjust_vector", si_adjust_vector, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "ALLOCATE-RAW-INSTANCE" ECL_FUN("si_allocate_raw_instance", si_allocate_raw_instance, 3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{EXT_ "ARGC" ECL_FUN("si_argc", si_argc, 0) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "ARGV" ECL_FUN("si_argv", si_argv, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{SYS_ "ASET" ECL_FUN("si_aset", si_aset, -2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "BASE-CHAR-P" ECL_FUN("si_base_char_p", si_base_char_p, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "BASE-STRING-P" ECL_FUN("si_base_string_p", si_base_string_p, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "BC-COMPILE-FROM-STREAM" ECL_FUN("si_bc_compile_from_stream", si_bc_compile_from_stream, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "BC-DISASSEMBLE" ECL_FUN("si_bc_disassemble", si_bc_disassemble, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "BC-SPLIT" ECL_FUN("si_bc_split", si_bc_split, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "BC-JOIN" ECL_FUN("si_bc_join", si_bc_join, 4) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "BDS-TOP" ECL_FUN("si_bds_top", si_bds_top, 0) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "BDS-VAL" ECL_FUN("si_bds_val", si_bds_val, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "BDS-VAR" ECL_FUN("si_bds_var", si_bds_var, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "BIT-ARRAY-OP" ECL_FUN("si_bit_array_op", si_bit_array_op, 4) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "C-ARGUMENTS-LIMIT" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_CONSTANT, ecl_make_fixnum(ECL_C_ARGUMENTS_LIMIT))},
{SYS_ "CHAR-SET" ECL_FUN("si_char_set", si_char_set, 3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{EXT_ "CHDIR" ECL_FUN("si_chdir", si_chdir, -2) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{SYS_ "CLEAR-COMPILER-PROPERTIES" ECL_FUN("cl_identity", cl_identity, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "COERCE-TO-BASE-STRING" ECL_FUN("si_coerce_to_base_string", si_coerce_to_base_string, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "COERCE-TO-EXTENDED-STRING" ECL_FUN("si_coerce_to_extended_string", si_coerce_to_extended_string, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "COERCE-TO-FILE-PATHNAME" ECL_FUN("si_coerce_to_file_pathname", si_coerce_to_file_pathname, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "COERCE-TO-FILENAME" ECL_FUN("si_coerce_to_filename", si_coerce_to_filename, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "COERCE-TO-FUNCTION" ECL_FUN("si_coerce_to_function", si_coerce_to_function, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "COERCE-TO-PACKAGE" ECL_FUN("si_coerce_to_package", si_coerce_to_package, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "COERCE-TO-PHYSICAL-PATHNAME" ECL_FUN("si_coerce_to_physical_pathname", si_coerce_to_physical_pathname, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "COPY-TO-SIMPLE-BASE-STRING" ECL_FUN("si_copy_to_simple_base_string", si_copy_to_simple_base_string, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "COMPILED-FUNCTION-BLOCK" ECL_FUN("si_compiled_function_block", si_compiled_function_block, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{EXT_ "COMPILED-FUNCTION-NAME" ECL_FUN("si_compiled_function_name", si_compiled_function_name, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{SYS_ "COPY-STREAM" ECL_FUN("si_copy_stream", si_copy_stream, 3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "DESTRUCTURE" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "DO-READ-SEQUENCE" ECL_FUN("si_do_read_sequence", si_do_read_sequence, 4) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "DO-WRITE-SEQUENCE" ECL_FUN("si_do_write_sequence", si_do_write_sequence, 4) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "ELT-SET" ECL_FUN("si_elt_set", si_elt_set, 3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "EVAL-WITH-ENV" ECL_FUN("si_eval_with_env", si_eval_with_env, -2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "EXPAND-DEFMACRO" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FILE-COLUMN" ECL_FUN("si_file_column", si_file_column, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{EXT_ "FILE-KIND" ECL_FUN("si_file_kind", si_file_kind, 2) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{SYS_ "FILL-POINTER-SET" ECL_FUN("si_fill_pointer_set", si_fill_pointer_set, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{EXT_ "FILE-STREAM-FD" ECL_FUN("si_file_stream_fd", si_file_stream_fd, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "MAKE-STREAM-FROM-FD" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "FIXNUMP" ECL_FUN("si_fixnump", si_fixnump, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{SYS_ "FORMAT-ERROR" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
#ifdef ECL_CMU_FORMAT
{SYS_ "FORMATTER-AUX" ECL_FUN(NULL, NULL, -3) ECL_VAR(SI_ORDINARY, OBJNULL)},
#else
{SYS_ "FORMATTER-AUX" ECL_FUN("si_formatter_aux", si_formatter_aux, -3) ECL_VAR(SI_ORDINARY, OBJNULL)},
#endif
{SYS_ "FRS-BDS" ECL_FUN("si_frs_bds", si_frs_bds, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FRS-IHS" ECL_FUN("si_frs_ihs", si_frs_ihs, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FRS-TAG" ECL_FUN("si_frs_tag", si_frs_tag, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FRS-TOP" ECL_FUN("si_frs_top", si_frs_top, 0) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FSET" ECL_FUN("si_fset", si_fset, -3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FUNCTION-BLOCK-NAME" ECL_FUN("si_function_block_name", si_function_block_name, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "GET-LIBRARY-PATHNAME" ECL_FUN("si_get_library_pathname", si_get_library_pathname, 0) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "GET-SYSPROP" ECL_FUN("si_get_sysprop", si_get_sysprop, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{EXT_ "GETENV" ECL_FUN("si_getenv", si_getenv, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "GETCWD" ECL_FUN("si_getcwd", si_getcwd, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "GETPID" ECL_FUN("si_getpid", si_getpid, 0) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "GETUID" ECL_FUN("si_getuid", si_getuid, 0) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{SYS_ "HASH-SET" ECL_FUN("si_hash_set", si_hash_set, 3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "HASH-TABLE-ITERATOR" ECL_FUN("si_hash_table_iterator", si_hash_table_iterator, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "IHS-BDS" ECL_FUN("si_ihs_bds", si_ihs_bds, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "IHS-ENV" ECL_FUN("si_ihs_env", si_ihs_env, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "IHS-FUN" ECL_FUN("si_ihs_fun", si_ihs_fun, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "IHS-NEXT" ECL_FUN("si_ihs_next", si_ihs_next, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "IHS-PREV" ECL_FUN("si_ihs_prev", si_ihs_prev, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "IHS-TOP" ECL_FUN("si_ihs_top", si_ihs_top, 0) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "INTERPRETER-STACK" ECL_FUN("si_interpreter_stack", si_interpreter_stack, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "LINK-FROM" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "LINK-TO" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "LOAD-SOURCE" ECL_FUN("si_load_source", si_load_source, 4) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "LOGICAL-PATHNAME-P" ECL_FUN("si_logical_pathname_p", si_logical_pathname_p, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "MACRO" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "MAKE-LAMBDA" ECL_FUN("si_make_lambda", si_make_lambda, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "MAKE-PURE-ARRAY" ECL_FUN("si_make_pure_array", si_make_pure_array, 6) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "MAKE-STRING-OUTPUT-STREAM-FROM-STRING" ECL_FUN("si_make_string_output_stream_from_string", si_make_string_output_stream_from_string, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "MAKE-STRUCTURE" ECL_FUN("si_make_structure", si_make_structure, -2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "MAKE-VECTOR" ECL_FUN("si_make_vector", si_make_vector, 6) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "MANGLE-NAME" ECL_FUN("si_mangle_name", si_mangle_name, -2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "MEMBER1" ECL_FUN("si_member1", si_member1, 5) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "MEMQ" ECL_FUN("si_memq", si_memq, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "MKDIR" ECL_FUN("si_mkdir", si_mkdir, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{EXT_ "MKSTEMP" ECL_FUN("si_mkstemp", si_mkstemp, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{SYS_ "NEED-TO-MAKE-LOAD-FORM-P" ECL_FUN("si_need_to_make_load_form_p", si_need_to_make_load_form_p, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "RMDIR" ECL_FUN("si_rmdir", si_rmdir, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{EXT_ "MAKE-PIPE" ECL_FUN("si_make_pipe", si_make_pipe, 0) ECL_VAR(EXT_ORDINARY, OBJNULL)},
/* package extensions */
{EXT_ "*ED-FUNCTIONS*" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_SPECIAL, OBJNULL)},
{SYS_ "*IGNORE-PACKAGE-LOCKS*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ECL_NIL)},
{EXT_ "PACKAGE-LOCK" ECL_FUN("si_package_lock", si_package_lock, 2) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "PACKAGE-LOCKED-P" ECL_FUN("si_package_locked_p", si_package_locked_p, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{SYS_ "LOCK-PACKAGE" ECL_FUN(NULL, NULL, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{SYS_ "UNLOCK-PACKAGE" ECL_FUN(NULL, NULL, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{SYS_ "WITHOUT-PACKAGE-LOCKS" ECL_FUN(NULL, NULL, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{SYS_ "WITH-UNLOCKED-PACKAGES" ECL_FUN(NULL, NULL, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "PACKAGE-LOCAL-NICKNAMES" ECL_FUN("si_package_local_nicknames", si_package_local_nicknames, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "PACKAGE-LOCALLY-NICKNAMED-BY-LIST" ECL_FUN("si_package_locally_nicknamed_by_list", si_package_locally_nicknamed_by_list, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "ADD-PACKAGE-LOCAL-NICKNAME" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "REMOVE-PACKAGE-LOCAL-NICKNAME" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{SYS_ "%ADD-PACKAGE-LOCAL-NICKNAME" ECL_FUN("si_add_package_local_nickname", si_add_package_local_nickname, 3) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{SYS_ "%REMOVE-PACKAGE-LOCAL-NICKNAME" ECL_FUN("si_remove_package_local_nickname", si_remove_package_local_nickname, 2) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{SYS_ "PACKAGE-HASH-TABLES" ECL_FUN("si_package_hash_tables", si_package_hash_tables, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "PATHNAME-TRANSLATIONS" ECL_FUN("si_pathname_translations", si_pathname_translations, -2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "POINTER" ECL_FUN("si_pointer", si_pointer, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "PRETTY-PRINT-FORMAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "PROCESS-DECLARATIONS" ECL_FUN("si_process_declarations", si_process_declarations, -2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "PROCESS-LAMBDA" ECL_FUN("si_process_lambda", si_process_lambda, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "PROCESS-LAMBDA-LIST" ECL_FUN("si_process_lambda_list", si_process_lambda_list, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "PUT-F" ECL_FUN("si_put_f", si_put_f, 3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "PUT-PROPERTIES" ECL_FUN("si_put_properties", si_put_properties, -2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "PUT-SYSPROP" ECL_FUN("si_put_sysprop", si_put_sysprop, 3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "PUTPROP" ECL_FUN("si_putprop", si_putprop, 3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "READTABLE-CASE-SET" ECL_FUN("si_readtable_case_set", si_readtable_case_set, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "REM-F" ECL_FUN("si_rem_f", si_rem_f, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "REM-SYSPROP" ECL_FUN("si_rem_sysprop", si_rem_sysprop, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "REPLACE-ARRAY" ECL_FUN("si_replace_array", si_replace_array, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "ROW-MAJOR-ASET" ECL_FUN("si_row_major_aset", si_row_major_aset, 3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{EXT_ "SAFE-EVAL" ECL_FUN("si_safe_eval", ECL_NAME(si_safe_eval), -3) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{SYS_ "SCH-FRS-BASE" ECL_FUN("si_sch_frs_base", si_sch_frs_base, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SCHAR-SET" ECL_FUN("si_char_set", si_char_set, 3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SERROR" ECL_FUN("si_serror", si_serror, -3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SHARP-A-READER" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SHARP-S-READER" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SELECT-PACKAGE" ECL_FUN("si_select_package", si_select_package, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SET-SYMBOL-PLIST" ECL_FUN("si_set_symbol_plist", si_set_symbol_plist, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
#if defined(HAVE_PUTENV) || defined(HAVE_SETENV)
{EXT_ "SETENV" ECL_FUN("si_setenv", si_setenv, 2) ECL_VAR(EXT_ORDINARY, OBJNULL)},
#else
{EXT_ "SETENV" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
#endif
{SYS_ "SETF-METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SETF-NAMEP" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SIMPLE-PROGRAM-ERROR" ECL_FUN("si_simple_program_error", ECL_NAME(si_simple_program_error), -2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SIGNAL-SIMPLE-ERROR" ECL_FUN("si_signal_simple_error", si_signal_simple_error, -5) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SIGNAL-TYPE-ERROR" ECL_FUN("si_signal_type_error", si_signal_type_error, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SPECIALP" ECL_FUN("si_specialp", si_specialp, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "CONSTP" ECL_FUN("si_constp", si_constp, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "STANDARD-READTABLE" ECL_FUN("si_standard_readtable", si_standard_readtable, 0) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "STEPPER" ECL_FUN("OBJNULL", OBJNULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "BASE-STRING-CONCATENATE" ECL_FUN("si_base_string_concatenate", si_base_string_concatenate, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "STRING-TO-OBJECT" ECL_FUN("si_string_to_object", ECL_NAME(si_string_to_object), -2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "STRUCTURE-NAME" ECL_FUN("si_structure_name", si_structure_name, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "STRUCTURE-PRINT-FUNCTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "STRUCTURE-REF" ECL_FUN("si_structure_ref", si_structure_ref, 3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "STRUCTURE-SET" ECL_FUN("si_structure_set", si_structure_set, 4) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "STRUCTURE-SLOT-DESCRIPTIONS" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "STRUCTURE-SUBTYPE-P" ECL_FUN("si_structure_subtype_p", si_structure_subtype_p, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "STRUCTUREP" ECL_FUN("si_structurep", si_structurep, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SVSET" ECL_FUN("si_svset", si_svset, 3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SYMBOL-MACRO" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{EXT_ "SYSTEM" ECL_FUN("si_system", si_system, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{SYS_ "TERMINAL-INTERRUPT" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "TOP-LEVEL" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "UNIVERSAL-ERROR-HANDLER" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "STACK-ERROR-HANDLER" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "VALID-FUNCTION-NAME-P" ECL_FUN("si_valid_function_name_p", si_valid_function_name_p, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SEARCH-PRINT-CIRCLE" ECL_FUN("si_search_print_circle", si_search_print_circle, 1) ECL_VAR(SI_SPECIAL, OBJNULL)},
{SYS_ "WRITE-OBJECT-WITH-CIRCLE" ECL_FUN("si_write_object_with_circle", si_write_object_with_circle, 3) ECL_VAR(SI_SPECIAL, OBJNULL)},
{SYS_ "WRITE-OBJECT" ECL_FUN("si_write_object", si_write_object, 2) ECL_VAR(SI_SPECIAL, OBJNULL)},
{SYS_ "WRITE-UGLY-OBJECT" ECL_FUN("si_write_ugly_object", si_write_ugly_object, 2) ECL_VAR(SI_SPECIAL, OBJNULL)},

{SYS_ "COPY-INSTANCE" ECL_FUN("si_copy_instance", si_copy_instance, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "GENERIC-FUNCTION-P" ECL_FUN("si_generic_function_p", si_generic_function_p, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "INSTANCE-REF" ECL_FUN("si_instance_ref", si_instance_ref, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "INSTANCE-SET" ECL_FUN("si_instance_set", si_instance_set, 3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "INSTANCE-OBSOLETE-P" ECL_FUN("si_instance_obsolete_p", si_instance_obsolete_p, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "INSTANCE-NEW-STAMP" ECL_FUN("si_instance_new_stamp", si_instance_new_stamp, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "INSTANCE-GET-STAMP" ECL_FUN("si_instance_get_stamp", si_instance_get_stamp, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "INSTANCE-SLOTDS" ECL_FUN("si_instance_slotds", si_instance_slotds, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "INSTANCE-SIG-SET" ECL_FUN("si_instance_sig_set", si_instance_sig_set, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "INSTANCE-CLASS" ECL_FUN("si_instance_class", si_instance_class, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "INSTANCE-CLASS-SET" ECL_FUN("si_instance_class_set", si_instance_class_set, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "INSTANCEP" ECL_FUN("si_instancep", si_instancep, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SL-BOUNDP" ECL_FUN("si_sl_boundp", si_sl_boundp, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SL-MAKUNBOUND" ECL_FUN("si_sl_makunbound", si_sl_makunbound, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SUBCLASSP" ECL_FUN("si_subclassp", ECL_NAME(si_subclassp), -3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "OF-CLASS-P" ECL_FUN("si_of_class_p", ECL_NAME(si_of_class_p), -3) ECL_VAR(SI_ORDINARY, OBJNULL)},
/*{SYS_ "UNBOUND", SI_ORDINARY, si_unbound, 0, OBJNULL}, */

{EXT_ "*SOURCE-LOCATION*" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_SPECIAL, ECL_NIL)},
{EXT_ "*REGISTER-WITH-PDE-HOOK*" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_SPECIAL, ECL_NIL)},
{EXT_ "REGISTER-WITH-PDE" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

/* #ifdef PROFILE */
{SYS_ "PROFILE" ECL_FUN("si_profile", IF_PROFILE(si_profile), -3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "CLEAR-PROFILE" ECL_FUN("si_clear_profile", IF_PROFILE(si_clear_profile), -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "DISPLAY-PROFILE" ECL_FUN("si_display_profile", IF_PROFILE(si_display_profile), -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
/* #endif PROFILE */

/* #ifdef ECL_TCP */
{SYS_ "*PROFILE-ARRAY*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, OBJNULL)},
{SYS_ "OPEN-CLIENT-STREAM" ECL_FUN("si_open_client_stream", IF_TCP(si_open_client_stream), 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "OPEN-SERVER-STREAM" ECL_FUN("si_open_server_stream", IF_TCP(si_open_server_stream), 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "OPEN-UNIX-SOCKET-STREAM" ECL_FUN("si_open_unix_socket_stream", IF_TCP(si_open_unix_socket_stream), 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "LOOKUP-HOST-ENTRY" ECL_FUN("si_lookup_host_entry", IF_TCP(si_lookup_host_entry), 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
/* #endif ECL_TCP */

{EXT_ "CATCH-SIGNAL" ECL_FUN("si_catch_signal", si_catch_signal, -3) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "GET-SIGNAL-HANDLER" ECL_FUN("si_get_signal_handler", si_get_signal_handler, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "SET-SIGNAL-HANDLER" ECL_FUN("si_set_signal_handler", si_set_signal_handler, 2) ECL_VAR(EXT_ORDINARY, OBJNULL)},

/* KEYWORD PACKAGE */
{KEY_ "ADJUSTABLE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "ABORT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "ABSOLUTE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "ALLOW-OTHER-KEYS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "APPEND" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "ARRAY" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "BACK" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "BASE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "BLOCK" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "CAPITALIZE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "CATCH" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "CASE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "CIRCLE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "CLOSE-ON-EXEC" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "COMPILE-TOPLEVEL" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "COMMON" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "CONC-NAME" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "CONSTRUCTOR" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "CONTROL-STRING" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "COPIER" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "CREATE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "DATUM" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "DEFAULT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "DEFAULTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "DEVICE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "DIRECTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "DIRECTORY" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "DISPLACED-INDEX-OFFSET" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "DISPLACED-TO" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "DOCUMENTATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "DOWNCASE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "ELEMENT-TYPE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "END" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "END1" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "END2" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "EOF" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "ERROR" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "ESCAPE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "EXECUTE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "EXPECTED-TYPE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "EXPORT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "EXPORT-FROM" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "EXTERNAL" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "EXTERNAL-FORMAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "FIFO" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "FILE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "FILL-POINTER" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "FORMAT-ARGUMENTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "FORMAT-CONTROL" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "FUNCTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "GENSYM" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "HASH-FUNCTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "HOST" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "IF-DOES-NOT-EXIST" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "IF-ERROR-EXISTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "IF-EXISTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "IF-INPUT-DOES-NOT-EXIST" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "IF-OUTPUT-EXISTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "IGNORE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "IMPORT-FROM" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INCLUDE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INHERITED" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INITIAL-ELEMENT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INITIAL-CONTENTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INITIAL-OFFSET" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INPUT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INTERACTIVE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INSTANCE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INTERN" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INTERNAL" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INVERT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "IO" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "JUNK-ALLOWED" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "KEY" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "LENGTH" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "LEVEL" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "LINES" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "LINK" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "LIST-ALL" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "LOCAL" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "LOCAL-NICKNAMES" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "LOCKABLE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "LOAD-TOPLEVEL" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "MASK" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "MISER-WIDTH" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "NAME" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "NAMED" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "NEW-VERSION" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "NEWEST" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "NICKNAMES" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "NONBLOCK" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "OBJECT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "OFFSET" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "OPERATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "OPERANDS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "OUTPUT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "OVERWRITE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "PACKAGE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "PATHNAME" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "PPRINT-DISPATCH" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "PREDICATE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "PRESERVE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "PRETTY" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "PRINT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "PRINT-FUNCTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "PRINT-OBJECT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "PROBE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "PROCESS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "RADIX" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "READABLY" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "REHASH-SIZE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "REHASH-THRESHOLD" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "RELATIVE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "RENAME" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "RENAME-AND-DELETE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "REPORT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "RIGHT-MARGIN" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "SET-DEFAULT-PATHNAME" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "SEARCH-LIST" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "SHADOW" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "SHADOWING-IMPORT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "SIZE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "SPECIAL" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "START" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "START1" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "START2" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "SUPERSEDE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "TAG" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "TEST" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "TEST-NOT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "TRUNCATE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "TYPE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UNSPECIFIC" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UNMASK" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UP" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UPCASE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "USE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "CSTREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "VERBOSE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "VERSION" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "WILD" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "WILD-INFERIORS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "WAIT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},

{EXT_ "BYTE8" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "BYTE16" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "BYTE32" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "BYTE64" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "COMPILER-LET" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_FORM, OBJNULL)},
{EXT_ "INTEGER8" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "INTEGER16" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "INTEGER32" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "INTEGER64" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "LAMBDA-BLOCK" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "QUIT" ECL_FUN("si_quit", si_quit, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "GET-METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "INSTANCE" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{SYS_ "ALLOCATE-FOREIGN-DATA" ECL_FUN("si_allocate_foreign_data", si_allocate_foreign_data, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FIND-FOREIGN-SYMBOL" ECL_FUN("si_find_foreign_symbol", si_find_foreign_symbol, 4) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FOREIGN-DATA" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FOREIGN-DATA-ADDRESS" ECL_FUN("si_foreign_data_address", si_foreign_data_address, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FOREIGN-DATA-EQUAL" ECL_FUN("si_foreign_data_equal", si_foreign_data_equal, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FOREIGN-DATA-P" ECL_FUN("si_foreign_data_p", si_foreign_data_p, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FOREIGN-DATA-POINTER" ECL_FUN("si_foreign_data_pointer", si_foreign_data_pointer, 4) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FOREIGN-DATA-RECAST" ECL_FUN("si_foreign_data_recast", si_foreign_data_recast, 3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FOREIGN-DATA-REF" ECL_FUN("si_foreign_data_ref", si_foreign_data_ref, 4) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FOREIGN-DATA-REF-ELT" ECL_FUN("si_foreign_data_ref_elt", si_foreign_data_ref_elt, 3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FOREIGN-DATA-SET" ECL_FUN("si_foreign_data_set", si_foreign_data_set, 3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FOREIGN-DATA-SET-ELT" ECL_FUN("si_foreign_data_set_elt", si_foreign_data_set_elt, 4) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FOREIGN-DATA-TAG" ECL_FUN("si_foreign_data_tag", si_foreign_data_tag, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FOREIGN-ELT-TYPE-P" ECL_FUN("si_foreign_elt_type_p", si_foreign_elt_type_p, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FREE-FOREIGN-DATA" ECL_FUN("si_free_foreign_data", si_free_foreign_data, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "MAKE-FOREIGN-DATA-FROM-ARRAY" ECL_FUN("si_make_foreign_data_from_array", si_make_foreign_data_from_array, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "LOAD-FOREIGN-MODULE" ECL_FUN("si_load_foreign_module", si_load_foreign_module, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "UNLOAD-FOREIGN-MODULE" ECL_FUN("si_unload_foreign_module", si_unload_foreign_module, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "NULL-POINTER-P" ECL_FUN("si_null_pointer_p", si_null_pointer_p, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SIZE-OF-FOREIGN-ELT-TYPE" ECL_FUN("si_size_of_foreign_elt_type", si_size_of_foreign_elt_type, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "ALIGNMENT-OF-FOREIGN-ELT-TYPE" ECL_FUN("si_alignment_of_foreign_elt_type", si_alignment_of_foreign_elt_type, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{KEY_ "BYTE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "CHAR" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "CSFLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "CDFLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "CLFLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "CSTRING" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "DOUBLE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "FIXNUM" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INT8-T" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INT16-T" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INT32-T" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "INT64-T" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "LONG" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "LONG-DOUBLE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "LONG-LONG" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "POINTER-SELF" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "POINTER-VOID" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "SHORT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "STRUCT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UNION" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "VOID" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UINT8-T" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UINT16-T" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UINT32-T" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UINT64-T" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UNSIGNED-BYTE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UNSIGNED-CHAR" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UNSIGNED-INT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UNSIGNED-LONG" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UNSIGNED-LONG-LONG" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UNSIGNED-SHORT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},

#ifdef GBC_BOEHM
{EXT_ "GC" ECL_FUN("si_gc", si_gc, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{SYS_ "GC-DUMP" ECL_FUN("si_gc_dump", si_gc_dump, 0) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "GC-STATS" ECL_FUN("si_gc_stats", si_gc_stats, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
#endif
{EXT_ "TIMEOUT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
/* #ifdef ECL_THREADS */
{MP_ "PROCESS" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "LOCK" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "CONDITION-VARIABLE" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "*CURRENT-PROCESS*" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_SPECIAL, OBJNULL)},
{MP_ "ALL-PROCESSES" ECL_FUN("mp_all_processes", IF_MP(mp_all_processes), 0) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "EXIT-PROCESS" ECL_FUN("mp_exit_process", IF_MP(mp_exit_process), 0) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "MAKE-PROCESS" ECL_FUN("mp_make_process", IF_MP(mp_make_process), -1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "PROCESS-ACTIVE-P" ECL_FUN("mp_process_active_p", IF_MP(mp_process_active_p), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "PROCESS-ENABLE" ECL_FUN("mp_process_enable", IF_MP(mp_process_enable), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "PROCESS-YIELD" ECL_FUN("mp_process_yield", IF_MP(mp_process_yield), 0) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "PROCESS-KILL" ECL_FUN("mp_process_kill", IF_MP(mp_process_kill), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "PROCESS-NAME" ECL_FUN("mp_process_name", IF_MP(mp_process_name), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "PROCESS-PRESET" ECL_FUN("mp_process_preset", IF_MP(mp_process_preset), -3) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "PROCESS-RUN-FUNCTION" ECL_FUN("mp_process_run_function", IF_MP(mp_process_run_function), -3) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "PROCESS-WHOSTATE" ECL_FUN("mp_process_whostate", IF_MP(mp_process_whostate), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "PROCESS-JOIN" ECL_FUN("mp_process_join", IF_MP(mp_process_join), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "MAKE-LOCK" ECL_FUN("mp_make_lock", IF_MP(mp_make_lock), -1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{KEY_ "RECURSIVE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{MP_ "RECURSIVE-LOCK-P" ECL_FUN("mp_recursive_lock_p", IF_MP(mp_recursive_lock_p), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "HOLDING-LOCK-P" ECL_FUN("mp_holding_lock_p", IF_MP(mp_holding_lock_p), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "LOCK-NAME" ECL_FUN("mp_lock_name", IF_MP(mp_lock_name), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "LOCK-OWNER" ECL_FUN("mp_lock_owner", IF_MP(mp_lock_owner), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "LOCK-COUNT" ECL_FUN("mp_lock_count", IF_MP(mp_lock_count), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "GET-LOCK" ECL_FUN("mp_get_lock", IF_MP(mp_get_lock), -2) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "GIVEUP-LOCK" ECL_FUN("mp_giveup_lock", IF_MP(mp_giveup_lock), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{SYS_ "MUTEX-TIMEOUT" ECL_FUN("si_mutex_timeout", IF_MP(si_mutex_timeout), 3) ECL_VAR(SI_SPECIAL, OBJNULL)},
{MP_ "MAKE-CONDITION-VARIABLE" ECL_FUN("mp_make_condition_variable", IF_MP(mp_make_condition_variable), 0) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "CONDITION-VARIABLE-WAIT" ECL_FUN("mp_condition_variable_wait", IF_MP(mp_condition_variable_wait), 2) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "CONDITION-VARIABLE-TIMEDWAIT" ECL_FUN("mp_condition_variable_timedwait", IF_MP(mp_condition_variable_timedwait), 3) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "CONDITION-VARIABLE-SIGNAL" ECL_FUN("mp_condition_variable_signal", IF_MP(mp_condition_variable_signal), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "CONDITION-VARIABLE-BROADCAST" ECL_FUN("mp_condition_variable_broadcast", IF_MP(mp_condition_variable_broadcast), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{KEY_ "INITIAL-BINDINGS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{MP_ "INTERRUPT-PROCESS" ECL_FUN("mp_interrupt_process", IF_MP(mp_interrupt_process), 2) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "+LOAD-COMPILE-LOCK+" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_CONSTANT, OBJNULL)},
{MP_ "WITH-LOCK" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_CONSTANT, OBJNULL)},
{MP_ "WITH-RWLOCK" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_CONSTANT, OBJNULL)},
{MP_ "BLOCK-SIGNALS" ECL_FUN("mp_block_signals", IF_MP(mp_block_signals), 0) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "RESTORE-SIGNALS" ECL_FUN("mp_restore_signals", IF_MP(mp_restore_signals), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "PROCESS-SUSPEND" ECL_FUN("mp_process_suspend", IF_MP(mp_process_suspend), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "PROCESS-RESUME" ECL_FUN("mp_process_resume", IF_MP(mp_process_resume), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "SUSPEND-LOOP" ECL_FUN("mp_suspend_loop", IF_MP(mp_suspend_loop), 0) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "BREAK-SUSPEND-LOOP" ECL_FUN("mp_break_suspend_loop", IF_MP(mp_break_suspend_loop), 0) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "MAKE-RWLOCK" ECL_FUN("mp_make_rwlock", IF_MP(mp_make_rwlock), -1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "RWLOCK" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "RWLOCK-NAME" ECL_FUN("mp_rwlock_name", IF_MP(mp_rwlock_name), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "GET-RWLOCK-READ" ECL_FUN("mp_get_rwlock_read", IF_MP(mp_get_rwlock_read), -2) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "GET-RWLOCK-WRITE" ECL_FUN("mp_get_rwlock_write", IF_MP(mp_get_rwlock_write), -2) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "GIVEUP-RWLOCK-READ" ECL_FUN("mp_giveup_rwlock_read", IF_MP(mp_giveup_rwlock_read), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "GIVEUP-RWLOCK-WRITE" ECL_FUN("mp_giveup_rwlock_write", IF_MP(mp_giveup_rwlock_write), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "GLOBAL-LOCK" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "ERROR-LOCK" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_ORDINARY, OBJNULL)},

{MP_ "SEMAPHORE" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "MAKE-SEMAPHORE" ECL_FUN("mp_make_semaphore", IF_MP(mp_make_semaphore), -1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "SIGNAL-SEMAPHORE" ECL_FUN("mp_signal_semaphore", IF_MP(mp_signal_semaphore), -2) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "SEMAPHORE-WAIT" ECL_FUN("mp_semaphore_wait", IF_MP(mp_semaphore_wait), 3) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "WAIT-ON-SEMAPHORE" ECL_FUN("mp_wait_on_semaphore", IF_MP(mp_wait_on_semaphore), -2) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "TRY-GET-SEMAPHORE" ECL_FUN("mp_try_get_semaphore", IF_MP(mp_try_get_semaphore), -2) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "SEMAPHORE-COUNT" ECL_FUN("mp_semaphore_count", IF_MP(mp_semaphore_count), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "SEMAPHORE-NAME" ECL_FUN("mp_semaphore_name", IF_MP(mp_semaphore_name), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "SEMAPHORE-WAIT-COUNT" ECL_FUN("mp_semaphore_wait_count", IF_MP(mp_semaphore_wait_count), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{KEY_ "COUNT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "TIMEOUT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},

{MP_ "BARRIER" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "MAKE-BARRIER" ECL_FUN("mp_make_barrier", IF_MP(mp_make_barrier), -2) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "BARRIER-UNBLOCK" ECL_FUN("mp_barrier_unblock", IF_MP(mp_barrier_unblock), -2) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "BARRIER-WAIT" ECL_FUN("mp_barrier_wait", IF_MP(mp_barrier_wait), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "BARRIER-COUNT" ECL_FUN("mp_barrier_count", IF_MP(mp_barrier_count), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "BARRIER-NAME" ECL_FUN("mp_barrier_name", IF_MP(mp_barrier_name), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "BARRIER-ARRIVERS-COUNT" ECL_FUN("mp_barrier_arrivers_count", IF_MP(mp_barrier_arrivers_count), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{KEY_ "DISABLE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "RESET-COUNT" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "KILL-WAITING" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UNBLOCKED" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},

{MP_ "MAILBOX" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "MAKE-MAILBOX" ECL_FUN("mp_make_mailbox", IF_MP(mp_make_mailbox), -1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "MAILBOX-NAME" ECL_FUN("mp_mailbox_name", IF_MP(mp_mailbox_name), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "MAILBOX-COUNT" ECL_FUN("mp_mailbox_count", IF_MP(mp_mailbox_count), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "MAILBOX-EMPTY-P" ECL_FUN("mp_mailbox_empty_p", IF_MP(mp_mailbox_empty_p), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "MAILBOX-READ" ECL_FUN("mp_mailbox_read", IF_MP(mp_mailbox_read), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "MAILBOX-TRY-READ" ECL_FUN("mp_mailbox_try_read", IF_MP(mp_mailbox_try_read), 1) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "MAILBOX-SEND" ECL_FUN("mp_mailbox_send", IF_MP(mp_mailbox_send), 2) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "MAILBOX-TRY-SEND" ECL_FUN("mp_mailbox_try_send", IF_MP(mp_mailbox_try_send), 2) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "COMPARE-AND-SWAP-CAR" ECL_FUN("mp_compare_and_swap_car", IF_MP(mp_compare_and_swap_car), 3) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "COMPARE-AND-SWAP-CDR" ECL_FUN("mp_compare_and_swap_cdr", IF_MP(mp_compare_and_swap_cdr), 3) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "COMPARE-AND-SWAP-SYMBOL-PLIST" ECL_FUN("mp_compare_and_swap_symbol_plist", IF_MP(mp_compare_and_swap_symbol_plist), 3) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "COMPARE-AND-SWAP-SYMBOL-VALUE" ECL_FUN("mp_compare_and_swap_symbol_value", IF_MP(mp_compare_and_swap_symbol_value), 3) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "COMPARE-AND-SWAP-SVREF" ECL_FUN("mp_compare_and_swap_svref", IF_MP(mp_compare_and_swap_svref), 4) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "COMPARE-AND-SWAP-INSTANCE" ECL_FUN("mp_compare_and_swap_instance", IF_MP(mp_compare_and_swap_instance), 4) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "COMPARE-AND-SWAP-STRUCTURE" ECL_FUN("mp_compare_and_swap_structure", IF_MP(mp_compare_and_swap_structure), 5) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "ATOMIC-INCF-CAR" ECL_FUN("mp_atomic_incf_car", IF_MP(mp_atomic_incf_car), 2) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "ATOMIC-INCF-CDR" ECL_FUN("mp_atomic_incf_cdr", IF_MP(mp_atomic_incf_cdr), 2) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "ATOMIC-INCF-SYMBOL-VALUE" ECL_FUN("mp_atomic_incf_symbol_value", IF_MP(mp_atomic_incf_symbol_value), 2) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "ATOMIC-INCF-SVREF" ECL_FUN("mp_atomic_incf_svref", IF_MP(mp_atomic_incf_svref), 3) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "ATOMIC-INCF-INSTANCE" ECL_FUN("mp_atomic_incf_instance", IF_MP(mp_atomic_incf_instance), 3) ECL_VAR(MP_ORDINARY, OBJNULL)},
{MP_ "DEFINE-CAS-EXPANDER" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_CONSTANT, OBJNULL)},
{MP_ "DEFCAS" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_CONSTANT, OBJNULL)},
{MP_ "REMCAS" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_CONSTANT, OBJNULL)},
{MP_ "GET-CAS-EXPANSION" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_CONSTANT, OBJNULL)},
{MP_ "COMPARE-AND-SWAP" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_CONSTANT, OBJNULL)},
{MP_ "ATOMIC-UPDATE" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_CONSTANT, OBJNULL)},
{MP_ "ATOMIC-PUSH" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_CONSTANT, OBJNULL)},
{MP_ "ATOMIC-POP" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_CONSTANT, OBJNULL)},
{MP_ "ATOMIC-INCF" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_CONSTANT, OBJNULL)},
{MP_ "ATOMIC-DECF" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_CONSTANT, OBJNULL)},
/* #endif defined(ECL_THREADS) */

{SYS_ "WHILE" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "UNTIL" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "QUASIQUOTE" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "*EXIT-HOOKS*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ECL_NIL)},

{CLOS_ ".COMBINED-METHOD-ARGS." ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_SPECIAL, ECL_NIL)},
{CLOS_ "+BUILTIN-CLASSES+" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, ECL_NIL)},
{CLOS_ "*NEXT-METHODS*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_SPECIAL, ECL_NIL)},
{CLOS_ "*OPTIMIZE-SLOT-ACCESS*" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_SPECIAL, ECL_T)},
{CLOS_ "+THE-T-CLASS+" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, ECL_NIL)},
{CLOS_ "+THE-CLASS+" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, ECL_NIL)},
{CLOS_ "+THE-STD-CLASS+" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, ECL_NIL)},
{CLOS_ "+THE-STANDARD-CLASS+" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, ECL_NIL)},
{CLOS_ "+THE-FUNCALLABLE-STANDARD-CLASS+" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, ECL_NIL)},
{CLOS_ "ACCESSOR-METHOD-SLOT-DEFINITION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "ADD-DEPENDENT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "ADD-DIRECT-METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "ADD-DIRECT-SUBCLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "CLASS-DEFAULT-INITARGS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "CLASS-DIRECT-DEFAULT-INITARGS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "CLASS-DIRECT-SLOTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "CLASS-DIRECT-SUBCLASSES" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "CLASS-DIRECT-SUPERCLASSES" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "CLASS-FINALIZED-P" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "CLASS-PRECEDENCE-LIST" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "CLASS-PROTOTYPE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "CLASS-SLOTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "COMPUTE-APPLICABLE-METHODS-USING-CLASSES" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "COMPUTE-CLASS-PRECEDENCE-LIST" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "COMPUTE-DEFAULT-INITARGS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "COMPUTE-DISCRIMINATING-FUNCTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "COMPUTE-EFFECTIVE-METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "COMPUTE-EFFECTIVE-SLOT-DEFINITION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "COMPUTE-SLOTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "DIRECT-SLOT-DEFINITION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "DIRECT-SLOT-DEFINITION-CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "EFFECTIVE-SLOT-DEFINITION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "EFFECTIVE-SLOT-DEFINITION-CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "ENSURE-CLASS" ECL_FUN("clos_ensure_class", ECL_NAME(clos_ensure_class), -2) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "ENSURE-CLASS-USING-CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "ENSURE-GENERIC-FUNCTION-USING-CLASS" ECL_FUN(NULL, NULL, -3) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "EQL-SPECIALIZER" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "EQL-SPECIALIZER-OBJECT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "EXTRACT-LAMBDA-LIST" ECL_FUN("clos_extract_lambda_list", ECL_NAME(clos_extract_lambda_list), 1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "EXTRACT-SPECIALIZER-NAMES" ECL_FUN("clos_extract_specializer_names", ECL_NAME(clos_extract_specializer_names), 1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "FINALIZE-INHERITANCE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "FIND-METHOD-COMBINATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "FORWARD-REFERENCED-CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "FUNCALLABLE-STANDARD-CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "FUNCALLABLE-STANDARD-INSTANCE-ACCESS" ECL_FUN("clos_funcallable_standard_instance_access", ECL_NAME(clos_funcallable_standard_instance_access), 2) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "FUNCALLABLE-STANDARD-OBJECT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "GENERIC-FUNCTION-ARGUMENT-PRECEDENCE-ORDER" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "GENERIC-FUNCTION-DECLARATIONS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "GENERIC-FUNCTION-LAMBDA-LIST" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "GENERIC-FUNCTION-METHOD-CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "GENERIC-FUNCTION-METHOD-COMBINATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "GENERIC-FUNCTION-METHODS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "GENERIC-FUNCTION-NAME" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "INTERN-EQL-SPECIALIZER" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "LOCATION-TABLE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY | PRIVATE, OBJNULL)},
{CLOS_ "MAKE-METHOD-LAMBDA" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "MAP-DEPENDENTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "METAOBJECT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "METHOD-FUNCTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "METHOD-GENERIC-FUNCTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "METHOD-LAMBDA-LIST" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "METHOD-SPECIALIZERS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "NAME" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY | PRIVATE, OBJNULL)},
{CLOS_ "READER-METHOD-CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "REMOVE-DEPENDENT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "REMOVE-DIRECT-METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "REMOVE-DIRECT-SUBCLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SET-FUNCALLABLE-INSTANCE-FUNCTION" ECL_FUN("clos_set_funcallable_instance_function", clos_set_funcallable_instance_function, 2) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SLOT-BOUNDP-USING-CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SLOT-DEFINITION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SLOT-DEFINITION-ALLOCATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SLOT-DEFINITION-INITARGS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SLOT-DEFINITION-INITFORM" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SLOT-DEFINITION-INITFUNCTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SLOT-DEFINITION-LOCATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SLOT-DEFINITION-NAME" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SLOT-DEFINITION-READERS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SLOT-DEFINITION-TYPE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SLOT-DEFINITION-WRITERS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SLOT-MAKUNBOUND-USING-CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SLOT-VALUE-USING-CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SLOT-VALUE-SET" ECL_FUN("clos_slot_value_set", clos_slot_value_set, 3) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SLOT-TABLE" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SPECIALIZER" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SPECIALIZER-DIRECT-GENERIC-FUNCTIONS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SPECIALIZER-DIRECT-METHODS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "STANDARD-ACCESSOR-METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "STANDARD-DIRECT-SLOT-DEFINITION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "STANDARD-EFFECTIVE-SLOT-DEFINITION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "STANDARD-INSTANCE-ACCESS" ECL_FUN("clos_standard_instance_access", ECL_NAME(clos_standard_instance_access), 2) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "STANDARD-INSTANCE-SET" ECL_FUN("clos_standard_instance_set", ECL_NAME(clos_standard_instance_set), 3) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "STANDARD-READER-METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "STANDARD-SLOT-DEFINITION" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "STANDARD-WRITER-METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "STANDARD-OPTIMIZED-READER-METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "STANDARD-OPTIMIZED-WRITER-METHOD" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "STD-COMPUTE-APPLICABLE-METHODS" ECL_FUN("clos_std_compute_applicable_methods", ECL_NAME(clos_std_compute_applicable_methods), 2) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "STD-COMPUTE-APPLICABLE-METHODS-USING-CLASSES" ECL_FUN(NULL, NULL, 2) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "STD-COMPUTE-EFFECTIVE-METHOD" ECL_FUN("clos_std_compute_effective_method", ECL_NAME(clos_std_compute_effective_method), 3) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "COMPUTE-EFFECTIVE-METHOD-FUNCTION" ECL_FUN("clos_compute_effective_method_function", ECL_NAME(clos_compute_effective_method_function), 3) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "UPDATE-DEPENDENT" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "UPDATE-INSTANCE" ECL_FUN(NULL, NULL, 1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "VALIDATE-SUPERCLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "WRITER-METHOD-CLASS" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{SYS_ "CLEAR-GFUN-HASH" ECL_FUN("si_clear_gfun_hash", si_clear_gfun_hash, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{CLOS_ "LOAD-DEFCLASS" ECL_FUN("clos_load_defclass", ECL_NAME(clos_load_defclass), 4) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "DOCSTRING" ECL_FUN(NULL, NULL, -1) ECL_VAR(CLOS_ORDINARY, OBJNULL)},
{CLOS_ "SAFE-INSTANCE-REF" ECL_FUN("clos_safe_instance_ref", clos_safe_instance_ref, 2) ECL_VAR(CLOS_ORDINARY, OBJNULL)},

{SYS_ "CL-FIXNUM-BITS" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_CONSTANT, ecl_make_fixnum(ECL_FIXNUM_BITS))},
{EXT_ "CL-FIXNUM" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, NULL)},
{EXT_ "CL-INDEX" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, NULL)},

{SYS_ "DO-DEFTYPE" ECL_FUN("si_do_deftype", ECL_NAME(si_do_deftype), -4) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "CREATE-TYPE-NAME" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "*ALIEN-DECLARATIONS*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ECL_NIL)},

#ifdef ENABLE_DLOPEN
{SYS_ "LOAD-BINARY" ECL_FUN("si_load_binary", si_load_binary, 4) ECL_VAR(SI_ORDINARY, OBJNULL)},
#else
{SYS_ "LOAD-BINARY" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
#endif

{SYS_ "*CODE-WALKER*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, OBJNULL)},

/* #if defined(HAVE_LIBFFI) */
{SYS_ "CALL-CFUN" ECL_FUN("si_call_cfun", IF_DFFI(si_call_cfun), -5) ECL_VAR(SI_ORDINARY, OBJNULL)},
{KEY_ "CALLBACK" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{SYS_ "MAKE-DYNAMIC-CALLBACK" ECL_FUN("si_make_dynamic_callback", IF_DFFI(si_make_dynamic_callback), -5) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FREE-FFI-CLOSURE" ECL_FUN("si_free_ffi_closure", IF_DFFI(si_free_ffi_closure), 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
/* #endif defined(HAVE_LIBFFI) */

{EXT_ "TRAP-FPE" ECL_FUN("si_trap_fpe", si_trap_fpe, 2) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "*ACTION-ON-UNDEFINED-VARIABLE*" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_SPECIAL, ECL_NIL)},

{SYS_ "WINDOWS-CODEPAGE-ENCODING" ECL_FUN("si_windows_codepage_encoding", IF_WINDOWS(si_windows_codepage_encoding), 0) ECL_VAR(SI_ORDINARY, OBJNULL)},

{EXT_ "SET-BUFFERING-MODE" ECL_FUN("si_set_buffering_mode", si_set_buffering_mode, 2) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{KEY_ "NONE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "LINE-BUFFERED" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "FULLY-BUFFERED" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "LINE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "FULL" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},

{SYS_ "CMP-ENV-REGISTER-MACROLET" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},

{EXT_ "GET-FINALIZER" ECL_FUN("si_get_finalizer", si_get_finalizer, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "SET-FINALIZER" ECL_FUN("si_set_finalizer", si_set_finalizer, 2) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{SYS_ "WRONG-TYPE-ARGUMENT" ECL_FUN("si_wrong_type_argument", si_wrong_type_argument, -3) ECL_VAR(SI_ORDINARY, OBJNULL)},

{SYS_ "*CURRENT-FORM*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, OBJNULL)},

{SYS_ "CODE-BLOCK" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},

{SYS_ "FRAME" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "APPLY-FROM-STACK-FRAME" ECL_FUN("si_apply_from_stack_frame", si_apply_from_stack_frame, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},

#ifdef ECL_CLOS_STREAMS
{GRAY_ "PATHNAME" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "TRUENAME" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "CLOSE" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAMP" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "INPUT-STREAM-P" ECL_FUN(NULL, NULL, 1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "OUTPUT-STREAM-P" ECL_FUN(NULL, NULL, 1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "OPEN-STREAM-P" ECL_FUN(NULL, NULL, 1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-ADVANCE-TO-COLUMN" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-CLEAR-INPUT" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-CLEAR-OUTPUT" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-ELEMENT-TYPE" ECL_FUN(NULL, NULL, 1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-FILE-DESCRIPTOR" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-FILE-LENGTH" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-FILE-POSITION" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-FILE-STRING-LENGTH" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-FINISH-OUTPUT" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-FORCE-OUTPUT" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-FRESH-LINE" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-INTERACTIVE-P" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-LINE-COLUMN" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-LINE-LENGTH" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-LISTEN" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-PEEK-CHAR" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-READ-BYTE" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-READ-CHAR" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-READ-CHAR-NO-HANG" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-READ-LINE" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-READ-SEQUENCE" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-START-LINE-P" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-TERPRI" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-UNREAD-CHAR" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-WRITE-BYTE" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-WRITE-CHAR" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-WRITE-SEQUENCE" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "STREAM-WRITE-STRING" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "FUNDAMENTAL-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "FUNDAMENTAL-INPUT-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "FUNDAMENTAL-OUTPUT-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "FUNDAMENTAL-CHARACTER-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "FUNDAMENTAL-BINARY-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "FUNDAMENTAL-CHARACTER-INPUT-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "FUNDAMENTAL-CHARACTER-OUTPUT-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "FUNDAMENTAL-BINARY-INPUT-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
{GRAY_ "FUNDAMENTAL-BINARY-OUTPUT-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(GRAY_ORDINARY, OBJNULL)},
#endif /* ECL_CLOS_STREAMS */

{SYS_ "LOG1P" ECL_FUN("si_log1p", si_log1p, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},

{EXT_ "BC-FILE" ECL_FUN("si_compiled_function_file", si_compiled_function_file, 1) ECL_VAR(EXT_ORDINARY, ECL_NIL)},
{EXT_ "COMPILED-FUNCTION-FILE" ECL_FUN("si_compiled_function_file", si_compiled_function_file, 1) ECL_VAR(EXT_ORDINARY, ECL_NIL)},

{SYS_ "PROPERTY-LIST" ECL_FUN(NULL, NULL, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},

{SYS_ "BYTECODES" ECL_FUN(NULL, NULL, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},

{SYS_ "HASH-EQL" ECL_FUN("si_hash_eql", si_hash_eql, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "HASH-EQUAL" ECL_FUN("si_hash_equal", si_hash_equal, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "HASH-EQUALP" ECL_FUN("si_hash_equalp", si_hash_equalp, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},

{EXT_ "INTERACTIVE-INTERRUPT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "STORAGE-EXHAUSTED" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "STACK-OVERFLOW" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "STACK-OVERFLOW-SIZE" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "STACK-OVERFLOW-TYPE" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "BINDING-STACK" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "FRAME-STACK" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "LISP-STACK" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "C-STACK" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "HEAP-SIZE" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "ILLEGAL-INSTRUCTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "SET-LIMIT" ECL_FUN("si_set_limit", si_set_limit, 2) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "GET-LIMIT" ECL_FUN("si_get_limit", si_get_limit, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{SYS_ "RESET-MARGIN" ECL_FUN("si_reset_margin", si_reset_margin, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "SEGMENTATION-VIOLATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "EXTENDED-STRING" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{SYS_ "CHECK-PENDING-INTERRUPTS" ECL_FUN("si_check_pending_interrupts", si_check_pending_interrupts, 0) ECL_VAR(SI_ORDINARY, OBJNULL)},

{KEY_ "LATIN-1" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "ISO-8859-1" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UTF-8" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UCS-2" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UCS-4" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},

{EXT_ "CONSTANTLY-T" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "CONSTANTLY-NIL" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "MAYBE-QUOTE" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "MAYBE-UNQUOTE" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{KEY_ "CR" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "LF" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "CRLF" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},

{KEY_ "UCS-2BE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UCS-4BE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UCS-2LE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UCS-4LE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},

{EXT_ "LOAD-ENCODING" ECL_FUN("si_load_encoding", ECL_NAME(si_load_encoding), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "MAKE-ENCODING" ECL_FUN("si_make_encoding", ECL_NAME(si_make_encoding), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "ALL-ENCODINGS" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{KEY_ "US-ASCII" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "LITTLE-ENDIAN" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "BIG-ENDIAN" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},

{SYS_ "+UNICODE-DATABASE+" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_CONSTANT, ECL_NIL)},

{EXT_ "COPY-FILE" ECL_FUN("si_copy_file", si_copy_file, 2) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "FILL-ARRAY-WITH-ELT" ECL_FUN("si_fill_array_with_elt", si_fill_array_with_elt, 4) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "+ECL-VERSION-NUMBER+" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_CONSTANT, ecl_make_fixnum(ECL_VERSION_NUMBER))},

{EXT_ "*BYTECODES-COMPILER*" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_SPECIAL, ECL_NIL)},

#ifdef ECL_IEEE_FP
{SYS_ "NAN" ECL_FUN("si_nan", si_nan, 0) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "SHORT-FLOAT-POSITIVE-INFINITY" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_CONSTANT, OBJNULL)},
{EXT_ "SINGLE-FLOAT-POSITIVE-INFINITY" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_CONSTANT, OBJNULL)},
{EXT_ "DOUBLE-FLOAT-POSITIVE-INFINITY" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_CONSTANT, OBJNULL)},
{EXT_ "LONG-FLOAT-POSITIVE-INFINITY" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_CONSTANT, OBJNULL)},

{EXT_ "SHORT-FLOAT-NEGATIVE-INFINITY" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_CONSTANT, OBJNULL)},
{EXT_ "SINGLE-FLOAT-NEGATIVE-INFINITY" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_CONSTANT, OBJNULL)},
{EXT_ "DOUBLE-FLOAT-NEGATIVE-INFINITY" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_CONSTANT, OBJNULL)},
{EXT_ "LONG-FLOAT-NEGATIVE-INFINITY" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_CONSTANT, OBJNULL)},
#endif /* ECL_IEEE_FP */

{EXT_ "FLOAT-NAN-P" ECL_FUN("si_float_nan_p", si_float_nan_p, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "FLOAT-INFINITY-P" ECL_FUN("si_float_infinity_p", si_float_infinity_p, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "FLOAT-NAN-STRING" ECL_FUN(NULL, NULL, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "FLOAT-INFINITY-STRING" ECL_FUN(NULL, NULL, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{SYS_ "SINGLE-FLOAT-BITS" ECL_FUN(NULL, NULL, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "BITS-SINGLE-FLOAT" ECL_FUN(NULL, NULL, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "DOUBLE-FLOAT-BITS" ECL_FUN(NULL, NULL, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "BITS-DOUBLE-FLOAT" ECL_FUN(NULL, NULL, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "LONG-FLOAT-BITS" ECL_FUN(NULL, NULL, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "BITS-LONG-FLOAT" ECL_FUN(NULL, NULL, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},

{SYS_ "READ-OBJECT-OR-IGNORE" ECL_FUN("si_read_object_or_ignore", si_read_object_or_ignore, 2) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "READTABLE-LOCK" ECL_FUN("si_readtable_lock", si_readtable_lock, -2) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{SYS_ "+IO-SYNTAX-PROGV-LIST+" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_CONSTANT, OBJNULL)},
{SYS_ "+ECL-SYNTAX-PROGV-LIST+" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_CONSTANT, OBJNULL)},
{SYS_ "WITH-ECL-IO-SYNTAX" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},

{SYS_ "STREAM-EXTERNAL-FORMAT-SET" ECL_FUN("si_stream_external_format_set", si_stream_external_format_set, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},

{KEY_ "CDECL" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "EABI" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "GNUW64" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "STDCALL" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "SYSV" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UNIX" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "UNIX64" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "VFP" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "WIN64" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},

{EXT_ "WEAK-POINTER" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "MAKE-WEAK-POINTER" ECL_FUN("si_make_weak_pointer", si_make_weak_pointer, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "WEAK-POINTER-VALUE" ECL_FUN("si_weak_pointer_value", si_weak_pointer_value, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{SYS_ "*ALLOW-WITH-INTERRUPTS*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ECL_T)},

/* conveniance macros from CMU util */
{EXT_ "ONCE-ONLY" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "COLLECT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "WITH-UNIQUE-NAMES" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "WITH-GENSYMS" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "WITH-CLEAN-SYMBOLS" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "IF-LET" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "WHEN-LET" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "WHEN-LET*" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{SYS_ "HANDLE-SIGNAL" ECL_FUN("si_handle_signal", si_handle_signal, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},

{EXT_ "WITH-INTERRUPTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_CONSTANT, OBJNULL)},
{EXT_ "WITHOUT-INTERRUPTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_CONSTANT, OBJNULL)},
{EXT_ "WITH-RESTORED-INTERRUPTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_CONSTANT, OBJNULL)},
{EXT_ "WITH-LOCAL-INTERRUPTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_CONSTANT, OBJNULL)},
{EXT_ "ALLOW-WITH-INTERRUPTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(MP_CONSTANT, OBJNULL)},

{SYS_ "*QUIT-TAG*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, OBJNULL)},

{EXT_ "ARRAY-RAW-DATA" ECL_FUN("si_array_raw_data", si_array_raw_data, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "*PROGRAM-EXIT-CODE*" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_SPECIAL, ecl_make_fixnum(0))},
{EXT_ "EXIT" ECL_FUN("si_exit", si_exit, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "ENVIRON" ECL_FUN("si_environ", si_environ, 0) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{KEY_ "ENVIRON" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},

/* external-process extension */
{EXT_ "RUN-PROGRAM" ECL_FUN("si_run_program", ECL_NAME(si_run_program), -3) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "MAKE-EXTERNAL-PROCESS" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "EXTERNAL-PROCESS" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "EXTERNAL-PROCESS-PID" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "EXTERNAL-PROCESS-INPUT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "EXTERNAL-PROCESS-OUTPUT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "EXTERNAL-PROCESS-ERROR-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "EXTERNAL-PROCESS-STATUS" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "EXTERNAL-PROCESS-WAIT" ECL_FUN(NULL, NULL, -2) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "TERMINATE-PROCESS" ECL_FUN("si_terminate_process", ECL_NAME(si_terminate_process), -2) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{KEY_ "RUNNING" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "EXITED" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "SIGNALED" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "STOPPED" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "RESUMED" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
/* ~ external-process extension */

/* unixsys.d */
{SYS_ "WAITPID" ECL_FUN("si_waitpid", si_waitpid, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
#if !defined(ECL_MS_WINDOWS_HOST)
{SYS_ "KILLPID" ECL_FUN("si_killpid", si_killpid, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
#else
{SYS_ "KILLPID" ECL_FUN(NULL, NULL, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
#endif
{SYS_ "RUN-PROGRAM-INNER" ECL_FUN("si_run_program_inner", si_run_program_inner, 4) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SPAWN-SUBPROCESS" ECL_FUN("si_spawn_subprocess", si_spawn_subprocess, 6) ECL_VAR(SI_ORDINARY, OBJNULL)},
/* ~ */

{EXT_ "*INVOKE-DEBUGGER-HOOK*" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_SPECIAL, ECL_NIL)},

{EXT_ "*DOCUMENTATION-POOL*" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_SPECIAL, ECL_NIL)},
{EXT_ "ANNOTATE" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, ECL_NIL)},
{EXT_ "GET-ANNOTATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, ECL_NIL)},
{EXT_ "REMOVE-ANNOTATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, ECL_NIL)},
{EXT_ "FUNCTION-LAMBDA-LIST" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, ECL_NIL)},
{EXT_ "DEFAULT-ANNOTATION-LOGIC" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, ECL_NIL)},
{EXT_ "OPTIONAL-ANNOTATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, ECL_NIL)},
{EXT_ "LOCATION" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, ECL_NIL)},

{EXT_ "LISP-IMPLEMENTATION-VCS-ID" ECL_FUN("si_lisp_implementation_vcs_id", ECL_NAME(si_lisp_implementation_vcs_id), 0) ECL_VAR(EXT_ORDINARY, ECL_NIL)},

{SYS_ "SIGNAL-SERVICING" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, ECL_NIL)},

{EXT_ "*DEFAULT-EXTERNAL-FORMAT*" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_SPECIAL, ECL_T)},
{KEY_ "PASS-THROUGH" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},

{EXT_ "WITH-BACKEND" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{KEY_ "BYTECODES" ECL_FUN(NULL, NULL, 1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "C/C++" ECL_FUN(NULL, NULL, 1) ECL_VAR(KEYWORD, OBJNULL)},

{EXT_ "ARRAY-INDEX" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "ANSI-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "VIRTUAL-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "COMPLEX-ARRAY" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{SYS_ "SEQUENCE-START-END" ECL_FUN("si_sequence_start_end", si_sequence_start_end, 4) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SEQUENCE-COUNT" ECL_FUN("si_sequence_count", ECL_NAME(si_sequence_count), 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SHRINK-VECTOR" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "COPY-SUBARRAY" ECL_FUN("si_copy_subarray", si_copy_subarray, 5) ECL_VAR(SI_ORDINARY, OBJNULL)},

{SYS_ "CONS-CAR" ECL_FUN("cl_car", cl_car, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "CONS-CDR" ECL_FUN("cl_cdr", cl_cdr, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},

{EXT_ "COMPILER-TYPECASE" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{SYS_ "ASSERT-FAILURE" ECL_FUN("si_assert_failure", ECL_NAME(si_assert_failure), -2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "CCASE-ERROR" ECL_FUN("si_ccase_error", ECL_NAME(si_ccase_error), 3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "ECASE-ERROR" ECL_FUN("si_ecase_error", ECL_NAME(si_ecase_error), 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "ETYPECASE-ERROR" ECL_FUN("si_etypecase_error", ECL_NAME(si_etypecase_error), 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "CTYPECASE-ERROR" ECL_FUN("si_ctypecase_error", ECL_NAME(si_ctypecase_error), 3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "DO-CHECK-TYPE" ECL_FUN("si_do_check_type", ECL_NAME(si_do_check_type), 4) ECL_VAR(SI_ORDINARY, OBJNULL)},

/* #ifdef ECL_EXTERNALIZABLE */
{SYS_ "SERIALIZE" ECL_FUN("si_serialize", IF_EXTERNALIZABLE(si_serialize), 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "DESERIALIZE" ECL_FUN("si_deserialize", IF_EXTERNALIZABLE(si_deserialize), 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
/* #endif */

{EXT_ "ARRAY-ELEMENT-TYPE-BYTE-SIZE" ECL_FUN("si_array_element_type_byte_size", si_array_element_type_byte_size, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

/* #ifdef ECL_COMPLEX_FLOAT */
{SYS_ "COMPLEX-FLOAT-P" ECL_FUN("si_complex_float_p", IF_COMPLEX_FLOAT(si_complex_float_p), 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "COMPLEX-FLOAT" ECL_FUN("si_complex_float", IF_COMPLEX_FLOAT(si_complex_float), 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "COMPLEX-SINGLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "COMPLEX-DOUBLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "COMPLEX-LONG-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
/* #endif */

/* #ifdef ECL_SSE2 */
{EXT_ "SSE-PACK" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "SSE-PACK-P" ECL_FUN("si_sse_pack_p", IF_SSE2(si_sse_pack_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "SSE-PACK-AS-ELT-TYPE" ECL_FUN("si_sse_pack_as_elt_type", IF_SSE2(si_sse_pack_as_elt_type), 2) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "VECTOR-TO-SSE-PACK" ECL_FUN("si_vector_to_sse_pack", IF_SSE2(si_vector_to_sse_pack), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "SSE-PACK-TO-VECTOR" ECL_FUN("si_sse_pack_to_vector", IF_SSE2(si_sse_pack_to_vector), 2) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "INT-SSE-PACK" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "FLOAT-SSE-PACK" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "DOUBLE-SSE-PACK" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "SSE-PACK-ELEMENT-TYPE" ECL_FUN("si_sse_pack_element_type", IF_SSE2(si_sse_pack_element_type), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "*SSE-PACK-PRINT-MODE*" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_SPECIAL, ECL_NIL)},
/* #endif ECL_SSE2 */

{EXT_ "UNIX-SIGNAL-RECEIVED" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "UNIX-SIGNAL-RECEIVED-CODE" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{KEY_ "CODE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},

{SYS_ "FLOAT-TO-DIGITS" ECL_FUN("si_float_to_digits", si_float_to_digits, 4) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "FLOAT-TO-STRING-FREE" ECL_FUN("si_float_to_string_free", si_float_to_string_free, 4) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "INTEGER-TO-STRING" ECL_FUN("si_integer_to_string", si_integer_to_string, 5) ECL_VAR(SI_ORDINARY, OBJNULL)},

{SYS_ "PRINT-UNREADABLE-OBJECT-FUNCTION" ECL_FUN("si_print_unreadable_object_function", si_print_unreadable_object_function, 5) ECL_VAR(SI_ORDINARY, OBJNULL)},

{EXT_ "DUMP-C-BACKTRACE" ECL_FUN("si_dump_c_backtrace", si_dump_c_backtrace, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "+PROCESS-STANDARD-INPUT+" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_CONSTANT, ECL_NIL)},
{EXT_ "+PROCESS-STANDARD-OUTPUT+" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_CONSTANT, ECL_NIL)},
{EXT_ "+PROCESS-ERROR-OUTPUT+" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_CONSTANT, ECL_NIL)},

{EXT_ "*HELP-MESSAGE*" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_SPECIAL, ECL_NIL)},
{EXT_ "*LISP-INIT-FILE-LIST*" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_SPECIAL, ECL_NIL)},
{EXT_ "+DEFAULT-COMMAND-ARG-RULES+" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "COMMAND-ARGS" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "*COMMAND-ARGS*" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_SPECIAL, ECL_NIL)},
{EXT_ "PROCESS-COMMAND-ARGS" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "*UNPROCESSED-ECL-COMMAND-ARGS*" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_SPECIAL, ECL_NIL)},

/* #ifdef ECL_UNICODE */
{KEY_ "OCTETS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{EXT_ "CHARACTER-CODING-ERROR" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "CHARACTER-CODING-ERROR-EXTERNAL-FORMAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "CHARACTER-ENCODING-ERROR" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "CHARACTER-ENCODING-ERROR-CODE" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "CHARACTER-DECODING-ERROR" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "CHARACTER-DECODING-ERROR-OCTETS" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "STREAM-DECODING-ERROR" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "STREAM-ENCODING-ERROR" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "DECODING-ERROR" ECL_FUN(NULL, NULL, 3) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "ENCODING-ERROR" ECL_FUN(NULL, NULL, 3) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "OCTETS-TO-STRING" ECL_FUN("si_octets_to_string", si_octets_to_string, -2) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "STRING-TO-OCTETS" ECL_FUN("si_string_to_octets", si_string_to_octets, -2) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{KEY_ "NULL-TERMINATE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
/* #endif ECL_UNICODE */

{SYS_ "PROPER-LIST-P" ECL_FUN("si_proper_list_p", si_proper_list_p, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "TRACED-OLD-DEFINITION" ECL_FUN("si_traced_old_definition", ECL_NAME(si_traced_old_definition), 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "*TRACE-LIST*" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_SPECIAL, ECL_NIL)},

{SYS_ "FUNCTION-BOUNDARY" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "UNWIND-PROTECT-BOUNDARY" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},

{EXT_ "*INSPECTOR-HOOK*" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_SPECIAL, ECL_NIL)},

{KEY_ "RESOLVE-SYMLINKS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},

{SYS_ "LOAD-BYTECODES" ECL_FUN("si_load_bytecodes", si_load_bytecodes, 4) ECL_VAR(SI_ORDINARY, OBJNULL)},

{KEY_ "SHARED" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "PRIVATE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},

{EXT_ "MMAP" ECL_FUN("si_mmap", si_mmap, -2) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "MUNMAP" ECL_FUN("si_munmap", si_munmap, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "MMAP-ARRAY" ECL_FUN("si_mmap_array", si_mmap_array, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{SYS_ "GET-CDATA" ECL_FUN("si_get_cdata", si_get_cdata, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "ADD-CDATA" ECL_FUN("si_add_cdata", si_add_cdata, 2) ECL_VAR(SI_ORDINARY, OBJNULL)},

/*
 * CDR-5 http://cdr.eurolisp.org/document/5/extra-num-types.html
 */

{EXT_ "NEGATIVE-FIXNUM" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-FIXNUM" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-FIXNUM" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-FIXNUM" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NEGATIVE-FIXNUM-P" ECL_FUN("si_negative_fixnum_p", ECL_NAME(si_negative_fixnum_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-FIXNUM-P" ECL_FUN("si_positive_fixnum_p", ECL_NAME(si_positive_fixnum_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-FIXNUM-P" ECL_FUN("si_non_negative_fixnum_p", ECL_NAME(si_non_negative_fixnum_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-FIXNUM-P" ECL_FUN("si_non_positive_fixnum_p", ECL_NAME(si_non_positive_fixnum_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "NEGATIVE-INTEGER" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-INTEGER" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-INTEGER" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-INTEGER" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NEGATIVE-INTEGER-P" ECL_FUN("si_negative_integer_p", ECL_NAME(si_negative_integer_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-INTEGER-P" ECL_FUN("si_positive_integer_p", ECL_NAME(si_positive_integer_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-INTEGER-P" ECL_FUN("si_non_negative_integer_p", ECL_NAME(si_non_negative_integer_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-INTEGER-P" ECL_FUN("si_non_positive_integer_p", ECL_NAME(si_non_positive_integer_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "NEGATIVE-RATIONAL" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-RATIONAL" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-RATIONAL" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-RATIONAL" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NEGATIVE-RATIONAL-P" ECL_FUN("si_negative_rational_p", ECL_NAME(si_negative_rational_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-RATIONAL-P" ECL_FUN("si_positive_rational_p", ECL_NAME(si_positive_rational_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-RATIONAL-P" ECL_FUN("si_non_negative_rational_p", ECL_NAME(si_non_negative_rational_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-RATIONAL-P" ECL_FUN("si_non_positive_rational_p", ECL_NAME(si_non_positive_rational_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "NEGATIVE-RATIO" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-RATIO" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-RATIO" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-RATIO" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NEGATIVE-RATIO-P" ECL_FUN("si_negative_ratio_p", ECL_NAME(si_negative_ratio_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-RATIO-P" ECL_FUN("si_positive_ratio_p", ECL_NAME(si_positive_ratio_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-RATIO-P" ECL_FUN("si_non_negative_ratio_p", ECL_NAME(si_non_negative_ratio_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-RATIO-P" ECL_FUN("si_non_positive_ratio_p", ECL_NAME(si_non_positive_ratio_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "NEGATIVE-REAL" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-REAL" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-REAL" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-REAL" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NEGATIVE-REAL-P" ECL_FUN("si_negative_real_p", ECL_NAME(si_negative_real_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-REAL-P" ECL_FUN("si_positive_real_p", ECL_NAME(si_positive_real_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-REAL-P" ECL_FUN("si_non_negative_real_p", ECL_NAME(si_non_negative_real_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-REAL-P" ECL_FUN("si_non_positive_real_p", ECL_NAME(si_non_positive_real_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "NEGATIVE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NEGATIVE-FLOAT-P" ECL_FUN("si_negative_float_p", ECL_NAME(si_negative_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-FLOAT-P" ECL_FUN("si_positive_float_p", ECL_NAME(si_positive_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-FLOAT-P" ECL_FUN("si_non_negative_float_p", ECL_NAME(si_non_negative_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-FLOAT-P" ECL_FUN("si_non_positive_float_p", ECL_NAME(si_non_positive_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "NEGATIVE-SHORT-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-SHORT-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-SHORT-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-SHORT-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NEGATIVE-SHORT-FLOAT-P" ECL_FUN("si_negative_short_float_p", ECL_NAME(si_negative_short_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-SHORT-FLOAT-P" ECL_FUN("si_positive_short_float_p", ECL_NAME(si_positive_short_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-SHORT-FLOAT-P" ECL_FUN("si_non_negative_short_float_p", ECL_NAME(si_non_negative_short_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-SHORT-FLOAT-P" ECL_FUN("si_non_positive_short_float_p", ECL_NAME(si_non_positive_short_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "NEGATIVE-SINGLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-SINGLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-SINGLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-SINGLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NEGATIVE-SINGLE-FLOAT-P" ECL_FUN("si_negative_single_float_p", ECL_NAME(si_negative_single_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-SINGLE-FLOAT-P" ECL_FUN("si_positive_single_float_p", ECL_NAME(si_positive_single_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-SINGLE-FLOAT-P" ECL_FUN("si_non_negative_single_float_p", ECL_NAME(si_non_negative_single_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-SINGLE-FLOAT-P" ECL_FUN("si_non_positive_single_float_p", ECL_NAME(si_non_positive_single_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "NEGATIVE-DOUBLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-DOUBLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-DOUBLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-DOUBLE-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NEGATIVE-DOUBLE-FLOAT-P" ECL_FUN("si_negative_double_float_p", ECL_NAME(si_negative_double_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-DOUBLE-FLOAT-P" ECL_FUN("si_positive_double_float_p", ECL_NAME(si_positive_double_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-DOUBLE-FLOAT-P" ECL_FUN("si_non_negative_double_float_p", ECL_NAME(si_non_negative_double_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-DOUBLE-FLOAT-P" ECL_FUN("si_non_positive_double_float_p", ECL_NAME(si_non_positive_double_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "NEGATIVE-LONG-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-LONG-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-LONG-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-LONG-FLOAT" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NEGATIVE-LONG-FLOAT-P" ECL_FUN("si_negative_long_float_p", ECL_NAME(si_negative_long_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "POSITIVE-LONG-FLOAT-P" ECL_FUN("si_positive_long_float_p", ECL_NAME(si_positive_long_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-NEGATIVE-LONG-FLOAT-P" ECL_FUN("si_non_negative_long_float_p", ECL_NAME(si_non_negative_long_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "NON-POSITIVE-LONG-FLOAT-P" ECL_FUN("si_non_positive_long_float_p", ECL_NAME(si_non_positive_long_float_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "ARRAY-INDEX-P" ECL_FUN("si_array_index_p", ECL_NAME(si_array_index_p), 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "SEQUENCE-STREAM" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "MAKE-SEQUENCE-INPUT-STREAM" ECL_FUN("si_make_sequence_input_stream", si_make_sequence_input_stream, -2) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "MAKE-SEQUENCE-OUTPUT-STREAM" ECL_FUN("si_make_sequence_output_stream", si_make_sequence_output_stream, -2) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "CHMOD" ECL_FUN("si_chmod", si_chmod, 2) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{SYS_ "MISSING-KEYWORD" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},

{EXT_ "HASH-TABLE-CONTENT" ECL_FUN("si_hash_table_content", si_hash_table_content, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "HASH-TABLE-FILL" ECL_FUN("si_hash_table_fill", si_hash_table_fill, 2) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "RANDOM-STATE-ARRAY" ECL_FUN("si_random_state_array", si_random_state_array, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{SYS_ "REPORT-FUNCTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(SI_ORDINARY, OBJNULL)},

{SYS_ "DO-DEFSETF" ECL_FUN("si_do_defsetf", ECL_NAME(si_do_defsetf), -3) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "DO-DEFINE-SETF-METHOD" ECL_FUN("si_do_define_setf_method", ECL_NAME(si_do_define_setf_method), 2) ECL_VAR(SI_ORDINARY, OBJNULL)},

{SYS_ "SETF-DEFINITION" ECL_FUN("si_setf_definition", ECL_NAME(si_setf_definition), 2) ECL_VAR(SI_ORDINARY, OBJNULL)},

{EXT_ "ASSUME-NO-ERRORS" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "ASSUME-RIGHT-TYPE" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "TYPE-ASSERTIONS" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "CHECK-STACK-OVERFLOW" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "CHECK-ARGUMENTS-TYPE" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "ARRAY-BOUNDS-CHECK" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "GLOBAL-VAR-CHECKING" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "GLOBAL-FUNCTION-CHECKING" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "CHECK-NARGS" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "THE-IS-CHECKED" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "ASSUME-TYPES-DONT-CHANGE" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "INLINE-SLOT-ACCESS" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "INLINE-ACCESSORS" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "INLINE-BIT-OPERATIONS" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "OPEN-CODE-AREF/ASET" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "EVALUATE-FORMS" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "USE-DIRECT-C-CALL" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "INLINE-TYPE-CHECKS" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "INLINE-SEQUENCE-FUNCTIONS" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "DEBUG-VARIABLE-BINDINGS" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "DEBUG-IHS-FRAME" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{KEY_ "VALUE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "KEY-AND-VALUE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "KEY-OR-VALUE" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{KEY_ "WEAKNESS" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{EXT_ "HASH-TABLE-WEAKNESS" ECL_FUN("si_hash_table_weakness", si_hash_table_weakness, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{KEY_ "SYNCHRONIZED" ECL_FUN(NULL, NULL, -1) ECL_VAR(KEYWORD, OBJNULL)},
{EXT_ "HASH-TABLE-SYNCHRONIZED-P" ECL_FUN("si_hash_table_synchronized_p", si_hash_table_synchronized_p, 1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "TRULY-THE" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "CHECKED-VALUE" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{EXT_ "INSTALL-BYTECODES-COMPILER" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "INSTALL-C-COMPILER" ECL_FUN(NULL, NULL, -1) ECL_VAR(EXT_ORDINARY, OBJNULL)},

{FFI_ "C-CHAR-BIT" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_CONSTANT, ecl_make_fixnum(CHAR_BIT))},
{FFI_ "C-CHAR-MAX" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_CONSTANT, ecl_make_fixnum(CHAR_MAX))},
{FFI_ "C-CHAR-MIN" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_CONSTANT, ecl_make_fixnum(CHAR_MIN))},
{FFI_ "C-INT-MAX" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_CONSTANT, OBJNULL)},
{FFI_ "C-INT-MIN" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_CONSTANT, OBJNULL)},
{FFI_ "C-SHORT-MAX" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_CONSTANT, ecl_make_fixnum(SHRT_MAX))},
{FFI_ "C-SHORT-MIN" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_CONSTANT, ecl_make_fixnum(SHRT_MIN))},
{FFI_ "C-LONG-MAX" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_CONSTANT, OBJNULL)},
{FFI_ "C-LONG-MIN" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_CONSTANT, OBJNULL)},
{FFI_ "C-LONG-LONG-MAX" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_CONSTANT, OBJNULL)},
{FFI_ "C-UCHAR-MAX" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_CONSTANT, ecl_make_fixnum(UCHAR_MAX))},
{FFI_ "C-UINT-MAX" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_CONSTANT, OBJNULL)},
{FFI_ "C-USHORT-MAX" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_CONSTANT, ecl_make_fixnum(USHRT_MAX))},
{FFI_ "C-ULONG-MAX" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_CONSTANT, OBJNULL)},
{FFI_ "C-ULONG-LONG-MAX" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_CONSTANT, OBJNULL)},
#ifdef ecl_long_long_t
{FFI_ "C-LONG-LONG-BIT" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_CONSTANT, ecl_make_fixnum(ECL_LONG_LONG_BITS))},
#else
{FFI_ "C-LONG-LONG-BIT" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_CONSTANT, OBJNULL)},
#endif

{FFI_ "*USE-DFFI*" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "+NULL-CSTRING-POINTER+" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "ALLOCATE-FOREIGN-OBJECT" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "ALLOCATE-FOREIGN-STRING" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "C-INLINE" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "C-PROGN" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "CALLBACK" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "CHAR*" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "CHAR-ARRAY-TO-POINTER" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "CLINES" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "CONVERT-FROM-CSTRING" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "CONVERT-FROM-FOREIGN-STRING" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "CONVERT-TO-CSTRING" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "CONVERT-TO-FOREIGN-STRING" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "DEF-ARRAY" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "DEF-ARRAY-POINTER" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "DEF-CONSTANT" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "DEF-ENUM" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "DEF-FOREIGN-TYPE" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "DEF-FOREIGN-VAR" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "DEF-FUNCTION" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "DEF-STRUCT" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "DEF-TYPE" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "DEF-UNION" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "DEFCALLBACK" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "DEFCBODY" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "DEFENTRY" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "DEFINLINE" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "DEFLA" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "DEREF-ARRAY" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "DEREF-POINTER" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "DOUBLE" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "ENSURE-CHAR-CHARACTER" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "ENSURE-CHAR-INTEGER" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "ENSURE-CHAR-STORABLE" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "FIND-FOREIGN-LIBRARY" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "FOREIGN-STRING-LENGTH" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "FREE-CSTRING" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "FREE-FOREIGN-OBJECT" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "GET-SLOT-POINTER" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "GET-SLOT-VALUE" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "INT" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "LOAD-FOREIGN-LIBRARY" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "MAKE-NULL-POINTER" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "MAKE-POINTER" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "NULL-CHAR-P" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "OBJECT" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "POINTER-ADDRESS" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "SIZE-OF-FOREIGN-TYPE" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "VOID" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "WITH-CAST-POINTER" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "WITH-CSTRING" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "WITH-CSTRINGS" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "WITH-FOREIGN-OBJECT" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "WITH-FOREIGN-OBJECTS" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "WITH-FOREIGN-STRING" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},
{FFI_ "WITH-FOREIGN-STRINGS" ECL_FUN(NULL, NULL, -1) ECL_VAR(FFI_ORDINARY, OBJNULL)},

{SYS_ "BIND-SIMPLE-RESTARTS" ECL_FUN("si_bind_simple_restarts", ECL_NAME(si_bind_simple_restarts), 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "BIND-SIMPLE-HANDLERS" ECL_FUN("si_bind_simple_handlers", ECL_NAME(si_bind_simple_handlers), 2) ECL_VAR(SI_ORDINARY, OBJNULL)},
{EXT_ "CONSTANT-FORM-VALUE" ECL_FUN("si_constant_form_value", si_constant_form_value, -2) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{EXT_ "CONSTANTP-INNER" ECL_FUN("si_constantp_inner", si_constantp_inner, -2) ECL_VAR(EXT_ORDINARY, OBJNULL)},
{SYS_ "MAKE-BACKQ-VECTOR" ECL_FUN("si_make_backq_vector", si_make_backq_vector, 3) ECL_VAR(SI_ORDINARY, OBJNULL)},

{SYS_ "RATIOP" ECL_FUN("si_ratiop", ECL_NAME(si_ratiop), 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SHORT-FLOAT-P" ECL_FUN("si_short_float_p", ECL_NAME(si_short_float_p), 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "SINGLE-FLOAT-P" ECL_FUN("si_single_float_p", ECL_NAME(si_single_float_p), 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "DOUBLE-FLOAT-P" ECL_FUN("si_double_float_p", ECL_NAME(si_double_float_p), 1) ECL_VAR(SI_ORDINARY, OBJNULL)},
{SYS_ "LONG-FLOAT-P" ECL_FUN("si_long_float_p", ECL_NAME(si_long_float_p), 1) ECL_VAR(SI_ORDINARY, OBJNULL)},

{SYS_ "COPY-HASH-TABLE" ECL_FUN("si_copy_hash_table", si_copy_hash_table, 1) ECL_VAR(SI_ORDINARY, OBJNULL)},

/* Tag for end of list */
{NULL ECL_FUN(NULL, NULL, -1) ECL_VAR(CL_ORDINARY, OBJNULL)}};

#undef ECL_FUN
#undef ECL_VAR
