/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.ForEach;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.sort.SortExpression;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;

public class XSLForEach
extends StyleElement {
    Expression select = null;
    boolean containsTailCall = false;

    public boolean isInstruction() {
        return true;
    }

    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLSort;
    }

    protected ItemType getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    protected boolean markTailCalls() {
        if (Cardinality.allowsMany(this.select.getCardinality())) {
            return false;
        }
        StyleElement last = this.getLastChildInstruction();
        this.containsTailCall = last != null && last.markTailCalls();
        return this.containsTailCall;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (selectAtt == null) {
            this.reportAbsence("select");
        } else {
            this.select = this.makeExpression(selectAtt);
        }
    }

    public void validate() throws XPathException {
        this.checkSortComesFirst(false);
        this.select = this.typeCheck("select", this.select);
        if (!this.hasChildNodes()) {
            this.compileWarning("An empty xsl:for-each instruction has no effect", "SXWN9009");
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        Expression block;
        SortKeyDefinition[] sortKeys = this.makeSortKeys();
        Expression sortedSequence = this.select;
        if (sortKeys != null) {
            sortedSequence = new SortExpression(this.select, sortKeys);
        }
        if ((block = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true)) == null) {
            return Literal.makeEmptySequence();
        }
        try {
            return new ForEach(sortedSequence, this.makeExpressionVisitor().simplify(block), this.containsTailCall);
        }
        catch (XPathException err) {
            this.compileError(err);
            return null;
        }
    }
}

