/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class Message
extends Instruction {
    private Expression terminate;
    private Expression select;

    public Message(Expression select, Expression terminate) {
        this.terminate = terminate;
        this.select = select;
        this.adoptChildExpression(terminate);
        this.adoptChildExpression(select);
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.select = visitor.simplify(this.select);
        this.terminate = visitor.simplify(this.terminate);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.select = visitor.typeCheck(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        if (this.terminate != null) {
            this.terminate = visitor.typeCheck(this.terminate, contextItemType);
            this.adoptChildExpression(this.terminate);
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.select = visitor.optimize(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        if (this.terminate != null) {
            this.terminate = visitor.optimize(this.terminate, contextItemType);
            this.adoptChildExpression(this.terminate);
        }
        return this;
    }

    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    public int getInstructionNameCode() {
        return 158;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return AnyItemType.getInstance();
    }

    public int getCardinality() {
        return 24576;
    }

    public final boolean createsNewNodes() {
        return true;
    }

    protected void promoteInst(PromotionOffer offer) throws XPathException {
        if (this.select != null) {
            this.select = this.doPromotion(this.select, offer);
        }
        if (this.terminate != null) {
            this.terminate = this.doPromotion(this.terminate, offer);
        }
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(2);
        if (this.select != null) {
            list.add(this.select);
        }
        if (this.terminate != null) {
            list.add(this.terminate);
        }
        return list.iterator();
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.terminate == original) {
            this.terminate = replacement;
            found = true;
        }
        return found;
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        String term;
        Controller controller = context.getController();
        Receiver emitter = controller.getMessageEmitter();
        SequenceReceiver rec = new TreeReceiver(emitter);
        rec = new AttributeMasker(rec);
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOrigin(this);
        Properties props = new Properties();
        props.setProperty("omit-xml-declaration", "yes");
        c2.changeOutputDestination(props, rec, false, 50, 3, null);
        boolean abort = false;
        if (this.terminate != null && !(term = ((Object)this.terminate.evaluateAsString(context)).toString()).equals("no")) {
            if (term.equals("yes")) {
                abort = true;
            } else {
                XPathException e = new XPathException("The terminate attribute of xsl:message must be 'yes' or 'no'");
                e.setXPathContext(context);
                e.setErrorCode("XTDE0030");
                throw e;
            }
        }
        rec.startDocument(abort ? 16384 : 0);
        if (this.select != null) {
            Item item;
            SequenceIterator iter = this.select.iterate(c2);
            while ((item = iter.next()) != null) {
                rec.append(item, this.locationId, 2);
            }
        }
        rec.endDocument();
        if (abort) {
            throw new TerminationException("Processing terminated by xsl:message at line " + this.getLineNumber() + " in " + ExpressionLocation.truncateURI(this.getSystemId()));
        }
        return null;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("xslMessage");
        out.endElement();
    }

    private static class AttributeMasker
    extends ProxyReceiver {
        private boolean contentStarted = true;

        public AttributeMasker(SequenceReceiver next) {
            this.setPipelineConfiguration(next.getPipelineConfiguration());
            this.setUnderlyingReceiver(next);
        }

        public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
            this.contentStarted = false;
            super.startElement(nameCode, typeCode, locationId, properties);
        }

        public void startContent() throws XPathException {
            this.contentStarted = true;
            super.startContent();
        }

        public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
            if (this.contentStarted) {
                String attName = this.getNamePool().getDisplayName(nameCode);
                this.processingInstruction("attribute", "name=\"" + attName + "\" value=\"" + value + "\"", 0, 0);
            } else {
                super.attribute(nameCode, typeCode, value, locationId, properties);
            }
        }

        public void namespace(int namespaceCode, int properties) throws XPathException {
            if (this.contentStarted) {
                String prefix = this.getNamePool().getPrefixFromNamespaceCode(namespaceCode);
                String uri = this.getNamePool().getURIFromNamespaceCode(namespaceCode);
                this.processingInstruction("namespace", "prefix=\"" + prefix + "\" uri=\"" + uri + "\"", 0, 0);
            } else {
                super.namespace(namespaceCode, properties);
            }
        }

        public void append(Item item, int locationId, int copyNamespaces) throws XPathException {
            int kind;
            if (item instanceof NodeInfo && ((kind = ((NodeInfo)item).getNodeKind()) == 2 || kind == 13)) {
                ((NodeInfo)item).copy(this, 0, false, 0);
                return;
            }
            ((SequenceReceiver)this.nextReceiver).append(item, locationId, copyNamespaces);
        }
    }
}

