/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/frame/std_exception.hpp
 *
 * $Id: std_exception.hpp,v 1.11 2005/06/23 09:54:18 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] @ref diagnostics::Std_Exception middle-class
 */

#ifndef DIAGNOSTICS__FRAME__STD_EXCEPTION_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__FRAME__STD_EXCEPTION_HPP__INCLUDE_GUARD

// used as base class
#include <diagnostics/frame/exception.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;

/**
 * @class Std_Exception diagnostics/frame/std_exception.hpp
 *
 * @brief Middle class for exceptions -- just implementing the what
 * field and method
 *
 * The field is left accessible for manipulation by the
 * subclasses. The constructors are all protected -- this class is not
 * instantiated directly.
 *
 * @nosubgrouping
 */
class Std_Exception :
    public Exception
{
    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Creation
     * @{
     */
protected:
     /**
      * @brief Empty initialization.
	  *
	  * @post what() == ""
      *
      * @throw never
      */
	Std_Exception();

     /**
      * @brief Intialization with @a what
	  *
	  * @post what() == @a what
      *
      * @throw never
      */
	explicit Std_Exception(::std::string const & what);

	/**
     * @brief Standard Copy Constructor
	 *
	 * @post what() == @a other.what()
	 *
	 * @throw never
     */ 
	Std_Exception(Std_Exception const & other);
 public:
     /**
      * @brief noop 
      *
      * @throw never
      */
    virtual ~Std_Exception() DIAGNOSTICS_EXCEPTIONS_THROW_DECL;
    // @}

	////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Disabled Creation/Assignment
     * @{
     */
private:
	/**
     * @brief Is not necessary. And should not be generated -- thus
     * the assignment is set private is left UNIMPLEMENTED.
     */ 
	Std_Exception & operator=(Std_Exception const & other);
	//@}


    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Partial Interface Implementation of Exception
     * @{
     */
public:
    virtual char const * what() const DIAGNOSTICS_EXCEPTIONS_THROW_DECL;
    // @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Encapsulated State
     * @{
     */
protected:
    ::std::string m_what;
    // @}
};


DIAGNOSTICS_NAMESPACE_END;

#endif

// vim:ts=4:sw=4
