pragma Ada_2005;
pragma Style_Checks (Off);

with Interfaces.C; use Interfaces.C;
with Interfaces.C.Strings;
with System;
limited with dbus_errors_h;
with dbus_types_h;

package dbus_address_h is

   --  skipped empty struct DBusAddressEntry

   function dbus_parse_address
     (address : Interfaces.C.Strings.chars_ptr;
      c_entry : System.Address;
      array_len : access int;
      error : access dbus_errors_h.DBusError) return dbus_types_h.dbus_bool_t;  -- ../dbus/dbus-address.h:44
   pragma Import (C, dbus_parse_address, "dbus_parse_address");

   function dbus_address_entry_get_value (c_entry : System.Address; key : Interfaces.C.Strings.chars_ptr) return Interfaces.C.Strings.chars_ptr;  -- ../dbus/dbus-address.h:49
   pragma Import (C, dbus_address_entry_get_value, "dbus_address_entry_get_value");

   function dbus_address_entry_get_method (c_entry : System.Address) return Interfaces.C.Strings.chars_ptr;  -- ../dbus/dbus-address.h:52
   pragma Import (C, dbus_address_entry_get_method, "dbus_address_entry_get_method");

   procedure dbus_address_entries_free (entries : System.Address);  -- ../dbus/dbus-address.h:54
   pragma Import (C, dbus_address_entries_free, "dbus_address_entries_free");

   function dbus_address_escape_value (value : Interfaces.C.Strings.chars_ptr) return Interfaces.C.Strings.chars_ptr;  -- ../dbus/dbus-address.h:57
   pragma Import (C, dbus_address_escape_value, "dbus_address_escape_value");

   function dbus_address_unescape_value (value : Interfaces.C.Strings.chars_ptr; error : access dbus_errors_h.DBusError) return Interfaces.C.Strings.chars_ptr;  -- ../dbus/dbus-address.h:59
   pragma Import (C, dbus_address_unescape_value, "dbus_address_unescape_value");

end dbus_address_h;
