#!/bin/sh -e

# Script to package tarball for distribution
#	01/2005 Created by Dustin Kirkland (dkirklan@us.ibm.com)
#	10/2008 Updated by Dustin Kirkland (dustin.kirkland@gmail.com)
#		to switch from date-based versioning to numeric


VER=`head -n1 debian/changelog | sed "s/^.*(//" | sed "s/).*$//"`
RELEASE="bogosec-$VER"

mkdir -p "$RELEASE"

# files to package
FILES=" bogosec
	bogosec.conf
	bogosec_wrapper
	configure
	Makefile
	LICENSE
	README
	man/bogosec.1
	man/bogosec_wrapper.1
	plugins/BogoFlaw.pm
	plugins/BogoLintian.pm
	plugins/BogoRats.pm"

# dirs in package
DIRS="  man
	plugins "

for dir in $DIRS; do
	mkdir -p "$RELEASE/$dir"
done

for file in $FILES; do
	cp -f $file "$RELEASE/$file"
done
cp -f debian/changelog $RELEASE/CHANGELOG

tar zcf ../$RELEASE.tar.gz $RELEASE
gpg --armor --sign --detach-sig ../$RELEASE.tar.gz
rm -rf "$RELEASE"
