function spect2(a, b, xlc, vitn, rhoe,&
                defm, f, tol, ier, r1,&
                err, nbp, im, jm)
!------------------------------------------------------------------
! ======================================================================
! COPYRIGHT (C) 1991 - 2012  EDF R&D                  WWW.CODE-ASTER.ORG
! THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
! IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
! THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
! (AT YOUR OPTION) ANY LATER VERSION.
!
! THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
! WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
! MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
! GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
! YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
! ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
!    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
! ======================================================================
!-------------------------------------------------------------------
! aslint: disable=
    implicit none
!                                 B  F2(X)
! DESCRIPTION : CALCULE DINTEG = S  S F(X,Y) DY   DX
! -----------                     A  F1(X)
!
!               (S EST LE SYMBOLE DE L'INTEGRALE).
!
!               TOL DONNE LE SEUIL DE CONVERGENCE RELATIVE.
!
!               F EST LA FONCTION A INTEGRER.
!               ELLE DOIT ETRE DECLAREE EXTERNAL DANS L'APPELANT.
!               SA SPECIFICATION EST :
!                        DOUBLE PRECISION FUNCTION F ( X, Y )
!                        DOUBLE PRECISION X, Y
!               L'INTEGRALE INTERNE EST EVALUEE PAR LA FONCTION DINTG2.
!               C'EST DONC DINTG2 QUI APPELLE F ET NON DINTEG.
!               F EST DONNEE EN ARGUMENT A DINTG2 PAR DINTEG.
!
!               A ET B DONNENT LES BORNES DE L'INTEGRALE EXTERNE.
!
!               F1 ET F2 DONNENT LES BORNES DE L'INTEGRALE INTERNE.
!               ELLES DOIVENT ETRE DECLAREE EXTERNAL DANS L'APPELANT.
!               LEURS SPECIFICATIONS SONT :
!                        DOUBLE PRECISION FUNCTION F1 ( X )
!                        DOUBLE PRECISION X
!                        DOUBLE PRECISION FUNCTION F2 ( X )
!                        DOUBLE PRECISION X
!
! AU RETOUR : IER=0 <==> L'INTEGRALE EXTERNE A CONVERGEE.
! ---------   IER=1 <==> L'INTEGRALE EXTERNE N'A PAS CONVERGEE.
!                        ON RENVOIT LA VALEUR AU PAS PRECEDENT ET
!                        L'ERREUR RELATIVE.
!             A, B ET TOL SONT INCHANGES.
!
! *****************   DECLARATIONS DES VARIABLES   ********************
!
!
! ARGUMENTS
! ---------
#include "jeveux.h"
#include "asterfort/spect3.h"
    interface
    function f(xx, y, xlc, vitn, rhoe,&
               defm, nbp, im, jm)
        integer :: nbp
        real(kind=8) :: xx
        real(kind=8) :: y
        real(kind=8) :: xlc
        real(kind=8) :: vitn(nbp, *)
        real(kind=8) :: rhoe(nbp, *)
        real(kind=8) :: defm(nbp, *)
        integer :: im
        integer :: jm
        real(kind=8) :: f
    end function f
    end interface
    integer :: ier
    real(kind=8) :: vitn(nbp, *), defm(nbp, *), rhoe(nbp, *), a, b, tol, xlc, r1
    real(kind=8) :: err
!
! VARIABLES LOCALES
! -----------------
    integer :: index, n1, n2, i, arret
    real(kind=8) :: res, xm, dx, x0, som, x
    real(kind=8) :: w(127), coeff(381)
!
! FONCTIONS
! ---------
!
! DATAS
! -----
!-----------------------------------------------------------------------
    integer :: im, jm, nbp
    real(kind=8) :: spect2
!-----------------------------------------------------------------------
    data (coeff(i),i=  1, 20) /&
     &     0.7745966692414834D0  ,    0.5555555555555556D0  ,&
     &     0.8888888888888889D0  ,    0.2684880898683334D0  ,&
     &     0.9604912687080203D0  ,    0.1046562260264673D0  ,&
     &     0.4342437493468026D0  ,    0.4013974147759622D0  ,&
     &     0.4509165386584741D0  ,    0.1344152552437842D0  ,&
     &     0.5160328299707974D-1 ,    0.2006285293769890D0  ,&
     &     0.9938319632127550D0  ,    0.1700171962994026D-1 ,&
     &     0.8884592328722570D0  ,    0.9292719531512454D-1 ,&
     &     0.6211029467372264D0  ,    0.1715119091363914D0  ,&
     &     0.2233866864289669D0  ,    0.2191568584015875D0  /
!
    data (coeff(i),i= 21, 40) /&
     &     0.2255104997982067D0  ,    0.6720775429599070D-1 ,&
     &     0.2580759809617665D-1 ,    0.1003142786117956D0  ,&
     &     0.8434565739321106D-2 ,    0.4646289326175799D-1 ,&
     &     0.8575592004999035D-1 ,    0.1095784210559246D0  ,&
     &     0.9990981249676676D0  ,    0.2544780791561874D-2 ,&
     &     0.9815311495537401D0  ,    0.1644604985438781D-1 ,&
     &     0.9296548574297401D0  ,    0.3595710330712932D-1 ,&
     &     0.8367259381688687D0  ,    0.5697950949412336D-1 ,&
     &     0.7024962064915271D0  ,    0.7687962049900353D-1 ,&
     &     0.5313197436443756D0  ,    0.9362710998126447D-1 /
!
    data (coeff(i),i= 41, 60) /&
     &     0.3311353932579768D0  ,    0.1056698935802348D0  ,&
     &     0.1124889431331866D0  ,    0.1119568730209535D0  ,&
     &     0.1127552567207687D0  ,    0.3360387714820773D-1 ,&
     &     0.1290380010035127D-1 ,    0.5015713930589954D-1 ,&
     &     0.4217630441558855D-2 ,    0.2323144663991027D-1 ,&
     &     0.4287796002500773D-1 ,    0.5478921052796287D-1 ,&
     &     0.1265156556230068D-2 ,    0.8223007957235930D-2 ,&
     &     0.1797855156812827D-1 ,    0.2848975474583355D-1 ,&
     &     0.3843981024945553D-1 ,    0.4681355499062801D-1 ,&
     &     0.5283494679011652D-1 ,    0.5597843651047632D-1 /
!
    data (coeff(i),i= 61, 80) /&
     &     0.9998728881203576D0  ,    0.3632214818455307D-3 ,&
     &     0.9972062593722220D0  ,    0.2579049794685688D-2 ,&
     &     0.9886847575474295D0  ,    0.6115506822117246D-2 ,&
     &     0.9721828747485818D0  ,    0.1049824690962132D-1 ,&
     &     0.9463428583734029D0  ,    0.1540675046655950D-1 ,&
     &     0.9103711569570043D0  ,    0.2059423391591271D-1 ,&
     &     0.8639079381936905D0  ,    0.2586967932721475D-1 ,&
     &     0.8069405319502176D0  ,    0.3107355111168796D-1 ,&
     &     0.7397560443526948D0  ,    0.3606443278078257D-1 ,&
     &     0.6629096600247806D0  ,    0.4071551011694432D-1 /
!
    data (coeff(i),i= 81,100) /&
     &     0.5771957100520458D0  ,    0.4491453165363220D-1 ,&
     &     0.4836180269458410D0  ,    0.4856433040667320D-1 ,&
     &     0.3833593241987303D0  ,    0.5158325395204846D-1 ,&
     &     0.2777498220218243D0  ,    0.5390549933526606D-1 ,&
     &     0.1682352515522075D0  ,    0.5548140435655936D-1 ,&
     &     0.5634431304659279D-1 ,    0.5627769983125430D-1 ,&
     &     0.5637762836038472D-1 ,    0.1680193857410387D-1 ,&
     &     0.6451900050175737D-2 ,    0.2507856965294977D-1 ,&
     &     0.2108815245726633D-2 ,    0.1161572331995513D-1 ,&
     &     0.2143898001250387D-1 ,    0.2739460526398143D-1 /
!
    data (coeff(i),i=101,120) /&
     &     0.6326073193626335D-3 ,    0.4111503978654693D-2 ,&
     &     0.8989275784064136D-2 ,    0.1424487737291677D-1 ,&
     &     0.1921990512472777D-1 ,    0.2340677749531401D-1 ,&
     &     0.2641747339505826D-1 ,    0.2798921825523816D-1 ,&
     &     0.1807395644453884D-3 ,    0.1289524082610417D-2 ,&
     &     0.3057753410175531D-2 ,    0.5249123454808859D-2 ,&
     &     0.7703375233279742D-2 ,    0.1029711695795636D-1 ,&
     &     0.1293483966360737D-1 ,    0.1553677555584398D-1 ,&
     &     0.1803221639039129D-1 ,    0.2035775505847216D-1 ,&
     &     0.2245726582681610D-1 ,    0.2428216520333660D-1 /
!
    data (coeff(i),i=121,140) /&
     &     0.2579162697602423D-1 ,    0.2695274966763303D-1 ,&
     &     0.2774070217827968D-1 ,    0.2813884991562715D-1 ,&
     &     0.9999824303548916D0  ,    0.5053609520786252D-4 ,&
     &     0.9995987996719107D0  ,    0.3777466463269847D-3 ,&
     &     0.9983166353184074D0  ,    0.9383698485423815D-3 ,&
     &     0.9957241046984072D0  ,    0.1681142865421470D-2 ,&
     &     0.9914957211781061D0  ,    0.2568764943794020D-2 ,&
     &     0.9853714995985204D0  ,    0.3572892783517300D-2 ,&
     &     0.9771415146397057D0  ,    0.4671050372114322D-2 ,&
     &     0.9666378515584166D0  ,    0.5843449875835640D-2 /
!
    data (coeff(i),i=141,160) /&
     &     0.9537300064257611D0  ,    0.7072489995433555D-2 ,&
     &     0.9383203977795929D0  ,    0.8342838753968158D-2 ,&
     &     0.9203400254700124D0  ,    0.9641177729702537D-2 ,&
     &     0.8997448997769400D0  ,    0.1095573338783790D-1 ,&
     &     0.8765134144847053D0  ,    0.1227583056008277D-1 ,&
     &     0.8506444947683503D0  ,    0.1359157100976555D-1 ,&
     &     0.8221562543649804D0  ,    0.1489364166481518D-1 ,&
     &     0.7910849337998484D0  ,    0.1617321872957772D-1 ,&
     &     0.7574839663805136D0  ,    0.1742193015946417D-1 ,&
     &     0.7214230853700989D0  ,    0.1863184825613879D-1 /
!
    data (coeff(i),i=161,180) /&
     &     0.6829874310910792D0  ,    0.1979549504809750D-1 ,&
     &     0.6422766425097595D0  ,    0.2090585144581202D-1 ,&
     &     0.5994039302422429D0  ,    0.2195636630531782D-1 ,&
     &     0.5544951326319325D0  ,    0.2294096422938775D-1 ,&
     &     0.5076877575337166D0  ,    0.2385405210603854D-1 ,&
     &     0.4591300119898323D0  ,    0.2469052474448768D-1 ,&
     &     0.4089798212298887D0  ,    0.2544576996546477D-1 ,&
     &     0.3574038378315322D0  ,    0.2611567337670610D-1 ,&
     &     0.3045764415567140D0  ,    0.2669662292745036D-1 ,&
     &     0.2506787303034832D0  ,    0.2718551322962479D-1 /
!
    data (coeff(i),i=181,200) /&
     &     0.1958975027111002D0  ,    0.2757974956648187D-1 ,&
     &     0.1404242331525602D0  ,    0.2787725147661370D-1 ,&
     &     0.8445404008371088D-1 ,    0.2807645579381725D-1 ,&
     &     0.2818464894974569D-1 ,    0.2817631903301660D-1 ,&
     &     0.2818881418019236D-1 ,    0.8400969287051933D-2 ,&
     &     0.3225950025087868D-2 ,    0.1253928482647488D-1 ,&
     &     0.1054407622853764D-2 ,    0.5807861659977567D-2 ,&
     &     0.1071949000625193D-1 ,    0.1369730263199072D-1 ,&
     &     0.3163038905577009D-3 ,    0.2055751989327344D-2 ,&
     &     0.4494637892032068D-2 ,    0.7122438686458387D-2 /
!
    data (coeff(i),i=201,220) /&
     &     0.9609952562363883D-2 ,    0.1170338874765700D-1 ,&
     &     0.1320873669752913D-1 ,    0.1399460912761908D-1 ,&
     &     0.9059242831838712D-4 ,    0.6447620408298260D-3 ,&
     &     0.1528876705087616D-2 ,    0.2624561727404430D-2 ,&
     &     0.3851687616639871D-2 ,    0.5148558478978178D-2 ,&
     &     0.6467419831803687D-2 ,    0.7768387777921991D-2 ,&
     &     0.9016108195195643D-2 ,    0.1017887752923608D-1 ,&
     &     0.1122863291340805D-1 ,    0.1214108260166830D-1 ,&
     &     0.1289581348801211D-1 ,    0.1347637483381652D-1 ,&
     &     0.1387035108913984D-1 ,    0.1406942495781358D-1 /
!
    data (coeff(i),i=221,240) /&
     &     0.2234303854547696D-4 ,    0.1888639812523945D-3 ,&
     &     0.4691849097155527D-3 ,    0.8405714326197546D-3 ,&
     &     0.1284382471895813D-2 ,    0.1786446391758630D-2 ,&
     &     0.2335525186057160D-2 ,    0.2921724937917820D-2 ,&
     &     0.3536244997716778D-2 ,    0.4171419376984079D-2 ,&
     &     0.4820588864851268D-2 ,    0.5477866693918951D-2 ,&
     &     0.6137915280041385D-2 ,    0.6795785504882773D-2 ,&
     &     0.7446820832407591D-2 ,    0.8086609364788860D-2 ,&
     &     0.8710965079732087D-2 ,    0.9315924128069395D-2 ,&
     &     0.9897747524048750D-2 ,    0.1045292572290601D-1 /
!
    data (coeff(i),i=241,260) /&
     &     0.1097818315265891D-1 ,    0.1147048211469387D-1 ,&
     &     0.1192702605301927D-1 ,    0.1234526237224384D-1 ,&
     &     0.1272288498273238D-1 ,    0.1305783668835305D-1 ,&
     &     0.1334831146372518D-1 ,    0.1359275661481240D-1 ,&
     &     0.1378987478324094D-1 ,    0.1393862573830685D-1 ,&
     &     0.1403822789690862D-1 ,    0.1408815951650830D-1 ,&
     &     0.9999958664005165D0  ,    0.8822702694609804D-5 ,&
     &     0.9999445736539534D0  ,    0.5403992347935378D-4 ,&
     &     0.9997604612201292D0  ,    0.1357078405902732D-3 ,&
     &     0.9993803390481119D0  ,    0.2492143139346697D-3 /
!
    data (coeff(i),i=261,280) /&
     &     0.9987456144372444D0  ,    0.3897452481631715D-3 ,&
     &     0.9978053544968644D0  ,    0.5542953186526136D-3 ,&
     &     0.9965141459148629D0  ,    0.7402828044420028D-3 ,&
     &     0.9948315028006219D0  ,    0.9453615168885046D-3 ,&
     &     0.9927213442827886D0  ,    0.1167484117433308D-2 ,&
     &     0.9901513704007702D0  ,    0.1404907995655566D-2 ,&
     &     0.9870925279540341D0  ,    0.1656112728154507D-2 ,&
     &     0.9835186575786327D0  ,    0.1919712971013880D-2 ,&
     &     0.9794062816708627D0  ,    0.2194406925363840D-2 ,&
     &     0.9747344597524027D0  ,    0.2478958226657568D-2 /
!
    data (coeff(i),i=281,300) /&
     &     0.9694846595024592D0  ,    0.2772195764593451D-2 ,&
     &     0.9636406215698121D0  ,    0.3073018434702578D-2 ,&
     &     0.9571882161098610D0  ,    0.3380397991086920D-2 ,&
     &     0.9501152975212949D0  ,    0.3693377917025651D-2 ,&
     &     0.9424115651910831D0  ,    0.4011068724075023D-2 ,&
     &     0.9340684361577258D0  ,    0.4332640968092983D-2 ,&
     &     0.9250789329070757D0  ,    0.4657317299756855D-2 ,&
     &     0.9154375871557650D0  ,    0.4984364564765539D-2 ,&
     &     0.9051403588132616D0  ,    0.5313086605187057D-2 ,&
     &     0.8941845683355590D0  ,    0.5642818101384444D-2 /
!
    data (coeff(i),i=301,320) /&
     &     0.8825688402473419D0  ,    0.5972919565508166D-2 ,&
     &     0.8702930555481139D0  ,    0.6302773449085759D-2 ,&
     &     0.8573583108862322D0  ,    0.6631781242901888D-2 ,&
     &     0.8437668826727086D0  ,    0.6959361409390423D-2 ,&
     &     0.8295221946374014D0  ,    0.7284947980553807D-2 ,&
     &     0.8146287876551374D0  ,    0.7607989665719057D-2 ,&
     &     0.7990922909608414D0  ,    0.7927949334294849D-2 ,&
     &     0.7829193941182830D0  ,    0.8244303763032868D-2 ,&
     &     0.7661178193037601D0  ,    0.8556543561307690D-2 ,&
     &     0.7486962936169366D0  ,    0.8864173209482494D-2 /
!
    data (coeff(i),i=321,340) /&
     &     0.7306645212421813D0  ,    0.9166711163560788D-2 ,&
     &     0.7120331553622520D0  ,    0.9463689993830065D-2 ,&
     &     0.6928137697791147D0  ,    0.9754656536317411D-2 ,&
     &     0.6730188302304185D0  ,    0.1003917204405684D-1 ,&
     &     0.6526616654100175D0  ,    0.1031681233094762D-1 ,&
     &     0.6317564377111942D0  ,    0.1058716790488520D-1 ,&
     &     0.6103181137151864D0  ,    0.1084984408933731D-1 ,&
     &     0.5883624344476625D0  ,    0.1110446113400693D-1 ,&
     &     0.5659058854236544D0  ,    0.1135065431598060D-1 ,&
     &     0.5429656664983115D0  ,    0.1158807403304395D-1 /
!
    data (coeff(i),i=341,360) /&
     &     0.5195596615374570D0  ,    0.1181638589083024D-1 ,&
     &     0.4957064079187615D0  ,    0.1203527078527956D-1 ,&
     &     0.4714250658716589D0  ,    0.1224442498161199D-1 ,&
     &     0.4467353876620285D0  ,    0.1244356019071404D-1 ,&
     &     0.4216576866261633D0  ,    0.1263240364354208D-1 ,&
     &     0.3962128060576159D0  ,    0.1281069816387736D-1 ,&
     &     0.3704220879500782D0  ,    0.1297820223953740D-1 ,&
     &     0.3443073415994380D0  ,    0.1313469009196015D-1 ,&
     &     0.3178908120684767D0  ,    0.1327995174393053D-1 ,&
     &     0.2911951485182467D0  ,    0.1341379308511010D-1 /
!
    data (coeff(i),i=361,381) /&
     &     0.2642433724109268D0  ,    0.1353603593495621D-1 ,&
     &     0.2370588455898297D0  ,    0.1364651810257129D-1 ,&
     &     0.2096652382431812D0  ,    0.1374509344300190D-1 ,&
     &     0.1820864967592522D0  ,    0.1383163190950643D-1 ,&
     &     0.1543468114813781D0  ,    0.1390601960132546D-1 ,&
     &     0.1264705843723020D0  ,    0.1396815880651694D-1 ,&
     &     0.9848239659811920D-1 ,    0.1401796803945661D-1 ,&
     &     0.7040697604285518D-1 ,    0.1405538207264996D-1 ,&
     &     0.4226916476536360D-1 ,    0.1408035196255366D-1 ,&
     &     0.1409388641078246D-1 ,    0.1409284506916041D-1 ,&
     &     0.1409440709009618D-1 /
!
! *****************    DEBUT DU CODE EXECUTABLE    *********************
!
    ier = 0
    err = 0.d0
    res = 0.0d0
    if (abs(a-b) .lt. 1.0d-30) then
        spect2 = res
        goto 9999
    endif
!
    xm = ( a + b ) / 2.0d0
    dx = ( b - a ) / 2.0d0
    x0 = spect3 ( xm, a,b, f, tol, coeff,xlc,vitn,defm, rhoe,nbp,im,jm )
    r1 = (x0+x0) * dx
    index = 0
    n1 = 0
    n2 = 1
    som = 0.0d0
!
! --- REPETER ...
!
10  continue
    n1 = n1 + n2
    do 20 i = n2, n1
        index = index + 1
        x = coeff(index) * dx
        w(i) = spect3( xm+x, a, b, f, tol, coeff,xlc,vitn, defm,rhoe, nbp,im,jm ) + spect3( xm-x,&
               & a, b, f, tol, coeff,xlc,vitn, defm,rhoe,nbp,im,jm )
        index = index + 1
        som = som + coeff(index)*w(i)
20  end do
    n2 = n1 + 1
    index = index + 1
    res = ( som + coeff(index)*x0 ) * dx
!
! --- TEST DE CONVERGENCE.
!
    if (abs(res-r1) .le. abs(r1*tol)) then
        ier = 0
        arret = 1
    else
        ier = 1
        if (n1 .ge. 127) then
            arret = 1
            err = abs((res-r1)/r1)*100.d0
        else
            arret = 0
            r1 = res
            som = 0.0d0
            do 22 i = 1, n1
                index = index + 1
                som = som + coeff(index)*w(i)
22          continue
        endif
    endif
!
! --- JUSQUE ARRET = 1.
!
    if (arret .eq. 0) goto 10
!
    spect2 = res
!
9999  continue
end function
