/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;

public class PgIndex {
    private String definition;
    private String name;
    private String tableName;
    private boolean unique;
    private String comment;

    public PgIndex(String string) {
        this.name = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getCreationSQL() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("CREATE ");
        if (this.isUnique()) {
            stringBuilder.append("UNIQUE ");
        }
        stringBuilder.append("INDEX ");
        stringBuilder.append(PgDiffUtils.getCreateIfNotExists());
        stringBuilder.append(PgDiffUtils.getQuotedName(this.getName()));
        stringBuilder.append(" ON ");
        stringBuilder.append(PgDiffUtils.getQuotedName(this.getTableName()));
        stringBuilder.append(' ');
        stringBuilder.append(this.getDefinition());
        stringBuilder.append(';');
        if (this.comment != null && !this.comment.isEmpty()) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("COMMENT ON INDEX ");
            stringBuilder.append(PgDiffUtils.getQuotedName(this.name));
            stringBuilder.append(" IS ");
            stringBuilder.append(this.comment);
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public void setDefinition(String string) {
        this.definition = string;
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getDropSQL() {
        return "DROP INDEX " + PgDiffUtils.getDropIfExists() + PgDiffUtils.getQuotedName(this.getName()) + ";";
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof PgIndex) {
            PgIndex pgIndex = (PgIndex)object;
            bl = this.definition.equals(pgIndex.getDefinition()) && this.name.equals(pgIndex.getName()) && this.tableName.equals(pgIndex.getTableName()) && this.unique == pgIndex.isUnique();
        }
        return bl;
    }

    public int hashCode() {
        return (this.getClass().getName() + "|" + this.definition + "|" + this.name + "|" + this.tableName + "|" + this.unique).hashCode();
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean bl) {
        this.unique = bl;
    }
}

