# How did Bolshevik ideology contribute to the failure of the Revolution?

It is a truism of Leninism that Stalinism has nothing to do with the ideas of
Bolshevism. Moreover, most are at pains to stress that these ideas have no
relation to the actual practice of the Bolshevik Party after the October
Revolution. To re-quote one Leninist:

> _"it was overwhelmingly the force of circumstance which obliged the
> Bolsheviks to retreat so far from their own goals. They travelled this route
> in opposition to their own theory, not because of it -- no matter what
> rhetorical justifications were given at the time."_ [John Rees, _"In Defence
> of October,"_ pp. 3-82, **International Socialism** , no. 52, p. 70]

His fellow party member Duncan Hallas argued that it was _"these desperate
conditions"_ (namely terrible economic situation combined with civil war)
which resulted in _"the Bolshevik Party [coming] to substitute its own rule
for that of a decimated, exhausted working class"_ anarchists disagree. [
**Towards a Revolutionary Socialist Party** , p. 43]

We have discussed in the appendix on ["What caused the degeneration of the
Russian Revolution?"](append43.md) why the various _"objective factors"_
explanations favoured by Leninists to explain the defeat of the Russian
Revolution are unconvincing. Ultimately, they rest on the spurious argument
that if only what most revolutionaries (including, ironically, Leninists!)
consider as inevitable side effects of a revolution did not occur, then
Bolshevism would have been fine. It is hard to take seriously the argument
that if only the ruling class disappeared without a fight, if the imperialists
had not intervened and if the economy was not disrupted then Bolshevism would
have resulted in socialism. This is particularly the case as Leninists argue
that only **their** version of socialism recognises that the ruling class will
**not** disappear after a revolution, that we will face counter-revolution and
so we need a state to defend the revolution! As we argued in [section
H.2.1](secH2.md#sech21), this is not the case. Anarchists have long
recognised that a revolution will require defending and that it will provoke a
serious disruption in the economic life of a country.

Given the somewhat unrealistic tone of these kinds of assertions, it is
necessary to look at the ideological underpinnings of Bolshevism and how they
played their part in the defeat of the Russian Revolution. This section,
therefore, will discuss why such Leninist claims are not true. Simply put,
Bolshevik ideology **did** play a role in the degeneration of the Russian
Revolution. This is obvious once we look at most aspects of Bolshevik ideology
as well as the means advocated by the Bolsheviks to achieve their goals.
Rather than being in opposition to the declared aims of the Bolsheviks, the
policies implemented by them during the revolution and civil war had clear
relations with their pre-revolution ideas and visions. To quote Maurice
Brinton's conclusions after looking at this period:

> _"there is a clear-cut and incontrovertible link between what happened under
> Lenin and Trotsky and the later practices of Stalinism. We know that many on
> the revolutionary left will find this statement hard to swallow. We are
> convinced however that any honest reading of the facts cannot but lead to
> this conclusion. The more one unearths about this period the more difficult
> it becomes to define - or even to see - the 'gulf' allegedly separating what
> happened in Lenin's time from what happened later. Real knowledge of the
> facts also makes it impossible to accept . . . that the whole course of
> events was 'historically inevitable' and 'objectively determined'. Bolshevik
> ideology and practice were themselves important and sometimes decisive
> factors in the equation, at every critical stage of this critical period.
> Now that more facts are available self-mystification on these issues should
> no longer be possible. Should any who have read these pages remain
> 'confused' it will be because they want to remain in that state -- or
> because (as the future beneficiaries of a society similar to the Russian
> one) it is their interest to remain so."_ [ **The Bolsheviks and Workers'
> Control** , p. 84]

This is unsurprising. The Leninist idea that politics of the Bolsheviks had no
influence on the outcome of the revolution, that their policies during the
revolution were a product purely of objective forces, is unconvincing. The
facts of the matter is that people are faced with choices, choices that arise
from the objective conditions that they face. What decisions they make will be
influenced by the ideas they hold -- they will **not** occur automatically, as
if people were on auto-pilot -- and their ideas are shaped by the social
relationships they experience. Thus, someone who favours centralisation and
sees nationalisation as the defining characteristic of socialism will make
different decisions than someone who favours decentralising power and sees
self-management as the key issue. The former will also create **different**
forms of social organisation based on their perceptions of what "socialism" is
and what is "efficient." Similarly, the different forms of social organisation
favoured will also impact on how a revolution develops and the political
decisions they make. For example, if you have a vision which favours
centralised, hierarchical organisation then those placed into a position of
power over others within such structures will act in certain ways, have a
certain world view, which would be alien to someone subject to egalitarian
social relations.

In summary, the ideas in people's heads matter, including during a revolution.
Someone in favour of centralisation, centralised power and who equates party
rule with class rule (like Lenin and Trotsky), will act in ways (and create
structures) totally different from someone who believes in decentralisation
and federalism. The organisation they create will create specific forms of
social relationships which, in turn, will shape the ideas of those subject to
them. This means that a centralised, hierarchical system will create
authoritarian social relationships and these will shape those within them and
the ideas they have in totally different ways than a decentralised,
egalitarian system.

Similarly, if Bolshevik policies hastened the alienation of working class
people and peasants from the regime which, in turn, resulted in resistance to
them then some of the "objective factors" facing Lenin's regime were
themselves the products of earlier political decisions. Unwelcome and
unforeseen (at least to the Bolshevik leadership) consequences of specific
Bolshevik practices and actions, but still flowing from Bolshevik ideology all
the same. So, for example, when leading Bolsheviks had preconceived biases
against decentralisation, federalism, "petty-bourgeois" peasants, "declassed"
workers or "anarcho-syndicalist" tendencies, this would automatically become
an ideological determinant to the policies decided upon by the ruling party.
While social circumstances may have limited Bolshevik options, these social
circumstances were also shaped by the results of Bolshevik ideology and
practice and, moreover, possible solutions to social problems were also
limited by Bolshevik ideology and practice.

So, **political ideas do matter.** And, ironically, the very Leninists who
argue that Bolshevik politics played no role in the degeneration of the
revolution accept this. Modern day Leninists, while denying Bolshevik ideology
had a negative on the development of the revolution also subscribe to the
contradictory idea that Bolshevik politics were essential for its "success"!
Indeed, the fact that they **are** Leninists shows this is the case. They
obviously think that Leninist ideas on centralisation, the role of the party,
the _"workers' state"_ and a host of other issues are correct and, moreover,
essential for the success of a revolution. They just dislike the results when
these ideas were applied in practice within the institutional context these
ideas promote, subject to the pressures of the objective circumstances they
argue **every** revolution will face!

Little wonder anarchists are not convinced by Leninist arguments that their
ideology played no role in the rise of Stalinism in Russia. Simply put, if you
use certain methods then these will be rooted in the specific vision you are
aiming for. If you think socialism is state ownership and centralised planning
then you will favour institutions and organisations which facilitate that end.
If you want a highly centralised state and consider a state as simply being an
_"instrument of class rule"_ then you will see little to worry about in the
concentration of power into the hands of a few party leaders. However, if you
see socialism in terms of working class managing their own affairs then you
will view such developments as being fundamentally in opposition to your goals
and definitely **not** a means to that end.

So part of the reason why Marxist revolutions yield such anti-working class
outcomes is to do with its ideology, methods and goals. It has little to do
with the will to power of a few individuals (important a role as that can
play, sometimes, in events). In a nutshell, the ideology and vision guiding
Leninist parties incorporate hierarchical values and pursue hierarchical aims.
Furthermore, the methods and organisations favoured to achieve (their vision
of) "socialism" are fundamentally hierarchical, aiming to ensure that power is
centralised at the top of pyramidal structures in the hands of the party
leaders.

It would be wrong, as Leninists will do, to dismiss this as simply a case of
"idealism." After all, we are talking about the ideology of a ruling party. As
such, these ideas are more than just ideas: after the seizure of power, they
became a part of the real social situation within Russia. Individually, party
members assumed leadership posts in all spheres of social life and started to
apply their ideology. Then, overtime, the results of this application ensured
that the party could not be done otherwise as the framework of exercising
power had been shaped by its successful application (e.g. Bolshevik centralism
ensured that all its policies were marked by centralist tendencies, simply
because Bolshevik power had become centralised). Soon, the only real instance
of power is the Party, and very soon, only the summits of the Party. This
cannot help but shape its policies and actions. As Castoriadis argues:

> _"If it is true that people's real social existence determines their
> consciousness, it is from that moment illusory to expect the Bolshevik party
> to act in any other fashion than according to its real social position. The
> real social situation of the Party is that of a directorial organ, and its
> point of view toward this society henceforth is not necessarily the same as
> the one this society has toward itself."_ [ **The role of Bolshevik Ideology
> in the birth of the Bureaucracy** , p. 97]

As such, means and ends are related and cannot be separated. As Emma Goldman
argued, there is _"no greater fallacy than the belief that aims and purposes
are one thing, while methods and tactics are another. This conception is a
potent menace to social regeneration. All human experience teaches that
methods and means cannot be separated from the ultimate aim. The means
employed become, through individual habit and social practice, part and parcel
of the final purpose; they influence it, modify it, and presently the aims and
means become identical. . . The great and inspiring aims of the Revolution
became so clouded with and obscured by the methods used by the ruling
political power that it was hard to distinguish what was temporary means and
what final purpose. Psychologically and socially the means necessarily
influence and alter the aims. The whole history of man is continuous proof of
the maxim that to divest one's methods of ethical concepts means to Sink into
the depths of utter demoralisation. In that lies the real tragedy of the
Bolshevik philosophy as applied to the Russian Revolution. May this lesson not
be in vain."_ In summary, _"[n]o revolution can ever succeed as a factor of
liberation unless the MEANS used to further it be identical in spirit and
tendency with the PURPOSES to be achieved."_ [ **My Disillusionment in
Russia** , pp. 260-1]

If this analysis of the anarchists against Bolshevism is true then it follows
that the Bolsheviks were not just wrong on one or two issues but their
political outlook right down to the core was wrong. Its vision of socialism
was flawed, which produced a flawed perspective on the potentially valid means
available to achieve it. Leninism, we must never forget, does not aim for the
same kind of society anarchism does. As we discussed in [section
H.3.1](secH3.md#sech31), the short, medium and long term goals of both
movements are radically different. While both claim to aim for "communism,"
what is mean by that word is radically different in details if somewhat
similar in outline. The anarchist ideal of a classless, stateless and free
society is based on a decentralised, participatory and bottom-up premise. The
Leninist ideal is the product of a centralised, party ruled and top-down
paradigm.

This explains why Leninists advocate a democratic-centralist "Revolutionary
Party." It arises from the fact that their programme is the capture of state
power in order to abolish the _"anarchy of the market."_ Not the abolition of
wage labour, but its universalisation under the state as one big boss. Not the
destruction of alienated forces (political, social and economic) but rather
their capture by the party on behalf of the masses. In other words, this
section of the FAQ is based on the fact that Leninists are not (libertarian)
communists; they have not broken sufficiently with Second International
orthodoxy, with the assumption that socialism is basically state capitalism (
_"The idea of the State as Capitalist, to which the Social-Democratic fraction
of the great Socialist Party is now trying to reduce Socialism."_ [Peter
Kropotkin, The Great French Revolution, vol. 1, p. 31]). Just as one cannot
abolish alienation with alienated means, so we cannot attack Leninist
_"means"_ also without distinguishing our libertarian _"ends"_ from theirs.

This means that both Leninist means and ends are flawed. Both will fail to
produce a socialist society. As Kropotkin said at the time, the Bolsheviks
_"have shown how the Revolution is **not** to be made."_ [quoted by Berkman,
**The Bolshevik Myth** , p. 75] If applied today, Leninist ideas will
undoubtedly fail from an anarchist point of view while, as under Lenin,
"succeeding" from the limited perspective of Bolshevism. Yes, the party may be
in power and, yes, capitalist property may be abolished by nationalisation
but, no, a socialist society would be no nearer. Rather we would have a new
hierarchical and class system rather than the classless and free society which
non-anarchist socialists claim to be aiming for.

Let us be perfectly clear. Anarchists are **not** saying that Stalinism will
be the inevitable result of any Bolshevik revolution. What we are saying is
that some form of class society will result from any such a revolution. The
exact form this class system will take will vary depending on the objective
circumstances it faces, but no matter the specific form of such a post-
revolutionary society it will not be a socialist one. This is because of the
ideology of the party in power will shape the revolution in specific ways
which, by necessity, form new forms of hierarchical and class exploitation and
oppression. The preferred means of Bolshevism (vanguardism, statism,
centralisation, nationalisation, and so on) will determine the ends, the ends
being not communist anarchism but some kind of bureaucratic state capitalist
society labelled _"socialism"_ by those in charge. Stalinism, in this
perspective, was the result of an interaction of certain ideological goals and
positions as well as organisational principles and preferences with structural
and circumstantial pressures resulting from the specific conditions prevalent
at the time. For example, a Leninist revolution in an advanced western country
would not require the barbaric means used by Stalinism to industrialise
Russia.

This section of the FAQ will, therefore, indicate the key areas of Bolshevik
ideology which, when applied, will undermine any revolution as they did the
Russian. As such, it is all fine and well for Trotskyist Max Shachtman (like
so many others) to argue that the Bolsheviks had _"convert[ed] the
expediencies and necessities of the civil war period into virtues and
principles which had never been part of their original program."_ Looking at
this _"original program"_ we can see elements of what was latter to be
applied. Rather than express a divergence it could be argued that it was this
that undermined the more democratic aspects of their original program. In
other words, perhaps the use of state power and economic nationalisation came
into conflict with, and finally destroyed, the original proclaimed socialist
principles? And, perhaps, the _"socialist"_ vision of Bolshevism was so deeply
flawed that even attempting to apply it destroyed the aspirations for liberty,
equality and solidarity that inspired it? For, after all, as we indicated in
[section H.3.1](secH3.md#sech31), the anarchist and mainstream Marxist
visions of socialism and how to get there **are** different. Can we be
surprised if Marxist means cannot achieve anarchist (i.e. authentic socialist)
ends? To his credit, Shachtman acknowledges that post-civil war salvation
"required full democratic rights" for all workers, and that this was
_"precisely what the Bolsheviks . . . were determined not to permit."_ Sadly
he failed to wonder **why** the democratic principles of the _"original
program"_ were only _"honoured in the breach"_ and why _"Lenin and Trotsky did
not observe them."_ The possibility that Bakunin was right and that statism
and socialism cannot go together was not raised. [ _"Introduction"_ to
Trotsky's **Terrorism and Communism** , p. xv]

Equally, there is a tendency of pro-Leninists to concentrate on the period
between the two revolutions of 1917 when specifying what Bolshevism "really"
stood for, particularly Lenin's book State and Revolution. To use an analogy,
when Leninists do this they are like politicians who, when faced with people
questioning the results of their policies, ask them to look at their election
manifesto rather than what they have done when in power. As we discuss in
[section 4](append41.md#app4) of the appendix ["What happened during the
Russian Revolution?"](append41.md) Lenin's book was never applied in
practice. From the very first day, the Bolsheviks ignored it. After 6 months
**none** of its keys ideas had been applied. Indeed, in all cases the exact
opposite had been imposed. As such, to blame (say) the civil war for the
reality of "Bolshevik in power" (as Leninists do) seems without substance.
Simply put, **State and Revolution** is no guide to what Bolshevism "really"
stood for. Neither is their position **before** seizing power if the realities
of their chosen methods (i.e. seizing state power) quickly changed their
perspective, practice **and** ideology (i.e. shaped the desired ends).
Assuming of course that most of their post-October policies were radically
different from their pre-October ones, which (as we indicate here) they were
not.

With that said, what do anarchists consider the key aspects of Bolshevik
ideology which helped to ensure the defeat of the Russian Revolution and had,
long before the civil war started, had started its degeneration into tyranny?
These factors are many and so we will, by necessity, concrete on the key ones.
These are believe in centralisation, the confusion of party power with popular
power, the Marxist theory of the state, the negative influence of Engels'
infamous essay _"On Authority",_ the equation of nationalisation and state
capitalism with socialism, the lack of awareness that working class economic
power was a key factor in socialism, the notion that "big" was automatically
"more efficient," the identification of class consciousness with supporting
the party, how the vanguard party organises itself and, lastly, the underlying
assumptions that vanguardism is based on.

Each one of these factors had a negative impact on the development of the
revolution, combined they were devastating. Nor can it be a case of keeping
Bolshevism while getting rid of some of these positions. Most go to the heart
of Bolshevism and could only be eliminated by eliminating what makes Leninism
Leninist. Thus some Leninists now pay lip service to workers' control of
production and recognise that the Bolsheviks saw the form of property (i.e.,
whether private or state owned) as being far more important that workers'
management of production. Yet revising Bolshevism to take into account this
flaw means little unless the others are also revised. Simply put, workers'
management of production would have little impact in a highly centralised
state ruled over by a equally centralised vanguard party. Self-management in
production or society could not co-exist with a state and party power nor with
_"centralised"_ economic decision making based on nationalised property. In a
nutshell, the only way Bolshevism could result in a genuine socialist society
is if it stopped being Bolshevik!

## 1 How did the Marxist historical materialism affect Bolshevism?

As is well known, Marx argued that history progressed through distinct stages.
After his death, this _"materialist conception of history"_ became known as
_"historical materialism."_ The basic idea of this is that the _"totality of
[the] relations of production constitutes the economic structure of society,
the real foundation, on which arises a legal and political superstructure and
to which correspond definite forms of social consciousness . . . At a certain
stage of development, the material productive forces of society come into
conflict with the existing relations of production or -- this merely expresses
the same thing in legal terms -- with the property relations within the
framework of which they have operated hitherto. From forms of development of
productive forces these relations turn into their fetters. Then begins an era
of social revolution."_ [ **A Contribution to the Critique of Political
Economy** , pp. 20-1]

Thus slavery was replaced by feudalism, feudalism with capitalism. For Marx,
the _"bourgeois mode of production is the last antagonistic form of the social
process of production"_ and _"the productive forces developing within
bourgeois society create also the material conditions for a solution of this
antagonism."_ [ **Op. Cit.** , p. 21] In other words, after capitalism there
would be socialism:

> _"The monopoly of capital becomes a fetter upon the mode of production which
> has flourished alongside and under it. The centralisation of the means of
> production and the socialisation of labour reach a point at which they
> become incompatible with their capitalist integument. The integument is
> burst asunder. The knell of capitalist private property sounds. The
> expropriators are expropriated."_ [Karl Marx, **Capital** , vol. 1, p. 929]

Socialism replaces capitalism once the _" **proletariat seized political power
and turns the means of production into state property."**_ By so doing, _"it
abolishes itself as proletariat, abolishes all class distinctions and class
antagonisms, abolishes also the state as state."_ [Engels, **The Marx-Engels
Reader** , p. 713]

Most Marxists subscribe to this schema of historical progress. For example,
Tony Cliff noted that, _"[f]or Lenin, whose Marxism was never mechanical or
fatalistic, the definition of the dictatorship of the proletariat as a
**transition period** meant that there could be **two** outcomes of this
phase: going forward to socialism, or backsliding to capitalism. The policy of
the party would tip the balance."_ [ **Revolution Besieged** , p. 364]

Marxists, like Marx, argue that socialism was the society which would come
after capitalism. Thus the Bolsheviks had the mindset that whatever they did
there was only two possibilities: (their version of) socialism or the
restoration of capitalism. However, this is based on a false premise. Is it
valid to assume that there is only one possible post-capitalist future, one
that, by definition, is classless? If so, then any action or structure could
be utilised to fight reaction as after victory there can be only one outcome.
However, if there is more that one post-capitalist future then the question of
means becomes decisive. If we assume just two possible post-capitalist
futures, one based on self-management and without classes and another with
economic, social and political power centralised in a few hands, then the
means used in a revolution become decisive in determining which possibility
will become reality.

If we accept the Marxist theory and assume only one possible post-capitalist
system, then all that is required of revolutionary anti-capitalist movements
is that they only need to overthrow capitalism and they will wind up where
they wish to arrive as there is no other possible outcome. But if the answer
no, then in order to wind up where we wish to arrive, we have to not only
overthrow capitalism, we have use means that will push us toward the desired
future society. As such, **means** become the key and they cannot be ignored
or downplayed in favour of the ends -- particularly as these ends will never
be reached if the appropriate means are not used.

This is no abstract metaphysical or ideological/theoretical point. The impact
of this issue can be seen from the practice of Bolshevism in power. For Lenin
and Trotsky, **any** and **all** means could and were used in pursuit of their
ends. They simply could not see how the means used shaped the ends reached.
Ultimately, there was only two possibilities -- socialism (by definition
classless) or a return to capitalism.

Once we see that because of their flawed perspective on what comes after
capitalism we understand why, for the Bolsheviks, the means used and
institutions created were meaningless. We can see one of the roots for
Bolshevik indifference to working class self-management. As Samuel Farber
notes that _"there is no evidence indicating that Lenin or any of the
mainstream Bolshevik leaders lamented the loss of workers' control or of
democracy in the soviets, or at least referred to these losses as a retreat,
as Lenin declared with the replacement of War Communism by NEP in 1921."_ [
**Before Stalinism** , p. 44] There was no need, for such means had no impact
on achieving the ends Bolshevik power had set itself. As we discuss in
[section 6](append44.md#app6), such questions of meaningful working class
participation in the workplace or the soviets were considered by the likes of
Trotsky as fundamentally irrelevant to whether Bolshevik Russia was socialist
or whether the working class was the ruling class or not, incredible as it may
seem.

So if we accept Marx's basic schema, then we simply have to conclude that what
means we use are, ultimately, irrelevant as there is only one outcome. As long
as property is nationalised and a non-capitalist party holds state power, then
the basic socialist nature of the regime automatically flows. This was, of
course, Trotsky's argument with regard to Stalinist Russia and why he defended
it against those who recognised that it was a new form of class society. Yet
it is precisely the rise of Stalinism out of the dictatorship of the
Bolsheviks which exposes the limitations in the Marxist schema of historical
development.

Simply put, there is no guarantee that getting rid of capitalism will result
in a decent society. As anarchists like Bakunin argued against Marx, it is
possible to get rid of capitalism while not creating socialism, if we
understand by that term a free, classless society of equals. Rather, a Marxist
revolution would _"concentrate all the powers of government in strong hands,
because the very fact that the people are ignorant necessitates strong,
solicitous care by the government. [It] will create a single State bank,
concentrating in its hands all the commercial, industrial, agricultural, and
even scientific production; and they will divide the mass of people into two
armies -- industrial and agricultural armies under the direct command of the
State engineers who will constitute the new privileged scientific-political
class."_ [ **The Political Philosophy of Bakunin** , p. 289] As Bolshevism
proved, there **was** always an alternative to socialism or a reversion to
capitalism, in this case **state** capitalism.

So libertarians have long been aware that actually existing capitalism could
be replaced by another form of class society. As the experience of Bolshevik
tyranny proves beyond doubt, this perspective is the correct one. And that
perspective ensured that during the Russian Revolution the Makhnovists **had**
to encourage free soviets and workers' self-management, freedom of speech and
organisation in order for the revolution to remain socialist (see the appendix
on ["Why does the Makhnovist movement show there is an alternative to
Bolshevism?"](append46.md)). In contrast, the Bolsheviks implemented party
dictatorship, nationalisation and one-man management while proclaiming this
had something to do with socialism. Little wonder Trotsky had such
difficulties understanding the obvious truth that Stalinism has **nothing** to
do with socialism.

## 2 Why did the Marxist theory of the state undermine working class power?

As discussed in [section H.3.7](secH3.md#sech37), anarchists and Marxists
have fundamentally different definitions of what constitutes a state. These
different definitions resulted, in practice, to the Bolsheviks undermining
**real** working class power during the Russian Revolution in favour of an
abstract "power" which served as little more than a fig-leaf for Bolshevik
power.

For anarchists, the state is marked by centralised power in the hands of a
few. The state, we argue, is designed to ensure minority rule and,
consequently, cannot be used by the majority to manage their own affairs.
Every bourgeois revolution, moreover, has been marked by a conflict between
centralised power and popular power and, unsurprisingly, the bourgeois
favoured the former over the latter. As such, we would expect centralised
power (i.e. a state) to be the means by which a minority class seized power
**over** the masses and never the means by which the majority managed society
themselves. It was for this reason that anarchists refuse to confuse a
federation of self-managed organisations with a state:

> _"The reader knows by now that the anarchists refused to use the term
> 'State' even for a transitional situation. The gap between authoritarians
> and libertarians has not always been very wide on this score. In the First
> International the collectivists, whose spokesman was Bakunin, allowed the
> terms 'regenerate State,' 'new and revolutionary State,' or even 'socialist
> State' to be accepted as synonyms for 'social collective.' The anarchists
> soon saw, however, that it was rather dangerous for them to use the same
> word as the authoritarians while giving it a quite different meaning. They
> felt that a new concept called for a new word and that the use of the old
> term could be dangerously ambiguous; so they ceased to give the name 'State'
> to the social collective of the future."_ [Daniel Guerin, **Anarchism** ,
> pp. 60-1]

This is no mere semantics. The essence of statism is the removal of powers
that should belong to the community as whole (though they may for reasons of
efficiency delegate their actual implementation to elected, mandated and
recallable committees) into the hands of a tiny minority who claim to act on
our behalf and in our interests but who are not under our direct control. In
other words it continues the division into rulers and ruled. Any confusion
between two such radically different forms of organisation can only have a
seriously negative effect on the development of any revolution. At its most
basic, it allows those in power to develop structures and practices which
disempower the many while, at the same time, taking about extending working
class "power."

The roots of this confusion can be found at the root of Marxism. As discussed
in [section H.3.7](secH3.md#sech37), Marx and Engels had left a somewhat
contradictory inheritance on the nature and role of the state. Unlike
anarchists, who clearly argued that only confusion would arise by calling the
organs of popular self-management required by a revolution a _"state,"_ the
founders of Marxism confused two radically different ideas. On the one hand,
there is the idea of a radical and participatory democracy (as per the model
of the Paris Commune). On the other, there is a centralised body with a
government in charge (as per the model of the democratic state). By using the
term _"state"_ to cover these two radically different concepts, it allowed the
Bolsheviks to confuse party power with popular power and, moreover, replace
the latter by the former without affecting the so-called "proletarian" nature
of the state. The confusion of popular organs of self-management with a state
ensured that these organs **were** submerged by state structures and top-down
rule.

By confusing the state (delegated power, necessarily concentrated in the hands
of a few) with the organs of popular self-management Marxism opened up the
possibility of a _"workers' state"_ which is simply the rule of a few party
leaders over the masses. The _"truth of the matter,"_ wrote Emma Goldman, _"is
that the Russian people have been **locked out** and that the Bolshevik State
-- even as the bourgeois industrial master -- uses the sword and the gun to
keep the people out. In the case of the Bolsheviki this tyranny is masked by a
world-stirring slogan . . . Just because I am a revolutionist I refuse to side
with the master class, which in Russia is called the Communist Party."_ [ **My
Disillusionment in Russia** , p. xlix] In this, she simply saw in practice
that which Bakunin had predicted would happen. For Bakunin, like all
anarchists, _"every state power, every government, by its nature and by its
position stands outside the people and above them, and must invariably try to
subject them to rules and objectives which are alien to them."_ It was for
this reason _"we declare ourselves the enemies of every government and state
every state power . . . the people can only be happy and free when they create
their own life, organising themselves from below upwards."_ [ **Statism and
Anarchy** , p. 136]

The _"workers' state"_ proved no exception to that generalisation. The roots
of the problem, which expressed itself from the start during the Russian
revolution, was the fatal confusion of the state with organs of popular self-
management. Lenin argued in _"State and Revolution"_ that, on the one hand,
_"the armed proletariat itself shall **become the government** "_ while, on
the other, that _"[w]e cannot imagine democracy, not even proletarian
democracy, without representative institutions."_ If, as Lenin asserts,
democracy _"means equality"_ he has reintroduced inequality into the
"proletarian" state as the representatives have, by definition, more power
than those who elected them. [ **Essential Works of Lenin** , p. 363, p. 306
and p. 346] Yet, as noted in [section H.1.2](secH1.md#sech12),
representative bodies necessarily place policy-making in the hands of deputies
and do not (and cannot) mean that the working class **as a class** can manage
society. Moreover, such bodies ensure that popular power can be usurped
without difficulty by a minority. After all, a minority already **does** hold
power.

True equality implies the abolition of the state and its replacement by a
federation of self-managed communes. The state, as anarchists have long
stressed, signifies a power **above** society, a concentration of power into a
few hands. Lenin, ironically, quotes Engels on the state being marked by _"the
establishment of a **public power,** which is no longer directly identical
with the population organising itself as an armed power."_ [quoted by Lenin,
**Op. Cit.** , p. 275] As Lenin supported **representative** structures rather
than one based on elected, mandated and recallable **delegates** then he has
created a _"public power"_ no longer identical with the population.

Combine this with an awareness that bureaucracy must continue to exist in the
"proletarian" state then we have the ideological preconditions for
dictatorship **over** the proletariat. _"There can be no thought,"_ asserted
Lenin, _"of destroying officialdom immediately everywhere, completely. That is
utopia. But to **smash** the old bureaucratic machine at once and to begin
immediately to construct a new one that will enable all officialdom to be
gradually abolished is **not** utopia."_ In other words, Lenin expected _"the
gradual 'withering away' of all bureaucracy."_ [ **Op. Cit.** , p. 306 and p.
307]

Yet why expect a "new" bureaucracy to be as easy to control as the old one?
Regular election to posts does not undermine the institutional links,
pressures and powers a centralised "officialdom" will generate around itself,
even a so-called "proletarian" one. Significantly, Lenin justified this
defence of temporary state bureaucracy by the kind of straw man argument
against anarchism _"State and Revolution"_ is riddled with. _"We are not
utopians,"_ asserted Lenin, _"we do not indulge in 'dreams' of dispensing **at
once** with all administration, with all subordination: these anarchist dreams
. . . are totally alien to Marxism, and, as a matter of fact, serve only to
postpone the socialist revolution until human nature has changed. No, we want
the socialist revolution with human nature as it is now, with human nature
that cannot dispense with subordination, control and 'managers.'"_ [ **Op.
Cit.** , p. 307] Yet anarchists do not wish to _"dispense"_ with _"all
administration,"_ rather we wish to replace government **by** administration,
hierarchical positions ( _"subordination"_ ) with co-operative organisation.
Equally, we see the revolution as a process in which _"human nature"_ is
changed by the struggle itself so that working class people become capable of
organising itself and society without bosses, bureaucrats and politicians. If
Lenin says that socialism _"cannot dispense"_ with the hierarchical structures
required by class society why should we expect the same kinds of structures
and social relationships to have different ends just because _"red"_ managers
are in power?

Thus Lenin's work is deeply ambiguous. He is confusing popular self-management
with a state structure. Anarchists argue that states, by their very nature,
are based on concentrated, centralised, alienated power in the hands of a few.
Thus Lenin's _"workers' state"_ is just the same as any other state, namely
rule by a few over the many. This is confirmed when Lenin argues that
_"[u]nder socialism, **all** will take part in the work of government in turn
and will soon become accustomed to no one governing."_ In fact, once the
_"overwhelming majority"_ have _"learned to administer the state
**themselves** , have taken this business into their own hands . . . the need
for government begins to disappear. The more complete democracy becomes, the
nearer the moment approaches when it becomes unnecessary. The more democratic
the 'state' of the armed workers -- which is 'no longer a state in the proper
sense of the word' -- becomes, the more rapidly does **the state** begin to
wither away."_ Moreover, _"[u]ntil the 'higher' phase of communism arrives,
the Socialists demand the **strictest** control, by society **and by the
state,** of the amount of labour and of consumption."_ [ **Op. Cit.** , p.
361, p. 349 and p. 345]

Clearly, the "proletarian" state is **not** based on direct, mass,
participation by the population but, in fact, on giving power to a few
representatives. It is **not** identical with _"society,"_ i.e. the armed,
self-organised people. Rather than look to the popular assemblies of the
French revolution, Lenin, like the bourgeoisie, looked to representative
structures -- structures designed to combat working class power and influence.
(at one point Lenin states that _"for a certain time not only bourgeois right,
but even the bourgeois state remains under communism, without the
bourgeoisie!"_ This was because _"bourgeois right in regard to the
distribution of articles of **consumption** inevitably presupposes the
existence of the **bourgeois state,** for right is nothing without an
apparatus capable of **enforcing** the observance of the standards of right."_
[ **Op. Cit.** , p. 346]).

Can we expect the same types of organs and social relationships to produce
different results simply because Lenin is at the head of the state? Of course
not.

As the Marxist theory of the state confused party/vanguard power with working
class power, we should not be surprised that Lenin's _"State and Revolution"_
failed to discuss the practicalities of this essential question in anything
but a passing and ambiguous manner. For example, Lenin notes that _"[b]y
educating the workers' party, Marxism educates the vanguard of the proletariat
which is capable of assuming power and of **leading the whole people** to
socialism, of directing and organising the new order."_ [ **Op. Cit.** , p.
288] It is not clear whether it is the vanguard or the proletariat as a whole
which assumes power. Later, he states that _"the dictatorship of the
proletariat"_ was _"the organisation of the vanguard of the oppressed as the
ruling class for the purpose of crushing the oppressors."_ [ **Op. Cit.** , p.
337] Given that this fits in with subsequent Bolshevik practice, it seems
clear that it is the vanguard which assumes power rather than the whole class.
The negative effects of this are discussed in [section 8](append44.md#app8).

However, the assumption of power by the party highlights the key problem with
the Marxist theory of the state and how it could be used to justify the
destruction of popular power. It does not matter in the Marxist schema whether
the class or the party is in power, it does not impact on whether the working
class is the _"ruling class"_ or not. As Lenin put it. _"democracy is **not**
identical with the subordination of the minority to the majority. Democracy is
a **state** which recognises the subordination of the minority to the
majority, i.e. an organisation for the systematic use of **violence** by one
class against the other, by one section of the population against another."_ [
**Op. Cit.** , p. 332] Thus the majority need not actually _"rule"_ (i.e. make
the fundamental decisions) for a regime to be considered a _"democracy"_ or an
instrument of class rule. That power can be delegated to a party leadership
(even dictatorship) without harming the _"class nature"_ of the state. This
results of such a theory can be seen from Bolshevik arguments in favour of
party dictatorship during the civil war period (and beyond).

The problem with the centralised, representative structures Lenin favours for
the _"dictatorship of the proletariat"_ is that they are rooted in the
inequality of power. They constitute in fact, if not initially in theory, a
power **above** society. As Lenin put it, _"the **essence** of bureaucracy"_
is _"privileged persons divorced from the masses and **superior to** the
masses."_ [ **Op. Cit.** , p. 360] In the words of Malatesta, a _"government,
that is a group of people entrusted with making laws and empowered to use the
collective power to oblige each individual to obey them, is already a
privileged class and cut off from the people. As any constituted body would
do, it will instinctively seek to extend its powers, to be beyond public
control, to impose its own policies and to give priority to its special
interests. Having been put in a privileged position, the government is already
at odds with the people whose strength it disposes of."_ [ **Anarchy** , p.
34] As we discussed in appendix ["What happened during the Russian
Revolution?"](append41.md), Lenin's regime provides more than enough
evidence to support such an analysis.

This is the fatal flaw in the Marxist theory of the state. As Bakunin put it,
_"the theory of the state"_ is _"based on this fiction of pseudo-popular
representation -- which in actual fact means the government of the masses by
an insignificant handful of privileged individuals, elected (or even not
elected) by mobs of people rounded up for voting and never knowing what or
whom they are voting for -- on this imaginary and abstract expression of the
imaginary thought and will of the all the people, of which the real, living
people do not have the faintest idea."_ Thus the state represents _"government
of the majority by a minority in the name of the presumed stupidity of the one
and the presumed intelligence of the other."_ [ **Op. Cit.** , pp. 136-7]

By confusing popular participation with a state, by ignoring the real
inequalities of power in any state structure, Marxism allowed Lenin and the
Bolsheviks to usurp state power, implement party dictatorship **and** continue
to talk about the working class being in power. Because of Marxism's
metaphysical definition of the state (see [section H.3.7](secH3.md#sech37)),
actual working class people's power over their lives is downplayed, if not
ignored, in favour party power.

As parties represent classes in this schema, if the party is in power then, by
definition, so is the class. This raises the possibility of Lenin asserting
the _"working class"_ held power even when his party was exercising a
dictatorship **over** the working class and violently repressing any protests
by it. As one socialist historian puts it, _"while it is true that Lenin
recognised the different functions and democratic raison d'etre for both the
soviets and his party, in the last analysis it was the party that was more
important than the soviets. In other words, the party was the final repository
of working-class sovereignty. Thus, Lenin did not seem to have been reflected
on or have been particularly perturbed by the decline of the soviets after
1918."_ [Samuel Farber, **Before Stalinism** , p. 212] This can be seen from
how the Marxist theory of the state was changed **after** the Bolsheviks
seized power to bring into line with its new role as the means by which the
vanguard ruled society (see [section H.3.8](secH3.md#sech38)).

This confusion between two radically different concepts and their submersion
into the term _"state"_ had its negative impact from the start. Firstly, the
Bolsheviks constantly equated rule by the Bolshevik party (in practice, its
central committee) with the working class as a whole. Rather than rule by all
the masses, the Bolsheviks substituted rule by a handful of leaders. Thus we
find Lenin talking about _"the power of the Bolsheviks -- that is, the power
of the proletariat"_ as if these things were the same. Thus it was a case of
_"the Bolsheviks"_ having _"to take the whole governmental power into their
own hands,"_ of _"the complete assumption of power by the Bolsheviks alone,"_
rather than the masses. Indeed, Russia had been _"ruled by 130,000
landowners"_ and _"yet they tell us that Russia will not be able to be
governed by the 240,000 members of the Bolshevik Party -- governing in the
interests of the poor and against the rich."_ [ **Will the Bolsheviks Maintain
Power?** , p. 102, p. 7 and pp. 61-2]

However, governing in the _"interests"_ of the poor is **not** the same as the
poor governing themselves. Thus we have the first key substitution that leads
to authoritarian rule, namely the substitution of the power of the masses by
the power of a few members who make up the government. Such a small body will
require a centralised state system and, consequently, we have the creation of
a hierarchical body around the new government which, as we discuss in [section
7](append44.md#app7), will become the real master in society.

The preconditions for a new form of class society have been created and,
moreover, they are rooted in the basic ideas of Marxism. Society has been
split into two bodies, the masses and those who claim to rule in their name.
Given this basic inequality in power we would, according to anarchist theory,
expect the interests of the masses and the rulers to separate and come into
conflict. While the Bolsheviks had the support of the working class (as they
did in the first few months of their rule), this does not equal mass
participation in running society. Quite the reverse. So while Lenin raised the
vision of mass participation in the _"final"_ stage of communism, he
unfortunately blocked the means to get there.

Simply put, a self-managed society can only be created by self-managed means.
To think we can have a _"public power"_ separate from the masses which will,
slowly, dissolve itself into it is the height of naivety. Unsurprisingly, once
in power the Bolsheviks held onto power by all means available, including
gerrymandering and disbanding soviets, suppressing peaceful opposition parties
and violently repressing the very workers it claimed ruled in _"soviet"_
Russia (see [section 6](append41.md#app6) of the appendix ["What happened
during the Russian Revolution?"](append41.md)). Significantly, this conflict
developed before the start of the civil war (see [section
3](append43.md#app3) of the appendix on ["What caused the degeneration of
the Russian Revolution?"](append43.md) for details). So when popular support
was lost, the basic contradictions in the Bolshevik position and theory became
clear. Rather than be a _"soviet"_ power, the Bolshevik regime was simply rule
over the workers in their name, nothing more. And equally unsurprising, the
Leninists revised their theory of the state to take into account the realities
of state power and the need to justify minority power **over** the masses (see
[section H.3.8](secH3.md#sech38)).

Needless to say, even electoral support for the Bolsheviks should not and
cannot be equated to working class management of society. Echoing Marx and
Engels at their most reductionist (see [section H.3.9](secH3.md#sech39)),
Lenin stressed that the state was _"an organ or machine for the subjection of
one class by another . . . when the State has become proletarian, when it has
become a machine for the domination of the proletariat over the bourgeoisie,
then we shall fully and unreservedly for a strong government and centralism."_
[ **Op. Cit.** , p. 75] The notions that the state could have interests of its
own, that it is not simply an instrument of class rule but rather **minority**
class rule are nowhere to be found. The implications of this simplistic
analysis had severe ramifications for the Russian Revolution and Trotskyist
explanations of both Stalinism and its rise.

Which brings us to the second issue. It is clear that by considering the state
simply as an instrument of class rule Lenin could downplay, even ignore, such
important questions of **how** the working class can _"rule"_ society, how it
can be a _"ruling"_ class. Blinded by the notion that a state could not be
anything **but** an instrument of class rule, the Bolsheviks simply were able
to justify any limitation of working class democracy and freedom and argue
that it had no impact on whether the Bolshevik regime was really a
"dictatorship of the proletariat" or not. This can be seen from Lenin's
polemic with German Social-Democrat Karl Kautsky, where he glibly stated that
_" **[t]he form of government,** has absolutely nothing to so with it."_ [
**Collected Works** , vol. 28, p. 238]

Yet the idea that there is a difference between **who** rules in a
revolutionary situation and **how** they rule is a key one, and one raised by
the anarchists against Marxism. After all, if the working class is politically
expropriated how can you maintain that a regime is remotely "proletarian"?
Ultimately, the working class can only _"rule"_ society through its collective
participation in decision making (social, economic and "political"). If
working class people are not managing their own affairs, if they have
delegated that power to a few party leaders then they are **not** a ruling
class and could never be. While the bourgeoisie can, and has, ruled
economically under an actual dictatorship, the same cannot be said to be the
case with the working class. Every class society is marked by a clear division
between order takers and order givers. To think that such a division can be
implemented in a socialist revolution and for it to remain socialist is pure
naivety. As the Bolshevik revolution showed, representative government is the
first step in the political expropriation of the working class from control
over their fate.

This can best be seen by Trotsky's confused analyses of Stalinism. He simply
could not understand the nature of Stalinism with the simplistic analytical
tools he inherited from mainstream Marxism and Bolshevism. Thus we find him
arguing in 1933 that:

> _"The dictatorship of a class does not mean by a long shot that its entire
> mass always participates in the management of the state. This we have seen,
> first of all, in the case of the propertied classes. The nobility ruled
> through the monarchy before which the noble stood on his knees. The
> dictatorship of the bourgeoisie took on comparatively developed democratic
> forms only under the conditions of capitalist upswing when the ruling class
> had nothing to fear. Before our own eyes, democracy has been supplanted in
> Germany by Hitler's autocracy, with all the traditional bourgeois parties
> smashed to smithereens. Today, the German bourgeoisie does not rule
> directly; politically it is placed under complete subjection to Hitler and
> his bands. Nevertheless, the dictatorship of the bourgeoisie remains
> inviolate in Germany, because all the conditions of its social hegemony have
> been preserved and strengthened. By expropriating the bourgeoisie
> politically, Hitler saved it, even if temporarily, from economic
> expropriation. The fact that the bourgeoisie was compelled to resort to the
> fascist regime testifies to the fact that its hegemony was endangered but
> not at all that it had fallen."_ [Trotsky, **The Class Nature Of The Soviet
> State** ]

Yet Trotsky is confusing the matter. He is comparing the actions of class
society with those a socialist revolution. While a minority class need not
_"participate"_ **en mass** the question arises does this apply to the
transition from class society to a classless one? Can the working class
**really** can be _"expropriated"_ politically and still remain _"the ruling
class"_? Moreover, Trotsky fails to note that the working class was
**economically** and **politically** expropriated under Stalinism as well.
This is unsurprising, as both forms of expropriation had occurred when he and
Lenin held the reins of state power. Yet Trotsky's confused ramblings do serve
a purpose in showing how the Marxist theory of the state can be used to
rationalise the replacement of popular power by party power. With such
ideological baggage, can it be a surprise that the Bolshevik replacement of
workers' power by party power could be a revolutionary goal? Ironically, the
Marxist theory of the state as an instrument of class rule helped ensure that
the Russian working class did **not** become the ruling class post-October.
Rather, it ensured that the Bolshevik party did.

To conclude, by its redunctionist logic, the Marxist theory of the state
ensured that the substitution of popular power by party power could go ahead
and, moreover, be justified ideologically. The first steps towards party
dictatorship can be found in such apparently "libertarian" works as Lenin's
_"State and Revolution"_ with its emphasis on "representation" and
"centralisation." The net effect of this was to centralise power into fewer
and fewer hands, replacing the essential constructive working class
participation and self-activity required by a social revolution with top-down
rule by a few party leaders. Such rule could not avoid becoming bureaucratised
and coming into conflict with the real aspirations and interests of those it
claimed to represent. In such circumstances, in a conflict between the
_"workers' state"_ and the actual workers the Marxist theory of the state,
combined with the assumptions of vanguardism, made the shift to party
dictatorship inevitable. As we discussed in [section 3](append43.md#app3) of
the appendix on ["What caused the degeneration of the Russian
Revolution?"](append43.md), authoritarian tendencies had surfaced before the
civil war began.

The strange paradox of Leninism, namely that the theoretical dictatorship of
the proletariat was, in practice, a dictatorship **over** the proletariat
comes as no surprise. In spite of Lenin announcing _"all power to the
soviets"_ he remained committed to a disciplined party wielding centralised
power. This regime soon expropriated the soviets while calling the subsequent
regime "Soviet." Rather that create the authoritarian tendencies of the
Bolshevik state the "objective factors" facing Lenin's regime simply increased
their impact. The preconditions for the minority rule which the civil war
intensified to extreme levels already existed within Marxist theory.
Consequently, a Leninist revolution which avoided the (inevitable) problems
facing a revolution would still create some kind of class society simply
because it reproduces minority rule by creating a _"workers' state"_ as its
first step. Sadly, Marxist theory confuses popular self-government with a
state so ensuring the substitution of rule by a few party leaders for the
popular participation required to ensure a successful revolution.

## 3 How did Engels' essay _"On Authority"_ affect the revolution?

We have discussed Engels' infamous diatribe against anarchism already (see
[section H.4](secH4.md) and subsequent sections). Here we discuss how its
caricature of anarchism helped disarm the Bolsheviks theoretically to the
dangers of their own actions, so helping to undermine the socialist potential
of the Russian revolution. While the Marxist theory of the state, with its
ahistoric and ambiguous use of the word "state" undermined popular autonomy
and power in favour of party power, Engels' essay _"On Authority"_ helped
undermine popular self-management.

Simply put, Engels essay contained the germs from which Lenin and Trotsky's
support for one-man management flowed. He provided the Marxist orthodoxy
required to undermine real working class power by confusing all forms of
organisation with _"authority"_ and equating the necessity of self-discipline
with _"subordination"_ to one will. Engels' infamous essay helped Lenin to
destroy self-management in the workplace and replace it with appointed _"one-
man management"_ armed with _"dictatorial powers."_

For Lenin and Trotsky, familiar with Engels' _"On Authority,"_ it was a truism
that any form of organisation was based on _"authoritarianism"_ and,
consequently, it did not really matter **how** that _"authority"_ was
constituted. Thus Marxism's agnostic attitude to the patterns of domination
and subordination within society was used to justify one-man management and
party dictatorship. Indeed, _"Soviet socialist democracy and individual
management and dictatorship are in no way contradictory . . . the will of a
class may sometimes be carried by a dictator, who sometimes does more alone
and is frequently more necessary."_ [Lenin, **Collected Works** , vol. 30, p.
476]

Like Engels, Lenin defended the principle of authority. The dictatorship of
the Party over the proletariat found its apology in this principle, thoroughly
grounded in the practice of bureaucracy and modern factory production.
Authority, hierarchy, and the need for submission and domination is inevitable
given the current mode of production, they argued. And no foreseeable change
in social relations could ever overcome this blunt necessity. As such, it was
(fundamentally) irrelevant **how** a workplace is organised as, no matter
what, it would be _"authoritarian."_ Thus _"one-man management"_ would be,
basically, the same as worker's self-management via an elected factory
committee.

For Engels, any form of joint activity required as its _"first condition"_ a
_"dominant will that settles all subordinate questions, whether this will is
represented by a single delegate or a committee charged with the execution of
the resolutions of the majority of persons interested. In either case there is
very pronounced authority."_ Thus the _"necessity of authority, and of
imperious authority at that."_ Collective life, he stressed, required _"a
certain authority, no matter how delegated"_ and _"a certain subordination,
are things which, independently of all social organisation, are imposed upon
us."_ [ **The Marx-Engels Reader** , p. 732]

Lenin was aware of these arguments, even quoting from this essay in his
**State and Revolution**. Thus he was aware that for Engels, collective
decisions meant _"the will of the single individual will always have to
subordinate itself, which means that questions are settled in an authoritarian
way."_ Thus there was no difference if _"they are settled by decision of a
delegate placed at the head of each branch of labour or, if possible, by a
majority vote."_ The more advanced the technology, the greater the
_"despotism"_ : _"The automatic machinery of a big factory is much more
despotic than the small capitalist who employ workers ever have been."_ [
**Op. Cit.** , p. 731] Thus Engels had used the modern factory system of mass
production as a direct analogy to argue against the anarchist call for
workers' councils and self-management in production, for workers' autonomy and
participation. Like Engels, Lenin stressed the necessity of central authority
in industry.

It can be argued that it was this moment that ensured the creation of state
capitalism under the Bolsheviks. This is the moment in Marxist theory when the
turn from economics to technics, from proletarian control to technocracy, from
workers' self-management to appointed state management was ensured. Henceforth
the end of any critique of alienation in mainstream Marxism was assured.
Submission to technique under hierarchical authority effectively prevents
active participation in the social production of values. And there was no
alternative.

As noted in [section 8](append41.md#app8) of the appendix ["What happened
during the Russian Revolution?"](append41.md)). and [section
H.3.14](secH3.md#sech314), during 1917 Lenin did not favour workers' self-
management of production. He raised the idea of _"workers' control"_ after the
workers spontaneously raised the idea and practice themselves during the
revolution. Moreover, he interpreted that slogan in his own way, placing it
within a statist context and within institutions inherited from capitalism
(see [section H.3.12](secH3.md#sech312)). Once in power, it was
(unsurprisingly) **his** vision of socialism and workers' control that was
implemented, **not** the workers' factory committees. The core of that vision
he repeatedly stressed had been raised **before** the October revolution.

This vision can be best seen in **The Immediate Tasks of the Soviet
Government** , written by Lenin and published on the 25th of April 1918. This
occurred before the start of the civil war and, indeed, he starts by arguing
that _"[t]hanks to the peace which has been achieved"_ the Bolsheviks had
_"gained an opportunity to concentrate its efforts for a while on the most
important and most difficult aspect of the socialist revolution, namely the
task of organisation."_ The Bolsheviks, who had _"managed to complete the
conquest of power,"_ now faced _"the principal task of convincing people"_ and
doing _" **practical organisational work.** "_ Only when this was done _"will
it be possible to say that Russia **has become** not only a Soviet, but also a
socialist, republic."_ [ **The Immediate Tasks of the Soviet Government** , p.
2 and p. 8]

Sadly, this _"organisation"_ was riddled with authoritarianism and was
fundamentally top-down in nature. His "socialist" vision was simply state
capitalism (see [section 10](append41.md#app10) of the appendix ["What
happened during the Russian Revolution?"](append41.md)). However, what
interests us here is that his arguments to justify the "socialist" policies he
presented are similar to those put forward by Engels in _"On Authority."_ As
such, we can only reach the following conclusions. Firstly, that the _"state
capitalist"_ vision of socialism imposed upon Russia by the Bolsheviks was
what they had always intended to introduce. It was their limited support for
workers' control in 1917 that was atypical and not part of their tradition,
**not** their policies once in power (as modern day Leninists assert).
Secondly, that this vision had its roots in classical Marxism, specifically
Engels' _"On Authority"_ and the identification of socialism with nationalised
property (see [section H.3.13](secH3.md#sech313) for more on this).

That Engels diatribe had a negative impact on the development of the Russian
revolution can easily be seen from Lenin's arguments. For example, Lenin
argues that the _"tightening of discipline"_ and _"harmonious organisation"_
calls _"for coercion -- coercion precisely in the form of dictatorship."_ He
did not object to granting _"individual executives dictatorial power (or
'unlimited' powers)"_ and did not think _"the appointment of individual,
dictators with unlimited power"_ was incompatible with _"the fundamental
principles of the Soviet government."_ After all, _"the history of
revolutionary movements"_ had _"shown"_ that _"the dictatorship of individuals
was very often the expression, the vehicle, the channel of the dictatorship of
revolutionary classes."_ He notes that _"[u]ndoubtably, the dictatorship of
individuals was compatible with bourgeois democracy."_ [ **Op. Cit.** , p. 28
and p. 32] It would be churlish to note that previous revolutionary movements
had not been **socialist** in nature and did not aim to **abolish** classes.
In such cases, the government appointing people with dictatorial powers would
not have harmed the nature of the revolution, which was transferring power
from one minority class to another.

Lenin mocked the _"exceedingly poor arguments"_ of those who objected, saying
that they _"demand of us a higher democracy than bourgeois democracy and say:
personal dictatorship is absolutely incompatible with your, Bolshevik (i.e.
not bourgeois, **but socialist** ) Soviet democracy."_ As the Bolsheviks were
_"not anarchists,"_ he admitted the need _"coercion"_ in the _"transition from
capitalism to socialism,"_ its form being determined _"by the degree of
development of the given revolutionary class, and also by special
circumstances."_ In general, he stressed, there was _"absolutely **no**
contradiction in principle between Soviet ( **that is,** socialist) democracy
and the exercise of dictatorial powers by individuals."_ [ **Op. Cit.** , pp.
32-3 and p. 33] Which is, of course, sophistry as dictatorship by a few people
in some aspects of live will erode democracy in others. For example, being
subject to the economic power of the capitalist during work harms the
individual and reduces their ability to participate in other aspects of social
life. Why should being subject to "red" bosses be any different?

In particular, Lenin argued that _"individual dictatorial power"_ was required
because _"large-scale machine industry"_ (which is the _"foundation of
socialism"_ ) calls for _"absolute and strict **unity of will,** which directs
the joint labours of hundreds, thousands and tens of thousands of people. . .
But how can strict unity of will be ensured? By thousands subordinating their
will to the will of one."_ He reiterated that the _" **unquestioning
subordination** to a single will is absolutely necessary for the success of
processes organised on the pattern of large-scale machine industry."_ The
people must _" **unquestioningly obey the single will** of the leaders of
labour."_ And so it was a case (for the workers, at least) of _"[o]bedience,
and unquestioning obedience at that, during work to the one-man decisions of
Soviet directors, of the dictators elected or appointed by Soviet
institutions, vested with dictatorial powers."_ [ **Op. Cit.** , p. 33, p. 34
and p. 44]

The parallels with Engels' _"On Authority"_ could not be clearer, as are the
fallacies of Lenin's assertions (see, for example, [section
H.4.4](secH4.md#sech44)). Lenin, like Engels, uses the example of modern
industry to bolster his arguments. Yet the net effect of Lenin's argument was
to eliminate working class economic power at the point of production. Instead
of socialist social relationships, Lenin imposed capitalist ones. Indeed, no
capitalist would disagree with Lenin's workplace regime -- they try to create
such a regime by breaking unions and introducing technologies and techniques
which allow them to control the workers. Unsurprisingly, Lenin also urged the
introduction of two such techniques, namely _"piece-work"_ and _"applying much
of what is scientific and progressive in the Taylor system."_ [ **Op. Cit.** ,
pp. 23-4] As Trotskyist Tony Cliff reminds us, _"the employers have at their
disposal a number of effective methods of disrupting th[e] unity [of workers
as a class]. Once of the most important of these is the fostering of
competition between workers by means of piece-work systems."_ He notes that
these were used by the Nazis and the Stalinists _"for the same purpose."_ [
**State Capitalism in Russia** , pp. 18-9] Obviously piece-work is different
when Lenin introduces it! Similarly, when Trotsky notes that _"[b]lind
obedience is not a thing to be proud of in a revolutionary,"_ it is somewhat
different when Lenin calls upon workers to do so (or, for that matter, Trotsky
himself when in power -- see [section 6](append44.md#app6) for Trotsky's
radically different perspective on blind obedience of the worker to "his"
state in 1920!). [ **Terrorism and Communism** , p. xlvii]

The **economic** dominance of the bourgeoisie ensures the political
dispossession of the working class. Why expect the introduction of capitalist
social relations in production to have different outcomes just because Lenin
was the head of the government? In the words of libertarian socialist Maurice
Brinton:

> _"We hold that the 'relations of production' -- the relations which
> individuals or groups enter into with one another in the process of
> producing wealth - are the essential foundations of any society. A certain
> pattern of relations of production is the common denominator of all class
> societies. This pattern is one in which the producer does not dominate the
> means of production but on the contrary both is 'separated from them' and
> from the products of his own labour. In all class societies the producer is
> in a position of subordination to those who manage the productive process.
> Workers' management of production -- implying as it does the total
> domination of the producer over the productive process -- is not for us a
> marginal matter. It is the core of our politics. It is the only means
> whereby authoritarian (order-giving, order-taking) relations in production
> can be transcended and a free, communist or anarchist, society introduced._
>
> _"We also hold that the means of production may change hands (passing for
> instance from private hands into those of a bureaucracy, collectively owning
> them) with out this revolutionising the relations of production. Under such
> circumstances -- and whatever the formal status of property -- the society
> is still a class society for production is still managed by an agency other
> than the producers themselves. Property relations, in other words, do not
> necessarily reflect the: relations of production. They may serve to mask
> them -- and in fact they often have."_ [ **The Bolsheviks and Workers'
> Control** , p. vii-viii]

The net effect of Lenin's arguments, as anarchist Peter Arshinov noted a few
years later, was that the _"fundamental fact"_ of the Bolshevik revolution was
_"that the workers and the peasant labourers remained within the earlier
situation of 'working classes' -- producers managed by authority from above."_
He stressed that Bolshevik political and economic ideas may have _"remov[ed]
the workers from the hands of individual capitalists"_ but they _"delivered
them to the yet more rapacious hands of a single ever-present capitalist boss,
the State. The relations between the workers and this new boss are the same as
earlier relations between labour and capital . . . Wage labour has remained
what it was before, expect that it has taken on the character of an obligation
to the State. . . . It is clear that in all this we are dealing with a simple
substitution of State capitalism for private capitalism."_ [ **The History of
the Makhnovist Movement** , p. 35 and p. 71] Moreover, Lenin's position failed
to understand that unless workers have power at the point of production, they
will soon loose it in society as a whole. Which, of course, they soon did in
Bolshevik Russia, even in the limited form of electing a "revolutionary"
government.

So while the causes of the failure of the Russian Revolution were many fold,
the obvious influence of Engels' _"On Authority"_ on the fate of the workers'
control movement should be noted. After all, Engels' argument confuses the
issues that Bakunin and other anarchists were trying to raise (namely on the
nature of the organisations we create and our relationships with others). If,
as Engels' argues, all organisation is _"authoritarian,"_ then does this mean
that there no real difference between organisational structures? Is a
dictatorship just the same as a self-managed group, as they are both
organisations and so both _"authoritarian"_? If so, surely that means the
kinds of organisation we create are irrelevant and what **really** matters is
state ownership? Such logic can only lead to the perspective that working
class self-management of production is irrelevant to socialism and,
unfortunately, the experience of the Russian Revolution tends to suggest that
for mainstream Marxism this is the case. The Bolsheviks imposed distinctly
authoritarian social structures while arguing that they were creating
socialism.

Like Engels, the Bolsheviks defended the principle of authority. The
dictatorship of the Party over the proletariat in the workplace (and, indeed,
elsewhere) ultimately found its apology in this principle, thoroughly grounded
in the practice of bureaucracy and modern factory production. Authority,
hierarchy, and the need for submission and domination is inevitable, given the
current mode of production, they argued. And, as Engels had stressed, no
foreseeable change in social relations could ever overcome this blunt
necessity. As such, it was (fundamentally) irrelevant for the leading
Bolsheviks **how** a workplace is organised as, no matter what, it would be
_"authoritarian."_ Thus _"one-man management"_ would be, basically, the same
as worker's self-management via an elected factory committee. As Trotsky made
clear in 1920, for the Bolsheviks the _"dictatorship of the proletariat is
expressed in the abolition of private property in the means of production, in
the supremacy over the whole Soviet mechanism of the collective will of the
workers [i.e. the party, which Trotsky cheerfully admits is exercising a
**party** dictatorship], and not at all in the form in which individual
economic enterprises are administered."_ Thus, it _"would be a most crying
error to confuse the question as to the supremacy of the proletariat with the
question of boards of workers at the head of the factories."_ [ **Terrorism
and Communism** , p. 162]

By equating _"organisation"_ with _"authority"_ (i.e. hierarchy) and
dismissing the importance of revolutionising the social relationships people
create between themselves, Engels opened the way for the Bolsheviks' advocacy
of _"one-man management."_ His essay is at the root of mainstream Marxism's
agnostic attitude to the patterns of domination and subordination within
society and was used to justify one-man management. After all, if Engels was
right, then it did not matter **how** the workplace was organised. It would,
inherently, be _"authoritarian"_ and so what mattered, therefore, was who
owned property, **not** how the workplace was run. Perhaps, then, _"On
Authority"_ was a self-fulfilling prophecy -- by seeing any form of
organisation and any form of advanced technology as needing hierarchy,
discipline and obedience, as being "authoritarian," it ensured that mainstream
Marxism became blinded to the key question of **how** society was organised.
After all, if _"despotism"_ was a fact of life within industry regardless of
how the wider society was organised, then it does not matter if _"one-man
management"_ replaces workers' self-management. Little wonder then that the
continued alienation of the worker was widespread long before Stalin took
power and, more importantly, before the civil war started.

As such, the dubious inheritance of classical Marxism had started to push the
Bolshevik revolution down an authoritarian path and create economic structures
and social relationships which were in no way socialist and, moreover, laid
the foundations for Stalinism. Even if the civil war had not occurred,
capitalist social relationships would have been dominant within "socialist"
Russia -- with the only difference being that rather than private capitalism
it would have been state capitalism. As Lenin admitted, incidentally. It is
doubtful that this state capitalism would have been made to serve _"the whole
people"_ as Lenin naively believed.

In another way Engels identification of organisation with authority affected
the outcome of the revolution. As **any** form of organisation involved, for
Engels, the domination of individuals and, as such, _"authoritarian"_ then the
nature of the socialist state was as irrelevant as the way workplaces were
run. As both party dictatorship and soviet democracy meant that the individual
was _"dominated"_ by collective decisions, so both were _"authoritarian."_ As
such, the transformation of the soviet state into a party dictatorship did not
fundamentally mean a change for the individuals subject to it. Little wonder
that no leading Bolshevik called the end of soviet democracy and its
replacement by party dictatorship as a "retreat" or even as something to be
worried about (indeed, they all argued the opposite, namely that party
dictatorship was essential and not an issue to be worried about).

Perhaps this analogy by the SWP's Tony Cliff of the relationship between the
party and the working class provides an insight:

> _"In essence the dictatorship of the proletariat **does not** represent a
> combination of abstract, immutable elements like democracy and centralism,
> independent of time and space. The actual level of democracy, as well as
> centralism, depends on three basic factors: 1. the strength of the
> proletariat; 2. the material and cultural legacy left to it by the old
> regime; and 3. the strength of capitalist resistance. The level of democracy
> feasible must be indirect proportion to the first two factors, and in
> inverse proportion to the third. The captain of an ocean liner can allow
> football to be played on his vessel; on a tiny raft in a stormy sea the
> level of tolerance is far lower."_ [ **Lenin** , vol. 3, p. 179]

Ignoring the obvious points (such as comparing working class freedom and
democracy to a game!), we can see shades of Engels in Cliff's words. Let us
not forget that Engels argued that _"a ship on the high seas"_ at a _"time of
danger"_ required _"the necessity of authority, and of imperious authority at
that."_ [ **Op. Cit.** , p. 732] Here Cliff is placing the party into the
Captain's role and the workers as the crew. The Captain, in Engels argument,
exercised _"imperious authority."_ In Cliff's, the party decides the freedoms
which working class people are allowed to have -- and so subjects them to its
_"imperious authority."_

Little wonder Bolshevism failed. By this simple analogy Cliff shows the
authoritarian essence of Bolshevism and who really has _"all power"_ under
that system. Like the crew and passengers dominated by the will of the
captain, the working class under Leninism will be dominated by the party. It
does not bode well that Cliff thinks that democracy can be _"feasible"_ in
some circumstances, but not others and it is up to those in power (i.e. the
party leaders) to determine when it was. In his rush to justify Bolshevik
party dictatorship in terms of "objective conditions" he clearly forgot his
earlier comments that the _"liberation of the working class can only be
achieved through the action of the working class. Hence one can have a
revolution with more or less violence, with more or less suppression of civil
rights of the bourgeoisie and its hangers-on [a general catch-all category
which, if Bolshevik practice is anything to go by, can include rebel workers,
indeed the whole working class!], with more or less political freedom, but one
**cannot** gave a revolution, as the history of Russia conclusively
demonstratives, without workers' democracy -- even if restricted and
distorted. Socialist advance must be gauged by workers' freedom, by their
power to shape their own destiny . . . Without workers' democracy the
immediate means leads to a very different end, to an end that is prefigured in
these same means."_ [ **Op. Cit.** , p. 110] Obviously if Lenin and Trotsky
are the captains of the ship of state, such considerations are less important.
When it is Lenin wielding _"imperious authority"_ then workers' democracy can
be forgotten and the regime remain a _"workers' state"_!

By ignoring the key issue Bakunin and other anarchists drew attention to by
attacking _"authority"_ (and let us not forget that by that they meant
hierarchical organisations in which power is concentrated at the top in a few
hands -- see [section H.4](secH4.md)), Engels opened up the way of seeing
democratic decision as being less than important. This is **not** to suggest
that Engels favoured dictatorship. Rather we are suggesting that by confusing
two radically different forms of organisation as self-management and hierarchy
he blunted latter Marxists to the importance of participation and collective
decision making from below. After all, if all organisation is
_"authoritarian"_ then it matters little, in the end, how it is structured.
Dictatorship, representative democracy and self-management were all equally
_"authoritarian"_ and so the issues raised by anarchism can safely be ignored
(namely that electing bosses does not equate to freedom). Thus the Bolshevik
willingness to equate their dictatorship with rule by the working class is not
such a surprise after all.

To conclude, rather than the anti-authoritarians not knowing _"what they are
talking about,"_ _"creating nothing but confusion,"_ _"betraying the movement
of the proletariat"_ and _"serv[ing] the reaction,"_ it was Engels' essay that
aided the Bolshevik counter-revolution and helped, in its own small way, to
lay the foundations for Leninist tyranny and state capitalism. [Engels, **Op.
Cit.** , p. 733] Ultimately, Engels _"On Authority"_ helped give Lenin the
ideological premises by which to undermine workers' economic power during the
revolution and recreate capitalist social relations and call it "socialism."
His ill thought out diatribe had ramifications even he would never have
guessed (but were obvious at the time to libertarians). His use of the modern
factory system to argue against the anarchist call for workers' councils,
federalism and workers' autonomy, for participation, for self-management,
became the basis for re-imposing **capitalist** relations of production in
revolutionary Russia.

## 4 How did the Bolshevik vision of "democracy" affect the revolution?

As discussed in [section H.3.2](secH3.md#sech32), Marx and Engels had left
their followers which a contradictory legacy as regards _"socialism from
below."_ On the one hand, their praise for the Paris Commune and its
libertarian ideas pointed to a participatory democracy run from below. On the
other, Marx's comments during the German Revolution in 1850 that the workers
must _"strive for . . . the most determined centralisation of power in the
hands of the state authority"_ because _"the path of revolutionary activity"_
can "proceed only from the centre" suggests a top-down approach. He stressed
that centralisation of power was essential to overcome local autonomy, which
would allow _"every village, every town and every province"_ to put _"a new
obstacle in the path"_ the revolution due to _"local and provincial
obstinacy."_ [ **Marx-Engels Reader** , p. 509]

Building upon this contradictory legacy, Lenin unambiguously stressed the
_"from above"_ aspect of it (see [section H.3.3](secH3.md#sech33) for
details). The only real exception to this perspective occurred in 1917, when
Lenin was trying to win mass support for his party. However, even this support
for democracy from below was always tempered by reminding the reader that the
Bolsheviks stood for centralisation and strong government once they were in
power (see [section 7](append44.md#app7)).

Once in power, the promises of 1917 were quickly forgotten. Unsurprisingly,
modern day Leninists argue that this was due to the difficult circumstances
facing the Bolsheviks at the time. They argue that the words of 1917 represent
the true democratic vision of Bolshevism. Anarchists are not impressed. After
all, for an idea to be useful it must be practical -- even in "exceptional
circumstances." If the Bolshevik vision is not robust enough to handle the
problems that have affected every revolution then we have to question the
validity of that vision or the strength of commitment its supporters hold it.

Given this, the question becomes which of these two aspects of Marxism was
considered its "essence" by Lenin and the Bolsheviks. Obviously, it is hard to
isolate the real Bolshevik vision of democracy from the influence of
"objective factors." However, we can get a taste by looking at how the
Bolsheviks acted and argued during the first six months in power. During this
period, the problems facing the revolution were hard but not as bad as those
facing it after the Czech revolt at the end of May, 1918. Particularly after
March, 1918, the Bolsheviks were in a position to start constructive work as
in the middle of that month Lenin claimed that the _"Soviet Government has
triumphed in the Civil War."_ [quoted by Maximoff, **The Guillotine at Work**
, p. 53]

So the question as to whether the Bolsheviks were forced into authoritarian
and hierarchical methods by the practical necessities of the civil war or
whether all this was inherent in Leninism all along, and the natural product
of Leninist ideology, can be answered by looking at the record of the
Bolsheviks prior to the civil war. From this we can ascertain the effect of
the civil war. And the obvious conclusion is that the record of the initial
months of Bolshevik rule point to a less than democratic approach which
suggests that authoritarian policies were inherent in Leninism and, as such,
pointed the revolution into a path were further authoritarian policies were
not only easy to implement, but had to be as alternative options had been
eliminated by previous policies. Moreover, Bolshevik ideology itself made such
policies easy to accept and to justify.

As discussed in [section 6](append41.md#app6) of the appendix ["What
happened during the Russian Revolution?"](append41.md),it was during this
period that the Bolsheviks started to gerrymander soviets and disband any they
lost elections to. As we indicate in [section 9](append41.md#app9) of the
appendix ["What happened during the Russian Revolution?"](append41.md), they
undermined the factory committees, stopping them federating and basically
handed the factories to the state bureaucracy. Lenin argued for and
implemented one-man management, piecework, Taylorism and other things
Stalinism is condemned for (see [section 3](append44.md#app3), for example).
In the army, Trotsky disbanded the soldier committees and elected officers by
decree.

How Trotsky defended this policy of appointing officers is significant. It
mirrors Lenin's argument in favour of appointed one-man management and, as
such, reflects the basic Bolshevik vision of democracy. By looking at his
argument we can see how the Bolshevik vision of democracy fatality undermined
the Russian Revolution and its socialist content. The problems of the civil
war simply deepened the abscess in democracy created by Lenin and Trotsky in
the spring of 1918.

Trotsky acknowledged that that _"the soldier-workers and soldier-peasants"_
needed _"to elect commanders for themselves"_ in the Tzarist army _"not [as]
military chiefs, but simply [as] representatives who could guard them against
attacks of counter-revolutionary classes."_ However, in the new Red Army this
was not needed as it was the _"workers' and peasants' Soviets, i.e. the same
classes which compose the army"_ which is building it. He blandly asserted
that _"[h]ere no internal struggle is possible."_ To illustrate his point he
pointed to the trade unions. _"The metal workers,"_ he noted, _"elect their
committee, and the committee finds a secretary, a clerk, and a number of other
persons who are necessary. Does it ever happen that the workers should say:
'Why are our clerks and treasurers appointed, and not elected?' No, no
intelligent workers will say so."_ [ **Leon Trotsky Speaks** , p. 112-3]

Thus in less than six months, Lenin's call in _"State and Revolution"_ that
_"[a]ll officials, without exception, [would be] elected and subject to recall
**at any time** "_ was dismissed as the demand that _"no intelligent workers"_
would raise! [ **Essential Works of Lenin** , p. 302] But, then again, Trotsky
**was** in the process of destroying another apparent _"principle"_ of
Leninism, namely (to quote, like Lenin, Marx) _"the suppression of the
standing army, and the substitution for it of the armed people."_ [quoted by
Lenin, **Op. Cit.** , p. 300]

Trotsky continues his argument. The Trade union committee, he asserts, would
say _"You yourselves have chosen the committee. If you don't like us, dismiss
us, but once you have entrusted us with the direction of the union, then give
us the possibility of choosing the clerk or the cashier, since we are better
able to judge in the matter than you, and if our way of conducting business is
bad, then throw us out and elect another committee."_ After this defence of
elected dictatorship, he states that the _"Soviet government is the same as
the committee of a trade union. It is elected by the workers and peasants, and
you can at the All-Russian Congress of the Soviets, at any moment you like,
dismiss that government and appoint another."_ Until that happens, he was
happy to urge blind obedience by the sovereign people to their servants: _"But
once you have appointed it, you must give it the right to choose the technical
specialists, the clerks, the secretaries in the broad sense of the word, and
in military affairs, in particular."_ He tried to calm the nerves of those who
could see the obvious problems with this argument by asking whether it was
_"possible for the Soviet government to appoint military specialists against
the interests of the labouring and peasant masses?"_ [ **Op. Cit.** , p. 113]

And the answer to that question is, of course, an empathic yes. Even looking
at his own analogy, namely that of a trade union committee, it is obvious that
an elected body can have interests separate from and in opposition to those
who elected it. The history of trade unionism is full of examples of
committees betraying the membership of the unions. And, of course, the history
of the Soviet government under Lenin and Trotsky (never mind Stalin!) shows
that just because it was once elected by a majority of the working people does
not mean it will act in their best interests.

Trotsky even went one better. _"The army is now only in the process of
formation,"_ he noted. _"How could the soldiers who have just entered the army
choose the chiefs! Have they have any vote to go by? They have none. And
therefore elections are impossible."_ [ **Op. Cit.** , p. 113] If only the
Tsar had thought of that one! If he had, he would still be in power. And,
needless to say, Trotsky did not apply that particular logic to himself. After
all, he had no experience of holding governmental office or building an army
(or even being in combat). Nor did any of the other Bolshevik leaders. By the
logic of his argument, not only should the workers not been allowed to vote
for a soviet government, he and his fellow Bolsheviks should not have assumed
power in 1917. But, clearly, sauce for the goose is definitely **not** sauce
for the gander.

For all his talk that the masses could replace the Bolsheviks at the All-
Russian Congress of Soviets, Trotsky failed to realise that these proposals
(and other ones like it) ensured that this was unlikely to happen. Even
assuming that the Bolsheviks had not gerrymandered and disbanded soviets, the
fact is that the Bolshevik vision of "democracy" effectively hollowed out the
grassroots participation required to make democracy at the top anything more
than a fig-leaf for party power. He honestly seemed to believe that
eliminating mass participation in other areas of society would have no effect
on the levels of participation in soviet elections. Would people subjected to
one-man management in the workplace and in the army really be truly free and
able to vote for parties which had not appointed their bosses? Could workers
who were disenfranchised economically and socially remain in political power
(assuming you equate voting a handful of leaders into power with _"political
power"_ )? And does being able to elect a representative every quarter to the
All-Russian congress really mean that the working class was really in charge
of society? Of course not.

This vision of top-down "democracy" can, of course, be traced back to Marx's
arguments of 1850 and Lenin's comments that the _"organisational principle of
revolutionary Social-Democracy"_ was _"to proceed from the top downward."_
(see sections [H.3.2](secH3.md#sech32) and [H.3.3](secH3.md#sech33)). By
equating centralised, top-down decision making by an elected government with
"democracy," the Bolsheviks had the ideological justification to eliminate the
functional democracy associated with the factory committees and soldiers
committees. In place of workers' and soldiers' direct democracy and self-
management, the Bolsheviks appointed managers and officers and justified
because a workers' party was in power. After all, had not the masses elected
the Bolsheviks into power? This became the means by which **real** democracy
was eliminated in area after area of Russian working class life. Needless to
say, a state which eliminates functional democracy in the grassroots will not
stay democratic in any meaningful sense for long. At best, it will be like a
bourgeois republic with purely elections where people elect a party to
misrepresent them every four or so years while real economic, political and
social power rests in the hands of a few. At worse, it would be a dictatorship
with "elections" whose results are known before hand.

The Leninist vision of "democracy" is seen purely as a means of placing the
party into power. Thus power in society shifts to the top, to the leaders of
the centralised party in charge of the centralised state. The workers' become
mere electors rather than actual controllers of the revolution and are
expected to carry out the orders of the party without comment. In other words,
a decidedly bourgeois vision of "democracy." Anarchists, in contrast, seek to
dissolve power back into the hands of society and empower the individual by
giving them a direct say in the revolution through their workplace and
community assemblies and their councils and conferences.

This vision was not a new development. Far from it. While, ironically enough,
Lenin's and Trotsky's support for the appointment of officers/managers can be
refuted by looking at Lenin's **State and Revolution** , the fact is that the
undemocratic perspectives they are based on can be found in Lenin's **What is
to be Done?**. This suggests that his 1917 arguments were the aberration and
against the true essence of Leninism, not his and Trotsky's policies once they
were in power (as Leninists like to argue).

Forgetting that he had argued against _"primitive democracy"_ in What is to Be
Done?, Lenin had lambasted the opportunists and "present Kautskyists" for
_"repeat[ing] the vulgar bourgeois jeers at 'primitive' democracy."_ Now, in
1917, it was a case that _"the transition from capitalism to socialism is
**impossible** without some 'reversion' to 'primitive' democracy (how else can
the majority, even the whole population, proceed to discharge state
functions?)"_ [ **Op. Cit.** , p. 302] Very true. As Leninism in power showed,
the conscious elimination of _"primitive democracy"_ in the army and workplace
ensured that socialism **was** _"impossible."_ And this elimination was not
justified in terms of "difficult" circumstances but rather in terms of
principle and the inability of working people to manage their own affairs
directly.

Particularly ironic, given Trotsky's trade union committee analogy was Lenin's
comment that _"Bernstein [the arch revisionist and reformist] combats
'primitive democracy' . . . To prove that 'primitive democracy' is worthless,
Bernstein refers to the experience of the British trade unions, as interpreted
by the Webbs. Seventy years of development . . . convinced the trade unions
that primitive democracy was useless, and they substituted ordinary democracy,
i.e. parliamentarism, combined with bureaucracy, for it."_ Lenin replied that
because the trade unions operated _" **in absolute capitalist slavery** "_ a
_"number of concessions to the prevailing evil, violence, falsehood, exclusion
of the poor from the affairs of the 'higher' administration 'cannot be
avoided.' Under socialism much of the 'primitive' democracy will inevitably be
revived, since, for the first time in history of civilised society, the
**mass** of the population will rise to **independent** participation, not
only in voting and elections, **but also in the everyday administration of
affairs** "_ [ **Op. Cit.** , p. 361] Obviously things looked a bit different
once he and his fellow Bolshevik leaders were in power. Then the exclusion of
the poor from the affairs of the _"higher"_ administration was seen as normal
practice, as proven by the practice of the trade unions! And as we note in
[section H.3.8](secH3.md#sech38), this _"exclusion"_ was taken as a key
lesson of the revolution and built into the Leninist theory of the state.

This development was not unexpected. After all, as we noted in [section
H.5.5](secH5.md#sech55), over a decade before Lenin had been less than
enthralled by _"primitive democracy"_ and more in agreement with Bernstein
than he lets on in **State and Revolution**. In **What is to Be Done?** , he
based his argument for centralised, top-down party organisation on the
experiences of the labour movement in democratic capitalist regimes. He quotes
the same book by the Webb's to defend his position. He notes that _"in the
first period of existence in their unions, the British workers thought it was
an indispensable sign of democracy for all members to do all the work of
managing the unions."_ This involved _"all questions [being] decided by the
votes of all the members"_ and all _"official duties"_ being _"fulfilled by
all the members in turn."_ He dismisses _"such a conception of democracy"_ as
_"absurd"_ and _"historical experience"_ made them _"understand the necessity
for representative institutions"_ and _"full-time professional officials."_
Ironically, Lenin records that in Russia the _"'primitive' conception of
democracy"_ existed in two groups, the _"masses of the students and workers"_
and the _"Economists of the Bernstein persuasion."_ [ **Op. Cit.** , pp.
162-3]

Thus Trotsky's autocratic and top-down vision of democracy has its roots
within Leninism. Rather than being forced upon the Bolsheviks by difficult
circumstances, the eroding of grassroots, functional ("primitive") democracy
was at the core of Bolshevism. Lenin's arguments in 1917 were the exception,
not his practice after he seized power.

This fundamentally undemocratic perspective can be found today in modern
Leninism. As well as defending the Bolshevik dictatorship during the civil
war, modern Leninists support the continuation of party dictatorship after its
end. In particular, they support the Bolshevik repression of the Kronstadt
rebellion (see appendix ["What was the Kronstadt Rebellion?"](append42.md)
for more details). As Trotsky put it in 1937, if the Kronstadt demand for
soviet elections had been implemented then _"to free the soviets from the
leadership [sic!] of the Bolsheviks would have meant within a short time to
demolish the soviets themselves . . . Social-Revolutionary-anarchist soviets
would serve only as a bridge from the proletarian dictatorship [sic!] to
capitalist restoration."_ He generalised this example, by pointing to the
_"experience of the Russian soviets during the period of Menshevik and SR
domination and, even more clearly, the experience of the German and Austrian
soviets under the domination of the Social Democrats."_ [Lenin and Trotsky,
**Kronstadt** , p. 90] Modern day Leninists repeat this argument, failing to
note that they sound like leftist Henry Kissingers (Kissinger, let us not
forget, ensured US aid for Pinochet's coup in Chile and argued that _"I don't
see why we need to stand by and watch a country go communist due to the
irresponsibility of its own people"_ ).

Today we have Leninists combining rhetoric about democratic socialism, with
elections and recall, with a mentality which justifies the suppression of
working class revolt because they are not prepared to stand by and watch a
country go capitalist due to the irresponsibility of its own people. Perhaps,
unsurprisingly, previously in 1937 Trotsky expressed his support for the
_"objective necessity"_ of the _"revolutionary dictatorship of a proletarian
party"_ and, two years later, that the _"vanguard of the proletariat"_ must be
_"armed with the resources of the state in order to repel dangers, including
those emanating from the backward layers of the proletariat itself."_ (see
[section H.3.8](secH3.md#sech38)). If only modern day Leninists were as
honest!

So the Bolshevik contempt for working class self-government still exists.
While few, however, explicitly proclaim the logic of this position (namely
party dictatorship) most defend the Bolsheviks implementing this conclusion in
practice. Can we not conclude that, faced with the same problems the
Bolsheviks faced, these modern day Leninists will implement the same policies?
That they will go from party power to party dictatorship, simply because they
know better than those who elected them on such matters? That answer seems all
too obvious.

As such, the Bolshevik preference for centralised state power and of
representative forms of democracy involved the substitution of the party for
the class and, consequently, will facilitate the dictatorship **over** the
proletariat when faced with the inevitable problems facing any revolution. As
Bakunin put it, a _"people's administration, according to [the Marxists], must
mean a people's administration by virtue of a small number of representatives
chosen by the people . . . [I]t is a deception which would conceal the
despotism of a governing minority, all the more dangerous because it appears
as a sham expression of the people's will . . . [T]he vast majority, the great
mass of people, would be governed by a privileged minority . . . [of]
**former** workers, who would stop being workers the moment they became rulers
or representatives, and would then come to regard the whole blue-collared
world from governmental heights, and would not represent the people but
themselves and their pretensions."_ So the Marxist state would be _"the reign
of the **scientific mind,** the most aristocratic, despotic, arrogant and
contemptuous of all regimes. There will be a new class, a new hierarchy of
real of bogus learning, and the world will be divided into a dominant,
science-based minority and a vast, ignorant majority. And then let the
ignorant masses beware!"_ [ **Michael Bakunin: Selected Writings** , p. 268,
pp. 268-9 and p. 266]

In summary, Trotsky's deeply undemocratic justification for appointing
officers, like Lenin's similar arguments for appointing managers, express the
logic and reality of Bolshevism far better than statements made before the
Bolsheviks seized power and never implemented. Sadly, modern Leninists
concentrate on the promises of the election manifesto rather than the grim
reality of Bolshevik power and its long standing top-down vision of
"democracy." A vision which helped undermine the revolution and ensure its
degeneration into a party dictatorship presiding over a state capitalist
economy.

## 5 What was the effect of the Bolshevik vision of "socialism"?

As we discussed in [section H.3.1](secH3.md#sech31), anarchists and most
Marxists are divided not only by **means** but also by **ends**. Simply put,
libertarians and Leninist do **not** have the same vision of socialism. Given
this, anarchists are not surprised at the negative results of the Bolshevik
revolution -- the use of anti-socialist means to attain anti-socialist ends
would obviously have less than desirable results.

The content of the Bolshevik vision of "socialism" is criticised by anarchists
on two main counts. Firstly, it is a top-down, centralised vision of
"socialism." This can only result in the destruction of working class economic
power at the point of production in favour of centralised bureaucratic power.
Secondly, for Bolshevism nationalisation, **not** workers' self-management,
was the key issue. We will discuss the first issue here and the second in the
following section.

The Bolshevik vision of "socialism" was inherently centralised and top-down.
This can be seen from the organisational schemas and arguments made by leading
Bolsheviks before and immediately after the Revolution. For example, we
discover Trotsky arguing in March 1918 that workplaces _"will be subject to
policies laid down by the local council of workmen's deputies"_ who, in turn,
had _"their range of discretion . . . limited in turn by regulations made for
each class of industry by the boards or bureaux of the central government."_
He dismissed Kropotkin's communalist ideas by saying local autonomy was not
_"suited to the state of things in modern industrial society"_ and _"would
result in endless frictions and difficulties."_ As the _"coal from the Donets
basin goes all over Russia, and is indispensable in all sorts of industries"_
you could not allow _"the organised people of that district [to] do what they
pleased with the coal mines"_ as they _"could hold up all the rest of
Russia."_ [contained in Al Richardson (ed.), **In Defence of the Russian
Revolution** , p. 186]

Lenin repeated this centralised vision in June of that year, arguing that
_"Communism requires and presupposes the greatest possible centralisation of
large-scale production throughout the country. The all-Russian centre,
therefore, should definitely be given the right of direct control over all the
enterprises of the given branch of industry. The regional centres define their
functions depending on local conditions of life, etc., in accordance with the
general production directions and decisions of the centre."_ He continued by
explicitly arguing that _"[t]o deprive the all-Russia centre of the right to
direct control over all the enterprises of the given industry . . . would be
regional anarcho-syndicalism, and not communism."_ [Marx, Engels and Lenin,
**Anarchism and Anarcho-Syndicalism** , p. 292]

Thus the Bolshevik economic ideal was centralised and top-down. This is not
unsurprising, as Lenin had promised precisely this when the Bolsheviks got
into power. As in the Bolshevik party itself, the lower organs were controlled
by the higher ones (and as we will discuss, these higher ones were not
directly elected by the lower ones). The problems with this vision are many
fold.

Firstly, to impose an "ideal" solution would destroy a revolution -- the
actions and decisions ( **including what others may consider mistakes** ) of a
free people are infinitely more productive and useful than the decisions and
decrees of the best central committee. Moreover, a centralised system by
necessity is an imposed system (as it excludes by its very nature the
participation of the mass of the people in determining their own fate). Thus
**real** socialisation must proceed from below, reflecting the real
development and desires of those involved. Centralisation can only result in
replacing socialisation with nationalisation and the elimination of workers'
self-management with hierarchical management. Workers' again would be reduced
to the level of order-takers, with control over their workplaces resting not
in their hands but in those of the state.

Secondly, Trotsky seems to think that workers at the base of society would be
so unchanged by a revolution that they would hold their fellow workers ransom.
And, moreover, that other workers would let them. That, to say the least,
seems a strange perspective. But not as strange as thinking that giving
extensive powers to a central body will **not** produce equally selfish
behaviour (but on a wider and more dangerous scale). The basic fallacy of
Trotsky's argument is that the centre will not start to view the whole economy
as its property (and being centralised, such a body would be difficult to
effectively control). Indeed, Stalin's power was derived from the state
bureaucracy which ran the economy in its own interests. Not that did not
suddenly arise with Stalin. It was a feature of the Soviet system from the
start. Samuel Farber, for example, notes that, _"in practice, [the]
hypercentralisation [pursued by the Bolsheviks from early 1918 onwards] turned
into infighting and scrambles for control among competing bureaucracies"_ and
he points to the _"not untypical example of a small condensed milk plant with
few than 15 workers that became the object of a drawn-out competition among
six organisations including the Supreme Council of National Economy, the
Council of People's Commissars of the Northern Region, the Vologda Council of
People's Commissars, and the Petrograd Food Commissariat."_ [ **Before
Stalinism** , p. 73]

In other words, centralised bodies are not immune to viewing resources as
their own property and doing as they please with it. Compared to an individual
workplace, the state's power to enforce its viewpoint against the rest of
society is considerably stronger and the centralised system would be harder to
control. The requirements of gathering and processing the information required
for the centre to make intelligent decisions would be immense, thus provoking
a large bureaucracy which would be hard to control and soon become the
**real** power in the state. A centralised body, therefore, effectively
excludes the mass participation of the mass of workers -- power rests in the
hands of a few people which, by its nature, generates bureaucratic rule. If
that sounds familiar, it should. It is precisely what **did** happen in
Lenin's Russia and laid the basis for Stalinism.

Thirdly, to eliminate the dangers of workers' self-management generating
"propertarian" notions, the workers' have to have their control over their
workplace reduced, if not eliminated. This, by necessity, generates bourgeois
social relationships and, equally, appointment of managers from above (which
the Bolsheviks did embrace). Indeed, by 1920 Lenin was boasting that in 1918
he had _"pointed out the necessity of recognising the dictatorial authority of
single individuals for the pursue of carrying out the Soviet idea"_ and even
claimed that at that stage _"there were no disputes in connection with the
question"_ of one-man management. [quoted by Brinton, **Op. Cit.** , p. 65]
While the first claim is true (Lenin argued for one-man management appointed
from above before the start of the Civil War in May 1918) the latter one is
not true (excluding anarchists, anarcho-syndicalists and Maximalists, there
were also the dissent _"Left Communists"_ in the Bolshevik party itself).

Fourthly, centralism was not that efficient. The central bodies the Bolsheviks
created had little knowledge of the local situation and often gave orders that
contradicted each other or had little bearing to reality, so encouraging
factories to ignore the centre: _"it seems apparent that many workers
themselves . . . had now come to believe . . . that confusion and anarchy
[sic!] **at the top** were the major causes of their difficulties, and with
some justification. The fact was that Bolshevik administration was chaotic . .
. Scores of competitive and conflicting Bolshevik and Soviet authorities
issued contradictory orders, often brought to factories by armed Chekists. The
Supreme Economic Council. . . issu[ed] dozens of orders and pass[ed] countless
directives with virtually no real knowledge of affairs."_ [William G.
Rosenberg, **Russian Labour and Bolshevik Power** , p. 116] The Bolsheviks, as
Lenin had promised, built from the top-down their system of _"unified
administration"_ based on the Tsarist system of central bodies which governed
and regulated certain industries during the war. [Brinton, **Op. Cit.** , p.
36] This was very centralised and very inefficient (see [section
7](append44.md#app7) for more discussion).

Moreover, having little real understanding of the circumstances on the ground
they could not compare their ideological assumptions and preferences to
reality. As an example, the Bolshevik idea that "big" was automatically "more
efficient" and "better" had a negative impact on the revolution. In practice,
as Thomas F. Remington notes, this simply resulted generated waste:

> _"The waste of scare materials at [the giant] Putilov [plant] was indeed
> serious, but not only political unrest had caused it. The general shortage
> of fuel and materials in the city took its greatest toll on the largest
> enterprises, whose overhead expenditures for heating the plant and firing
> the furnaces were proportionally greater than those for smaller enterprises.
> This point -- explained by the relative constant proportions among needed
> inputs to producers at any given point in time -- only was recognised
> latter. Not until 1919 were the regime's leaders prepared to acknowledge
> that small enterprises, under the conditions of the time, might be more
> efficient in using resources: and not until 1921 did a few Bolsheviks
> theorists grasp the economic reasons for this apparent violation of their
> standing assumption that larger units were inherently more productive. Thus
> not only were the workers accused of politically motivated resistance, but
> the regime blamed them for the effects of circumstances which the workers
> had no control."_ [ **Building Socialism in Bolshevik Russia** , p. 106]

All in all, the Bolshevik vision of socialism was a disaster. Centralism was a
source of massive economic mismanagement and, moreover, bureaucratisation from
the start. As anarchists had long predicted. As we discuss in [section
12](append41.md#app12) of the appendix ["What happened during the Russian
Revolution?"](append41.md), there was an alternative in the form of the
factory committees and the federation. Sadly this was not part of the
Bolshevik vision. At best they were tacked onto this vision as a (very) junior
partner (as in 1917) or they were quickly marginalised and then dumped when
they had outlived their usefulness in securing Bolshevik power (as in 1918).

While some Leninists like to paint the economic policies of the Bolsheviks in
power as being different from what they called for in 1917, the truth is
radically different. For example, Tony Cliff of the UK's "Socialist Workers
Party" asserts, correctly, that in April 1918 the _"defence of state
capitalism constituted the essence of his economic policy for this period."_
However, he also states that this was _"an entirely new formulation,"_ which
was not the case in the slightest. [Cliff, **Op. Cit.** , p. 69] As Lenin
himself acknowledged.

Lenin had always confused state capitalism with socialism. _"State
capitalism,"_ he wrote, _"is a complete **material** preparation for
socialism, the threshold of socialism, a rung on the ladder of history between
which and the rung called socialism **there are no gaps.** "_ He argued that
socialism _"is nothing but the next step forward from state capitalist
monopoly. In other words, Socialism is merely state capitalist monopoly **made
to benefit the whole people** ; by this token it **ceases** to be capitalist
monopoly."_ [ **The Threatening Catastrophe and how to avoid it** , p. 38 and
p. 37] This was in May, 1917. A few months latter, he was talking about how
the institutions of state capitalism could be taken over and used to create
socialism (see [section H.3.12](secH3.md#sech312)). Unsurprisingly, when
defending Cliff's _"new formulation"_ against the _"Left Communists"_ in the
spring of 1918 he noted that he gave his _"'high' appreciation of state
capitalism"_ _" **before** the Bolsheviks seized power."_ [ **Selected Works**
, vol. 2, p. 636]

And, indeed, his praise for state capitalism and its forms of social
organisation can be found in his **State and Revolution** :

> _"the **post-office** [is] an example of the socialist system . . . At
> present . . . [it] is organised on the lines of a state **capitalist**
> monopoly. Imperialism is gradually transforming all trusts into
> organisations of a similar type . . . the mechanism of social management is
> here already to hand. Overthrow the capitalists . . . Our immediate object
> is to organise the **whole** of national economy on the lines of the postal
> system . . . It is such a state, standing on such an economic basis, that we
> need."_ [ **Essential Works of Lenin** , pp. 307-8]

Given this, Lenin's rejection of the factory committee's model of socialism
comes as no surprise (see [section 10](append41.md#app10) of the appendix
["What happened during the Russian Revolution?"](append41.md) for more
details). As we noted in [section H.3.14](secH3.md#sech314), rather than
promote workers' control, Lenin effectively undermined it. Murray Bookchin
points out the obvious:

> _"In accepting the concept of worker's control, Lenin's famous decree of
> November 14, 1917, merely acknowledged an accomplished fact; the Bolsheviks
> dared not oppose the workers at this early date. But they began to whittle
> down the power of the factory committees. In January 1918, a scant two
> months after 'decreeing' workers' control, Lenin began to advocate that the
> administration of the factories be placed under trade union control. The
> story that the Bolsheviks 'patiently' experimented with workers' control,
> only to find it 'inefficient' and 'chaotic,' is a myth. Their 'patience' did
> not last more than a few weeks. Not only did Lenin oppose direct workers'
> control within a matter of weeks . . . even union control came to an end
> shortly after it had been established. By the summer of 1918, almost all of
> Russian industry had been placed under bourgeois forms of management."_ [
> **Post-Scarcity Anarchism** , pp. 200-1]

Significantly, even his initial vision of workers' control was hierarchical,
centralised and top-down. In the workplace it was to be exercised by factory
committees. The _"higher workers' control bodies"_ were to be _"composed of
representatives of trade unions, factory and office workers' committees, and
workers' co-operatives."_ The decisions of the lower bodies _"may be revoked
only by higher workers' control bodies."_ [quoted by Cliff, **Op. Cit.** , p.
10] As Maurice Brinton notes:

> _"there [was] . . . a firm hierarchy of control organs . . . each Committee
> was to be responsible to a 'Regional Council of Workers' Control',
> subordinated in turn to an 'All-Russian Council of Workers' Control'. The
> composition of these higher organs was decided by the Party._
>
> _"The trade unions were massively represented in the middle and higher
> strata of this new pyramid of 'institutionalised workers' control.' For
> instance the All-Russian Council of Workers' Control was to consist of 21
> 'representatives': 5 from the All-Russian Central Executive Committee of the
> Soviets, 5 from the Executive of the All-Russian Council of Trade Unions, 5
> from the Association of Engineers and Technicians, 2 from the Association of
> Agronomists, 2 from the Petrograd Trade Union Council, 1 from each All-
> Russian Trade Union Federation numbering fewer than 100,000 members (2 for
> Federations of over this number)... and 5 from the All-Russian Council of
> Factory Committees! The Factory Committees often under anarcho-syndicalist
> influence had been well and truly 'cut down to size'."_ [ **Op. Cit.** , p.
> 18]

As we note in [section 10](append41.md#app10) of the appendix ["What
happened during the Russian Revolution?"](append41.md), this was a conscious
preference on Lenin's part. The factory committees had started to federate,
creating their own institutional framework of socialism based on the workers
own class organisation. Lenin, as he had explained in 1917, favoured using the
institutions created by _"state capitalism"_ and simply tacked on a form of
_"workers' control"_ distinctly at odds with the popular usage of the
expression. He **rejected** the suggestions of factory committees themselves.
The Supreme Economic Council, established by the Soviet government, soon
demonstrated how to really mismanage the economy.

As such, the economic developments proposed by Lenin in early 1918 and onwards
were **not** the result of the specific problems facing the Russian
revolution. The fact is while the dire problems facing the Russian revolution
undoubtedly made many aspects of the Bolshevik system worse, they did not
create them. Rather, the centralised, bureaucratic and top-down abuses
Leninists like to distance themselves from where, in fact, built into Lenin's
socialism from the start. A form of socialism Lenin and his government
explicitly favoured and created in opposition to other, authentically
proletarian, versions.

The path to state capitalism was the one Lenin wanted to trend. It was not
forced upon him or the Bolsheviks. And, by re-introducing wage slavery (this
time, to the state) the Bolshevik vision of socialism helped undermine the
revolution, workers' power and, sadly, build the foundations of Stalinism.

## 6 How did Bolshevik preference for nationalisation affect the revolution?

As noted in the [last section](append44.md#app5), unlike anarchism, for
Bolshevism nationalisation, **not** workers' self-management, was the key
issue in socialism. As noted in [section 3](append44.md#app3), Lenin had
proclaimed the necessity for appointed one-man managers and implementing
_"state capitalism"_ in April 1918. Neither policy was thought to harm the
socialist character of the regime. As Trotsky stressed in 1920, the decision
to place a manager at the head of a factory instead of a workers' collective
had no political significance:

> _"It would be a most crying error to confuse the question as to the
> supremacy of the proletariat with the question of boards of workers at the
> head of factories. The dictatorship of the proletariat is expressed in the
> abolition of private property in the means of production, in the supremacy
> of the collective will of the workers and not at all in the form in which
> individual economic organisations are administered."_ [ **Terrorism and
> Communism** , p. 162]

Nor was this considered a bad thing or forced upon the Bolsheviks as a result
of terrible circumstances. Quite the reverse: _"I consider if the civil war
had not plundered our economic organs of all that was strongest, most
independent, most endowed with initiative, we should undoubtedly have entered
the path of one-man management in the sphere of economic administration much
sooner and much less painfully."_ [ **Op. Cit.** , pp. 162-3] As discussed in
the [previous section](append44.md#app5), this evaluation fits perfectly
into Bolshevik ideology and practice before and after they seized power. One
can easily find dozens of quotations from Lenin expressing the same idea.

Needless to say, Trotsky's _"collective will of the workers"_ was simply a
euphemism for the Party, whose dictatorship **over** the workers Trotsky
glibly justified:

> _"We have more than once been accused of having substituted for the
> dictatorship of the Soviets the dictatorship of the party. Yet it can be
> said with complete justice that the dictatorship of the Soviets became
> possible only by means of the dictatorship of the party. It is thanks to the
> . . . party . . . [that] the Soviets . . . [became] transformed from
> shapeless parliaments of labour into the apparatus of the supremacy of
> labour. In this 'substitution' of the power of the party for the power of
> the working class there is nothing accidental, and in reality there is no
> substitution at all. The Communists express the fundamental interests of the
> working class."_ [ **Op. Cit.** , p. 109]

While Trotsky's honesty on this matter is refreshing (unlike his followers
today who hypocritically talk about the "leadership" of the Bolshevik party)
we can say that this was a **fatal** position to take. Indeed, for Trotsky
**any** system (including the militarisation of labour) was acceptable as the
key _"differences . . . is defined by a fundamental test: who is in power?"_
\-- the capitalist class or the proletariat (i.e. the party) [ **Op. Cit.** ,
pp. 171-2] Thus working class control over their own affairs was of little
importance: _"The worker does not merely bargain with the Soviet State; no, he
is subordinated to the Soviet State, under its orders in every direction --
for it is **his** State."_ [ **Op. Cit.** , p. 168] This, of course, echoed
his own arguments in favour of appointment (see [section
4](append44.md#app4)) **and** Lenin's demands for the _"exercise of
dictatorial powers by individuals"_ in the workplace (see [section
3](append44.md#app3)) in early 1918. Cornelius Castoriadis points out the
obvious:

> _"The role of the proletariat in the new State was thus quite clear. It was
> that of enthusiastic and passive citizens. And the role of the proletariat
> in work and in production was no less clear. On the whole, it was the same
> as before -- under capitalism -- except that workers of 'character and
> capacity' [to quote Trotsky] were to be chosen to replace factory managers
> who had fled."_ [ **The Role of the Bureaucracy in the birth of the
> Bureaucracy** , p. 99]

Trotsky's position, it should be noted, remained consistent. In the early
1930s he argued (in respect to Stalin's regime) that _"anatomy of society is
determined by its economic relations. So long as the forms of property that
have been created by the October Revolution are not overthrown, the
proletariat remains the ruling class."_ [ **The Class Nature of The Soviet
State** ] Obviously, if the prime issue is property and not who **manages**
the means of production (or even _"the state"_ ) then having functioning
factory-committees becomes as irrelevant as having democratic soviets when
determining whether the working class is in power or not.

(As an aside, we should not by that surprised that Trotsky could think the
workers were the _"ruling class"_ in the vast prison-camp which was Stalin's
USSR, given that he thought the workers were the _"ruling class"_ when he and
Lenin headed the Bolshevik party dictatorship! Thus we have the strange
division Leninists make between Lenin's dictatorship and Stalin's (and those
of Stalin's followers). When Lenin presides over a one-party dictatorship,
breaks up strikes, bans political parties, bans Bolshevik factions, and
imprisons and shoots political dissidents these are all regrettable but
necessary steps in the protection of the "proletarian state." When Stalin does
the exact same thing, a few years later, they are all terrible examples of the
deformation of this same "proletarian state"!)

For anarchists (and other libertarian socialists) this was and is nonsense.
Without workers' self-management in production, socialism cannot exist. To
focus attention of whether individuals own property or whether the state does
is fundamentally a red-herring. Without workers' self-management of
production, private capitalism will simply have been replaced by **state**
capitalism. As one anarchist active in the factory committee movement argued
in January, 1918, it is _"not the liberation of the proletariat when many
individual plunders are changed for one very powerful plunder -- the state.
The position of the proletariat remains the same."_ Therefore, _"[w]e must not
forget that the factory committees are the nuclei of the future socialist
order"_ nor must we forget _"that the state . . . will try to maintain its own
interests at the expense of the interests of the workers. There is no doubt
that we will be witnesses of a great conflict between the state power in the
centre and the organisations composed exclusively of workers which are found
in the localities."_ He was proved right. Instead of centralised the Bolshevik
vision of state capitalism, the anarchists argued that factory committees _"be
united on the basic of federalism, into industrial federations . . . [and]
poly-industrial soviets of national economy."_ Only in that way could **real**
socialism be created. [quoted by Frederick I. Kaplan, **Bolshevik Ideology and
the Ethics of Soviet Labour** , p. 163 and p. 166] (see [section
7](append41.md#app7) of the appendix ["What happened during the Russian
Revolution?"](append41.md) for more on the factory committee movement).

The reason is obvious. It is worth quoting Cornelius Castoriadis at length on
why the Bolshevik system was doomed to failure:

> _"So we end up with the uncontested power of managers in the factories, and
> the Party's exclusive 'control' (in reality, what kind of control was it,
> anyway?). And there was the uncontested power of the Party over society,
> without any control. From that point on, nobody could prevent these two
> powers from merging, could anyone stop the two strata embodying them from
> merging, nor could the consolidation of an irremovable bureaucracy ruling
> over all sectors of social life be halted. The process may have been
> accelerated or magnified by the entry of non-proletarian elements into the
> Party, as they rushed to jump on the bandwagon. But this was a consequence,
> and not a cause, of the Party's orientation . . ._
>
> _"Who is to manage production . . .? . . . the correct answer [is] the
> collective organs of labouring people. What the party leadership wanted,
> what it had already imposed -- and on this point there was no difference
> between Lenin and Trotsky -- was a hierarchy directed from above. We know
> that this was the conception that triumphed. We know, too, where this
> 'victory' led . . ._
>
> _"In all Lenin's speeches and writings of this period, what recurs again and
> again like an obsession is the idea that Russia ought to learn from the
> advanced capitalist countries; that there are not a hundred and one
> different ways of developing production and labour productivity if one wants
> to emerge from backwardness and chaos; that one must adopt capitalist
> methods of 'rationalisation' and management as well as capitalist forms of
> work 'incentives.' All these, for Lenin, are just 'means' that apparently
> could freely be placed in the service of a radically different historical
> end, the building of socialism._
>
> _"Thus Trotsky, when discussing the merits of militarism, came to separate
> the army itself, its structure and its methods, from the social system it
> serves. What is criticisable in bourgeois militarism and in the bourgeois
> army, Trotsky says in substance, is that they are in the service of the
> bourgeoisie. Except for that, there is nothing in them to be criticised. The
> sole difference, he says, lies in this: ' **Who is in power**?' Likewise,
> the dictatorship of the proletariat is not expressed by the 'form in which
> individual economic enterprises are administered.' _
>
> _"The idea that like means cannot be placed indifferently into the service
> of different ends; that there is an intrinsic relationship between the
> instruments used and the result obtained; that, especially, neither the army
> nor the factory are simple 'means' or 'instruments,' but social structures
> in which are organised two fundamental aspects of human relations
> (production and violence); that in them can be seen in condensed form the
> essential expression of the type of social relations that characterise an
> era -- this idea, though perfectly obvious and banal for Marxists, was
> totally 'forgotten.' It was just a matter of developing production, using
> proven methods and structures. That among these 'proofs' the principal one
> was the development of capitalism as a social system and that a factory
> produces not so much cloth or steel but proletariat and capital were facts
> that were utterly ignored._
>
> _"Obviously, behind this 'forgetfulness' is hidden something else. At the
> time, of course, there was the desperate concern to revive production as
> soon as possible and to put a collapsing economy back on its feet. This
> preoccupation, however, does not fatally dictate the choice of 'means.' If
> it seemed obvious to Bolshevik leaders that the sole effective means were
> capitalist ones, it was because they were imbued with the conviction that
> capitalism was the only effective and rational system of production.
> Faithful in this respect to Marx, they wanted to abolish private property
> and market anarchy, but not the type of organisation capitalism had achieved
> at the point of production. They wanted to modify the **economy,** not the
> relations between people at work or the nature of labour itself. _
>
> _"At a deeper level still, their philosophy was to develop the forces of
> production. Here too they were the faithful inheritors of Marx -- or at
> least one side of Marx, which became the predominant one in his mature
> writings. The development of the forces of production was, if not the
> ultimate goal, at any rate the essential means, in the sense that everything
> else would follow as a by-product and that everything else had to be
> subordinated to it. . ._
>
> _"To manage the work of others -- this is the beginning and the end of the
> whole cycle of exploitation. The 'need' for a specific social category to
> manage the work of others in production (and the activity of others in
> politics and in society), the 'need' for a separate business management and
> for a Party to rule the State -- this is what Bolshevism proclaimed as soon
> as it seized power, and this is what it zealously laboured to impose. We
> know that it achieved its ends. Insofar as ideas play a role in the
> development of history -- and, **in the final analysis** , they play an
> enormous role -- the Bolshevik ideology (and with it, the Marxist ideology
> lying behind it) was a decisive factor in the birth of the Russian
> bureaucracy."_ [ **Op. Cit.** , pp. 100-4]

Therefore, we _"may therefore conclude that, contrary to the prevailing
mythology, it was not in 1927, or in 1923, or even in 1921 that the game was
played and lost, but much earlier, during the period from 1918 to 1920. . . .
[1921 saw] the beginning of the reconstruction of the productive apparatus.
This reconstruction effort, however, was already firmly set in the groove of
bureaucratic capitalism."_ [ **Op. Cit.** , p. 99] In this, they simply
followed the economic ideas Lenin had expounded in 1917 and 1918, but in an
even more undemocratic way. Modern-day Leninism basically takes the
revolutionised Russia of the Bolsheviks and, essentially, imposes upon it a
more democratic form of government rather than Lenin's (and then Stalin's).
Anarchists, however, still oppose the economy.

Ironically, proof that libertarians are right on this issue can be found in
Trotsky's own work. In 1936, he argued that the _"demobilisation of the Red
Army of five million played no small role in the formation of the bureaucracy.
The victorious commanders assumed leading posts in the local Soviets, in
economy, in education, and they persistently introduced everywhere that regime
which had ensured success in the civil war. Thus on all sides the masses were
pushed away gradually from actual participation in the leadership of the
country."_ [ **The Revolution Betrayed** ] Needless to say, he failed to note
who had abolished the election of commanders in the Red Army in March 1918,
namely himself (see [section 4](append44.md#app4)). Similarly, he failed to
note that the _"masses"_ had been _"pushed . . . from actual participation in
the leadership of the country"_ well before the end of the civil war and that,
at the time, he was not concerned about it. Equally, it would be churlish to
note that back in 1920 he thought that _"'Military' qualities . . . are valued
in every sphere. It was in this sense that I said that every class prefers to
have in its service those of its members who, other things being equal, have
passed through the military school . . . This experience is a great and
valuable experience. And when a former regimental commissary returns to his
trade union, he becomes not a bad organiser."_ [ **Terrorism and Communism** ,
p. 173]

In 1937 Trotsky asserted that _"liberal-anarchist thought closes its eyes to
the fact that the Bolshevik revolution, with all its repressions, meant an
upheaval of social relations in the interests of the masses, whereas Stalin's
Thermidorian upheaval accompanies the reconstruction of Soviet society in the
interest of a privileged minority."_ [Trotsky, **Stalinism and Bolshevism** ]
Yet Stalin's _"upheaval"_ was built upon the social relations created when
Lenin and Trotsky held power. State ownership, one-man management, and so on
where originally advocated and implemented by Lenin and Trotsky. The
bureaucracy did not have to expropriate the working class economically --
"real" Bolshevism had already did so. Nor can it be said that the social
relations associated with the political sphere had fundamentally changed under
Stalin. He had, after all, inherited the one-party state from Lenin and
Trotsky. In a nutshell, Trotsky is talking nonsense.

Simply put, as Trotsky himself indicates, Bolshevik preference for
nationalisation helped ensure the creation and subsequent rise of the
Stalinist bureaucracy. Rather than be the product of terrible objective
circumstances as his followers suggest, the Bolshevik state capitalist
economic system was at the heart of their vision of what socialism was. The
civil war simply brought the underlying logic of vision into the fore.

## 7 How did Bolshevik preference for centralism affect the revolution?

The next issue we will discuss is centralisation. Before starting, it is
essential that it be stressed that anarchists are **not** against co-ordinated
activity and organisation on a large scale. Anarchists stress the need for
federalism to meet the need for such work (see [section
A.2.9](secA2.md#seca29), for example). As such, our critique of Bolshevik
centralism is **not** a call for "localism" or isolation (as many Leninists
assert). Rather, it is a critique of **how** the social co-operation essential
for society will be conducted. Will it be in a federal (and so bottom-up) way
or will it be in a centralised (and so top-down) way?

It goes almost without saying that Bolshevik ideology was centralist in
nature. Lenin repeatedly stressed the importance of centralisation, arguing
constantly that Marxism was, by its very nature, centralist (and top-down --
[section H.3.3](secH3.md#sech33)). Long before the revolution, Lenin had
argued that within the party it was a case of _"the transformation of the
power of ideas into the power of authority, the subordination of lower Party
bodies to higher ones."_ [ **Collected Works** , vol. 7, p. 367] Such visions
of centralised organisation were the model for the revolutionary state. In
1917, he repeatedly stressed that after it the Bolsheviks would be totally in
favour of _"centralism"_ and _"strong state power."_ [Lenin, **Selected
Works** , vol. 2, p. 374] Once in power, they did not disappoint.

Anarchists argue that this prejudice in favour of centralisation and
centralism is at odds with Leninist claims to be in favour of mass
participation. It is all fine and well for Trotskyist Tony Cliff to quote
Lenin arguing that under capitalism the _"talent among the people"_ is
_"merely suppressed"_ and that it _"must be given an opportunity to display
itself"_ and that this can _"save the cause of socialism,"_ it is something
else for Lenin (and the Leninist tradition) to favour organisational
structures that allow that to happen. Similarly, it is fine to record Lenin
asserting that _"living, creative socialism is the product of the masses
themselves"_ but it is something else to justify the barriers Leninist
ideology placed in the way of it by its advocacy of centralism. [quoted by
Tony Cliff, **Lenin** , vol. 3, p. 20 and p. 21]

The central contradiction of Leninism is that while it (sometimes) talks about
mass participation, it has always prefers an organisational form (centralism)
which hinders, and ultimately destroys, the participation that **real**
socialism needs.

That centralism works in this way should come as no surprise. After all, it
based on centralising power at the top of an organisation and, consequently,
into a few hands. It was for this precise reason that **every** ruling class
in history has utilised centralisation against the masses. As we indicated in
[section B.2.5](secB2.md#secb25), centralisation has always been the tool of
minority classes to disempower the masses. In the American and French
revolutions, centralisation of state power was the means used to destroy the
revolution, to take it out off the hands of the masses and concentrate it into
the hands of a minority. In France:

> _"From the moment the bourgeoisie set themselves against the popular stream
> they were in need of a weapon that could enable them to resist pressure from
> the bras nus [working people]; they forced one by strengthening the central
> power . . . [This was] the formation of the state machinery through which
> the bourgeoisie was going to enslave the proletariat. Here is the
> centralised state, with its bureaucracy and police . . . [it was] a
> conscious attempt to reduce . . . the power of the people."_ [Daniel Guerin,
> **Class Struggle in the First French Republic** , p. 176]

The reason is not hard to understand -- mass participation and class society
do not go together. Thus, _"the move towards bourgeois dictatorship"_ saw
_"the strengthening of the central power against the masses."_ [Guerin, **Op.
Cit.** , pp. 177-8] _"To attack the central power,"_ argued Kropotkin, _"to
strip it of its prerogatives, to decentralise, to dissolve authority, would
have been to abandon to the people the control of its affairs, to run the risk
of a truly popular revolution. That is why the bourgeoisie sought to reinforce
the central government even more."_ [ **Words of a Rebel** , p. 143]

Can we expect a similar concentration of the central power under the
Bolsheviks to have a different impact? And, as discussed in appendix ["What
happened during the Russian Revolution?"](append41.md) we find a similar
marginalisation of the working class from its own revolution. Rather than
being actively participating in the transformation of society, they were
transformed into spectators who simply were expected to implement the
decisions made by the Bolsheviks on their behalf. Bolshevik centralisation
quickly ensured the disempowerment of working class people. Unsurprisingly
enough, given its role in class society and in bourgeois revolutions.

In this section of the FAQ, we will indicate why this process happened, why
Bolshevik centralisation undermined the socialist content of the revolution in
favour of new forms of oppression and exploitation.

Therefore, anarchists argue, centralism cannot help but generate minority
rule, not a classless society. Representative, and so centralised, democracy,
argued Malatesta, _"substitutes the will of a few for that of all . . . and in
the name of a fictitious collective interest, rides roughshod over every real
interests, and by means of elections and the vote, disregards the wishes of
each and everyone."_ [ **Life and Ideas** , p. 147]

This is rooted in the nature of the system, for democracy does not mean, in
practice, _"rule by all the people."_ Rather, as Malatesta pointed out, it
_"would be closer to the truth to say 'government of the majority of the
people."_ And even this is false, as _"it is never the case that the
representatives of the majority of the people are in the same mind on all
questions; it is therefore necessary to have recourse again to the majority
system and thus we will get closer still to the truth with 'government of the
majority of the elected by the majority of the electors.'"_ This, obviously,
_"is already beginning to bear a strong resemblance to minority government."_
And so, _"it is easy to understand what has already been proven by universal
historical experience: even in the most democratic of democracies it is always
a small minority that rules and imposes its will and interests by force."_ And
so centralism turns democracy into little more than picking masters.
Therefore, anarchists argue, _"those who really want 'government of the
people' . . . must abolish government."_ [ **The Anarchist Revolution** , p.
78]

The Russian Revolution is a striking confirmation of this libertarian
analysis. By applying centralism, the Bolsheviks disempowered the masses and
concentrated power into the hands of the party leadership. This places power
in a distinct social class and subject to the pervasive effects of their
concrete social circumstances within their institutional position. As Bakunin
predicted with amazing accuracy:

> _"The falsehood of the representative system rests upon the fiction that the
> executive power and the legislative chamber issuing from popular elections
> must, or even can for that matter, represent the will of the people . . .
> the instinctive aims of those who govern . . . are, because of their
> exceptional position diametrically opposed to the instinctive popular
> aspirations. Whatever their democratic sentiments and intentions may be,
> viewing society from the high position in which they find themselves, they
> cannot consider this society in any other way but that in which a
> schoolmaster views the pupils. And there can be no equality between the
> schoolmaster and the pupils. . . Whoever says political power says
> domination. And where domination exists, a more or less considerable section
> of the population is bound to be dominated by others. . . those who do the
> dominating necessarily must repress and consequently oppress those who are
> subject to the domination . . . [This] explains why and how men who were
> democrats and rebels of the reddest variety when they were a part of the
> mass of governed people, became exceedingly moderate when they rose to
> power. Usually these backslidings are attributed to treason. That, however,
> is an erroneous idea; they have for their main cause the change of position
> and perspective . . . if there should be established tomorrow a government .
> . . made up exclusively of workers, those . . . staunch democrats and
> Socialists, will become determined aristocrats, bold or timid worshippers of
> the principle of authority, and will also become oppressors and
> exploiters."_ [ **The Political Philosophy of Bakunun** , p. 218]

However, due to the inefficiencies of centralised bodies, this is not the end
of the process. Around the new ruling bodies inevitably springs up
officialdom. This is because a centralised body does not know what is
happening in the grassroots. Therefore it needs a bureaucracy to gather and
process that information and to implement its decisions. In the words of
Bakunin:

> _"where is the head, however brilliant it may be, or if one wishes to speak
> of a collective dictatorship, were it formed of many hundreds of individuals
> endowed with superior faculties, where are those brains powerful enough and
> wide-ranging enough to embrace the infinite multiplicity and diversity of
> the real interests, aspirations, wishes and needs whose sum total
> constitutes the collective will of a people, and to invent a social
> organisation can which can satisfy everybody? This organisation will never
> be anything but a Procrustean bed which the more or less obvious violence of
> the State will be able to force unhappy society to lie down on. . . Such a
> system . . . would lead inevitably to the creation of a new State, and
> consequently to the formation of a governmental aristocracy, that is, an
> entire class of people, having nothing in common with the mass of people . .
> . [and would] exploit the people and subject them."_ [ **Michael Bakunin:
> Selected Writings** , pp. 204-6]

As the bureaucracy is permanent and controls information and resources, it
soon becomes the main source of power in the state. The transformation of the
bureaucracy from servant to the master soon results. The "official" government
is soon controlled by it, shaping its activities in line with its interests.
Being highly centralised, popular control is even more limited than government
control -- people would simply not know where real power lay, which officials
to replace or even what was going on within the distant bureaucracy. Moreover,
if the people did manage to replace the correct people, the newcomers would be
subject to the same institutional pressures that corrupted the previous
members and so the process would start again (assuming their did not come
under the immediate influence of those who remained in the bureaucracy).
Consequently, a new bureaucratic class develops around the centralised bodies
created by the governing party. This body would soon become riddled with
personal influences and favours, so ensuring that members could be sheltered
from popular control. As Malatesta argued, they _"would use every means
available to those in power to have their friends elected as the successors
who would then in turn support and protect them. And thus government would be
passes to and fro in the same hands, and **democracy,** which is the alleged
government of all, would end up, as usual, in an **oligarchy,** which is the
government of a few, the government of a class."_ [ **Anarchy** , p. 34]

This state bureaucracy, of course, need not be dictatorial nor the regime it
rules/administers be totalitarian (for example, bourgeois states combine
bureaucracy with many real and important liberties). However, such a regime is
still a class one and socialism would still not exist -- as proven by the
state bureaucracies and nationalised property within bourgeois society.

So the danger to liberty of combining political **and** economic power into
one set of hands (the state's) is obvious. As Kropotkin argued:

> _"the state was, and continues to be, the chief instrument for permitting
> the few to monopolise the land, and the capitalists to appropriate for
> themselves a quite disproportionate share of the yearly accumulated surplus
> of production. Consequently, while combating the present monopolisation of
> land, and capitalism altogether, the anarchists combat with the same energy
> the state, as the main support of that system. Not this or that special
> form, but the state altogether . . . The state organisation, having always
> been, both in ancient and modern history . . . the instrument for
> establishing monopolies in favour of the ruling minorities, cannot be made
> to work for the destruction of these monopolies. The anarchists consider,
> therefore, that to hand over to the state all the main sources of economical
> life -- the land, the mines, the railways, banking, insurance, and so on -
> as also the management of all the main branches of industry, in addition to
> all the functions already accumulated in its hands (education, state-
> supported religions, defence of the territory, etc.), would mean to create a
> new instrument of tyranny. State capitalism would only increase the powers
> of bureaucracy and capitalism. True progress lies in the direction of
> decentralisation, both **territorial** and **functional** , in the
> development of the spirit of local and personal initiative, and of free
> federation from the simple to the compound, **in lieu** of the present
> hierarchy from the centre to the periphery."_ [ **Kropotkin's Revolutionary
> Pamphlets** , p. 286]

Thus we have the basic argument **why** centralism will result in the
continuation of class society. Does the Bolshevik experience contradict this
analysis? Essentially, it confirms to Kropotkin's predictions on the
uselessness of "revolutionary" government:

> _"Instead of acting for themselves, instead of marching forward, instead of
> advancing in the direction of the new order of things, the people confiding
> in their governors, entrusted to them the charge of taking initiative. This
> was the first consequence of the inevitable result of elections. . . Shut up
> in the city hall, charged to proceed after the forms established by the
> preceding governments, these ardent revolutionists, these reformers found
> themselves smitten with incapacity and sterility. . . but it was not the men
> who were the cause for this failure -- it was the system.. ._
>
> _"The will of the bulk of the nation once expressed, the rest would submit
> to it with a good grace, but this is not how things are done. The revolution
> bursts out long before a general understanding has come, and those who have
> a clear idea of what should be done the next day are only a very small
> minority. The great mass of the people have as yet only a general idea of
> the end which they wish realised, without knowing much how to advance
> towards that end, and without having much confidence in the direction to
> follow. The practical solution will not be found, will not be made clear
> until the change will have already begun. It will be the product of the
> revolution itself, of the people in action, -- or else it will be nothing,
> incapable of finding solutions which can only spring from the life of the
> people. . . The government becomes a parliament with all the vices of a
> middle-class parliament. Far from being a 'revolutionary' government it
> becomes the greatest obstacle to the revolution and at last the people find
> themselves compelled to put it out of the way, to dismiss those that but
> yesterday they acclaimed as their children._
>
> _"But it is not so easy to do so. The new government which has hastened to
> organise a new administration in order to extend it's domination and make
> itself obeyed does not understand giving up so easily. Jealous of
> maintaining it's power, it clings to it with all the energy of an
> institution which has yet had time to fall into senile decay. It decides to
> oppose force with force, and there is only one means then to dislodge it,
> namely, to take up arms, to make another revolution in order to dismiss
> those in whom the people had placed all their hopes."_ [ **Op. Cit.** , pp.
> 240-2]

By the spring and summer of 1918, the Bolshevik party had consolidated its
power. It had created a new state, marked as all states are by the
concentration of power in a few hands and bureaucracy. Effective power became
concentrated into the hands of the executive committees of the soviets from
top to bottom. Faced with rejection at soviet election after soviet election,
the Bolsheviks simply disbanded them and gerrymandered the rest. At the summit
of the new state, a similar process was at work. The soviets had little real
power, which was centralised in Lenin's new government. This is discussed in
more detail in [section 6](append41.md#app6) of the appendix ["What happened
during the Russian Revolution?"](append41.md). Thus centralisation quickly
displaced popular power and participation. As predicted by Russia anarchists
in November 1917:

> _"Once their power is consolidated and 'legalised', the Bolsheviks -- who
> are Social Democrats, that is, men of centralist and authoritarian action --
> will begin to rearrange the life of the country and of the people by
> governmental and dictatorial methods, imposed by the centre. The[y] . . .
> will dictate the will of the party to all Russia, and command the whole
> nation. Your Soviets and your other local organisations will become little
> by little, simply executive organs of the will of the central government. In
> the place of healthy, constructive work by the labouring masses, in place of
> free unification from the bottom, we will see the installation of an
> authoritarian and statist apparatus which would act from above and set about
> wiping out everything that stood in its way with an iron hand. The Soviets
> and other organisations will have to obey and do its will. That will be
> called 'discipline.'"_ [quoted by Voline, **The Unknown Revolution** , p.
> 235]

From top to bottom, the new party in power systematically undermined the
influence and power of the soviets they claimed to be ensuring the power of.
This process had begun, it should be stressed **before** the start of the
civil war in May, 1918. Thus Leninist Tony Cliff is wrong to state that it was
_"under the iron pressure of the civil war"_ which forced the Bolshevik
leaders _"to move, as the price of survival, to a **one-party system.** "_ [
**Revolution Besieged** , p. 163] From the summer of 1918 (i.e. before the
civil war even started), the Bolsheviks had turned from the first of
Kropotkin's "revolutionary" governments (representative government) to the
other, dictatorship, with sadly predictable results.

So far, the anarchist predictions on the nature of centralised revolutionary
governments had been confirmed. Being placed in a new social position and,
therefore, different social relationships, produced a dramatic revision on the
perspectives of the Bolsheviks. They went from being in favour of party power
to being in favour of party dictatorship. They acted to ensure their power by
making accountability and recall difficult, if not impossible, and simply
ignored any election results which did not favour them.

What of the second prediction of anarchism, namely that centralisation will
recreate bureaucracy? That, too, was confirmed. After all, some means were
required to gather, collate and provide information by which the central
bodies made their decisions. Thus a necessary side-effect of Bolshevik
centralism was bureaucracy, which, as is well known, ultimately fused with the
party and replaced Leninism with Stalinism. The rise of a state bureaucracy
started immediately with the seizure of power by the Bolsheviks. Instead of
the state starting to _"wither away"_ from the start it grew:

> _"The old state's political apparatus was 'smashed,' but in its place a new
> bureaucratic and centralised system emerged with extraordinary rapidity.
> After the transfer of government to Moscow in March 1918 it continued to
> expand . . . As the functions of the state expanded so did the bureaucracy,
> and by August 1918 nearly a third of Moscow's working population were
> employed in offices [147,134 employed in state institutions and 83,886 in
> local ones. This was 13.7% of the total adult population and 29.6% of the
> independent population of 846,095]. The great increase in the number of
> employees . . . took place in early to mid-1918 and, thereafter, despite
> many campaigns to reduce their number, they remained a steady proportion of
> the falling population . . . At first the problem was dismissed by arguments
> that the impressive participation of the working class in state structures
> was evidence that there was no 'bureaucratism' in the bureaucracy. According
> to the industrial census of 31 August 1918, out of 123,578 workers in
> Moscow, only 4,191 (3.4 percent) were involved in some sort of public
> organisation . . . Class composition is a dubious criterion of the level of
> bureaucratism. Working class participation in state structures did not
> ensure an organisation against bureaucratism, and this was nowhere more true
> than in the new organisations that regulated the economic life of the
> country."_ [Richard Sakwa, _"The Commune State in Moscow in 1918,"_ pp.
> 429-449, **Slavic Review** , vol. 46, no. 3/4, pp. 437-8]

The _"bureaucracy grew by leaps and bounds. Control over the new bureaucracy
constantly diminished, partly because no genuine opposition existed. The
alienation between 'people' and 'officials,' which the soviet system was
supposed to remove, was back again. Beginning in 1918, complaints about
'bureaucratic excesses,' lack of contact with voters, and new proletarian
bureaucrats grew louder and louder."_ [Oskar Anweiler, **The Soviets** , p.
242]

Overtime, this permanent collection of bodies would become the real power in
the state, with the party members nominally in charge really under the control
of an unelected and uncontrolled officialdom. This was recognised by Lenin in
the last years of his life. As he noted in 1922:

> _"Let us look at Moscow . . . Who is leading whom? The 4,700 responsible
> Communists the mass of bureaucrats, or the other way round? I do not believe
> that you can say that the Communists are leading this mass. To put it
> honestly, they are not the leaders, but the led."_ [quoted by Chris Harman,
> **Bureaucracy and Revolution in Eastern Europe** , p. 13]

By the end of 1920, there were five times more state officials than industrial
workers. 5, 880,000 were members of the state bureaucracy. However, the
bureaucracy had existed since the start. As noted above, the 231,000 people
employed in offices in in Moscow in August 1918 represented 30 per cent of the
workforce there. _"By 1920 the general number of office workers . . . still
represented about a third of those employed in the city."_ In November, 1920,
they were 200 000 office workers in Moscow, compared to 231 000 in August,
1918. By July, 1921 (in spite of a plan to transfer 10,000 away) their numbers
had increased to 228,000 and by October 1922, to 243,000. [Richard Sakwa,
**Soviet Communists in Power** , p. 192, p. 191 and p. 193]

This makes perfect sense as _"on coming to power the Bolsheviks smashed the
old state but rapidly created their own apparatus to wage the political and
economic offensive against the bourgeois and capitalism. As the functions of
the state expanded, so did the bureaucracy . . . following the revolution the
process of institutional proliferation reached unprecedented heights."_ [
**Op. Cit.** , p. 191] And with bureaucracy came the abuse of it simply
because it held **real** power:

> _"The prevalence of bureaucracy, of committees and commissions . . .
> permitted, and indeed encouraged, endless permutations of corrupt practices.
> These raged from the style of living of communist functionaries to bribe-
> taking by officials. With the power of allocation of scare resources, such
> as housing, there was an inordinate potential for corruption."_ [ **Op.
> Cit.** , p. 193]

The growth in **power** of the bureaucracy should not, therefore, come as a
major surprise given that had existed from the start in sizeable numbers.
However, for the Bolsheviks _"the development of a bureaucracy"_ was a puzzle,
_"whose emergence and properties mystified them."_ However, it should be noted
that, _"[f]or the Bolsheviks, bureaucratism signified the escape of this
bureaucracy from the will of the party as it took on a life of its own."_
[Sakwa, **Op. Cit.** , p. 182 and p. 190] This was the key. They did not
object the usurpation of power by the party (indeed they placed party
dictatorship at the core of their politics and universalised it to a general
principle for **all** _"socialist"_ revolutions). Nor did they object to the
centralisation of power and activity (and so the bureaucratisation of life).
They only objected to it when the bureaucracy was not doing what the party
wanted it to. Indeed, this was the basic argument of Trotsky against Stalinism
(see [section 3](append45.md#app3) of the appendix on ["Were any of the
Bolshevik oppositions a real alternative?"](append45.md)).

Faced with this bureaucracy, the Bolsheviks tried to combat it
(unsuccessfully) and explain it. As the failed to achieve the latter, they
failed in the former. Given the Bolshevik fixation for all things centralised,
they simply added to the problem rather than solve it. Thus we find that
_"[o]n the eve of the VIII Party Congress Lenin had argued that centralisation
was the only way to combat bureaucratism."_ [Sakwa, **Op. Cit.** , p. 196]

Unsurprisingly, Lenin's "anti-bureaucratic" policies in the last years of his
live were _"organisational ones. He purposes the formation of the Workers' and
Peasants' Inspection to correct bureaucratic deformations in the party and
state -- and this body falls under Stalin's control and becomes highly
bureaucratic in its own right. Lenin then suggests that the size of the
Workers' and Peasants' Inspection be reduced and that it be merged with the
Control Commission. He advocates enlarging the Central Committee. Thus it
rolls along; this body to be enlarged, this one to be merged with another,
still a third to be modified or abolished. The strange ballet of
organisational forms continues up to his very death, as though the problem
could be resolved by organisational means."_ [Murray Bookchin, **Post-Scarcity
Anarchism** , p. 205]

Failing to understand the links between centralism and bureaucracy, Lenin had
to find another source for the bureaucracy. He found one. He _"argued that the
low cultural level of the working class prevented mass involvement in
management and this led to bureaucratism . . . the new state could only reply
on a minuscule layer of workers while the rest were backward because of the
low cultural level of the country."_ However, such an explanation is by no
means convincing: _"Such culturalist assertions, which could neither be proved
or disproved but which were politically highly effective in explaining the
gulf, served to blur the political and structural causes of the problem. The
working class was thus held responsible for the failings of the bureaucracy.
At the end of the civil war the theme of the backwardness of the proletariat
was given greater elaboration in Lenin's theory of the declassing of the
proletariat."_ [Sakwa, **Op. Cit.** , p. 195] Given that the bureaucracy had
existed from the start, it is hard to say that a more _"cultured"_ working
class would have been in a better position to control the officials of a
highly centralised state bureaucracy. Given the problems workers in
"developed" nations have in controlling their (centralised) union
bureaucracies, Lenin's explanation seems simply inadequate and, ultimately,
self-serving.

Nor was this centralism particularly efficient. You need only read Goldman's
or Berkman's accounts of their time in Bolshevik Russia to see how inefficient
and wasteful centralisation and its resultant bureaucracy was in practice (see
**My Disillusionment in Russia** and **The Bolshevik Myth** , respectively).
This can be traced, in part, to the centralised economic structures favoured
by the Bolsheviks. Rejecting the alternative vision of socialism advocated
and, in part created, by the factory committees (and supported wholeheartedly
by the Russian Anarchists at the time), the Bolsheviks basically took over and
used the _"state capitalist"_ organs created under Tsarism as the basis of
their "socialism" (see [section 5](append44.md#app5)). As Lenin promised
**before** seizing power:

> _" **Forced syndicatisation** \-- that is, forced fusion into unions [i.e.
> trusts] under the control of the State -- this is what capitalism has
> prepared for us -- this is what the Banker State has realised in Germany --
> this is what will be completely realisable in Russia by the Soviets, by the
> dictatorship of the proletariat."_ [ **Will the Bolsheviks Maintain Power?**
> , p. 53]

In practice, Lenin's centralised vision soon proved to be a disaster (see
[section 11](append41.md#app11) of the appendix ["What happened during the
Russian Revolution?"](append41.md) for details). It was highly inefficient
and simply spawned a vast bureaucracy. There was an alternative, as we discuss
in [section 12](append41.md#app12) of the appendix ["What happened during
the Russian Revolution?"](append41.md), the only reason that industry did
not totally collapse in Russia during the early months of the revolution was
the activity of the factory committees. However, such activity was not part of
the Bolshevik vision of centralised socialism and so the factory committees
were **not** encouraged. At the very moment when mass participation and
initiative is required (i.e. during a revolution) the Bolsheviks favoured a
system which killed it. As Kropotkin argued a few years later:

> _"production and exchange represented an undertaking so complicated that the
> plans of the state socialists, which lead to a party directorship, would
> prove to be absolutely ineffective as soon as they were applied to life. No
> government would be able to organise production if the workers themselves
> through their unions did not do it in each branch of industry; for in all
> production there arise daily thousands of difficulties which no government
> can solve or foresee . . . Only the efforts of thousands of intelligences
> working on the problems can co-operate in the development of a new social
> system and find the best solutions for the thousands of local needs."_ [
> **Kropotkin's Revolutionary Pamphlets** , pp. 76-7]

No system is perfect. Any system will take time to develop fully. Of course
the factory committees made mistakes and, sometimes, things were pretty
chaotic with different factories competing for scarce resources. But that does
not prove that factory committees and their federations were not the most
efficient way of running things under the circumstances. Unless, of course,
you share the Bolsheviks a dogmatic belief that central planning is always
more efficient. Moreover, attacks on the factory committees for lack of co-
ordination by pro-Leninists seem less than sincere, given the utter lack of
encouragement (and, often, actual barriers) the Bolsheviks placed in the way
of the creation of federations of factory committees (see [section
9](append41.md#app9) of the appendix ["What happened during the Russian
Revolution?"](append41.md) for further details).

Lastly, Bolshevik centralism (as well as being extremely inefficient) also
ensured that the control of production and the subsequent surplus would be in
the hands of the state and, so, class society would continue. In Russia,
capitalism became state capitalism under Lenin and Trotsky (see sections
[5](append44.md#app5) and [6](append44.md#app6) for more discussion of
this).

So Bolshevik support for centralised power ensured that minority power
replaced popular power, which, in turn, necessitated bureaucracy to maintain
it. Bolshevism retained statist and capitalist social relations and, as such,
could not develop socialist ones which, by their very nature, imply
egalitarianism in terms of social influence and power (i.e. the abolition of
concentrated power, both economic and political). Ironically, by being
centralists, the Bolsheviks systematically eliminated mass participation and
ensured the replacement of popular power with party power. This saw the
rebirth of non-socialist social relationships within society, so ensuring the
defeat of the socialist tendencies and institutions which had started to grow
during 1917.

It cannot be said that this centralism was a product of the civil war. As best
it could be argued that the civil war extenuated an existing centralist spirit
into ultra-centralism, but it did not create it. After all, Lenin was
stressing that the Bolsheviks were _"convinced centralists . . . by their
programme and the tactics of the whole of their party"_ in 1917. Ironically,
he never realised (nor much cared, after the seizure of power) that this
position precluded his call for _"the deepening and extension of democracy in
the administration of a State of the of the proletarian type."_ [ **Can the
Bolsheviks Maintain Power?** , p. 74 and p. 55] Given that centralism exists
to ensure minority rule, we should not be to surprised that party power
replaced popular participation and self-government quickly after the October
Revolution. Which it did. Writing in September 1918, a Russian anarchist
portrays the results of Bolshevik ideology in practice:

> _"Within the framework of this dictatorship [of the proletariat] . . . we
> can see that the centralisation of power has begun to crystallise and grow
> firm, that the apparatus of the state is being consolidated by the ownership
> of property and even by an anti-socialist morality. Instead of hundreds of
> thousands of property owners there is now a single owner served by a whole
> bureaucratic system and a new 'statised' morality._
>
> _"The proletariat is gradually being enserfed by the state. The people are
> being transformed into servants over whom there has risen a new class of
> administrators -- a new class . . . Isn't this merely a new class system
> looming on the revolutionary horizon . . ._
>
> _"The resemblance is all too striking . . . And if the elements of class
> inequality are as yet indistinct, it is only a matter of time before
> privileges will pass to the administrators. We do not mean to say . . . that
> the Bolshevik party set out to create a new class system. But we do say that
> even the best intentions and aspirations must inevitably be smashed against
> the evils inherent in any system of centralised power. The separation of
> management from labour, the division between administrators and workers
> flows logically from, centralisation. It cannot be otherwise . . . we are
> presently moving not towards socialism but towards state capitalism._
>
> _"Will state capitalism lead us to the gates of socialism? Of this we see
> not the slightest evidence . . . Arrayed against socialism are . . .
> thousands of administrators. And if the workers . . . should become a
> powerful revolutionary force, then it is hardly necessary to point out that
> the class of administrators, wielding the state apparatus, will be a far
> from weak opponent. The single owner and state capitalism form a new dam
> before the waves of our social revolution. . ._
>
> _"Is it at all possible to conduct the social revolution through a
> centralised authority? Not even a Solomon could direct the revolutionary
> struggle or the economy from one centre . . ."_ [M. Sergven, cited by Paul
> Avrich, **Anarchists in the Russian Revolution** , pp. 123-5]

Subsequent developments proved this argument correct. Working class revolts
were crushed by the state and a new class society developed. little wonder,
then, Alexander Berkman's summary of what he saw first hand in Bolshevik
Russia a few years later:

> _"Mechanical centralisation, run mad, is paralysing the industrial and
> economic activities of the country. Initiative is frowned upon, free effort
> systematically discouraged. The great masses are deprived of the opportunity
> to shape the policies of the Revolution, or take part in the administration
> of the affairs of the country. The government is monopolising every avenue
> of life; the Revolution is divorced from the people. A bureaucratic machine
> is created that is appalling in its parasitism, inefficiency and corruption.
> In Moscow alone this new class of **sovburs** (Soviet bureaucrats) exceeds,
> in 1920, the total of office holders throughout the whole of Russia under
> the Tsar in 1914 . . . The Bolshevik economic policies, effectively aided by
> this bureaucracy, completely disorganise the already crippled industrial
> life of the country. Lenin, Zinoviev, and other Communist leaders thunder
> philippics against the new Soviet bourgeoisie, - and issue ever new decrees
> that strengthen and augment its numbers and influence."_ [ **The Russian
> Tragedy** , p. 26]

Bakunin would not have been remotely surprised. As such, the Bolshevik
revolution provided a good example to support Malatesta's argument that _"if .
. . one means government action when one talks of social action, then this is
still the resultant of individual forces, but only of those individuals who
form the government . . . it follows. . . that far from resulting in an
increase in the productive, organising and protective forces in society, it
would greatly reduce them, limiting initiative to a few, and giving them the
right to do everything without, of course, being able to provide them with the
gift of being all-knowing."_ [ **Anarchy** , pp. 36-7]

By confusing _"state action"_ with collective working class action, the
Bolsheviks effectively eliminated the latter in favour of the former. The
usurpation of all aspects of life by the centralised bodies created by the
Bolsheviks left workers with no choice but to act as isolated individuals. Can
it be surprising, then, that Bolshevik policies aided the atomisation of the
working class by replacing collective organisation and action by state
bureaucracy? The potential for collective action **was** there. You need only
look at the strikes and protests directed **against** the Bolsheviks to see
that was the case (see [section 5](append43.md#app5) of the appendix on
["What caused the degeneration of the Russian Revolution?"](append43.md) for
details). Ironically, Bolshevik policies and ideology ensured that the
collective effort and action of workers was directed not at solving the
revolution's problems but resisting Bolshevik tyranny.

That centralism concentrates power in a few hands can be seen even in Leninist
accounts of the Russian revolution. To take one example, Tony Cliff may assert
that the _"mistakes of the masses were themselves creative"_ but when push
comes to shove, he (like Lenin) simply does not allow the masses to make such
mistakes and, consequently, learn from them. Thus he defends Lenin's economic
policies of _"state capitalism"_ and _"one-man management"_ (and in the
process misleadingly suggests that these were **new** ideas on Lenin's part,
imposed by objective factors, rather than, as Lenin acknowledged, what he had
advocated all along -- see [section 5](append44.md#app5)). Thus we discover
that the collapse of industry (which had started in the start of 1917) meant
that _"[d]rastic measures had to be taken."_ But never fear, _"Lenin was not
one to shirk responsibility, however unpleasant the task."_ He called for
_"state capitalism,"_ and there _"were more difficult decisions to be
accepted. To save industry from complete collapse, Lenin argued for the need
to impose one-man management."_ So much for the creative self-activity of the
masses, which was quickly dumped -- precisely at the time when it was most
desperately needed. And it is nice to know that in a workers' state it is not
the workers who decide things. Rather it is Lenin (or his modern equivalent,
like Cliff) who would have the task of not shirking from the responsibility of
deciding which drastic measures are required. [ **Op. Cit.** , p. 21, p. 71
and p. 73] So much for "workers' power"!

Ultimately, centralism is designed to exclude the mass participation
anarchists have long argued is required by a social revolution. It helped to
undermine what Kropotkin considered the key to the success of a social
revolution -- _"the people becom[ing] masters of their destiny."_ [ **Op.
Cit.** , p. 133] In his words:

> _"We understand the revolution as a widespread popular movement, during
> which in every town and village within the region of revolt, the masses will
> have to take it upon themselves **the work of construction upon communistic
> bases,** without awaiting any orders and directions from above . . . As to
> representative government, whether self-appointed or elected . . . , we
> place in it no hopes whatever. We know beforehand that it will be able to do
> nothing to accomplish the revolution as long as the people themselves do not
> accomplish the change by working out on the spot the necessary new
> institutions . . . nowhere and never in history do we find that people
> carried into government by a revolutionary wave, have proved equal to the
> occasion. _
>
> _"In the task of reconstructing society on new principles, separate men . .
> . are sure to fail. The collective spirit of the masses is necessary for
> this purpose . . . a socialist government . . . would be absolutely
> powerless without the activity of the people themselves, and that,
> necessarily, they would soon begin to act fatally as a bridle upon the
> revolution."_ [ **Op. Cit.** , pp. 188-190]

The Bolshevik revolution and its mania for centralism proved him right. The
use of centralisation helped ensure that workers' lost any meaningful say in
their revolution and helped alienate them from it. Instead of the mass
participation of all, the Bolsheviks ensured the top-down rule of a few.
Unsurprisingly, as mass participation is what centralism was designed to
exclude. Wishful thinking on behalf of the Bolshevik leaders (and their later-
day followers) could not (and can not) overcome the structural imperatives of
centralisation and its role in society. Nor could it stop the creation of a
bureaucracy around these new centralised institutions.

## 8 How did the aim for party power undermine the revolution?

As well as a passion for centralisation and state capitalism, Bolshevism had
another aim which helped undermine the revolution. This was the goal of party
power (see see [section 5](append41.md#app5) of the appendix ["What happened
during the Russian Revolution?"](append41.md) for details). Given this,
namely that the Bolsheviks had, from the start, aimed for party power it
should not come as too surprising that Bolshevik dictatorship quickly replaced
soviet democracy.

Given this obvious fact, it seems strange for modern day Leninists to blame
the civil war for the Bolsheviks substituting their rule for the masses. After
all, when strange for modern day Leninists to blame the civil war for the
Bolsheviks substituting their rule for the masses. After all, when the
Bolshevik Party took power in October 1917, it did "substitute" itself for the
working class and did so deliberately and knowingly. As we note in [section
2](append44.md#app2), this usurpation of power by a minority was perfectly
acceptable within the Marxist theory of the state, a theory which aided this
process no end.

Thus the Bolshevik party would be in power, with the _"conscious workers"_
ruling over the rest. The question instantly arises of what happens if the
masses turn against the party. If the Bolsheviks embody _"the power of the
proletariat,"_ what happens if the proletariat reject the party? The
undermining of soviet power by party power and the destruction of soviet
democracy in the spring and summer of 1918 answers that specific question (see
[section 6](append41.md#app6) of the appendix ["What happened during the
Russian Revolution?"](append41.md)). This should have come as no surprise,
given the stated aim (and implementation) of party power plus the Bolshevik
identification of party power with workers' power. It is not a great step to
party dictatorship **over** the proletariat from these premises (particularly
if we include the underlying assumptions of vanguardism -- see [section
H.5.3](secH5.md#sech53)). A step, we must stress, that the Bolsheviks
quickly took when faced with working class rejection in the soviet elections
of spring and summer of 1918.

Nor was this destruction of soviet democracy by party power just the result of
specific conditions in 1917-8. This perspective had been in Russian Marxist
circles well before the revolution. As we discuss in [section
H.5](secH5.md), vanguardism implies party power (see, as noted, [section
H.5.3](secH5.md#sech53) in particular). The ideas of Lenin's **What is to be
Done?** give the ideological justification for party dictatorship over the
masses. Once in power, the logic of vanguardism came into its own, allowing
the most disgraceful repression of working class freedoms to be justified in
terms of "Soviet Power" and other euphemisms for the party.

The identification of workers' power with party power has deeply undemocratic
results, as the experience of the Bolshevik proves. However, these results
were actually articulated in Russian socialist circles before hand. At the
divisive 1903 congress of the Russian Social Democrats, which saw the split
into two factions (Bolshevik and Menshevism) Plekhanov, the father of Russian
Marxism, argued as follows:

> _"Every particular democratic principle must be considered not in itself,
> abstractly, . . . the success of the revolution is the highest law. And if,
> for the success of the revolution's success, we need temporarily to restrict
> the functioning of a particular democratic principle, then it would be
> criminal to refrain from imposing that restriction. . . And we must take the
> same attitude where the question of the length of parliaments is concerned.
> If, in an outburst of revolutionary enthusiasm, the people elect a very good
> parliament . . . it would suit us to try and make that a **long Parliament**
> ; but if the elections turned out badly for us, we should have to try and
> disperse the resulting parliament not after two years but, if possible,
> after two weeks."_ [RSDLP, **Minutes of the Second Congress of the RSDLP** ,
> p. 220]

Another delegate argued that _"[t]here is not a single one among the
principles of democracy which we ought not to subordinate **to the interests
of our Party** . . . we must consider democratic principles exclusively from
the standpoint of the most rapid achievement of that aim [i.e. revolution],
from the standpoint of the interests of our Party. If any particular demand is
against our interests, we must not include it."_ To which, Plekhanov replied,
_"I fully associate myself with what Comrade Posadovksy has said."_ [ **Op.
Cit.** , p. 219 and p. 220] Lenin _"agreed unreservedly with this
subordination of democratic principles to party interests."_ [Oskar Anweiler,
**The Soviets** , p. 211]

Plekhanov at this time was linked with Lenin, although this association lasted
less than a year. After that, he became associated with the Mensheviks (before
his support for Russia in World War I saw him form his own faction). Needless
to say, he was mightily annoyed when Lenin threw his words back in his face in
1918 when the Bolsheviks disbanded the Constituent Assembly. Yet while
Plekhanov came to reject this position (perhaps because the elections had not
_"turned out badly for"_ his liking) it is obvious that the Bolsheviks
embraced it and keenly applied it to elections to soviets and unions as well
as Parliaments once in power (see [section 6](append41.md#app6) of the
appendix ["What happened during the Russian Revolution?"](append41.md) for
example). But, at the time, he sided with Lenin against the Mensheviks and it
can be argued that the latter applied these teachings of that most respected
pre-1914 Russian Marxist thinker.

This undemocratic perspective can also be seen when, in 1905, the St.
Petersburg Bolsheviks, like most of the party, opposed the soviets. They
argued that _"only a strong party along class lines can guide the proletarian
political movement and preserve the integrity of its program, rather than a
political mixture of this kind, an indeterminate and vacillating political
organisation such as the workers council represents and cannot help but
represent."_ [quoted by Oskar Anweiler, **The Soviets** , p. 77] Thus the
soviets could not reflect workers' interests because they were elected by the
workers!

The Bolsheviks saw the soviets as a rival to their party and demanded it
either accept their political program or simply become a trade-union like
organisation. They feared that it pushed aside the party committee and thus
led to the _"subordination of consciousness to spontaneity"_ and under the
label _"non-party"_ allow _"the rotten goods of bourgeois ideology"_ to be
introduced among the workers. [quoted by Anweilier, **Op. Cit.** , p. 78 and
p. 79] In this, the St. Petersburg Bolsheviks were simply following Lenin's
**What is to be Done?** , in which Lenin had argued that the _"
**spontaneous** development of the labour movement leads to it being
subordinated to bourgeois ideology."_ [ **Essential Works of Lenin** , p. 82]
Lenin in 1905, to his credit, rejected these clear conclusions of his own
theory and was more supportive of the soviets than his followers (although
_"he sided in principle with those who saw in the soviet the danger of
amorphous nonpartisan organisation."_ [Anweilier, **Op. Cit.** , p. 81]).

This perspective, however, is at the root of all Bolshevik justifications for
party power after the October revolution. The logical result of this position
can be found in the actions of the Bolsheviks in 1918 and onwards. For the
Bolsheviks in power, the soviets were less than important. The key for them
was to maintain Bolshevik party power and if soviet democracy was the price to
pay, then they were more than willing to pay it. As such, Bolshevik attitudes
in 1905 are significant:

> _"Despite the failure of the Bolshevik assault on the non-partisanship of
> the [St.] Petersburg Soviet, which may be dismissed as a passing episode . .
> . the attempt . . . is of particular significance in understanding the
> Bolshevik's mentality, political ambitions and **modus operandi.** First,
> starting in [St.] Petersburg, the Bolshevik campaign was repeated in a
> number of provincial soviets such as Kostroma and Tver, and, possibly,
> Sormovo. Second, the assault reveals that from the outset the Bolsheviks
> were distrustful of, if not hostile towards the Soviets, to which they had
> at best an instrumental and always party-minded attitude. Finally, the
> attempt to bring the [St.] Petersburg Soviet to heel is an early and major
> example of Bolshevik take-over techniques hitherto practised within the
> narrow confines of the underground party and now extended to the larger
> arena of open mass organisations such as soviets, with the ultimate aim of
> controlling them and turning them into one-party organisations, or, failing
> that, of destroying them."_ [Israel Getzler, _"The Bolshevik Onslaught on
> the Non-Party 'Political Profile' of the Petersburg Soviet of Workers'
> Deputies October-November 1905",_ **Revolutionary History** , pp. 123-146,
> vol. 5, no. 2, pp. 124-5]

The instrumentalist approach of the Bolsheviks post-1917 can be seen from
their arguments and attitudes in 1905. On the day the Moscow soviet opened, a
congress of the northern committees of the Social Democratic Party passed a
resolution stating that a _"council of workers deputies should be established
only in places where the party organisation has no other means of directing
the proletariat's revolutionary action . . . The soviet of workers deputies
must be a technical instrument of the party for the purpose of giving
political leadership to the masses through the RSDWP [the Social-Democratic
Party]. It is therefore imperative to gain control of the soviet and prevail
upon it to recognise the program and political leadership of the RSDWP."_
[quoted by Anweilier, **Op. Cit.** , p. 79]

This perspective that the party should be given precedence can be seen in
Lenin's comment that while the Bolsheviks should _"go along with the
unpoliticalised proletarians, but on no account and at no time should we
forget that animosity among the proletariat toward the Social Democrats is a
remnant of bourgeois attitudes . . . Participation in unaffiliated
organisations can be permitted to socialists only as an exception . . . only
if the independence of the workers party is guaranteed and if within
unaffiliated organisations or soviets individual delegates or party groups are
subject to unconditional control and guidance by the party executive."_
[quoted by Anweilier, **Op. Cit.** , p. 81] These comments have clear links to
Lenin's argument in 1920 that working class protest against the Bolsheviks
showed that they had become _"declassed"_ (see [section 5](append43.md#app5)
of the appendix on ["What caused the degeneration of the Russian
Revolution?"](append43.md)). It similarly allows soviets to be disbanded if
Bolsheviks are not elected (which they were, see [section
6](append41.md#app6) of the appendix ["What happened during the Russian
Revolution?"](append41.md)). It also ensures that Bolshevik representatives
to the soviets are not delegates from the workplace, but rather a
"transmission belt" (to use a phrase from the 1920s) for the decisions of the
party leadership. In a nutshell, Bolshevik soviets would represent the party's
central committee, not those who elected them. As Oskar Anweiler summarised:

> _"The 'revolutionary genius' of the people, which Lenin had mentioned and
> which was present in the soviets, constantly harboured the danger of
> 'anarcho-syndicalist tendencies' that Lenin fought against all his life. He
> detected this danger early in the development of the soviets and hoped to
> subdue it by subordinating the soviets to the party. The drawback of the new
> 'soviet democracy' hailed by Lenin in 1906 is that he could envisage the
> soviets only as **controlled** organisations; for him they were the
> instruments by which the party controlled the working masses, rather than
> true forms of a workers democracy."_ [ **Op. Cit.** , p. 85]

As we noted in [section H.3.11](secH3.md#sech311), Lenin had concluded in
1907 that while the party could _"utilise"_ the soviets _"for the purpose of
developing the Social-Democratic movement,"_ the party _"must bear in mind
that if Social-Democratic activities among the proletarian masses are
properly, effectively and widely organised, such institutions may actually
become superfluous."_ [Marx, Engels and Lenin, **Anarchism and Anarcho-
Syndicalism** , p. 210] Thus the means by which working class can manage their
own affairs would become _"superfluous"_ once the party was in power. As
Samuel Farber argues, Lenin's position before 1917 was _"clearly implying that
the party could normally fulfil its revolutionary role without the existence
of broad class organisations . . . Consequently, Lenin's and the party's
eventual endorsement of the soviets in 1905 seems to have been tactical in
character. That is, the Bolshevik support for the soviets did not at the time
signify a theoretical and/or principled commitment to these institutions as
revolutionary organs to overthrow the old society, let alone as key structural
ingredients of the post-revolutionary order. Furthermore, it is again
revealing that from 1905 to 1917 the concept of soviets did not play an
important role in the thinking of Lenin or of the Bolshevik Party . . .
[T]hese strategies and tactics vis-a-vis the soviets . . . can be fairly seen
as expressing a predisposition favouring the party and downgrading the soviets
and other non-party class organisations, at least in relative terms."_ [
**Before Stalinism** , p. 37] Such a perspective on the soviets can be seen
once the party was in power when they quickly turned them, without concern,
into mere fig-leafs for party power (see [section 6](append41.md#app6) of
the appendix ["What happened during the Russian Revolution?"](append41.md)
for more details).

It cannot be mere coincidence that the ideas and rhetoric against the soviets
in 1905 should resurface again once the Bolsheviks were in power. For example,
in 1905, in St. Petersburg _"the Bolsheviks pressed on"_ with their campaign
and, _"according to the testimony of Vladimir Voitinskii, then a young
Bolshevik agitator, the initial thrust of the Bolshevik 'plan' was to push the
SRs [who were in a minority] out of the Soviet, while 'the final blow' would
be directed against the Mensheviks. Voitinskii also recalled the heated
argument advanced by the popular agitator Nikolai Krylenko ('Abram') for the
'dispersal of the Soviet' should it reject the 'ultimatum' to declare its
affiliation with the RSDP."_ [Getzler, **Op., Cit.** , pp. 127-8] This
mirrored events in 1918. Then _"at the local political level"_ Bolshevik
majorities were attained ( _"by means fair, foul and terrorist"_ ) _"in the
plenary assemblies of the soviets, and with the barring of all those not
'completely dedicated to Soviet power' [i.e. Mensheviks and SRs] from the
newly established network of soviet administrative departments and from the
soviet militias. Soviets where Bolshevik majorities could not be achieved were
simply disbanded."_ A similar process occurred at the summit (see [section
7](append44.md#app7)). Thus _"the October revolution marked [the soviets]
transformation from agents of democratisation into regional and local
administrative organs of the centralised, one-party Soviet state."_ [Israel
Getzler, **Soviets as Agents of Democratisation** , p. 27 and pp. 26-7]

Can such an outcome really have **no** link at all with the Bolshevik position
and practice in period before 1917 and, in particular, during the 1905
revolution? Obviously not. As such, we should not be too surprised or shocked
when Lenin replied to a critic who assailed the "dictatorship of one party" in
1919 by clearly and unashamedly stating: _"Yes, the dictatorship of one party!
We stand upon it and cannot depart from this ground, since this is the party
which in the course of decades has won for itself the position of vanguard of
the whole factory and industrial proletariat."_ [quoted by E.H. Carr, **The
Bolshevik Revolution** , vol. 1, p. 236] Or when he replied to a critic in
1920 that _"[h]e says we understand by the words dictatorship of proletariat
what is actually the dictatorship of its determined and conscious minority.
And that is the fact."_ This _"minority . . . may be called a party,"_ Lenin
stressed. [quoted by Arthur Ransome, **The Crisis in Russia 1920** , p. 35]

This perspective can be traced back to the underlying ideology expounded by
the Bolsheviks before and during 1917. For example, mere days after seizing
power in the October Revolution Lenin was stressing that the Bolsheviks'
_"present slogan is: No compromise, i.e. for a homogeneous Boshevik
government."_ He did not hesitate to use the threat to _"appeal to the
sailors"_ against the other socialist parties, stating _"[i]f you get the
majority, take power in the Central Executive Committee and carry one. But we
will go to the sailors."_ [quoted by Tony Cliff, **Lenin** , vol. 3, p. 26]
Clearly soviet power was far from Lenin's mind, rejecting soviet democracy if
need be in favour of party power. Strangely, Cliff (a supporter of Lenin)
states that Lenin _"did not visualise one-party rule"_ and that the _"first
decrees and laws issued after the October revolution were full of repetitions
of the word 'democracy.'"_ [ **Op. Cit.** , p. 161 and p. 146] He goes on to
quote Lenin stating that _"[a]s a democratic government we cannot ignore the
decision of the masses of the people, even though we disagree with it."_ Cliff
strangely fails to mention that Lenin also applied this not only to the land
decree (as Cliff notes) but also to the Constituent Assembly. _"And even if,"_
Lenin continued, _"the peasants continue to follow the Socialist
Revolutionaries, even if they give this party a majority in the Constituent
Assembly, we shall still say -- what of it?"_ [Lenin, **Collected Works** ,
vol. 26, pp. 260-1] But the Bolsheviks disbanded the Constituent Assembly
after one session. The peasants had voted for the SRs and the Assembly went
the same way as Lenin's promises. And if Lenin's promises of 1917 on the
Assembly proved to be of little value, then why should his various comments to
soviet democracy be considered any different? In a clash between soviet
democracy and party power, the Bolsheviks consistently favoured the latter.

Thus Bolshevik ideology had consistently favoured party power and had a long
term ideological preference for it. Combine this aim of party power with a
vanguardism position (see [section H.5](secH5.md)) and party dictatorship
will soon result. Neil Harding summarises the issue well:

> _"There were a number of very basic axioms that lay at the very heart of the
> theory and practice of Leninism with regard to the party . . . It was the
> party that disposed of scientific or objective knowledge. Its analysis of
> the strivings of the proletariat was, therefore, privileged over the
> proletariat's own class goals and a single discernible class will was,
> similarly, axiomatic to both Marxism and Leninism. Both maintained that it
> was the communists who alone articulated these goals and this will -- that
> was the party's principal historical role._
>
> _"At this point, Leninism (again faithful to the Marxist original) resorted
> to a little-noticed definitional conjuring trick -- one that proved to be of
> crucial importance for the mesmeric effect of the ideology. The trick was
> spectacularly simple and audacious -- the class was defined as class only to
> the extent that it conformed to the **party's** account of its objectives,
> and mobilised itself to fulfil them. . . . The messy, real proletarians --
> the aggregation of wage workers with all their diverse projects and
> aspirations -- were to be judged by their progress towards a properly class
> existence by the party that had itself devised the criteria for the class
> existence."_ [ **Leninism** , pp. 173-4]

This authoritarian position, which allows "socialism" to be imposed by force
upon the working class, lies at the core of Leninism. Ironically, while
Bolshevism claims to be **the** party of the working class, representing it
essentially or exclusively, they do so in the name of possessing a theory
that, qua theory, can be the possession of intellectuals and, therefore, has
to be "introduced" to the working class from outside (see [section
H.5.1](secH5.md#sech51) for details).

This means that Bolshevism is rooted in the identification of "class
consciousness" with supporting the party. Given the underlying premises of
vanguardism, unsurprisingly the Bolsheviks took "class consciousness" to mean
this. If the workers protested against the policies of the party, this
represented a fall in class consciousness and, therefore, working class
resistance placed "class" power in danger. If, on the other hand, the workers
remained quiet and followed the party's decision then, obviously, they showed
high levels of class consciousness. The net effect of this position was, of
course, to justify party dictatorship. Which, of course, the Bolsheviks did
create **and** justified ideologically.

Thus the Bolshevik aim for party power results in disempowering the working
class in practice. Moreover, the assumptions of vanguardism ensure that only
the party leadership is able to judge what is and is not in the interests of
the working class. Any disagreement by elements of that class or the whole
class itself can be dismissed as _"wavering"_ and _"vacillation."_ While this
is perfectly acceptable within the Leninist _"from above"_ perspective, from
an anarchist _"from below"_ perspective it means little more than pseudo-
theoretical justification for party dictatorship **over** the proletariat and
the ensuring that a socialist society will **never** be created. Ultimately,
socialism without freedom is meaningless -- as the Bolshevik regime proved
time and time again.

As such, to claim that the Bolsheviks did not aim to "substitute" party power
for working class power seems inconsistent with both Bolshevik theory and
practice. Lenin had been aiming for party power from the start, identifying it
with working class power. As the party was the vanguard of the proletariat, it
was duty bound to seize power and govern on behalf of the masses and,
moreover, take any actions necessary to maintain the revolution -- even if
these actions violated the basic principles required to have any form of
meaningful workers' democracy and freedom. Thus the _"dictatorship of the
proletariat"_ had long become equated with party power and, once in power, it
was only a matter of time before it became the _"dictatorship of the party."_
And once this did occur, none of the leading Bolsheviks questioned it. The
implications of these Bolshevik perspectives came clear after 1917, when the
Bolsheviks raised the need for party dictatorship to an ideological truism.

Thus it seems strange to hear some Leninists complain that the rise of
Stalinism can be explained by the rising "independence" of the state machine
from the class (i.e. party) it claimed to in service of. Needless to say, few
Leninists ponder the links between the rising _"independence"_ of the state
machine from the proletariat (by which most, in fact, mean the _"vanguard"_ of
the proletariat, the party) and Bolshevik ideology. As noted in [section
H.3.8](secH3.md#sech38), a key development in Bolshevik theory on the state
was the perceived need for the vanguard to ignore the wishes of the class it
claimed to represent and lead. For example, Victor Serge (writing in the
1920s) considered it a truism that the _"party of the proletariat must know,
at hours of decision, how to break the resistance of the backward elements
among the masses; it must know how to stand firm sometimes against the masses
. . . it must know how to go against the current, and cause proletarian
consciousness to prevail against lack of consciousness and against alien class
influences."_ [ **Year One of the Russian Revolution** , p. 218]

The problem with this is that, by definition, **everyone** is backward in
comparison to the vanguard party. Moreover, in Bolshevik ideology it is the
party which determines what is and is not _"proletarian consciousness."_ Thus
we have the party ideologue presenting self-justifications for party power
**over** the working class. Now, is the vanguard is to be able to ignore the
masses then it must have power **over** them. Moreover, to be independent of
the masses the machine it relies on to implement its power must also, by
definition, be independent of the masses. Can we be surprised, therefore, with
the rise of the "independent" state bureaucracy in such circumstances? If the
state machine is to be independent of the masses then why should we expect it
not to become independent of the vanguard? Surely it must be the case that we
would be far more surprised if the state machine did **not** become
"independent" of the ruling party?

Nor can it be said that the Bolsheviks learned from the experience of the
Russian Revolution. This can be seen from Trotsky's 1937 comments that the
_"proletariat can take power only through its vanguard. In itself the
necessity for state power arises from the insufficient cultural level of the
masses and their heterogeneity."_ Thus _"state power"_ is required **not** to
defend the revolution against reaction but from the working class itself, who
do not have a high enough _"cultural level"_ to govern themselves. At best,
their role is that of a passive supporter, for "[w]ithout the confidence of
the class in the vanguard, without support of the vanguard by the class, there
can be no talk of the conquest of power." While soviets _"are the only
organised form of the tie between the vanguard and the class"_ it does not
mean that they are organs of self-management. No, a _"revolutionary content
can be given . . . only by the party. This is proved by the positive
experience of the October Revolution and by the negative experience of other
countries (Germany, Austria, finally, Spain)."_ [ **Stalinism and Bolshevism**
]

Sadly, Trotsky failed to explicitly address the question of what happens when
the _"masses"_ stop having _"confidence in the vanguard"_ and decides to
support some other group. After all, if a _"revolutionary content"_ can only
be given by _"the party"_ then if the masses reject the party then the soviets
can no only be revolutionary. To save the revolution, it would be necessary to
destroy the democracy and power of the soviets. Which is **exactly** what the
Bolsheviks did do in 1918. By equating popular power with party power
Bolshevism not only opens the door to party dictatorship, it invites it in,
gives it some coffee and asks it to make itself a home! Nor can it be said
that Trotsky ever appreciated Kropotkin's _"general observation"_ that _"those
who preach dictatorship do not in general perceive that in sustaining their
prejudice they only prepare the way for those who later on will cut their
throats."_ [ **Kropotkin's Revolutionary Pamphlets** , p. 244]

In summary, it cannot be a coincidence that once in power the Bolsheviks acted
in ways which had clear links to the political ideology it had been advocating
before hand. As such, the Bolshevik aim for party power helped undermine the
real power of working class people during the Russian revolution. Rooted in a
deeply anti-democratic political tradition, it was ideologically predisposed
to substitute party power for soviet power and, finally, to create -- and
justify -- the dictatorship **over** the proletariat. The civil war may have
shaped certain aspects of these authoritarian tendencies but it did not create
them.

[‹ What caused the degeneration of the Russian Revolution?](append43.md "Go
to previous page") [up](append4.md "Go to parent page") [Were any of the
Bolshevik oppositions a real alternative? ›](append45.md "Go to next page")

