!{\src2tex{textfont=tt}}
!!****f* ABINIT/opernlb_ylm
!! NAME
!! opernlb_ylm
!!
!! FUNCTION
!! * Operate with the non-local part of the hamiltonian,
!!   from projected scalars to reciprocal space.
!! * Operate with the non-local projectors and the overlap matrix,
!!   from projected scalars to reciprocal space.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  choice=chooses possible output (see below)
!!  cplex=1 if <p_lmn|c> scalars are real (equivalent to istwfk>1)
!!        2 if <p_lmn|c> scalars are complex
!!  dgxdtfac(cplex,ndgxdtfac,nlmn,nincat)= gradients of gxfac
!!  dimffnl=second dimension of ffnl
!!  ffnl(npw,dimffnl,nlmn)= nonlocal quantities containing nonlocal form factors
!!  gxfac(cplex,nlmn,nincat)= reduced projected scalars related to Vnl (NL operator)
!!  gxfac_sij(cplex,nlmn,nincat*(paw_opt/3))= reduced projected scalars related to Sij (overlap)
!!  ia3=gives the number of the first atom in the subset presently treated
!!  idir=direction of the - atom to be moved in the case (choice=2,signs=2),
!!                        - k point direction in the case (choice=5,signs=2)
!!                        - strain component (1:6) in the case (choice=2,signs=2) or (choice=6,signs=1)
!!  indlmn(6,nlmn)= array giving l,m,n,lm,ln,s for i=lmn
!!  kpg(npw,nkpg)=(k+G) components (if nkpg=3)
!!  matblk=dimension of the array ph3d
!!  ndgxdtfac=second dimension of dgxdtfac
!!  nincat=number of atoms in the subset here treated
!!  nkpg=second dimension of array kpg (0 or 3)
!!  nlmn=number of (l,m,n) numbers for current type of atom
!!  nloalg(5)=governs the choice of the algorithm for non-local operator.
!!  npw=number of plane waves in reciprocal space
!!  paw_opt= define the nonlocal operator concerned with:
!!           paw_opt=0 : Norm-conserving Vnl (use of Kleinman-Bylander ener.)
!!           paw_opt=1 : PAW nonlocal part of H (use of Dij coeffs)
!!           paw_opt=2 : PAW: (Vnl-lambda.Sij) (Sij=overlap matrix)
!!           paw_opt=3 : PAW overlap matrix (Sij)
!!           paw_opt=4 : both PAW nonlocal part of H (Dij) and overlap matrix (Sij)
!!  ph3d(2,npw,matblk)=three-dimensional phase factors
!!  ucvol=unit cell volume (bohr^3)
!!
!! OUTPUT
!!  (see side effects)
!!
!! SIDE EFFECTS
!! --if (paw_opt=0, 1 or 4)
!!    vectout(2*npw)=result of the aplication of the concerned operator
!!                or one of its derivatives to the input vect.:
!!      if (choice=1) <G|V_nonlocal|vect_start>
!!      if (choice=2) <G|dV_nonlocal/d(atm coord)|vect_start>
!!      if (choice=3) <G|dV_nonlocal/d(strain)|vect_start>
!!      if (choice=5) <G|dV_nonlocal/dk|vect_start>
!!  if (paw_opt=2)
!!    vectout(2*npw)=final vector in reciprocal space:
!!      if (choice=1) <G|V_nonlocal-lamdba.(I+S)|vect_start>
!!      if (choice=2) <G|d[V_nonlocal-lamdba.(I+S)]/d(atm coord)|vect_start>
!!      if (choice=3) <G|d[V_nonlocal-lamdba.(I+S)]/d(strain)|vect_start>
!!      if (choice=5) <G|d[V_nonlocal-lamdba.(I+S)]/dk|vect_start>
!! --if (paw_opt=3 or 4)
!!    svectout(2*npw)=result of the aplication of Sij (overlap matrix)
!!                  to the input vect.:
!!      if (choice=1) <G|I+S|vect_start>  (S= overlap matrix)
!! --if (paw_opt=-1)
!!    not available
!!
!! NOTES
!! Operate for one type of atom, and within this given type of atom,
!! for a subset of at most nincat atoms.
!!
!! PARENTS
!!      nonlop_ylm
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine opernlb_ylm(choice,cplex,dgxdtfac,dimffnl,ffnl,gxfac,gxfac_sij,ia3,idir,&
&                       indlmn,kpg,matblk,ndgxdtfac,nincat,nkpg,nlmn,nloalg,npw,&
&                       paw_opt,ph3d,svect,ucvol,vect)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: choice,cplex,dimffnl,ia3,idir,matblk,ndgxdtfac,nincat,nkpg
 integer,intent(in) :: nlmn,npw,paw_opt
 real(dp),intent(in) :: ucvol
!arrays
 integer,intent(in) :: indlmn(6,nlmn),nloalg(5)
 real(dp),intent(in) :: dgxdtfac(cplex,ndgxdtfac,nlmn,nincat)
 real(dp),intent(in) :: ffnl(npw,dimffnl,nlmn),gxfac(cplex,nlmn,nincat)
 real(dp),intent(in) :: gxfac_sij(cplex,nlmn,nincat*(paw_opt/3)),kpg(npw,nkpg)
 real(dp),intent(in) :: ph3d(2,npw,matblk)
 real(dp),intent(inout) :: svect(2,npw*(paw_opt/3)),vect(2,npw)

!Local variables-------------------------------
!scalars
 integer :: ia,iaph3d,ii,il,ilmn,iplex
 real(dp) :: scale,wt
 logical :: parity
!Arrays
 real(dp),allocatable :: dgxdtfac_(:,:,:),gxfac_(:,:),gxfacs_(:,:)
 complex(dp),allocatable :: ztab(:)
 
! *************************************************************************

!Nothing to do when choice=4
 if (paw_opt==-1.or.choice==4.or.choice==6.or.choice==23) return

!Inits
 wt=four_pi/sqrt(ucvol)
 allocate(gxfac_(2,nlmn))
 if (choice>1) allocate(dgxdtfac_(2,ndgxdtfac,nlmn))
 if (paw_opt>=3) allocate(gxfacs_(2,nlmn))

!Loops (blocking)
!$OMP PARALLEL DEFAULT(PRIVATE) &
!$OMP&SHARED(choice,nincat,nloalg,ia3,npw,nlmn,wt,indlmn)
!$OMP&SHARED(ffnl,gxfac,gxfac_,dgxdtfac,dgxdtfax_,kpg,ph3d,vect)
!$OMP DO

!Loop on atoms
 do ia=1,nincat
  iaph3d=ia;if (nloalg(1)>0) iaph3d=ia+ia3-1

! Scale gxfac with 4pi/sqr(omega).(-i)^l
  if (paw_opt/=3) then
   do ilmn=1,nlmn
    il=mod(indlmn(1,ilmn),4);parity=(mod(il,2)==0)
    scale=wt;if (il>1) scale=-scale
    if (parity) then
     gxfac_(1:cplex,ilmn)=scale*gxfac(1:cplex,ilmn,ia)
     if (cplex==1) gxfac_(2,ilmn)=zero
    else
     gxfac_(2,ilmn)=-scale*gxfac(1,ilmn,ia)
     if (cplex==2) then
      gxfac_(1,ilmn)=scale*gxfac(2,ilmn,ia)
     else
      gxfac_(1,ilmn)=zero
     end if
    end if
   end do
   if (choice>1) then
    do ilmn=1,nlmn
     il=mod(indlmn(1,ilmn),4);parity=(mod(il,2)==0)
     scale=wt;if (il>1) scale=-scale
     if (parity) then
      dgxdtfac_(1:cplex,1:ndgxdtfac,ilmn)=scale*dgxdtfac(1:cplex,1:ndgxdtfac,ilmn,ia)
      if (cplex==1) dgxdtfac_(2,1:ndgxdtfac,ilmn)=zero
     else
      do ii=1,ndgxdtfac
       dgxdtfac_(2,ii,ilmn)=-scale*dgxdtfac(1,ii,ilmn,ia)
       if (cplex==2) then
        dgxdtfac_(1,ii,ilmn)=scale*dgxdtfac(2,ii,ilmn,ia)
       else
        dgxdtfac_(1,ii,ilmn)=zero
       end if
      end do
     end if
    end do
   end if
  end if
  if (paw_opt>=3) then
   do ilmn=1,nlmn
    il=mod(indlmn(1,ilmn),4);parity=(mod(il,2)==0)
    scale=wt;if (il>1) scale=-scale
    if (parity) then
     gxfacs_(1:cplex,ilmn)=scale*gxfac_sij(1:cplex,ilmn,ia)
     if (cplex==1) gxfacs_(2,ilmn)=zero
    else
     gxfacs_(2,ilmn)=-scale*gxfac_sij(1,ilmn,ia)
     if (cplex==2) then
      gxfacs_(1,ilmn)=scale*gxfac_sij(2,ilmn,ia)
     else
      gxfacs_(1,ilmn)=zero
     end if
    end if
   end do
  end if

! Compute <g|Vnl|c> (or derivatives) for each plane wave:
  
  allocate(ztab(npw));ztab(:)=czero
  
  if (paw_opt/=3) then
        
   if (choice==1) then
    do ilmn=1,nlmn
     ztab(:)=ztab(:)+ffnl(:,1,ilmn)*cmplx(gxfac_(1,ilmn),gxfac_(2,ilmn),kind=dp)
    end do
   end if

   if (choice==2) then
    do ilmn=1,nlmn
     ztab(:)=ztab(:)+ffnl(:,1,ilmn)*cmplx(gxfac_(2,ilmn),-gxfac_(1,ilmn),kind=dp)
    end do
    ztab(:)=two_pi*kpg(:,idir)*ztab(:)
    do ilmn=1,nlmn
     ztab(:)=ztab(:)+ffnl(:,1,ilmn)*cmplx(dgxdtfac_(1,1,ilmn),dgxdtfac_(2,1,ilmn),kind=dp)
    end do
   end if
   
   if (choice==3) then
    if (idir<=3) then
     do ilmn=1,nlmn
      ztab(:)=ztab(:)+ffnl(:,1,ilmn)&
&            *cmplx(dgxdtfac_(1,1,ilmn)-gxfac_(1,ilmn),dgxdtfac_(2,1,ilmn)-gxfac_(2,ilmn),kind=dp)&
&                    -ffnl(:,2,ilmn)*cmplx(gxfac_(1,ilmn),gxfac_(2,ilmn),kind=dp)
     end do
    else
     do ilmn=1,nlmn
      ztab(:)=ztab(:)+ffnl(:,1,ilmn)*cmplx(dgxdtfac_(1,1,ilmn),dgxdtfac_(2,1,ilmn),kind=dp)&
&                    -ffnl(:,2,ilmn)*cmplx(gxfac_(1,ilmn),gxfac_(2,ilmn),kind=dp)
     end do
    end if
   end if
   
   if (choice==5) then
    do ilmn=1,nlmn
     ztab(:)=ztab(:)+ffnl(:,1,ilmn)*cmplx(dgxdtfac_(1,1,ilmn),dgxdtfac_(2,1,ilmn),kind=dp)&
&                   +ffnl(:,2,ilmn)*cmplx(gxfac_(1,ilmn),gxfac_(2,ilmn),kind=dp)
    end do
   end if
   
   ztab(:)=ztab(:)*cmplx(ph3d(1,:,iaph3d),-ph3d(2,:,iaph3d),kind=dp)
   vect(1,:)=vect(1,:)+real(ztab(:))
   vect(2,:)=vect(2,:)+aimag(ztab(:))

  end if 

  if (paw_opt>=3.and.choice==1) then
   ztab(:)=czero
   do ilmn=1,nlmn
    ztab(:)=ztab(:)+ffnl(:,1,ilmn)*cmplx(gxfacs_(1,ilmn),gxfacs_(2,ilmn),kind=dp)
   end do
   ztab(:)=ztab(:)*cmplx(ph3d(1,:,iaph3d),-ph3d(2,:,iaph3d),kind=dp)
   svect(1,:)=svect(1,:)+real(ztab(:))
   svect(2,:)=svect(2,:)+aimag(ztab(:))
  end if

  deallocate(ztab)

!End loop on atoms
 end do
!$OMP END DO
!$OMP END PARALLEL

 deallocate(gxfac_);if (choice>1) deallocate(dgxdtfac_)
 if (paw_opt>=3) deallocate(gxfacs_)

end subroutine opernlb_ylm
!!***
