#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Rakuen
# send your bug reports to contact@dotslashplay.it
###

script_version=20231114.11

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='rakuen'
GAME_NAME='Rakuen'

ARCHIVE_BASE_0_NAME='rakuen_linux.tgz'
ARCHIVE_BASE_0_MD5='cae92b2e92cd4e15796a7faa765d2e64'
ARCHIVE_BASE_0_SIZE='200000'
ARCHIVE_BASE_0_VERSION='1.0-humble1'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/rakuen'

CONTENT_PATH_DEFAULT='Rakuen'
## FIXME: Some sound effects do not play, they might require the shipped builds of some libraries.
##        The displayed error is "Unable to decode sound: (…): Sound format unsupported".
CONTENT_LIBS_BIN_FILES='
libruby.so.2.1'
## The shipped build of libphysfs.so.1 must be used, or the game will fail to find some required data files.
CONTENT_LIBS_BIN_FILES="${CONTENT_LIBS_BIN_FILES:-}
libphysfs.so.1"
CONTENT_LIBS_BIN64_PATH="${CONTENT_PATH_DEFAULT}/lib64"
CONTENT_LIBS_BIN64_FILES="$CONTENT_LIBS_BIN_FILES"
CONTENT_LIBS_BIN32_PATH="${CONTENT_PATH_DEFAULT}/lib"
CONTENT_LIBS_BIN32_FILES="$CONTENT_LIBS_BIN_FILES"
CONTENT_GAME_BIN64_FILES='
Rakuen.amd64'
CONTENT_GAME_BIN32_FILES='
Rakuen.x86'
CONTENT_GAME_DATA_FILES='
Audio
Engine.ini
Engine.rgssad
Fonts
icon.png
mkxp
mkxp.conf'
CONTENT_DOC_DATA_FILES='
*.pdf'

APP_MAIN_EXE_BIN64='Rakuen.amd64'
APP_MAIN_EXE_BIN32='Rakuen.x86'
APP_MAIN_ICON='icon.png'
## The game engine fails to find required game data when using a symlinks farm prefix.
APP_MAIN_PREFIX_TYPE='none'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN32_DEPS="$PKG_BIN_DEPS"
PKG_BIN64_DEPS="$PKG_BIN_DEPS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libcrypt.so.1
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libopenal.so.1
libpixman-1.so.0
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libSDL2_image-2.0.so.0
libSDL2_ttf-2.0.so.0
libSDL_sound-1.0.so.1
libsigc-2.0.so.0
libstdc++.so.6
libvorbisfile.so.3
libz.so.1'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	## Prevent the inclusion of MacOS archive junk files.
	find -type f -name '._*' -delete
)

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN64'
launchers_write
set_current_package 'PKG_BIN32'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
