#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Dustforce
# send your bug reports to contact@dotslashplay.it
###

script_version=20240528.1

PLAYIT_COMPATIBILITY_LEVEL='2.28'

GAME_ID='dustforce'
GAME_NAME='Dustforce DX'

ARCHIVE_BASE_0_NAME='gog_dustforce_dx_2.2.0.5.sh'
ARCHIVE_BASE_0_MD5='5423718cf31f2602c9d0b30b79d1f409'
ARCHIVE_BASE_0_SIZE='409517'
ARCHIVE_BASE_0_VERSION='2014.12.22-gog2.2.0.5'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/dustforce_dx'

CONTENT_PATH_DEFAULT='data/noarch/game'
# TODO: Check if some shipped libraries could be dropped in favour of system-provided ones.
CONTENT_LIBS_BIN_FILES='
libcurl.so.3
libopenal.so.1
libSDL2-2.0.so.0'
CONTENT_LIBS_BIN64_PATH="${CONTENT_PATH_DEFAULT}/lib64"
CONTENT_LIBS_BIN64_FILES="$CONTENT_LIBS_BIN32_FILES"
CONTENT_LIBS_BIN32_PATH="${CONTENT_PATH_DEFAULT}/lib"
CONTENT_LIBS_BIN32_FILES="$CONTENT_LIBS_BIN32_FILES"
CONTENT_GAME_BIN64_FILES='
Dustforce.bin.x86_64'
CONTENT_GAME_BIN32_FILES='
Dustforce.bin.x86'
CONTENT_GAME_DATA_FILES='
content
Dustforce.png'
CONTENT_DOC_DATA_FILES='
Linux.README
ReadMe.txt'

APP_MAIN_EXE_BIN64='Dustforce.bin.x86_64'
APP_MAIN_EXE_BIN32='Dustforce.bin.x86'
APP_MAIN_ICON='Dustforce.png'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN64_DEPS="$PKG_BIN_DEPS"
PKG_BIN32_DEPS="$PKG_BIN_DEPS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libidn.so.11
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libz.so.1'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
