/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.activity.CuptiActivityFunction;
import com.nvidia.viper.activity.CuptiActivitySourceLocator;
import com.nvidia.viper.analysis.AnalysisResultSourceLevel;
import com.nvidia.viper.analysis.AnalysisResultSourceLevelKind;
import com.nvidia.viper.editor.CudaFunction;
import com.nvidia.viper.model.CudaFunctionManager;
import com.nvidia.viper.model.ModelWithProperties;
import com.nvidia.viper.model.SassInstruction;
import com.nvidia.viper.model.Session;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class SourceSassModel
extends ModelWithProperties {
    public static final String PROPERTY_FILE_CHANGED = "sourcesassmodel:filechanged";
    public static final String PROPERTY_ANALYSIS_CHANGED = "sourcesassmodel:analysischanged";
    private Session session;
    private AnalysisResultSourceLevel sourceLevelResult;
    private List<SassInstruction> sassInstructions;
    private Map<Integer, List<Integer>> sourceSassMap;
    private String fileName;
    private Set<String> sourceFiles;
    private int lineToSelect;
    private int functionId;
    Set<AnalysisResultSourceLevel> sourceLevelResults;
    private boolean gprInfo = false;

    public SourceSassModel(Session session, AnalysisResultSourceLevel sourceLevelResult) {
        this.init(session, sourceLevelResult);
        this.collectSassInstructions();
    }

    public SourceSassModel(Session session, AnalysisResultSourceLevel sourceLevelResult, String fileName, int lineToSelect) {
        this.init(session, sourceLevelResult);
        this.fileName = fileName;
        this.lineToSelect = lineToSelect;
        this.collectSassInstructions();
    }

    public SourceSassModel(Session session, AnalysisResultSourceLevel sourceLevelResult, int functionId) {
        this.init(session, sourceLevelResult);
        this.functionId = functionId;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && workbench.getActiveWorkbenchWindow() != null) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(workbench.getActiveWorkbenchWindow().getShell());
            try {
                dialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(ViperMessages.Pc_Sampling_InProgress_Message, 100);
                        Thread computeThread = new Thread("Source Sass"){

                            @Override
                            public void run() {
                                SourceSassModel.this.collectSassInstructions();
                            }
                        };
                        computeThread.start();
                        computeThread.join();
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                dialog.close();
            }
        } else {
            this.collectSassInstructions();
        }
    }

    private void init(Session session, AnalysisResultSourceLevel sourceLevelResult) {
        this.session = session;
        this.sourceLevelResult = sourceLevelResult;
        this.functionId = -1;
        this.lineToSelect = -1;
        this.sourceLevelResults = new HashSet<AnalysisResultSourceLevel>();
        this.sourceLevelResults.add(sourceLevelResult);
    }

    private void collectSassInstructions() {
        if (this.session != null) {
            if (this.sassInstructions == null) {
                this.sassInstructions = new ArrayList<SassInstruction>();
            } else {
                this.sassInstructions.clear();
            }
            if (this.sourceSassMap == null) {
                this.sourceSassMap = new HashMap<Integer, List<Integer>>();
            } else {
                this.sourceSassMap.clear();
            }
            CudaFunctionManager cudaFunctionManager = this.session.getCudaFunctionManager();
            Collection<CuptiActivityFunction> cuptiActivityFunctions = cudaFunctionManager.getFunctions();
            for (CuptiActivityFunction function : cuptiActivityFunctions) {
                CudaFunction cudaFunction = cudaFunctionManager.getCudaFunction(function, false);
                if (cudaFunction == null || !cudaFunction.updateSourceLocator(this.sourceLevelResult, function.id)) continue;
                List<SassInstruction> instructionList = cudaFunction.getSassInstructions();
                for (SassInstruction inst : instructionList) {
                    if (inst.getSourcelocatorid() == -1) {
                        inst.setSourcelocatorid(cudaFunctionManager.getSourceLocatorId(inst.getPcOffset(), function.id));
                    }
                    int locatorId = inst.getSourcelocatorid();
                    CuptiActivitySourceLocator locator = this.session.getSourceLocator().getLocation(locatorId);
                    if (locator == null) continue;
                    if (this.functionId == function.id && this.fileName == null) {
                        this.fileName = locator.fileName;
                    }
                    if (this.sourceFiles == null) {
                        this.sourceFiles = new HashSet<String>();
                    }
                    this.sourceFiles.add(locator.fileName);
                }
                this.sassInstructions.addAll(instructionList);
            }
        }
    }

    public int getLineToSelect() {
        return this.lineToSelect;
    }

    public List<Integer> getSassLinesGroup(int sassLine) {
        CuptiActivitySourceLocator sourceLocator = this.getSourceLocator(sassLine);
        if (sourceLocator != null) {
            return this.sourceSassMap.get(sourceLocator.id);
        }
        return null;
    }

    public List<Integer> getSassLines(String cudaFileName, int cudaLine) {
        CuptiActivitySourceLocator sourceLocator = this.getSourceLocator(cudaFileName, cudaLine);
        if (sourceLocator != null) {
            if (this.sourceSassMap.get(sourceLocator.id) != null) {
                return this.sourceSassMap.get(sourceLocator.id);
            }
            ArrayList<Integer> sassLines = new ArrayList<Integer>();
            int i = 0;
            while (i < this.sassInstructions.size()) {
                if (this.sassInstructions.get(i).getSourcelocatorid() == sourceLocator.id) {
                    sassLines.add(i);
                }
                ++i;
            }
            if (sassLines.size() != 0) {
                this.sourceSassMap.put(sourceLocator.id, sassLines);
                return sassLines;
            }
        }
        return null;
    }

    private CuptiActivitySourceLocator getSourceLocator(String cudaFileName, int cudaLine) {
        URI uriCudaFile;
        if (cudaFileName == null) {
            return null;
        }
        try {
            uriCudaFile = new URI(cudaFileName);
        }
        catch (URISyntaxException uRISyntaxException) {
            uriCudaFile = new File(cudaFileName).toURI();
        }
        CuptiActivitySourceLocator sourceLocator = this.session.getSourceLocator().getLocation(uriCudaFile, cudaLine);
        return sourceLocator;
    }

    public Session getSession() {
        return this.session;
    }

    public AnalysisResultSourceLevel getAnalysisResultSourceLevel() {
        return this.sourceLevelResult;
    }

    public AnalysisResultSourceLevel getAnalysisResultSourceLevel(AnalysisResultSourceLevelKind resultKind) {
        for (AnalysisResultSourceLevel sourceLevelResult : this.sourceLevelResults) {
            if (resultKind.getSourceLevelResultClass() != sourceLevelResult.getClass()) continue;
            return sourceLevelResult;
        }
        return null;
    }

    public List<SassInstruction> getSassInstructions() {
        return this.sassInstructions;
    }

    public CuptiActivitySourceLocator getSourceLocator(int sassLine) {
        if (sassLine == -1 || sassLine >= this.sassInstructions.size()) {
            return null;
        }
        int sourcelocatorid = this.sassInstructions.get(sassLine).getSourcelocatorid();
        CuptiActivitySourceLocator locator = this.session.getSourceLocator().getLocation(sourcelocatorid);
        return locator;
    }

    public String getSassDocumentString() {
        StringBuilder stringBuilder = new StringBuilder();
        String tabs = "\t\t";
        for (SassInstruction inst : this.sassInstructions) {
            String current = inst.getSass();
            if (!current.endsWith(":")) {
                stringBuilder.append(tabs);
            }
            stringBuilder.append(String.valueOf(current) + "\n");
        }
        return stringBuilder.toString();
    }

    public CuptiActivitySourceLocator getLocatorToOpen() {
        CuptiActivitySourceLocator firstLocator = null;
        for (SassInstruction inst : this.sassInstructions) {
            int locatorId = inst.getSourcelocatorid();
            CuptiActivitySourceLocator locator = this.session.getSourceLocator().getLocation(locatorId);
            if (locator != null && firstLocator == null) {
                firstLocator = locator;
            }
            if (locator == null || !locator.fileName.equals(this.fileName)) continue;
            return locator;
        }
        return firstLocator;
    }

    public String getFilename() {
        return this.fileName;
    }

    public Set<String> getSourceFiles() {
        return this.sourceFiles;
    }

    public boolean existsSourceLevelResult(AnalysisResultSourceLevelKind sourceLevelResultKind) {
        for (AnalysisResultSourceLevel sourceLevelResult : this.sourceLevelResults) {
            if (sourceLevelResult.getClass() != sourceLevelResultKind.getSourceLevelResultClass()) continue;
            return true;
        }
        return false;
    }

    public void update(SourceSassModel refModel) {
        if (refModel != null) {
            if (this.fileName != null && !this.fileName.equals(refModel.getFilename())) {
                this.fileName = refModel.getFilename();
            }
            this.lineToSelect = refModel.getLineToSelect();
            this.sourceLevelResult = refModel.getAnalysisResultSourceLevel();
            if (!this.sourceLevelResults.contains(refModel.getAnalysisResultSourceLevel())) {
                this.sourceLevelResults.add(this.sourceLevelResult);
            }
            this.firePropertyChange(PROPERTY_FILE_CHANGED);
            this.firePropertyChange(PROPERTY_ANALYSIS_CHANGED);
        }
    }

    public void generateGPRInfo() {
        if (!this.gprInfo) {
            CudaFunctionManager cudaFunctionManager = this.session.getCudaFunctionManager();
            Collection<CuptiActivityFunction> cuptiActivityFunctions = cudaFunctionManager.getFunctions();
            this.sassInstructions.clear();
            for (CuptiActivityFunction function : cuptiActivityFunctions) {
                CudaFunction cudaFunction = cudaFunctionManager.getCudaFunction(function, false);
                if (cudaFunction == null || !cudaFunction.updateSourceLocator(this.sourceLevelResult, function.id)) continue;
                cudaFunctionManager.getCudaFunction(function, true);
                this.sassInstructions.addAll(cudaFunction.getSassInstructions());
            }
            this.gprInfo = true;
        }
    }
}

