/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.dom.parser.AbstractCLikeLanguage;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.EditorHighlightingSynchronizer;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactoringArgument;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactory;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameProcessor;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameRefactoringPreferences;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameInformationPopup;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameMessages;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameSupport;
import org.eclipse.cdt.internal.ui.search.LinkedNamesFinder;
import org.eclipse.cdt.internal.ui.text.correction.proposals.LinkedNamesAssistProposal;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class RenameLinkedMode {
    private static RenameLinkedMode fgActiveLinkedMode;
    private final CEditor fEditor;
    private RenameInformationPopup fInfoPopup;
    private Point fOriginalSelection;
    private String fOriginalName;
    private LinkedPosition fNamePosition;
    private LinkedModeModel fLinkedModeModel;
    private LinkedPositionGroup fLinkedPositionGroup;
    private final FocusEditingSupport fFocusEditingSupport;
    private boolean fShowPreview;
    private IUndoableOperation fStartingUndoOperation;
    private IRegion[] fLocations;

    public RenameLinkedMode(CEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fFocusEditingSupport = new FocusEditingSupport();
    }

    public static RenameLinkedMode getActiveLinkedMode() {
        if (fgActiveLinkedMode != null) {
            StyledText textWidget;
            ISourceViewer viewer = RenameLinkedMode.fgActiveLinkedMode.fEditor.getViewer();
            if (viewer != null && (textWidget = viewer.getTextWidget()) != null && !textWidget.isDisposed()) {
                return fgActiveLinkedMode;
            }
            fgActiveLinkedMode = null;
        }
        return null;
    }

    public void start() {
        if (RenameLinkedMode.getActiveLinkedMode() != null) {
            fgActiveLinkedMode.startFullDialog();
            return;
        }
        ISourceViewer viewer = this.fEditor.getViewer();
        this.fOriginalSelection = viewer.getSelectedRange();
        final int offset = this.fOriginalSelection.x;
        try {
            IUndoManager undoManager;
            this.fLocations = null;
            Point selection = viewer.getSelectedRange();
            final int secectionOffset = selection.x;
            final int selectionLength = selection.y;
            IDocument document = viewer.getDocument();
            ASTProvider.getASTProvider().runOnAST((ICElement)this.fEditor.getInputCElement(), ASTProvider.WAIT_ACTIVE_ONLY, (IProgressMonitor)new NullProgressMonitor(), new ASTCache.ASTRunnable(){

                public IStatus runOnAST(ILanguage lang, IASTTranslationUnit astRoot) throws CoreException {
                    if (astRoot == null) {
                        return Status.CANCEL_STATUS;
                    }
                    IASTNodeSelector selector = astRoot.getNodeSelector(null);
                    IASTName name = selector.findEnclosingName(secectionOffset, selectionLength);
                    if (name != null) {
                        RenameLinkedMode.this.fOriginalName = name.toString();
                        RenameLinkedMode.this.fLocations = LinkedNamesFinder.findByName(astRoot, name);
                    }
                    return Status.OK_STATUS;
                }
            });
            if (this.fLocations == null || this.fLocations.length == 0) {
                return;
            }
            if (viewer instanceof ITextViewerExtension6 && (undoManager = ((ITextViewerExtension6)viewer).getUndoManager()) instanceof IUndoManagerExtension) {
                IUndoManagerExtension undoManagerExtension = (IUndoManagerExtension)undoManager;
                IUndoContext undoContext = undoManagerExtension.getUndoContext();
                IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
                this.fStartingUndoOperation = operationHistory.getUndoOperation(undoContext);
            }
            Arrays.sort(this.fLocations, new Comparator<IRegion>(){

                @Override
                public int compare(IRegion n1, IRegion n2) {
                    return this.rank(n1) - this.rank(n2);
                }

                private int rank(IRegion location) {
                    int relativeRank = location.getOffset() + location.getLength() - offset;
                    if (relativeRank < 0) {
                        return Integer.MAX_VALUE + relativeRank;
                    }
                    return relativeRank;
                }
            });
            this.fLinkedPositionGroup = new LinkedPositionGroup();
            int i = 0;
            while (i < this.fLocations.length) {
                IRegion item = this.fLocations[i];
                LinkedPosition linkedPosition = new LinkedPosition(document, item.getOffset(), item.getLength(), i);
                if (i == 0) {
                    this.fNamePosition = linkedPosition;
                }
                this.fLinkedPositionGroup.addPosition(linkedPosition);
                ++i;
            }
            this.fLinkedModeModel = new LinkedModeModel();
            this.fLinkedModeModel.addGroup(this.fLinkedPositionGroup);
            this.fLinkedModeModel.forceInstall();
            this.fLinkedModeModel.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(this.fEditor));
            this.fLinkedModeModel.addLinkingListener((ILinkedModeListener)new EditorSynchronizer());
            EditorLinkedModeUI ui = new EditorLinkedModeUI(this.fLinkedModeModel, (ITextViewer)viewer);
            ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(document));
            ui.setExitPosition((ITextViewer)viewer, offset, 0, -1);
            ui.enter();
            viewer.setSelectedRange(selection.x, selection.y);
            if (viewer instanceof IEditingSupportRegistry) {
                IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
                registry.register((IEditingSupport)this.fFocusEditingSupport);
            }
            this.openSecondaryPopup();
            fgActiveLinkedMode = this;
        }
        catch (BadLocationException e) {
            CUIPlugin.log(e);
        }
    }

    void doRename(boolean showPreview) {
        this.cancel();
        Image image = null;
        Label label = null;
        this.fShowPreview |= showPreview;
        try {
            String newName;
            SourceViewer sourceViewer;
            Control viewerControl;
            ISourceViewer viewer = this.fEditor.getViewer();
            if (viewer instanceof SourceViewer && (viewerControl = (sourceViewer = (SourceViewer)viewer).getControl()) instanceof Composite) {
                Point size;
                Composite composite = (Composite)viewerControl;
                Display display = composite.getDisplay();
                while (!display.isDisposed() && display.readAndDispatch()) {
                }
                GC gc = new GC((Drawable)composite);
                try {
                    size = composite.getSize();
                    image = new Image(gc.getDevice(), size.x, size.y);
                    gc.copyArea(image, 0, 0);
                }
                finally {
                    gc.dispose();
                    gc = null;
                }
                label = new Label(composite, 0);
                label.setImage(image);
                label.setBounds(0, 0, size.x, size.y);
                label.moveAbove(null);
            }
            if (this.fOriginalName.equals(newName = this.fNamePosition.getContent())) {
                return;
            }
            RenameSupport renameSupport = this.undoAndCreateRenameSupport(newName);
            if (renameSupport == null) {
                return;
            }
            try {
                Shell shell = this.fEditor.getSite().getShell();
                boolean executed = this.fShowPreview ? renameSupport.openDialog(shell, true) : renameSupport.perform(shell, this.fEditor.getSite().getWorkbenchWindow());
                if (executed) {
                    this.restoreFullSelection();
                }
                this.reconcile();
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                CUIPlugin.log(e);
            }
            catch (BadLocationException e) {
                CUIPlugin.log(e);
            }
        }
        finally {
            if (label != null) {
                label.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }

    public void cancel() {
        if (this.fLinkedModeModel != null) {
            this.fLinkedModeModel.exit(0);
        }
        this.linkedModeLeft();
    }

    private void restoreFullSelection() {
        if (this.fOriginalSelection.y != 0) {
            int originalOffset = this.fOriginalSelection.x;
            LinkedPosition[] positions = this.fLinkedPositionGroup.getPositions();
            int i = 0;
            while (i < positions.length) {
                LinkedPosition position = positions[i];
                if (!position.isDeleted() && position.includes(originalOffset)) {
                    this.fEditor.getViewer().setSelectedRange(position.offset, position.length);
                    return;
                }
                ++i;
            }
        }
    }

    private RenameSupport undoAndCreateRenameSupport(String newName) throws CoreException {
        final ISourceViewer viewer = this.fEditor.getViewer();
        try {
            try {
                if (!this.fOriginalName.equals(newName)) {
                    this.fEditor.getSite().getWorkbenchWindow().run(false, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            IUndoManager undoManager;
                            if (viewer instanceof ITextViewerExtension6 && (undoManager = ((ITextViewerExtension6)viewer).getUndoManager()) instanceof IUndoManagerExtension) {
                                IUndoManagerExtension undoManagerExtension = (IUndoManagerExtension)undoManager;
                                IUndoContext undoContext = undoManagerExtension.getUndoContext();
                                IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
                                while (undoManager.undoable()) {
                                    if (RenameLinkedMode.this.fStartingUndoOperation != null && RenameLinkedMode.this.fStartingUndoOperation.equals(operationHistory.getUndoOperation(undoContext))) {
                                        return;
                                    }
                                    undoManager.undo();
                                }
                            }
                        }
                    });
                }
            }
            catch (InvocationTargetException e) {
                throw new CoreException((IStatus)new Status(4, CUIPlugin.getPluginId(), RenameMessages.RenameLinkedMode_error_saving_editor, (Throwable)e));
            }
            catch (InterruptedException interruptedException) {
                this.reconcile();
                return null;
            }
        }
        finally {
            this.reconcile();
        }
        viewer.setSelectedRange(this.fOriginalSelection.x, this.fOriginalSelection.y);
        if (newName.length() == 0) {
            return null;
        }
        IWorkingCopy workingCopy = this.getWorkingCopy();
        IResource resource = workingCopy.getResource();
        if (!(resource instanceof IFile)) {
            return null;
        }
        CRefactoringArgument arg = new CRefactoringArgument((IFile)resource, this.fOriginalSelection.x, this.fOriginalSelection.y);
        CRenameProcessor processor = new CRenameProcessor(CRefactory.getInstance(), arg);
        processor.setReplacementText(newName);
        CRenameRefactoringPreferences preferences = new CRenameRefactoringPreferences();
        processor.setSelectedOptions(preferences.getOptions());
        processor.setExhaustiveSearchScope(preferences.getScope());
        processor.setWorkingSetName(preferences.getWorkingSet());
        return RenameSupport.create(processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconcile() throws CModelException {
        IWorkingCopy workingCopy;
        IWorkingCopy iWorkingCopy = workingCopy = this.getWorkingCopy();
        synchronized (iWorkingCopy) {
            workingCopy.reconcile();
        }
    }

    private IWorkingCopy getWorkingCopy() {
        IEditorInput input = this.fEditor.getEditorInput();
        IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
        return manager.getWorkingCopy(input);
    }

    public void startFullDialog() {
        this.cancel();
        try {
            String newName = this.fNamePosition.getContent();
            RenameSupport renameSupport = this.undoAndCreateRenameSupport(newName);
            if (renameSupport != null) {
                renameSupport.openDialog(this.fEditor.getSite().getShell());
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        catch (BadLocationException e) {
            CUIPlugin.log(e);
        }
    }

    private void linkedModeLeft() {
        ISourceViewer viewer;
        fgActiveLinkedMode = null;
        if (this.fInfoPopup != null) {
            this.fInfoPopup.close();
        }
        if ((viewer = this.fEditor.getViewer()) instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
            registry.unregister((IEditingSupport)this.fFocusEditingSupport);
        }
    }

    private void openSecondaryPopup() {
        this.fInfoPopup = new RenameInformationPopup(this.fEditor, this);
        this.fInfoPopup.open();
    }

    public boolean isCaretInLinkedPosition() {
        return this.getCurrentLinkedPosition() != null;
    }

    public LinkedPosition getCurrentLinkedPosition() {
        Point selection = this.fEditor.getViewer().getSelectedRange();
        int start = selection.x;
        int end = start + selection.y;
        LinkedPosition[] positions = this.fLinkedPositionGroup.getPositions();
        int i = 0;
        while (i < positions.length) {
            LinkedPosition position = positions[i];
            if (position.includes(start) && position.includes(end)) {
                return position;
            }
            ++i;
        }
        return null;
    }

    public boolean isEnabled() {
        String newName;
        block3: {
            try {
                newName = this.fNamePosition.getContent();
                if (!this.fOriginalName.equals(newName)) break block3;
                return false;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        return CConventions.validateIdentifier((String)newName, (AbstractCLikeLanguage)this.getLanguage()).isOK();
    }

    private AbstractCLikeLanguage getLanguage() {
        IWorkingCopy tu = this.fEditor.getInputCElement();
        ILanguage language = null;
        try {
            language = tu.getLanguage();
        }
        catch (CoreException coreException) {}
        if (language instanceof AbstractCLikeLanguage) {
            return (AbstractCLikeLanguage)language;
        }
        return GPPLanguage.getDefault();
    }

    public boolean isOriginalName() {
        try {
            String newName = this.fNamePosition.getContent();
            return this.fOriginalName.equals(newName);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private class EditorSynchronizer
    implements ILinkedModeListener {
        private EditorSynchronizer() {
        }

        public void left(LinkedModeModel model, int flags) {
            RenameLinkedMode.this.linkedModeLeft();
            if ((flags & 2) != 0) {
                RenameLinkedMode.this.doRename(RenameLinkedMode.this.fShowPreview);
            }
        }

        public void resume(LinkedModeModel model, int flags) {
        }

        public void suspend(LinkedModeModel model) {
        }
    }

    private class ExitPolicy
    extends LinkedNamesAssistProposal.DeleteBlockingExitPolicy {
        public ExitPolicy(IDocument document) {
            super(document);
        }

        @Override
        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            RenameLinkedMode.this.fShowPreview = (event.stateMask & 0x40000) != 0 && (event.character == '\r' || event.character == '\n');
            return super.doExit(model, event, offset, length);
        }
    }

    private class FocusEditingSupport
    implements IEditingSupport {
        private FocusEditingSupport() {
        }

        public boolean ownsFocusShell() {
            Shell activeShell;
            if (RenameLinkedMode.this.fInfoPopup == null) {
                return false;
            }
            if (RenameLinkedMode.this.fInfoPopup.ownsFocusShell()) {
                return true;
            }
            Shell editorShell = RenameLinkedMode.this.fEditor.getSite().getShell();
            return editorShell == (activeShell = editorShell.getDisplay().getActiveShell());
        }

        public boolean isOriginator(DocumentEvent event, IRegion subjectRegion) {
            return false;
        }
    }
}

