/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.config.importer;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.ColumnConfig;
import amazon.fws.clicommando.config.CommandConfig;
import amazon.fws.clicommando.config.ConfirmConfig;
import amazon.fws.clicommando.config.DefaultConfig;
import amazon.fws.clicommando.config.EnvironmentVariableConfig;
import amazon.fws.clicommando.config.LoadedClassConfig;
import amazon.fws.clicommando.config.MapConfig;
import amazon.fws.clicommando.config.MapKeyConfig;
import amazon.fws.clicommando.config.MapTransConfig;
import amazon.fws.clicommando.config.OptionConfig;
import amazon.fws.clicommando.config.OutputDescriptionConfig;
import amazon.fws.clicommando.config.OutputFormatConfig;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.config.ProcessorConfig;
import amazon.fws.clicommando.config.ValueReferenceConfig;
import amazon.fws.clicommando.config.VersionInfoConfig;
import amazon.fws.clicommando.config.XsltColumnHandlerConfig;
import amazon.fws.clicommando.util.StringUtils;
import amazon.fws.clicommando.util.XmlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomImportHelper {
    private static final String MINSIZE = "minsize";
    private static final String APIVERSION = "apiversion";
    private static final String VERSION = "build";
    private static final String SERVICE = "service";
    private static final String VERSIONINFO = "versioninfo";
    private static final String EMPTY_RESPONSE = "empty-response";
    private static final String TITLE = "title";
    private static final String HELPREF = "helpref";
    private static final String ORDINAL_START = "ordinal-start";
    private static final String TRANSLATION = "translation";
    private static final String MAP_TRANSLATION = "map-translation";
    private static final String MAP = "map";
    private static final String MAP_KEYS = "keys";
    private static final String MAP_ORDINAL_START = "map-ordinal-start";
    private static final String IGNORE_IN_SYNOPSIS = "ignore-in-synopsis";
    private static final String TRUE = "true";
    private static final String COLUMNHANDLER = "columnhandler";
    private static final String TABLENAME = "tablename";
    private static final String TARGET = "target";
    private static final String LIST = "list";
    private static final String COLSIZE = "colsize";
    private static final String SOURCE = "source";
    private static final String HEADER = "header";
    private static final String COLUMN = "column";
    private static final String OUTPUTDESCRIPTION = "outputdescription";
    private static final String SHORT_OPT = "short.opt";
    private static final String LONG_OPT = "long.opt";
    private static final String INDEX = "index";
    private static final String OPTION = "option";
    private static final String OPTIONAL_VALUE = "optional-value";
    private static final String ENTRY_SEPARATOR = "entry-separator";
    private static final String KEY_VALUE_SEPARATOR = "key-value-separator";
    private static final String MAP_ENTRY_SEPARATOR = "map-entry-separator";
    private static final String ENVVAR = "envvar";
    private static final String VARNAME = "varname";
    private static final String VALUE = "value";
    private static final String DEFAULT = "default";
    private static final String REQUIRED = "required";
    private static final String TYPE = "type";
    private static final String DIRECTIVE = "directive";
    private static final String SECURE_INPUT = "secure-input";
    private static final String MAX_VALUE_SIZE = "max-value-size";
    private static final String PROMPT = "prompt";
    private static final String PARAM = "param";
    private static final String REF = "ref";
    private static final String PARAMINCLUDE = "paraminclude";
    private static final String PROCESSOR = "processor";
    private static final String CLASS = "class";
    private static final String PROCESSOR_CONFIG = "processor.config";
    private static final String EXECUTIONCONTROLLER = "execution-controller";
    private static final String CUSTOM_PARAM = "param-custom-processor";
    private static final String DESCRIPTOR = "descriptor";
    private static final String FORMATTER = "formatter";
    private static final String ALIAS = "alias";
    private static final String COMMAND = "command";
    private static final String NAME = "name";
    private static final String SAME_AS = "same-as";
    private static final String COMMONPARAMETERS = "commonparameters";
    private static final String REFERENCE = "reference";
    private static final String NONEMPTY = "nonEmpty";
    private static final String ENCODE = "encode";
    private HashMap<String, List<Element>> commonParamMap = new HashMap();
    private HashMap<String, String> contextMap = new HashMap();

    public Command createCommandFromElements(List<Element> commands) {
        Command cmd = new Command();
        for (Element doc : commands) {
            this.readCommonParams(doc);
        }
        for (Element doc : commands) {
            this.addCommandCfgsTo(cmd, doc);
            this.addOutputDescTo(cmd, doc);
            this.addColumnHandlersTo(cmd, doc);
            this.addVersionInfoTo(cmd, doc);
        }
        return cmd;
    }

    private void addVersionInfoTo(Command command, Element doc) {
        NodeList versionInfos = doc.getElementsByTagName(VERSIONINFO);
        for (int i = 0; i < versionInfos.getLength(); ++i) {
            if (!(versionInfos.item(i) instanceof Element)) continue;
            Element verInfo = (Element)versionInfos.item(i);
            VersionInfoConfig ver = new VersionInfoConfig(verInfo.getAttribute(SERVICE), verInfo.getAttribute(VERSION), verInfo.getAttribute(APIVERSION));
            command.setVersion(ver);
        }
    }

    private void addColumnHandlersTo(Command command, Element doc) {
        NodeList colHandlers = doc.getElementsByTagName(COLUMNHANDLER);
        for (int i = 0; i < colHandlers.getLength(); ++i) {
            if (!(colHandlers.item(i) instanceof Element)) continue;
            Element hand = (Element)colHandlers.item(i);
            XsltColumnHandlerConfig xHandler = new XsltColumnHandlerConfig(hand.getAttribute(NAME), hand.getChildNodes().item(1).getNodeValue());
            command.addColumnHandler(xHandler);
        }
    }

    private void addOutputDescTo(Command command, Element doc) {
        NodeList outDescs = doc.getElementsByTagName(OUTPUTDESCRIPTION);
        for (int i = 0; i < outDescs.getLength(); ++i) {
            if (!(outDescs.item(i) instanceof Element)) continue;
            Element out = (Element)outDescs.item(i);
            OutputDescriptionConfig outDesc = new OutputDescriptionConfig(out.getAttribute(NAME), out.getAttribute(TABLENAME), out.getAttribute(HELPREF), out.getAttribute(EMPTY_RESPONSE));
            this.addColumnsToDescription(out, outDesc);
            this.addOutput(outDesc, out);
            command.addOutputDescription(outDesc);
        }
    }

    private void addColumnsToDescription(Element out, OutputDescriptionConfig outDesc) {
        NodeList columns = out.getElementsByTagName(COLUMN);
        for (int i = 0; i < columns.getLength(); ++i) {
            if (!(columns.item(i) instanceof Element)) continue;
            Element col = (Element)columns.item(i);
            Integer maxSize = StringUtils.isEmpty(col.getAttribute(COLSIZE)) ? -1 : Integer.parseInt(col.getAttribute(COLSIZE));
            Integer minSize = StringUtils.isEmpty(col.getAttribute(MINSIZE)) ? -1 : Integer.parseInt(col.getAttribute(MINSIZE));
            ColumnConfig column = new ColumnConfig(col.getAttribute(HEADER), col.getAttribute(SOURCE), col.getAttribute(TYPE), maxSize, minSize, ColumnConfig.ColumnListType.parse(col.getAttribute(LIST)), this.getTagValue(col, "sort"), this.getTagBoolean(col, NONEMPTY));
            outDesc.addColumn(column);
        }
    }

    private boolean getTagBoolean(Element opt, String tagName) {
        return Boolean.parseBoolean(this.getTagValue(opt, tagName));
    }

    private void readCommonParams(Element doc) {
        NodeList commons = doc.getElementsByTagName(COMMONPARAMETERS);
        for (int i = 0; i < commons.getLength(); ++i) {
            if (!(commons.item(i) instanceof Element)) continue;
            Element common = (Element)commons.item(i);
            String name = common.getAttribute(NAME);
            List<Element> elements = this.commonParamMap.get(name);
            if (elements != null) {
                elements.add(common);
            } else {
                ArrayList<Element> elems = new ArrayList<Element>();
                elems.add(common);
                this.commonParamMap.put(name, elems);
            }
            this.contextMap.put(common.getAttribute(NAME), common.getAttribute(TITLE));
        }
    }

    private void addCommandCfgsTo(Command command, Element doc) {
        NodeList cmds = doc.getElementsByTagName(COMMAND);
        for (int i = 0; i < cmds.getLength(); ++i) {
            if (!(cmds.item(i) instanceof Element)) continue;
            Element cmd = (Element)cmds.item(i);
            CommandConfig cc = new CommandConfig(cmd.getAttribute(NAME), cmd.getAttribute(ALIAS), cmd.getAttribute(HELPREF));
            this.addIncludedParamsTo(cc, cmd);
            this.addParametersTo(cc, cmd, "");
            this.addProcessorDir(cc, cmd);
            this.addController(cc, cmd);
            this.addParamCustomProcessor(cc, cmd);
            this.addOutput(cc, cmd);
            this.addConfirms(cc, cmd);
            command.addCommandConfig(cc);
        }
    }

    private void addConfirms(CommandConfig cc, Element cmd) {
        NodeList confirms = cmd.getElementsByTagName("confirm");
        for (int i = 0; i < confirms.getLength(); ++i) {
            if (!(confirms.item(i) instanceof Element)) continue;
            Element confirm = (Element)confirms.item(i);
            ConfirmConfig confirmation = new ConfirmConfig(confirm.getAttribute("challenge"), XmlUtils.getTextFromNode(confirm));
            cc.setConfirmation(confirmation);
        }
    }

    private void addOutput(CommandConfig cc, Element cmd) {
        NodeList formatters = cmd.getElementsByTagName(FORMATTER);
        for (int i = 0; i < formatters.getLength(); ++i) {
            if (!(formatters.item(i) instanceof Element)) continue;
            Element formatter = (Element)formatters.item(i);
            OutputFormatConfig form = new OutputFormatConfig(formatter.getAttribute(TARGET), formatter.getAttribute(DESCRIPTOR), Boolean.parseBoolean(formatter.getAttribute(NONEMPTY)));
            cc.setOutputConfig(form);
        }
    }

    private void addOutput(OutputDescriptionConfig outDesc, Element cmd) {
        NodeList formatters = cmd.getElementsByTagName(FORMATTER);
        for (int i = 0; i < formatters.getLength(); ++i) {
            if (!(formatters.item(i) instanceof Element)) continue;
            Element formatter = (Element)formatters.item(i);
            OutputFormatConfig form = new OutputFormatConfig(formatter.getAttribute(TARGET), formatter.getAttribute(DESCRIPTOR), Boolean.parseBoolean(formatter.getAttribute(NONEMPTY)));
            outDesc.addTable(form);
        }
    }

    private void addProcessorDir(CommandConfig cc, Element cmd) {
        NodeList processes = cmd.getChildNodes();
        for (int i = 0; i < processes.getLength(); ++i) {
            Element processor;
            if (!(processes.item(i) instanceof Element) || !(processor = (Element)processes.item(i)).getNodeName().equals(PROCESSOR)) continue;
            Element configElem = (Element)processor.getElementsByTagName(PROCESSOR_CONFIG).item(0);
            Map<String, String> configMap = null;
            if (configElem != null) {
                configMap = this.makeMap(configElem);
            }
            ProcessorConfig proc = new ProcessorConfig(processor.getAttribute(CLASS), configMap);
            cc.setProcessor(proc);
        }
    }

    private void addController(CommandConfig cc, Element cmd) {
        LoadedClassConfig executionController = this.addLoadedClassConfig(cc, cmd, EXECUTIONCONTROLLER);
        cc.setExecutionControlConfig(executionController);
    }

    private void addParamCustomProcessor(CommandConfig cc, Element cmd) {
        LoadedClassConfig paramProcessor = this.addLoadedClassConfig(cc, cmd, CUSTOM_PARAM);
        cc.setCustomParamProcessingConfig(paramProcessor);
    }

    private LoadedClassConfig addLoadedClassConfig(CommandConfig cc, Element cmd, String elementName) {
        NodeList processes = cmd.getChildNodes();
        for (int i = 0; i < processes.getLength(); ++i) {
            Element processor;
            if (!(processes.item(i) instanceof Element) || !(processor = (Element)processes.item(i)).getNodeName().equals(elementName)) continue;
            Element configElem = (Element)processor.getElementsByTagName(elementName + ".config").item(0);
            Map<String, String> configMap = null;
            if (configElem != null) {
                configMap = this.makeMap(configElem);
            }
            return new LoadedClassConfig(processor.getAttribute(CLASS), configMap);
        }
        return null;
    }

    private Map<String, String> makeMap(Element configElem) {
        HashMap<String, String> map = new HashMap<String, String>();
        NamedNodeMap nodes = configElem.getAttributes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (!(nodes.item(i) instanceof Attr)) continue;
            Attr attr = (Attr)nodes.item(i);
            map.put(attr.getName(), attr.getValue());
        }
        return map;
    }

    private void addIncludedParamsTo(CommandConfig cc, Element cmd) {
        NodeList includes = cmd.getElementsByTagName(PARAMINCLUDE);
        for (int i = 0; i < includes.getLength(); ++i) {
            if (!(includes.item(i) instanceof Element)) continue;
            Element includeRef = (Element)includes.item(i);
            String incName = includeRef.getAttribute(REF);
            if (this.commonParamMap.containsKey(incName)) {
                List<Element> elements = this.commonParamMap.get(incName);
                if (elements == null) continue;
                for (Element include : elements) {
                    String title = this.contextMap.get(incName);
                    this.addParametersTo(cc, include, title);
                }
                continue;
            }
            throw new IllegalArgumentException("This file tried to reference common param group '" + incName + "' which doesn't exist");
        }
    }

    private void addParametersTo(CommandConfig cc, Element cmd, String context) {
        NodeList params = cmd.getElementsByTagName(PARAM);
        for (int i = 0; i < params.getLength(); ++i) {
            if (!(params.item(i) instanceof Element)) continue;
            Element param = (Element)params.item(i);
            Boolean directive = StringUtils.isEmpty(param.getAttribute(DIRECTIVE)) ? false : Boolean.parseBoolean(param.getAttribute(DIRECTIVE));
            Boolean secureInput = StringUtils.isEmpty(param.getAttribute(SECURE_INPUT)) ? false : Boolean.parseBoolean(param.getAttribute(SECURE_INPUT));
            Boolean undoc = StringUtils.isEmpty(param.getAttribute("undocumented")) ? false : Boolean.parseBoolean(param.getAttribute("undocumented"));
            String sameAs = param.getAttribute(SAME_AS);
            sameAs = StringUtils.isEmpty(sameAs) ? null : sameAs;
            int maxValueSize = StringUtils.isEmpty(param.getAttribute(MAX_VALUE_SIZE)) ? 2048000 : Integer.parseInt(param.getAttribute(MAX_VALUE_SIZE));
            ParamConfig pc = new ParamConfig(param.getAttribute(NAME), sameAs, param.getAttribute(TYPE), Boolean.parseBoolean(param.getAttribute(REQUIRED)), directive, context, secureInput, maxValueSize, StringUtils.isEmpty(param.getAttribute(PROMPT)) ? "" : param.getAttribute(PROMPT), undoc, param.getAttribute(ENCODE));
            this.addOptionsTo(pc, param);
            this.addEnvironTo(pc, param);
            this.addDefaultTo(pc, param);
            this.addReferenceTo(pc, param);
            this.addMapConfigTo(pc, param);
            cc.addParameter(pc);
        }
    }

    private void addReferenceTo(ParamConfig pc, Element param) {
        NodeList references = param.getElementsByTagName(REFERENCE);
        ValueReferenceConfig valueReferenceConfig = pc.getValueReferenceConfig();
        for (int i = 0; i < references.getLength(); ++i) {
            if (!(references.item(i) instanceof Element)) continue;
            Element ref = (Element)references.item(i);
            NamedNodeMap attributes = ref.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node attributeNode = attributes.item(j);
                String name = attributeNode.getNodeName();
                String value = attributeNode.getNodeValue();
                if (TYPE.equalsIgnoreCase(name)) {
                    valueReferenceConfig.setType(value);
                    continue;
                }
                valueReferenceConfig.setArgument(name, value);
            }
        }
    }

    private void addMapConfigTo(ParamConfig pc, Element param) {
        NodeList maps = param.getElementsByTagName(MAP);
        MapConfig mapConfig = pc.getMapConfig();
        for (int i = 0; i < maps.getLength(); ++i) {
            if (!(maps.item(i) instanceof Element)) continue;
            Element map = (Element)maps.item(i);
            String mapOrdinalStart = map.getAttribute(MAP_ORDINAL_START);
            String string = mapOrdinalStart = StringUtils.isEmpty(mapOrdinalStart) ? "1" : mapOrdinalStart;
            if (mapOrdinalStart != null) {
                mapConfig.setOrdinalStart(mapOrdinalStart);
            }
            this.addMapTranslationTo(mapConfig, map);
            this.addKeysTo(mapConfig, map);
        }
    }

    private void addMapTranslationTo(MapConfig mc, Element param) {
        NodeList mapTs = param.getElementsByTagName(MAP_TRANSLATION);
        for (int i = 0; i < mapTs.getLength(); ++i) {
            if (!(mapTs.item(i) instanceof Element)) continue;
            Element mapT = (Element)mapTs.item(i);
            NodeList trans = mapT.getChildNodes();
            for (int j = 0; j < trans.getLength(); ++j) {
                if (!(trans.item(j) instanceof Element)) continue;
                Element tran = (Element)trans.item(j);
                String ordinalStart = tran.getAttribute(ORDINAL_START);
                ordinalStart = StringUtils.isEmpty(ordinalStart) ? "1" : ordinalStart;
                MapTransConfig mtc = new MapTransConfig(tran.getAttribute(TRANSLATION), StringUtils.toInteger(ordinalStart));
                MapTransConfig.MapType type = MapTransConfig.MapType.parse(tran.getNodeName());
                mc.setMapTrans(type, mtc);
            }
        }
    }

    private void addKeysTo(MapConfig mc, Element param) {
        NodeList keysNodes = param.getElementsByTagName(MAP_KEYS);
        for (int i = 0; i < keysNodes.getLength(); ++i) {
            if (!(keysNodes.item(i) instanceof Element)) continue;
            Element keysNode = (Element)keysNodes.item(i);
            if (TRUE.equals(keysNode.getAttribute(IGNORE_IN_SYNOPSIS))) {
                mc.setIgnoreKeysInSynopsis(Boolean.TRUE);
            }
            NodeList keys = keysNode.getChildNodes();
            for (int j = 0; j < keys.getLength(); ++j) {
                if (!(keys.item(j) instanceof Element)) continue;
                Element key = (Element)keys.item(j);
                String name = key.getAttribute(NAME);
                String translation = key.getAttribute(TRANSLATION);
                String required = key.getAttribute(REQUIRED);
                if ("*".equals(name)) {
                    required = "false";
                    translation = "";
                }
                MapKeyConfig mkc = new MapKeyConfig(name, translation, required);
                mc.setKey(mkc);
            }
        }
    }

    private void addDefaultTo(ParamConfig pc, Element param) {
        NodeList defaults = param.getElementsByTagName(DEFAULT);
        for (int i = 0; i < defaults.getLength(); ++i) {
            if (!(defaults.item(i) instanceof Element)) continue;
            Element def = (Element)defaults.item(i);
            DefaultConfig defl = new DefaultConfig(def.getAttribute(VALUE));
            pc.setDefaultValue(defl);
        }
    }

    private void addEnvironTo(ParamConfig pc, Element param) {
        NodeList envvars = param.getElementsByTagName(ENVVAR);
        for (int i = 0; i < envvars.getLength(); ++i) {
            if (!(envvars.item(i) instanceof Element)) continue;
            Element envV = (Element)envvars.item(i);
            EnvironmentVariableConfig eVar = new EnvironmentVariableConfig(envV.getAttribute(VARNAME));
            pc.setEnvVarValue(eVar);
        }
    }

    private void addOptionsTo(ParamConfig pc, Element param) {
        NodeList options = param.getElementsByTagName(OPTION);
        for (int i = 0; i < options.getLength(); ++i) {
            String mapEntrySeparator;
            String keyValueSeparator;
            if (!(options.item(i) instanceof Element)) continue;
            Element opt = (Element)options.item(i);
            Integer idx = StringUtils.isEmpty(this.getTagValue(opt, INDEX)) ? null : Integer.valueOf(Integer.parseInt(opt.getAttribute(INDEX)));
            String longOpt = this.getTagValue(opt, LONG_OPT);
            String shortOpt = this.getTagValue(opt, SHORT_OPT);
            String val = this.getTagValue(opt, VALUE);
            String valueSeparator = opt.getAttribute(ENTRY_SEPARATOR);
            if (valueSeparator.equals("")) {
                valueSeparator = null;
            }
            if ((keyValueSeparator = opt.getAttribute(KEY_VALUE_SEPARATOR)).equals("")) {
                keyValueSeparator = null;
            }
            if ((mapEntrySeparator = opt.getAttribute(MAP_ENTRY_SEPARATOR)).equals("")) {
                mapEntrySeparator = null;
            }
            String optionalValue = this.getTagValue(opt, OPTIONAL_VALUE);
            OptionConfig opcfg = new OptionConfig(longOpt, shortOpt, val, idx, valueSeparator, keyValueSeparator, mapEntrySeparator, optionalValue);
            pc.getOptions().add(opcfg);
        }
    }

    private String getTagValue(Element opt, String tagName) {
        return StringUtils.isEmpty(opt.getAttribute(tagName)) ? null : opt.getAttribute(tagName);
    }
}

