/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.keystroke;

import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;

class KeyStrokeMapCollection {
    private final Map<Character, KeyStroke> charToKeyStroke = new HashMap<Character, KeyStroke>();
    private final Map<KeyStroke, Character> keyStrokeToChar = new HashMap<KeyStroke, Character>();

    KeyStrokeMapCollection() {
    }

    void add(Character character, KeyStroke keyStroke) {
        this.charToKeyStroke.put(character, keyStroke);
        this.keyStrokeToChar.put(keyStroke, character);
    }

    void clear() {
        this.charToKeyStroke.clear();
        this.keyStrokeToChar.clear();
    }

    boolean isEmpty() {
        return this.charToKeyStroke.isEmpty() && this.keyStrokeToChar.isEmpty();
    }

    KeyStroke keyStrokeFor(char character) {
        return this.charToKeyStroke.get(Character.valueOf(character));
    }

    Character charFor(KeyStroke keyStroke) {
        return this.keyStrokeToChar.get(keyStroke);
    }
}

