/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "fil" locale.
 */
public class LocalizedNamesImpl_fil extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "PH",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "AX",
        "AL",
        "DE",
        "DZ",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BL",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "KY",
        "CF",
        "EA",
        "TD",
        "CL",
        "CX",
        "CP",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "CK",
        "CR",
        "CI",
        "HR",
        "CU",
        "CY",
        "CZ",
        "DK",
        "DG",
        "DJ",
        "DM",
        "DO",
        "EC",
        "EG",
        "SV",
        "GQ",
        "ER",
        "ES",
        "US",
        "EE",
        "ET",
        "EU",
        "FK",
        "FO",
        "FJ",
        "FI",
        "GF",
        "PF",
        "TF",
        "GA",
        "GM",
        "GD",
        "GE",
        "GH",
        "GI",
        "GP",
        "GL",
        "GR",
        "GT",
        "GU",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "HN",
        "HK",
        "HU",
        "IS",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IM",
        "IL",
        "IT",
        "JP",
        "JE",
        "JM",
        "JO",
        "KZ",
        "KE",
        "KI",
        "KW",
        "KG",
        "LA",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MK",
        "MG",
        "MW",
        "QO",
        "MY",
        "ML",
        "MH",
        "MR",
        "MC",
        "MX",
        "MF",
        "UM",
        "FM",
        "MD",
        "MN",
        "ME",
        "MA",
        "MZ",
        "MQ",
        "MS",
        "MT",
        "MU",
        "MV",
        "MM",
        "NA",
        "NP",
        "NL",
        "AN",
        "NC",
        "NZ",
        "NI",
        "NE",
        "NG",
        "NF",
        "MP",
        "KP",
        "NO",
        "NR",
        "NU",
        "OM",
        "PA",
        "PK",
        "PS",
        "PG",
        "PY",
        "PE",
        "PH",
        "PN",
        "PL",
        "PT",
        "PR",
        "FR",
        "PW",
        "QA",
        "RE",
        "RO",
        "RU",
        "RW",
        "KN",
        "LC",
        "PM",
        "VC",
        "WS",
        "SM",
        "ST",
        "SA",
        "SN",
        "RS",
        "CS",
        "SC",
        "SG",
        "SL",
        "SK",
        "SI",
        "SB",
        "SO",
        "ZA",
        "GS",
        "LK",
        "SH",
        "SD",
        "SR",
        "SJ",
        "SZ",
        "SE",
        "CH",
        "SY",
        "TW",
        "TJ",
        "TZ",
        "TH",
        "KR",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "CN",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "VI",
        "UG",
        "UA",
        "AE",
        "GB",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "EH",
        "YE",
        "YT",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Mundo");
    namesMap.put("011", "Kanlurang Africa");
    namesMap.put("013", "Gitnang Amerika");
    namesMap.put("014", "Silangang Africa");
    namesMap.put("015", "Hilagang Africa");
    namesMap.put("017", "Gitnang Africa");
    namesMap.put("018", "Katimugang Africa");
    namesMap.put("021", "Hilagang Amerika");
    namesMap.put("029", "Carribbean");
    namesMap.put("030", "Silangang Asya");
    namesMap.put("034", "Katimugang Asya");
    namesMap.put("035", "Timog-Silangang Asya");
    namesMap.put("039", "Katimugang Europa");
    namesMap.put("053", "Australia at New Zealand");
    namesMap.put("057", "Rehiyong Micronesia");
    namesMap.put("062", "Timog-Gitnang Asya");
    namesMap.put("142", "Asya");
    namesMap.put("143", "Gitnang Asya");
    namesMap.put("145", "Kanlurang Asya");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Silangang Europa");
    namesMap.put("154", "Hilagang Europa");
    namesMap.put("155", "Kanlurang Europa");
    namesMap.put("419", "Latin America at ang Caribbean");
    namesMap.put("AC", "Acsencion island");
    namesMap.put("AG", "Antigua at Barbuda");
    namesMap.put("AQ", "Antartica");
    namesMap.put("AX", "Aland Islands");
    namesMap.put("CC", "Cocos Islands");
    namesMap.put("CD", "Congo - Kinshasa");
    namesMap.put("CG", "Congo - Brazzaville");
    namesMap.put("CI", "Côte d'Ivoire");
    namesMap.put("CN", "Tsina");
    namesMap.put("CS", "Serbia at Montenegro");
    namesMap.put("DE", "Alemanya");
    namesMap.put("EG", "Ehipto");
    namesMap.put("ES", "Espanya");
    namesMap.put("FK", "Falkland Islands");
    namesMap.put("FR", "Pranses");
    namesMap.put("GR", "Griyego");
    namesMap.put("GS", "South Georgia and The South Sandwich Islands");
    namesMap.put("IC", "Canary Island");
    namesMap.put("IT", "Italya");
    namesMap.put("KR", "Timog Korea");
    namesMap.put("MK", "Macedonia");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MX", "Mehiko");
    namesMap.put("PH", "Pilipinas");
    namesMap.put("PM", "Saint Pierre at Miquelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PS", "Palestinian Territory");
    namesMap.put("QO", "Malayong bahagi ng Oceania");
    namesMap.put("RU", "Russian Federation");
    namesMap.put("SA", "Saudi Arabya");
    namesMap.put("SH", "St. Helena");
    namesMap.put("SJ", "Svalbard and Jan Mayen Islands");
    namesMap.put("ST", "Sao Tome and Principe");
    namesMap.put("TA", "Tristan de Cunha");
    namesMap.put("UM", "Mga Minor Outlying Island ng Estados Unidos");
    namesMap.put("US", "Estados Unidos");
    namesMap.put("WF", "Wallis and the Futuna Islands");
    namesMap.put("ZZ", "Hindi kilala o Hindi wastong Rehiyon");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Mundo",
        "011": "Kanlurang Africa",
        "013": "Gitnang Amerika",
        "014": "Silangang Africa",
        "015": "Hilagang Africa",
        "017": "Gitnang Africa",
        "018": "Katimugang Africa",
        "021": "Hilagang Amerika",
        "029": "Carribbean",
        "030": "Silangang Asya",
        "034": "Katimugang Asya",
        "035": "Timog-Silangang Asya",
        "039": "Katimugang Europa",
        "053": "Australia at New Zealand",
        "057": "Rehiyong Micronesia",
        "062": "Timog-Gitnang Asya",
        "142": "Asya",
        "143": "Gitnang Asya",
        "145": "Kanlurang Asya",
        "150": "Europa",
        "151": "Silangang Europa",
        "154": "Hilagang Europa",
        "155": "Kanlurang Europa",
        "419": "Latin America at ang Caribbean",
        "AC": "Acsencion island",
        "AG": "Antigua at Barbuda",
        "AQ": "Antartica",
        "AX": "Aland Islands",
        "CC": "Cocos Islands",
        "CD": "Congo - Kinshasa",
        "CG": "Congo - Brazzaville",
        "CI": "Côte d'Ivoire",
        "CN": "Tsina",
        "CS": "Serbia at Montenegro",
        "DE": "Alemanya",
        "EG": "Ehipto",
        "ES": "Espanya",
        "FK": "Falkland Islands",
        "FR": "Pranses",
        "GR": "Griyego",
        "GS": "South Georgia and The South Sandwich Islands",
        "IC": "Canary Island",
        "IT": "Italya",
        "KR": "Timog Korea",
        "MK": "Macedonia",
        "MM": "Myanmar",
        "MX": "Mehiko",
        "PH": "Pilipinas",
        "PM": "Saint Pierre at Miquelon",
        "PN": "Pitcairn",
        "PS": "Palestinian Territory",
        "QO": "Malayong bahagi ng Oceania",
        "RU": "Russian Federation",
        "SA": "Saudi Arabya",
        "SH": "St. Helena",
        "SJ": "Svalbard and Jan Mayen Islands",
        "ST": "Sao Tome and Principe",
        "TA": "Tristan de Cunha",
        "UM": "Mga Minor Outlying Island ng Estados Unidos",
        "US": "Estados Unidos",
        "WF": "Wallis and the Futuna Islands",
        "ZZ": "Hindi kilala o Hindi wastong Rehiyon"
    };
  }-*/;
}
