/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.cliparams;

import amazon.fws.clicommando.config.OptionConfig;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.processors.cliparams.MultipleCliParamProcessor;
import amazon.fws.clicommando.util.StringUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapCliParamProcessor
extends MultipleCliParamProcessor {
    private static final String RECORD_SEPARATOR = "\u001e";

    public MapCliParamProcessor(ParamConfig paramConfig, String[] commandLineArguments) {
        super(paramConfig, commandLineArguments);
        OptionConfig mapOption = paramConfig.getFirstOption();
        String mapEntrySeparator = mapOption.getMapEntrySeparator();
        if (StringUtils.isEmpty(mapEntrySeparator) || StringUtils.isEmpty(mapEntrySeparator.trim())) {
            throw new ConfigurationErrorException(paramConfig.getName() + "." + mapOption.toString() + ":  Entry separator cannot be a space character");
        }
    }

    @Override
    public void loadOptions(Options options) throws CliCommandoException {
        super.loadOptions(options);
    }

    @Override
    public void loadValuesFromCommandLine(CommandLine line) throws CliCommandoException {
        String keyValueSeparator = this.paramConfig.getFirstOption().getKeyValueSeparator();
        OptionConfig mapOption = this.paramConfig.getFirstOption();
        if (StringUtils.isEmpty(keyValueSeparator)) {
            throw new ConfigurationErrorException("No key value separator defined for: " + this.paramConfig.getName());
        }
        String[] paramValues = this.getOptionValues(line);
        String mapEntrySeparator = mapOption.getMapEntrySeparator();
        String valueSeparator = mapOption.getValueSeparator();
        if ((paramValues = this.compressMapResults(paramValues, mapEntrySeparator)) != null) {
            for (String mapString : paramValues) {
                Map<String, String> mapValues = this.parseValues(mapString.split(mapEntrySeparator), keyValueSeparator);
                this.paramConfig.getValuesMap().add(mapValues);
                if (valueSeparator == null || "".equals(valueSeparator)) break;
            }
        }
    }

    private Map<String, String> parseValues(String[] paramValues, String keyValueSeparator) {
        LinkedHashMap<String, String> valuesMap = new LinkedHashMap<String, String>();
        if (paramValues != null) {
            for (String keyValuePair : paramValues) {
                int separatorLocation = keyValuePair.indexOf(keyValueSeparator);
                if (separatorLocation == -1) {
                    throw new BadInputException(ErrorMessages.ErrorCode.NO_SEPARATOR_FOUND_IN_MAP, keyValueSeparator, keyValuePair);
                }
                String name = keyValuePair.substring(0, separatorLocation);
                int valueBegin = Math.min(keyValuePair.length(), separatorLocation + keyValueSeparator.length());
                String value = keyValuePair.substring(valueBegin);
                valuesMap.put(name, value);
            }
        }
        return valuesMap;
    }

    private String[] compressMapResults(String[] results, String sepString) {
        if (StringUtils.isEmpty(sepString) || results == null) {
            return results;
        }
        StringBuilder sb = new StringBuilder();
        char sep = sepString.charAt(0);
        for (String s : results) {
            if (s.charAt(0) == sep || sb.length() == 0 || sb.charAt(sb.length() - 1) == sep) {
                sb.append(s);
                continue;
            }
            sb.append(RECORD_SEPARATOR + s);
        }
        return sb.toString().split(RECORD_SEPARATOR);
    }
}

