/*
A GeoClue provider to use the Ubuntu GeoIP web service

Copyright 2010 Canonical Ltd.

Authors:
    Ted Gould <ted@canonical.com>

This program is free software: you can redistribute it and/or modify it 
under the terms of the GNU General Public License version 3, as published 
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranties of 
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __UBUNTU_GEOIP_PROVIDER_H__
#define __UBUNTU_GEOIP_PROVIDER_H__

#include <glib.h>
#include <glib-object.h>

#include <geoclue/gc-provider.h>

G_BEGIN_DECLS

#define UBUNTU_GEOIP_PROVIDER_TYPE            (ubuntu_geoip_provider_get_type ())
#define UBUNTU_GEOIP_PROVIDER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), UBUNTU_GEOIP_PROVIDER_TYPE, UbuntuGeoipProvider))
#define UBUNTU_GEOIP_PROVIDER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), UBUNTU_GEOIP_PROVIDER_TYPE, UbuntuGeoipProviderClass))
#define IS_UBUNTU_GEOIP_PROVIDER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UBUNTU_GEOIP_PROVIDER_TYPE))
#define IS_UBUNTU_GEOIP_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UBUNTU_GEOIP_PROVIDER_TYPE))
#define UBUNTU_GEOIP_PROVIDER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), UBUNTU_GEOIP_PROVIDER_TYPE, UbuntuGeoipProviderClass))

typedef struct _UbuntuGeoipProvider        UbuntuGeoipProvider;
typedef struct _UbuntuGeoipProviderClass   UbuntuGeoipProviderClass;
typedef struct _UbuntuGeoipProviderPrivate UbuntuGeoipProviderPrivate;

struct _UbuntuGeoipProviderClass {
	GcProviderClass parent_class;
};

struct _UbuntuGeoipProvider {
	GcProvider parent;
	UbuntuGeoipProviderPrivate * priv;
};

GType ubuntu_geoip_provider_get_type (void);

G_END_DECLS

#endif
