// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef REMOTING_HOST_FAKE_OAUTH_TOKEN_GETTER_H_
#define REMOTING_HOST_FAKE_OAUTH_TOKEN_GETTER_H_

#include <string>

#include "base/callback.h"
#include "remoting/host/oauth_token_getter.h"

namespace remoting {

class FakeOAuthTokenGetter : public OAuthTokenGetter {
 public:
  FakeOAuthTokenGetter(Status status,
                       const std::string& user_email,
                       const std::string& access_token);
  ~FakeOAuthTokenGetter() override;

  // OAuthTokenGetter interface.
  void CallWithToken(const TokenCallback& on_access_token) override;
  void InvalidateCache() override;

 private:
  Status status_;
  std::string user_email_;
  std::string access_token_;
};

}  // namespace remoting

#endif  // REMOTING_HOST_FAKE_OAUTH_TOKEN_GETTER_H_
