/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#include "rtfcontrolwords.hxx"
#include <oox/token/namespaces.hxx>

namespace writerfilter::rtftok
{
RTFSymbol const aRTFControlWords[] = {
    // sKeyword nControlType nIndex
    { "'", RTFControlType::SYMBOL, RTFKeyword::HEXCHAR, 0 },
    { "-", RTFControlType::SYMBOL, RTFKeyword::OPTHYPH, 0 },
    { "*", RTFControlType::SYMBOL, RTFKeyword::IGNORE, 0 },
    { ":", RTFControlType::SYMBOL, RTFKeyword::SUBENTRY, 0 },
    { "\\", RTFControlType::SYMBOL, RTFKeyword::BACKSLASH, 0 },
    { "\n", RTFControlType::SYMBOL, RTFKeyword::PAR, 0 },
    { "\r", RTFControlType::SYMBOL, RTFKeyword::PAR, 0 },
    { "\r\n", RTFControlType::SYMBOL, RTFKeyword::PAR, 0 },
    { "_", RTFControlType::SYMBOL, RTFKeyword::NOBRKHYPH, 0 },
    { "{", RTFControlType::SYMBOL, RTFKeyword::LBRACE, 0 },
    { "|", RTFControlType::SYMBOL, RTFKeyword::FORMULA, 0 },
    { "}", RTFControlType::SYMBOL, RTFKeyword::RBRACE, 0 },
    { "~", RTFControlType::SYMBOL, RTFKeyword::NOBREAK, 0 },
    { "ab", RTFControlType::TOGGLE, RTFKeyword::AB, 1 },
    { "absh", RTFControlType::VALUE, RTFKeyword::ABSH, 0 },
    { "abslock", RTFControlType::FLAG, RTFKeyword::ABSLOCK, 0 },
    { "absnoovrlp", RTFControlType::TOGGLE, RTFKeyword::ABSNOOVRLP, 1 },
    { "absw", RTFControlType::VALUE, RTFKeyword::ABSW, 0 },
    { "acaps", RTFControlType::TOGGLE, RTFKeyword::ACAPS, 1 },
    { "acccircle", RTFControlType::TOGGLE, RTFKeyword::ACCCIRCLE, 1 },
    { "acccomma", RTFControlType::TOGGLE, RTFKeyword::ACCCOMMA, 1 },
    { "accdot", RTFControlType::TOGGLE, RTFKeyword::ACCDOT, 1 },
    { "accnone", RTFControlType::TOGGLE, RTFKeyword::ACCNONE, 1 },
    { "accunderdot", RTFControlType::TOGGLE, RTFKeyword::ACCUNDERDOT, 1 },
    { "acf", RTFControlType::VALUE, RTFKeyword::ACF, 0 },
    { "adeff", RTFControlType::VALUE, RTFKeyword::ADEFF, 0 },
    { "additive", RTFControlType::FLAG, RTFKeyword::ADDITIVE, 0 },
    { "adeflang", RTFControlType::VALUE, RTFKeyword::ADEFLANG, 0 },
    { "adjustright", RTFControlType::FLAG, RTFKeyword::ADJUSTRIGHT, 0 },
    { "adn", RTFControlType::VALUE, RTFKeyword::ADN, 6 },
    { "aenddoc", RTFControlType::FLAG, RTFKeyword::AENDDOC, 0 },
    { "aendnotes", RTFControlType::FLAG, RTFKeyword::AENDNOTES, 0 },
    { "aexpnd", RTFControlType::VALUE, RTFKeyword::AEXPND, 0 },
    { "af", RTFControlType::VALUE, RTFKeyword::AF, 0 },
    { "afelev", RTFControlType::FLAG, RTFKeyword::AFELEV, 0 },
    { "afs", RTFControlType::VALUE, RTFKeyword::AFS, 24 },
    { "aftnbj", RTFControlType::FLAG, RTFKeyword::AFTNBJ, 0 },
    { "aftncn", RTFControlType::DESTINATION, RTFKeyword::AFTNCN, 0 },
    { "aftnnalc", RTFControlType::FLAG, RTFKeyword::AFTNNALC, 0 },
    { "aftnnar", RTFControlType::FLAG, RTFKeyword::AFTNNAR, 0 },
    { "aftnnauc", RTFControlType::FLAG, RTFKeyword::AFTNNAUC, 0 },
    { "aftnnchi", RTFControlType::FLAG, RTFKeyword::AFTNNCHI, 0 },
    { "aftnnchosung", RTFControlType::FLAG, RTFKeyword::AFTNNCHOSUNG, 0 },
    { "aftnncnum", RTFControlType::FLAG, RTFKeyword::AFTNNCNUM, 0 },
    { "aftnndbar", RTFControlType::FLAG, RTFKeyword::AFTNNDBAR, 0 },
    { "aftnndbnum", RTFControlType::FLAG, RTFKeyword::AFTNNDBNUM, 0 },
    { "aftnndbnumd", RTFControlType::FLAG, RTFKeyword::AFTNNDBNUMD, 0 },
    { "aftnndbnumk", RTFControlType::FLAG, RTFKeyword::AFTNNDBNUMK, 0 },
    { "aftnndbnumt", RTFControlType::FLAG, RTFKeyword::AFTNNDBNUMT, 0 },
    { "aftnnganada", RTFControlType::FLAG, RTFKeyword::AFTNNGANADA, 0 },
    { "aftnngbnum", RTFControlType::FLAG, RTFKeyword::AFTNNGBNUM, 0 },
    { "aftnngbnumd", RTFControlType::FLAG, RTFKeyword::AFTNNGBNUMD, 0 },
    { "aftnngbnumk", RTFControlType::FLAG, RTFKeyword::AFTNNGBNUMK, 0 },
    { "aftnngbnuml", RTFControlType::FLAG, RTFKeyword::AFTNNGBNUML, 0 },
    { "aftnnrlc", RTFControlType::FLAG, RTFKeyword::AFTNNRLC, 0 },
    { "aftnnruc", RTFControlType::FLAG, RTFKeyword::AFTNNRUC, 0 },
    { "aftnnzodiac", RTFControlType::FLAG, RTFKeyword::AFTNNZODIAC, 0 },
    { "aftnnzodiacd", RTFControlType::FLAG, RTFKeyword::AFTNNZODIACD, 0 },
    { "aftnnzodiacl", RTFControlType::FLAG, RTFKeyword::AFTNNZODIACL, 0 },
    { "aftnrestart", RTFControlType::FLAG, RTFKeyword::AFTNRESTART, 0 },
    { "aftnrstcont", RTFControlType::FLAG, RTFKeyword::AFTNRSTCONT, 0 },
    { "aftnsep", RTFControlType::DESTINATION, RTFKeyword::AFTNSEP, 0 },
    { "aftnsepc", RTFControlType::DESTINATION, RTFKeyword::AFTNSEPC, 0 },
    { "aftnstart", RTFControlType::VALUE, RTFKeyword::AFTNSTART, 1 },
    { "aftntj", RTFControlType::FLAG, RTFKeyword::AFTNTJ, 0 },
    { "ai", RTFControlType::TOGGLE, RTFKeyword::AI, 1 },
    { "alang", RTFControlType::VALUE, RTFKeyword::ALANG, 0 },
    { "allowfieldendsel", RTFControlType::FLAG, RTFKeyword::ALLOWFIELDENDSEL, 0 },
    { "allprot", RTFControlType::FLAG, RTFKeyword::ALLPROT, 0 },
    { "alntblind", RTFControlType::FLAG, RTFKeyword::ALNTBLIND, 0 },
    { "alt", RTFControlType::FLAG, RTFKeyword::ALT, 0 },
    { "animtext", RTFControlType::VALUE, RTFKeyword::ANIMTEXT, 0 },
    { "annotation", RTFControlType::DESTINATION, RTFKeyword::ANNOTATION, 0 },
    { "annotprot", RTFControlType::FLAG, RTFKeyword::ANNOTPROT, 0 },
    { "ansi", RTFControlType::FLAG, RTFKeyword::ANSI, 0 },
    { "ansicpg", RTFControlType::VALUE, RTFKeyword::ANSICPG, 0 },
    { "aoutl", RTFControlType::TOGGLE, RTFKeyword::AOUTL, 1 },
    { "ApplyBrkRules", RTFControlType::FLAG, RTFKeyword::APPLYBRKRULES, 0 },
    { "ascaps", RTFControlType::TOGGLE, RTFKeyword::ASCAPS, 1 },
    { "ashad", RTFControlType::TOGGLE, RTFKeyword::ASHAD, 1 },
    { "asianbrkrule", RTFControlType::FLAG, RTFKeyword::ASIANBRKRULE, 0 },
    { "aspalpha", RTFControlType::TOGGLE, RTFKeyword::ASPALPHA, 1 },
    { "aspnum", RTFControlType::TOGGLE, RTFKeyword::ASPNUM, 1 },
    { "astrike", RTFControlType::TOGGLE, RTFKeyword::ASTRIKE, 1 },
    { "atnauthor", RTFControlType::DESTINATION, RTFKeyword::ATNAUTHOR, 0 },
    { "atndate", RTFControlType::DESTINATION, RTFKeyword::ATNDATE, 0 },
    { "atnicn", RTFControlType::DESTINATION, RTFKeyword::ATNICN, 0 },
    { "atnid", RTFControlType::DESTINATION, RTFKeyword::ATNID, 0 },
    { "atnparent", RTFControlType::DESTINATION, RTFKeyword::ATNPARENT, 0 },
    { "atnref", RTFControlType::DESTINATION, RTFKeyword::ATNREF, 0 },
    { "atntime", RTFControlType::DESTINATION, RTFKeyword::ATNTIME, 0 },
    { "atrfend", RTFControlType::DESTINATION, RTFKeyword::ATRFEND, 0 },
    { "atrfstart", RTFControlType::DESTINATION, RTFKeyword::ATRFSTART, 0 },
    { "aul", RTFControlType::TOGGLE, RTFKeyword::AUL, 1 },
    { "auld", RTFControlType::TOGGLE, RTFKeyword::AULD, 1 },
    { "auldb", RTFControlType::TOGGLE, RTFKeyword::AULDB, 1 },
    { "aulnone", RTFControlType::TOGGLE, RTFKeyword::AULNONE, 1 },
    { "aulw", RTFControlType::TOGGLE, RTFKeyword::AULW, 1 },
    { "aup", RTFControlType::VALUE, RTFKeyword::AUP, 6 },
    { "author", RTFControlType::DESTINATION, RTFKeyword::AUTHOR, 0 },
    { "autofmtoverride", RTFControlType::FLAG, RTFKeyword::AUTOFMTOVERRIDE, 0 },
    { "b", RTFControlType::TOGGLE, RTFKeyword::B, 1 },
    { "background", RTFControlType::DESTINATION, RTFKeyword::BACKGROUND, 0 },
    { "bdbfhdr", RTFControlType::FLAG, RTFKeyword::BDBFHDR, 0 },
    { "bdrrlswsix", RTFControlType::FLAG, RTFKeyword::BDRRLSWSIX, 0 },
    { "bgbdiag", RTFControlType::FLAG, RTFKeyword::BGBDIAG, 0 },
    { "bgcross", RTFControlType::FLAG, RTFKeyword::BGCROSS, 0 },
    { "bgdcross", RTFControlType::FLAG, RTFKeyword::BGDCROSS, 0 },
    { "bgdkbdiag", RTFControlType::FLAG, RTFKeyword::BGDKBDIAG, 0 },
    { "bgdkcross", RTFControlType::FLAG, RTFKeyword::BGDKCROSS, 0 },
    { "bgdkdcross", RTFControlType::FLAG, RTFKeyword::BGDKDCROSS, 0 },
    { "bgdkfdiag", RTFControlType::FLAG, RTFKeyword::BGDKFDIAG, 0 },
    { "bgdkhoriz", RTFControlType::FLAG, RTFKeyword::BGDKHORIZ, 0 },
    { "bgdkvert", RTFControlType::FLAG, RTFKeyword::BGDKVERT, 0 },
    { "bgfdiag", RTFControlType::FLAG, RTFKeyword::BGFDIAG, 0 },
    { "bghoriz", RTFControlType::FLAG, RTFKeyword::BGHORIZ, 0 },
    { "bgvert", RTFControlType::FLAG, RTFKeyword::BGVERT, 0 },
    { "bin", RTFControlType::VALUE, RTFKeyword::BIN, 0 },
    { "binfsxn", RTFControlType::VALUE, RTFKeyword::BINFSXN, 0 },
    { "binsxn", RTFControlType::VALUE, RTFKeyword::BINSXN, 0 },
    { "bkmkcolf", RTFControlType::VALUE, RTFKeyword::BKMKCOLF, 0 },
    { "bkmkcoll", RTFControlType::VALUE, RTFKeyword::BKMKCOLL, 0 },
    { "bkmkend", RTFControlType::DESTINATION, RTFKeyword::BKMKEND, 0 },
    { "bkmkpub", RTFControlType::FLAG, RTFKeyword::BKMKPUB, 0 },
    { "bkmkstart", RTFControlType::DESTINATION, RTFKeyword::BKMKSTART, 0 },
    { "bliptag", RTFControlType::VALUE, RTFKeyword::BLIPTAG, 0 },
    { "blipuid", RTFControlType::DESTINATION, RTFKeyword::BLIPUID, 0 },
    { "blipupi", RTFControlType::VALUE, RTFKeyword::BLIPUPI, 0 },
    { "blue", RTFControlType::VALUE, RTFKeyword::BLUE, 0 },
    { "bookfold", RTFControlType::FLAG, RTFKeyword::BOOKFOLD, 0 },
    { "bookfoldrev", RTFControlType::FLAG, RTFKeyword::BOOKFOLDREV, 0 },
    { "bookfoldsheets", RTFControlType::VALUE, RTFKeyword::BOOKFOLDSHEETS, 0 },
    { "box", RTFControlType::FLAG, RTFKeyword::BOX, 0 },
    { "brdrart", RTFControlType::VALUE, RTFKeyword::BRDRART, 0 },
    { "brdrb", RTFControlType::FLAG, RTFKeyword::BRDRB, 0 },
    { "brdrbar", RTFControlType::FLAG, RTFKeyword::BRDRBAR, 0 },
    { "brdrbtw", RTFControlType::FLAG, RTFKeyword::BRDRBTW, 0 },
    { "brdrcf", RTFControlType::VALUE, RTFKeyword::BRDRCF, 0 },
    { "brdrdash", RTFControlType::FLAG, RTFKeyword::BRDRDASH, 0 },
    { "brdrdashd", RTFControlType::FLAG, RTFKeyword::BRDRDASHD, 0 },
    { "brdrdashdd", RTFControlType::FLAG, RTFKeyword::BRDRDASHDD, 0 },
    { "brdrdashdotstr", RTFControlType::FLAG, RTFKeyword::BRDRDASHDOTSTR, 0 },
    { "brdrdashsm", RTFControlType::FLAG, RTFKeyword::BRDRDASHSM, 0 },
    { "brdrdb", RTFControlType::FLAG, RTFKeyword::BRDRDB, 0 },
    { "brdrdot", RTFControlType::FLAG, RTFKeyword::BRDRDOT, 0 },
    { "brdremboss", RTFControlType::FLAG, RTFKeyword::BRDREMBOSS, 0 },
    { "brdrengrave", RTFControlType::FLAG, RTFKeyword::BRDRENGRAVE, 0 },
    { "brdrframe", RTFControlType::FLAG, RTFKeyword::BRDRFRAME, 0 },
    { "brdrhair", RTFControlType::FLAG, RTFKeyword::BRDRHAIR, 0 },
    { "brdrinset", RTFControlType::FLAG, RTFKeyword::BRDRINSET, 0 },
    { "brdrl", RTFControlType::FLAG, RTFKeyword::BRDRL, 0 },
    { "brdrnil", RTFControlType::FLAG, RTFKeyword::BRDRNIL, 0 },
    { "brdrnone", RTFControlType::FLAG, RTFKeyword::BRDRNONE, 0 },
    { "brdroutset", RTFControlType::FLAG, RTFKeyword::BRDROUTSET, 0 },
    { "brdrr", RTFControlType::FLAG, RTFKeyword::BRDRR, 0 },
    { "brdrs", RTFControlType::FLAG, RTFKeyword::BRDRS, 0 },
    { "brdrsh", RTFControlType::FLAG, RTFKeyword::BRDRSH, 0 },
    { "brdrt", RTFControlType::FLAG, RTFKeyword::BRDRT, 0 },
    { "brdrtbl", RTFControlType::FLAG, RTFKeyword::BRDRTBL, 0 },
    { "brdrth", RTFControlType::FLAG, RTFKeyword::BRDRTH, 0 },
    { "brdrthtnlg", RTFControlType::FLAG, RTFKeyword::BRDRTHTNLG, 0 },
    { "brdrthtnmg", RTFControlType::FLAG, RTFKeyword::BRDRTHTNMG, 0 },
    { "brdrthtnsg", RTFControlType::FLAG, RTFKeyword::BRDRTHTNSG, 0 },
    { "brdrtnthlg", RTFControlType::FLAG, RTFKeyword::BRDRTNTHLG, 0 },
    { "brdrtnthmg", RTFControlType::FLAG, RTFKeyword::BRDRTNTHMG, 0 },
    { "brdrtnthsg", RTFControlType::FLAG, RTFKeyword::BRDRTNTHSG, 0 },
    { "brdrtnthtnlg", RTFControlType::FLAG, RTFKeyword::BRDRTNTHTNLG, 0 },
    { "brdrtnthtnmg", RTFControlType::FLAG, RTFKeyword::BRDRTNTHTNMG, 0 },
    { "brdrtnthtnsg", RTFControlType::FLAG, RTFKeyword::BRDRTNTHTNSG, 0 },
    { "brdrtriple", RTFControlType::FLAG, RTFKeyword::BRDRTRIPLE, 0 },
    { "brdrw", RTFControlType::VALUE, RTFKeyword::BRDRW, 0 },
    { "brdrwavy", RTFControlType::FLAG, RTFKeyword::BRDRWAVY, 0 },
    { "brdrwavydb", RTFControlType::FLAG, RTFKeyword::BRDRWAVYDB, 0 },
    { "brkfrm", RTFControlType::FLAG, RTFKeyword::BRKFRM, 0 },
    { "brsp", RTFControlType::VALUE, RTFKeyword::BRSP, 0 },
    { "bullet", RTFControlType::SYMBOL, RTFKeyword::BULLET, 0 },
    { "buptim", RTFControlType::DESTINATION, RTFKeyword::BUPTIM, 0 },
    { "bxe", RTFControlType::FLAG, RTFKeyword::BXE, 0 },
    { "caccentfive", RTFControlType::FLAG, RTFKeyword::CACCENTFIVE, 0 },
    { "caccentfour", RTFControlType::FLAG, RTFKeyword::CACCENTFOUR, 0 },
    { "caccentone", RTFControlType::FLAG, RTFKeyword::CACCENTONE, 0 },
    { "caccentsix", RTFControlType::FLAG, RTFKeyword::CACCENTSIX, 0 },
    { "caccentthree", RTFControlType::FLAG, RTFKeyword::CACCENTTHREE, 0 },
    { "caccenttwo", RTFControlType::FLAG, RTFKeyword::CACCENTTWO, 0 },
    { "cachedcolbal", RTFControlType::FLAG, RTFKeyword::CACHEDCOLBAL, 0 },
    { "caps", RTFControlType::TOGGLE, RTFKeyword::CAPS, 1 },
    { "category", RTFControlType::DESTINATION, RTFKeyword::CATEGORY, 0 },
    { "cb", RTFControlType::VALUE, RTFKeyword::CB, 0 },
    { "cbackgroundone", RTFControlType::FLAG, RTFKeyword::CBACKGROUNDONE, 0 },
    { "cbackgroundtwo", RTFControlType::FLAG, RTFKeyword::CBACKGROUNDTWO, 0 },
    { "cbpat", RTFControlType::VALUE, RTFKeyword::CBPAT, 0 },
    { "cchs", RTFControlType::VALUE, RTFKeyword::CCHS, 0 },
    { "cell", RTFControlType::SYMBOL, RTFKeyword::CELL, 0 },
    { "cellx", RTFControlType::VALUE, RTFKeyword::CELLX, 0 },
    { "cf", RTFControlType::VALUE, RTFKeyword::CF, 0 },
    { "cfollowedhyperlink", RTFControlType::FLAG, RTFKeyword::CFOLLOWEDHYPERLINK, 0 },
    { "cfpat", RTFControlType::VALUE, RTFKeyword::CFPAT, 0 },
    { "cgrid", RTFControlType::VALUE, RTFKeyword::CGRID, 0 },
    { "charrsid", RTFControlType::VALUE, RTFKeyword::CHARRSID, 0 },
    { "charscalex", RTFControlType::VALUE, RTFKeyword::CHARSCALEX, 100 },
    { "chatn", RTFControlType::SYMBOL, RTFKeyword::CHATN, 0 },
    { "chbgbdiag", RTFControlType::FLAG, RTFKeyword::CHBGBDIAG, 0 },
    { "chbgcross", RTFControlType::FLAG, RTFKeyword::CHBGCROSS, 0 },
    { "chbgdcross", RTFControlType::FLAG, RTFKeyword::CHBGDCROSS, 0 },
    { "chbgdkbdiag", RTFControlType::FLAG, RTFKeyword::CHBGDKBDIAG, 0 },
    { "chbgdkcross", RTFControlType::FLAG, RTFKeyword::CHBGDKCROSS, 0 },
    { "chbgdkdcross", RTFControlType::FLAG, RTFKeyword::CHBGDKDCROSS, 0 },
    { "chbgdkfdiag", RTFControlType::FLAG, RTFKeyword::CHBGDKFDIAG, 0 },
    { "chbgdkhoriz", RTFControlType::FLAG, RTFKeyword::CHBGDKHORIZ, 0 },
    { "chbgdkvert", RTFControlType::FLAG, RTFKeyword::CHBGDKVERT, 0 },
    { "chbgfdiag", RTFControlType::FLAG, RTFKeyword::CHBGFDIAG, 0 },
    { "chbghoriz", RTFControlType::FLAG, RTFKeyword::CHBGHORIZ, 0 },
    { "chbgvert", RTFControlType::FLAG, RTFKeyword::CHBGVERT, 0 },
    { "chbrdr", RTFControlType::FLAG, RTFKeyword::CHBRDR, 0 },
    { "chcbpat", RTFControlType::VALUE, RTFKeyword::CHCBPAT, 0 },
    { "chcfpat", RTFControlType::VALUE, RTFKeyword::CHCFPAT, 0 },
    { "chdate", RTFControlType::SYMBOL, RTFKeyword::CHDATE, 0 },
    { "chdpa", RTFControlType::SYMBOL, RTFKeyword::CHDPA, 0 },
    { "chdpl", RTFControlType::SYMBOL, RTFKeyword::CHDPL, 0 },
    { "chftn", RTFControlType::SYMBOL, RTFKeyword::CHFTN, 0 },
    { "chftnsep", RTFControlType::SYMBOL, RTFKeyword::CHFTNSEP, 0 },
    { "chftnsepc", RTFControlType::SYMBOL, RTFKeyword::CHFTNSEPC, 0 },
    { "chpgn", RTFControlType::SYMBOL, RTFKeyword::CHPGN, 0 },
    { "chhres", RTFControlType::VALUE, RTFKeyword::CHHRES, 0 },
    { "chshdng", RTFControlType::VALUE, RTFKeyword::CHSHDNG, 0 },
    { "chtime", RTFControlType::SYMBOL, RTFKeyword::CHTIME, 0 },
    { "chyperlink", RTFControlType::FLAG, RTFKeyword::CHYPERLINK, 0 },
    { "clbgbdiag", RTFControlType::FLAG, RTFKeyword::CLBGBDIAG, 0 },
    { "clbgcross", RTFControlType::FLAG, RTFKeyword::CLBGCROSS, 0 },
    { "clbgdcross", RTFControlType::FLAG, RTFKeyword::CLBGDCROSS, 0 },
    { "clbgdkbdiag", RTFControlType::FLAG, RTFKeyword::CLBGDKBDIAG, 0 },
    { "clbgdkcross", RTFControlType::FLAG, RTFKeyword::CLBGDKCROSS, 0 },
    { "clbgdkdcross", RTFControlType::FLAG, RTFKeyword::CLBGDKDCROSS, 0 },
    { "clbgdkfdiag", RTFControlType::FLAG, RTFKeyword::CLBGDKFDIAG, 0 },
    { "clbgdkhor", RTFControlType::FLAG, RTFKeyword::CLBGDKHOR, 0 },
    { "clbgdkvert", RTFControlType::FLAG, RTFKeyword::CLBGDKVERT, 0 },
    { "clbgfdiag", RTFControlType::FLAG, RTFKeyword::CLBGFDIAG, 0 },
    { "clbghoriz", RTFControlType::FLAG, RTFKeyword::CLBGHORIZ, 0 },
    { "clbgvert", RTFControlType::FLAG, RTFKeyword::CLBGVERT, 0 },
    { "clbrdrb", RTFControlType::FLAG, RTFKeyword::CLBRDRB, 0 },
    { "clbrdrl", RTFControlType::FLAG, RTFKeyword::CLBRDRL, 0 },
    { "clbrdrr", RTFControlType::FLAG, RTFKeyword::CLBRDRR, 0 },
    { "clbrdrt", RTFControlType::FLAG, RTFKeyword::CLBRDRT, 0 },
    { "clcbpat", RTFControlType::VALUE, RTFKeyword::CLCBPAT, 0 },
    { "clcbpatraw", RTFControlType::VALUE, RTFKeyword::CLCBPATRAW, 0 },
    { "clcfpat", RTFControlType::VALUE, RTFKeyword::CLCFPAT, 0 },
    { "clcfpatraw", RTFControlType::VALUE, RTFKeyword::CLCFPATRAW, 0 },
    { "cldel", RTFControlType::FLAG, RTFKeyword::CLDEL, 0 },
    { "cldelauth", RTFControlType::VALUE, RTFKeyword::CLDELAUTH, 0 },
    { "cldeldttm", RTFControlType::VALUE, RTFKeyword::CLDELDTTM, 0 },
    { "cldgll", RTFControlType::FLAG, RTFKeyword::CLDGLL, 0 },
    { "cldglu", RTFControlType::FLAG, RTFKeyword::CLDGLU, 0 },
    { "clFitText", RTFControlType::FLAG, RTFKeyword::CLFITTEXT, 0 },
    { "clftsWidth", RTFControlType::VALUE, RTFKeyword::CLFTSWIDTH, 0 },
    { "clhidemark", RTFControlType::FLAG, RTFKeyword::CLHIDEMARK, 0 },
    { "clins", RTFControlType::FLAG, RTFKeyword::CLINS, 0 },
    { "clinsauth", RTFControlType::VALUE, RTFKeyword::CLINSAUTH, 0 },
    { "clinsdttm", RTFControlType::VALUE, RTFKeyword::CLINSDTTM, 0 },
    { "clmgf", RTFControlType::FLAG, RTFKeyword::CLMGF, 0 },
    { "clmrg", RTFControlType::FLAG, RTFKeyword::CLMRG, 0 },
    { "clmrgd", RTFControlType::FLAG, RTFKeyword::CLMRGD, 0 },
    { "clmrgdauth", RTFControlType::VALUE, RTFKeyword::CLMRGDAUTH, 0 },
    { "clmrgddttm", RTFControlType::VALUE, RTFKeyword::CLMRGDDTTM, 0 },
    { "clmrgdr", RTFControlType::FLAG, RTFKeyword::CLMRGDR, 0 },
    { "clNoWrap", RTFControlType::FLAG, RTFKeyword::CLNOWRAP, 0 },
    { "clpadb", RTFControlType::VALUE, RTFKeyword::CLPADB, 0 },
    { "clpadfb", RTFControlType::VALUE, RTFKeyword::CLPADFB, 0 },
    { "clpadfl", RTFControlType::VALUE, RTFKeyword::CLPADFL, 0 },
    { "clpadfr", RTFControlType::VALUE, RTFKeyword::CLPADFR, 0 },
    { "clpadft", RTFControlType::VALUE, RTFKeyword::CLPADFT, 0 },
    { "clpadl", RTFControlType::VALUE, RTFKeyword::CLPADL, 0 },
    { "clpadr", RTFControlType::VALUE, RTFKeyword::CLPADR, 0 },
    { "clpadt", RTFControlType::VALUE, RTFKeyword::CLPADT, 0 },
    { "clspb", RTFControlType::VALUE, RTFKeyword::CLSPB, 0 },
    { "clspfb", RTFControlType::VALUE, RTFKeyword::CLSPFB, 0 },
    { "clspfl", RTFControlType::VALUE, RTFKeyword::CLSPFL, 0 },
    { "clspfr", RTFControlType::VALUE, RTFKeyword::CLSPFR, 0 },
    { "clspft", RTFControlType::VALUE, RTFKeyword::CLSPFT, 0 },
    { "clspl", RTFControlType::VALUE, RTFKeyword::CLSPL, 0 },
    { "clspr", RTFControlType::VALUE, RTFKeyword::CLSPR, 0 },
    { "clspt", RTFControlType::VALUE, RTFKeyword::CLSPT, 0 },
    { "clshdng", RTFControlType::VALUE, RTFKeyword::CLSHDNG, 0 },
    { "clshdngraw", RTFControlType::VALUE, RTFKeyword::CLSHDNGRAW, 0 },
    { "clshdrawnil", RTFControlType::FLAG, RTFKeyword::CLSHDRAWNIL, 0 },
    { "clsplit", RTFControlType::FLAG, RTFKeyword::CLSPLIT, 0 },
    { "clsplitr", RTFControlType::FLAG, RTFKeyword::CLSPLITR, 0 },
    { "cltxbtlr", RTFControlType::FLAG, RTFKeyword::CLTXBTLR, 0 },
    { "cltxlrtb", RTFControlType::FLAG, RTFKeyword::CLTXLRTB, 0 },
    { "cltxlrtbv", RTFControlType::FLAG, RTFKeyword::CLTXLRTBV, 0 },
    { "cltxtbrl", RTFControlType::FLAG, RTFKeyword::CLTXTBRL, 0 },
    { "cltxtbrlv", RTFControlType::FLAG, RTFKeyword::CLTXTBRLV, 0 },
    { "clvertalb", RTFControlType::FLAG, RTFKeyword::CLVERTALB, 0 },
    { "clvertalc", RTFControlType::FLAG, RTFKeyword::CLVERTALC, 0 },
    { "clvertalt", RTFControlType::FLAG, RTFKeyword::CLVERTALT, 0 },
    { "clvmgf", RTFControlType::FLAG, RTFKeyword::CLVMGF, 0 },
    { "clvmrg", RTFControlType::FLAG, RTFKeyword::CLVMRG, 0 },
    { "clwWidth", RTFControlType::VALUE, RTFKeyword::CLWWIDTH, 0 },
    { "cmaindarkone", RTFControlType::FLAG, RTFKeyword::CMAINDARKONE, 0 },
    { "cmaindarktwo", RTFControlType::FLAG, RTFKeyword::CMAINDARKTWO, 0 },
    { "cmainlightone", RTFControlType::FLAG, RTFKeyword::CMAINLIGHTONE, 0 },
    { "cmainlighttwo", RTFControlType::FLAG, RTFKeyword::CMAINLIGHTTWO, 0 },
    { "collapsed", RTFControlType::FLAG, RTFKeyword::COLLAPSED, 0 },
    { "colno", RTFControlType::VALUE, RTFKeyword::COLNO, 0 },
    { "colorschememapping", RTFControlType::DESTINATION, RTFKeyword::COLORSCHEMEMAPPING, 0 },
    { "colortbl", RTFControlType::DESTINATION, RTFKeyword::COLORTBL, 0 },
    { "cols", RTFControlType::VALUE, RTFKeyword::COLS, 1 },
    { "colsr", RTFControlType::VALUE, RTFKeyword::COLSR, 0 },
    { "colsx", RTFControlType::VALUE, RTFKeyword::COLSX, 720 },
    { "column", RTFControlType::SYMBOL, RTFKeyword::COLUMN, 0 },
    { "colw", RTFControlType::VALUE, RTFKeyword::COLW, 0 },
    { "comment", RTFControlType::DESTINATION, RTFKeyword::COMMENT, 0 },
    { "company", RTFControlType::DESTINATION, RTFKeyword::COMPANY, 0 },
    { "contextualspace", RTFControlType::FLAG, RTFKeyword::CONTEXTUALSPACE, 0 },
    { "cpg", RTFControlType::VALUE, RTFKeyword::CPG, 0 },
    { "crauth", RTFControlType::VALUE, RTFKeyword::CRAUTH, 0 },
    { "crdate", RTFControlType::VALUE, RTFKeyword::CRDATE, 0 },
    { "creatim", RTFControlType::DESTINATION, RTFKeyword::CREATIM, 0 },
    { "cs", RTFControlType::VALUE, RTFKeyword::CS, 0 },
    { "cshade", RTFControlType::VALUE, RTFKeyword::CSHADE, 0 },
    { "ctextone", RTFControlType::FLAG, RTFKeyword::CTEXTONE, 0 },
    { "ctexttwo", RTFControlType::FLAG, RTFKeyword::CTEXTTWO, 0 },
    { "ctint", RTFControlType::VALUE, RTFKeyword::CTINT, 0 },
    { "ctrl", RTFControlType::FLAG, RTFKeyword::CTRL, 0 },
    { "cts", RTFControlType::VALUE, RTFKeyword::CTS, 0 },
    { "cufi", RTFControlType::VALUE, RTFKeyword::CUFI, 0 },
    { "culi", RTFControlType::VALUE, RTFKeyword::CULI, 0 },
    { "curi", RTFControlType::VALUE, RTFKeyword::CURI, 0 },
    { "cvmme", RTFControlType::FLAG, RTFKeyword::CVMME, 0 },
    { "datafield", RTFControlType::DESTINATION, RTFKeyword::DATAFIELD, 0 },
    { "datastore", RTFControlType::DESTINATION, RTFKeyword::DATASTORE, 0 },
    { "date", RTFControlType::FLAG, RTFKeyword::DATE, 0 },
    { "dbch", RTFControlType::FLAG, RTFKeyword::DBCH, 0 },
    { "defchp", RTFControlType::DESTINATION, RTFKeyword::DEFCHP, 0 },
    { "deff", RTFControlType::VALUE, RTFKeyword::DEFF, 0 },
    { "defformat", RTFControlType::FLAG, RTFKeyword::DEFFORMAT, 0 },
    { "deflang", RTFControlType::VALUE, RTFKeyword::DEFLANG, 0 },
    { "deflangfe", RTFControlType::VALUE, RTFKeyword::DEFLANGFE, 0 },
    { "defpap", RTFControlType::DESTINATION, RTFKeyword::DEFPAP, 0 },
    { "defshp", RTFControlType::FLAG, RTFKeyword::DEFSHP, 0 },
    { "deftab", RTFControlType::VALUE, RTFKeyword::DEFTAB, 720 },
    { "deleted", RTFControlType::TOGGLE, RTFKeyword::DELETED, 1 },
    { "delrsid", RTFControlType::VALUE, RTFKeyword::DELRSID, 0 },
    { "dfrauth", RTFControlType::VALUE, RTFKeyword::DFRAUTH, 0 },
    { "dfrdate", RTFControlType::VALUE, RTFKeyword::DFRDATE, 0 },
    { "dfrmtxtx", RTFControlType::VALUE, RTFKeyword::DFRMTXTX, 0 },
    { "dfrmtxty", RTFControlType::VALUE, RTFKeyword::DFRMTXTY, 0 },
    { "dfrstart", RTFControlType::VALUE, RTFKeyword::DFRSTART, 0 },
    { "dfrstop", RTFControlType::VALUE, RTFKeyword::DFRSTOP, 0 },
    { "dfrxst", RTFControlType::VALUE, RTFKeyword::DFRXST, 0 },
    { "dghorigin", RTFControlType::VALUE, RTFKeyword::DGHORIGIN, 1701 },
    { "dghshow", RTFControlType::VALUE, RTFKeyword::DGHSHOW, 3 },
    { "dghspace", RTFControlType::VALUE, RTFKeyword::DGHSPACE, 120 },
    { "dgmargin", RTFControlType::FLAG, RTFKeyword::DGMARGIN, 0 },
    { "dgsnap", RTFControlType::FLAG, RTFKeyword::DGSNAP, 0 },
    { "dgvorigin", RTFControlType::VALUE, RTFKeyword::DGVORIGIN, 1984 },
    { "dgvshow", RTFControlType::VALUE, RTFKeyword::DGVSHOW, 0 },
    { "dgvspace", RTFControlType::VALUE, RTFKeyword::DGVSPACE, 120 },
    { "dibitmap", RTFControlType::VALUE, RTFKeyword::DIBITMAP, 0 },
    { "disabled", RTFControlType::TOGGLE, RTFKeyword::DISABLED, 1 },
    { "dn", RTFControlType::VALUE, RTFKeyword::DN, 6 },
    { "dntblnsbdb", RTFControlType::FLAG, RTFKeyword::DNTBLNSBDB, 0 },
    { "do", RTFControlType::DESTINATION, RTFKeyword::DO, 0 },
    { "dobxcolumn", RTFControlType::FLAG, RTFKeyword::DOBXCOLUMN, 0 },
    { "dobxmargin", RTFControlType::FLAG, RTFKeyword::DOBXMARGIN, 0 },
    { "dobxpage", RTFControlType::FLAG, RTFKeyword::DOBXPAGE, 0 },
    { "dobymargin", RTFControlType::FLAG, RTFKeyword::DOBYMARGIN, 0 },
    { "dobypage", RTFControlType::FLAG, RTFKeyword::DOBYPAGE, 0 },
    { "dobypara", RTFControlType::FLAG, RTFKeyword::DOBYPARA, 0 },
    { "doccomm", RTFControlType::DESTINATION, RTFKeyword::DOCCOMM, 0 },
    { "doctemp", RTFControlType::FLAG, RTFKeyword::DOCTEMP, 0 },
    { "doctype", RTFControlType::VALUE, RTFKeyword::DOCTYPE, 0 },
    { "docvar", RTFControlType::DESTINATION, RTFKeyword::DOCVAR, 0 },
    { "dodhgt", RTFControlType::VALUE, RTFKeyword::DODHGT, 0 },
    { "dolock", RTFControlType::FLAG, RTFKeyword::DOLOCK, 0 },
    { "donotembedlingdata", RTFControlType::VALUE, RTFKeyword::DONOTEMBEDLINGDATA, 0 },
    { "donotembedsysfont", RTFControlType::VALUE, RTFKeyword::DONOTEMBEDSYSFONT, 0 },
    { "donotshowcomments", RTFControlType::FLAG, RTFKeyword::DONOTSHOWCOMMENTS, 0 },
    { "donotshowinsdel", RTFControlType::FLAG, RTFKeyword::DONOTSHOWINSDEL, 0 },
    { "donotshowmarkup", RTFControlType::FLAG, RTFKeyword::DONOTSHOWMARKUP, 0 },
    { "donotshowprops", RTFControlType::FLAG, RTFKeyword::DONOTSHOWPROPS, 0 },
    { "dpaendhol", RTFControlType::FLAG, RTFKeyword::DPAENDHOL, 0 },
    { "dpaendl", RTFControlType::VALUE, RTFKeyword::DPAENDL, 0 },
    { "dpaendsol", RTFControlType::FLAG, RTFKeyword::DPAENDSOL, 0 },
    { "dpaendw", RTFControlType::VALUE, RTFKeyword::DPAENDW, 0 },
    { "dparc", RTFControlType::FLAG, RTFKeyword::DPARC, 0 },
    { "dparcflipx", RTFControlType::FLAG, RTFKeyword::DPARCFLIPX, 0 },
    { "dparcflipy", RTFControlType::FLAG, RTFKeyword::DPARCFLIPY, 0 },
    { "dpastarthol", RTFControlType::FLAG, RTFKeyword::DPASTARTHOL, 0 },
    { "dpastartl", RTFControlType::VALUE, RTFKeyword::DPASTARTL, 0 },
    { "dpastartsol", RTFControlType::FLAG, RTFKeyword::DPASTARTSOL, 0 },
    { "dpastartw", RTFControlType::VALUE, RTFKeyword::DPASTARTW, 0 },
    { "dpcallout", RTFControlType::FLAG, RTFKeyword::DPCALLOUT, 0 },
    { "dpcoa", RTFControlType::VALUE, RTFKeyword::DPCOA, 0 },
    { "dpcoaccent", RTFControlType::FLAG, RTFKeyword::DPCOACCENT, 0 },
    { "dpcobestfit", RTFControlType::FLAG, RTFKeyword::DPCOBESTFIT, 0 },
    { "dpcoborder", RTFControlType::FLAG, RTFKeyword::DPCOBORDER, 0 },
    { "dpcodabs", RTFControlType::FLAG, RTFKeyword::DPCODABS, 0 },
    { "dpcodbottom", RTFControlType::FLAG, RTFKeyword::DPCODBOTTOM, 0 },
    { "dpcodcenter", RTFControlType::FLAG, RTFKeyword::DPCODCENTER, 0 },
    { "dpcodescent", RTFControlType::VALUE, RTFKeyword::DPCODESCENT, 0 },
    { "dpcodtop", RTFControlType::FLAG, RTFKeyword::DPCODTOP, 0 },
    { "dpcolength", RTFControlType::VALUE, RTFKeyword::DPCOLENGTH, 0 },
    { "dpcominusx", RTFControlType::FLAG, RTFKeyword::DPCOMINUSX, 0 },
    { "dpcominusy", RTFControlType::FLAG, RTFKeyword::DPCOMINUSY, 0 },
    { "dpcooffset", RTFControlType::VALUE, RTFKeyword::DPCOOFFSET, 0 },
    { "dpcosmarta", RTFControlType::FLAG, RTFKeyword::DPCOSMARTA, 0 },
    { "dpcotdouble", RTFControlType::FLAG, RTFKeyword::DPCOTDOUBLE, 0 },
    { "dpcotright", RTFControlType::FLAG, RTFKeyword::DPCOTRIGHT, 0 },
    { "dpcotsingle", RTFControlType::FLAG, RTFKeyword::DPCOTSINGLE, 0 },
    { "dpcottriple", RTFControlType::FLAG, RTFKeyword::DPCOTTRIPLE, 0 },
    { "dpcount", RTFControlType::VALUE, RTFKeyword::DPCOUNT, 0 },
    { "dpellipse", RTFControlType::FLAG, RTFKeyword::DPELLIPSE, 0 },
    { "dpendgroup", RTFControlType::FLAG, RTFKeyword::DPENDGROUP, 0 },
    { "dpfillbgcb", RTFControlType::VALUE, RTFKeyword::DPFILLBGCB, 0 },
    { "dpfillbgcg", RTFControlType::VALUE, RTFKeyword::DPFILLBGCG, 0 },
    { "dpfillbgcr", RTFControlType::VALUE, RTFKeyword::DPFILLBGCR, 0 },
    { "dpfillbggray", RTFControlType::VALUE, RTFKeyword::DPFILLBGGRAY, 0 },
    { "dpfillbgpal", RTFControlType::FLAG, RTFKeyword::DPFILLBGPAL, 0 },
    { "dpfillfgcb", RTFControlType::VALUE, RTFKeyword::DPFILLFGCB, 0 },
    { "dpfillfgcg", RTFControlType::VALUE, RTFKeyword::DPFILLFGCG, 0 },
    { "dpfillfgcr", RTFControlType::VALUE, RTFKeyword::DPFILLFGCR, 0 },
    { "dpfillfggray", RTFControlType::VALUE, RTFKeyword::DPFILLFGGRAY, 0 },
    { "dpfillfgpal", RTFControlType::FLAG, RTFKeyword::DPFILLFGPAL, 0 },
    { "dpfillpat", RTFControlType::VALUE, RTFKeyword::DPFILLPAT, 0 },
    { "dpgroup", RTFControlType::FLAG, RTFKeyword::DPGROUP, 0 },
    { "dpline", RTFControlType::FLAG, RTFKeyword::DPLINE, 0 },
    { "dplinecob", RTFControlType::VALUE, RTFKeyword::DPLINECOB, 0 },
    { "dplinecog", RTFControlType::VALUE, RTFKeyword::DPLINECOG, 0 },
    { "dplinecor", RTFControlType::VALUE, RTFKeyword::DPLINECOR, 0 },
    { "dplinedado", RTFControlType::FLAG, RTFKeyword::DPLINEDADO, 0 },
    { "dplinedadodo", RTFControlType::FLAG, RTFKeyword::DPLINEDADODO, 0 },
    { "dplinedash", RTFControlType::FLAG, RTFKeyword::DPLINEDASH, 0 },
    { "dplinedot", RTFControlType::FLAG, RTFKeyword::DPLINEDOT, 0 },
    { "dplinegray", RTFControlType::VALUE, RTFKeyword::DPLINEGRAY, 0 },
    { "dplinehollow", RTFControlType::FLAG, RTFKeyword::DPLINEHOLLOW, 0 },
    { "dplinepal", RTFControlType::FLAG, RTFKeyword::DPLINEPAL, 0 },
    { "dplinesolid", RTFControlType::FLAG, RTFKeyword::DPLINESOLID, 0 },
    { "dplinew", RTFControlType::VALUE, RTFKeyword::DPLINEW, 0 },
    { "dppolycount", RTFControlType::VALUE, RTFKeyword::DPPOLYCOUNT, 0 },
    { "dppolygon", RTFControlType::FLAG, RTFKeyword::DPPOLYGON, 0 },
    { "dppolyline", RTFControlType::FLAG, RTFKeyword::DPPOLYLINE, 0 },
    { "dpptx", RTFControlType::VALUE, RTFKeyword::DPPTX, 0 },
    { "dppty", RTFControlType::VALUE, RTFKeyword::DPPTY, 0 },
    { "dprect", RTFControlType::FLAG, RTFKeyword::DPRECT, 0 },
    { "dproundr", RTFControlType::FLAG, RTFKeyword::DPROUNDR, 0 },
    { "dpshadow", RTFControlType::FLAG, RTFKeyword::DPSHADOW, 0 },
    { "dpshadx", RTFControlType::VALUE, RTFKeyword::DPSHADX, 0 },
    { "dpshady", RTFControlType::VALUE, RTFKeyword::DPSHADY, 0 },
    { "dptxbtlr", RTFControlType::FLAG, RTFKeyword::DPTXBTLR, 0 },
    { "dptxbx", RTFControlType::FLAG, RTFKeyword::DPTXBX, 0 },
    { "dptxbxmar", RTFControlType::VALUE, RTFKeyword::DPTXBXMAR, 0 },
    { "dptxbxtext", RTFControlType::DESTINATION, RTFKeyword::DPTXBXTEXT, 0 },
    { "dptxlrtb", RTFControlType::FLAG, RTFKeyword::DPTXLRTB, 0 },
    { "dptxlrtbv", RTFControlType::FLAG, RTFKeyword::DPTXLRTBV, 0 },
    { "dptxtbrl", RTFControlType::FLAG, RTFKeyword::DPTXTBRL, 0 },
    { "dptxtbrlv", RTFControlType::FLAG, RTFKeyword::DPTXTBRLV, 0 },
    { "dpx", RTFControlType::VALUE, RTFKeyword::DPX, 0 },
    { "dpxsize", RTFControlType::VALUE, RTFKeyword::DPXSIZE, 0 },
    { "dpy", RTFControlType::VALUE, RTFKeyword::DPY, 0 },
    { "dpysize", RTFControlType::VALUE, RTFKeyword::DPYSIZE, 0 },
    { "dropcapli", RTFControlType::VALUE, RTFKeyword::DROPCAPLI, 0 },
    { "dropcapt", RTFControlType::VALUE, RTFKeyword::DROPCAPT, 0 },
    { "ds", RTFControlType::VALUE, RTFKeyword::DS, 0 },
    { "dxfrtext", RTFControlType::VALUE, RTFKeyword::DXFRTEXT, 0 },
    { "dy", RTFControlType::VALUE, RTFKeyword::DY, 0 },
    { "ebcend", RTFControlType::DESTINATION, RTFKeyword::EBCEND, 0 },
    { "ebcstart", RTFControlType::DESTINATION, RTFKeyword::EBCSTART, 0 },
    { "edmins", RTFControlType::VALUE, RTFKeyword::EDMINS, 0 },
    { "embo", RTFControlType::TOGGLE, RTFKeyword::EMBO, 1 },
    { "emdash", RTFControlType::SYMBOL, RTFKeyword::EMDASH, 0 },
    { "emfblip", RTFControlType::FLAG, RTFKeyword::EMFBLIP, 0 },
    { "emspace", RTFControlType::SYMBOL, RTFKeyword::EMSPACE, 0 },
    { "endash", RTFControlType::SYMBOL, RTFKeyword::ENDASH, 0 },
    { "enddoc", RTFControlType::FLAG, RTFKeyword::ENDDOC, 0 },
    { "endnhere", RTFControlType::FLAG, RTFKeyword::ENDNHERE, 0 },
    { "endnotes", RTFControlType::FLAG, RTFKeyword::ENDNOTES, 0 },
    { "enforceprot", RTFControlType::VALUE, RTFKeyword::ENFORCEPROT, 0 },
    { "enspace", RTFControlType::SYMBOL, RTFKeyword::ENSPACE, 0 },
    { "expnd", RTFControlType::VALUE, RTFKeyword::EXPND, 0 },
    { "expndtw", RTFControlType::VALUE, RTFKeyword::EXPNDTW, 0 },
    { "expshrtn", RTFControlType::FLAG, RTFKeyword::EXPSHRTN, 0 },
    { "f", RTFControlType::VALUE, RTFKeyword::F, 0 },
    { "faauto", RTFControlType::FLAG, RTFKeyword::FAAUTO, 0 },
    { "facenter", RTFControlType::FLAG, RTFKeyword::FACENTER, 0 },
    { "facingp", RTFControlType::TOGGLE, RTFKeyword::FACINGP, 1 },
    { "factoidname", RTFControlType::DESTINATION, RTFKeyword::FACTOIDNAME, 0 },
    { "fafixed", RTFControlType::FLAG, RTFKeyword::FAFIXED, 0 },
    { "fahang", RTFControlType::FLAG, RTFKeyword::FAHANG, 0 },
    { "falt", RTFControlType::DESTINATION, RTFKeyword::FALT, 0 },
    { "faroman", RTFControlType::FLAG, RTFKeyword::FAROMAN, 0 },
    { "favar", RTFControlType::FLAG, RTFKeyword::FAVAR, 0 },
    { "fbias", RTFControlType::VALUE, RTFKeyword::FBIAS, 0 },
    { "fbidi", RTFControlType::FLAG, RTFKeyword::FBIDI, 0 },
    { "fbidis", RTFControlType::FLAG, RTFKeyword::FBIDIS, 0 },
    { "fbimajor", RTFControlType::FLAG, RTFKeyword::FBIMAJOR, 0 },
    { "fbiminor", RTFControlType::FLAG, RTFKeyword::FBIMINOR, 0 },
    { "fchars", RTFControlType::DESTINATION, RTFKeyword::FCHARS, 0 },
    { "fcharset", RTFControlType::VALUE, RTFKeyword::FCHARSET, 0 },
    { "fcs", RTFControlType::VALUE, RTFKeyword::FCS, 0 },
    { "fdbmajor", RTFControlType::FLAG, RTFKeyword::FDBMAJOR, 0 },
    { "fdbminor", RTFControlType::FLAG, RTFKeyword::FDBMINOR, 0 },
    { "fdecor", RTFControlType::FLAG, RTFKeyword::FDECOR, 0 },
    { "felnbrelev", RTFControlType::FLAG, RTFKeyword::FELNBRELEV, 0 },
    { "fet", RTFControlType::VALUE, RTFKeyword::FET, 0 },
    { "fetch", RTFControlType::FLAG, RTFKeyword::FETCH, 0 },
    { "ffdefres", RTFControlType::VALUE, RTFKeyword::FFDEFRES, 0 },
    { "ffdeftext", RTFControlType::DESTINATION, RTFKeyword::FFDEFTEXT, 0 },
    { "ffentrymcr", RTFControlType::DESTINATION, RTFKeyword::FFENTRYMCR, 0 },
    { "ffexitmcr", RTFControlType::DESTINATION, RTFKeyword::FFEXITMCR, 0 },
    { "ffformat", RTFControlType::DESTINATION, RTFKeyword::FFFORMAT, 0 },
    { "ffhaslistbox", RTFControlType::VALUE, RTFKeyword::FFHASLISTBOX, 0 },
    { "ffhelptext", RTFControlType::DESTINATION, RTFKeyword::FFHELPTEXT, 0 },
    { "ffhps", RTFControlType::VALUE, RTFKeyword::FFHPS, 0 },
    { "ffl", RTFControlType::DESTINATION, RTFKeyword::FFL, 0 },
    { "ffmaxlen", RTFControlType::VALUE, RTFKeyword::FFMAXLEN, 0 },
    { "ffname", RTFControlType::DESTINATION, RTFKeyword::FFNAME, 0 },
    { "ffownhelp", RTFControlType::VALUE, RTFKeyword::FFOWNHELP, 0 },
    { "ffownstat", RTFControlType::VALUE, RTFKeyword::FFOWNSTAT, 0 },
    { "ffprot", RTFControlType::VALUE, RTFKeyword::FFPROT, 0 },
    { "ffrecalc", RTFControlType::VALUE, RTFKeyword::FFRECALC, 0 },
    { "ffres", RTFControlType::VALUE, RTFKeyword::FFRES, 0 },
    { "ffsize", RTFControlType::VALUE, RTFKeyword::FFSIZE, 0 },
    { "ffstattext", RTFControlType::DESTINATION, RTFKeyword::FFSTATTEXT, 0 },
    { "fftype", RTFControlType::VALUE, RTFKeyword::FFTYPE, 0 },
    { "fftypetxt", RTFControlType::VALUE, RTFKeyword::FFTYPETXT, 0 },
    { "fhimajor", RTFControlType::FLAG, RTFKeyword::FHIMAJOR, 0 },
    { "fhiminor", RTFControlType::FLAG, RTFKeyword::FHIMINOR, 0 },
    { "fi", RTFControlType::VALUE, RTFKeyword::FI, 0 },
    { "fid", RTFControlType::VALUE, RTFKeyword::FID, 0 },
    { "field", RTFControlType::DESTINATION, RTFKeyword::FIELD, 0 },
    { "file", RTFControlType::DESTINATION, RTFKeyword::FILE, 0 },
    { "filetbl", RTFControlType::DESTINATION, RTFKeyword::FILETBL, 0 },
    { "fittext", RTFControlType::VALUE, RTFKeyword::FITTEXT, 0 },
    { "fjgothic", RTFControlType::FLAG, RTFKeyword::FJGOTHIC, 0 },
    { "fjminchou", RTFControlType::FLAG, RTFKeyword::FJMINCHOU, 0 },
    { "fldalt", RTFControlType::FLAG, RTFKeyword::FLDALT, 0 },
    { "flddirty", RTFControlType::FLAG, RTFKeyword::FLDDIRTY, 0 },
    { "fldedit", RTFControlType::FLAG, RTFKeyword::FLDEDIT, 0 },
    { "fldinst", RTFControlType::DESTINATION, RTFKeyword::FLDINST, 0 },
    { "fldlock", RTFControlType::FLAG, RTFKeyword::FLDLOCK, 0 },
    { "fldpriv", RTFControlType::FLAG, RTFKeyword::FLDPRIV, 0 },
    { "fldrslt", RTFControlType::DESTINATION, RTFKeyword::FLDRSLT, 0 },
    { "fldtype", RTFControlType::DESTINATION, RTFKeyword::FLDTYPE, 0 },
    { "flomajor", RTFControlType::FLAG, RTFKeyword::FLOMAJOR, 0 },
    { "flominor", RTFControlType::FLAG, RTFKeyword::FLOMINOR, 0 },
    { "fmodern", RTFControlType::FLAG, RTFKeyword::FMODERN, 0 },
    { "fn", RTFControlType::VALUE, RTFKeyword::FN, 0 },
    { "fname", RTFControlType::DESTINATION, RTFKeyword::FNAME, 0 },
    { "fnetwork", RTFControlType::FLAG, RTFKeyword::FNETWORK, 0 },
    { "fnil", RTFControlType::FLAG, RTFKeyword::FNIL, 0 },
    { "fnonfilesys", RTFControlType::FLAG, RTFKeyword::FNONFILESYS, 0 },
    { "fontemb", RTFControlType::DESTINATION, RTFKeyword::FONTEMB, 0 },
    { "fontfile", RTFControlType::DESTINATION, RTFKeyword::FONTFILE, 0 },
    { "fonttbl", RTFControlType::DESTINATION, RTFKeyword::FONTTBL, 0 },
    { "footer", RTFControlType::DESTINATION, RTFKeyword::FOOTER, 0 },
    { "footerf", RTFControlType::DESTINATION, RTFKeyword::FOOTERF, 0 },
    { "footerl", RTFControlType::DESTINATION, RTFKeyword::FOOTERL, 0 },
    { "footerr", RTFControlType::DESTINATION, RTFKeyword::FOOTERR, 0 },
    { "footery", RTFControlType::VALUE, RTFKeyword::FOOTERY, 720 },
    { "footnote", RTFControlType::DESTINATION, RTFKeyword::FOOTNOTE, 0 },
    { "forceupgrade", RTFControlType::FLAG, RTFKeyword::FORCEUPGRADE, 0 },
    { "formdisp", RTFControlType::FLAG, RTFKeyword::FORMDISP, 0 },
    { "formfield", RTFControlType::DESTINATION, RTFKeyword::FORMFIELD, 0 },
    { "formprot", RTFControlType::FLAG, RTFKeyword::FORMPROT, 0 },
    { "formshade", RTFControlType::FLAG, RTFKeyword::FORMSHADE, 0 },
    { "fosnum", RTFControlType::VALUE, RTFKeyword::FOSNUM, 0 },
    { "fprq", RTFControlType::VALUE, RTFKeyword::FPRQ, 0 },
    { "fracwidth", RTFControlType::FLAG, RTFKeyword::FRACWIDTH, 0 },
    { "frelative", RTFControlType::VALUE, RTFKeyword::FRELATIVE, 0 },
    { "frmtxbtlr", RTFControlType::FLAG, RTFKeyword::FRMTXBTLR, 0 },
    { "frmtxlrtb", RTFControlType::FLAG, RTFKeyword::FRMTXLRTB, 0 },
    { "frmtxlrtbv", RTFControlType::FLAG, RTFKeyword::FRMTXLRTBV, 0 },
    { "frmtxtbrl", RTFControlType::FLAG, RTFKeyword::FRMTXTBRL, 0 },
    { "frmtxtbrlv", RTFControlType::FLAG, RTFKeyword::FRMTXTBRLV, 0 },
    { "froman", RTFControlType::FLAG, RTFKeyword::FROMAN, 0 },
    { "fromhtml", RTFControlType::VALUE, RTFKeyword::FROMHTML, 0 },
    { "fromtext", RTFControlType::FLAG, RTFKeyword::FROMTEXT, 0 },
    { "fs", RTFControlType::VALUE, RTFKeyword::FS, 24 },
    { "fscript", RTFControlType::FLAG, RTFKeyword::FSCRIPT, 0 },
    { "fswiss", RTFControlType::FLAG, RTFKeyword::FSWISS, 0 },
    { "ftech", RTFControlType::FLAG, RTFKeyword::FTECH, 0 },
    { "ftnalt", RTFControlType::FLAG, RTFKeyword::FTNALT, 0 },
    { "ftnbj", RTFControlType::FLAG, RTFKeyword::FTNBJ, 0 },
    { "ftncn", RTFControlType::DESTINATION, RTFKeyword::FTNCN, 0 },
    { "ftnil", RTFControlType::FLAG, RTFKeyword::FTNIL, 0 },
    { "ftnlytwnine", RTFControlType::FLAG, RTFKeyword::FTNLYTWNINE, 0 },
    { "ftnnalc", RTFControlType::FLAG, RTFKeyword::FTNNALC, 0 },
    { "ftnnar", RTFControlType::FLAG, RTFKeyword::FTNNAR, 0 },
    { "ftnnauc", RTFControlType::FLAG, RTFKeyword::FTNNAUC, 0 },
    { "ftnnchi", RTFControlType::FLAG, RTFKeyword::FTNNCHI, 0 },
    { "ftnnchosung", RTFControlType::FLAG, RTFKeyword::FTNNCHOSUNG, 0 },
    { "ftnncnum", RTFControlType::FLAG, RTFKeyword::FTNNCNUM, 0 },
    { "ftnndbar", RTFControlType::FLAG, RTFKeyword::FTNNDBAR, 0 },
    { "ftnndbnum", RTFControlType::FLAG, RTFKeyword::FTNNDBNUM, 0 },
    { "ftnndbnumd", RTFControlType::FLAG, RTFKeyword::FTNNDBNUMD, 0 },
    { "ftnndbnumk", RTFControlType::FLAG, RTFKeyword::FTNNDBNUMK, 0 },
    { "ftnndbnumt", RTFControlType::FLAG, RTFKeyword::FTNNDBNUMT, 0 },
    { "ftnnganada", RTFControlType::FLAG, RTFKeyword::FTNNGANADA, 0 },
    { "ftnngbnum", RTFControlType::FLAG, RTFKeyword::FTNNGBNUM, 0 },
    { "ftnngbnumd", RTFControlType::FLAG, RTFKeyword::FTNNGBNUMD, 0 },
    { "ftnngbnumk", RTFControlType::FLAG, RTFKeyword::FTNNGBNUMK, 0 },
    { "ftnngbnuml", RTFControlType::FLAG, RTFKeyword::FTNNGBNUML, 0 },
    { "ftnnrlc", RTFControlType::FLAG, RTFKeyword::FTNNRLC, 0 },
    { "ftnnruc", RTFControlType::FLAG, RTFKeyword::FTNNRUC, 0 },
    { "ftnnzodiac", RTFControlType::FLAG, RTFKeyword::FTNNZODIAC, 0 },
    { "ftnnzodiacd", RTFControlType::FLAG, RTFKeyword::FTNNZODIACD, 0 },
    { "ftnnzodiacl", RTFControlType::FLAG, RTFKeyword::FTNNZODIACL, 0 },
    { "ftnrestart", RTFControlType::FLAG, RTFKeyword::FTNRESTART, 0 },
    { "ftnrstcont", RTFControlType::FLAG, RTFKeyword::FTNRSTCONT, 0 },
    { "ftnrstpg", RTFControlType::FLAG, RTFKeyword::FTNRSTPG, 0 },
    { "ftnsep", RTFControlType::DESTINATION, RTFKeyword::FTNSEP, 0 },
    { "ftnsepc", RTFControlType::DESTINATION, RTFKeyword::FTNSEPC, 0 },
    { "ftnstart", RTFControlType::VALUE, RTFKeyword::FTNSTART, 1 },
    { "ftntj", RTFControlType::FLAG, RTFKeyword::FTNTJ, 0 },
    { "fttruetype", RTFControlType::FLAG, RTFKeyword::FTTRUETYPE, 0 },
    { "fvaliddos", RTFControlType::FLAG, RTFKeyword::FVALIDDOS, 0 },
    { "fvalidhpfs", RTFControlType::FLAG, RTFKeyword::FVALIDHPFS, 0 },
    { "fvalidmac", RTFControlType::FLAG, RTFKeyword::FVALIDMAC, 0 },
    { "fvalidntfs", RTFControlType::FLAG, RTFKeyword::FVALIDNTFS, 0 },
    { "g", RTFControlType::DESTINATION, RTFKeyword::G, 0 },
    { "gcw", RTFControlType::VALUE, RTFKeyword::GCW, 0 },
    { "generator", RTFControlType::DESTINATION, RTFKeyword::GENERATOR, 0 },
    { "green", RTFControlType::VALUE, RTFKeyword::GREEN, 0 },
    { "grfdocevents", RTFControlType::VALUE, RTFKeyword::GRFDOCEVENTS, 0 },
    { "gridtbl", RTFControlType::DESTINATION, RTFKeyword::GRIDTBL, 0 },
    { "gutter", RTFControlType::VALUE, RTFKeyword::GUTTER, 0 },
    { "gutterprl", RTFControlType::FLAG, RTFKeyword::GUTTERPRL, 0 },
    { "guttersxn", RTFControlType::VALUE, RTFKeyword::GUTTERSXN, 0 },
    { "header", RTFControlType::DESTINATION, RTFKeyword::HEADER, 0 },
    { "headerf", RTFControlType::DESTINATION, RTFKeyword::HEADERF, 0 },
    { "headerl", RTFControlType::DESTINATION, RTFKeyword::HEADERL, 0 },
    { "headerr", RTFControlType::DESTINATION, RTFKeyword::HEADERR, 0 },
    { "headery", RTFControlType::VALUE, RTFKeyword::HEADERY, 720 },
    { "hich", RTFControlType::FLAG, RTFKeyword::HICH, 0 },
    { "highlight", RTFControlType::VALUE, RTFKeyword::HIGHLIGHT, 0 },
    { "hl", RTFControlType::DESTINATION, RTFKeyword::HL, 0 },
    { "hlfr", RTFControlType::DESTINATION, RTFKeyword::HLFR, 0 },
    { "hlinkbase", RTFControlType::DESTINATION, RTFKeyword::HLINKBASE, 0 },
    { "hlloc", RTFControlType::DESTINATION, RTFKeyword::HLLOC, 0 },
    { "hlsrc", RTFControlType::DESTINATION, RTFKeyword::HLSRC, 0 },
    { "horzdoc", RTFControlType::FLAG, RTFKeyword::HORZDOC, 0 },
    { "horzsect", RTFControlType::FLAG, RTFKeyword::HORZSECT, 0 },
    { "horzvert", RTFControlType::VALUE, RTFKeyword::HORZVERT, 0 },
    { "hr", RTFControlType::VALUE, RTFKeyword::HR, 0 },
    { "hres", RTFControlType::VALUE, RTFKeyword::HRES, 0 },
    { "hrule", RTFControlType::FLAG, RTFKeyword::HRULE, 0 },
    { "hsv", RTFControlType::DESTINATION, RTFKeyword::HSV, 0 },
    { "htmautsp", RTFControlType::FLAG, RTFKeyword::HTMAUTSP, 0 },
    { "htmlbase", RTFControlType::FLAG, RTFKeyword::HTMLBASE, 0 },
    { "htmlrtf", RTFControlType::TOGGLE, RTFKeyword::HTMLRTF, 1 },
    { "htmltag", RTFControlType::DESTINATION, RTFKeyword::HTMLTAG, 0 },
    { "hwelev", RTFControlType::FLAG, RTFKeyword::HWELEV, 0 },
    { "hyphauto", RTFControlType::TOGGLE, RTFKeyword::HYPHAUTO, 1 },
    { "hyphcaps", RTFControlType::TOGGLE, RTFKeyword::HYPHCAPS, 1 },
    { "hyphconsec", RTFControlType::VALUE, RTFKeyword::HYPHCONSEC, 0 },
    { "hyphhotz", RTFControlType::VALUE, RTFKeyword::HYPHHOTZ, 0 },
    { "hyphpar", RTFControlType::TOGGLE, RTFKeyword::HYPHPAR, 1 },
    { "i", RTFControlType::TOGGLE, RTFKeyword::I, 1 },
    { "id", RTFControlType::VALUE, RTFKeyword::ID, 0 },
    { "ignoremixedcontent", RTFControlType::VALUE, RTFKeyword::IGNOREMIXEDCONTENT, 0 },
    { "ilfomacatclnup", RTFControlType::VALUE, RTFKeyword::ILFOMACATCLNUP, 0 },
    { "ilvl", RTFControlType::VALUE, RTFKeyword::ILVL, 0 },
    { "impr", RTFControlType::TOGGLE, RTFKeyword::IMPR, 1 },
    { "indmirror", RTFControlType::FLAG, RTFKeyword::INDMIRROR, 0 },
    { "indrlsweleven", RTFControlType::FLAG, RTFKeyword::INDRLSWELEVEN, 0 },
    { "info", RTFControlType::DESTINATION, RTFKeyword::INFO, 0 },
    { "insrsid", RTFControlType::VALUE, RTFKeyword::INSRSID, 0 },
    { "intbl", RTFControlType::FLAG, RTFKeyword::INTBL, 0 },
    { "ipgp", RTFControlType::VALUE, RTFKeyword::IPGP, 0 },
    { "irowband", RTFControlType::VALUE, RTFKeyword::IROWBAND, 0 },
    { "irow", RTFControlType::VALUE, RTFKeyword::IROW, 0 },
    { "itap", RTFControlType::VALUE, RTFKeyword::ITAP, 1 },
    { "ixe", RTFControlType::FLAG, RTFKeyword::IXE, 0 },
    { "jcompress", RTFControlType::FLAG, RTFKeyword::JCOMPRESS, 0 },
    { "jexpand", RTFControlType::FLAG, RTFKeyword::JEXPAND, 0 },
    { "jis", RTFControlType::FLAG, RTFKeyword::JIS, 0 },
    { "jpegblip", RTFControlType::FLAG, RTFKeyword::JPEGBLIP, 0 },
    { "jsksu", RTFControlType::FLAG, RTFKeyword::JSKSU, 0 },
    { "keep", RTFControlType::FLAG, RTFKeyword::KEEP, 0 },
    { "keepn", RTFControlType::FLAG, RTFKeyword::KEEPN, 0 },
    { "kerning", RTFControlType::VALUE, RTFKeyword::KERNING, 0 },
    { "keycode", RTFControlType::DESTINATION, RTFKeyword::KEYCODE, 0 },
    { "keywords", RTFControlType::DESTINATION, RTFKeyword::KEYWORDS, 0 },
    { "krnprsnet", RTFControlType::FLAG, RTFKeyword::KRNPRSNET, 0 },
    { "ksulang", RTFControlType::VALUE, RTFKeyword::KSULANG, 0 },
    { "jclisttab", RTFControlType::FLAG, RTFKeyword::JCLISTTAB, 0 },
    { "landscape", RTFControlType::FLAG, RTFKeyword::LANDSCAPE, 0 },
    { "lang", RTFControlType::VALUE, RTFKeyword::LANG, 0 },
    { "langfe", RTFControlType::VALUE, RTFKeyword::LANGFE, 0 },
    { "langfenp", RTFControlType::VALUE, RTFKeyword::LANGFENP, 0 },
    { "langnp", RTFControlType::VALUE, RTFKeyword::LANGNP, 0 },
    { "lastrow", RTFControlType::FLAG, RTFKeyword::LASTROW, 0 },
    { "latentstyles", RTFControlType::DESTINATION, RTFKeyword::LATENTSTYLES, 0 },
    { "lbr", RTFControlType::VALUE, RTFKeyword::LBR, 0 },
    { "lchars", RTFControlType::DESTINATION, RTFKeyword::LCHARS, 0 },
    { "ldblquote", RTFControlType::SYMBOL, RTFKeyword::LDBLQUOTE, 0 },
    { "level", RTFControlType::VALUE, RTFKeyword::LEVEL, 0 },
    { "levelfollow", RTFControlType::VALUE, RTFKeyword::LEVELFOLLOW, 0 },
    { "levelindent", RTFControlType::VALUE, RTFKeyword::LEVELINDENT, 0 },
    { "leveljc", RTFControlType::VALUE, RTFKeyword::LEVELJC, 0 },
    { "leveljcn", RTFControlType::VALUE, RTFKeyword::LEVELJCN, 0 },
    { "levellegal", RTFControlType::VALUE, RTFKeyword::LEVELLEGAL, 0 },
    { "levelnfc", RTFControlType::VALUE, RTFKeyword::LEVELNFC, 0 },
    { "levelnfcn", RTFControlType::VALUE, RTFKeyword::LEVELNFCN, 0 },
    { "levelnorestart", RTFControlType::VALUE, RTFKeyword::LEVELNORESTART, 0 },
    { "levelnumbers", RTFControlType::DESTINATION, RTFKeyword::LEVELNUMBERS, 0 },
    { "levelold", RTFControlType::VALUE, RTFKeyword::LEVELOLD, 0 },
    { "levelpicture", RTFControlType::VALUE, RTFKeyword::LEVELPICTURE, 0 },
    { "levelpicturenosize", RTFControlType::FLAG, RTFKeyword::LEVELPICTURENOSIZE, 0 },
    { "levelprev", RTFControlType::VALUE, RTFKeyword::LEVELPREV, 0 },
    { "levelprevspace", RTFControlType::VALUE, RTFKeyword::LEVELPREVSPACE, 0 },
    { "levelspace", RTFControlType::VALUE, RTFKeyword::LEVELSPACE, 0 },
    { "levelstartat", RTFControlType::VALUE, RTFKeyword::LEVELSTARTAT, 0 },
    { "leveltemplateid", RTFControlType::VALUE, RTFKeyword::LEVELTEMPLATEID, 0 },
    { "leveltext", RTFControlType::DESTINATION, RTFKeyword::LEVELTEXT, 0 },
    { "lfolevel", RTFControlType::DESTINATION, RTFKeyword::LFOLEVEL, 0 },
    { "li", RTFControlType::VALUE, RTFKeyword::LI, 0 },
    { "line", RTFControlType::SYMBOL, RTFKeyword::LINE, 0 },
    { "linebetcol", RTFControlType::FLAG, RTFKeyword::LINEBETCOL, 0 },
    { "linecont", RTFControlType::FLAG, RTFKeyword::LINECONT, 0 },
    { "linemod", RTFControlType::VALUE, RTFKeyword::LINEMOD, 1 },
    { "lineppage", RTFControlType::FLAG, RTFKeyword::LINEPPAGE, 0 },
    { "linerestart", RTFControlType::FLAG, RTFKeyword::LINERESTART, 0 },
    { "linestart", RTFControlType::VALUE, RTFKeyword::LINESTART, 1 },
    { "linestarts", RTFControlType::VALUE, RTFKeyword::LINESTARTS, 1 },
    { "linex", RTFControlType::VALUE, RTFKeyword::LINEX, 360 },
    { "linkself", RTFControlType::FLAG, RTFKeyword::LINKSELF, 0 },
    { "linkstyles", RTFControlType::FLAG, RTFKeyword::LINKSTYLES, 0 },
    { "linkval", RTFControlType::DESTINATION, RTFKeyword::LINKVAL, 0 },
    { "lin", RTFControlType::VALUE, RTFKeyword::LIN, 0 },
    { "lisa", RTFControlType::VALUE, RTFKeyword::LISA, 0 },
    { "lisb", RTFControlType::VALUE, RTFKeyword::LISB, 0 },
    { "list", RTFControlType::DESTINATION, RTFKeyword::LIST, 0 },
    { "listhybrid", RTFControlType::FLAG, RTFKeyword::LISTHYBRID, 0 },
    { "listid", RTFControlType::VALUE, RTFKeyword::LISTID, 0 },
    { "listlevel", RTFControlType::DESTINATION, RTFKeyword::LISTLEVEL, 0 },
    { "listname", RTFControlType::DESTINATION, RTFKeyword::LISTNAME, 0 },
    { "listoverride", RTFControlType::DESTINATION, RTFKeyword::LISTOVERRIDE, 0 },
    { "listoverridecount", RTFControlType::VALUE, RTFKeyword::LISTOVERRIDECOUNT, 0 },
    { "listoverrideformat", RTFControlType::VALUE, RTFKeyword::LISTOVERRIDEFORMAT, 0 },
    { "listoverridestartat", RTFControlType::FLAG, RTFKeyword::LISTOVERRIDESTARTAT, 0 },
    { "listoverridetable", RTFControlType::DESTINATION, RTFKeyword::LISTOVERRIDETABLE, 0 },
    { "listpicture", RTFControlType::DESTINATION, RTFKeyword::LISTPICTURE, 0 },
    { "listrestarthdn", RTFControlType::VALUE, RTFKeyword::LISTRESTARTHDN, 0 },
    { "listsimple", RTFControlType::VALUE, RTFKeyword::LISTSIMPLE, 0 },
    { "liststyleid", RTFControlType::VALUE, RTFKeyword::LISTSTYLEID, 0 },
    { "liststylename", RTFControlType::DESTINATION, RTFKeyword::LISTSTYLENAME, 0 },
    { "listtable", RTFControlType::DESTINATION, RTFKeyword::LISTTABLE, 0 },
    { "listtemplateid", RTFControlType::VALUE, RTFKeyword::LISTTEMPLATEID, 0 },
    { "listtext", RTFControlType::DESTINATION, RTFKeyword::LISTTEXT, 0 },
    { "lnbrkrule", RTFControlType::FLAG, RTFKeyword::LNBRKRULE, 0 },
    { "lndscpsxn", RTFControlType::FLAG, RTFKeyword::LNDSCPSXN, 0 },
    { "lnongrid", RTFControlType::FLAG, RTFKeyword::LNONGRID, 0 },
    { "loch", RTFControlType::FLAG, RTFKeyword::LOCH, 0 },
    { "lquote", RTFControlType::SYMBOL, RTFKeyword::LQUOTE, 0 },
    { "ls", RTFControlType::VALUE, RTFKeyword::LS, 0 },
    { "lsdlocked", RTFControlType::VALUE, RTFKeyword::LSDLOCKED, 0 },
    { "lsdlockeddef", RTFControlType::VALUE, RTFKeyword::LSDLOCKEDDEF, 0 },
    { "lsdlockedexcept", RTFControlType::DESTINATION, RTFKeyword::LSDLOCKEDEXCEPT, 0 },
    { "lsdpriority", RTFControlType::VALUE, RTFKeyword::LSDPRIORITY, 0 },
    { "lsdprioritydef", RTFControlType::VALUE, RTFKeyword::LSDPRIORITYDEF, 0 },
    { "lsdqformat", RTFControlType::VALUE, RTFKeyword::LSDQFORMAT, 0 },
    { "lsdqformatdef", RTFControlType::VALUE, RTFKeyword::LSDQFORMATDEF, 0 },
    { "lsdsemihidden", RTFControlType::VALUE, RTFKeyword::LSDSEMIHIDDEN, 0 },
    { "lsdsemihiddendef", RTFControlType::VALUE, RTFKeyword::LSDSEMIHIDDENDEF, 0 },
    { "lsdstimax", RTFControlType::VALUE, RTFKeyword::LSDSTIMAX, 0 },
    { "lsdunhideused", RTFControlType::VALUE, RTFKeyword::LSDUNHIDEUSED, 0 },
    { "lsdunhideuseddef", RTFControlType::VALUE, RTFKeyword::LSDUNHIDEUSEDDEF, 0 },
    { "ltrch", RTFControlType::FLAG, RTFKeyword::LTRCH, 0 },
    { "ltrdoc", RTFControlType::FLAG, RTFKeyword::LTRDOC, 0 },
    { "ltrmark", RTFControlType::SYMBOL, RTFKeyword::LTRMARK, 0 },
    { "ltrpar", RTFControlType::FLAG, RTFKeyword::LTRPAR, 0 },
    { "ltrrow", RTFControlType::FLAG, RTFKeyword::LTRROW, 0 },
    { "ltrsect", RTFControlType::FLAG, RTFKeyword::LTRSECT, 0 },
    { "lvltentative", RTFControlType::FLAG, RTFKeyword::LVLTENTATIVE, 0 },
    { "lytcalctblwd", RTFControlType::FLAG, RTFKeyword::LYTCALCTBLWD, 0 },
    { "lytexcttp", RTFControlType::FLAG, RTFKeyword::LYTEXCTTP, 0 },
    { "lytprtmet", RTFControlType::FLAG, RTFKeyword::LYTPRTMET, 0 },
    { "lyttblrtgr", RTFControlType::FLAG, RTFKeyword::LYTTBLRTGR, 0 },
    { "mac", RTFControlType::FLAG, RTFKeyword::MAC, 0 },
    { "macc", RTFControlType::DESTINATION, RTFKeyword::MACC, 0 },
    { "maccPr", RTFControlType::DESTINATION, RTFKeyword::MACCPR, 0 },
    { "macpict", RTFControlType::FLAG, RTFKeyword::MACPICT, 0 },
    { "mailmerge", RTFControlType::DESTINATION, RTFKeyword::MAILMERGE, 0 },
    { "makebackup", RTFControlType::FLAG, RTFKeyword::MAKEBACKUP, 0 },
    { "maln", RTFControlType::DESTINATION, RTFKeyword::MALN, 0 },
    { "malnScr", RTFControlType::DESTINATION, RTFKeyword::MALNSCR, 0 },
    { "manager", RTFControlType::DESTINATION, RTFKeyword::MANAGER, 0 },
    { "margb", RTFControlType::VALUE, RTFKeyword::MARGB, 1440 },
    { "margbsxn", RTFControlType::VALUE, RTFKeyword::MARGBSXN, 0 },
    { "margl", RTFControlType::VALUE, RTFKeyword::MARGL, 1800 },
    { "marglsxn", RTFControlType::VALUE, RTFKeyword::MARGLSXN, 0 },
    { "margmirror", RTFControlType::FLAG, RTFKeyword::MARGMIRROR, 0 },
    { "margmirsxn", RTFControlType::FLAG, RTFKeyword::MARGMIRSXN, 0 },
    { "margPr", RTFControlType::DESTINATION, RTFKeyword::MARGPR, 0 },
    { "margr", RTFControlType::VALUE, RTFKeyword::MARGR, 1800 },
    { "margrsxn", RTFControlType::VALUE, RTFKeyword::MARGRSXN, 0 },
    { "margSz", RTFControlType::VALUE, RTFKeyword::MARGSZ, 0 },
    { "margt", RTFControlType::VALUE, RTFKeyword::MARGT, 1440 },
    { "margtsxn", RTFControlType::VALUE, RTFKeyword::MARGTSXN, 0 },
    { "mbar", RTFControlType::DESTINATION, RTFKeyword::MBAR, 0 },
    { "mbarPr", RTFControlType::DESTINATION, RTFKeyword::MBARPR, 0 },
    { "mbaseJc", RTFControlType::DESTINATION, RTFKeyword::MBASEJC, 0 },
    { "mbegChr", RTFControlType::DESTINATION, RTFKeyword::MBEGCHR, 0 },
    { "mborderBox", RTFControlType::DESTINATION, RTFKeyword::MBORDERBOX, 0 },
    { "mborderBoxPr", RTFControlType::DESTINATION, RTFKeyword::MBORDERBOXPR, 0 },
    { "mbox", RTFControlType::DESTINATION, RTFKeyword::MBOX, 0 },
    { "mboxPr", RTFControlType::DESTINATION, RTFKeyword::MBOXPR, 0 },
    { "mbrk", RTFControlType::VALUE, RTFKeyword::MBRK, 0 },
    { "mbrkBin", RTFControlType::VALUE, RTFKeyword::MBRKBIN, 0 },
    { "mbrkBinSub", RTFControlType::VALUE, RTFKeyword::MBRKBINSUB, 0 },
    { "mcGp", RTFControlType::VALUE, RTFKeyword::MCGP, 0 },
    { "mcGpRule", RTFControlType::VALUE, RTFKeyword::MCGPRULE, 0 },
    { "mchr", RTFControlType::DESTINATION, RTFKeyword::MCHR, 0 },
    { "mcount", RTFControlType::DESTINATION, RTFKeyword::MCOUNT, 0 },
    { "mcSp", RTFControlType::VALUE, RTFKeyword::MCSP, 0 },
    { "mctrlPr", RTFControlType::DESTINATION, RTFKeyword::MCTRLPR, 0 },
    { "md", RTFControlType::DESTINATION, RTFKeyword::MD, 0 },
    { "mdefJc", RTFControlType::VALUE, RTFKeyword::MDEFJC, 0 },
    { "mdeg", RTFControlType::DESTINATION, RTFKeyword::MDEG, 0 },
    { "mdegHide", RTFControlType::DESTINATION, RTFKeyword::MDEGHIDE, 0 },
    { "mden", RTFControlType::DESTINATION, RTFKeyword::MDEN, 0 },
    { "mdiff", RTFControlType::DESTINATION, RTFKeyword::MDIFF, 0 },
    { "mdiffSty", RTFControlType::VALUE, RTFKeyword::MDIFFSTY, 0 },
    { "mdispdef", RTFControlType::VALUE, RTFKeyword::MDISPDEF, 1 },
    { "mdPr", RTFControlType::DESTINATION, RTFKeyword::MDPR, 0 },
    { "me", RTFControlType::DESTINATION, RTFKeyword::ME, 0 },
    { "mendChr", RTFControlType::DESTINATION, RTFKeyword::MENDCHR, 0 },
    { "meqArr", RTFControlType::DESTINATION, RTFKeyword::MEQARR, 0 },
    { "meqArrPr", RTFControlType::DESTINATION, RTFKeyword::MEQARRPR, 0 },
    { "mf", RTFControlType::DESTINATION, RTFKeyword::MF, 0 },
    { "mfName", RTFControlType::DESTINATION, RTFKeyword::MFNAME, 0 },
    { "mfPr", RTFControlType::DESTINATION, RTFKeyword::MFPR, 0 },
    { "mfunc", RTFControlType::DESTINATION, RTFKeyword::MFUNC, 0 },
    { "mfuncPr", RTFControlType::DESTINATION, RTFKeyword::MFUNCPR, 0 },
    { "mgroupChr", RTFControlType::DESTINATION, RTFKeyword::MGROUPCHR, 0 },
    { "mgroupChrPr", RTFControlType::DESTINATION, RTFKeyword::MGROUPCHRPR, 0 },
    { "mgrow", RTFControlType::DESTINATION, RTFKeyword::MGROW, 0 },
    { "mhideBot", RTFControlType::DESTINATION, RTFKeyword::MHIDEBOT, 0 },
    { "mhideLeft", RTFControlType::DESTINATION, RTFKeyword::MHIDELEFT, 0 },
    { "mhideRight", RTFControlType::DESTINATION, RTFKeyword::MHIDERIGHT, 0 },
    { "mhideTop", RTFControlType::DESTINATION, RTFKeyword::MHIDETOP, 0 },
    { "mhtmltag", RTFControlType::DESTINATION, RTFKeyword::MHTMLTAG, 0 },
    { "min", RTFControlType::VALUE, RTFKeyword::MIN, 0 },
    { "minterSp", RTFControlType::VALUE, RTFKeyword::MINTERSP, 0 },
    { "mintLim", RTFControlType::VALUE, RTFKeyword::MINTLIM, 0 },
    { "mintraSp", RTFControlType::VALUE, RTFKeyword::MINTRASP, 0 },
    { "mjc", RTFControlType::VALUE, RTFKeyword::MJC, 0 },
    { "mlim", RTFControlType::DESTINATION, RTFKeyword::MLIM, 0 },
    { "mlimloc", RTFControlType::DESTINATION, RTFKeyword::MLIMLOC, 0 },
    { "mlimLoc", RTFControlType::DESTINATION, RTFKeyword::MLIMLOC, 0 },
    { "mlimlow", RTFControlType::DESTINATION, RTFKeyword::MLIMLOW, 0 },
    { "mlimLow", RTFControlType::DESTINATION, RTFKeyword::MLIMLOW, 0 },
    { "mlimlowPr", RTFControlType::DESTINATION, RTFKeyword::MLIMLOWPR, 0 },
    { "mlimLowPr", RTFControlType::DESTINATION, RTFKeyword::MLIMLOWPR, 0 },
    { "mlimupp", RTFControlType::DESTINATION, RTFKeyword::MLIMUPP, 0 },
    { "mlimUpp", RTFControlType::DESTINATION, RTFKeyword::MLIMUPP, 0 },
    { "mlimuppPr", RTFControlType::DESTINATION, RTFKeyword::MLIMUPPPR, 0 },
    { "mlimUppPr", RTFControlType::DESTINATION, RTFKeyword::MLIMUPPPR, 0 },
    { "mlit", RTFControlType::FLAG, RTFKeyword::MLIT, 0 },
    { "mlMargin", RTFControlType::VALUE, RTFKeyword::MLMARGIN, 0 },
    { "mm", RTFControlType::DESTINATION, RTFKeyword::MM, 0 },
    { "mmaddfieldname", RTFControlType::DESTINATION, RTFKeyword::MMADDFIELDNAME, 0 },
    { "mmath", RTFControlType::DESTINATION, RTFKeyword::MMATH, 0 },
    { "mmathFont", RTFControlType::VALUE, RTFKeyword::MMATHFONT, 0 },
    { "mmathPict", RTFControlType::DESTINATION, RTFKeyword::MMATHPICT, 0 },
    { "mmathPr", RTFControlType::DESTINATION, RTFKeyword::MMATHPR, 0 },
    { "mmattach", RTFControlType::FLAG, RTFKeyword::MMATTACH, 0 },
    { "mmaxdist", RTFControlType::DESTINATION, RTFKeyword::MMAXDIST, 0 },
    { "mmblanklines", RTFControlType::FLAG, RTFKeyword::MMBLANKLINES, 0 },
    { "mmc", RTFControlType::DESTINATION, RTFKeyword::MMC, 0 },
    { "mmcJc", RTFControlType::DESTINATION, RTFKeyword::MMCJC, 0 },
    { "mmconnectstr", RTFControlType::DESTINATION, RTFKeyword::MMCONNECTSTR, 0 },
    { "mmconnectstrdata", RTFControlType::DESTINATION, RTFKeyword::MMCONNECTSTRDATA, 0 },
    { "mmcPr", RTFControlType::DESTINATION, RTFKeyword::MMCPR, 0 },
    { "mmcs", RTFControlType::DESTINATION, RTFKeyword::MMCS, 0 },
    { "mmdatasource", RTFControlType::DESTINATION, RTFKeyword::MMDATASOURCE, 0 },
    { "mmdatatypeaccess", RTFControlType::FLAG, RTFKeyword::MMDATATYPEACCESS, 0 },
    { "mmdatatypeexcel", RTFControlType::FLAG, RTFKeyword::MMDATATYPEEXCEL, 0 },
    { "mmdatatypefile", RTFControlType::FLAG, RTFKeyword::MMDATATYPEFILE, 0 },
    { "mmdatatypeodbc", RTFControlType::FLAG, RTFKeyword::MMDATATYPEODBC, 0 },
    { "mmdatatypeodso", RTFControlType::FLAG, RTFKeyword::MMDATATYPEODSO, 0 },
    { "mmdatatypeqt", RTFControlType::FLAG, RTFKeyword::MMDATATYPEQT, 0 },
    { "mmdefaultsql", RTFControlType::FLAG, RTFKeyword::MMDEFAULTSQL, 0 },
    { "mmdestemail", RTFControlType::FLAG, RTFKeyword::MMDESTEMAIL, 0 },
    { "mmdestfax", RTFControlType::FLAG, RTFKeyword::MMDESTFAX, 0 },
    { "mmdestnewdoc", RTFControlType::FLAG, RTFKeyword::MMDESTNEWDOC, 0 },
    { "mmdestprinter", RTFControlType::FLAG, RTFKeyword::MMDESTPRINTER, 0 },
    { "mmerrors", RTFControlType::VALUE, RTFKeyword::MMERRORS, 0 },
    { "mmfttypeaddress", RTFControlType::FLAG, RTFKeyword::MMFTTYPEADDRESS, 0 },
    { "mmfttypebarcode", RTFControlType::FLAG, RTFKeyword::MMFTTYPEBARCODE, 0 },
    { "mmfttypedbcolumn", RTFControlType::FLAG, RTFKeyword::MMFTTYPEDBCOLUMN, 0 },
    { "mmfttypemapped", RTFControlType::FLAG, RTFKeyword::MMFTTYPEMAPPED, 0 },
    { "mmfttypenull", RTFControlType::FLAG, RTFKeyword::MMFTTYPENULL, 0 },
    { "mmfttypesalutation", RTFControlType::FLAG, RTFKeyword::MMFTTYPESALUTATION, 0 },
    { "mmheadersource", RTFControlType::DESTINATION, RTFKeyword::MMHEADERSOURCE, 0 },
    { "mmjdsotype", RTFControlType::VALUE, RTFKeyword::MMJDSOTYPE, 0 },
    { "mmlinktoquery", RTFControlType::FLAG, RTFKeyword::MMLINKTOQUERY, 0 },
    { "mmmailsubject", RTFControlType::DESTINATION, RTFKeyword::MMMAILSUBJECT, 0 },
    { "mmmaintypecatalog", RTFControlType::FLAG, RTFKeyword::MMMAINTYPECATALOG, 0 },
    { "mmmaintypeemail", RTFControlType::FLAG, RTFKeyword::MMMAINTYPEEMAIL, 0 },
    { "mmmaintypeenvelopes", RTFControlType::FLAG, RTFKeyword::MMMAINTYPEENVELOPES, 0 },
    { "mmmaintypefax", RTFControlType::FLAG, RTFKeyword::MMMAINTYPEFAX, 0 },
    { "mmmaintypelabels", RTFControlType::FLAG, RTFKeyword::MMMAINTYPELABELS, 0 },
    { "mmmaintypeletters", RTFControlType::FLAG, RTFKeyword::MMMAINTYPELETTERS, 0 },
    { "mmodso", RTFControlType::DESTINATION, RTFKeyword::MMODSO, 0 },
    { "mmodsoactive", RTFControlType::VALUE, RTFKeyword::MMODSOACTIVE, 0 },
    { "mmodsocoldelim", RTFControlType::VALUE, RTFKeyword::MMODSOCOLDELIM, 0 },
    { "mmodsocolumn", RTFControlType::VALUE, RTFKeyword::MMODSOCOLUMN, 0 },
    { "mmodsodynaddr", RTFControlType::VALUE, RTFKeyword::MMODSODYNADDR, 0 },
    { "mmodsofhdr", RTFControlType::VALUE, RTFKeyword::MMODSOFHDR, 0 },
    { "mmodsofilter", RTFControlType::DESTINATION, RTFKeyword::MMODSOFILTER, 0 },
    { "mmodsofldmpdata", RTFControlType::DESTINATION, RTFKeyword::MMODSOFLDMPDATA, 0 },
    { "mmodsofmcolumn", RTFControlType::VALUE, RTFKeyword::MMODSOFMCOLUMN, 0 },
    { "mmodsohash", RTFControlType::VALUE, RTFKeyword::MMODSOHASH, 0 },
    { "mmodsolid", RTFControlType::VALUE, RTFKeyword::MMODSOLID, 0 },
    { "mmodsomappedname", RTFControlType::DESTINATION, RTFKeyword::MMODSOMAPPEDNAME, 0 },
    { "mmodsoname", RTFControlType::DESTINATION, RTFKeyword::MMODSONAME, 0 },
    { "mmodsorecipdata", RTFControlType::DESTINATION, RTFKeyword::MMODSORECIPDATA, 0 },
    { "mmodsosort", RTFControlType::DESTINATION, RTFKeyword::MMODSOSORT, 0 },
    { "mmodsosrc", RTFControlType::DESTINATION, RTFKeyword::MMODSOSRC, 0 },
    { "mmodsotable", RTFControlType::DESTINATION, RTFKeyword::MMODSOTABLE, 0 },
    { "mmodsoudl", RTFControlType::DESTINATION, RTFKeyword::MMODSOUDL, 0 },
    { "mmodsoudldata", RTFControlType::DESTINATION, RTFKeyword::MMODSOUDLDATA, 0 },
    { "mmodsouniquetag", RTFControlType::DESTINATION, RTFKeyword::MMODSOUNIQUETAG, 0 },
    { "mmPr", RTFControlType::DESTINATION, RTFKeyword::MMPR, 0 },
    { "mmquery", RTFControlType::DESTINATION, RTFKeyword::MMQUERY, 0 },
    { "mmr", RTFControlType::DESTINATION, RTFKeyword::MMR, 0 },
    { "mmreccur", RTFControlType::VALUE, RTFKeyword::MMRECCUR, 0 },
    { "mmshowdata", RTFControlType::FLAG, RTFKeyword::MMSHOWDATA, 0 },
    { "mnary", RTFControlType::DESTINATION, RTFKeyword::MNARY, 0 },
    { "mnaryLim", RTFControlType::VALUE, RTFKeyword::MNARYLIM, 0 },
    { "mnaryPr", RTFControlType::DESTINATION, RTFKeyword::MNARYPR, 0 },
    { "mnoBreak", RTFControlType::DESTINATION, RTFKeyword::MNOBREAK, 0 },
    { "mnor", RTFControlType::FLAG, RTFKeyword::MNOR, 0 },
    { "mnum", RTFControlType::DESTINATION, RTFKeyword::MNUM, 0 },
    { "mo", RTFControlType::VALUE, RTFKeyword::MO, 0 },
    { "mobjDist", RTFControlType::DESTINATION, RTFKeyword::MOBJDIST, 0 },
    { "moMath", RTFControlType::DESTINATION, RTFKeyword::MOMATH, 0 },
    { "moMathPara", RTFControlType::DESTINATION, RTFKeyword::MOMATHPARA, 0 },
    { "moMathParaPr", RTFControlType::DESTINATION, RTFKeyword::MOMATHPARAPR, 0 },
    { "mopEmu", RTFControlType::DESTINATION, RTFKeyword::MOPEMU, 0 },
    { "mphant", RTFControlType::DESTINATION, RTFKeyword::MPHANT, 0 },
    { "mphantPr", RTFControlType::DESTINATION, RTFKeyword::MPHANTPR, 0 },
    { "mplcHide", RTFControlType::DESTINATION, RTFKeyword::MPLCHIDE, 0 },
    { "mpos", RTFControlType::DESTINATION, RTFKeyword::MPOS, 0 },
    { "mpostSp", RTFControlType::VALUE, RTFKeyword::MPOSTSP, 0 },
    { "mpreSp", RTFControlType::VALUE, RTFKeyword::MPRESP, 0 },
    { "mr", RTFControlType::DESTINATION, RTFKeyword::MR, 0 },
    { "mrad", RTFControlType::DESTINATION, RTFKeyword::MRAD, 0 },
    { "mradPr", RTFControlType::DESTINATION, RTFKeyword::MRADPR, 0 },
    { "mrMargin", RTFControlType::VALUE, RTFKeyword::MRMARGIN, 0 },
    { "mrPr", RTFControlType::DESTINATION, RTFKeyword::MRPR, 0 },
    { "mrSp", RTFControlType::VALUE, RTFKeyword::MRSP, 0 },
    { "mrSpRule", RTFControlType::VALUE, RTFKeyword::MRSPRULE, 0 },
    { "mscr", RTFControlType::VALUE, RTFKeyword::MSCR, 0 },
    { "msepChr", RTFControlType::DESTINATION, RTFKeyword::MSEPCHR, 0 },
    { "mshow", RTFControlType::DESTINATION, RTFKeyword::MSHOW, 0 },
    { "mshp", RTFControlType::DESTINATION, RTFKeyword::MSHP, 0 },
    { "msmallFrac", RTFControlType::VALUE, RTFKeyword::MSMALLFRAC, 0 },
    { "msmcap", RTFControlType::FLAG, RTFKeyword::MSMCAP, 0 },
    { "msPre", RTFControlType::DESTINATION, RTFKeyword::MSPRE, 0 },
    { "msPrePr", RTFControlType::DESTINATION, RTFKeyword::MSPREPR, 0 },
    { "msSub", RTFControlType::DESTINATION, RTFKeyword::MSSUB, 0 },
    { "msSubPr", RTFControlType::DESTINATION, RTFKeyword::MSSUBPR, 0 },
    { "msSubSup", RTFControlType::DESTINATION, RTFKeyword::MSSUBSUP, 0 },
    { "msSubSupPr", RTFControlType::DESTINATION, RTFKeyword::MSSUBSUPPR, 0 },
    { "msSup", RTFControlType::DESTINATION, RTFKeyword::MSSUP, 0 },
    { "msSupPr", RTFControlType::DESTINATION, RTFKeyword::MSSUPPR, 0 },
    { "mstrikeBLTR", RTFControlType::DESTINATION, RTFKeyword::MSTRIKEBLTR, 0 },
    { "mstrikeH", RTFControlType::DESTINATION, RTFKeyword::MSTRIKEH, 0 },
    { "mstrikeTLBR", RTFControlType::DESTINATION, RTFKeyword::MSTRIKETLBR, 0 },
    { "mstrikeV", RTFControlType::DESTINATION, RTFKeyword::MSTRIKEV, 0 },
    { "msty", RTFControlType::VALUE, RTFKeyword::MSTY, 0 },
    { "msub", RTFControlType::DESTINATION, RTFKeyword::MSUB, 0 },
    { "msubHide", RTFControlType::DESTINATION, RTFKeyword::MSUBHIDE, 0 },
    { "msup", RTFControlType::DESTINATION, RTFKeyword::MSUP, 0 },
    { "msupHide", RTFControlType::DESTINATION, RTFKeyword::MSUPHIDE, 0 },
    { "mtransp", RTFControlType::DESTINATION, RTFKeyword::MTRANSP, 0 },
    { "mtype", RTFControlType::DESTINATION, RTFKeyword::MTYPE, 0 },
    { "muser", RTFControlType::FLAG, RTFKeyword::MUSER, 0 },
    { "mvauth", RTFControlType::VALUE, RTFKeyword::MVAUTH, 0 },
    { "mvdate", RTFControlType::VALUE, RTFKeyword::MVDATE, 0 },
    { "mvertJc", RTFControlType::DESTINATION, RTFKeyword::MVERTJC, 0 },
    { "mvf", RTFControlType::FLAG, RTFKeyword::MVF, 0 },
    { "mvfmf", RTFControlType::DESTINATION, RTFKeyword::MVFMF, 0 },
    { "mvfml", RTFControlType::DESTINATION, RTFKeyword::MVFML, 0 },
    { "mvt", RTFControlType::FLAG, RTFKeyword::MVT, 0 },
    { "mvtof", RTFControlType::DESTINATION, RTFKeyword::MVTOF, 0 },
    { "mvtol", RTFControlType::DESTINATION, RTFKeyword::MVTOL, 0 },
    { "mwrapIndent", RTFControlType::VALUE, RTFKeyword::MWRAPINDENT, 1440 },
    { "mwrapRight", RTFControlType::VALUE, RTFKeyword::MWRAPRIGHT, 0 },
    { "mzeroAsc", RTFControlType::DESTINATION, RTFKeyword::MZEROASC, 0 },
    { "mzeroDesc", RTFControlType::DESTINATION, RTFKeyword::MZERODESC, 0 },
    { "mzeroWid", RTFControlType::DESTINATION, RTFKeyword::MZEROWID, 0 },
    { "nestcell", RTFControlType::SYMBOL, RTFKeyword::NESTCELL, 0 },
    { "nestrow", RTFControlType::SYMBOL, RTFKeyword::NESTROW, 0 },
    { "nesttableprops", RTFControlType::DESTINATION, RTFKeyword::NESTTABLEPROPS, 0 },
    { "newtblstyruls", RTFControlType::FLAG, RTFKeyword::NEWTBLSTYRULS, 0 },
    { "nextfile", RTFControlType::DESTINATION, RTFKeyword::NEXTFILE, 0 },
    { "noafcnsttbl", RTFControlType::FLAG, RTFKeyword::NOAFCNSTTBL, 0 },
    { "nobrkwrptbl", RTFControlType::FLAG, RTFKeyword::NOBRKWRPTBL, 0 },
    { "nocolbal", RTFControlType::FLAG, RTFKeyword::NOCOLBAL, 0 },
    { "nocompatoptions", RTFControlType::FLAG, RTFKeyword::NOCOMPATOPTIONS, 0 },
    { "nocwrap", RTFControlType::FLAG, RTFKeyword::NOCWRAP, 0 },
    { "nocxsptable", RTFControlType::FLAG, RTFKeyword::NOCXSPTABLE, 0 },
    { "noextrasprl", RTFControlType::FLAG, RTFKeyword::NOEXTRASPRL, 0 },
    { "nofchars", RTFControlType::VALUE, RTFKeyword::NOFCHARS, 0 },
    { "nofcharsws", RTFControlType::VALUE, RTFKeyword::NOFCHARSWS, 0 },
    { "nofeaturethrottle", RTFControlType::FLAG, RTFKeyword::NOFEATURETHROTTLE, 0 },
    { "nofpages", RTFControlType::VALUE, RTFKeyword::NOFPAGES, 0 },
    { "nofwords", RTFControlType::VALUE, RTFKeyword::NOFWORDS, 0 },
    { "nogrowautofit", RTFControlType::FLAG, RTFKeyword::NOGROWAUTOFIT, 0 },
    { "noindnmbrts", RTFControlType::FLAG, RTFKeyword::NOINDNMBRTS, 0 },
    { "nojkernpunct", RTFControlType::FLAG, RTFKeyword::NOJKERNPUNCT, 0 },
    { "nolead", RTFControlType::FLAG, RTFKeyword::NOLEAD, 0 },
    { "noline", RTFControlType::FLAG, RTFKeyword::NOLINE, 0 },
    { "nolnhtadjtbl", RTFControlType::FLAG, RTFKeyword::NOLNHTADJTBL, 0 },
    { "nonesttables", RTFControlType::DESTINATION, RTFKeyword::NONESTTABLES, 0 },
    { "nonshppict", RTFControlType::FLAG, RTFKeyword::NONSHPPICT, 0 },
    { "nooverflow", RTFControlType::FLAG, RTFKeyword::NOOVERFLOW, 0 },
    { "noproof", RTFControlType::FLAG, RTFKeyword::NOPROOF, 0 },
    { "noqfpromote", RTFControlType::FLAG, RTFKeyword::NOQFPROMOTE, 0 },
    { "nosectexpand", RTFControlType::FLAG, RTFKeyword::NOSECTEXPAND, 0 },
    { "nosnaplinegrid", RTFControlType::FLAG, RTFKeyword::NOSNAPLINEGRID, 0 },
    { "nospaceforul", RTFControlType::FLAG, RTFKeyword::NOSPACEFORUL, 0 },
    { "nosupersub", RTFControlType::FLAG, RTFKeyword::NOSUPERSUB, 0 },
    { "notabind", RTFControlType::FLAG, RTFKeyword::NOTABIND, 0 },
    { "notbrkcnstfrctbl", RTFControlType::FLAG, RTFKeyword::NOTBRKCNSTFRCTBL, 0 },
    { "notcvasp", RTFControlType::FLAG, RTFKeyword::NOTCVASP, 0 },
    { "notvatxbx", RTFControlType::FLAG, RTFKeyword::NOTVATXBX, 0 },
    { "nouicompat", RTFControlType::FLAG, RTFKeyword::NOUICOMPAT, 0 },
    { "noultrlspc", RTFControlType::FLAG, RTFKeyword::NOULTRLSPC, 0 },
    { "nowidctlpar", RTFControlType::FLAG, RTFKeyword::NOWIDCTLPAR, 0 },
    { "nowrap", RTFControlType::FLAG, RTFKeyword::NOWRAP, 0 },
    { "nowwrap", RTFControlType::FLAG, RTFKeyword::NOWWRAP, 0 },
    { "noxlattoyen", RTFControlType::FLAG, RTFKeyword::NOXLATTOYEN, 0 },
    { "objalias", RTFControlType::DESTINATION, RTFKeyword::OBJALIAS, 0 },
    { "objalign", RTFControlType::VALUE, RTFKeyword::OBJALIGN, 0 },
    { "objattph", RTFControlType::FLAG, RTFKeyword::OBJATTPH, 0 },
    { "objautlink", RTFControlType::FLAG, RTFKeyword::OBJAUTLINK, 0 },
    { "objclass", RTFControlType::DESTINATION, RTFKeyword::OBJCLASS, 0 },
    { "objcropb", RTFControlType::VALUE, RTFKeyword::OBJCROPB, 0 },
    { "objcropl", RTFControlType::VALUE, RTFKeyword::OBJCROPL, 0 },
    { "objcropr", RTFControlType::VALUE, RTFKeyword::OBJCROPR, 0 },
    { "objcropt", RTFControlType::VALUE, RTFKeyword::OBJCROPT, 0 },
    { "objdata", RTFControlType::DESTINATION, RTFKeyword::OBJDATA, 0 },
    { "object", RTFControlType::DESTINATION, RTFKeyword::OBJECT, 0 },
    { "objemb", RTFControlType::FLAG, RTFKeyword::OBJEMB, 0 },
    { "objh", RTFControlType::VALUE, RTFKeyword::OBJH, 0 },
    { "objhtml", RTFControlType::FLAG, RTFKeyword::OBJHTML, 0 },
    { "objicemb", RTFControlType::FLAG, RTFKeyword::OBJICEMB, 0 },
    { "objlink", RTFControlType::FLAG, RTFKeyword::OBJLINK, 0 },
    { "objlock", RTFControlType::FLAG, RTFKeyword::OBJLOCK, 0 },
    { "objname", RTFControlType::DESTINATION, RTFKeyword::OBJNAME, 0 },
    { "objocx", RTFControlType::FLAG, RTFKeyword::OBJOCX, 0 },
    { "objpub", RTFControlType::FLAG, RTFKeyword::OBJPUB, 0 },
    { "objscalex", RTFControlType::VALUE, RTFKeyword::OBJSCALEX, 0 },
    { "objscaley", RTFControlType::VALUE, RTFKeyword::OBJSCALEY, 0 },
    { "objsect", RTFControlType::DESTINATION, RTFKeyword::OBJSECT, 0 },
    { "objsetsize", RTFControlType::FLAG, RTFKeyword::OBJSETSIZE, 0 },
    { "objsub", RTFControlType::FLAG, RTFKeyword::OBJSUB, 0 },
    { "objtime", RTFControlType::DESTINATION, RTFKeyword::OBJTIME, 0 },
    { "objtransy", RTFControlType::VALUE, RTFKeyword::OBJTRANSY, 0 },
    { "objupdate", RTFControlType::FLAG, RTFKeyword::OBJUPDATE, 0 },
    { "objw", RTFControlType::VALUE, RTFKeyword::OBJW, 0 },
    { "ogutter", RTFControlType::VALUE, RTFKeyword::OGUTTER, 0 },
    { "oldas", RTFControlType::FLAG, RTFKeyword::OLDAS, 0 },
    { "oldcprops", RTFControlType::DESTINATION, RTFKeyword::OLDCPROPS, 0 },
    { "oldlinewrap", RTFControlType::FLAG, RTFKeyword::OLDLINEWRAP, 0 },
    { "oldpprops", RTFControlType::DESTINATION, RTFKeyword::OLDPPROPS, 0 },
    { "oldsprops", RTFControlType::DESTINATION, RTFKeyword::OLDSPROPS, 0 },
    { "oldtprops", RTFControlType::DESTINATION, RTFKeyword::OLDTPROPS, 0 },
    { "oleclsid", RTFControlType::DESTINATION, RTFKeyword::OLECLSID, 0 },
    { "operator", RTFControlType::DESTINATION, RTFKeyword::OPERATOR, 0 },
    { "otblrul", RTFControlType::FLAG, RTFKeyword::OTBLRUL, 0 },
    { "outl", RTFControlType::TOGGLE, RTFKeyword::OUTL, 1 },
    { "outlinelevel", RTFControlType::VALUE, RTFKeyword::OUTLINELEVEL, 0 },
    { "overlay", RTFControlType::FLAG, RTFKeyword::OVERLAY, 0 },
    { "page", RTFControlType::SYMBOL, RTFKeyword::PAGE, 0 },
    { "pagebb", RTFControlType::FLAG, RTFKeyword::PAGEBB, 0 },
    { "panose", RTFControlType::DESTINATION, RTFKeyword::PANOSE, 0 },
    { "paperh", RTFControlType::VALUE, RTFKeyword::PAPERH, 15840 },
    { "paperw", RTFControlType::VALUE, RTFKeyword::PAPERW, 12240 },
    { "par", RTFControlType::SYMBOL, RTFKeyword::PAR, 0 },
    { "pararsid", RTFControlType::VALUE, RTFKeyword::PARARSID, 0 },
    { "pard", RTFControlType::FLAG, RTFKeyword::PARD, 0 },
    { "password", RTFControlType::DESTINATION, RTFKeyword::PASSWORD, 0 },
    { "passwordhash", RTFControlType::DESTINATION, RTFKeyword::PASSWORDHASH, 0 },
    { "pc", RTFControlType::FLAG, RTFKeyword::PC, 0 },
    { "pca", RTFControlType::FLAG, RTFKeyword::PCA, 0 },
    { "pgbrdrb", RTFControlType::FLAG, RTFKeyword::PGBRDRB, 0 },
    { "pgbrdrfoot", RTFControlType::FLAG, RTFKeyword::PGBRDRFOOT, 0 },
    { "pgbrdrhead", RTFControlType::FLAG, RTFKeyword::PGBRDRHEAD, 0 },
    { "pgbrdrl", RTFControlType::FLAG, RTFKeyword::PGBRDRL, 0 },
    { "pgbrdropt", RTFControlType::VALUE, RTFKeyword::PGBRDROPT, 0 },
    { "pgbrdrr", RTFControlType::FLAG, RTFKeyword::PGBRDRR, 0 },
    { "pgbrdrsnap", RTFControlType::FLAG, RTFKeyword::PGBRDRSNAP, 0 },
    { "pgbrdrt", RTFControlType::FLAG, RTFKeyword::PGBRDRT, 0 },
    { "pghsxn", RTFControlType::VALUE, RTFKeyword::PGHSXN, 0 },
    { "pgnbidia", RTFControlType::FLAG, RTFKeyword::PGNBIDIA, 0 },
    { "pgnbidib", RTFControlType::FLAG, RTFKeyword::PGNBIDIB, 0 },
    { "pgnchosung", RTFControlType::FLAG, RTFKeyword::PGNCHOSUNG, 0 },
    { "pgncnum", RTFControlType::FLAG, RTFKeyword::PGNCNUM, 0 },
    { "pgncont", RTFControlType::FLAG, RTFKeyword::PGNCONT, 0 },
    { "pgndbnum", RTFControlType::FLAG, RTFKeyword::PGNDBNUM, 0 },
    { "pgndbnumd", RTFControlType::FLAG, RTFKeyword::PGNDBNUMD, 0 },
    { "pgndbnumk", RTFControlType::FLAG, RTFKeyword::PGNDBNUMK, 0 },
    { "pgndbnumt", RTFControlType::FLAG, RTFKeyword::PGNDBNUMT, 0 },
    { "pgndec", RTFControlType::FLAG, RTFKeyword::PGNDEC, 0 },
    { "pgndecd", RTFControlType::FLAG, RTFKeyword::PGNDECD, 0 },
    { "pgnganada", RTFControlType::FLAG, RTFKeyword::PGNGANADA, 0 },
    { "pgngbnum", RTFControlType::FLAG, RTFKeyword::PGNGBNUM, 0 },
    { "pgngbnumd", RTFControlType::FLAG, RTFKeyword::PGNGBNUMD, 0 },
    { "pgngbnumk", RTFControlType::FLAG, RTFKeyword::PGNGBNUMK, 0 },
    { "pgngbnuml", RTFControlType::FLAG, RTFKeyword::PGNGBNUML, 0 },
    { "pgnhindia", RTFControlType::FLAG, RTFKeyword::PGNHINDIA, 0 },
    { "pgnhindib", RTFControlType::FLAG, RTFKeyword::PGNHINDIB, 0 },
    { "pgnhindic", RTFControlType::FLAG, RTFKeyword::PGNHINDIC, 0 },
    { "pgnhindid", RTFControlType::FLAG, RTFKeyword::PGNHINDID, 0 },
    { "pgnhn", RTFControlType::VALUE, RTFKeyword::PGNHN, 0 },
    { "pgnhnsc", RTFControlType::FLAG, RTFKeyword::PGNHNSC, 0 },
    { "pgnhnsh", RTFControlType::FLAG, RTFKeyword::PGNHNSH, 0 },
    { "pgnhnsm", RTFControlType::FLAG, RTFKeyword::PGNHNSM, 0 },
    { "pgnhnsn", RTFControlType::FLAG, RTFKeyword::PGNHNSN, 0 },
    { "pgnhnsp", RTFControlType::FLAG, RTFKeyword::PGNHNSP, 0 },
    { "pgnid", RTFControlType::FLAG, RTFKeyword::PGNID, 0 },
    { "pgnlcltr", RTFControlType::FLAG, RTFKeyword::PGNLCLTR, 0 },
    { "pgnlcrm", RTFControlType::FLAG, RTFKeyword::PGNLCRM, 0 },
    { "pgnrestart", RTFControlType::FLAG, RTFKeyword::PGNRESTART, 0 },
    { "pgnstart", RTFControlType::VALUE, RTFKeyword::PGNSTART, 1 },
    { "pgnstarts", RTFControlType::VALUE, RTFKeyword::PGNSTARTS, 1 },
    { "pgnthaia", RTFControlType::FLAG, RTFKeyword::PGNTHAIA, 0 },
    { "pgnthaib", RTFControlType::FLAG, RTFKeyword::PGNTHAIB, 0 },
    { "pgnthaic", RTFControlType::FLAG, RTFKeyword::PGNTHAIC, 0 },
    { "pgnucltr", RTFControlType::FLAG, RTFKeyword::PGNUCLTR, 0 },
    { "pgnucrm", RTFControlType::FLAG, RTFKeyword::PGNUCRM, 0 },
    { "pgnvieta", RTFControlType::FLAG, RTFKeyword::PGNVIETA, 0 },
    { "pgnx", RTFControlType::VALUE, RTFKeyword::PGNX, 720 },
    { "pgny", RTFControlType::VALUE, RTFKeyword::PGNY, 720 },
    { "pgnzodiac", RTFControlType::FLAG, RTFKeyword::PGNZODIAC, 0 },
    { "pgnzodiacd", RTFControlType::FLAG, RTFKeyword::PGNZODIACD, 0 },
    { "pgnzodiacl", RTFControlType::FLAG, RTFKeyword::PGNZODIACL, 0 },
    { "pgp", RTFControlType::DESTINATION, RTFKeyword::PGP, 0 },
    { "pgptbl", RTFControlType::DESTINATION, RTFKeyword::PGPTBL, 0 },
    { "pgwsxn", RTFControlType::VALUE, RTFKeyword::PGWSXN, 0 },
    { "phcol", RTFControlType::FLAG, RTFKeyword::PHCOL, 0 },
    { "phmrg", RTFControlType::FLAG, RTFKeyword::PHMRG, 0 },
    { "phpg", RTFControlType::FLAG, RTFKeyword::PHPG, 0 },
    { "picbmp", RTFControlType::FLAG, RTFKeyword::PICBMP, 0 },
    { "picbpp", RTFControlType::VALUE, RTFKeyword::PICBPP, 0 },
    { "piccropb", RTFControlType::VALUE, RTFKeyword::PICCROPB, 0 },
    { "piccropl", RTFControlType::VALUE, RTFKeyword::PICCROPL, 0 },
    { "piccropr", RTFControlType::VALUE, RTFKeyword::PICCROPR, 0 },
    { "piccropt", RTFControlType::VALUE, RTFKeyword::PICCROPT, 0 },
    { "pich", RTFControlType::VALUE, RTFKeyword::PICH, 0 },
    { "pichgoal", RTFControlType::VALUE, RTFKeyword::PICHGOAL, 0 },
    { "pichGoal", RTFControlType::VALUE, RTFKeyword::PICHGOAL, 0 },
    { "picprop", RTFControlType::DESTINATION, RTFKeyword::PICPROP, 0 },
    { "picscaled", RTFControlType::FLAG, RTFKeyword::PICSCALED, 0 },
    { "picscalex", RTFControlType::VALUE, RTFKeyword::PICSCALEX, 100 },
    { "picscaley", RTFControlType::VALUE, RTFKeyword::PICSCALEY, 100 },
    { "pict", RTFControlType::DESTINATION, RTFKeyword::PICT, 0 },
    { "picw", RTFControlType::VALUE, RTFKeyword::PICW, 0 },
    { "picwgoal", RTFControlType::VALUE, RTFKeyword::PICWGOAL, 0 },
    { "picwGoal", RTFControlType::VALUE, RTFKeyword::PICWGOAL, 0 },
    { "pindtabqc", RTFControlType::FLAG, RTFKeyword::PINDTABQC, 0 },
    { "pindtabql", RTFControlType::FLAG, RTFKeyword::PINDTABQL, 0 },
    { "pindtabqr", RTFControlType::FLAG, RTFKeyword::PINDTABQR, 0 },
    { "plain", RTFControlType::FLAG, RTFKeyword::PLAIN, 0 },
    { "pmartabqc", RTFControlType::FLAG, RTFKeyword::PMARTABQC, 0 },
    { "pmartabql", RTFControlType::FLAG, RTFKeyword::PMARTABQL, 0 },
    { "pmartabqr", RTFControlType::FLAG, RTFKeyword::PMARTABQR, 0 },
    { "pmmetafile", RTFControlType::VALUE, RTFKeyword::PMMETAFILE, 0 },
    { "pn", RTFControlType::DESTINATION, RTFKeyword::PN, 0 },
    { "pnacross", RTFControlType::FLAG, RTFKeyword::PNACROSS, 0 },
    { "pnaiu", RTFControlType::FLAG, RTFKeyword::PNAIU, 0 },
    { "pnaiud", RTFControlType::FLAG, RTFKeyword::PNAIUD, 0 },
    { "pnaiueo", RTFControlType::FLAG, RTFKeyword::PNAIUEO, 0 },
    { "pnaiueod", RTFControlType::FLAG, RTFKeyword::PNAIUEOD, 0 },
    { "pnb", RTFControlType::TOGGLE, RTFKeyword::PNB, 1 },
    { "pnbidia", RTFControlType::FLAG, RTFKeyword::PNBIDIA, 0 },
    { "pnbidib", RTFControlType::FLAG, RTFKeyword::PNBIDIB, 0 },
    { "pncaps", RTFControlType::TOGGLE, RTFKeyword::PNCAPS, 1 },
    { "pncard", RTFControlType::FLAG, RTFKeyword::PNCARD, 0 },
    { "pncf", RTFControlType::VALUE, RTFKeyword::PNCF, 0 },
    { "pnchosung", RTFControlType::FLAG, RTFKeyword::PNCHOSUNG, 0 },
    { "pncnum", RTFControlType::FLAG, RTFKeyword::PNCNUM, 0 },
    { "pndbnum", RTFControlType::FLAG, RTFKeyword::PNDBNUM, 0 },
    { "pndbnumd", RTFControlType::FLAG, RTFKeyword::PNDBNUMD, 0 },
    { "pndbnumk", RTFControlType::FLAG, RTFKeyword::PNDBNUMK, 0 },
    { "pndbnuml", RTFControlType::FLAG, RTFKeyword::PNDBNUML, 0 },
    { "pndbnumt", RTFControlType::FLAG, RTFKeyword::PNDBNUMT, 0 },
    { "pndec", RTFControlType::FLAG, RTFKeyword::PNDEC, 0 },
    { "pndecd", RTFControlType::FLAG, RTFKeyword::PNDECD, 0 },
    { "pnf", RTFControlType::VALUE, RTFKeyword::PNF, 0 },
    { "pnfs", RTFControlType::VALUE, RTFKeyword::PNFS, 0 },
    { "pnganada", RTFControlType::FLAG, RTFKeyword::PNGANADA, 0 },
    { "pngblip", RTFControlType::FLAG, RTFKeyword::PNGBLIP, 0 },
    { "pngbnum", RTFControlType::FLAG, RTFKeyword::PNGBNUM, 0 },
    { "pngbnumd", RTFControlType::FLAG, RTFKeyword::PNGBNUMD, 0 },
    { "pngbnumk", RTFControlType::FLAG, RTFKeyword::PNGBNUMK, 0 },
    { "pngbnuml", RTFControlType::FLAG, RTFKeyword::PNGBNUML, 0 },
    { "pnhang", RTFControlType::FLAG, RTFKeyword::PNHANG, 0 },
    { "pni", RTFControlType::TOGGLE, RTFKeyword::PNI, 1 },
    { "pnindent", RTFControlType::VALUE, RTFKeyword::PNINDENT, 0 },
    { "pniroha", RTFControlType::FLAG, RTFKeyword::PNIROHA, 0 },
    { "pnirohad", RTFControlType::FLAG, RTFKeyword::PNIROHAD, 0 },
    { "pnlcltr", RTFControlType::FLAG, RTFKeyword::PNLCLTR, 0 },
    { "pnlcrm", RTFControlType::FLAG, RTFKeyword::PNLCRM, 0 },
    { "pnlvl", RTFControlType::VALUE, RTFKeyword::PNLVL, 0 },
    { "pnlvlblt", RTFControlType::FLAG, RTFKeyword::PNLVLBLT, 0 },
    { "pnlvlbody", RTFControlType::FLAG, RTFKeyword::PNLVLBODY, 0 },
    { "pnlvlcont", RTFControlType::FLAG, RTFKeyword::PNLVLCONT, 0 },
    { "pnnumonce", RTFControlType::FLAG, RTFKeyword::PNNUMONCE, 0 },
    { "pnord", RTFControlType::FLAG, RTFKeyword::PNORD, 0 },
    { "pnordt", RTFControlType::FLAG, RTFKeyword::PNORDT, 0 },
    { "pnprev", RTFControlType::FLAG, RTFKeyword::PNPREV, 0 },
    { "pnqc", RTFControlType::FLAG, RTFKeyword::PNQC, 0 },
    { "pnql", RTFControlType::FLAG, RTFKeyword::PNQL, 0 },
    { "pnqr", RTFControlType::FLAG, RTFKeyword::PNQR, 0 },
    { "pnrauth", RTFControlType::VALUE, RTFKeyword::PNRAUTH, 0 },
    { "pnrdate", RTFControlType::VALUE, RTFKeyword::PNRDATE, 0 },
    { "pnrestart", RTFControlType::FLAG, RTFKeyword::PNRESTART, 0 },
    { "pnrnfc", RTFControlType::VALUE, RTFKeyword::PNRNFC, 0 },
    { "pnrnot", RTFControlType::FLAG, RTFKeyword::PNRNOT, 0 },
    { "pnrpnbr", RTFControlType::VALUE, RTFKeyword::PNRPNBR, 0 },
    { "pnrrgb", RTFControlType::VALUE, RTFKeyword::PNRRGB, 0 },
    { "pnrstart", RTFControlType::VALUE, RTFKeyword::PNRSTART, 0 },
    { "pnrstop", RTFControlType::VALUE, RTFKeyword::PNRSTOP, 0 },
    { "pnrxst", RTFControlType::VALUE, RTFKeyword::PNRXST, 0 },
    { "pnscaps", RTFControlType::TOGGLE, RTFKeyword::PNSCAPS, 1 },
    { "pnseclvl", RTFControlType::DESTINATION, RTFKeyword::PNSECLVL, 0 },
    { "pnsp", RTFControlType::VALUE, RTFKeyword::PNSP, 0 },
    { "pnstart", RTFControlType::VALUE, RTFKeyword::PNSTART, 0 },
    { "pnstrike", RTFControlType::TOGGLE, RTFKeyword::PNSTRIKE, 1 },
    { "pntext", RTFControlType::DESTINATION, RTFKeyword::PNTEXT, 0 },
    { "pntxta", RTFControlType::DESTINATION, RTFKeyword::PNTXTA, 0 },
    { "pntxtb", RTFControlType::DESTINATION, RTFKeyword::PNTXTB, 0 },
    { "pnucltr", RTFControlType::FLAG, RTFKeyword::PNUCLTR, 0 },
    { "pnucrm", RTFControlType::FLAG, RTFKeyword::PNUCRM, 0 },
    { "pnul", RTFControlType::TOGGLE, RTFKeyword::PNUL, 1 },
    { "pnuld", RTFControlType::FLAG, RTFKeyword::PNULD, 0 },
    { "pnuldash", RTFControlType::FLAG, RTFKeyword::PNULDASH, 0 },
    { "pnuldashd", RTFControlType::FLAG, RTFKeyword::PNULDASHD, 0 },
    { "pnuldashdd", RTFControlType::FLAG, RTFKeyword::PNULDASHDD, 0 },
    { "pnuldb", RTFControlType::FLAG, RTFKeyword::PNULDB, 0 },
    { "pnulhair", RTFControlType::FLAG, RTFKeyword::PNULHAIR, 0 },
    { "pnulnone", RTFControlType::FLAG, RTFKeyword::PNULNONE, 0 },
    { "pnulth", RTFControlType::FLAG, RTFKeyword::PNULTH, 0 },
    { "pnulw", RTFControlType::FLAG, RTFKeyword::PNULW, 0 },
    { "pnulwave", RTFControlType::FLAG, RTFKeyword::PNULWAVE, 0 },
    { "pnzodiac", RTFControlType::FLAG, RTFKeyword::PNZODIAC, 0 },
    { "pnzodiacd", RTFControlType::FLAG, RTFKeyword::PNZODIACD, 0 },
    { "pnzodiacl", RTFControlType::FLAG, RTFKeyword::PNZODIACL, 0 },
    { "posnegx", RTFControlType::VALUE, RTFKeyword::POSNEGX, 0 },
    { "posnegy", RTFControlType::VALUE, RTFKeyword::POSNEGY, 0 },
    { "posx", RTFControlType::VALUE, RTFKeyword::POSX, 0 },
    { "posxc", RTFControlType::FLAG, RTFKeyword::POSXC, 0 },
    { "posxi", RTFControlType::FLAG, RTFKeyword::POSXI, 0 },
    { "posxl", RTFControlType::FLAG, RTFKeyword::POSXL, 0 },
    { "posxo", RTFControlType::FLAG, RTFKeyword::POSXO, 0 },
    { "posxr", RTFControlType::FLAG, RTFKeyword::POSXR, 0 },
    { "posy", RTFControlType::VALUE, RTFKeyword::POSY, 0 },
    { "posyb", RTFControlType::FLAG, RTFKeyword::POSYB, 0 },
    { "posyc", RTFControlType::FLAG, RTFKeyword::POSYC, 0 },
    { "posyil", RTFControlType::FLAG, RTFKeyword::POSYIL, 0 },
    { "posyin", RTFControlType::FLAG, RTFKeyword::POSYIN, 0 },
    { "posyout", RTFControlType::FLAG, RTFKeyword::POSYOUT, 0 },
    { "posyt", RTFControlType::FLAG, RTFKeyword::POSYT, 0 },
    { "prauth", RTFControlType::VALUE, RTFKeyword::PRAUTH, 0 },
    { "prcolbl", RTFControlType::FLAG, RTFKeyword::PRCOLBL, 0 },
    { "prdate", RTFControlType::VALUE, RTFKeyword::PRDATE, 0 },
    { "printdata", RTFControlType::FLAG, RTFKeyword::PRINTDATA, 0 },
    { "printim", RTFControlType::DESTINATION, RTFKeyword::PRINTIM, 0 },
    { "private", RTFControlType::DESTINATION, RTFKeyword::PRIVATE, 0 },
    { "propname", RTFControlType::DESTINATION, RTFKeyword::PROPNAME, 0 },
    { "proptype", RTFControlType::VALUE, RTFKeyword::PROPTYPE, 0 },
    { "protect", RTFControlType::TOGGLE, RTFKeyword::PROTECT, 1 },
    { "protend", RTFControlType::DESTINATION, RTFKeyword::PROTEND, 0 },
    { "protlevel", RTFControlType::VALUE, RTFKeyword::PROTLEVEL, 0 },
    { "protstart", RTFControlType::DESTINATION, RTFKeyword::PROTSTART, 0 },
    { "protusertbl", RTFControlType::DESTINATION, RTFKeyword::PROTUSERTBL, 0 },
    { "psover", RTFControlType::FLAG, RTFKeyword::PSOVER, 0 },
    { "psz", RTFControlType::VALUE, RTFKeyword::PSZ, 0 },
    { "ptabldot", RTFControlType::FLAG, RTFKeyword::PTABLDOT, 0 },
    { "ptablmdot", RTFControlType::FLAG, RTFKeyword::PTABLMDOT, 0 },
    { "ptablminus", RTFControlType::FLAG, RTFKeyword::PTABLMINUS, 0 },
    { "ptablnone", RTFControlType::FLAG, RTFKeyword::PTABLNONE, 0 },
    { "ptabluscore", RTFControlType::FLAG, RTFKeyword::PTABLUSCORE, 0 },
    { "pubauto", RTFControlType::FLAG, RTFKeyword::PUBAUTO, 0 },
    { "pvmrg", RTFControlType::FLAG, RTFKeyword::PVMRG, 0 },
    { "pvpara", RTFControlType::FLAG, RTFKeyword::PVPARA, 0 },
    { "pvpg", RTFControlType::FLAG, RTFKeyword::PVPG, 0 },
    { "pwd", RTFControlType::VALUE, RTFKeyword::PWD, 0 },
    { "pxe", RTFControlType::DESTINATION, RTFKeyword::PXE, 0 },
    { "qc", RTFControlType::FLAG, RTFKeyword::QC, 0 },
    { "qd", RTFControlType::FLAG, RTFKeyword::QD, 0 },
    { "qj", RTFControlType::FLAG, RTFKeyword::QJ, 0 },
    { "qk", RTFControlType::VALUE, RTFKeyword::QK, 0 },
    { "ql", RTFControlType::FLAG, RTFKeyword::QL, 0 },
    { "qmspace", RTFControlType::SYMBOL, RTFKeyword::QMSPACE, 0 },
    { "qr", RTFControlType::FLAG, RTFKeyword::QR, 0 },
    { "qt", RTFControlType::FLAG, RTFKeyword::QT, 0 },
    { "rawclbgdkbdiag", RTFControlType::FLAG, RTFKeyword::RAWCLBGDKBDIAG, 0 },
    { "rawclbgbdiag", RTFControlType::FLAG, RTFKeyword::RAWCLBGBDIAG, 0 },
    { "rawclbgcross", RTFControlType::FLAG, RTFKeyword::RAWCLBGCROSS, 0 },
    { "rawclbgdcross", RTFControlType::FLAG, RTFKeyword::RAWCLBGDCROSS, 0 },
    { "rawclbgdkcross", RTFControlType::FLAG, RTFKeyword::RAWCLBGDKCROSS, 0 },
    { "rawclbgdkdcross", RTFControlType::FLAG, RTFKeyword::RAWCLBGDKDCROSS, 0 },
    { "rawclbgdkfdiag", RTFControlType::FLAG, RTFKeyword::RAWCLBGDKFDIAG, 0 },
    { "rawclbgdkhor", RTFControlType::FLAG, RTFKeyword::RAWCLBGDKHOR, 0 },
    { "rawclbgdkvert", RTFControlType::FLAG, RTFKeyword::RAWCLBGDKVERT, 0 },
    { "rawclbgfdiag", RTFControlType::FLAG, RTFKeyword::RAWCLBGFDIAG, 0 },
    { "rawclbghoriz", RTFControlType::FLAG, RTFKeyword::RAWCLBGHORIZ, 0 },
    { "rawclbgvert", RTFControlType::FLAG, RTFKeyword::RAWCLBGVERT, 0 },
    { "rdblquote", RTFControlType::SYMBOL, RTFKeyword::RDBLQUOTE, 0 },
    { "readonlyrecommended", RTFControlType::FLAG, RTFKeyword::READONLYRECOMMENDED, 0 },
    { "readprot", RTFControlType::FLAG, RTFKeyword::READPROT, 0 },
    { "red", RTFControlType::VALUE, RTFKeyword::RED, 0 },
    { "relyonvml", RTFControlType::VALUE, RTFKeyword::RELYONVML, 0 },
    { "remdttm", RTFControlType::FLAG, RTFKeyword::REMDTTM, 0 },
    { "rempersonalinfo", RTFControlType::FLAG, RTFKeyword::REMPERSONALINFO, 0 },
    { "result", RTFControlType::DESTINATION, RTFKeyword::RESULT, 0 },
    { "revauth", RTFControlType::VALUE, RTFKeyword::REVAUTH, 0 },
    { "revauthdel", RTFControlType::VALUE, RTFKeyword::REVAUTHDEL, 0 },
    { "revbar", RTFControlType::VALUE, RTFKeyword::REVBAR, 3 },
    { "revdttm", RTFControlType::VALUE, RTFKeyword::REVDTTM, 0 },
    { "revdttmdel", RTFControlType::VALUE, RTFKeyword::REVDTTMDEL, 0 },
    { "revised", RTFControlType::TOGGLE, RTFKeyword::REVISED, 1 },
    { "revisions", RTFControlType::FLAG, RTFKeyword::REVISIONS, 0 },
    { "revprop", RTFControlType::VALUE, RTFKeyword::REVPROP, 3 },
    { "revprot", RTFControlType::FLAG, RTFKeyword::REVPROT, 0 },
    { "revtbl", RTFControlType::DESTINATION, RTFKeyword::REVTBL, 0 },
    { "revtim", RTFControlType::DESTINATION, RTFKeyword::REVTIM, 0 },
    { "ri", RTFControlType::VALUE, RTFKeyword::RI, 0 },
    { "rin", RTFControlType::VALUE, RTFKeyword::RIN, 0 },
    { "row", RTFControlType::SYMBOL, RTFKeyword::ROW, 0 },
    { "rquote", RTFControlType::SYMBOL, RTFKeyword::RQUOTE, 0 },
    { "rsid", RTFControlType::VALUE, RTFKeyword::RSID, 0 },
    { "rsidroot", RTFControlType::VALUE, RTFKeyword::RSIDROOT, 0 },
    { "rsidtbl", RTFControlType::DESTINATION, RTFKeyword::RSIDTBL, 0 },
    { "rsltbmp", RTFControlType::FLAG, RTFKeyword::RSLTBMP, 0 },
    { "rslthtml", RTFControlType::FLAG, RTFKeyword::RSLTHTML, 0 },
    { "rsltmerge", RTFControlType::FLAG, RTFKeyword::RSLTMERGE, 0 },
    { "rsltpict", RTFControlType::FLAG, RTFKeyword::RSLTPICT, 0 },
    { "rsltrtf", RTFControlType::FLAG, RTFKeyword::RSLTRTF, 0 },
    { "rslttxt", RTFControlType::FLAG, RTFKeyword::RSLTTXT, 0 },
    { "rtf", RTFControlType::DESTINATION, RTFKeyword::RTF, 0 },
    { "rtlch", RTFControlType::FLAG, RTFKeyword::RTLCH, 0 },
    { "rtldoc", RTFControlType::FLAG, RTFKeyword::RTLDOC, 0 },
    { "rtlgutter", RTFControlType::FLAG, RTFKeyword::RTLGUTTER, 0 },
    { "rtlmark", RTFControlType::SYMBOL, RTFKeyword::RTLMARK, 0 },
    { "rtlpar", RTFControlType::FLAG, RTFKeyword::RTLPAR, 0 },
    { "rtlrow", RTFControlType::FLAG, RTFKeyword::RTLROW, 0 },
    { "rtlsect", RTFControlType::FLAG, RTFKeyword::RTLSECT, 0 },
    { "rxe", RTFControlType::DESTINATION, RTFKeyword::RXE, 0 },
    { "s", RTFControlType::VALUE, RTFKeyword::S, 0 },
    { "sa", RTFControlType::VALUE, RTFKeyword::SA, 0 },
    { "saauto", RTFControlType::TOGGLE, RTFKeyword::SAAUTO, 1 },
    { "saftnnalc", RTFControlType::FLAG, RTFKeyword::SAFTNNALC, 0 },
    { "saftnnar", RTFControlType::FLAG, RTFKeyword::SAFTNNAR, 0 },
    { "saftnnauc", RTFControlType::FLAG, RTFKeyword::SAFTNNAUC, 0 },
    { "saftnnchi", RTFControlType::FLAG, RTFKeyword::SAFTNNCHI, 0 },
    { "saftnnchosung", RTFControlType::FLAG, RTFKeyword::SAFTNNCHOSUNG, 0 },
    { "saftnncnum", RTFControlType::FLAG, RTFKeyword::SAFTNNCNUM, 0 },
    { "saftnndbar", RTFControlType::FLAG, RTFKeyword::SAFTNNDBAR, 0 },
    { "saftnndbnum", RTFControlType::FLAG, RTFKeyword::SAFTNNDBNUM, 0 },
    { "saftnndbnumd", RTFControlType::FLAG, RTFKeyword::SAFTNNDBNUMD, 0 },
    { "saftnndbnumk", RTFControlType::FLAG, RTFKeyword::SAFTNNDBNUMK, 0 },
    { "saftnndbnumt", RTFControlType::FLAG, RTFKeyword::SAFTNNDBNUMT, 0 },
    { "saftnnganada", RTFControlType::FLAG, RTFKeyword::SAFTNNGANADA, 0 },
    { "saftnngbnum", RTFControlType::FLAG, RTFKeyword::SAFTNNGBNUM, 0 },
    { "saftnngbnumd", RTFControlType::FLAG, RTFKeyword::SAFTNNGBNUMD, 0 },
    { "saftnngbnumk", RTFControlType::FLAG, RTFKeyword::SAFTNNGBNUMK, 0 },
    { "saftnngbnuml", RTFControlType::FLAG, RTFKeyword::SAFTNNGBNUML, 0 },
    { "saftnnrlc", RTFControlType::FLAG, RTFKeyword::SAFTNNRLC, 0 },
    { "saftnnruc", RTFControlType::FLAG, RTFKeyword::SAFTNNRUC, 0 },
    { "saftnnzodiac", RTFControlType::FLAG, RTFKeyword::SAFTNNZODIAC, 0 },
    { "saftnnzodiacd", RTFControlType::FLAG, RTFKeyword::SAFTNNZODIACD, 0 },
    { "saftnnzodiacl", RTFControlType::FLAG, RTFKeyword::SAFTNNZODIACL, 0 },
    { "saftnrestart", RTFControlType::FLAG, RTFKeyword::SAFTNRESTART, 0 },
    { "saftnrstcont", RTFControlType::FLAG, RTFKeyword::SAFTNRSTCONT, 0 },
    { "saftnstart", RTFControlType::VALUE, RTFKeyword::SAFTNSTART, 1 },
    { "sautoupd", RTFControlType::FLAG, RTFKeyword::SAUTOUPD, 0 },
    { "saveinvalidxml", RTFControlType::FLAG, RTFKeyword::SAVEINVALIDXML, 0 },
    { "saveprevpict", RTFControlType::FLAG, RTFKeyword::SAVEPREVPICT, 0 },
    { "sb", RTFControlType::VALUE, RTFKeyword::SB, 0 },
    { "sbasedon", RTFControlType::VALUE, RTFKeyword::SBASEDON, 222 },
    { "sbauto", RTFControlType::TOGGLE, RTFKeyword::SBAUTO, 1 },
    { "sbkcol", RTFControlType::FLAG, RTFKeyword::SBKCOL, 0 },
    { "sbkeven", RTFControlType::FLAG, RTFKeyword::SBKEVEN, 0 },
    { "sbknone", RTFControlType::FLAG, RTFKeyword::SBKNONE, 0 },
    { "sbkodd", RTFControlType::FLAG, RTFKeyword::SBKODD, 0 },
    { "sbkpage", RTFControlType::FLAG, RTFKeyword::SBKPAGE, 0 },
    { "sbys", RTFControlType::FLAG, RTFKeyword::SBYS, 0 },
    { "scaps", RTFControlType::TOGGLE, RTFKeyword::SCAPS, 1 },
    { "scompose", RTFControlType::FLAG, RTFKeyword::SCOMPOSE, 0 },
    { "sec", RTFControlType::VALUE, RTFKeyword::SEC, 0 },
    { "sect", RTFControlType::SYMBOL, RTFKeyword::SECT, 0 },
    { "sectd", RTFControlType::FLAG, RTFKeyword::SECTD, 0 },
    { "sectdefaultcl", RTFControlType::FLAG, RTFKeyword::SECTDEFAULTCL, 0 },
    { "sectexpand", RTFControlType::VALUE, RTFKeyword::SECTEXPAND, 0 },
    { "sectlinegrid", RTFControlType::VALUE, RTFKeyword::SECTLINEGRID, 0 },
    { "sectnum", RTFControlType::SYMBOL, RTFKeyword::SECTNUM, 0 },
    { "sectrsid", RTFControlType::VALUE, RTFKeyword::SECTRSID, 0 },
    { "sectspecifycl", RTFControlType::FLAG, RTFKeyword::SECTSPECIFYCL, 0 },
    { "sectspecifygenN", RTFControlType::FLAG, RTFKeyword::SECTSPECIFYGENN, 0 },
    { "sectspecifyl", RTFControlType::FLAG, RTFKeyword::SECTSPECIFYL, 0 },
    { "sectunlocked", RTFControlType::FLAG, RTFKeyword::SECTUNLOCKED, 0 },
    { "sftnbj", RTFControlType::FLAG, RTFKeyword::SFTNBJ, 0 },
    { "sftnnalc", RTFControlType::FLAG, RTFKeyword::SFTNNALC, 0 },
    { "sftnnar", RTFControlType::FLAG, RTFKeyword::SFTNNAR, 0 },
    { "sftnnauc", RTFControlType::FLAG, RTFKeyword::SFTNNAUC, 0 },
    { "sftnnchi", RTFControlType::FLAG, RTFKeyword::SFTNNCHI, 0 },
    { "sftnnchosung", RTFControlType::FLAG, RTFKeyword::SFTNNCHOSUNG, 0 },
    { "sftnncnum", RTFControlType::FLAG, RTFKeyword::SFTNNCNUM, 0 },
    { "sftnndbar", RTFControlType::FLAG, RTFKeyword::SFTNNDBAR, 0 },
    { "sftnndbnum", RTFControlType::FLAG, RTFKeyword::SFTNNDBNUM, 0 },
    { "sftnndbnumd", RTFControlType::FLAG, RTFKeyword::SFTNNDBNUMD, 0 },
    { "sftnndbnumk", RTFControlType::FLAG, RTFKeyword::SFTNNDBNUMK, 0 },
    { "sftnndbnumt", RTFControlType::FLAG, RTFKeyword::SFTNNDBNUMT, 0 },
    { "sftnnganada", RTFControlType::FLAG, RTFKeyword::SFTNNGANADA, 0 },
    { "sftnngbnum", RTFControlType::FLAG, RTFKeyword::SFTNNGBNUM, 0 },
    { "sftnngbnumd", RTFControlType::FLAG, RTFKeyword::SFTNNGBNUMD, 0 },
    { "sftnngbnumk", RTFControlType::FLAG, RTFKeyword::SFTNNGBNUMK, 0 },
    { "sftnngbnuml", RTFControlType::FLAG, RTFKeyword::SFTNNGBNUML, 0 },
    { "sftnnrlc", RTFControlType::FLAG, RTFKeyword::SFTNNRLC, 0 },
    { "sftnnruc", RTFControlType::FLAG, RTFKeyword::SFTNNRUC, 0 },
    { "sftnnzodiac", RTFControlType::FLAG, RTFKeyword::SFTNNZODIAC, 0 },
    { "sftnnzodiacd", RTFControlType::FLAG, RTFKeyword::SFTNNZODIACD, 0 },
    { "sftnnzodiacl", RTFControlType::FLAG, RTFKeyword::SFTNNZODIACL, 0 },
    { "sftnrestart", RTFControlType::FLAG, RTFKeyword::SFTNRESTART, 0 },
    { "sftnrstcont", RTFControlType::FLAG, RTFKeyword::SFTNRSTCONT, 0 },
    { "sftnrstpg", RTFControlType::FLAG, RTFKeyword::SFTNRSTPG, 0 },
    { "sftnstart", RTFControlType::VALUE, RTFKeyword::SFTNSTART, 1 },
    { "sftntj", RTFControlType::FLAG, RTFKeyword::SFTNTJ, 0 },
    { "shad", RTFControlType::TOGGLE, RTFKeyword::SHAD, 1 },
    { "shading", RTFControlType::VALUE, RTFKeyword::SHADING, 0 },
    { "shidden", RTFControlType::FLAG, RTFKeyword::SHIDDEN, 0 },
    { "shift", RTFControlType::FLAG, RTFKeyword::SHIFT, 0 },
    { "showplaceholdtext", RTFControlType::VALUE, RTFKeyword::SHOWPLACEHOLDTEXT, 0 },
    { "showxmlerrors", RTFControlType::VALUE, RTFKeyword::SHOWXMLERRORS, 0 },
    { "shp", RTFControlType::DESTINATION, RTFKeyword::SHP, 0 },
    { "shpbottom", RTFControlType::VALUE, RTFKeyword::SHPBOTTOM, 0 },
    { "shpbxcolumn", RTFControlType::FLAG, RTFKeyword::SHPBXCOLUMN, 0 },
    { "shpbxignore", RTFControlType::FLAG, RTFKeyword::SHPBXIGNORE, 0 },
    { "shpbxmargin", RTFControlType::FLAG, RTFKeyword::SHPBXMARGIN, 0 },
    { "shpbxpage", RTFControlType::FLAG, RTFKeyword::SHPBXPAGE, 0 },
    { "shpbyignore", RTFControlType::FLAG, RTFKeyword::SHPBYIGNORE, 0 },
    { "shpbymargin", RTFControlType::FLAG, RTFKeyword::SHPBYMARGIN, 0 },
    { "shpbypage", RTFControlType::FLAG, RTFKeyword::SHPBYPAGE, 0 },
    { "shpbypara", RTFControlType::FLAG, RTFKeyword::SHPBYPARA, 0 },
    { "shpfblwtxt", RTFControlType::VALUE, RTFKeyword::SHPFBLWTXT, 0 },
    { "shpfhdr", RTFControlType::VALUE, RTFKeyword::SHPFHDR, 0 },
    { "shpgrp", RTFControlType::DESTINATION, RTFKeyword::SHPGRP, 0 },
    { "shpinst", RTFControlType::DESTINATION, RTFKeyword::SHPINST, 0 },
    { "shpleft", RTFControlType::VALUE, RTFKeyword::SHPLEFT, 0 },
    { "shplid", RTFControlType::VALUE, RTFKeyword::SHPLID, 0 },
    { "shplockanchor", RTFControlType::FLAG, RTFKeyword::SHPLOCKANCHOR, 0 },
    { "shppict", RTFControlType::DESTINATION, RTFKeyword::SHPPICT, 0 },
    { "shpright", RTFControlType::VALUE, RTFKeyword::SHPRIGHT, 0 },
    { "shprslt", RTFControlType::DESTINATION, RTFKeyword::SHPRSLT, 0 },
    { "shptop", RTFControlType::VALUE, RTFKeyword::SHPTOP, 0 },
    { "shptxt", RTFControlType::DESTINATION, RTFKeyword::SHPTXT, 0 },
    { "shpwrk", RTFControlType::VALUE, RTFKeyword::SHPWRK, 0 },
    { "shpwr", RTFControlType::VALUE, RTFKeyword::SHPWR, 0 },
    { "shpz", RTFControlType::VALUE, RTFKeyword::SHPZ, 0 },
    { "sl", RTFControlType::VALUE, RTFKeyword::SL, 0 },
    { "slink", RTFControlType::VALUE, RTFKeyword::SLINK, 0 },
    { "slmult", RTFControlType::VALUE, RTFKeyword::SLMULT, 0 },
    { "slocked", RTFControlType::FLAG, RTFKeyword::SLOCKED, 0 },
    { "sn", RTFControlType::DESTINATION, RTFKeyword::SN, 0 },
    { "snaptogridincell", RTFControlType::FLAG, RTFKeyword::SNAPTOGRIDINCELL, 0 },
    { "snext", RTFControlType::VALUE, RTFKeyword::SNEXT, 0 },
    { "softcol", RTFControlType::FLAG, RTFKeyword::SOFTCOL, 0 },
    { "softlheight", RTFControlType::VALUE, RTFKeyword::SOFTLHEIGHT, 0 },
    { "softline", RTFControlType::FLAG, RTFKeyword::SOFTLINE, 0 },
    { "softpage", RTFControlType::FLAG, RTFKeyword::SOFTPAGE, 0 },
    { "sp", RTFControlType::DESTINATION, RTFKeyword::SP, 0 },
    { "spersonal", RTFControlType::FLAG, RTFKeyword::SPERSONAL, 0 },
    { "spltpgpar", RTFControlType::FLAG, RTFKeyword::SPLTPGPAR, 0 },
    { "splytwnine", RTFControlType::FLAG, RTFKeyword::SPLYTWNINE, 0 },
    { "spriority", RTFControlType::VALUE, RTFKeyword::SPRIORITY, 0 },
    { "sprsbsp", RTFControlType::FLAG, RTFKeyword::SPRSBSP, 0 },
    { "sprslnsp", RTFControlType::FLAG, RTFKeyword::SPRSLNSP, 0 },
    { "sprsspbf", RTFControlType::FLAG, RTFKeyword::SPRSSPBF, 0 },
    { "sprstsm", RTFControlType::FLAG, RTFKeyword::SPRSTSM, 0 },
    { "sprstsp", RTFControlType::FLAG, RTFKeyword::SPRSTSP, 0 },
    { "spv", RTFControlType::FLAG, RTFKeyword::SPV, 0 },
    { "sqformat", RTFControlType::FLAG, RTFKeyword::SQFORMAT, 0 },
    { "srauth", RTFControlType::VALUE, RTFKeyword::SRAUTH, 0 },
    { "srdate", RTFControlType::VALUE, RTFKeyword::SRDATE, 0 },
    { "sreply", RTFControlType::FLAG, RTFKeyword::SREPLY, 0 },
    { "ssemihidden", RTFControlType::VALUE, RTFKeyword::SSEMIHIDDEN, 0 },
    { "staticval", RTFControlType::DESTINATION, RTFKeyword::STATICVAL, 0 },
    { "stextflow", RTFControlType::VALUE, RTFKeyword::STEXTFLOW, 0 },
    { "strike", RTFControlType::TOGGLE, RTFKeyword::STRIKE, 1 },
    { "striked", RTFControlType::TOGGLE, RTFKeyword::STRIKED, 1 },
    { "stshfbi", RTFControlType::VALUE, RTFKeyword::STSHFBI, 0 },
    { "stshfdbch", RTFControlType::VALUE, RTFKeyword::STSHFDBCH, 0 },
    { "stshfhich", RTFControlType::VALUE, RTFKeyword::STSHFHICH, 0 },
    { "stshfloch", RTFControlType::VALUE, RTFKeyword::STSHFLOCH, 0 },
    { "stylelock", RTFControlType::FLAG, RTFKeyword::STYLELOCK, 0 },
    { "stylelockbackcomp", RTFControlType::FLAG, RTFKeyword::STYLELOCKBACKCOMP, 0 },
    { "stylelockenforced", RTFControlType::FLAG, RTFKeyword::STYLELOCKENFORCED, 0 },
    { "stylelockqfset", RTFControlType::FLAG, RTFKeyword::STYLELOCKQFSET, 0 },
    { "stylelocktheme", RTFControlType::FLAG, RTFKeyword::STYLELOCKTHEME, 0 },
    { "stylesheet", RTFControlType::DESTINATION, RTFKeyword::STYLESHEET, 0 },
    { "stylesortmethod", RTFControlType::VALUE, RTFKeyword::STYLESORTMETHOD, 1 },
    { "styrsid", RTFControlType::VALUE, RTFKeyword::STYRSID, 0 },
    { "sub", RTFControlType::FLAG, RTFKeyword::SUB, 0 },
    { "subdocument", RTFControlType::VALUE, RTFKeyword::SUBDOCUMENT, 0 },
    { "subfontbysize", RTFControlType::FLAG, RTFKeyword::SUBFONTBYSIZE, 0 },
    { "subject", RTFControlType::DESTINATION, RTFKeyword::SUBJECT, 0 },
    { "sunhideused", RTFControlType::VALUE, RTFKeyword::SUNHIDEUSED, 0 },
    { "super", RTFControlType::FLAG, RTFKeyword::SUPER, 0 },
    { "sv", RTFControlType::DESTINATION, RTFKeyword::SV, 0 },
    { "svb", RTFControlType::DESTINATION, RTFKeyword::SVB, 0 },
    { "swpbdr", RTFControlType::FLAG, RTFKeyword::SWPBDR, 0 },
    { "tab", RTFControlType::SYMBOL, RTFKeyword::TAB, 0 },
    { "tabsnoovrlp", RTFControlType::FLAG, RTFKeyword::TABSNOOVRLP, 0 },
    { "taprtl", RTFControlType::FLAG, RTFKeyword::TAPRTL, 0 },
    { "tb", RTFControlType::VALUE, RTFKeyword::TB, 0 },
    { "tblind", RTFControlType::VALUE, RTFKeyword::TBLIND, 0 },
    { "tblindtype", RTFControlType::VALUE, RTFKeyword::TBLINDTYPE, 0 },
    { "tbllkbestfit", RTFControlType::FLAG, RTFKeyword::TBLLKBESTFIT, 0 },
    { "tbllkborder", RTFControlType::FLAG, RTFKeyword::TBLLKBORDER, 0 },
    { "tbllkcolor", RTFControlType::FLAG, RTFKeyword::TBLLKCOLOR, 0 },
    { "tbllkfont", RTFControlType::FLAG, RTFKeyword::TBLLKFONT, 0 },
    { "tbllkhdrcols", RTFControlType::FLAG, RTFKeyword::TBLLKHDRCOLS, 0 },
    { "tbllkhdrrows", RTFControlType::FLAG, RTFKeyword::TBLLKHDRROWS, 0 },
    { "tbllklastcol", RTFControlType::FLAG, RTFKeyword::TBLLKLASTCOL, 0 },
    { "tbllklastrow", RTFControlType::FLAG, RTFKeyword::TBLLKLASTROW, 0 },
    { "tbllknocolband", RTFControlType::FLAG, RTFKeyword::TBLLKNOCOLBAND, 0 },
    { "tbllknorowband", RTFControlType::FLAG, RTFKeyword::TBLLKNOROWBAND, 0 },
    { "tbllkshading", RTFControlType::FLAG, RTFKeyword::TBLLKSHADING, 0 },
    { "tblrsid", RTFControlType::VALUE, RTFKeyword::TBLRSID, 0 },
    { "tc", RTFControlType::DESTINATION, RTFKeyword::TC, 0 },
    { "tcelld", RTFControlType::FLAG, RTFKeyword::TCELLD, 0 },
    { "tcf", RTFControlType::VALUE, RTFKeyword::TCF, 67 },
    { "tcl", RTFControlType::VALUE, RTFKeyword::TCL, 0 },
    { "tcn", RTFControlType::FLAG, RTFKeyword::TCN, 0 },
    { "tdfrmtxtBottom", RTFControlType::VALUE, RTFKeyword::TDFRMTXTBOTTOM, 0 },
    { "tdfrmtxtLeft", RTFControlType::VALUE, RTFKeyword::TDFRMTXTLEFT, 0 },
    { "tdfrmtxtRight", RTFControlType::VALUE, RTFKeyword::TDFRMTXTRIGHT, 0 },
    { "tdfrmtxtTop", RTFControlType::VALUE, RTFKeyword::TDFRMTXTTOP, 0 },
    { "template", RTFControlType::DESTINATION, RTFKeyword::TEMPLATE, 0 },
    { "themedata", RTFControlType::DESTINATION, RTFKeyword::THEMEDATA, 0 },
    { "themelang", RTFControlType::VALUE, RTFKeyword::THEMELANG, 0 },
    { "themelangcs", RTFControlType::VALUE, RTFKeyword::THEMELANGCS, 0 },
    { "themelangfe", RTFControlType::VALUE, RTFKeyword::THEMELANGFE, 0 },
    { "time", RTFControlType::FLAG, RTFKeyword::TIME, 0 },
    { "title", RTFControlType::DESTINATION, RTFKeyword::TITLE, 0 },
    { "titlepg", RTFControlType::FLAG, RTFKeyword::TITLEPG, 0 },
    { "tldot", RTFControlType::FLAG, RTFKeyword::TLDOT, 0 },
    { "tleq", RTFControlType::FLAG, RTFKeyword::TLEQ, 0 },
    { "tlhyph", RTFControlType::FLAG, RTFKeyword::TLHYPH, 0 },
    { "tlmdot", RTFControlType::FLAG, RTFKeyword::TLMDOT, 0 },
    { "tlth", RTFControlType::FLAG, RTFKeyword::TLTH, 0 },
    { "tlul", RTFControlType::FLAG, RTFKeyword::TLUL, 0 },
    { "toplinepunct", RTFControlType::FLAG, RTFKeyword::TOPLINEPUNCT, 0 },
    { "tphcol", RTFControlType::FLAG, RTFKeyword::TPHCOL, 0 },
    { "tphmrg", RTFControlType::FLAG, RTFKeyword::TPHMRG, 0 },
    { "tphpg", RTFControlType::FLAG, RTFKeyword::TPHPG, 0 },
    { "tposnegx", RTFControlType::VALUE, RTFKeyword::TPOSNEGX, 0 },
    { "tposnegy", RTFControlType::VALUE, RTFKeyword::TPOSNEGY, 0 },
    { "tposxc", RTFControlType::FLAG, RTFKeyword::TPOSXC, 0 },
    { "tposxi", RTFControlType::FLAG, RTFKeyword::TPOSXI, 0 },
    { "tposxl", RTFControlType::FLAG, RTFKeyword::TPOSXL, 0 },
    { "tposx", RTFControlType::VALUE, RTFKeyword::TPOSX, 0 },
    { "tposxo", RTFControlType::FLAG, RTFKeyword::TPOSXO, 0 },
    { "tposxr", RTFControlType::FLAG, RTFKeyword::TPOSXR, 0 },
    { "tposy", RTFControlType::VALUE, RTFKeyword::TPOSY, 0 },
    { "tposyb", RTFControlType::FLAG, RTFKeyword::TPOSYB, 0 },
    { "tposyc", RTFControlType::FLAG, RTFKeyword::TPOSYC, 0 },
    { "tposyil", RTFControlType::FLAG, RTFKeyword::TPOSYIL, 0 },
    { "tposyin", RTFControlType::FLAG, RTFKeyword::TPOSYIN, 0 },
    { "tposyout", RTFControlType::FLAG, RTFKeyword::TPOSYOUT, 0 },
    { "tposyt", RTFControlType::FLAG, RTFKeyword::TPOSYT, 0 },
    { "tpvmrg", RTFControlType::FLAG, RTFKeyword::TPVMRG, 0 },
    { "tpvpara", RTFControlType::FLAG, RTFKeyword::TPVPARA, 0 },
    { "tpvpg", RTFControlType::FLAG, RTFKeyword::TPVPG, 0 },
    { "tqc", RTFControlType::FLAG, RTFKeyword::TQC, 0 },
    { "tqdec", RTFControlType::FLAG, RTFKeyword::TQDEC, 0 },
    { "tqr", RTFControlType::FLAG, RTFKeyword::TQR, 0 },
    { "trackformatting", RTFControlType::VALUE, RTFKeyword::TRACKFORMATTING, 0 },
    { "trackmoves", RTFControlType::VALUE, RTFKeyword::TRACKMOVES, 0 },
    { "transmf", RTFControlType::FLAG, RTFKeyword::TRANSMF, 0 },
    { "trauth", RTFControlType::VALUE, RTFKeyword::TRAUTH, 0 },
    { "trautofit", RTFControlType::TOGGLE, RTFKeyword::TRAUTOFIT, 1 },
    { "trbgbdiag", RTFControlType::FLAG, RTFKeyword::TRBGBDIAG, 0 },
    { "trbgcross", RTFControlType::FLAG, RTFKeyword::TRBGCROSS, 0 },
    { "trbgdcross", RTFControlType::FLAG, RTFKeyword::TRBGDCROSS, 0 },
    { "trbgdkbdiag", RTFControlType::FLAG, RTFKeyword::TRBGDKBDIAG, 0 },
    { "trbgdkcross", RTFControlType::FLAG, RTFKeyword::TRBGDKCROSS, 0 },
    { "trbgdkdcross", RTFControlType::FLAG, RTFKeyword::TRBGDKDCROSS, 0 },
    { "trbgdkfdiag", RTFControlType::FLAG, RTFKeyword::TRBGDKFDIAG, 0 },
    { "trbgdkhor", RTFControlType::FLAG, RTFKeyword::TRBGDKHOR, 0 },
    { "trbgdkvert", RTFControlType::FLAG, RTFKeyword::TRBGDKVERT, 0 },
    { "trbgfdiag", RTFControlType::FLAG, RTFKeyword::TRBGFDIAG, 0 },
    { "trbghoriz", RTFControlType::FLAG, RTFKeyword::TRBGHORIZ, 0 },
    { "trbgvert", RTFControlType::FLAG, RTFKeyword::TRBGVERT, 0 },
    { "trbrdrb", RTFControlType::FLAG, RTFKeyword::TRBRDRB, 0 },
    { "trbrdrh", RTFControlType::FLAG, RTFKeyword::TRBRDRH, 0 },
    { "trbrdrl", RTFControlType::FLAG, RTFKeyword::TRBRDRL, 0 },
    { "trbrdrr", RTFControlType::FLAG, RTFKeyword::TRBRDRR, 0 },
    { "trbrdrt", RTFControlType::FLAG, RTFKeyword::TRBRDRT, 0 },
    { "trbrdrv", RTFControlType::FLAG, RTFKeyword::TRBRDRV, 0 },
    { "trcbpat", RTFControlType::VALUE, RTFKeyword::TRCBPAT, 0 },
    { "trcfpat", RTFControlType::VALUE, RTFKeyword::TRCFPAT, 0 },
    { "trdate", RTFControlType::VALUE, RTFKeyword::TRDATE, 0 },
    { "trftsWidthA", RTFControlType::VALUE, RTFKeyword::TRFTSWIDTHA, 0 },
    { "trftsWidthB", RTFControlType::VALUE, RTFKeyword::TRFTSWIDTHB, 0 },
    { "trftsWidth", RTFControlType::VALUE, RTFKeyword::TRFTSWIDTH, 0 },
    { "trgaph", RTFControlType::VALUE, RTFKeyword::TRGAPH, 0 },
    { "trhdr", RTFControlType::FLAG, RTFKeyword::TRHDR, 0 },
    { "trkeep", RTFControlType::FLAG, RTFKeyword::TRKEEP, 0 },
    { "trkeepfollow", RTFControlType::FLAG, RTFKeyword::TRKEEPFOLLOW, 0 },
    { "trleft", RTFControlType::VALUE, RTFKeyword::TRLEFT, 0 },
    { "trowd", RTFControlType::FLAG, RTFKeyword::TROWD, 0 },
    { "trpaddb", RTFControlType::VALUE, RTFKeyword::TRPADDB, 0 },
    { "trpaddfb", RTFControlType::VALUE, RTFKeyword::TRPADDFB, 0 },
    { "trpaddfl", RTFControlType::VALUE, RTFKeyword::TRPADDFL, 0 },
    { "trpaddfr", RTFControlType::VALUE, RTFKeyword::TRPADDFR, 0 },
    { "trpaddft", RTFControlType::VALUE, RTFKeyword::TRPADDFT, 0 },
    { "trpaddl", RTFControlType::VALUE, RTFKeyword::TRPADDL, 0 },
    { "trpaddr", RTFControlType::VALUE, RTFKeyword::TRPADDR, 0 },
    { "trpaddt", RTFControlType::VALUE, RTFKeyword::TRPADDT, 0 },
    { "trpadob", RTFControlType::VALUE, RTFKeyword::TRPADOB, 0 },
    { "trpadofb", RTFControlType::VALUE, RTFKeyword::TRPADOFB, 0 },
    { "trpadofl", RTFControlType::VALUE, RTFKeyword::TRPADOFL, 0 },
    { "trpadofr", RTFControlType::VALUE, RTFKeyword::TRPADOFR, 0 },
    { "trpadoft", RTFControlType::VALUE, RTFKeyword::TRPADOFT, 0 },
    { "trpadol", RTFControlType::VALUE, RTFKeyword::TRPADOL, 0 },
    { "trpador", RTFControlType::VALUE, RTFKeyword::TRPADOR, 0 },
    { "trpadot", RTFControlType::VALUE, RTFKeyword::TRPADOT, 0 },
    { "trpat", RTFControlType::VALUE, RTFKeyword::TRPAT, 0 },
    { "trqc", RTFControlType::FLAG, RTFKeyword::TRQC, 0 },
    { "trql", RTFControlType::FLAG, RTFKeyword::TRQL, 0 },
    { "trqr", RTFControlType::FLAG, RTFKeyword::TRQR, 0 },
    { "trrh", RTFControlType::VALUE, RTFKeyword::TRRH, 0 },
    { "trshdng", RTFControlType::VALUE, RTFKeyword::TRSHDNG, 0 },
    { "trspdb", RTFControlType::VALUE, RTFKeyword::TRSPDB, 0 },
    { "trspdfb", RTFControlType::VALUE, RTFKeyword::TRSPDFB, 0 },
    { "trspdfl", RTFControlType::VALUE, RTFKeyword::TRSPDFL, 0 },
    { "trspdfr", RTFControlType::VALUE, RTFKeyword::TRSPDFR, 0 },
    { "trspdft", RTFControlType::VALUE, RTFKeyword::TRSPDFT, 0 },
    { "trspdl", RTFControlType::VALUE, RTFKeyword::TRSPDL, 0 },
    { "trspdr", RTFControlType::VALUE, RTFKeyword::TRSPDR, 0 },
    { "trspdt", RTFControlType::VALUE, RTFKeyword::TRSPDT, 0 },
    { "trspob", RTFControlType::VALUE, RTFKeyword::TRSPOB, 0 },
    { "trspofb", RTFControlType::VALUE, RTFKeyword::TRSPOFB, 0 },
    { "trspofl", RTFControlType::VALUE, RTFKeyword::TRSPOFL, 0 },
    { "trspofr", RTFControlType::VALUE, RTFKeyword::TRSPOFR, 0 },
    { "trspoft", RTFControlType::VALUE, RTFKeyword::TRSPOFT, 0 },
    { "trspol", RTFControlType::VALUE, RTFKeyword::TRSPOL, 0 },
    { "trspor", RTFControlType::VALUE, RTFKeyword::TRSPOR, 0 },
    { "trspot", RTFControlType::VALUE, RTFKeyword::TRSPOT, 0 },
    { "truncatefontheight", RTFControlType::FLAG, RTFKeyword::TRUNCATEFONTHEIGHT, 0 },
    { "truncex", RTFControlType::FLAG, RTFKeyword::TRUNCEX, 0 },
    { "trwWidthA", RTFControlType::VALUE, RTFKeyword::TRWWIDTHA, 0 },
    { "trwWidthB", RTFControlType::VALUE, RTFKeyword::TRWWIDTHB, 0 },
    { "trwWidth", RTFControlType::VALUE, RTFKeyword::TRWWIDTH, 0 },
    { "ts", RTFControlType::VALUE, RTFKeyword::TS, 0 },
    { "tsbgbdiag", RTFControlType::FLAG, RTFKeyword::TSBGBDIAG, 0 },
    { "tsbgcross", RTFControlType::FLAG, RTFKeyword::TSBGCROSS, 0 },
    { "tsbgdcross", RTFControlType::FLAG, RTFKeyword::TSBGDCROSS, 0 },
    { "tsbgdkbdiag", RTFControlType::FLAG, RTFKeyword::TSBGDKBDIAG, 0 },
    { "tsbgdkcross", RTFControlType::FLAG, RTFKeyword::TSBGDKCROSS, 0 },
    { "tsbgdkdcross", RTFControlType::FLAG, RTFKeyword::TSBGDKDCROSS, 0 },
    { "tsbgdkfdiag", RTFControlType::FLAG, RTFKeyword::TSBGDKFDIAG, 0 },
    { "tsbgdkhor", RTFControlType::FLAG, RTFKeyword::TSBGDKHOR, 0 },
    { "tsbgdkvert", RTFControlType::FLAG, RTFKeyword::TSBGDKVERT, 0 },
    { "tsbgfdiag", RTFControlType::FLAG, RTFKeyword::TSBGFDIAG, 0 },
    { "tsbghoriz", RTFControlType::FLAG, RTFKeyword::TSBGHORIZ, 0 },
    { "tsbgvert", RTFControlType::FLAG, RTFKeyword::TSBGVERT, 0 },
    { "tsbrdrb", RTFControlType::FLAG, RTFKeyword::TSBRDRB, 0 },
    { "tsbrdrdgl", RTFControlType::FLAG, RTFKeyword::TSBRDRDGL, 0 },
    { "tsbrdrdgr", RTFControlType::FLAG, RTFKeyword::TSBRDRDGR, 0 },
    { "tsbrdrh", RTFControlType::FLAG, RTFKeyword::TSBRDRH, 0 },
    { "tsbrdrl", RTFControlType::FLAG, RTFKeyword::TSBRDRL, 0 },
    { "tsbrdrr", RTFControlType::FLAG, RTFKeyword::TSBRDRR, 0 },
    { "tsbrdrt", RTFControlType::FLAG, RTFKeyword::TSBRDRT, 0 },
    { "tsbrdrv", RTFControlType::FLAG, RTFKeyword::TSBRDRV, 0 },
    { "tscbandhorzeven", RTFControlType::FLAG, RTFKeyword::TSCBANDHORZEVEN, 0 },
    { "tscbandhorzodd", RTFControlType::FLAG, RTFKeyword::TSCBANDHORZODD, 0 },
    { "tscbandsh", RTFControlType::VALUE, RTFKeyword::TSCBANDSH, 0 },
    { "tscbandsv", RTFControlType::VALUE, RTFKeyword::TSCBANDSV, 0 },
    { "tscbandverteven", RTFControlType::FLAG, RTFKeyword::TSCBANDVERTEVEN, 0 },
    { "tscbandvertodd", RTFControlType::FLAG, RTFKeyword::TSCBANDVERTODD, 0 },
    { "tscellcbpat", RTFControlType::VALUE, RTFKeyword::TSCELLCBPAT, 0 },
    { "tscellcfpat", RTFControlType::VALUE, RTFKeyword::TSCELLCFPAT, 0 },
    { "tscellpaddb", RTFControlType::VALUE, RTFKeyword::TSCELLPADDB, 0 },
    { "tscellpaddfb", RTFControlType::VALUE, RTFKeyword::TSCELLPADDFB, 0 },
    { "tscellpaddfl", RTFControlType::VALUE, RTFKeyword::TSCELLPADDFL, 0 },
    { "tscellpaddfr", RTFControlType::VALUE, RTFKeyword::TSCELLPADDFR, 0 },
    { "tscellpaddft", RTFControlType::VALUE, RTFKeyword::TSCELLPADDFT, 0 },
    { "tscellpaddl", RTFControlType::VALUE, RTFKeyword::TSCELLPADDL, 0 },
    { "tscellpaddr", RTFControlType::VALUE, RTFKeyword::TSCELLPADDR, 0 },
    { "tscellpaddt", RTFControlType::VALUE, RTFKeyword::TSCELLPADDT, 0 },
    { "tscellpct", RTFControlType::VALUE, RTFKeyword::TSCELLPCT, 0 },
    { "tscellwidth", RTFControlType::VALUE, RTFKeyword::TSCELLWIDTH, 0 },
    { "tscellwidthfts", RTFControlType::VALUE, RTFKeyword::TSCELLWIDTHFTS, 0 },
    { "tscfirstcol", RTFControlType::FLAG, RTFKeyword::TSCFIRSTCOL, 0 },
    { "tscfirstrow", RTFControlType::FLAG, RTFKeyword::TSCFIRSTROW, 0 },
    { "tsclastcol", RTFControlType::FLAG, RTFKeyword::TSCLASTCOL, 0 },
    { "tsclastrow", RTFControlType::FLAG, RTFKeyword::TSCLASTROW, 0 },
    { "tscnecell", RTFControlType::FLAG, RTFKeyword::TSCNECELL, 0 },
    { "tscnwcell", RTFControlType::FLAG, RTFKeyword::TSCNWCELL, 0 },
    { "tscsecell", RTFControlType::FLAG, RTFKeyword::TSCSECELL, 0 },
    { "tscswcell", RTFControlType::FLAG, RTFKeyword::TSCSWCELL, 0 },
    { "tsd", RTFControlType::FLAG, RTFKeyword::TSD, 0 },
    { "tsnowrap", RTFControlType::FLAG, RTFKeyword::TSNOWRAP, 0 },
    { "tsrowd", RTFControlType::FLAG, RTFKeyword::TSROWD, 0 },
    { "tsvertalb", RTFControlType::FLAG, RTFKeyword::TSVERTALB, 0 },
    { "tsvertalc", RTFControlType::FLAG, RTFKeyword::TSVERTALC, 0 },
    { "tsvertalt", RTFControlType::FLAG, RTFKeyword::TSVERTALT, 0 },
    { "twoinone", RTFControlType::VALUE, RTFKeyword::TWOINONE, 0 },
    { "twoonone", RTFControlType::FLAG, RTFKeyword::TWOONONE, 0 },
    { "tx", RTFControlType::VALUE, RTFKeyword::TX, 0 },
    { "txbxtwalways", RTFControlType::FLAG, RTFKeyword::TXBXTWALWAYS, 0 },
    { "txbxtwfirst", RTFControlType::FLAG, RTFKeyword::TXBXTWFIRST, 0 },
    { "txbxtwfirstlast", RTFControlType::FLAG, RTFKeyword::TXBXTWFIRSTLAST, 0 },
    { "txbxtwlast", RTFControlType::FLAG, RTFKeyword::TXBXTWLAST, 0 },
    { "txbxtwno", RTFControlType::FLAG, RTFKeyword::TXBXTWNO, 0 },
    { "txe", RTFControlType::DESTINATION, RTFKeyword::TXE, 0 },
    { "u", RTFControlType::VALUE, RTFKeyword::U, 0 },
    { "uc", RTFControlType::VALUE, RTFKeyword::UC, 1 },
    { "ud", RTFControlType::DESTINATION, RTFKeyword::UD, 0 },
    { "ul", RTFControlType::TOGGLE, RTFKeyword::UL, 1 },
    { "ulc", RTFControlType::VALUE, RTFKeyword::ULC, 0 },
    { "uld", RTFControlType::FLAG, RTFKeyword::ULD, 0 },
    { "uldash", RTFControlType::TOGGLE, RTFKeyword::ULDASH, 1 },
    { "uldashd", RTFControlType::TOGGLE, RTFKeyword::ULDASHD, 1 },
    { "uldashdd", RTFControlType::TOGGLE, RTFKeyword::ULDASHDD, 1 },
    { "uldb", RTFControlType::TOGGLE, RTFKeyword::ULDB, 1 },
    { "ulhair", RTFControlType::TOGGLE, RTFKeyword::ULHAIR, 1 },
    { "ulhwave", RTFControlType::TOGGLE, RTFKeyword::ULHWAVE, 1 },
    { "ulldash", RTFControlType::TOGGLE, RTFKeyword::ULLDASH, 1 },
    { "ulnone", RTFControlType::FLAG, RTFKeyword::ULNONE, 0 },
    { "ulth", RTFControlType::TOGGLE, RTFKeyword::ULTH, 1 },
    { "ulthd", RTFControlType::TOGGLE, RTFKeyword::ULTHD, 1 },
    { "ulthdash", RTFControlType::TOGGLE, RTFKeyword::ULTHDASH, 1 },
    { "ulthdashd", RTFControlType::TOGGLE, RTFKeyword::ULTHDASHD, 1 },
    { "ulthdashdd", RTFControlType::TOGGLE, RTFKeyword::ULTHDASHDD, 1 },
    { "ulthldash", RTFControlType::TOGGLE, RTFKeyword::ULTHLDASH, 1 },
    { "ululdbwave", RTFControlType::TOGGLE, RTFKeyword::ULULDBWAVE, 1 },
    { "ulw", RTFControlType::FLAG, RTFKeyword::ULW, 0 },
    { "ulwave", RTFControlType::TOGGLE, RTFKeyword::ULWAVE, 1 },
    { "up", RTFControlType::VALUE, RTFKeyword::UP, 6 },
    { "upr", RTFControlType::DESTINATION, RTFKeyword::UPR, 0 },
    { "urtf", RTFControlType::VALUE, RTFKeyword::URTF, 0 },
    { "useltbaln", RTFControlType::FLAG, RTFKeyword::USELTBALN, 0 },
    { "usenormstyforlist", RTFControlType::FLAG, RTFKeyword::USENORMSTYFORLIST, 0 },
    { "userprops", RTFControlType::DESTINATION, RTFKeyword::USERPROPS, 0 },
    { "usexform", RTFControlType::FLAG, RTFKeyword::USEXFORM, 0 },
    { "utinl", RTFControlType::FLAG, RTFKeyword::UTINL, 0 },
    { "v", RTFControlType::TOGGLE, RTFKeyword::V, 1 },
    { "validatexml", RTFControlType::VALUE, RTFKeyword::VALIDATEXML, 0 },
    { "vern", RTFControlType::VALUE, RTFKeyword::VERN, 0 },
    { "version", RTFControlType::VALUE, RTFKeyword::VERSION, 0 },
    { "vertal", RTFControlType::FLAG, RTFKeyword::VERTAL, 0 },
    { "vertalb", RTFControlType::FLAG, RTFKeyword::VERTALB, 0 },
    { "vertalc", RTFControlType::FLAG, RTFKeyword::VERTALC, 0 },
    { "vertalj", RTFControlType::FLAG, RTFKeyword::VERTALJ, 0 },
    { "vertalt", RTFControlType::FLAG, RTFKeyword::VERTALT, 0 },
    { "vertdoc", RTFControlType::FLAG, RTFKeyword::VERTDOC, 0 },
    { "vertsect", RTFControlType::FLAG, RTFKeyword::VERTSECT, 0 },
    { "viewbksp", RTFControlType::VALUE, RTFKeyword::VIEWBKSP, 0 },
    { "viewkind", RTFControlType::VALUE, RTFKeyword::VIEWKIND, 0 },
    { "viewnobound", RTFControlType::FLAG, RTFKeyword::VIEWNOBOUND, 0 },
    { "viewscale", RTFControlType::VALUE, RTFKeyword::VIEWSCALE, 100 },
    { "viewzk", RTFControlType::VALUE, RTFKeyword::VIEWZK, 0 },
    { "wbitmap", RTFControlType::VALUE, RTFKeyword::WBITMAP, 0 },
    { "wbmbitspixel", RTFControlType::VALUE, RTFKeyword::WBMBITSPIXEL, 1 },
    { "wbmplanes", RTFControlType::VALUE, RTFKeyword::WBMPLANES, 0 },
    { "wbmwidthbyte", RTFControlType::VALUE, RTFKeyword::WBMWIDTHBYTE, 0 },
    { "webhidden", RTFControlType::FLAG, RTFKeyword::WEBHIDDEN, 0 },
    { "wgrffmtfilter", RTFControlType::DESTINATION, RTFKeyword::WGRFFMTFILTER, 0 },
    { "widctlpar", RTFControlType::FLAG, RTFKeyword::WIDCTLPAR, 0 },
    { "widowctrl", RTFControlType::FLAG, RTFKeyword::WIDOWCTRL, 0 },
    { "windowcaption", RTFControlType::DESTINATION, RTFKeyword::WINDOWCAPTION, 0 },
    { "wmetafile", RTFControlType::VALUE, RTFKeyword::WMETAFILE, 1 },
    { "wpeqn", RTFControlType::FLAG, RTFKeyword::WPEQN, 0 },
    { "wpjst", RTFControlType::FLAG, RTFKeyword::WPJST, 0 },
    { "wpsp", RTFControlType::FLAG, RTFKeyword::WPSP, 0 },
    { "wraparound", RTFControlType::FLAG, RTFKeyword::WRAPAROUND, 0 },
    { "wrapdefault", RTFControlType::FLAG, RTFKeyword::WRAPDEFAULT, 0 },
    { "wrapthrough", RTFControlType::FLAG, RTFKeyword::WRAPTHROUGH, 0 },
    { "wraptight", RTFControlType::FLAG, RTFKeyword::WRAPTIGHT, 0 },
    { "wraptrsp", RTFControlType::FLAG, RTFKeyword::WRAPTRSP, 0 },
    { "writereservation", RTFControlType::DESTINATION, RTFKeyword::WRITERESERVATION, 0 },
    { "writereservhash", RTFControlType::DESTINATION, RTFKeyword::WRITERESERVHASH, 0 },
    { "wrppunct", RTFControlType::FLAG, RTFKeyword::WRPPUNCT, 0 },
    { "xe", RTFControlType::DESTINATION, RTFKeyword::XE, 0 },
    { "xef", RTFControlType::VALUE, RTFKeyword::XEF, 0 },
    { "xform", RTFControlType::DESTINATION, RTFKeyword::XFORM, 0 },
    { "xmlattr", RTFControlType::FLAG, RTFKeyword::XMLATTR, 0 },
    { "xmlattrname", RTFControlType::DESTINATION, RTFKeyword::XMLATTRNAME, 0 },
    { "xmlattrns", RTFControlType::VALUE, RTFKeyword::XMLATTRNS, 0 },
    { "xmlattrvalue", RTFControlType::DESTINATION, RTFKeyword::XMLATTRVALUE, 0 },
    { "xmlclose", RTFControlType::DESTINATION, RTFKeyword::XMLCLOSE, 0 },
    { "xmlname", RTFControlType::DESTINATION, RTFKeyword::XMLNAME, 0 },
    { "xmlns", RTFControlType::VALUE, RTFKeyword::XMLNS, 0 },
    { "xmlnstbl", RTFControlType::DESTINATION, RTFKeyword::XMLNSTBL, 0 },
    { "xmlopen", RTFControlType::DESTINATION, RTFKeyword::XMLOPEN, 0 },
    { "xmlsdttcell", RTFControlType::FLAG, RTFKeyword::XMLSDTTCELL, 0 },
    { "xmlsdttpara", RTFControlType::FLAG, RTFKeyword::XMLSDTTPARA, 0 },
    { "xmlsdttregular", RTFControlType::FLAG, RTFKeyword::XMLSDTTREGULAR, 0 },
    { "xmlsdttrow", RTFControlType::FLAG, RTFKeyword::XMLSDTTROW, 0 },
    { "xmlsdttunknown", RTFControlType::FLAG, RTFKeyword::XMLSDTTUNKNOWN, 0 },
    { "yr", RTFControlType::VALUE, RTFKeyword::YR, 0 },
    { "yts", RTFControlType::VALUE, RTFKeyword::YTS, 0 },
    { "yxe", RTFControlType::FLAG, RTFKeyword::YXE, 0 },
    { "zwbo", RTFControlType::SYMBOL, RTFKeyword::ZWBO, 0 },
    { "zwj", RTFControlType::SYMBOL, RTFKeyword::ZWJ, 0 },
    { "zwnbo", RTFControlType::SYMBOL, RTFKeyword::ZWNBO, 0 },
    { "zwnj", RTFControlType::SYMBOL, RTFKeyword::ZWNJ, 0 },
    { "flymaincnt", RTFControlType::DESTINATION, RTFKeyword::FLYMAINCNT, 0 },
    { "flyvert", RTFControlType::VALUE, RTFKeyword::FLYVERT, 0 },
    { "flyhorz", RTFControlType::VALUE, RTFKeyword::FLYHORZ, 0 },
    { "flyanchor", RTFControlType::VALUE, RTFKeyword::FLYANCHOR, 0 },
};
const int nRTFControlWords = SAL_N_ELEMENTS(aRTFControlWords);

RTFMathSymbol const aRTFMathControlWords[] = {
    // eKeyword nToken eDestination
    { RTFKeyword::MOMATH, M_TOKEN(oMath), Destination::MOMATH },
    { RTFKeyword::MF, M_TOKEN(f), Destination::MF },
    { RTFKeyword::MFPR, M_TOKEN(fPr), Destination::MFPR },
    { RTFKeyword::MCTRLPR, M_TOKEN(ctrlPr), Destination::MCTRLPR },
    { RTFKeyword::MNUM, M_TOKEN(num), Destination::MNUM },
    { RTFKeyword::MDEN, M_TOKEN(den), Destination::MDEN },
    { RTFKeyword::MACC, M_TOKEN(acc), Destination::MACC },
    { RTFKeyword::MACCPR, M_TOKEN(accPr), Destination::MACCPR },
    { RTFKeyword::MBAR, M_TOKEN(bar), Destination::MBAR },
    { RTFKeyword::MBARPR, M_TOKEN(barPr), Destination::MBARPR },
    { RTFKeyword::ME, M_TOKEN(e), Destination::ME },
    { RTFKeyword::MD, M_TOKEN(d), Destination::MD },
    { RTFKeyword::MDPR, M_TOKEN(dPr), Destination::MDPR },
    { RTFKeyword::MFUNC, M_TOKEN(func), Destination::MFUNC },
    { RTFKeyword::MFUNCPR, M_TOKEN(funcPr), Destination::MFUNCPR },
    { RTFKeyword::MFNAME, M_TOKEN(fName), Destination::MFNAME },
    { RTFKeyword::MLIMLOW, M_TOKEN(limLow), Destination::MLIMLOW },
    { RTFKeyword::MLIMLOWPR, M_TOKEN(limLowPr), Destination::MLIMLOWPR },
    { RTFKeyword::MLIM, M_TOKEN(lim), Destination::MLIM },
    { RTFKeyword::MM, M_TOKEN(m), Destination::MM },
    { RTFKeyword::MMPR, M_TOKEN(mPr), Destination::MMPR },
    { RTFKeyword::MMR, M_TOKEN(mr), Destination::MMR },
    { RTFKeyword::MNARY, M_TOKEN(nary), Destination::MNARY },
    { RTFKeyword::MNARYPR, M_TOKEN(naryPr), Destination::MNARYPR },
    { RTFKeyword::MSUB, M_TOKEN(sub), Destination::MSUB },
    { RTFKeyword::MSUP, M_TOKEN(sup), Destination::MSUP },
    { RTFKeyword::MLIMUPP, M_TOKEN(limUpp), Destination::MLIMUPP },
    { RTFKeyword::MLIMUPPPR, M_TOKEN(limUppPr), Destination::MLIMUPPPR },
    { RTFKeyword::MGROUPCHR, M_TOKEN(groupChr), Destination::MGROUPCHR },
    { RTFKeyword::MGROUPCHRPR, M_TOKEN(groupChrPr), Destination::MGROUPCHRPR },
    { RTFKeyword::MBORDERBOX, M_TOKEN(borderBox), Destination::MBORDERBOX },
    { RTFKeyword::MBORDERBOXPR, M_TOKEN(borderBoxPr), Destination::MBORDERBOXPR },
    { RTFKeyword::MRAD, M_TOKEN(rad), Destination::MRAD },
    { RTFKeyword::MRADPR, M_TOKEN(radPr), Destination::MRADPR },
    { RTFKeyword::MDEG, M_TOKEN(deg), Destination::MDEG },
    { RTFKeyword::MSSUB, M_TOKEN(sSub), Destination::MSSUB },
    { RTFKeyword::MSSUBPR, M_TOKEN(sSubPr), Destination::MSSUBPR },
    { RTFKeyword::MSSUP, M_TOKEN(sSup), Destination::MSSUP },
    { RTFKeyword::MSSUPPR, M_TOKEN(sSupPr), Destination::MSSUPPR },
    { RTFKeyword::MSSUBSUP, M_TOKEN(sSubSup), Destination::MSSUBSUP },
    { RTFKeyword::MSSUBSUPPR, M_TOKEN(sSubSupPr), Destination::MSSUBSUPPR },
    { RTFKeyword::MSPRE, M_TOKEN(sPre), Destination::MSPRE },
    { RTFKeyword::MSPREPR, M_TOKEN(sPrePr), Destination::MSPREPR },
    { RTFKeyword::MBOX, M_TOKEN(box), Destination::MBOX },
    { RTFKeyword::MEQARR, M_TOKEN(eqArr), Destination::MEQARR },
};
const int nRTFMathControlWords = SAL_N_ELEMENTS(aRTFMathControlWords);

bool RTFMathSymbol::operator<(const RTFMathSymbol& rOther) const
{
    return m_eKeyword < rOther.m_eKeyword;
}

} // namespace writerfilter

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
