// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT
#![allow(deprecated)]

use crate::{ffi, CssSection, StyleProvider};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkCssProvider")]
    pub struct CssProvider(Object<ffi::GtkCssProvider, ffi::GtkCssProviderClass>) @implements StyleProvider;

    match fn {
        type_ => || ffi::gtk_css_provider_get_type(),
    }
}

impl CssProvider {
    #[doc(alias = "gtk_css_provider_new")]
    pub fn new() -> CssProvider {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_css_provider_new()) }
    }

    #[cfg(feature = "v4_12")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_12")))]
    #[doc(alias = "gtk_css_provider_load_from_bytes")]
    pub fn load_from_bytes(&self, data: &glib::Bytes) {
        unsafe {
            ffi::gtk_css_provider_load_from_bytes(self.to_glib_none().0, data.to_glib_none().0);
        }
    }

    #[cfg_attr(feature = "v4_12", deprecated = "Since 4.12")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_css_provider_load_from_data")]
    pub fn load_from_data(&self, data: &str) {
        let length = data.len() as _;
        unsafe {
            ffi::gtk_css_provider_load_from_data(
                self.to_glib_none().0,
                data.to_glib_none().0,
                length,
            );
        }
    }

    #[doc(alias = "gtk_css_provider_load_from_file")]
    pub fn load_from_file(&self, file: &impl IsA<gio::File>) {
        unsafe {
            ffi::gtk_css_provider_load_from_file(
                self.to_glib_none().0,
                file.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_css_provider_load_from_path")]
    pub fn load_from_path(&self, path: impl AsRef<std::path::Path>) {
        unsafe {
            ffi::gtk_css_provider_load_from_path(
                self.to_glib_none().0,
                path.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_css_provider_load_from_resource")]
    pub fn load_from_resource(&self, resource_path: &str) {
        unsafe {
            ffi::gtk_css_provider_load_from_resource(
                self.to_glib_none().0,
                resource_path.to_glib_none().0,
            );
        }
    }

    #[cfg(feature = "v4_12")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_12")))]
    #[doc(alias = "gtk_css_provider_load_from_string")]
    pub fn load_from_string(&self, string: &str) {
        unsafe {
            ffi::gtk_css_provider_load_from_string(self.to_glib_none().0, string.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_css_provider_load_named")]
    pub fn load_named(&self, name: &str, variant: Option<&str>) {
        unsafe {
            ffi::gtk_css_provider_load_named(
                self.to_glib_none().0,
                name.to_glib_none().0,
                variant.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_css_provider_to_string")]
    #[doc(alias = "to_string")]
    pub fn to_str(&self) -> glib::GString {
        unsafe { from_glib_full(ffi::gtk_css_provider_to_string(self.to_glib_none().0)) }
    }

    #[doc(alias = "parsing-error")]
    pub fn connect_parsing_error<F: Fn(&Self, &CssSection, &glib::Error) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn parsing_error_trampoline<
            F: Fn(&CssProvider, &CssSection, &glib::Error) + 'static,
        >(
            this: *mut ffi::GtkCssProvider,
            section: *mut ffi::GtkCssSection,
            error: *mut glib::ffi::GError,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                &from_glib_borrow(section),
                &from_glib_borrow(error),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"parsing-error\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    parsing_error_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for CssProvider {
    fn default() -> Self {
        Self::new()
    }
}

impl std::fmt::Display for CssProvider {
    #[inline]
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        f.write_str(&self.to_str())
    }
}
