//  (C) Copyright John Maddock 2006-7.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#define SC_(x) static_cast<typename table_type<T>::type>(BOOST_JOIN(x, L))
   static const boost::array<boost::array<typename table_type<T>::type, 5>, 792> negative_binomial_quantile_data = {{
      {{ SC_(4.285762786865234375), SC_(0.12698681652545928955078125), SC_(0.097540400922298431396484375), SC_(11.568381290037563253305975817351444024377036234904), SC_(49.67581419477884086070549390307050513757197652133) }}, 
      {{ SC_(4.285762786865234375), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(12.977136041273636067294825573363051160267257422387), SC_(46.43808301937089644496373095130068129633820080023) }}, 
      {{ SC_(4.285762786865234375), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(13.355446548799362499196093574014767375702882517351), SC_(45.626103029359612367556766004407934151298781150048) }}, 
      {{ SC_(4.285762786865234375), SC_(0.12698681652545928955078125), SC_(0.188381969928741455078125), SC_(15.52940284708738793480132106889874510563268887437), SC_(41.360131052208165673316312211602173007116266843573) }}, 
      {{ SC_(4.285762786865234375), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(16.764430009390827897971671993143269955166674809408), SC_(39.199062325902508267047473072514261193252696080063) }}, 
      {{ SC_(4.285762786865234375), SC_(0.12698681652545928955078125), SC_(0.278498232364654541015625), SC_(18.827330684864743271502385688632742201801058689866), SC_(35.937947666898633946380128330076651597919337173838) }}, 
      {{ SC_(4.285762786865234375), SC_(0.12698681652545928955078125), SC_(0.308167040348052978515625), SC_(19.859834305054294539273728119716020535354199181236), SC_(34.447725391983382465551236140743414030393753548228) }}, 
      {{ SC_(4.285762786865234375), SC_(0.12698681652545928955078125), SC_(0.546881496906280517578125), SC_(28.286804773212901440345106101213208895684167630136), SC_(24.86330569705991784268291712045956516535854891059) }}, 
      {{ SC_(4.285762786865234375), SC_(0.12698681652545928955078125), SC_(0.54722058773040771484375), SC_(28.299740373205303221140202770183676832612364871957), SC_(24.851358289573499476668996699249466707769441766967) }}, 
      {{ SC_(4.285762786865234375), SC_(0.12698681652545928955078125), SC_(0.6323592662811279296875), SC_(31.73736778560021399190439490465225517649411428882), SC_(21.903093030340690478633356609280583765345155546618) }}, 
      {{ SC_(4.285762786865234375), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(41.581048291789996379031836662067110664529508417554), SC_(15.408543519764343109524257516360446517499916058047) }}, 
      {{ SC_(4.285762786865234375), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(43.10384701106176229875584955487632776474324453572), SC_(14.601011028162507643960564673392801813634068117566) }}, 
      {{ SC_(4.285762786865234375), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(50.094535137629288573734520653142480510400961256303), SC_(11.397121631223656712589512277532338441195467483516) }}, 
      {{ SC_(4.285762786865234375), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(51.098599887179268255648450676362082449552339318083), SC_(10.996003692440138313901526209414132521171300944181) }}, 
      {{ SC_(4.285762786865234375), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(62.716516078499341651738309899935421006173913497388), SC_(7.1855867886566362977974128843005441031906018669252) }}, 
      {{ SC_(4.285762786865234375), SC_(0.12698681652545928955078125), SC_(0.992881298065185546875), SC_(78.135892109397114634653055502437231742885628698282), SC_(3.8338142963160007269966960400281352929892103698611) }}, 
      {{ SC_(4.285762786865234375), SC_(0.135477006435394287109375), SC_(0.097540400922298431396484375), SC_(10.624056775155116321252971830163132523696456706443), SC_(46.168116272573933025564829848047689892749815610812) }}, 
      {{ SC_(4.285762786865234375), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(11.937594680205310062450054769420385143853396936078), SC_(43.147864152428529071931027785565229425525762378092) }}, 
      {{ SC_(4.285762786865234375), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(12.290355004920375860856813963510658282713119461282), SC_(42.39042769495045299438101593160196987419972593678) }}, 
      {{ SC_(4.285762786865234375), SC_(0.135477006435394287109375), SC_(0.188381969928741455078125), SC_(14.317612777721405445071965596006895653029592961372), SC_(38.411036900535023554001380453088305992611092832638) }}, 
      {{ SC_(4.285762786865234375), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(15.469376627895497352658331319256284808359682715295), SC_(36.395161073493776973362594888209284880517853786539) }}, 
      {{ SC_(4.285762786865234375), SC_(0.135477006435394287109375), SC_(0.278498232364654541015625), SC_(17.393291825275618145260282795413109030294855088256), SC_(33.353171765069675931417999475586842722093226138689) }}, 
      {{ SC_(4.285762786865234375), SC_(0.135477006435394287109375), SC_(0.308167040348052978515625), SC_(18.356266419524471801981332379322445883128639508671), SC_(31.963094506992116634224442588913436038463193120154) }}, 
      {{ SC_(4.285762786865234375), SC_(0.135477006435394287109375), SC_(0.546881496906280517578125), SC_(26.216303876726192697224223153981767281844891492988), SC_(23.023033560254770287526386240846949403245291727374) }}, 
      {{ SC_(4.285762786865234375), SC_(0.135477006435394287109375), SC_(0.54722058773040771484375), SC_(26.228369734253914995541211877634676470672322247943), SC_(23.011889788038572395363617637127196883456914071844) }}, 
      {{ SC_(4.285762786865234375), SC_(0.135477006435394287109375), SC_(0.6323592662811279296875), SC_(29.434900070748812569225007134187585348456304499303), SC_(20.261985460034048292288157734398458612682708046451) }}, 
      {{ SC_(4.285762786865234375), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(38.617112313927460960335145788267069989607179492264), SC_(14.204904197096488126288100410890126358086514033082) }}, 
      {{ SC_(4.285762786865234375), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(40.03760824455834863265835710080111292324719085546), SC_(13.451845203426820871126354466598672068957015235961) }}, 
      {{ SC_(4.285762786865234375), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(46.558712784341762721625765865482997761343544432876), SC_(10.464381400829619482306015575858157249227101387963) }}, 
      {{ SC_(4.285762786865234375), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(47.495338004142394072176759174814040313522643424318), SC_(10.090404457802057197979908185083000391010167615374) }}, 
      {{ SC_(4.285762786865234375), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(58.332998984396769920995370446832741766431808482186), SC_(6.5387027857285630793165709885860007348429617492412) }}, 
      {{ SC_(4.285762786865234375), SC_(0.135477006435394287109375), SC_(0.992881298065185546875), SC_(72.716963016212538373008925002498861848899452883834), SC_(3.4174834799389700863014049302100106995335881681039) }}, 
      {{ SC_(4.285762786865234375), SC_(0.814723670482635498046875), SC_(0.097540400922298431396484375), SC_(0.0), SC_(1.9547937327529084415676231401628831702037954903797) }}, 
      {{ SC_(4.285762786865234375), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(0.0), SC_(1.7041307252991781679323580074723287867760045629066) }}, 
      {{ SC_(4.285762786865234375), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(0.0), SC_(1.6414748306133560405163701394428396689931747262996) }}, 
      {{ SC_(4.285762786865234375), SC_(0.814723670482635498046875), SC_(0.188381969928741455078125), SC_(0.0), SC_(1.3139080330820788064640015554307117317368340089595) }}, 
      {{ SC_(4.285762786865234375), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(0.0), SC_(1.1491765685114908753868077895933142837396779546823) }}, 
      {{ SC_(4.285762786865234375), SC_(0.814723670482635498046875), SC_(0.278498232364654541015625), SC_(0.0), SC_(0.90250331040229883092083238887191323216954389922384) }}, 
      {{ SC_(4.285762786865234375), SC_(0.814723670482635498046875), SC_(0.308167040348052978515625), SC_(0.0), SC_(0.7906844894303203180025716400800690704614692491791) }}, 
      {{ SC_(4.285762786865234375), SC_(0.814723670482635498046875), SC_(0.546881496906280517578125), SC_(0.33643388821772044881959233531270322037166163378379), SC_(0.091735147880207113465851696897079149688903180912513) }}, 
      {{ SC_(4.285762786865234375), SC_(0.814723670482635498046875), SC_(0.54722058773040771484375), SC_(0.33737090254970571341079223904551029855198330085961), SC_(0.090894013814592825141609737324743482898065780375321) }}, 
      {{ SC_(4.285762786865234375), SC_(0.814723670482635498046875), SC_(0.6323592662811279296875), SC_(0.58906674919926080634908632250576153655308004321212), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(1.3307976988480120615170178638694046084041148521352), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(1.4474500545636407255740334422888311027669007185156), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(1.9872992766331381166501172691754587322828261682177), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(2.065320939161447140828199304809122043263160847658), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(2.9743403170222913933682227515125172778887531678721), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.814723670482635498046875), SC_(0.992881298065185546875), SC_(4.1924853509850394345146624609859359712492767694915), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.835008561611175537109375), SC_(0.097540400922298431396484375), SC_(0.0), SC_(1.7079178409071888382112767233295154757328901156822) }}, 
      {{ SC_(4.285762786865234375), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(0.0), SC_(1.4745889735036016667743163677457677924180837435699) }}, 
      {{ SC_(4.285762786865234375), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(0.0), SC_(1.4162904010362940285411984061135242974131006375663) }}, 
      {{ SC_(4.285762786865234375), SC_(0.835008561611175537109375), SC_(0.188381969928741455078125), SC_(0.0), SC_(1.1116936334489622563000374230836892527422615722757) }}, 
      {{ SC_(4.285762786865234375), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(0.0), SC_(0.95865529557865837834583190604806537898854785956616) }}, 
      {{ SC_(4.285762786865234375), SC_(0.835008561611175537109375), SC_(0.278498232364654541015625), SC_(0.0), SC_(0.72971443232583767907740484450701844266905971024921) }}, 
      {{ SC_(4.285762786865234375), SC_(0.835008561611175537109375), SC_(0.308167040348052978515625), SC_(0.0), SC_(0.62603871743276241336716309892470885430588607823472) }}, 
      {{ SC_(4.285762786865234375), SC_(0.835008561611175537109375), SC_(0.546881496906280517578125), SC_(0.20578654435957539606733819394147110908924172707042), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.835008561611175537109375), SC_(0.54722058773040771484375), SC_(0.20665152079860081153721429260279109450429554981613), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.835008561611175537109375), SC_(0.6323592662811279296875), SC_(0.43930604899962627245266961460372218903905055609132), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(1.1273902791007541153525146644324457120504537468556), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(1.2358299319379870542839137873725468238091083665107), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(1.7381860155745523019580819679763567705463527016776), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(1.8108463883970626762098942145349948247449328511667), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(2.6581483604611423296672687586233881889446005776514), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.835008561611175537109375), SC_(0.992881298065185546875), SC_(3.7949950470267022075874317546605823270124738185727), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.905791938304901123046875), SC_(0.097540400922298431396484375), SC_(0.0), SC_(0.88363331321825375715642717337234855003575333581594) }}, 
      {{ SC_(4.285762786865234375), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(0.0), SC_(0.71045430617414321474276926275370159590088171899258) }}, 
      {{ SC_(4.285762786865234375), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(0.0), SC_(0.66727876093031770394534964261121529020073110172094) }}, 
      {{ SC_(4.285762786865234375), SC_(0.905791938304901123046875), SC_(0.188381969928741455078125), SC_(0.0), SC_(0.44242185206833813070299640515675043541769510359096) }}, 
      {{ SC_(4.285762786865234375), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(0.0), SC_(0.32998429550564020028577315054126736024480100800083) }}, 
      {{ SC_(4.285762786865234375), SC_(0.905791938304901123046875), SC_(0.278498232364654541015625), SC_(0.0), SC_(0.16261576431011821862926285959718445666004133255343) }}, 
      {{ SC_(4.285762786865234375), SC_(0.905791938304901123046875), SC_(0.308167040348052978515625), SC_(0.0), SC_(0.087211897999243794150592945929987460173617372488449) }}, 
      {{ SC_(4.285762786865234375), SC_(0.905791938304901123046875), SC_(0.546881496906280517578125), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.905791938304901123046875), SC_(0.54722058773040771484375), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.905791938304901123046875), SC_(0.6323592662811279296875), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(0.45397634370932193619534190128062115529835010315623), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(0.53390321073029181892943713094659822881600167680857), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(0.90613921339718082652200988725135179234012374668877), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(0.96020063016469196523830950101285124624232815108098), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(1.5935340938699859742576824571685596509768758427999), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.905791938304901123046875), SC_(0.992881298065185546875), SC_(2.4488563960574186547345180307069118204055737783153), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.968867778778076171875), SC_(0.097540400922298431396484375), SC_(0.0), SC_(0.11042619189534262790908953978165539120063346376248) }}, 
      {{ SC_(4.285762786865234375), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.968867778778076171875), SC_(0.188381969928741455078125), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.968867778778076171875), SC_(0.278498232364654541015625), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.968867778778076171875), SC_(0.308167040348052978515625), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.968867778778076171875), SC_(0.546881496906280517578125), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.968867778778076171875), SC_(0.54722058773040771484375), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.968867778778076171875), SC_(0.6323592662811279296875), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(0.12492707933548932404132387210687773470508202565299), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(0.15980466725911098729064285233845315222755992427118), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(0.57226295659743649286678830817365105319568597964985), SC_(0.0) }}, 
      {{ SC_(4.285762786865234375), SC_(0.968867778778076171875), SC_(0.992881298065185546875), SC_(1.1369321436068695377498962278384829019462377490311), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.12698681652545928955078125), SC_(0.097540400922298431396484375), SC_(12.25893059687939119996322876958269221296598569479), SC_(51.087414807302476430503936666256449833118965639041) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(13.709419158778537881006632516420192520270496495586), SC_(47.806931135152649784793043676582241839877370607977) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(14.098547610994275136871442560548412759466289526923), SC_(46.983911001248771434117976396121672045613874760611) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.12698681652545928955078125), SC_(0.188381969928741455078125), SC_(16.331835698021431801154523835291448105411023383511), SC_(42.657640519414014692788774265870759825798383048944) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(17.598636451905175269479277411596811946654988557443), SC_(40.464426314561116332989473012532350782699263834218) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.12698681652545928955078125), SC_(0.278498232364654541015625), SC_(19.711903188362667458821397711340394139675486306901), SC_(37.152515868573876809543410775890497779705421906345) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.12698681652545928955078125), SC_(0.308167040348052978515625), SC_(20.768470496231795481545644817717262671929074860016), SC_(35.638081149579012144487963251278170952895579041764) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.12698681652545928955078125), SC_(0.546881496906280517578125), SC_(29.36930087161147176592159431981253138356945275474), SC_(25.879463556816837573133107367851361966569915477649) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.12698681652545928955078125), SC_(0.54722058773040771484375), SC_(29.382477590797856767528501607415925980898967099506), SC_(25.867275295300009805645978634255537641700833908775) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.12698681652545928955078125), SC_(0.6323592662811279296875), SC_(32.881907586305365743979119641487010369968354809836), SC_(22.857343683811152999326723687684579376709287174524) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(42.881780393783447709561896575050033079746350311611), SC_(16.207795984784291413224690113397901515405189803196) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(44.426487200896752083429730510992760306930079373374), SC_(15.378669121143277095831770540754226626427204547051) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(51.511523234867262678185073827608218907681188932694), SC_(12.082431351066992515620070012865769790857744599741) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(52.528380918138772505131626134473043203809655371081), SC_(11.668890818216726146963931467847937701301820651063) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(64.282869475723148444604976457340151662142268994691), SC_(7.7279457531716250976579214034840059399546023671048) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.12698681652545928955078125), SC_(0.992881298065185546875), SC_(79.857727465918309994754509259104711309788584381186), SC_(4.2342897772806176467454069401388121049224893581391) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.135477006435394287109375), SC_(0.097540400922298431396484375), SC_(11.263392930911391515168360123535715651758335541873), SC_(47.480035777498203691080444311243435647414647742425) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(12.61586300751390979795812127296839555263785244712), SC_(44.419905052178368456387857950318468757614391341996) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(12.978714801579736566271595634680046521920038375309), SC_(43.652170609667906639081183953720024507823224898983) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.135477006435394287109375), SC_(0.188381969928741455078125), SC_(15.061318561290247193565626647448619804898855888127), SC_(39.616534957002788617392997204727810770042888362142) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(16.242720767748580942652272438466216028125808494421), SC_(37.570674780552848499416334968702478706156451778859) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.135477006435394287109375), SC_(0.278498232364654541015625), SC_(18.213616633133179023234564056682386984654342559037), SC_(34.481304808079069839016012969109156879559124136476) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.135477006435394287109375), SC_(0.308167040348052978515625), SC_(19.199037231193778187354987997592948222413529448113), SC_(33.06864302170868920578427603437266138227099193622) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.135477006435394287109375), SC_(0.546881496906280517578125), SC_(27.221244955707124816998548232452955837482351532244), SC_(23.966096913600775539361812106337977797108167104366) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.135477006435394287109375), SC_(0.54722058773040771484375), SC_(27.233535719798247829701059330574236543768460139388), SC_(23.954728481964262080059943032864393473592706085347) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.135477006435394287109375), SC_(0.6323592662811279296875), SC_(30.497713131442431969135979546313433427179351135225), SC_(21.14730402901715857943023665456025822707022437352) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(39.825616352593154356756942963538745957354073723158), SC_(14.945643297413892249662688482038240298181102908837) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(41.266547545179625834282539651299192311190460077264), SC_(14.172440806462254905354297938486122083736748012756) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(47.875657628543348270136612113265845481479045616333), SC_(11.098829581614353501694895833543407833362162424961) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(48.824215853065993077591140536543614378243322099508), SC_(10.713263553391965847819346464628446412312881731662) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(59.789269714264154013859885325755153046270078639114), SC_(7.0397747521049131446147403167162987886602749309516) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.135477006435394287109375), SC_(0.992881298065185546875), SC_(74.318266912277067911053441760010580684176789578755), SC_(3.7860941252589571884723116050323442189175412931939) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.814723670482635498046875), SC_(0.097540400922298431396484375), SC_(0.0), SC_(2.016229228811943590529733274178808409704643601922) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(0.0), SC_(1.7624458093897594826307007335088473117441312876731) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(0.0), SC_(1.6989863140171035257648546053358694539376364915336) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.814723670482635498046875), SC_(0.188381969928741455078125), SC_(0.0), SC_(1.3670469031814692075045142766292367490673673003302) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(0.0), SC_(1.1999961099230724603966516077765245326252328452038) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.814723670482635498046875), SC_(0.278498232364654541015625), SC_(0.0), SC_(0.94967533338885600170126557789562849855617861933455) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.814723670482635498046875), SC_(0.308167040348052978515625), SC_(0.0), SC_(0.83612570247248753552050854407991363267300283778767) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.814723670482635498046875), SC_(0.546881496906280517578125), SC_(0.37423162746235820438183325633917834004259995572026), SC_(0.12489340057566566814130039063816330802393925022385) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.814723670482635498046875), SC_(0.54722058773040771484375), SC_(0.37518559749750026012787272607210647413901781395739), SC_(0.12403552062924254959821247151048135038152400776744) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.814723670482635498046875), SC_(0.6323592662811279296875), SC_(0.63124739087971409544135012235224073374043141131612), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(1.3841695436125556957478454154361936278765342850437), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(1.5024078791195589311198936538976854611202631057082), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(2.0491289358428468521540570082575830871881267276915), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(2.1280873946639785406938511125202812395794885684718), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(3.0471772898938074708483656926187671045754823064955), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.814723670482635498046875), SC_(0.992881298065185546875), SC_(4.2769290075217302830893881029915695414299479722625), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.835008561611175537109375), SC_(0.097540400922298431396484375), SC_(0.0), SC_(1.7627916126193711143512736555270644322287866395061) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(0.0), SC_(1.5265833492136591540421022433917644984077041825442) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(0.0), SC_(1.4675435789593727870967193144296629667063567802052) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.835008561611175537109375), SC_(0.188381969928741455078125), SC_(0.0), SC_(1.1589163460651043233787589976780473904588122854937) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(0.0), SC_(1.0037420904308344553858066393778329566559699861016) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.835008561611175537109375), SC_(0.278498232364654541015625), SC_(0.0), SC_(0.77144520748008235970905013638426558408494814322088) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.835008561611175537109375), SC_(0.308167040348052978515625), SC_(0.0), SC_(0.66617845266178194200763736206081182617274580198241) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.835008561611175537109375), SC_(0.546881496906280517578125), SC_(0.23891382879558701531583610692930573563172679190429), SC_(0.0091540927571036740168911753995223828594032319976354) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.835008561611175537109375), SC_(0.54722058773040771484375), SC_(0.23979433163143679311702730182753255740814832743679), SC_(0.0083650387369646159847448559626953587936867530875107) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.835008561611175537109375), SC_(0.6323592662811279296875), SC_(0.47645140400793023360961439022602722094011529094077), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(1.1748276201802476528138037284695023603357781009954), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(1.2847287183199979845722700613475541031424989244697), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(1.7934236470470585825426451166275690329412299139979), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(1.8669489172671515741605161796239185222439547524799), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(2.7235584667208578055107517412701154054592429800234), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.835008561611175537109375), SC_(0.992881298065185546875), SC_(3.8711519377131032935323999467433702489549347591787), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.905791938304901123046875), SC_(0.097540400922298431396484375), SC_(0.0), SC_(0.91718441753053256246774840460799309082683763877528) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(0.0), SC_(0.74197429022407614735407175773511330273049999382387) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(0.0), SC_(0.69827733642818583134550297286672207651570634585498) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.905791938304901123046875), SC_(0.188381969928741455078125), SC_(0.0), SC_(0.47059636085352728391785740040699182456378790509113) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(0.0), SC_(0.356670629509048107707063897133408090235617943663) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.905791938304901123046875), SC_(0.278498232364654541015625), SC_(0.0), SC_(0.18697733362438091703915694596100146936429308570353) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.905791938304901123046875), SC_(0.308167040348052978515625), SC_(0.0), SC_(0.11047778041158776687531040479272888589302369771459) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.905791938304901123046875), SC_(0.546881496906280517578125), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.905791938304901123046875), SC_(0.54722058773040771484375), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.905791938304901123046875), SC_(0.6323592662811279296875), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(0.48230073153395495029563132285210535234204316696314), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(0.56324971535019921557110352241261776270720486912988), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(0.93994758574938692725772479696113287687157630290048), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(0.99462104955718760508121306796127496346179140086654), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(1.6345829335796032835183305773580337897051945931093), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.905791938304901123046875), SC_(0.992881298065185546875), SC_(2.4976389347682782677046733441629194622249640661661), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.968867778778076171875), SC_(0.097540400922298431396484375), SC_(0.0), SC_(0.12561716232502682429377296571942294605835629082182) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(0.0), SC_(0.013298027705716899056615110436396867599311735757413) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.968867778778076171875), SC_(0.188381969928741455078125), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.968867778778076171875), SC_(0.278498232364654541015625), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.968867778778076171875), SC_(0.308167040348052978515625), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.968867778778076171875), SC_(0.546881496906280517578125), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.968867778778076171875), SC_(0.54722058773040771484375), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.968867778778076171875), SC_(0.6323592662811279296875), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(0.14026296694324869260918228870540675222781290683212), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(0.1754861034647699064704560546916169192355519761427), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(0.59175024874553379175056420593645202713092057880574), SC_(0.0) }}, 
      {{ SC_(4.43858623504638671875), SC_(0.968867778778076171875), SC_(0.992881298065185546875), SC_(1.1609811506564478935439723626084760213864503525595), SC_(0.0) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.12698681652545928955078125), SC_(0.097540400922298431396484375), SC_(77.164315586417023474890667638550122476836584770387), SC_(154.30705501758828215798796385630274036944891308582) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(80.87371593035329045637407522545456463581667243972), SC_(148.7480861461699698435388683962627300678299596489) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(81.846101192197259372049567713853149916210141416411), SC_(147.33755606671424469789540193347434024079444224729) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.12698681652545928955078125), SC_(0.188381969928741455078125), SC_(87.264120441810102677101389226816294594616250697866), SC_(139.80813319100646960391184973303454608281350103587) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(90.228001581058382111470655562314434551377666219525), SC_(135.91079564430536849618719706777646207869965231141) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.12698681652545928955078125), SC_(0.278498232364654541015625), SC_(95.021950094990911342129199503351245801032548635303), SC_(129.91010536305026025285242046701541799056088649574) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.12698681652545928955078125), SC_(0.308167040348052978515625), SC_(97.355938873346508748477360364861740518628862215037), SC_(127.11545840459351982529434360404767663397090628641) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.12698681652545928955078125), SC_(0.546881496906280517578125), SC_(115.15014364428750930511991655623919083153896543144), SC_(108.15715710395069549513382985741055737270059868315) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.12698681652545928955078125), SC_(0.54722058773040771484375), SC_(115.17605001758494551435618243343514254558930580378), SC_(108.13224411747299384138160759752046850232035913512) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.12698681652545928955078125), SC_(0.6323592662811279296875), SC_(121.93864483648763007233087252241338026598841076326), SC_(101.86168474852408237920927615010244494628507566751) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(140.20323882307064185066291368891455978208426858057), SC_(86.969916834802306252385366519426109104086069620843) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(142.91085211890910782695556602717891155688251175425), SC_(84.983847552988481960916054583838011397665869484557) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(155.01868801455287170461271501943359003943968311619), SC_(76.703142792173694215401226417707387051241586721201) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(156.71866680718943335923681156360333533761746447003), SC_(75.613629590788201230993346964504089134783719648197) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(175.80222819528816659106678161973028089982139832541), SC_(64.461810224091190893137103940112289149280460206311) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.12698681652545928955078125), SC_(0.992881298065185546875), SC_(199.81491988277606943482795496892378958168254710429), SC_(52.804324036829547048149046648029679257766536523631) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.135477006435394287109375), SC_(0.097540400922298431396484375), SC_(71.422267394138613536139754432519863738700649649316), SC_(143.37748917204838789001360028042267277477085866116) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(74.881876275769218439367223498045535364257462936248), SC_(138.19204666176681194577204794849546188844697318265) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(75.788791565300491093632000023950003928722942493049), SC_(136.87629892065041935447772920777437044783030347681) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.135477006435394287109375), SC_(0.188381969928741455078125), SC_(80.84209148416548264973614538568496510681280739779), SC_(129.85285467624284980731490140341415704390726471879) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(83.606502679613640229336534173050813124575861208209), SC_(126.21744028078879791257028206817169497906812863288) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.135477006435394287109375), SC_(0.278498232364654541015625), SC_(88.07787817059469117164580559065513445079524265191), SC_(120.62006240694212392846326927638109217556629203407) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.135477006435394287109375), SC_(0.308167040348052978515625), SC_(90.254843217691235247945131989032366179339430892417), SC_(118.01326097404392410704061889736880212463319881678) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.135477006435394287109375), SC_(0.546881496906280517578125), SC_(106.85233082772437273437370454881558290802878143392), SC_(100.32956579497101757388381430841970246814547446565) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.135477006435394287109375), SC_(0.54722058773040771484375), SC_(106.87649537109947262137745326823227258516013451804), SC_(100.30632817068381730027690954127515159555390795965) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.135477006435394287109375), SC_(0.6323592662811279296875), SC_(113.18444005892532704819319465821998974910211029015), SC_(94.457496910131505938340726746210482143261470091827) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(130.22140782415621521492165145931478277768686057422), SC_(80.567689556599071259738491124775820497485483244065) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(132.74706403361442824681208832240653658482026080256), SC_(78.715303230314616964867288353930389527572803087827) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(144.04130678884775954507918651099975719513397088591), SC_(70.992154766489918226561595497586091377396872200488) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(145.62706368320878748470661057837279237830619143586), SC_(69.976025123263392217640393484742663381195390554064) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(163.428524299723312081994455880137028567368302585), SC_(59.575750283965712466039248648604102623444750872701) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.135477006435394287109375), SC_(0.992881298065185546875), SC_(185.82821970856794562726820958190774426530892597985), SC_(48.705026590906157690713495250353233049404191056637) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.814723670482635498046875), SC_(0.097540400922298431396484375), SC_(0.71252548661765152839146010158934959420760662423545), SC_(6.1953919837845181031390214672196071297649479422468) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(0.9455733749852267160236893609566286676144037405926), SC_(5.7759192353294601257689093310418655053945590221822) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(1.0076387056632811910717439308597729824938823815715), SC_(5.669803360665967895588085133336298813255828191363) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.814723670482635498046875), SC_(0.188381969928741455078125), SC_(1.3599717199188943585885994287469422336352839287248), SC_(5.1057726890645179842420661557717100531303181039733) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(1.5568840032508634401094759000205331542828016702596), SC_(4.8155668959818617083993804993917705205260967028792) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.814723670482635498046875), SC_(0.278498232364654541015625), SC_(1.8807387849072588577931766148896690866091007551742), SC_(4.3713681561237662532658407683353189027620965370627) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.814723670482635498046875), SC_(0.308167040348052978515625), SC_(2.0405556022736788385853239260452707582836329653575), SC_(4.1656882662251887438632709224498535367262341060662) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.814723670482635498046875), SC_(0.546881496906280517578125), SC_(3.295136604779279500042336355329986815331843398104), SC_(2.7953949502471461079017079630645731191173391004398) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.814723670482635498046875), SC_(0.54722058773040771484375), SC_(3.2970016210008746519611865993564325343954335111252), SC_(2.7936285659341856185975028458204493574125702549868) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.814723670482635498046875), SC_(0.6323592662811279296875), SC_(3.7869112766537811459130510320305675753538201510441), SC_(2.3525957209153769004949080828763973453457299219391) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(5.1352629775535191039242567235645846039324231673734), SC_(1.340576796602420360728069949982139897419599118323) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(5.3376854430115081604944363768766237840782207573474), SC_(1.2104078508006732009681401677740538671551355290283) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(6.2492296291821699998881057894845187815260595520992), SC_(0.68399240281077147794756095599565931738956838004125) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(6.3779604588970546306213943114504088614259846563174), SC_(0.61699924031550661660306016412772112219225111419351) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(7.83340458131777430576608901144473079101478717143), SC_(0.0) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.814723670482635498046875), SC_(0.992881298065185546875), SC_(9.6859186159785436963124152061119734277155767322909), SC_(0.0) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.835008561611175537109375), SC_(0.097540400922298431396484375), SC_(0.42990075983882364330910169963179486196462416156412), SC_(5.4699216143912682675400856176004141145566977848919) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(0.63965780265789821784912918419750386496202786138081), SC_(5.0808874912216856131213138834076175952592444625028) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(0.69568702987188085547377830505649148925731890648076), SC_(4.982513323292578768034353123866507838009915127354) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.835008561611175537109375), SC_(0.188381969928741455078125), SC_(1.0148403215888894004933037558501437541075374878568), SC_(4.4599456988025969927200645441431876913330109333705) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(1.1938858042495714925636264277320420808371960094165), SC_(4.1913015942095166198933058418874492493634637206766) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.835008561611175537109375), SC_(0.278498232364654541015625), SC_(1.4891962191355990939766533455840670246495850472156), SC_(3.7804524955408023525036634041905592777345960097735) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.835008561611175537109375), SC_(0.308167040348052978515625), SC_(1.6352549961999981688273556950947541827750063296511), SC_(3.590373301302647258696625103894911577259963669331) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.835008561611175537109375), SC_(0.546881496906280517578125), SC_(2.7872064360107457674955465860965517709334289368977), SC_(2.32738585956973360325438999501419528680491215422) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.835008561611175537109375), SC_(0.54722058773040771484375), SC_(2.7889243814728950682673158013041807044839468859639), SC_(2.325762543530163372137930138957268161834677213114) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.835008561611175537109375), SC_(0.6323592662811279296875), SC_(3.2406249044022766531252520491005115222750663285686), SC_(1.9209588441770396888109641008787788800999454053469) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(4.4872540962653711979920578545255137454570976316683), SC_(0.99722907288574476640069009694370109687226125426838) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(4.6747431309951221992258929058903014112308005016888), SC_(0.87915277287722362022909267587800763245297237171403) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(5.5198705150510170243970422537025387447533685380225), SC_(0.40429510885377359449618824280923422341370140917859) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(5.6393186089090606868736222787847846419475702675352), SC_(0.34424832551156581480931610973787275518454750093484) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(6.9911407270647260733087322684217457898382181138898), SC_(0.0) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.835008561611175537109375), SC_(0.992881298065185546875), SC_(8.7144575266254253099421036726069171334963569907667), SC_(0.0) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.905791938304901123046875), SC_(0.097540400922298431396484375), SC_(0.0), SC_(3.1031836908381855458889927242360170923573846360902) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(0.0), SC_(2.8204516565337077838526733668524752014339051673631) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(0.0), SC_(2.7491270227819224080694228358626076346215375898203) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.905791938304901123046875), SC_(0.188381969928741455078125), SC_(0.0), SC_(2.3715285914122314446065781567289364423914910090304) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(0.10148767494910622729367689584929079358886561072658), SC_(2.1783421939502555346549260938143162743335871892313) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.905791938304901123046875), SC_(0.278498232364654541015625), SC_(0.29542066408902889600457969625012218858553094315144), SC_(1.8843114888042336994291389108525862443003981763976) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.905791938304901123046875), SC_(0.308167040348052978515625), SC_(0.39270931742027065226828734105437572893393547703045), SC_(1.7489281219164033252141403347232929408137149880138) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.905791938304901123046875), SC_(0.546881496906280517578125), SC_(1.1824353951035366280881382415910759802663629391513), SC_(0.86321874141731574301524061391743570672229255768239) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.905791938304901123046875), SC_(0.54722058773040771484375), SC_(1.1836359418719265434684927834541575296568240234307), SC_(0.86209993071902682689898907161476130414051190451853) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.905791938304901123046875), SC_(0.6323592662811279296875), SC_(1.5010463175714840427957375486846661796742676001705), SC_(0.58521026729852853210473861916001589786891392419055) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(2.3912040208188673569882466544588280688841591395678), SC_(0.0) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(2.5264642950490542646403097320408738571203012356295), SC_(0.0) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(3.1395573004347150704634586526113886874682985363614), SC_(0.0) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(3.2266049522668212859314390792682325836294680621877), SC_(0.0) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(4.2171560511944778247076752578655216669888340739793), SC_(0.0) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.905791938304901123046875), SC_(0.992881298065185546875), SC_(5.4908799340173972666111638450414166315574102778387), SC_(0.0) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.968867778778076171875), SC_(0.097540400922298431396484375), SC_(0.0), SC_(1.0374206287240739283577484495075633217099981206053) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(0.0), SC_(0.86563249253262857353892402645213967522657648568456) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(0.0), SC_(0.82254675507948616674151182097285385360725254007485) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.968867778778076171875), SC_(0.188381969928741455078125), SC_(0.0), SC_(0.59634622277667767070419996148429194637289053201857) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(0.0), SC_(0.48199739980919830094421421498841509846802921052731) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.968867778778076171875), SC_(0.278498232364654541015625), SC_(0.0), SC_(0.31005444487815978153017705301474768261294673549425) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.968867778778076171875), SC_(0.308167040348052978515625), SC_(0.0), SC_(0.23184503878916483920415769131899694892590984123325) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.968867778778076171875), SC_(0.546881496906280517578125), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.968867778778076171875), SC_(0.54722058773040771484375), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.968867778778076171875), SC_(0.6323592662811279296875), SC_(0.090450569492071437525965196627770947039897885686424), SC_(0.0) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(0.6080480039444390782549392481260079041275153943997), SC_(0.0) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(0.68875477330859779448649672913536415066643152006365), SC_(0.0) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(1.0596299080769520311145602220934697133273458743156), SC_(0.0) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(1.1128746884562313445604010490432165121598104616101), SC_(0.0) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(1.7268423627991006620479418697319303339609001048657), SC_(0.0) }}, 
      {{ SC_(16.6650257110595703125), SC_(0.968867778778076171875), SC_(0.992881298065185546875), SC_(2.5326980370661924506202049641073156088483726002909), SC_(0.0) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.12698681652545928955078125), SC_(0.097540400922298431396484375), SC_(79.246780966080558202939635968605006257471740350755), SC_(157.24507639911748767001426335971210639042796877524) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(83.007024468305236700746329941613823823438518410613), SC_(151.63512196779495178604946470487259889819777861732) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(83.992515102960380731962541624991996189675003579936), SC_(150.21145568497154971920097506814535752850053205127) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.12698681652545928955078125), SC_(0.188381969928741455078125), SC_(89.481953091506805543928400745751951877306807314465), SC_(142.6104811141682720577155471294020282878060887381) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(92.483808488948198698789235237405664816826099114067), SC_(138.67511878378298738450976779169586800473306818682) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.12698681652545928955078125), SC_(0.278498232364654541015625), SC_(97.337646601750561231394493744910625194566448098551), SC_(132.61448109779207388173711871121805085300104208624) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.12698681652545928955078125), SC_(0.308167040348052978515625), SC_(99.7001412068385296686030825769832375145601351881), SC_(129.79130848198598590609635187690756394377912131743) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.12698681652545928955078125), SC_(0.546881496906280517578125), SC_(117.69914461354449691189020665280633326436056319036), SC_(110.62816394422800932775000952326048992292091030888) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.12698681652545928955078125), SC_(0.54722058773040771484375), SC_(117.7253343763956380688995642464593268525181087272), SC_(110.60296760288884986566488267440502029188868285958) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.12698681652545928955078125), SC_(0.6323592662811279296875), SC_(124.56058081719399297575278568819703237087464554097), SC_(104.25977450289734043101837236660714375944465445192) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(143.00940306373868153606345883669377736135301112447), SC_(89.183938931878973275807277552840160065030019965058) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(145.74298264691918047876751461087605962328869726114), SC_(87.171946310720498301498517485781298988789455715625) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(157.96314814040707800661877033892569427860831372438), SC_(78.77919023281181950292644597730069470467374603355) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(159.67842909157167502160988449645034029922821917077), SC_(77.674427102447200221159155860949042993954573217661) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(178.92660862536277136031903133406907018110911393364), SC_(66.358863401314844978011199086427244428759055541459) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.12698681652545928955078125), SC_(0.992881298065185546875), SC_(203.12999587768655434986512088017096043138974996193), SC_(54.512758677678729461110598683829387755571897718271) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.135477006435394287109375), SC_(0.097540400922298431396484375), SC_(73.353295869229839230675790841342139231172853209518), SC_(146.10655424154979103421877973941451339458285359365) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(76.860330418691462876713684328442746525935370088802), SC_(140.87355391980849123365706385458800300008766822775) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(77.779470144829572937834071463017235860386964115185), SC_(139.54555312943179592211138797211980957621911878334) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.135477006435394287109375), SC_(0.188381969928741455078125), SC_(82.899387826448745013731299903723859501408713517864), SC_(132.45536771504967430576915585721909118081433430504) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(85.699220397450411609287810955487249654632074396806), SC_(128.7844850387993257055225308334433916680431599669) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.135477006435394287109375), SC_(0.278498232364654541015625), SC_(90.226459156020006273827407364535445762653327178539), SC_(123.13119022525215562341207648644703379588104272998) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.135477006435394287109375), SC_(0.308167040348052978515625), SC_(92.430013552370207791627124667424412894975098899179), SC_(120.4977810280032454910563240812813462175966244141) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.135477006435394287109375), SC_(0.546881496906280517578125), SC_(109.21853042137055582734219994881358744481664909522), SC_(102.62301516559236623358102470156008871382745767774) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.135477006435394287109375), SC_(0.54722058773040771484375), SC_(109.24295930066081884453728412479766518906210912712), SC_(102.59951323761555375544115309452169084621988963977) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.135477006435394287109375), SC_(0.6323592662811279296875), SC_(115.61867089731682547238281220330012367710134041785), SC_(96.68293168599300560888561946187388041969671836807) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(132.827480601220949152212838201766529815355046243), SC_(82.621431512098399649588731337330517062021380773573) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(135.37735733621474238470027264835911868990759399881), SC_(80.744864526433831433658764159095793020453685782176) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(146.77637773176666020109532209022606554982535432596), SC_(72.917196673061891946568535878436735314599789572378) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(148.37640803869753498852207041192107588710563380934), SC_(71.886842078541657231350414494362802871250865476865) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(166.33142011761128122908276755183745663618312070302), SC_(61.333826285055338567763210731603698518017496579349) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.135477006435394287109375), SC_(0.992881298065185546875), SC_(188.90899231041831195403314928456200016744213185623), SC_(50.287151153395194698879580290169476385386148978995) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.814723670482635498046875), SC_(0.097540400922298431396484375), SC_(0.76467699250640560306559252770310186345345459060479), SC_(6.3094270690010673790396108352641554487314122325168) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(1.0014671125242693219901881441986929905805530881232), SC_(5.886259664057651338936199856230807091337653451133) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(1.0644928217031378449992002724381410007202959502354), SC_(5.7791927700168423325028007819422457984809352352207) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.814723670482635498046875), SC_(0.188381969928741455078125), SC_(1.4220352247117311533730612966875746891207057206082), SC_(5.209988025017188841301975768924530266224877978669) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(1.621703943551428897445464787877533902147305478893), SC_(4.9170364434971559499019361001439014433275352688145) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.814723670482635498046875), SC_(0.278498232364654541015625), SC_(1.9498922229900387681920770420371531587284549970904), SC_(4.4685136793819080939529071646281889187951702892606) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.814723670482635498046875), SC_(0.308167040348052978515625), SC_(2.1117671716605896672382244323882769665881819891465), SC_(4.2607780383398794656199989930247881675324674920702) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.814723670482635498046875), SC_(0.546881496906280517578125), SC_(3.3810946493641250381370937653855278149035353443214), SC_(2.8757413229094264823578353443360600163769868546473) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.814723670482635498046875), SC_(0.54722058773040771484375), SC_(3.3829800553679028431350522841085588884469878524482), SC_(2.8739545479486596173214204666605529333747683656643) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.814723670482635498046875), SC_(0.6323592662811279296875), SC_(3.8781182346704195915867981177032729357254978212191), SC_(2.427692384326522905189943768280807086907953137713) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(5.2397540337408834852053591526742200884447094644751), SC_(1.4023632521687765303264786071119010054427158309444) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(5.4440532245804130392760531471128934249503667724354), SC_(1.2703070437058975960854812305510545958197168785993) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(6.3637316985839658664040254204240470645766998738953), SC_(0.7356694529763938385409495263678977492328550129252) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(6.493572721780467671944541185774658065528770774587), SC_(0.66754683026626650560931633233333467899094831350751) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(7.9609946601475676537314366909004857591866478039165), SC_(0.010290323615060139585504120206431986047076529827239) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.814723670482635498046875), SC_(0.992881298065185546875), SC_(9.8274674240398902253127100807576354641588936110673), SC_(0.0) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.835008561611175537109375), SC_(0.097540400922298431396484375), SC_(0.47362966266244515343861449158647223093359666962665), SC_(5.5706562176911406958880232282155767514707377178753) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(0.68683790831943933902409984669854406228744184962823), SC_(5.1782156759351620706260239528654331731970907013737) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(0.74375251817112828948825060733573323486647022567888), SC_(5.078964817513348197844659532009139542521114977621) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.835008561611175537109375), SC_(0.188381969928741455078125), SC_(1.0677064737779829678396192466118616144535163758854), SC_(4.5516284519425132520922369294494398511418124114537) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(1.2492910271752415416659604521727275280611456115703), SC_(4.280454285000421258315799999101193037957963335625) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.835008561611175537109375), SC_(0.278498232364654541015625), SC_(1.5485921173446054902158098241121152541180825757071), SC_(3.8656217035753779488502370234881454949280889912661) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.835008561611175537109375), SC_(0.308167040348052978515625), SC_(1.6965458716736065133787023489488376460421498481069), SC_(3.6736489885095663184045793550919667165452856247374) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.835008561611175537109375), SC_(0.546881496906280517578125), SC_(2.8620731656108624951218377075255723756311808098789), SC_(2.397086294647162862467517937918809761550532816202) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.835008561611175537109375), SC_(0.54722058773040771484375), SC_(2.8638098838316941601471146906567676991633142800751), SC_(2.3954442071818509386822078929438468806485159380006) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.835008561611175537109375), SC_(0.6323592662811279296875), SC_(3.3203247108825141612069892615790745736634266633488), SC_(1.9858264791566931846196869349578272719825965371739) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(4.579190930700989595845257083735096426138440977127), SC_(1.0498399860177424674558346770316224616924879677147) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(4.7684095185390488928120342631265493286702835499735), SC_(0.93002479016663550163564303212332146048786362668235) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(5.6210357310913713192739903108223665145076303282971), SC_(0.44758631293437381965844008209588652395846624563105) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(5.7415076049520179474184938879395357434042534509103), SC_(0.38649744355647126447910814311119393631528202904401) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(7.104380222386169694902599662755425591373405100152), SC_(0.0) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.835008561611175537109375), SC_(0.992881298065185546875), SC_(8.8405867211644999981457715457296168992111549192304), SC_(0.0) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.905791938304901123046875), SC_(0.097540400922298431396484375), SC_(0.0), SC_(3.1612717792770215477828062742807181641644225255667) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(0.0), SC_(2.876148268738741432166012498320630213857011799254) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(0.0), SC_(2.8042087733479612782938529897426269758319027296103) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.905791938304901123046875), SC_(0.188381969928741455078125), SC_(0.010852478341122081378284847139187258690005374380992), SC_(2.4232702362010460029383717364032223685742596724315) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(0.12805027055261101537122084892614168218393519979769), SC_(2.2283147555292011211093411469650699666388255419058) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.905791938304901123046875), SC_(0.278498232364654541015625), SC_(0.32473308899073450073099713287219143384954242049793), SC_(1.9315028776382889173863866278304198110204786758527) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.905791938304901123046875), SC_(0.308167040348052978515625), SC_(0.42332962692432653853276089196957085350085083845619), SC_(1.7947992658406691373109816966272749369278932833349) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.905791938304901123046875), SC_(0.546881496906280517578125), SC_(1.2224567342918784628688269228443656148378155021967), SC_(0.89965636030187358473725226836265287684270437526648) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.905791938304901123046875), SC_(0.54722058773040771484375), SC_(1.2236703171370315490653904112461818326846225001653), SC_(0.89852454211338907581012232616907881654833126790193) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.905791938304901123046875), SC_(0.6323592662811279296875), SC_(1.5444272415169183772782686156861811943076221112007), SC_(0.61830230237898182373439926118511158990684877138324) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(2.443123440627431891632290838791322936043913991121), SC_(0.0) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(2.5795944049487256138523598227474662782024973248018), SC_(0.0) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(3.197947973035442929048553596575241306697191969684), SC_(0.0) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(3.2857152629456466692610285245025122831839752330205), SC_(0.0) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(4.2840558928156667947874829242338957284417614041026), SC_(0.0) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.905791938304901123046875), SC_(0.992881298065185546875), SC_(5.5669153224772788575638587484635953891185262136926), SC_(0.0) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.968867778778076171875), SC_(0.097540400922298431396484375), SC_(0.0), SC_(1.0603642312910826733267556045333721350523541455969) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(0.0), SC_(0.88726239495091533910743890639075896923603697803422) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(0.0), SC_(0.84384019236408167208846324034373870938162899236312) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.968867778778076171875), SC_(0.188381969928741455078125), SC_(0.0), SC_(0.6158217152673041980923886854169600309515663616127) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(0.0), SC_(0.50051717410028358768520592168595121352943796472749) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.968867778778076171875), SC_(0.278498232364654541015625), SC_(0.0), SC_(0.32708276466237010067355204506897971567568673813701) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.968867778778076171875), SC_(0.308167040348052978515625), SC_(0.0), SC_(0.2481704776243976519515094205998071974718083114969) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.968867778778076171875), SC_(0.546881496906280517578125), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.968867778778076171875), SC_(0.54722058773040771484375), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.968867778778076171875), SC_(0.6323592662811279296875), SC_(0.10546022943479298113572336972360399370242392838202), SC_(0.0) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(0.62761982026350757393341120689771458133427413174493), SC_(0.0) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(0.70898390625649660012211119787702744270924372448477), SC_(0.0) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(1.0827402825174051563703030981363971563774813477528), SC_(0.0) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(1.1363821839831785692409371751391813963756747411595), SC_(0.0) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(1.7546894970518275291438444797501880939925027927796), SC_(0.0) }}, 
      {{ SC_(17.0301532745361328125), SC_(0.968867778778076171875), SC_(0.992881298065185546875), SC_(2.5657206628988033090589933791790515523582059905935), SC_(0.0) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.12698681652545928955078125), SC_(0.097540400922298431396484375), SC_(86.548865090237746659034104773727186179850292808047), SC_(167.46179025792665966467814591895849707952792347939) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(90.482372122358633151921675805949750899158397926453), SC_(161.67812086688900773909577265048521116647706204109) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(91.512520110338895134618553040608628281308757908382), SC_(160.20969950476146648609092505063780223179088690906) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.12698681652545928955078125), SC_(0.188381969928741455078125), SC_(97.245301850477409483342571999873420210080008951838), SC_(152.36495979595358315935306662113521696621738207472) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(100.37653432716653490487771845179531489717063529151), SC_(148.30006028230217588512306607154865004496750711616) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.12698681652545928955078125), SC_(0.278498232364654541015625), SC_(105.43440092691939481983160732670579459180183667436), SC_(142.03521096375478476143848488320518342331120888809) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.12698681652545928955078125), SC_(0.308167040348052978515625), SC_(107.89400279626148656132315452644961676779262349367), SC_(139.11486826356609204848404947511629301649598508878) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.12698681652545928955078125), SC_(0.546881496906280517578125), SC_(126.59061862474257008571837968124475568287046302183), SC_(119.2539700374463705390965063790811887764399283937) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.12698681652545928955078125), SC_(0.54722058773040771484375), SC_(126.61777368277086667625712184861843879407105920303), SC_(119.22780851079598697545563755804326323918194049635) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.12698681652545928955078125), SC_(0.6323592662811279296875), SC_(133.70049099846749373224890443541061785550404386583), SC_(112.63720119746338675965715240708138616474831644679) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(152.77688286399325591841376752396493707911682718973), SC_(96.934304841227186720699160049634165216577852408227) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(155.59892360023471231605989408939544126019309934325), SC_(94.83398717542725772921501660451902653983202680201) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(168.20180054022573335229324167996035835553406594011), SC_(86.059401777096490289608438854885579974213324714679) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(169.96922086716139287015093181200169241039821945968), SC_(84.902664865441539778388104728429431765436481708601) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(189.77838547631535388070352368949308058697701651722), SC_(73.028887436514153465076798461062265136126171074893) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.12698681652545928955078125), SC_(0.992881298065185546875), SC_(214.63183532518319775287237264444803612557404745334), SC_(60.539311887219147804311533834829674985616062494913) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.135477006435394287109375), SC_(0.097540400922298431396484375), SC_(80.124567105431644740144330862383371757207996731202), SC_(155.59650244202501533346903186997686317160847635833) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(83.793218842845068375207238317987837832578737174142), SC_(150.20146602684640531861434939277022032246592414942) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(84.754014035029445820540390863979824331847309779572), SC_(148.8317190762773803352059141631754263824592866202) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.135477006435394287109375), SC_(0.188381969928741455078125), SC_(90.100917003713639800866113855279709500347502054983), SC_(141.51415726148060999204603950148528088536098163278) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(93.021428994101908130589773671707437255717094933307), SC_(137.7224465381768031234663586706194904765609913284) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.135477006435394287109375), SC_(0.278498232364654541015625), SC_(97.73897948142690824991626494197672333994341537493), SC_(131.87866995354924354923096662405307794557151498931) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.135477006435394287109375), SC_(0.308167040348052978515625), SC_(100.03311248737374341656107313196639206072605757891), SC_(129.15462381323814374825676332416751597541962098129) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.135477006435394287109375), SC_(0.546881496906280517578125), SC_(117.47233858709638548834403098994382316179690307036), SC_(110.62901752259269100522686989683672703301973150917) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.135477006435394287109375), SC_(0.54722058773040771484375), SC_(117.49766786005383707593322891633843564386889635566), SC_(110.60461530299720856111029453608626251048150681661) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.135477006435394287109375), SC_(0.6323592662811279296875), SC_(124.10421166886941339267374411364173914183849394154), SC_(104.45725416599252864497992723903565048749525784393) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(141.89839717052279788299732226825187082869399418703), SC_(89.810850624765125836204936675576796211736717423973) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(144.53078763347793264646252442832192453263456099211), SC_(87.851896249475819906445086887232462394802375577297) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(156.28678955881302102549391004856849907460308722927), SC_(79.668065486421079623175589882418604411849384195863) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(157.9354539576270035361560635753094750865747820642), SC_(78.589230446038684536214161497571928832177755283607) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(176.4137379024487794084212759360565407260224048342), SC_(67.515513384839658361962696642785688722932076143487) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.135477006435394287109375), SC_(0.992881298065185546875), SC_(199.59767437965708024210049343998213068102736107226), SC_(55.86858459239310135359400617781854501115078421882) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.814723670482635498046875), SC_(0.097540400922298431396484375), SC_(0.94919207505004139075519856716293456507811217483515), SC_(6.7047423898027929227375551535531873519226420937742) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(1.1987282582764880808288968562905663238567395033223), SC_(6.2689901199886353689245344054293269234442706401551) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(1.2650252242221898932469114253524113302821372451131), SC_(6.1586838558532746132355589903558838277241850017884) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.814723670482635498046875), SC_(0.188381969928741455078125), SC_(1.6403130103717503546710350314181417806841298127129), SC_(5.5718552201835424994254525656631335159407723627959) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(1.849371830323330544005854145649946488894784018886), SC_(5.2695509530389698382132850768156806559700123307113) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.814723670482635498046875), SC_(0.278498232364654541015625), SC_(2.1923229882088037106095788742811731674582473143171), SC_(4.8062996211836590996894525160518368769638816363099) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.814723670482635498046875), SC_(0.308167040348052978515625), SC_(2.3612093983435093809170686689116830831282142998944), SC_(4.5915615683847653202617240608909891172494733163898) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.814723670482635498046875), SC_(0.546881496906280517578125), SC_(3.6807722764983589546848744967190683158606089778955), SC_(3.1563027028430219316557184423196085805168527166675) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.814723670482635498046875), SC_(0.54722058773040771484375), SC_(3.6827271392968548182840551154615915003400852703616), SC_(3.1544464655360497361999475404562421920943911605891) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.814723670482635498046875), SC_(0.6323592662811279296875), SC_(4.1956757254597281144924812311020509303182093749743), SC_(2.6903699472145263210980532842158391657683486158542) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(5.6025603840384219374872919764932504173717935237984), SC_(1.6196972543105914280261129323353585502542535652311) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(5.8132520552460891767755153219979687665492890186372), SC_(1.4812120763746237394124839328701660708866560223328) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(6.7606376907017769733678967375041984766355871633501), SC_(0.91856863585117386557113012026097864303724122059745) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(6.8942603411113264838239546071699234539200611272362), SC_(0.84659939836250886620078769640600330711052680437665) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(8.4024840835053642550700466097426772974230843621107), SC_(0.14720822645066944847434233438662841657908293508864) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.814723670482635498046875), SC_(0.992881298065185546875), SC_(10.316514198093407345772311034665818757982482476187), SC_(0.0) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.835008561611175537109375), SC_(0.097540400922298431396484375), SC_(0.62852987601430671694042451498641415153060429182288), SC_(5.9197569493183662854516087662332574142091896147859) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(0.8534970772763639427920171482054891356355765484245), SC_(5.5157137361146846233569914270609943166044976429884) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(0.91342835323220500862793289181652470722795922915704), SC_(5.4134767702126481752288877824009365546338234398305) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.835008561611175537109375), SC_(0.188381969928741455078125), SC_(1.2537391159621740145797903647747486295769699333451), SC_(4.8698974783041695947439862117620708681550821372504) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(1.4439747848485013361016162679787199959308547316816), SC_(4.5901055115515524269834792649576258342727077393019) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.835008561611175537109375), SC_(0.278498232364654541015625), SC_(1.7568727640583521544425757464246411328398316864258), SC_(4.1617043125729031673512151431651136916959028042549) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.835008561611175537109375), SC_(0.308167040348052978515625), SC_(1.9112829139130547635793506847240305419733011546622), SC_(3.9632817185044167006027794612600589422195947547316) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.835008561611175537109375), SC_(0.546881496906280517578125), SC_(3.1230611987108787006156148106102119414269849091791), SC_(2.6404743089576991143020499431998326099841474280026) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.835008561611175537109375), SC_(0.54722058773040771484375), SC_(3.1248618682109692905367584796993136385819219248647), SC_(2.6387682709669829674224707840261683648992994322226) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.835008561611175537109375), SC_(0.6323592662811279296875), SC_(3.5977766736272246431245501720423539463631894330324), SC_(2.2127496655532735691788178979839467487858779641162) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(4.8983253941688833343117012096756400983913235808598), SC_(1.2350029772540016233538445570647619728734735456197) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(5.0934350692139044477418276739584594784420285439066), SC_(1.1092630140135207470521253662635454019931288283175) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(5.9716031870882601917821521769618108315462461372898), SC_(0.60099517793689005772947227371052952814783041760148) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(6.095562199902746152185504586591238049548417188185), SC_(0.53635562607505522150256479953030095956697570188026) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(7.4960757282718020617119066557528093494028313154879), SC_(0.0) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.835008561611175537109375), SC_(0.992881298065185546875), SC_(9.2761939689773967520869170667606520685017264349874), SC_(0.0) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.905791938304901123046875), SC_(0.097540400922298431396484375), SC_(0.0), SC_(3.362247643386310958473539492184977006184281840929) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(0.0), SC_(3.0689798718686380692014117915958306375063228629316) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(0.0), SC_(2.9949463684156325947158311075872069234819289605931) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.905791938304901123046875), SC_(0.188381969928741455078125), SC_(0.098413065226003839479351384090991029759740936930936), SC_(2.6026319285881139032387224679505911736513450246522) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(0.22157409571149927180039867790785653697281103064878), SC_(2.4016506940569231330008760407569144763531655977698) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.905791938304901123046875), SC_(0.278498232364654541015625), SC_(0.42764485890929397089794038075146313387839506382657), SC_(2.095364850474955871909119528389430149042602452011) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.905791938304901123046875), SC_(0.308167040348052978515625), SC_(0.53070446477930318871506110816851663273585327833771), SC_(1.9541634358840504055291751186749435255018348422191) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.905791938304901123046875), SC_(0.546881496906280517578125), SC_(1.3618875990524636216889946166439604910955017062561), SC_(1.0268712894967200156502589010663422721533506854198) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.905791938304901123046875), SC_(0.54722058773040771484375), SC_(1.3631456115070048173825579250745040420433122457615), SC_(1.0256951247920073412845056081133014728532455100358) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.905791938304901123046875), SC_(0.6323592662811279296875), SC_(1.6953068603134513046864099806556812615371067545095), SC_(0.73410895421363225293975755551450255854118498387793) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(2.6230906389060206645968387049870449832835363102085), SC_(0.086382187232167803202701138110655621631606146078231) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(2.7636851455073073238415900249395207595065181101416), SC_(0.006145356743807486045292644752664162985651694941866) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(3.3999542697576417422650136854221823419087004903252), SC_(0.0) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(3.4901722220941302379335045286570695036446984936367), SC_(0.0) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(4.5150380587523322581041019855135056205048116937733), SC_(0.0) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.905791938304901123046875), SC_(0.992881298065185546875), SC_(5.8290061236751525497492628066021854410284141154799), SC_(0.0) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.968867778778076171875), SC_(0.097540400922298431396484375), SC_(0.0), SC_(1.1394221126046781974288831094405818051938878829726) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(0.0), SC_(0.96184821286558914554869958013233110265735887873761) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(0.0), SC_(0.9172804425285785718046277940591628758822716665553) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.968867778778076171875), SC_(0.188381969928741455078125), SC_(0.0), SC_(0.68307086409683844802819286811233323946558893429242) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(0.0), SC_(0.56451038005033535473471974296637035175367795365946) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.968867778778076171875), SC_(0.278498232364654541015625), SC_(0.0), SC_(0.38599284105957923732144750257796569450135022237477) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.968867778778076171875), SC_(0.308167040348052978515625), SC_(0.0), SC_(0.30468400233276436235664792089621264000632838165925) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.968867778778076171875), SC_(0.546881496906280517578125), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.968867778778076171875), SC_(0.54722058773040771484375), SC_(0.0), SC_(0.0) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.968867778778076171875), SC_(0.6323592662811279296875), SC_(0.15748534598946719683038586458555474098306836483445), SC_(0.0) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(0.69519707566396142178173757059101408004739531710646), SC_(0.0) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(0.77879994751093990023601584735599007270334899179413), SC_(0.0) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(1.1623658100433697060534626305007703869730399077967), SC_(0.0) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(1.2173593424911361976911174480981192418028768932487), SC_(0.0) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(1.8504324459543146249665693415521673945088820631078), SC_(0.0) }}, 
      {{ SC_(18.3042545318603515625), SC_(0.968867778778076171875), SC_(0.992881298065185546875), SC_(2.6790669139300149512449480393936282522955933021319), SC_(0.0) }}, 
      {{ SC_(19.4396209716796875), SC_(0.12698681652545928955078125), SC_(0.097540400922298431396484375), SC_(93.098684071399987254156209637410163767980858223509), SC_(176.52313770359206917174861393843004426841301064195) }}, 
      {{ SC_(19.4396209716796875), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(97.181555123185542558517054963194252747203885827101), SC_(170.58975290847638276138624750264630965898056986868) }}, 
      {{ SC_(19.4396209716796875), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(98.250196914509394107032061716501732895455773898417), SC_(169.0827616859914063682367015480379904597105391068) }}, 
      {{ SC_(19.4396209716796875), SC_(0.12698681652545928955078125), SC_(0.188381969928741455078125), SC_(104.19271371455996019583163566527019770918248040943), SC_(161.02795902343558304337089424400916778171152924355) }}, 
      {{ SC_(19.4396209716796875), SC_(0.12698681652545928955078125), SC_(0.22103404998779296875), SC_(107.43544117764217837365562238153355666389505493455), SC_(156.85143997267466778513200360133145064984787735927) }}, 
      {{ SC_(19.4396209716796875), SC_(0.12698681652545928955078125), SC_(0.278498232364654541015625), SC_(112.66912075971412613174019959016844638853059515766), SC_(150.4106352260101242670310327919827574560007151389) }}, 
      {{ SC_(19.4396209716796875), SC_(0.12698681652545928955078125), SC_(0.308167040348052978515625), SC_(115.21239530359826016919697061850973819441947705215), SC_(147.40657100089893242286645336852450383073723848121) }}, 
      {{ SC_(19.4396209716796875), SC_(0.12698681652545928955078125), SC_(0.546881496906280517578125), SC_(134.51005376814708850997279885654893246041172459693), SC_(126.94452031095568491150205701343659757074568914941) }}, 
      {{ SC_(19.4396209716796875), SC_(0.12698681652545928955078125), SC_(0.54722058773040771484375), SC_(134.53804046925614622510237034552935444721553049479), SC_(126.91752722662361545848424819347736905983017968273) }}, 
      {{ SC_(19.4396209716796875), SC_(0.12698681652545928955078125), SC_(0.6323592662811279296875), SC_(141.83396617942396464067428529270526514875707452102), SC_(120.11375556569041297890394129502441665648815363766) }}, 
      {{ SC_(19.4396209716796875), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(161.45108518319808464680719359903512599904933871984), SC_(103.8705278268562569909941985246716159771381709485) }}, 
      {{ SC_(19.4396209716796875), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(164.34935461804796500109130267679121419180933349162), SC_(101.69408736274219095833487126978670471097602589897) }}, 
      {{ SC_(19.4396209716796875), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(177.28205657705010098716196485472498184408774287895), SC_(92.590363516194684818898086541419467783712973957197) }}, 
      {{ SC_(19.4396209716796875), SC_(0.12698681652545928955078125), SC_(0.9133758544921875), SC_(179.09441617913627236332307735567140785078372130421), SC_(91.388816246725034814612521864743852085162269441616) }}, 
      {{ SC_(19.4396209716796875), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(199.38718789528767272070195308256135304765378079246), SC_(79.033590200891596689995043919987788830129094942056) }}, 
      {{ SC_(19.4396209716796875), SC_(0.12698681652545928955078125), SC_(0.992881298065185546875), SC_(224.80128017561359848525041654813469775801704107616), SC_(65.988510823274106369680322730468508337550821144183) }}, 
      {{ SC_(19.4396209716796875), SC_(0.135477006435394287109375), SC_(0.097540400922298431396484375), SC_(86.198492492484507886864575792646405840636045241575), SC_(164.01310325384358248160704948431456442830002873871) }}, 
      {{ SC_(19.4396209716796875), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(90.006468142127198501328736035700449497687689310809), SC_(158.47841686387544659257474472649783469768909458494) }}, 
      {{ SC_(19.4396209716796875), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(91.003169517268944185449958082464554517239152168381), SC_(157.07269314763294337405079102028131743254366891122) }}, 
      {{ SC_(19.4396209716796875), SC_(0.135477006435394287109375), SC_(0.188381969928741455078125), SC_(96.545708168188851730034173196272601897536680909849), SC_(149.55919132259956811101685977185677237361968971834) }}, 
      {{ SC_(19.4396209716796875), SC_(0.135477006435394287109375), SC_(0.22103404998779296875), SC_(99.570219567266032958918409094584575143037726031559), SC_(145.66336557258348332825602609487163722276703812905) }}, 
      {{ SC_(19.4396209716796875), SC_(0.135477006435394287109375), SC_(0.278498232364654541015625), SC_(104.45176310267707909399775268918834908538761867033), SC_(139.65546369214673911752173666573710743606014034589) }}, 
      {{ SC_(19.4396209716796875), SC_(0.135477006435394287109375), SC_(0.308167040348052978515625), SC_(106.82394332126766893738462072847739169767046971625), SC_(136.85332498040725387338106759227875748092018836985) }}, 
      {{ SC_(19.4396209716796875), SC_(0.135477006435394287109375), SC_(0.546881496906280517578125), SC_(124.823801504640430408392893354441985400626446227), SC_(117.76698461349280957449892635599695628985514034623) }}, 
      {{ SC_(19.4396209716796875), SC_(0.135477006435394287109375), SC_(0.54722058773040771484375), SC_(124.84990650514688876183409233382929949183579894535), SC_(117.7418067456648874296899602524785122574571600621) }}, 
      {{ SC_(19.4396209716796875), SC_(0.135477006435394287109375), SC_(0.6323592662811279296875), SC_(131.65532365080599943436785264217146843835026739331), SC_(111.39561317921959920665836175192852856873663391569) }}, 
      {{ SC_(19.4396209716796875), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(149.95388111047413645421560022210513803341544479096), SC_(96.24520510354300874217958004066959170628063043103) }}, 
      {{ SC_(19.4396209716796875), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(152.65737523961909894844267070259280368591721361774), SC_(94.215245357223090891406084002019307806923424256022) }}, 
      {{ SC_(19.4396209716796875), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(164.7210277415177091092357721370247209524115569294), SC_(85.724401147605860246815490336281188206841593341806) }}, 
      {{ SC_(19.4396209716796875), SC_(0.135477006435394287109375), SC_(0.9133758544921875), SC_(166.41161016964834464402794811997708852027695894311), SC_(84.603767692085929386484741961910463127861876912923) }}, 
      {{ SC_(19.4396209716796875), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(185.34098963550311856373884318848557405443365846235), SC_(73.080957266073051525369310963481921685581418547123) }}, 
      {{ SC_(19.4396209716796875), SC_(0.135477006435394287109375), SC_(0.992881298065185546875), SC_(209.04788080896296129188822476810829173802022989108), SC_(60.915837557605945157699850101496534050075253115139) }}, 
      {{ SC_(19.4396209716796875), SC_(0.814723670482635498046875), SC_(0.097540400922298431396484375), SC_(1.1166937313483211159808411039288577106477304299817), SC_(7.0538598853933835939600905882445880677785309738501) }}, 
      {{ SC_(19.4396209716796875), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(1.377208171698357215747505484968830394013707816154), SC_(6.6072653924234041150438964510939028726111915142548) }}, 
      {{ SC_(19.4396209716796875), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(1.4463230149311405095755039760337731015832427889712), SC_(6.4941683452536965803703924155102003715322771470765) }}, 
      {{ SC_(19.4396209716796875), SC_(0.814723670482635498046875), SC_(0.188381969928741455078125), SC_(1.8368984828689720558482143741274529502420020114149), SC_(5.8921564618962175713666799634518275006283447329056) }}, 
      {{ SC_(19.4396209716796875), SC_(0.814723670482635498046875), SC_(0.22103404998779296875), SC_(2.0540477335330767850717695757887443891593430417574), SC_(5.5817947149437128360164012405652928114211582671581) }}, 
      {{ SC_(19.4396209716796875), SC_(0.814723670482635498046875), SC_(0.278498232364654541015625), SC_(2.4097190959794397195197212982628282751987723603843), SC_(5.1058543858195126704379139139393039506734105720766) }}, 
      {{ SC_(19.4396209716796875), SC_(0.814723670482635498046875), SC_(0.308167040348052978515625), SC_(2.5846469597557137414777258617158691587776821986909), SC_(4.8850835141014783539317069630818518791510134798264) }}, 
      {{ SC_(19.4396209716796875), SC_(0.814723670482635498046875), SC_(0.546881496906280517578125), SC_(3.9474944526574447129368801577110408235911501914915), SC_(3.4065540663418679596905906562775333562865629847198) }}, 
      {{ SC_(19.4396209716796875), SC_(0.814723670482635498046875), SC_(0.54722058773040771484375), SC_(3.9495091590563865120326507247659723458462827993029), SC_(3.4046379781196282864457302795535964881815997130845) }}, 
      {{ SC_(19.4396209716796875), SC_(0.814723670482635498046875), SC_(0.6323592662811279296875), SC_(4.4778027852423051415188848598099942420620771631271), SC_(2.9252118266596611818091667976257214977742484128917) }}, 
      {{ SC_(19.4396209716796875), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(5.9236707207707731573571729700689342330065703419313), SC_(1.8154695965888135710753159359719230950532488978812) }}, 
      {{ SC_(19.4396209716796875), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(6.139869601345733986434504407166575221080992553264), SC_(1.6714456028893251991139685089081033260150339655669) }}, 
      {{ SC_(19.4396209716796875), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(7.1111256109418397092533208411544507833701131687914), SC_(1.0846786721192604011041176802311389422941142007423) }}, 
      {{ SC_(19.4396209716796875), SC_(0.814723670482635498046875), SC_(0.9133758544921875), SC_(7.2480062961936501178962099237976604436900381845145), SC_(1.0093968782773527337853155571999995353032636953861) }}, 
      {{ SC_(19.4396209716796875), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(8.7913848444048961115498757869726677117891986495359), SC_(0.27373711327702368705614476012729022372569397649685) }}, 
      {{ SC_(19.4396209716796875), SC_(0.814723670482635498046875), SC_(0.992881298065185546875), SC_(10.746399021623709688002433690935647132473746260038), SC_(0.0) }}, 
      {{ SC_(19.4396209716796875), SC_(0.835008561611175537109375), SC_(0.097540400922298431396484375), SC_(0.76937380651257837167230589906629567538298259909781), SC_(6.227930845619993212299652035664826946373753869742) }}, 
      {{ SC_(19.4396209716796875), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(1.0044729023004204303976483549107710829451910070826), SC_(5.8138920625395382893631916914711240244091685708361) }}, 
      {{ SC_(19.4396209716796875), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(1.0670035575951090667729769370077815513552654788614), SC_(5.7090826047865370383447262750099814727132482114579) }}, 
      {{ SC_(19.4396209716796875), SC_(0.835008561611175537109375), SC_(0.188381969928741455078125), SC_(1.4214092812623019375977810751748319750782545903961), SC_(5.1515101864365568222914602995698946896271989650285) }}, 
      {{ SC_(19.4396209716796875), SC_(0.835008561611175537109375), SC_(0.22103404998779296875), SC_(1.619100134757623869167797986080209224625469003926), SC_(4.8642939630256790958657207853323840998961653037698) }}, 
      {{ SC_(19.4396209716796875), SC_(0.835008561611175537109375), SC_(0.278498232364654541015625), SC_(1.943715557987286793409317026141378772893228005297), SC_(4.424203106229455206984565995824371771109594070314) }}, 
      {{ SC_(19.4396209716796875), SC_(0.835008561611175537109375), SC_(0.308167040348052978515625), SC_(2.1036896513563749292285003151085349284813535904621), SC_(4.2202236582156591017123361389760909237283307703974) }}, 
      {{ SC_(19.4396209716796875), SC_(0.835008561611175537109375), SC_(0.546881496906280517578125), SC_(3.355323019528913678976461923102593998897469242179), SC_(2.8575707098274709901870825525297814565243001009484) }}, 
      {{ SC_(19.4396209716796875), SC_(0.835008561611175537109375), SC_(0.54722058773040771484375), SC_(3.3571787920621057418568429423656897174355327498199), SC_(2.8558095656721032019532151255930829769190174049965) }}, 
      {{ SC_(19.4396209716796875), SC_(0.835008561611175537109375), SC_(0.6323592662811279296875), SC_(3.8442240400327573093472868109005477844220636024678), SC_(2.4156579226901714119087548635136039259865762233458) }}, 
      {{ SC_(19.4396209716796875), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(5.1806836733207283023771665638209207842985616116531), SC_(1.4019237225467993187327625984243757904977831591176) }}, 
      {{ SC_(19.4396209716796875), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(5.3808684798177529532076477033266626691955525753984), SC_(1.2710781698799036301545218946501661196958567620572) }}, 
      {{ SC_(19.4396209716796875), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(6.2810406557709563646801112811568875087918620952726), SC_(0.74055416713516124135752279000812882328962787967167) }}, 
      {{ SC_(19.4396209716796875), SC_(0.835008561611175537109375), SC_(0.9133758544921875), SC_(6.4080038219869195513300481198875281145078235425557), SC_(0.67285539755179811611912140250643629705509188574179) }}, 
      {{ SC_(19.4396209716796875), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(7.8409463124978356524789934350360672754046245131988), SC_(0.018221040692848489593575087294145737526784671836913) }}, 
      {{ SC_(19.4396209716796875), SC_(0.835008561611175537109375), SC_(0.992881298065185546875), SC_(9.6589028309669875818843197931847178319565040159789), SC_(0.0) }}, 
      {{ SC_(19.4396209716796875), SC_(0.905791938304901123046875), SC_(0.097540400922298431396484375), SC_(0.0), SC_(3.5392606161394667963325212881270833818959367061567) }}, 
      {{ SC_(19.4396209716796875), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(0.0), SC_(3.2389783381082832181636469607598646267918867774475) }}, 
      {{ SC_(19.4396209716796875), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(0.0), SC_(3.1631412166165860228967224472399809657349973510432) }}, 
      {{ SC_(19.4396209716796875), SC_(0.905791938304901123046875), SC_(0.188381969928741455078125), SC_(0.17762428958228061840904614075024134757094893099661), SC_(2.761027699419567801337589912188118963506080267528) }}, 
      {{ SC_(19.4396209716796875), SC_(0.905791938304901123046875), SC_(0.22103404998779296875), SC_(0.30594119267875838691006989522753507559504187859011), SC_(2.5548553517009618686267837296768249021636612470124) }}, 
      {{ SC_(19.4396209716796875), SC_(0.905791938304901123046875), SC_(0.278498232364654541015625), SC_(0.52012246949052635928104198110355182030362867576475), SC_(2.2404067973676897464856041799608120152691011035719) }}, 
      {{ SC_(19.4396209716796875), SC_(0.905791938304901123046875), SC_(0.308167040348052978515625), SC_(0.62703573660863785291482527052139282161809586813954), SC_(2.0953296144698993598863361150945268257047357048713) }}, 
      {{ SC_(19.4396209716796875), SC_(0.905791938304901123046875), SC_(0.546881496906280517578125), SC_(1.4858725290501716059710760994200143976878562706951), SC_(1.1403221385837576174780305908569360818835331197838) }}, 
      {{ SC_(19.4396209716796875), SC_(0.905791938304901123046875), SC_(0.54722058773040771484375), SC_(1.4871688468089233091479444531502378892252742404235), SC_(1.1391077248729542714881807435780204014291123652318) }}, 
      {{ SC_(19.4396209716796875), SC_(0.905791938304901123046875), SC_(0.6323592662811279296875), SC_(1.8291608963578030268534219944933451317245972938117), SC_(0.83771785814261707074670990832909264697612038633952) }}, 
      {{ SC_(19.4396209716796875), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(2.7820080210406442034311026912888335656678173274795), SC_(0.16507536970809509339066038058178058977154582860386) }}, 
      {{ SC_(19.4396209716796875), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(2.9261546306617076486692889821602091248317304489431), SC_(0.081310745444849958265226410224992699474593964135359) }}, 
      {{ SC_(19.4396209716796875), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(3.5778547016928082639017855745169400497430827263207), SC_(0.0) }}, 
      {{ SC_(19.4396209716796875), SC_(0.905791938304901123046875), SC_(0.9133758544921875), SC_(3.6701832578632035050636645976223553834807398342364), SC_(0.0) }}, 
      {{ SC_(19.4396209716796875), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(4.7178919857179393592989077370772099771750753529823), SC_(0.0) }}, 
      {{ SC_(19.4396209716796875), SC_(0.905791938304901123046875), SC_(0.992881298065185546875), SC_(6.0586497369604994218220517403606276160386680763016), SC_(0.0) }}, 
      {{ SC_(19.4396209716796875), SC_(0.968867778778076171875), SC_(0.097540400922298431396484375), SC_(0.0), SC_(1.2086622554331304182480637307011278598693732023357) }}, 
      {{ SC_(19.4396209716796875), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(0.0), SC_(1.0272387729801116071985531912629002010377497536151) }}, 
      {{ SC_(19.4396209716796875), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(0.0), SC_(0.98168467541389226291319478321818737656984195843519) }}, 
      {{ SC_(19.4396209716796875), SC_(0.968867778778076171875), SC_(0.188381969928741455078125), SC_(0.0), SC_(0.74214281026112422045452538815742688814928990265441) }}, 
      {{ SC_(19.4396209716796875), SC_(0.968867778778076171875), SC_(0.22103404998779296875), SC_(0.0), SC_(0.62077663711177133205078402931028598662881729306103) }}, 
      {{ SC_(19.4396209716796875), SC_(0.968867778778076171875), SC_(0.278498232364654541015625), SC_(0.0), SC_(0.43787651619733456336656945256392535294523267524984) }}, 
      {{ SC_(19.4396209716796875), SC_(0.968867778778076171875), SC_(0.308167040348052978515625), SC_(0.0), SC_(0.35450023138914178146547561208412540946204728538707) }}, 
      {{ SC_(19.4396209716796875), SC_(0.968867778778076171875), SC_(0.546881496906280517578125), SC_(0.012802494123647950223168474309581494381832771706813), SC_(0.0) }}, 
      {{ SC_(19.4396209716796875), SC_(0.968867778778076171875), SC_(0.54722058773040771484375), SC_(0.01351217161992312485473293903902561720437751939435), SC_(0.0) }}, 
      {{ SC_(19.4396209716796875), SC_(0.968867778778076171875), SC_(0.6323592662811279296875), SC_(0.20342707639964025244334339316221582344872239751531), SC_(0.0) }}, 
      {{ SC_(19.4396209716796875), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(0.7545516975039009601043421726947152630192871269055), SC_(0.0) }}, 
      {{ SC_(19.4396209716796875), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(0.84008310304870933900762310739787943195896636942928), SC_(0.0) }}, 
      {{ SC_(19.4396209716796875), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(1.2320944989087478956108278707140130190064010300436), SC_(0.0) }}, 
      {{ SC_(19.4396209716796875), SC_(0.968867778778076171875), SC_(0.9133758544921875), SC_(1.288251242897032573885223265595270607913214489441), SC_(0.0) }}, 
      {{ SC_(19.4396209716796875), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(1.9340264063290560542153517314853047813246263432306), SC_(0.0) }}, 
      {{ SC_(19.4396209716796875), SC_(0.968867778778076171875), SC_(0.992881298065185546875), SC_(2.7777959429252388177693504941218583273466700132889), SC_(0.0) }}, 
      {{ SC_(27.2588958740234375), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(144.07513508740869491259487446234170750508169497111), SC_(231.20815044746776782497419684965671569027854982903) }}, 
      {{ SC_(27.2588958740234375), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(145.38279744423961477798150456298910257889418300686), SC_(229.46178957600224752188566678153572078246853741039) }}, 
      {{ SC_(27.2588958740234375), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(220.59616548190531329631650077229480231317647653757), SC_(152.23563682370319425783018928206546185835413491435) }}, 
      {{ SC_(27.2588958740234375), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(223.96740423279465714480925979838596884375858592398), SC_(149.58671278013147384323628706749703945329537632143) }}, 
      {{ SC_(27.2588958740234375), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(238.94712486662445477089115455007329064499525422233), SC_(138.43912190396106046134407545891365729978047592707) }}, 
      {{ SC_(27.2588958740234375), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(264.33509627094776600745099246216596279271249769546), SC_(121.61002589834186255658709561379511521246221926519) }}, 
      {{ SC_(27.2588958740234375), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(133.50257989201279632536565963703652196242272464894), SC_(214.77658512024925211230864014363999016837671962176) }}, 
      {{ SC_(27.2588958740234375), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(134.72223366435091084073263247404402158864974565572), SC_(213.14758506721348427227380385618391204405543081289) }}, 
      {{ SC_(27.2588958740234375), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(204.87778711991831602729095191868978880351157495223), SC_(141.1139195723593774273195858167080281005155363321) }}, 
      {{ SC_(27.2588958740234375), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(208.02245137823182029016400385359048414674131314282), SC_(138.64324051238817511756625663651242905041297089167) }}, 
      {{ SC_(27.2588958740234375), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(221.9954976211434689789446948097295819439860921087), SC_(128.24592710779115128577220838213003011582436850879) }}, 
      {{ SC_(27.2588958740234375), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(245.67759793071083779890698619649121687624768617662), SC_(112.55010085647616295785823252138014557768217348885) }}, 
      {{ SC_(27.2588958740234375), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(2.6607165825750433300919767381603586543832700967989), SC_(8.881533074929377045469347141552445020725265260108) }}, 
      {{ SC_(27.2588958740234375), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(2.7472829535621744765685093521280203474526429988019), SC_(8.7511324252152701767482899565194618891255911383111) }}, 
      {{ SC_(27.2588958740234375), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(8.0915124729274133034099921151988823926851538571664), SC_(3.2061128015101830491561441715861713449311924950837) }}, 
      {{ SC_(27.2588958740234375), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(8.3418568994685436694324647442720142902064517135963), SC_(3.0277637485270054135639477267733250594454907770701) }}, 
      {{ SC_(27.2588958740234375), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(9.4611170082588398955098069474596269211297025920604), SC_(2.2916195592284244315767264945208217881334707484042) }}, 
      {{ SC_(27.2588958740234375), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(11.379596301445795999032375587877420275307757293056), SC_(1.2363926494981763065715389681000638617657879922478) }}, 
      {{ SC_(27.2588958740234375), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(2.0940137004463749519944647232649249988155004422935), SC_(7.8162269855027504498534094254198014525865134588289) }}, 
      {{ SC_(27.2588958740234375), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(2.1726485473263278243881523152460295003360728027332), SC_(7.6954692798040937123186195389078336546047103633434) }}, 
      {{ SC_(27.2588958740234375), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(7.0849406876620213085986006206168004183488625731205), SC_(2.5902835088702270120612196849541550505319609897993) }}, 
      {{ SC_(27.2588958740234375), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(7.3165896284602548626896779702237104505144974912214), SC_(2.4277879599991009801089691757470663543007238470582) }}, 
      {{ SC_(27.2588958740234375), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(8.3531772993719703673130985967184758943356763784268), SC_(1.7593967476431133215054497578722335272263495332029) }}, 
      {{ SC_(27.2588958740234375), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(10.132777363120719048228615681719505009731132001144), SC_(0.81083615125429476414523111178408417824643490422822) }}, 
      {{ SC_(27.2588958740234375), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(0.41177113983187812598568093978518110057847619345565), SC_(4.3732718112850936385603545425019380390496519982994) }}, 
      {{ SC_(27.2588958740234375), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(0.46192420820501252456568834699188236394150695647455), SC_(4.2862597168261230360303712711553298464634444971153) }}, 
      {{ SC_(27.2588958740234375), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(3.8476334179667165849011159915936114509441729561007), SC_(0.73206405316794532118978496413280877159666675712079) }}, 
      {{ SC_(27.2588958740234375), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(4.0137950027010035240619024025747106885019139161139), SC_(0.62624939895901339828962332375143081046590458991839) }}, 
      {{ SC_(27.2588958740234375), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(4.7611006017330206394055191825089358130759203419699), SC_(0.20133224904524454371136818470564201177527411822668) }}, 
      {{ SC_(27.2588958740234375), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(6.0556721280994300993038937843095059256059772715562), SC_(0.0) }}, 
      {{ SC_(27.2588958740234375), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(0.0), SC_(1.456397993849520565449997746649481168748896218119) }}, 
      {{ SC_(27.2588958740234375), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(0.0), SC_(1.4047397247564702156285428567448074038471027625429) }}, 
      {{ SC_(27.2588958740234375), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(1.1463278846430592435737403265810211498473193311565), SC_(0.0) }}, 
      {{ SC_(27.2588958740234375), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(1.243811079567454368514313395176954030551653166766), SC_(0.0) }}, 
      {{ SC_(27.2588958740234375), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(1.6880833622663971034220330281266258416824357327572), SC_(0.0) }}, 
      {{ SC_(27.2588958740234375), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(2.4756149299188790593033186723101481776197461799557), SC_(0.0) }}, 
      {{ SC_(29.0838165283203125), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(155.16981585927166011450805944236750222072210281018), SC_(245.20544982041673261407196787765523131989099246816) }}, 
      {{ SC_(29.0838165283203125), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(156.52806645776173985618067884504346774614634031635), SC_(243.40844664208978834061954386281869896456503589319) }}, 
      {{ SC_(29.0838165283203125), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(234.28179813259445941207039184299060047637009843347), SC_(163.6417074517993666455092292891585293942145042164) }}, 
      {{ SC_(29.0838165283203125), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(237.75308015922423563866624499920917124753161915021), SC_(160.8928153151608129029319726280201373913548004677) }}, 
      {{ SC_(29.0838165283203125), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(253.16589330112044459925837868008362103345202698857), SC_(149.31262011593241897561712634438406473055812355457) }}, 
      {{ SC_(29.0838165283203125), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(279.24886525262663948140733878084275351056612053913), SC_(131.79015520955477308587516755164407346638282777712) }}, 
      {{ SC_(29.0838165283203125), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(143.79422959660821089939945689799270178029938771484), SC_(227.77569918547774046048478229327027196115943684545) }}, 
      {{ SC_(29.0838165283203125), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(145.06107067935538666996287736179238735827264554838), SC_(226.09946165367715986382482768513120779982006249608) }}, 
      {{ SC_(29.0838165283203125), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(217.5861888689150141072686733486712580050223308136), SC_(151.69602466752218841914525103326986944939696558855) }}, 
      {{ SC_(29.0838165283203125), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(220.82417011671561089166291600083943407681147095089), SC_(149.13209839003870874000749331752811394026556398624) }}, 
      {{ SC_(29.0838165283203125), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(235.201190871320176748500750206332118677628160036), SC_(138.33126346050120881239321098967781272637559796081) }}, 
      {{ SC_(29.0838165283203125), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(259.53156674447116820571176140440917055693457184785), SC_(121.98867521472490086119947915321318968746351133647) }}, 
      {{ SC_(29.0838165283203125), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(2.9711094631096942670435588021131057179233089937417), SC_(9.4013304969885952117655155083967862662937946706558) }}, 
      {{ SC_(29.0838165283203125), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(3.0613595872426838465871969182208963376640993632804), SC_(9.2672721553926612090116490672556425488715397041004) }}, 
      {{ SC_(29.0838165283203125), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(8.5888134247656071920988605228300795524950098540652), SC_(3.5391288373796271483486027999289317211610230913261) }}, 
      {{ SC_(29.0838165283203125), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(8.8463755550876328059471827407847377842272678911935), SC_(3.3535294823700452644843167132011859464688844695289) }}, 
      {{ SC_(29.0838165283203125), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(9.9969214689526802202242105577330571449195071838317), SC_(2.5858588920489410283402169878310043514580491228035) }}, 
      {{ SC_(29.0838165283203125), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(11.965764472228821347663201648658854011696311873683), SC_(1.4792533309588510221489041946993697363756320464691) }}, 
      {{ SC_(29.0838165283203125), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(2.3582528314093315729001311632125545998967685981575), SC_(8.273398586498129063621447113971820768171877873711) }}, 
      {{ SC_(29.0838165283203125), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(2.4402870300172844178804566852109707513572591859207), SC_(8.1492700647166369866892285935072169937199727391737) }}, 
      {{ SC_(29.0838165283203125), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(7.5213823656290560587765803548200040829452046649388), SC_(2.8753904377859857908672893275301584996853769838633) }}, 
      {{ SC_(29.0838165283203125), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(7.7596816933587790668429854182096047538128505425939), SC_(2.7062092609774977148215997794851329566334753347158) }}, 
      {{ SC_(29.0838165283203125), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(8.825102173178121176173371704714139105722726425392), SC_(2.0087211701429259900394461410297495569500660486666) }}, 
      {{ SC_(29.0838165283203125), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(10.651140345398594712043691429321342029242227158495), SC_(1.0125848116728864204073097719585797250395275173309) }}, 
      {{ SC_(29.0838165283203125), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(0.53460169694206747939995494008241904342379369164424), SC_(4.6307913449420265174582126178816874690262787891544) }}, 
      {{ SC_(29.0838165283203125), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(0.58714176430890879011942573769579803110395246905988), SC_(4.5414186635875912839161200819669085696938494124902) }}, 
      {{ SC_(29.0838165283203125), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(4.0906455962791198629317950408858446318216837282683), SC_(0.86952158317377485982498223378061168447253579137345) }}, 
      {{ SC_(29.0838165283203125), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(4.2614587761317841711322795211412169598509262657781), SC_(0.75902712260325887618700950869914819802079299587116) }}, 
      {{ SC_(29.0838165283203125), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(5.0289594766153382056479490959677137265112721253974), SC_(0.31366600942644831373220794395712357561658703178439) }}, 
      {{ SC_(29.0838165283203125), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(6.356160243633407588714563664062745383758802272117), SC_(0.0) }}, 
      {{ SC_(29.0838165283203125), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(0.0), SC_(1.5524004290087638030543363526021797231662642183749) }}, 
      {{ SC_(29.0838165283203125), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(0.0), SC_(1.4994541311063440660604926136600264116869805810802) }}, 
      {{ SC_(29.0838165283203125), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(1.2344370562145078365726495799099435419004999900374), SC_(0.0) }}, 
      {{ SC_(29.0838165283203125), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(1.3344452141461399991290070340577327354186502952798), SC_(0.0) }}, 
      {{ SC_(29.0838165283203125), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(1.7897436797511505638626799545061378993762144919093), SC_(0.0) }}, 
      {{ SC_(29.0838165283203125), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(2.5952976223359616700581878181452145105072697718789), SC_(0.0) }}, 
      {{ SC_(50.492671966552734375), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(287.91512075778359356300514116921451840225893612182), SC_(406.8243168421740370347821804388274850118615307488) }}, 
      {{ SC_(50.492671966552734375), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(289.77702702790598442345684279891907506988078525618), SC_(404.52331800526276981565857260131124581240054164859) }}, 
      {{ SC_(50.492671966552734375), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(392.79937376752152129444232429143330915340031815898), SC_(299.48656321127078035072511879148917030848839478288) }}, 
      {{ SC_(50.492671966552734375), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(397.26604354849777032765798188323689016742442056957), SC_(295.74275581484987865915502078187839448855383495658) }}, 
      {{ SC_(50.492671966552734375), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(416.98919821398305654797718179156006670956163484808), SC_(279.85528942729789835057576190327894124169144227507) }}, 
      {{ SC_(50.492671966552734375), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(449.99454215683405783290289173864298073746644012975), SC_(255.42072975293351557876711239524552443459603774123) }}, 
      {{ SC_(50.492671966552734375), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(266.9447897708271184038891225227435274560139255766), SC_(377.85851115170720816814299637035530529611938777061) }}, 
      {{ SC_(50.492671966552734375), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(268.68142541051374370398371604406904876765773791271), SC_(375.71216359690125579584829859154285539667689120607) }}, 
      {{ SC_(50.492671966552734375), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(364.77622282553357447242484737631837576872136269906), SC_(277.73774778411687879330065614608520945456454455107) }}, 
      {{ SC_(50.492671966552734375), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(368.94266725446057544429853130600398682158367192502), SC_(274.24579678190525030018735949888412537040449488691) }}, 
      {{ SC_(50.492671966552734375), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(387.34022857341565239796084448681642832494775496896), SC_(259.42727012651280180764629709268294121467099533606) }}, 
      {{ SC_(50.492671966552734375), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(418.1275727922986500332715266863356689978654911864), SC_(236.63724726710307523195060000678458058353352953547) }}, 
      {{ SC_(50.492671966552734375), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(6.7996860628811881777584406898358952768423040118176), SC_(15.310837785725209785283663073296755799837763440904) }}, 
      {{ SC_(50.492671966552734375), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(6.9264740556389419825661527920433770769337989014664), SC_(15.140421518591362886721380067338566224270652628753) }}, 
      {{ SC_(50.492671966552734375), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(14.274703975348713316376829753300305709746607848438), SC_(7.5922086290704550373407242682847450378525790987307) }}, 
      {{ SC_(50.492671966552734375), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(14.604010550434282970712766700031244373890287258051), SC_(7.3346334396617408593127855120939393022138288639748) }}, 
      {{ SC_(50.492671966552734375), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(16.065543199504931681512331576987363165697619967306), SC_(6.2543240935211529814611943155638217578029875480023) }}, 
      {{ SC_(50.492671966552734375), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(18.535079063457269235847983305512300657974093413741), SC_(4.640421900253913203680072421106492207403361712825) }}, 
      {{ SC_(50.492671966552734375), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(5.630507175448693011258520719181572265500184113895), SC_(13.4627489240345598656489270320784144435561762366) }}, 
      {{ SC_(50.492671966552734375), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(5.7462439937487906365000231767667362773894803219075), SC_(13.305119590990879077452317880892424450487655188412) }}, 
      {{ SC_(50.492671966552734375), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(12.504704890770686532964070258482126382007724184164), SC_(6.3546625102572452502045237007176491658832832250584) }}, 
      {{ SC_(50.492671966552734375), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(12.80910131499196058144092828520292094496735632876), SC_(6.1191270159782958977735900981906141743007446080278) }}, 
      {{ SC_(50.492671966552734375), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(14.161076393267976075885006737493797358063703882733), SC_(5.1332282191492566837150497735943208314887885078231) }}, 
      {{ SC_(50.492671966552734375), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(16.448655517252383357632267382820889533156290590692), SC_(3.6679970617349622641223367635019117640269062326456) }}, 
      {{ SC_(50.492671966552734375), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(2.0934470758618288270801105514284801297851911290346), SC_(7.5288487392494985680333829411833744529990492579891) }}, 
      {{ SC_(50.492671966552734375), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(2.1696951836336911623074926094594454135342075089408), SC_(7.4160362395410171277805442050335154108311124878374) }}, 
      {{ SC_(50.492671966552734375), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(6.8446249901196701632291889400102043158082826998557), SC_(2.5737162916779030596125818880982114271242861012535) }}, 
      {{ SC_(50.492671966552734375), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(7.0616415230011582080019534463305798907712565345912), SC_(2.4167007021823743164740479808914021280341695096835) }}, 
      {{ SC_(50.492671966552734375), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(8.029665744149292958568564449454182126632830774164), SC_(1.7683185208887882906952105047226371613112534794461) }}, 
      {{ SC_(50.492671966552734375), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(9.680657502607467476743769437829888168284408490266), SC_(0.83990659830939867318097824096918818790276499609261) }}, 
      {{ SC_(50.492671966552734375), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(0.0), SC_(2.6086299563307524437196264515840176477358510617583) }}, 
      {{ SC_(50.492671966552734375), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(0.0), SC_(2.5429168933239374743898667059640815146047169066545) }}, 
      {{ SC_(50.492671966552734375), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(2.2123641106649883817655435214162807881532153106463), SC_(0.0) }}, 
      {{ SC_(50.492671966552734375), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(2.3374379238280306031655098912004642070465527699384), SC_(0.0) }}, 
      {{ SC_(50.492671966552734375), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(2.9020090226442076165168567456633633290799489966108), SC_(0.0) }}, 
      {{ SC_(50.492671966552734375), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(3.8856575102437326584809446993448185626866075382222), SC_(0.0) }}, 
      {{ SC_(78.72027587890625), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(467.10947924350797223876553341133127805115369220702), SC_(615.74987447029358330477554589289714402420401008601) }}, 
      {{ SC_(78.72027587890625), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(469.49046492431700744962983978265789479885510207385), SC_(612.92963210979420152989524982905412632609019401103) }}, 
      {{ SC_(78.72027587890625), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(598.5303143825455790847960686238996763170465906351), SC_(481.87469888242848779356835494849094793564121134178) }}, 
      {{ SC_(78.72027587890625), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(604.0222002477156436878190322093194003852192112971), SC_(477.10590329842545228397398333120821899536979261924) }}, 
      {{ SC_(78.72027587890625), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(628.18630345840913140751064441404545498809558688236), SC_(456.77897067487527352017437943261784760801868224554) }}, 
      {{ SC_(78.72027587890625), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(668.32999792810013247697579573473811562231890304853), SC_(425.21103155180135097160116399481313587333089707358) }}, 
      {{ SC_(78.72027587890625), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(433.20814440207925501987761985220051496979331349575), SC_(571.85405766749664817979596464549309863692337262227) }}, 
      {{ SC_(78.72027587890625), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(435.42895980088784193837240960902025726104361104407), SC_(569.22337808650080750138177590401281585957894339042) }}, 
      {{ SC_(78.72027587890625), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(555.79194420763094762482334757074743932431850772374), SC_(446.98014831970432405409599207146455360320590376833) }}, 
      {{ SC_(78.72027587890625), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(560.9146735307607299026222748391010180797459808951), SC_(442.53212388158789751520832237178585647681661945618) }}, 
      {{ SC_(78.72027587890625), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(583.45459518494739988503124527234955690655647569949), SC_(423.57261218971711009227415189154135643549159909504) }}, 
      {{ SC_(78.72027587890625), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(620.9003512103775769227499321134339356091101899666), SC_(394.12878913041926636821850232118706768759673334264) }}, 
      {{ SC_(78.72027587890625), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(12.14909982793806491207236430097414257983415199916), SC_(22.800213365855362746151819444541478569154581401041) }}, 
      {{ SC_(78.72027587890625), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(12.313384741864300890787355098167286738053945947977), SC_(22.592395357410373744535002536449477663450309684333) }}, 
      {{ SC_(78.72027587890625), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(21.534042100243757256647696076716745295384769023078), SC_(13.172136135512714922618103688638548371972314618548) }}, 
      {{ SC_(78.72027587890625), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(21.937153459837320103502192994493499025656696161425), SC_(12.840629795000440384848652780993670879533016428623) }}, 
      {{ SC_(78.72027587890625), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(23.71860211488675719853513322880638313865893018719), SC_(11.439536473676093633348805254971195171043739082202) }}, 
      {{ SC_(78.72027587890625), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(26.703251773637015659364009336810326707035999642143), SC_(9.3072860814992055331712139923571436980498448264822) }}, 
      {{ SC_(78.72027587890625), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(10.222682417528471368175194147574980814253213581795), SC_(20.02608238549223207830712276293500165964404949871) }}, 
      {{ SC_(78.72027587890625), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(10.372983246474333779720883597010862619850867649539), SC_(19.833997934970769085743216740852793052231039570243) }}, 
      {{ SC_(78.72027587890625), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(18.85613529005274091262186039651384320333146488055), SC_(11.159284370091222079170399298769764152135949093676) }}, 
      {{ SC_(78.72027587890625), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(19.2285154306410137893711405749393513080386016956), SC_(10.855621312310170110923838885065739551069316721795) }}, 
      {{ SC_(78.72027587890625), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(20.875206894315669398812566222282869674097124270577), SC_(9.5740120303190181878855195994677021614815798627183) }}, 
      {{ SC_(78.72027587890625), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(23.637455813632133814596849448254041605547260051724), SC_(7.6303631200162629163715655960184521780450277103408) }}, 
      {{ SC_(78.72027587890625), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(4.3415846345025556091558343340327730975457672489441), SC_(11.153498480504174763224797759400650161909175748475) }}, 
      {{ SC_(78.72027587890625), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(4.4420940722508273181755080577806546163043927112015), SC_(11.016607962990034396935271297640309480443272401701) }}, 
      {{ SC_(78.72027587890625), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(10.321243584378777919429913970681516737543550787398), SC_(4.9707832120908980463615108293024128139441165560393) }}, 
      {{ SC_(78.72027587890625), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(10.585739094865923040926942191158976366664592400403), SC_(4.7660555216158261807531548615711095731571152148273) }}, 
      {{ SC_(78.72027587890625), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(11.759737179998043466850145328863384887385203419568), SC_(3.910012712757551891354491934570684757119559847066) }}, 
      {{ SC_(78.72027587890625), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(13.74305354215741524879238355943113693661411548877), SC_(2.6423796620761183052110650607737220926913375974701) }}, 
      {{ SC_(78.72027587890625), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(0.26760169048072322686614067187819283033514604065561), SC_(3.8908598880080669539962600344458100142797440881114) }}, 
      {{ SC_(78.72027587890625), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(0.31376730026807870597642451820184082852914444851524), SC_(3.8120687501389319519673779000844340161076579415938) }}, 
      {{ SC_(78.72027587890625), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(3.4143046559274235060260114728977909680504875108572), SC_(0.56250581861537728594177521503988627448575142286204) }}, 
      {{ SC_(78.72027587890625), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(3.5651007673315295982018067173911192175907682539131), SC_(0.46506584135608068214380217299145855856568768636401) }}, 
      {{ SC_(78.72027587890625), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(4.2415868955657997312325001235923418329503274676668), SC_(0.074011360117937350116586280294333863103809080606752) }}, 
      {{ SC_(78.72027587890625), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(5.4069836033073418628501098304808796774477374847431), SC_(0.0) }}, 
      {{ SC_(92.12715911865234375), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(553.17577743318335227280870715877115163248637442042), SC_(714.02369059848550270117176277277191630949820047438) }}, 
      {{ SC_(92.12715911865234375), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(555.7699682791096595070522705490151388337394549222), SC_(710.99020051284902274966816123569081797932455817849) }}, 
      {{ SC_(92.12715911865234375), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(695.49222053797815159200911935480497353148095013503), SC_(569.25268928425558406945306080227920795830451419404) }}, 
      {{ SC_(92.12715911865234375), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(701.40510314921338379917059378749609952055501071696), SC_(564.06295603655085880906091241870585168494052904939) }}, 
      {{ SC_(92.12715911865234375), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(727.39309050677422957306429713837680329272131489575), SC_(541.91252370519847454593654600378600637832335000814) }}, 
      {{ SC_(92.12715911865234375), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(770.46954529961494848185047056383150010444353223955), SC_(507.41311450703861648724251603792203001218333121348) }}, 
      {{ SC_(92.12715911865234375), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(513.06845138522271366569160024324789609878200788382), SC_(663.10109205711265433940184144464475811811270903286) }}, 
      {{ SC_(92.12715911865234375), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(515.48813712112403149425031417057097191130142374963), SC_(660.27150265202113991977938480183032594525807062454) }}, 
      {{ SC_(92.12715911865234375), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(645.81527632505576569591487160164810320411900643227), SC_(528.06395553367983169635827530202769879115321852193) }}, 
      {{ SC_(92.12715911865234375), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(651.33069615193245584617400711329803812367616882782), SC_(523.22329541034066454305251143509915890149928254503) }}, 
      {{ SC_(92.12715911865234375), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(675.57187157983422688213318255280673014565403799446), SC_(502.56288662267651518990751546488087921916015283741) }}, 
      {{ SC_(92.12715911865234375), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(715.75320453671706042980578052637869102287673375099), SC_(470.38468359580139568995640348917589246520510201977) }}, 
      {{ SC_(92.12715911865234375), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(14.758919664363396478281568106218817927948329904367), SC_(26.288180326306165501179409955628086520199635672555) }}, 
      {{ SC_(92.12715911865234375), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(14.938579864105660666511213603402537968109417789605), SC_(26.065012437534724617651938036133539676956436820288) }}, 
      {{ SC_(92.12715911865234375), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(24.927599829123843133576503663633090549517851151139), SC_(15.876493126091009319691661146561222960653188841038) }}, 
      {{ SC_(92.12715911865234375), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(25.361001436225663229460354127286038714506547009422), SC_(15.514662382720368120424791913788512283259887946042) }}, 
      {{ SC_(92.12715911865234375), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(27.273745324966993044574586686603457773527136891786), SC_(13.982042769871186416350255670518588253697924622787) }}, 
      {{ SC_(92.12715911865234375), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(30.469800919851376723161756532600568182790062738839), SC_(11.637550121554691574118595713674314738525094567757) }}, 
      {{ SC_(92.12715911865234375), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(12.467420989330169784808554599436886461299502952278), SC_(23.079625774899778808028313882200611939110164668528) }}, 
      {{ SC_(92.12715911865234375), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(12.631890123927201204761585470570704884383152082692), SC_(22.87340223722446661623001987943346192495663124139) }}, 
      {{ SC_(92.12715911865234375), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(21.822720066251030102419232582491070862454292414274), SC_(13.491128416521714294347417960881275967576427284246) }}, 
      {{ SC_(92.12715911865234375), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(22.222999078351180087401304357517203517359656917419), SC_(13.159527345617945825675114211463534999097699448474) }}, 
      {{ SC_(92.12715911865234375), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(23.990630669518946192102064187397126829115795437605), SC_(11.756711995198832863026678437285810280807776845707) }}, 
      {{ SC_(92.12715911865234375), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(26.947655103541120960375280057907325148397322822006), SC_(9.6173168408220144467674927871179150470698539789327) }}, 
      {{ SC_(92.12715911865234375), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(5.4538193319736142740164311787584242237840004561015), SC_(12.830284613921795871162495072288272207404727645874) }}, 
      {{ SC_(92.12715911865234375), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(5.56425533483261753437400077190505932981823153677), SC_(12.683519483212207922479172171596295789157127184233) }}, 
      {{ SC_(92.12715911865234375), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(11.937315175579431174388641286127142287473068132514), SC_(6.1439901513771098381342117071178465080694244670914) }}, 
      {{ SC_(92.12715911865234375), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(12.221285499963922380327952336460750199909932925495), SC_(5.9197198911134598796256402200026499320945029942917) }}, 
      {{ SC_(92.12715911865234375), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(13.479753436528949778218818924466018443603252329146), SC_(4.9787316567680169164760463300453838990905264488001) }}, 
      {{ SC_(92.12715911865234375), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(15.599301033472576832749707723841953771519913283776), SC_(3.5730213735811406301487103247675045909679942160226) }}, 
      {{ SC_(92.12715911865234375), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(0.54693702104896340676770870351785027652089624451382), SC_(4.4749974873298243047715212940538396207571326188943) }}, 
      {{ SC_(92.12715911865234375), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(0.59852229259601578140205390739929228720474998682566), SC_(4.3908514588203478301305015017568796195470327513194) }}, 
      {{ SC_(92.12715911865234375), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(3.9655537583654966363547957422295326080334084928664), SC_(0.87502311861630798063580935268468363098503146993293) }}, 
      {{ SC_(92.12715911865234375), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(4.1268899058228638237672520120171239938716512936606), SC_(0.76697387080780410242928525952810700834268814837358) }}, 
      {{ SC_(92.12715911865234375), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(4.8491960557963980035292148074528431720035358814699), SC_(0.3294894953986609916033336626015524599685183842467) }}, 
      {{ SC_(92.12715911865234375), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(6.0888794890331687161400088157347320247735404922968), SC_(0.0) }}, 
      {{ SC_(272.01507568359375), SC_(0.12698681652545928955078125), SC_(0.12698681652545928955078125), SC_(1731.9472261440476649223465153309330130218413488263), SC_(2008.6508614482898537589120267609649496227106232271) }}, 
      {{ SC_(272.01507568359375), SC_(0.12698681652545928955078125), SC_(0.135477006435394287109375), SC_(1736.5657188363527475950980149268636394029462377856), SC_(2003.5929048812123568598412541899222837974710430322) }}, 
      {{ SC_(272.01507568359375), SC_(0.12698681652545928955078125), SC_(0.814723670482635498046875), SC_(1977.6658673375844247879890881951720880388365161323), SC_(1760.4768198171724421292970489746793096978268967189) }}, 
      {{ SC_(272.01507568359375), SC_(0.12698681652545928955078125), SC_(0.835008561611175537109375), SC_(1987.5748594608302442841747545677159525079523245726), SC_(1751.2912055326039226777743030902590011897101925503) }}, 
      {{ SC_(272.01507568359375), SC_(0.12698681652545928955078125), SC_(0.905791938304901123046875), SC_(2030.8783270970520646604300718973721137858224679932), SC_(1711.8267801508003405716493887320367033273610294175) }}, 
      {{ SC_(272.01507568359375), SC_(0.12698681652545928955078125), SC_(0.968867778778076171875), SC_(2101.8113422970922083642790340601954025169695424125), SC_(1649.4758057819173329762151299386537052435298561197) }}, 
      {{ SC_(272.01507568359375), SC_(0.135477006435394287109375), SC_(0.12698681652545928955078125), SC_(1606.9588926170896846656483498669616920264800063803), SC_(1865.057452017667176593967617721748030174574264553) }}, 
      {{ SC_(272.01507568359375), SC_(0.135477006435394287109375), SC_(0.135477006435394287109375), SC_(1611.2667735720526275769754427075345791326588821219), SC_(1860.3395146496086474589192537460496493858774855093) }}, 
      {{ SC_(272.01507568359375), SC_(0.135477006435394287109375), SC_(0.814723670482635498046875), SC_(1836.1554479864639370648835563618943915719578810277), SC_(1633.56980365889531443250244303087265264199083508) }}, 
      {{ SC_(272.01507568359375), SC_(0.135477006435394287109375), SC_(0.835008561611175537109375), SC_(1845.3982911408671590706536085656002496777088731952), SC_(1625.0019321861851545406845067942874599651470621026) }}, 
      {{ SC_(272.01507568359375), SC_(0.135477006435394287109375), SC_(0.905791938304901123046875), SC_(1885.7907110481644515101822055156909400229778888105), SC_(1588.191658721632658396114548288332485386501979879) }}, 
      {{ SC_(272.01507568359375), SC_(0.135477006435394287109375), SC_(0.968867778778076171875), SC_(1951.9556388864961118467559147283521688612466094879), SC_(1530.0344949644168449167765519849025766327756184264) }}, 
      {{ SC_(272.01507568359375), SC_(0.814723670482635498046875), SC_(0.12698681652545928955078125), SC_(51.503721941681047189668059038480794252231740904069), SC_(71.360223781060499173547846106290476517830049479487) }}, 
      {{ SC_(272.01507568359375), SC_(0.814723670482635498046875), SC_(0.135477006435394287109375), SC_(51.829056034111796423875447973035142234788106480785), SC_(70.99148267506361758813861884362168309942833447231) }}, 
      {{ SC_(272.01507568359375), SC_(0.814723670482635498046875), SC_(0.814723670482635498046875), SC_(69.104281405069657731505451366525028624435678534001), SC_(53.517167321218393705996392789877790658918806192461) }}, 
      {{ SC_(272.01507568359375), SC_(0.814723670482635498046875), SC_(0.835008561611175537109375), SC_(69.824954950675200362960955162147776517176019826696), SC_(52.867927614647648258025590068385625191365558659749) }}, 
      {{ SC_(272.01507568359375), SC_(0.814723670482635498046875), SC_(0.905791938304901123046875), SC_(72.982855186913545331380652454483987653281750601456), SC_(50.08923843424186370264772256663907271895697988192) }}, 
      {{ SC_(272.01507568359375), SC_(0.814723670482635498046875), SC_(0.968867778778076171875), SC_(78.183695006696982291565746619212447845869116855387), SC_(45.736749832811447970557694445419286643307911857461) }}, 
      {{ SC_(272.01507568359375), SC_(0.835008561611175537109375), SC_(0.12698681652545928955078125), SC_(44.177738587348597492185295632081119882763555344988), SC_(62.458577106278160523290529921712043695082904324879) }}, 
      {{ SC_(272.01507568359375), SC_(0.835008561611175537109375), SC_(0.135477006435394287109375), SC_(44.476392366774277795103754104395401317214357006499), SC_(62.118285144987383462995105244146148228230086342889) }}, 
      {{ SC_(272.01507568359375), SC_(0.835008561611175537109375), SC_(0.814723670482635498046875), SC_(60.377091401302131366299140420937567125788560470436), SC_(46.02661418142873125689282953102477300265575172496) }}, 
      {{ SC_(272.01507568359375), SC_(0.835008561611175537109375), SC_(0.835008561611175537109375), SC_(61.041927204443486505617423941542288870758355052458), SC_(45.430298472888491006364148499244007010567862887573) }}, 
      {{ SC_(272.01507568359375), SC_(0.835008561611175537109375), SC_(0.905791938304901123046875), SC_(63.956317317172836031691627567406336902394221150367), SC_(42.879669882871641505234380846022342455357840826787) }}, 
      {{ SC_(272.01507568359375), SC_(0.835008561611175537109375), SC_(0.968867778778076171875), SC_(68.759945784170108399452621965412641264173823351731), SC_(38.889942400075882510189082009569162251302936255753) }}, 
      {{ SC_(272.01507568359375), SC_(0.905791938304901123046875), SC_(0.12698681652545928955078125), SC_(21.489496587266890076517016454951601933868240710191), SC_(34.21419151204538642582501073593898455181225393677) }}, 
      {{ SC_(272.01507568359375), SC_(0.905791938304901123046875), SC_(0.135477006435394287109375), SC_(21.693684376277839805051109736192556966243931278661), SC_(33.9738887895006144506312349546109034434543780342) }}, 
      {{ SC_(272.01507568359375), SC_(0.905791938304901123046875), SC_(0.814723670482635498046875), SC_(32.746018517690654246567264816843784711545696390601), SC_(22.755946481269646466611582848763719170337310131891) }}, 
      {{ SC_(272.01507568359375), SC_(0.905791938304901123046875), SC_(0.835008561611175537109375), SC_(33.214512480133603302329410116305283062246842134753), SC_(22.346866227457822973178099650153865406868569125644) }}, 
      {{ SC_(272.01507568359375), SC_(0.905791938304901123046875), SC_(0.905791938304901123046875), SC_(35.273093826701032451443765605959004625391699421517), SC_(20.603814129178545613790080798274981448289703629005) }}, 
      {{ SC_(272.01507568359375), SC_(0.905791938304901123046875), SC_(0.968867778778076171875), SC_(38.682163065413445271801733134293205558716062791966), SC_(17.901424501093686966740632922099917275901391863203) }}, 
      {{ SC_(272.01507568359375), SC_(0.968867778778076171875), SC_(0.12698681652545928955078125), SC_(4.8860982307362946848490148677021209303963709988433), SC_(11.700973803207663097096356923398241331317568902751) }}, 
      {{ SC_(272.01507568359375), SC_(0.968867778778076171875), SC_(0.135477006435394287109375), SC_(4.9887446454577528986006399833823374787746289587588), SC_(11.566258084594318426060043263571263743668198571926) }}, 
      {{ SC_(272.01507568359375), SC_(0.968867778778076171875), SC_(0.814723670482635498046875), SC_(10.880759501342490984683807982974895981350858245686), SC_(5.5273280527774480805413749184523466447940455089765) }}, 
      {{ SC_(272.01507568359375), SC_(0.968867778778076171875), SC_(0.835008561611175537109375), SC_(11.141738049641109754624772567404173364587779651847), SC_(5.3190303970916925333893252428450932703036838979127) }}, 
      {{ SC_(272.01507568359375), SC_(0.968867778778076171875), SC_(0.905791938304901123046875), SC_(12.296689997181380679405006454997551301575272020897), SC_(4.4443542423997783257006693663771333961825154928459) }}, 
      {{ SC_(272.01507568359375), SC_(0.968867778778076171875), SC_(0.968867778778076171875), SC_(14.235964125170580443450965323386985634646137027791), SC_(3.1360623190240134481707711472606441020054701402056) }}
   }};
#undef SC_

