/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.RenamedDataEntry;
import proguard.util.MultiValueMap;

public class ExtraDataEntryWriter
implements DataEntryWriter {
    private final MultiValueMap<String, String> extraEntryNameMap;
    private final Set<String> extraEntryNamesWritten = new HashSet<String>();
    private final DataEntryWriter dataEntryWriter;
    private final DataEntryWriter extraDataEntryWriter;
    private final String entrySuffix;

    public ExtraDataEntryWriter(String string, DataEntryWriter dataEntryWriter) {
        this(string, dataEntryWriter, dataEntryWriter);
    }

    public ExtraDataEntryWriter(String string, DataEntryWriter dataEntryWriter, DataEntryWriter dataEntryWriter2) {
        this(new MultiValueMap<String, String>(), dataEntryWriter, dataEntryWriter2, null);
        this.extraEntryNameMap.put(null, string);
    }

    public ExtraDataEntryWriter(MultiValueMap<String, String> multiValueMap, DataEntryWriter dataEntryWriter, DataEntryWriter dataEntryWriter2, String string) {
        this.extraEntryNameMap = multiValueMap;
        this.dataEntryWriter = dataEntryWriter;
        this.extraDataEntryWriter = dataEntryWriter2;
        this.entrySuffix = string;
    }

    @Override
    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        return this.dataEntryWriter.createDirectory(dataEntry);
    }

    @Override
    public boolean sameOutputStream(DataEntry dataEntry, DataEntry dataEntry2) throws IOException {
        return this.dataEntryWriter.sameOutputStream(dataEntry, dataEntry2);
    }

    @Override
    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        this.writeExtraEntries(dataEntry, null);
        this.writeExtraEntries(dataEntry);
        return this.dataEntryWriter.createOutputStream(dataEntry);
    }

    private void writeExtraEntries(DataEntry dataEntry) throws IOException {
        String string = dataEntry.getName();
        if (this.entrySuffix != null && string.endsWith(this.entrySuffix)) {
            string = string.substring(0, string.length() - this.entrySuffix.length());
        }
        this.writeExtraEntries(dataEntry, string);
    }

    private void writeExtraEntries(DataEntry dataEntry, String string) throws IOException {
        Set<String> set = this.extraEntryNameMap.get(string);
        if (set != null) {
            for (String string2 : set) {
                if (this.extraEntryNamesWritten.contains(string2)) continue;
                String string3 = this.entrySuffix != null ? string2 + this.entrySuffix : string2;
                RenamedDataEntry renamedDataEntry = new RenamedDataEntry(dataEntry, string3);
                this.extraDataEntryWriter.createOutputStream(renamedDataEntry);
                this.extraEntryNamesWritten.add(string2);
                this.writeExtraEntries(renamedDataEntry);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.dataEntryWriter.close();
    }

    @Override
    public void println(PrintWriter printWriter, String string) {
        printWriter.println(string + "ExtraDataEntryWriter");
        this.dataEntryWriter.println(printWriter, string + "  ");
    }
}

