/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.0
 * november 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <stdlib.h>
#include <cstring>
#include "testvdk.h"
#include <vdk/vdk.h>
#include <vdk/vdkfilechooser.h>
#include "vdk/FileDialog.h"
#include "chartcompo.h"
#include "ctreecompo.h"
#include "dnd.h"
#include "sigctest.h"
#include "canvascompo.h"
#include "drawingcompo.h"
#include "combocompo.h"
#include "bookcompo.h"
#include "progcompo.h"
#include "edcompo.h"
#include "treeviewcompo.h"
#include <vdk/vdkhlbutton.h>

static char buff[1024];
extern char * mini_cfolder_xpm[];
/*
  VDK test program
*/
int main (int argc, char *argv[])
{
  // makes application
  TestvdkApp app(&argc, argv);
  // parse resource file
  app.SetResourceFile("testvdkrc");
  // runs application
  app.Run();
  return 0;
}

// Testvdk MAIN FORM  CLASS
/*
defining signal and events
dynamics tables
*/
DEFINE_SIGNAL_LIST(TestvdkForm,VDKForm);
DEFINE_EVENT_LIST(TestvdkForm,VDKForm);
/*
defining signal static table
*/
DEFINE_SIGNAL_MAP(TestvdkForm,VDKForm)
  ON_SIGNAL(quitMenu,activate_signal,OnquitMenuActivate),
  ON_SIGNAL(openMenu,activate_signal,OnopenMenuActivate),
  ON_SIGNAL(filechooser,activate_signal,OnfilechooserActivate),
  ON_SIGNAL(testlist,row_activated_signal,OnTestIt),
  ON_SIGNAL(testlist,click_column_signal,OnTestIt),
  //
  ON_SIGNAL(cbentry,activate_signal,OnComboEntryActivated),
  ON_SIGNAL(cbentry,changed_signal,OnComboEntryChanged),
  ON_SIGNAL(cbentry,focus_in_signal,OnComboEntryFocusIn),
  ON_SIGNAL(cbentry,focus_out_signal,OnComboEntryFocusOut),
  ON_SIGNAL(chbox,toggled_signal,OnCheckBoxToggled)
END_SIGNAL_MAP

/*
this struct array contains
mapping instructions to:
- load test list with <test name>
- static function to be invoked for each test
- source file name to be displayed (if any)
- a VDKObject address (constructed by CreateTest):
    it can be either a container address that
    it will be displayed along with his contained
    widget or a NULL if the test opens a child form.
    Each time <active> member contains the address
    of the current working test container or NULL.
    Current working test is added to test frame.
*/
static int MAX_TEST = 0;

struct
{ 
  char *test_name; // test name
  VDKObject* (*CreateTest)(VDKForm*); // pointer to static creator
  char* source, *member; // source containing test or member name  in testvdk.cc if source is NULL
  VDKObject* widget; // created widget
  bool tested; // tested
} tests[] =  
{    
/*
  test name            creator static function        source/member             widget  tested
*/
  {"Buttons & C.",     TestvdkForm::CreateButtons     ,NULL, "CreateButtons"    ,NULL,  false},
  {"Canvas ",          TestvdkForm::CreateCanvas      ,"canvascompo", NULL      ,NULL,  false},
  {"Combo box ",       TestvdkForm::CreateCombo       ,"combocompo", NULL       ,NULL,  false},
  {"Chart",            TestvdkForm::CreateChart       ,"chartcompo", NULL       ,NULL,  false},
  {"Drag & drop",      TestvdkForm::CreateDnD         ,"dnd", NULL              ,NULL,  false},
  {"DrawingArea ",     TestvdkForm::CreateDrawing     ,"drawingcompo",   NULL      ,NULL,  false},
  {"Image",            TestvdkForm::CreateImage       ,NULL, "CreateImage"      ,NULL,  false},
#ifdef USE_SIGCPLUSPLUS
  {"Libsigc extension",TestvdkForm::CreateSigcTest    ,"sigctest", NULL         ,NULL,  false},
#endif
  {"Notebook",         TestvdkForm::CreateNotebook    ,"bookcompo", NULL        ,NULL,  false},
  {"Progress bar",     TestvdkForm::CreateProgress    ,"progcompo", NULL        ,NULL,  false},
  {"Tree",             TestvdkForm::CreateTree        ,"ctreecompo", NULL       ,NULL,  false},
  {"Scrolled",         TestvdkForm::CreateScrolled    ,NULL, "CreateScrolled"   ,NULL,  false},
  {"Sorted Lists",     TestvdkForm::CreateSortedLists ,NULL,"CreateSortedLists" ,NULL,  false},
  {"TreeView",         TestvdkForm::CreateTreeView    ,"treeviewcompo", NULL    ,NULL,  false},
  {NULL, NULL,NULL,NULL}
};

#ifdef USE_SIGCPLUSPLUS
/*
  creates a child form with libsigc extension test
*/
VDKObject* 
TestvdkForm::CreateSigcTest(VDKForm* owner)
{

  SigctestForm* child = NULL;
  ChildListIterator li(owner->Childs());
  for(;li;li++)
    {
      if((child = dynamic_cast<SigctestForm*>(li.current())) )
	  break;
    }
  if(!child)
    {
      child = new SigctestForm(owner);
      child->Setup();
      child->Show(); 
    }
  else
    child->Raise();
  return NULL;
}
#endif
/*
  creates a child form with a drag & drop example
*/
VDKObject* 
TestvdkForm::CreateDnD(VDKForm* owner)
{
  // iterates on child lists to see if a DnDForm*
  // is already present, in this case raise child
  // instead construct it.
  DndForm* child = NULL;
  ChildListIterator li(owner->Childs());
  for(;li;li++)
    {
      if((child = dynamic_cast<DndForm*>(li.current())) )
	  break;
    }
  if(!child)
    {
      child = new DndForm(owner,NULL);
      child->Setup();
      child->Show(); 
    }
  else
    child->Raise();
  return NULL;
}
/*
  creates a progress bar  component
*/
VDKObject* 
TestvdkForm::CreateProgress(VDKForm* owner)
{
  return new ProgressComponent(owner);
}
/*
  creates a combobox component
*/
VDKObject* 
TestvdkForm::CreateNotebook(VDKForm* owner)
{
  return new NotebookComponent(owner);
}
/*
  creates a combobox component
*/
VDKObject* 
TestvdkForm::CreateCombo(VDKForm* owner)
{
  return new ComboComponent(owner);
}
/*
  creates a custom canvas component
*/
VDKObject* 
TestvdkForm::CreateCanvas(VDKForm* owner)
{
  return new CanvasComponent(owner);
}
/*
  creates a custom drawing area component
*/
VDKObject* 
TestvdkForm::CreateDrawing(VDKForm* owner)
{
  return new DrawingComponent(owner);
}
/*
  creates a custom tree component
*/
VDKObject* 
TestvdkForm::CreateTree(VDKForm* owner)
{
  return new TreeComponent(owner);
}

/*
  creates a treeview component
*/
VDKObject* 
TestvdkForm::CreateTreeView(VDKForm* owner)
{
  return new TreeViewComponent(owner);
}
/*
  creates a chart component
*/
VDKObject* 
TestvdkForm::CreateChart(VDKForm* owner)
{
  return new ChartComponent(owner);
}
/*
  creates a sorted list
 */
#define MAX_COL 5
#define MAX_ADDR 6
#define KEYPOS 0 // key column position
// yet another address program !
typedef struct {
  char *items[MAX_COL];
} ynad;

char *titles[MAX_COL] = 
{ 
"Last name","First name","Address","City","ZIP"
};

ynad address[MAX_ADDR]=
{
  {{"Motta","Mario","via delle fonti 1","Montecolombo","98564"}},
  {{"Guerra","Tonino","via Arcangelo 6","Morciano","34567"}},
  {{"Plum","Adam","Strawberry street 678","Los Angeles","CA4567"}},
  {{"Jim","Uncle","Sky boulevard 34", "Paris", "FR5676"}},
  {{"Adelante", "Speedo","fast plaza", "Madrid","SP98767"}},
  {{"Streisand","Barbara","Star hill 567","Hollywood", "XX5676"}}
}; 

/*
  =========================
  CREATES SORTED LISTS TEST
  =========================
*/
VDKObject* 
TestvdkForm::CreateSortedLists(VDKForm* owner)
{
  VDKBox *box1 = new VDKBox(owner);
  VDKBox *vbox1 = new VDKBox(owner);
  VDKBox *hbox2 = new VDKBox(owner,h_box);
  VDKLabel* label = new VDKLabel(owner,
				 "** Yet another address program **",
				 GTK_JUSTIFY_CENTER);
  label->SetForeground(VDKRgb("navy blue"));
  box1->Add(label,l_justify,false,false);
  box1->Add(new VDKSeparator(owner),l_justify,false,false);
  VDKCustomSortedList* list = new VDKCustomSortedList(owner,KEYPOS,
				 MAX_COL,titles,
				 GTK_SELECTION_EXTENDED);
  list->ActiveTitles(false);
  list->SelectedBackground = VDKRgb("navy blue");
  list->SelectedForeground = VDKRgb("yellow");
  list->NormalBackground = clIvory;
  list->Titles[0]->NormalBackground = VDKRgb(89,186,231);
  // set 4-th column right justified
  gtk_clist_set_column_justification (GTK_CLIST(list->CustomWidget()), 
				      4, GTK_JUSTIFY_RIGHT);
  // load addresses
  int t = 0;   
  for(;t < MAX_ADDR;t++) 
     list->AddRow(address[t].items);

  vbox1->Add(list,l_justify,true,true,5); 
  list->AutoResize = true;
  list->Font = new VDKFont("courier 10");
  box1->Add(vbox1);
  VDKCustomButton* add, *addmany,*del,*reload;
  hbox2->Add(add = new VDKCustomButton(owner,"Add a new address"));
  hbox2->Add(addmany = new VDKCustomButton(owner,"Add 1000 addresses"));
  hbox2->Add(del = new VDKCustomButton(owner,"Delete selected addresses"));
  hbox2->Add(reload = new VDKCustomButton(owner,"Reload addresses"));
  box1->Add(hbox2,l_justify,false,false);
  // downcast to Testvdkform to connect dynamic tables
  // and assign list address to placeholder.
  TestvdkForm* testform = dynamic_cast<TestvdkForm*>(owner);
  if(testform)
    {
      testform->sortedlist_widget = list;
      // here we connect with a vdk internally handled signal so third
      // arg must be false.
      testform->SignalConnect(list,"select_row",
			      &TestvdkForm::OnSortedListSelect,
			      false);
      // here we connect with a gtk+ handled signal so third
      // arg must be true (default).
      testform->SignalConnect(add,"clicked",
			      &TestvdkForm::OnAddClicked);
      testform->SignalConnect(addmany,"clicked",
			      &TestvdkForm::OnAddManyClicked);
      testform->SignalConnect(del,"clicked",
			      &TestvdkForm::OnDelClicked);
      testform->SignalConnect(reload,"clicked",
			      &TestvdkForm::OnReloadClicked);
    }
  return box1;
  
}
/*
  answers on a double click on sorted lists
 */
// on pixmaps.cc
extern char *mini_bball_xpm[];
bool
TestvdkForm::OnSortedListSelect(VDKObject* sender)
{
  // safely downcast here
  VDKCustomSortedList* list = dynamic_cast<VDKCustomSortedList*>(sender);
  if(list)
    {
      int ndx  = list->Selected.Row();
      if(ndx >= 0)
	{
	  if(gtk_clist_get_cell_type(GTK_CLIST(list->CustomWidget()),ndx,0) ==
	     GTK_CELL_PIXTEXT)
	    list->UpdateRow(ndx,list->Tuples[ndx]);
	  else
	    // bug in gtk+-1.3.2 ?
	    // updating with a pixmap sigsegv
	    //	    list->UpdateRow(ndx,list->Tuples[ndx],mini_bball_xpm,0);
	    ;
	}
    }
  return true;
}

bool
TestvdkForm::OnAddClicked(VDKObject* sender)
{
  if(sortedlist_widget)
    {
      ynad addr;
      int t,z;
      char p[10];
      for(t = 0; t < 10;t++)
	p[t] = (char) 64+rand()%26;
      p[t] = '\0';
      z = rand()%MAX_ADDR; 
      addr.items[0] = p; 
      for(t = 1; t <MAX_COL;t++)
	addr.items[t] = address[z].items[t];
      sortedlist_widget->AddKey(addr.items);
    }
  return true;
}

bool
TestvdkForm::OnAddManyClicked(VDKObject* sender)
{
  if(sortedlist_widget)
    {
      sortedlist_widget->Freeze();
      for(int t = 0; t < 1000; t++)
	// we can call a response function also
	// directly.
	OnAddClicked(sender);
      sortedlist_widget->Thaw();
    }
  return true;
}

bool
TestvdkForm::OnDelClicked(VDKObject* sender)
{
  if(sortedlist_widget && (sortedlist_widget->Selections().size() > 0))
    {
      int t;
      // create a string array of deleting keys 
      // StringArray is defined in vdkclist.h
      StringArray array(sortedlist_widget->Selections().size());
      for(t = 0; t < array.size(); t++)
	{
	  int row = sortedlist_widget->Selections()[t];
	  array[t] = sortedlist_widget->
	    Tuples[row][sortedlist_widget->KeyPos()];
	}
      // deletes all key
      sortedlist_widget->Freeze();
      for(t = 0; t < array.size(); t++)
	{
	  printf("\nremoving:(%s)", (char*) array[t]);
	  fflush(stdout);
	  sortedlist_widget->RemoveKey(array[t]);
	}
      sortedlist_widget->Thaw();
    }
  else if (sortedlist_widget && (sortedlist_widget->Selections().size() == 0))
    {
      int row = sortedlist_widget->Selected.Row();
      if(row >= 0)
	sortedlist_widget->RemoveRow(row);
    }
  return true;
}

bool
TestvdkForm::OnReloadClicked(VDKObject* sender)
{
  if(sortedlist_widget)
    {
      int t = 0; 
      sortedlist_widget->Clear();
      for(;t < MAX_ADDR;t++)
	sortedlist_widget->AddRow(address[t].items);
    }
  return true;
}
/*
  =========================
  CREATES IMAGE TEST
  =========================
*/
VDKObject* 
TestvdkForm::CreateImage(VDKForm* owner)
{
  static char *tip = "This will be the new VDKBuilder 2.0 logo";
  VDKBox* vbox = new VDKBox(owner);
  // setting last arg as true embedds pixmap into an event box so
  // will receive appropriate signals and can show tip
  // see below on CreateScrolled()  another way where pixmap is
  // explicitely embedded into an event box
  VDKImage* image = new VDKImage(owner,"vitrurian.png",tip,true);
  vbox->Add(image);
  return vbox;
}
/*
  =========================
  CREATES SCROLLED TEST
  =========================
*/
VDKObject* 
TestvdkForm::CreateScrolled(VDKForm* owner)
{
  static char *tip = 
"Believe it or not, VDK original author \
has flown more than 1500 hours on this airplane";
  VDKFixed* fixed = new VDKFixed(owner);
  VDKScrolled* scrolled = new VDKScrolled(owner);
  scrolled->Usize = VDKPoint(250,200);
  VDKEventBox* vbox = new VDKEventBox(owner);
  VDKPixmap* pixmap = new VDKPixmap(owner,"f104.xpm");
  vbox->SetTip(tip);
  vbox->Add(pixmap);
  scrolled->Add(vbox);
  fixed->Add(scrolled,l_justify,0,0); 
  return fixed;
}
/*
  =========================
  CREATES BUTTONS TEST
  =========================
*/
static char *completion_list[] =
{
  "vdk","vdkbuilder","vdk version 2.0.4","gtk+","gtk+ version 2.0.4",
  "open source model is great","open the door","gnome","gnomify",NULL
};

VDKObject* 
TestvdkForm::CreateButtons(VDKForm* owner)
{
  int t = 0;
  VDKTable* table = new VDKTable(owner,7,2,true);
  // attaches 9 buttons
  VDKObject* buttons[] = { NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL };
  buttons[0] = new VDKCustomButton(owner,"A _labeled button");
  buttons[0]->Font = new VDKFont(owner,"courier bold 12"); 
  buttons[0]->NormalBackground = clAirBlue;
  buttons[0]->Foreground = clYellow;
  buttons[1] = new VDKCustomButton(owner,"loadfile.xpm",
				   "A pixmapped _button");
  buttons[1]->Foreground = VDKRgb("sienna");
  buttons[2] = new VDKCustomButton(owner,
				   "A labeled button");

  buttons[3] = new VDKCustomButton(owner,
				   "A labeled toggle button",
				   VDK_CBUTTON_TOGGLED);
  buttons[3]->Font = new VDKFont(owner,"sans bold 10");
  buttons[3]->NormalBackground = VDKRgb("forest green");
  buttons[3]->Foreground = clWhite;

  buttons[4] = new VDKCustomButton(owner,"loadfile.xpm",
				   "A pixmapped button");

  buttons[5] = new VDKCustomButton(owner,"loadfile.xpm",
				   "A pixmapped toggle button",
				   VDK_CBUTTON_TOGGLED);
  buttons[6] = new VDKSpinButton(owner,6.5,0,20,.5,0);
  buttons[6]->NormalBackground = VDKRgb("lemon chiffon");
  buttons[6]->Foreground = clSiena;
  buttons[6]->Font = new VDKFont(owner,"helvetica bold 10");
  buttons[6]->SetTip("A spin button");

  buttons[7] = new VDKCheckButton(owner,"A check button");
  buttons[7]->Font = new VDKFont(owner,"helvetica bold 10");
  buttons[7]->ActiveBackground = VDKRgb("sienna");
  buttons[7]->Foreground = "white";

  buttons[8] = new VDKHLButton(owner,"stop.png","An highlighted button");
  buttons[8]->SetTip("Highlights when mouse is over, grayed on click");

  for(t = 0; buttons[t];t++)
    table->AddToCell(buttons[t],t/2,t%2,!GTK_FILL | !GTK_EXPAND,5);
  //
  VDKEntry* entry = new VDKEntry(owner);
  entry->NormalBackground = VDKRgb("lemon chiffon");
  entry->SetCompletion(completion_list);
  entry->AddCompletionItem("vdk porting to win is ready");
  table->AddToCell(entry,4,1,!GTK_FILL | !GTK_EXPAND,5);
  entry->SetTip("completion enabled, try: vdk,gtk or open");

  VDKRadioButtonGroup *rbg = new VDKRadioButtonGroup(owner);
  VDKRadioButton* rb = new VDKRadioButton(rbg,"A radio button");

  rb->SetTip("radio button group shows an exclusive-or behaviour");
  rb = new VDKRadioButton(rbg,"Another radio button");
  rb->SetTip("radio button group shows an exclusive-or behaviour");
  rb->Foreground = clBlue;
  table->AddToCell(rbg,5,0,!GTK_FILL | !GTK_EXPAND,5);
  VDKBox* abox = new VDKBox(owner);
  VDKCheckButton* bt = new VDKCheckButton(owner,"A check button");
  abox->Add(bt);
  rb = new VDKRadioButton(owner,"A stand-alone radio button");
  abox->Add(rb);
  table->AddToCell(abox,5,1,!GTK_FILL | !GTK_EXPAND,5);

  abox = new VDKBox(owner);
  VDKLabel* label = new VDKLabel(owner,"A VDKComboEntry widget");
  abox->Add(label);
  table->AddToCell(abox,6,0,!GTK_FILL | !GTK_EXPAND,5);

  TestvdkForm* form = dynamic_cast<TestvdkForm*>(owner);
  if(form)
    {
      form->chbox = new VDKCheckButton(owner,"Sorted");
      abox->Add(form->chbox);
      StringList list;
      for(int t = 0; completion_list[t];t++)
	list.add(completion_list[t]);
      form->cbentry = new VDKComboEntry(form/*,completion_list*/);
      //      form->cbentry->Font = new VDKFont(owner,"sans bold 10"); 
      form->cbentry->Selections = &list;
      // form->cbentry->Editable = false;
      form->cbentry->Selected = 0;
      form->cbentry->NormalBackground = VDKRgb("skyblue2");
      form->cbentry->Foreground = VDKRgb("navy blue");
      form->cbentry->SetTip("Hit \"Enter\" and text will added to\ndropdown list (if not already in)");
      gtk_widget_set_name (form->cbentry->Widget(), "list-combo");      
      table->AddToCell(form->cbentry,6,1,!GTK_FILL | !GTK_EXPAND,5);

    }
  return table;
}


bool 
TestvdkForm::OnCheckBoxToggled(VDKObject* sender)
{
  static StringList *unsorted = NULL;
  //GtkListStore* store = cbentry->StoreModel;
  // store unsorted dropdown list for later use
  if(!unsorted)
    unsorted = cbentry->Selections;
  if(chbox->Checked)
    {
      // cbentry->SortingOrder = GTK_SORT_DESCENDING;
      cbentry->Sorted = true;
    }
  else
    /*
      since once sorted cannot revert to previous state
      we substitute store model with a new unsorted one
     */
    {
      cbentry->Sorted = false;
      GtkListStore* store = gtk_list_store_new (1, G_TYPE_STRING);
      cbentry->StoreModel = store;
      cbentry->Selections = unsorted;
    }
  cbentry->Selected = 0;
  return true;
} 

bool
TestvdkForm::OnComboEntryActivated(VDKObject* sender)
{
  GtkTreeIter iter;
  gchar *item = NULL;  
  bool add_flag = true;
  char* text = (char*) cbentry->Text;
  printf("\nVDKComboEntry activated - text:%s",text);
  fflush(stdout);  
  // gets underlying store list
  GtkListStore* store = cbentry->StoreModel;
  for(bool flag = gtk_tree_model_get_iter_first(GTK_TREE_MODEL(store),&iter);
      flag; flag = gtk_tree_model_iter_next(GTK_TREE_MODEL(store),&iter))
    {
      gtk_tree_model_get (GTK_TREE_MODEL(store), &iter, 0, &item, -1);
      if(!strcmp(item,text))
	{
	  add_flag = false;
	  break;
	}
    }
  // add entry text if not unique in dropdown list
  if(add_flag)
    {
      gtk_list_store_append (store, &iter);
      gtk_list_store_set (store, &iter, 0, text, -1);
      printf("\nVDKComboEntry added:%s to dropdown list",text);
      fflush(stdout);
    }
  delete[] text;
  return true;
}

bool
TestvdkForm::OnComboEntryChanged(VDKObject* sender)
{
  VDKComboEntry* cbentry = dynamic_cast<VDKComboEntry*>(sender);
  if(cbentry)
    {
      char* selected = (char*) cbentry->Text;
      int index = cbentry->Selected;
      printf("\nVDKComboEntry - index: %d - text:%s",index , selected);
      fflush(stdout);
      delete[] selected;
    }
  return true;
}
bool
TestvdkForm::OnComboEntryFocusIn(VDKObject* sender)
{
  /*
  printf("\nVDKComboEntry <%p> get focus !",sender);
  fflush(stdout);
  */
  return true;
}
bool
TestvdkForm::OnComboEntryFocusOut(VDKObject* sender)
{
  /*
  printf("\nVDKComboEntry <%p> lost focus !",sender);
  fflush(stdout);
  */
  return true;
}
////////////////////////////////////////////////////////////////////

/*
  main form constructor
*/
TestvdkForm::TestvdkForm(VDKApplication* app, char* title):
  VDKForm(app,title)
{
  active = NULL;
  // set placeholder to null
  sortedlist_widget = NULL;
}
/*
  main form destructor
*/
TestvdkForm::~TestvdkForm()
{
}

/*
  main form gui setup
*/

static char* introduction =
"<span foreground=\"sienna\" font_desc=\"times bold 12\">"
"VDK \"The Visual Development Kit\"\nversion %d.%d.%d"
"</span>"
"<span font_desc=\"helvetica bold 10\">"
"\nA LGPL'd C++ framework based on\nglib %d.%d.%d - gtk+ %d.%d.%d\n"
"\n"
"<b><span foreground=\"sienna\">"
"Original author:"
"</span></b>"
" Mario Motta\n"
"<b><span foreground=\"sienna\">"
"VDK team:\n"
"</span></b>"
"<span foreground=\"navy blue\" font_desc=\"times bold 10\">"
"\t<i>Mario Motta"
"\tIonutz Borcoman"
"\tTim Lorenz\n"
"\tGeorge Boutwell"
"\tPierre-Louis"
"\tMile Lazarovski</i>"
"</span></span>";

void
TestvdkForm::GUISetup(void)
{
  int t = 0;
  SetDefaultSize(VDKPoint(650,450));
  Title = "VDK 2.0.x Test";
  if(!GTK_WIDGET_REALIZED(Window()))
     gtk_widget_realize(Window());
  hbox2 = new VDKBox(this,h_box);
  Add(hbox2,2,1,1,0);
  hbox2->BorderWidth(5);
  /*
    makes a new scrolled to be filled with list
  */
  VDKScrolled *scrolled = new VDKScrolled(Owner());
  testlist = new VDKTreeView(this,NULL,GTK_SELECTION_SINGLE);
  // makes model
  VDKTreeViewModel* model;
  GType* types = new GType[2];
  types[0] = G_TYPE_STRING;
  types[1] = G_TYPE_BOOLEAN;
  testlist->Model = (model = new VDKTreeViewModel(types,2));
  delete types;
  //    add columns to tree
  VDKTreeViewColumn* column = NULL;
  column = new VDKTreeViewColumn(testlist,0,"Test it");
  column = new VDKTreeViewColumn(testlist,1,"Passed");
  gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column->GtkColumn()),
				 GTK_TREE_VIEW_COLUMN_FIXED);
  gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column->GtkColumn()),30);
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW(testlist->WrappedWidget()), TRUE);
  // load test list model
  for(t=0; tests[t].test_name;t++)
    {
      GtkTreeIter iter;
      model->AppendBlank(&iter);
      model->SetCell(&iter,0,tests[t].test_name);
      model->SetCell(&iter,1,tests[t].tested ? "true" : "false");
    }
  (*testlist->Columns())[0]->ActiveTitle(tests[0].CreateTest != NULL);
  // stores max test numbers
  MAX_TEST = t;
  // select first row
  GtkTreeIter iter;
  if(model->Root(&iter))
    testlist->SelectNode(&iter);
  scrolled->Add(testlist,l_justify,false,false,0);
  hbox2->Add(scrolled);

  testframe = new VDKFrame(this,NULL,v_box,shadow_etched_in);
  testframe->Shadow = shadow_etched_in;
  testframe->Align = c_justify;
  testframe->SetSize(410,380);
  // We desire a white background for vdk
  // introduction label. Labels are transparent widgets
  // that do not have a window assigned, they use their
  // container context to draw themselves, so we
  // add the label to an event box and set the
  // box background to white.
  eventbox = new VDKEventBox(this);
  eventbox->NormalBackground = clWhite;
  // adding a pixmap to eventbox
  VDKPixmap* logo = new VDKPixmap(this,"vdklogo.xpm");
  logo->NormalBackground = clWhite;
  eventbox->Add(logo,l_justify,false,false,5);
  testframe->Add(eventbox);
  // setting label
  sprintf(buff,introduction,
	  VDK_VERSION_MAJOR,
	  VDK_VERSION_MINOR,
	  VDK_REVISION,
  	  glib_major_version,
  	  glib_minor_version,
  	  glib_micro_version,
  	  gtk_major_version,
  	  gtk_minor_version,
  	  gtk_micro_version);
  // since we will use mark translation
  // get an empty label at first
  introduce_vdk = new VDKLabel(this,NULL);
  // mark up label string
  gtk_label_set_markup(GTK_LABEL(introduce_vdk->WrappedWidget()),
		       buff);
  eventbox->Add(introduce_vdk,l_justify,false,false,5);
  testframe->BorderWidth(5);
  // initial contents of testframe finished
  hbox2->Add(testframe,0,1,1,0);
  // sets main menu bar
  menubar = new VDKMenubar(this);
  Add(menubar,0,0,0,0);
  MenuItem0 = new VDKMenuItem(this,"MenuItem0",mini_cfolder_xpm);
  MenuItem0->Caption = "_File...";
  MenuItem0->Checked = false;
  MenuItem0->SetSize(59,26);
  menubar->Add(MenuItem0,l_justify,1,1,0);
  Menu0 = new VDKMenu(this);
  MenuItem0->Add(Menu0);
  openMenu = new VDKMenuItem(this,"openMenu",NULL);
  VDKRawPixmap *openMenu_pix = new VDKRawPixmap(this,"loadfile.xpm");
  openMenu->SetPixmap(openMenu_pix);
  openMenu->Caption = "_View sources";
  openMenu->SetSize(98,25);
  Menu0->Add(openMenu,l_justify,1,1,0);
  filechooser = new VDKMenuItem(this,"filechooser",NULL);
  filechooser->Caption = "File  _Chooser";
  Menu0->Add(filechooser,l_justify,1,1,0);
  Menu0->Separator();
  quitMenu = new VDKMenuItem(this,"quitMenu",NULL);
  quitMenu->Caption = "_Quit";
  Menu0->Add(quitMenu,l_justify,1,1,0);
}
/*
  main form setup
*/
void
TestvdkForm::Setup(void)
{
  GUISetup();
}
/*
 */
bool
TestvdkForm::CanClose(void)
{
  bool result =  Application()->VDKMessageBox(
					   "VDK \"The Visual Development Kit\"",
					   "Really do you want quit VDK test program ?",
					   VDK_ICONQUESTION | VDK_YESNO,NULL,NULL,5000) == VDK_IDYES;
  return result;

}
// Testvdk APPLICATION  CLASS
/*
  application constructor
*/
TestvdkApp::TestvdkApp(int* argc, char** argv):
  VDKApplication(argc,argv)
{
  
}

/*
  application destructor
*/
TestvdkApp::~TestvdkApp()
{ 
  
}

/*
  application setup
*/

void
TestvdkApp::Setup(void)
{
  SetGarbageCollection(2000);
  MainForm = new TestvdkForm(this,NULL);
  MainForm->Setup();
  MainForm->Visible = true;
}

/*
  RESPONSE METHODS
*/

/*
  answers to view sources menu  menu activation
*/
bool
TestvdkForm::OnfilechooserActivate(VDKObject* sender)
{
  FileStringArray selections;
  VDKFileChooser* fc = new VDKFileChooser(this, &selections,"Apri files");
  fc->MultiSelection = true;
  fc->AddFilterPattern("All files","*");
  fc->AddFilterPattern("C sources","*.c");
  fc->AddFilterPattern("CC sources","*.cc");
  fc->AddFilterPattern("C/CC headers","*.h");
  fc->AddMimeType("images PNG","image/png");
  fc->SetDefaultFilter("All files");
  fc->Action = GTK_FILE_CHOOSER_ACTION_OPEN;
  fc->ShowModal();
  if(selections.size() == 1)
    {
    printf("\nSelected:%s",(char*) selections[0]);
    fflush(stdout);
    }
  else if(selections.size() > 1)
    {
      for(int t = 0; t < selections.size(); t++)
	    printf("\nSelected:%s",(char*) selections[t]);
      fflush(stdout);
    }
   return true;
}
/*
  answers to view sources menu  menu activation
*/
bool
TestvdkForm::OnopenMenuActivate(VDKObject* sender)
{
  EditorComponent *editor = NULL;
  // tests if editor is already running
  if(active)
      editor = dynamic_cast<EditorComponent*>(active);
  // construct a new one id <editor> is still NULL
  if(!editor)
    {
      // remove introduction event box if any
      if(eventbox->Visible)
	eventbox->Visible = false;
      // remove active widget if any
      if(active)
	testframe->RemoveObject(active);
      // makes a new editor component
      editor = new EditorComponent(this);
      active = editor;
      testframe->Add(editor,l_justify,true,true,0);
    }
  // check whether there is a test list activation or not
  testlist->GetSelections();
  if(testlist->Selections().size() == 1)
    {
      VDKTreeViewModel *model = testlist->Model;
      // get test name
      char* local = model->GetCell(&testlist->Selections()[0],0);
      // finds index into tests[] struct array
      int ndx = 0;
      for(;tests[ndx].test_name;ndx++)
	if(!strcmp(local,tests[ndx].test_name))
	  break;
      //
      if(tests[ndx].test_name)
	{
	  // checks if selected test has a source file available
	  if(tests[ndx].source)
	    {
	      sprintf(buff,"%s.cc",tests[ndx].source);
	      editor->AddPage(buff);
	    }
	  else
	    // open testvdk.cc as default
	    // scrolling to member
	    {
	      editor->AddPage("testvdk.cc", tests[ndx].member);
	    } 
	}
      else
	// open testvdk.cc as default
	editor->AddPage("testvdk.cc");
    }
   return true;
}
 
/*
  answers to quit menu activation
*/
bool
TestvdkForm::OnquitMenuActivate(VDKObject* sender)
{
  Close();
  return true; 
}
/*
  answers to a click on test list widget title
*/
bool
TestvdkForm::OnTestIt(VDKObject* sender)
{
  VDKTreeViewModel *model = testlist->Model;
  testlist->GetSelections();
  if(testlist->Selections().size() == 1)
    {
      // get test name
      char* local = model->GetCell(&testlist->Selections()[0],0);
      // finds index into tests[] struct array
      int ndx = 0;
      for(;tests[ndx].test_name;ndx++)
	if(!strcmp(local,tests[ndx].test_name))
	  break;
      //
      if(tests[ndx].test_name)
	{
	  // remove child widget if any 
	  if(active)
	    {
	      testframe->RemoveObject(active);
	      active = NULL;
	    }
	  // makes new widget and stores address on active
	  // active will be NULL if widget is a form.
	  if(ndx >= 0)
	    {
	      // toggles check box column
	      model->SetData(&testlist->Selections()[0], 1,true, -1);
	      active = tests[ndx].widget = tests[ndx].CreateTest(this);
	    }
	  // hides/shows introduction label hiding his container
	  eventbox->Visible =  active ? false : true;
	  // add it to test frame
	  if(active)
	      testframe->Add(active);
	}
    }
  return true;
}

void 
TestvdkForm::OnResize(VDKForm* form, VDKPoint& s)
{
  // printf("\nOnResize() - %d,%d",s.x,s.y);
  // fflush(stdout);
}
