/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-get.
 *
 *   Swac-get is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-get is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Foobar; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef _SWAC_INDEX_H
#define _SWAC_INDEX_H

#include "swac_db.hh"
#include <libxml/parser.h>

struct Tswac_index : virtual Tswac_db {
private:
	tconsts consts;
	tgroups groups;
	std::string filename;
	std::string packages_idx;
	xmlParserCtxtPtr parser_ctxt;
	bool finished;

	void show_consts();
	void group_push(char const **attr);
	void group_pop();
	void groups_clear();
	void insert(char const **attr);
	bool read_stream_bz2(FILE *f, std::string src_url);

	friend void element_start(void *user_data, xmlChar const *name, xmlChar const **attrs);
	friend void element_end(void *user_data, xmlChar const *name);
	friend void print_location(Tswac_index* index);

public:
	bool read_file(int idx, std::string const filename);
	bool read_url(int idx, std::string const url);
};

#endif

