
#include <inttypes.h>

//number of fields
/* SL42, SL45 and probably SL45i use version 2
 * ME45 and S45 and version 2 or 3
 */
#define FILE_VERSION_2 19
#define FILE_VERSION_3 20

/* S55 uses version 7
 */
#define FILE_VERSION_7 28

/* SL55 uses version 8
 */
#define FILE_VERSION_8 29

uint16_t known_fsizes[] = {
  FILE_VERSION_2,
  FILE_VERSION_3,
  FILE_VERSION_7,
  FILE_VERSION_8,
  0 //last entry
};

enum field_spec_type {
  FTYPE_INT_8BIT = 0x0,
  FTYPE_SEMIOCTET = 0x1,
  FTYPE_STRING_8BIT = 0x2,
  FTYPE_STRING_16BIT = 0x3,
  FTYPE_INT_16BIT = 0x4,
  FTYPE_DATE = 0x5
};

struct field_spec {
  uint16_t size;
  enum field_spec_type type;
};
