package ram

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAccessKey invokes the ram.UpdateAccessKey API synchronously
// api document: https://help.aliyun.com/api/ram/updateaccesskey.html
func (client *Client) UpdateAccessKey(request *UpdateAccessKeyRequest) (response *UpdateAccessKeyResponse, err error) {
	response = CreateUpdateAccessKeyResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAccessKeyWithChan invokes the ram.UpdateAccessKey API asynchronously
// api document: https://help.aliyun.com/api/ram/updateaccesskey.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateAccessKeyWithChan(request *UpdateAccessKeyRequest) (<-chan *UpdateAccessKeyResponse, <-chan error) {
	responseChan := make(chan *UpdateAccessKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAccessKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAccessKeyWithCallback invokes the ram.UpdateAccessKey API asynchronously
// api document: https://help.aliyun.com/api/ram/updateaccesskey.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateAccessKeyWithCallback(request *UpdateAccessKeyRequest, callback func(response *UpdateAccessKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAccessKeyResponse
		var err error
		defer close(result)
		response, err = client.UpdateAccessKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAccessKeyRequest is the request struct for api UpdateAccessKey
type UpdateAccessKeyRequest struct {
	*requests.RpcRequest
	UserAccessKeyId string `position:"Query" name:"UserAccessKeyId"`
	UserName        string `position:"Query" name:"UserName"`
	Status          string `position:"Query" name:"Status"`
}

// UpdateAccessKeyResponse is the response struct for api UpdateAccessKey
type UpdateAccessKeyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateAccessKeyRequest creates a request to invoke UpdateAccessKey API
func CreateUpdateAccessKeyRequest() (request *UpdateAccessKeyRequest) {
	request = &UpdateAccessKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ram", "2015-05-01", "UpdateAccessKey", "ram", "openAPI")
	return
}

// CreateUpdateAccessKeyResponse creates a response to parse from UpdateAccessKey response
func CreateUpdateAccessKeyResponse() (response *UpdateAccessKeyResponse) {
	response = &UpdateAccessKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
